#include "ocvrs_common.hpp"
#include <opencv2/highgui.hpp>
#include "highgui_types.hpp"

extern "C" {
	// addText(const cv::Mat &, const cv::String &, cv::Point, const cv::QtFont &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:763
	Result_void cv_addText_const_MatR_const_StringR_Point_const_QtFontR(const cv::Mat* img, const char* text, cv::Point* org, const cv::QtFont* font) {
		try {
			cv::addText(*img, std::string(text), *org, *font);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addText(const cv::Mat &, const cv::String &, cv::Point, const cv::String &, int, cv::Scalar, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:779
	Result_void cv_addText_const_MatR_const_StringR_Point_const_StringR_int_Scalar_int_int_int(const cv::Mat* img, const char* text, cv::Point* org, const char* nameFont, int pointSize, cv::Scalar* color, int weight, int style, int spacing) {
		try {
			cv::addText(*img, std::string(text), *org, std::string(nameFont), pointSize, *color, weight, style, spacing);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createButton(const cv::String &, cv::ButtonCallback, void *, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:858
	Result<int> cv_createButton_const_StringR_ButtonCallback_voidX_int_bool(const char* bar_name, cv::ButtonCallback on_change, void* userdata, int type, bool initial_button_state) {
		try {
			int ret = cv::createButton(std::string(bar_name), on_change, userdata, type, initial_button_state);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// createTrackbar(const cv::String &, const cv::String &, int *, int, cv::TrackbarCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:579
	Result<int> cv_createTrackbar_const_StringR_const_StringR_intX_int_TrackbarCallback_voidX(const char* trackbarname, const char* winname, int* value, int count, cv::TrackbarCallback onChange, void* userdata) {
		try {
			int ret = cv::createTrackbar(std::string(trackbarname), std::string(winname), value, count, onChange, userdata);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// destroyAllWindows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:332
	Result_void cv_destroyAllWindows() {
		try {
			cv::destroyAllWindows();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// destroyWindow(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:326
	Result_void cv_destroyWindow_const_StringR(const char* winname) {
		try {
			cv::destroyWindow(std::string(winname));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// displayOverlay(const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:794
	Result_void cv_displayOverlay_const_StringR_const_StringR_int(const char* winname, const char* text, int delayms) {
		try {
			cv::displayOverlay(std::string(winname), std::string(text), delayms);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// displayStatusBar(const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:808
	Result_void cv_displayStatusBar_const_StringR_const_StringR_int(const char* winname, const char* text, int delayms) {
		try {
			cv::displayStatusBar(std::string(winname), std::string(text), delayms);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fontQt(const cv::String &, int, cv::Scalar, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:749
	Result<cv::QtFont*> cv_fontQt_const_StringR_int_Scalar_int_int_int(const char* nameFont, int pointSize, cv::Scalar* color, int weight, int style, int spacing) {
		try {
			cv::QtFont ret = cv::fontQt(std::string(nameFont), pointSize, *color, weight, style, spacing);
			return Ok(new cv::QtFont(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::QtFont*>))
	}
	
	// getMouseWheelDelta(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:511
	Result<int> cv_getMouseWheelDelta_int(int flags) {
		try {
			int ret = cv::getMouseWheelDelta(flags);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getTrackbarPos(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:596
	Result<int> cv_getTrackbarPos_const_StringR_const_StringR(const char* trackbarname, const char* winname) {
		try {
			int ret = cv::getTrackbarPos(std::string(trackbarname), std::string(winname));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getWindowImageRect(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:480
	Result<cv::Rect> cv_getWindowImageRect_const_StringR(const char* winname) {
		try {
			cv::Rect ret = cv::getWindowImageRect(std::string(winname));
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// getWindowProperty(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:470
	Result<double> cv_getWindowProperty_const_StringR_int(const char* winname, int prop_id) {
		try {
			double ret = cv::getWindowProperty(std::string(winname), prop_id);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// imshow(const cv::String &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:416
	Result_void cv_imshow_const_StringR_const__InputArrayR(const char* winname, const cv::_InputArray* mat) {
		try {
			cv::imshow(std::string(winname), *mat);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// loadWindowParameters(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:826
	Result_void cv_loadWindowParameters_const_StringR(const char* windowName) {
		try {
			cv::loadWindowParameters(std::string(windowName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// moveWindow(const cv::String &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:443
	Result_void cv_moveWindow_const_StringR_int_int(const char* winname, int x, int y) {
		try {
			cv::moveWindow(std::string(winname), x, y);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// namedWindow(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:318
	Result_void cv_namedWindow_const_StringR_int(const char* winname, int flags) {
		try {
			cv::namedWindow(std::string(winname), flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pollKey() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:377
	Result<int> cv_pollKey() {
		try {
			int ret = cv::pollKey();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// resizeWindow(const cv::String &, const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:435
	Result_void cv_resizeWindow_const_StringR_const_SizeR(const char* winname, const cv::Size* size) {
		try {
			cv::resizeWindow(std::string(winname), *size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resizeWindow(const cv::String &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:429
	Result_void cv_resizeWindow_const_StringR_int_int(const char* winname, int width, int height) {
		try {
			cv::resizeWindow(std::string(winname), width, height);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// saveWindowParameters(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:817
	Result_void cv_saveWindowParameters_const_StringR(const char* windowName) {
		try {
			cv::saveWindowParameters(std::string(windowName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// selectROI(const cv::String &, cv::InputArray, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:528
	Result<cv::Rect> cv_selectROI_const_StringR_const__InputArrayR_bool_bool(const char* windowName, const cv::_InputArray* img, bool showCrosshair, bool fromCenter) {
		try {
			cv::Rect ret = cv::selectROI(std::string(windowName), *img, showCrosshair, fromCenter);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// selectROI(cv::InputArray, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:532
	Result<cv::Rect> cv_selectROI_const__InputArrayR_bool_bool(const cv::_InputArray* img, bool showCrosshair, bool fromCenter) {
		try {
			cv::Rect ret = cv::selectROI(*img, showCrosshair, fromCenter);
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// selectROIs(const cv::String &, cv::InputArray, std::vector<Rect> &, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:550
	Result_void cv_selectROIs_const_StringR_const__InputArrayR_vector_Rect_R_bool_bool(const char* windowName, const cv::_InputArray* img, std::vector<cv::Rect>* boundingBoxes, bool showCrosshair, bool fromCenter) {
		try {
			cv::selectROIs(std::string(windowName), *img, *boundingBoxes, showCrosshair, fromCenter);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMouseCallback(const cv::String &, cv::MouseCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:491
	Result_void cv_setMouseCallback_const_StringR_MouseCallback_voidX(const char* winname, cv::MouseCallback onMouse, void* userdata) {
		try {
			cv::setMouseCallback(std::string(winname), onMouse, userdata);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setOpenGlContext(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:699
	Result_void cv_setOpenGlContext_const_StringR(const char* winname) {
		try {
			cv::setOpenGlContext(std::string(winname));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setOpenGlDrawCallback(const cv::String &, cv::OpenGlDrawCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:693
	Result_void cv_setOpenGlDrawCallback_const_StringR_OpenGlDrawCallback_voidX(const char* winname, cv::OpenGlDrawCallback onOpenGlDraw, void* userdata) {
		try {
			cv::setOpenGlDrawCallback(std::string(winname), onOpenGlDraw, userdata);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTrackbarMax(const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:626
	Result_void cv_setTrackbarMax_const_StringR_const_StringR_int(const char* trackbarname, const char* winname, int maxval) {
		try {
			cv::setTrackbarMax(std::string(trackbarname), std::string(winname), maxval);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTrackbarMin(const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:641
	Result_void cv_setTrackbarMin_const_StringR_const_StringR_int(const char* trackbarname, const char* winname, int minval) {
		try {
			cv::setTrackbarMin(std::string(trackbarname), std::string(winname), minval);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTrackbarPos(const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:611
	Result_void cv_setTrackbarPos_const_StringR_const_StringR_int(const char* trackbarname, const char* winname, int pos) {
		try {
			cv::setTrackbarPos(std::string(trackbarname), std::string(winname), pos);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWindowProperty(const cv::String &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:453
	Result_void cv_setWindowProperty_const_StringR_int_double(const char* winname, int prop_id, double prop_value) {
		try {
			cv::setWindowProperty(std::string(winname), prop_id, prop_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setWindowTitle(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:459
	Result_void cv_setWindowTitle_const_StringR_const_StringR(const char* winname, const char* title) {
		try {
			cv::setWindowTitle(std::string(winname), std::string(title));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// startLoop(int (*)(int, char **), int, char **) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:828
	Result<int> cv_startLoop_int__X__int__charXX__int_charXX(int (*pt2Func)(int, char**), int argc, char** argv) {
		try {
			int ret = cv::startLoop(pt2Func, argc, argv);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// startWindowThread() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:334
	Result<int> cv_startWindowThread() {
		try {
			int ret = cv::startWindowThread();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// stopLoop() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:830
	Result_void cv_stopLoop() {
		try {
			cv::stopLoop();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updateWindow(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:705
	Result_void cv_updateWindow_const_StringR(const char* winname) {
		try {
			cv::updateWindow(std::string(winname));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// waitKeyEx(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:343
	Result<int> cv_waitKeyEx_int(int delay) {
		try {
			int ret = cv::waitKeyEx(delay);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// waitKey(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:363
	Result<int> cv_waitKey_int(int delay) {
		try {
			int ret = cv::waitKey(delay);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nameFont /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:716
	void* cv_QtFont_getPropNameFont_const(const cv::QtFont* instance) {
		const char* ret = instance->nameFont;
		return ocvrs_create_string(ret);
	}
	
	// color /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:717
	cv::Scalar cv_QtFont_getPropColor_const(const cv::QtFont* instance) {
		cv::Scalar ret = instance->color;
		return (cv::Scalar)ret;
	}
	
	// color /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:717
	void cv_QtFont_setPropColor_Scalar(cv::QtFont* instance, cv::Scalar* val) {
		instance->color = *val;
	}
	
	// font_face /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:718
	int cv_QtFont_getPropFont_face_const(const cv::QtFont* instance) {
		int ret = instance->font_face;
		return (int)ret;
	}
	
	// font_face /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:718
	void cv_QtFont_setPropFont_face_int(cv::QtFont* instance, int val) {
		instance->font_face = val;
	}
	
	// ascii /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:719
	const int* cv_QtFont_getPropAscii_const(const cv::QtFont* instance) {
		const int* ret = instance->ascii;
		return (const int*)ret;
	}
	
	// greek /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:720
	const int* cv_QtFont_getPropGreek_const(const cv::QtFont* instance) {
		const int* ret = instance->greek;
		return (const int*)ret;
	}
	
	// cyrillic /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:721
	const int* cv_QtFont_getPropCyrillic_const(const cv::QtFont* instance) {
		const int* ret = instance->cyrillic;
		return (const int*)ret;
	}
	
	// hscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:722
	float cv_QtFont_getPropHscale_const(const cv::QtFont* instance) {
		float ret = instance->hscale;
		return (float)ret;
	}
	
	// hscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:722
	void cv_QtFont_setPropHscale_float(cv::QtFont* instance, float val) {
		instance->hscale = val;
	}
	
	// vscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:722
	float cv_QtFont_getPropVscale_const(const cv::QtFont* instance) {
		float ret = instance->vscale;
		return (float)ret;
	}
	
	// vscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:722
	void cv_QtFont_setPropVscale_float(cv::QtFont* instance, float val) {
		instance->vscale = val;
	}
	
	// shear /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:723
	float cv_QtFont_getPropShear_const(const cv::QtFont* instance) {
		float ret = instance->shear;
		return (float)ret;
	}
	
	// shear /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:723
	void cv_QtFont_setPropShear_float(cv::QtFont* instance, float val) {
		instance->shear = val;
	}
	
	// thickness /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:724
	int cv_QtFont_getPropThickness_const(const cv::QtFont* instance) {
		int ret = instance->thickness;
		return (int)ret;
	}
	
	// thickness /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:724
	void cv_QtFont_setPropThickness_int(cv::QtFont* instance, int val) {
		instance->thickness = val;
	}
	
	// dx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:725
	float cv_QtFont_getPropDx_const(const cv::QtFont* instance) {
		float ret = instance->dx;
		return (float)ret;
	}
	
	// dx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:725
	void cv_QtFont_setPropDx_float(cv::QtFont* instance, float val) {
		instance->dx = val;
	}
	
	// line_type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:726
	int cv_QtFont_getPropLine_type_const(const cv::QtFont* instance) {
		int ret = instance->line_type;
		return (int)ret;
	}
	
	// line_type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/highgui.hpp:726
	void cv_QtFont_setPropLine_type_int(cv::QtFont* instance, int val) {
		instance->line_type = val;
	}
	
	void cv_QtFont_delete(cv::QtFont* instance) {
		delete instance;
	}
}
