#include "ocvrs_common.hpp"
#include <opencv2/hfs.hpp>
#include "hfs_types.hpp"

extern "C" {
	// setSegEgbThresholdI(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:54
	Result_void cv_hfs_HfsSegment_setSegEgbThresholdI_float(cv::hfs::HfsSegment* instance, float c) {
		try {
			instance->setSegEgbThresholdI(c);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSegEgbThresholdI() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:55
	Result<float> cv_hfs_HfsSegment_getSegEgbThresholdI(cv::hfs::HfsSegment* instance) {
		try {
			float ret = instance->getSegEgbThresholdI();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMinRegionSizeI(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:63
	Result_void cv_hfs_HfsSegment_setMinRegionSizeI_int(cv::hfs::HfsSegment* instance, int n) {
		try {
			instance->setMinRegionSizeI(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinRegionSizeI() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:64
	Result<int> cv_hfs_HfsSegment_getMinRegionSizeI(cv::hfs::HfsSegment* instance) {
		try {
			int ret = instance->getMinRegionSizeI();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSegEgbThresholdII(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:73
	Result_void cv_hfs_HfsSegment_setSegEgbThresholdII_float(cv::hfs::HfsSegment* instance, float c) {
		try {
			instance->setSegEgbThresholdII(c);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSegEgbThresholdII() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:74
	Result<float> cv_hfs_HfsSegment_getSegEgbThresholdII(cv::hfs::HfsSegment* instance) {
		try {
			float ret = instance->getSegEgbThresholdII();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setMinRegionSizeII(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:81
	Result_void cv_hfs_HfsSegment_setMinRegionSizeII_int(cv::hfs::HfsSegment* instance, int n) {
		try {
			instance->setMinRegionSizeII(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinRegionSizeII() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:82
	Result<int> cv_hfs_HfsSegment_getMinRegionSizeII(cv::hfs::HfsSegment* instance) {
		try {
			int ret = instance->getMinRegionSizeII();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setSpatialWeight(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:94
	Result_void cv_hfs_HfsSegment_setSpatialWeight_float(cv::hfs::HfsSegment* instance, float w) {
		try {
			instance->setSpatialWeight(w);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSpatialWeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:95
	Result<float> cv_hfs_HfsSegment_getSpatialWeight(cv::hfs::HfsSegment* instance) {
		try {
			float ret = instance->getSpatialWeight();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setSlicSpixelSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:105
	Result_void cv_hfs_HfsSegment_setSlicSpixelSize_int(cv::hfs::HfsSegment* instance, int n) {
		try {
			instance->setSlicSpixelSize(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSlicSpixelSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:106
	Result<int> cv_hfs_HfsSegment_getSlicSpixelSize(cv::hfs::HfsSegment* instance) {
		try {
			int ret = instance->getSlicSpixelSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumSlicIter(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:113
	Result_void cv_hfs_HfsSegment_setNumSlicIter_int(cv::hfs::HfsSegment* instance, int n) {
		try {
			instance->setNumSlicIter(n);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumSlicIter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:114
	Result<int> cv_hfs_HfsSegment_getNumSlicIter(cv::hfs::HfsSegment* instance) {
		try {
			int ret = instance->getNumSlicIter();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// performSegmentGpu(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:125
	Result<cv::Mat*> cv_hfs_HfsSegment_performSegmentGpu_const__InputArrayR_bool(cv::hfs::HfsSegment* instance, const cv::_InputArray* src, bool ifDraw) {
		try {
			cv::Mat ret = instance->performSegmentGpu(*src, ifDraw);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// performSegmentCpu(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:131
	Result<cv::Mat*> cv_hfs_HfsSegment_performSegmentCpu_const__InputArrayR_bool(cv::hfs::HfsSegment* instance, const cv::_InputArray* src, bool ifDraw) {
		try {
			cv::Mat ret = instance->performSegmentCpu(*src, ifDraw);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// create(int, int, float, int, float, int, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/hfs.hpp:144
	Result<cv::Ptr<cv::hfs::HfsSegment>*> cv_hfs_HfsSegment_create_int_int_float_int_float_int_float_int_int(int height, int width, float segEgbThresholdI, int minRegionSizeI, float segEgbThresholdII, int minRegionSizeII, float spatialWeight, int slicSpixelSize, int numSlicIter) {
		try {
			cv::Ptr<cv::hfs::HfsSegment> ret = cv::hfs::HfsSegment::create(height, width, segEgbThresholdI, minRegionSizeI, segEgbThresholdII, minRegionSizeII, spatialWeight, slicSpixelSize, numSlicIter);
			return Ok(new cv::Ptr<cv::hfs::HfsSegment>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::hfs::HfsSegment>*>))
	}
	
}
