#![allow(
	unused_parens,
	clippy::excessive_precision,
	clippy::missing_safety_doc,
	clippy::not_unsafe_ptr_arg_deref,
	clippy::should_implement_trait,
	clippy::too_many_arguments,
	clippy::unused_unit,
)]
//! \defgroup gapi G-API framework
//!    # G-API Main Classes
//!    # G-API Data Types
//!       # G-API Metadata Descriptors
//!    # G-API Standard Backends
//!    # G-API Graph Compilation Arguments
//!    # G-API Serialization functionality
use crate::{mod_prelude::*, core, sys, types};
pub mod prelude {
	pub use { super::GMatPTraitConst, super::GMatPTrait, super::GArrayUTraitConst, super::GArrayUTrait, super::GOpaqueUTraitConst, super::GOpaqueUTrait, super::GFrameDescTraitConst, super::GFrameDescTrait, super::Own_ScalarTraitConst, super::Own_ScalarTrait, super::MediaFrameTraitConst, super::MediaFrameTrait, super::MediaFrame_ViewTraitConst, super::MediaFrame_ViewTrait, super::MediaFrame_IAdapterConst, super::MediaFrame_IAdapter, super::RMat_ViewTraitConst, super::RMat_ViewTrait, super::RMatTraitConst, super::RMatTrait, super::GArgTraitConst, super::GArgTrait, super::GRunArgTraitConst, super::GRunArgTrait, super::DataTraitConst, super::DataTrait, super::GCompiledTraitConst, super::GCompiledTrait, super::GCallTraitConst, super::GCallTrait, super::GTransformTraitConst, super::GTransformTrait, super::GKernelTraitConst, super::GKernelTrait, super::GKernelImplTraitConst, super::GKernelImplTrait, super::GBackendTraitConst, super::GBackendTrait, super::use_onlyTraitConst, super::use_onlyTrait };
}

// GARRAY /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:42
pub const ArgKind_GARRAY: i32 = 6;
// GFRAME /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:40
pub const ArgKind_GFRAME: i32 = 4;
// GMAT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:38
pub const ArgKind_GMAT: i32 = 2;
// GMATP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:39
pub const ArgKind_GMATP: i32 = 3;
// GOBJREF /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:37
pub const ArgKind_GOBJREF: i32 = 1;
// GOPAQUE /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:43
pub const ArgKind_GOPAQUE: i32 = 7;
// GSCALAR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:41
pub const ArgKind_GSCALAR: i32 = 5;
// OPAQUE /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:35
pub const ArgKind_OPAQUE: i32 = 0;
// OPAQUE_VAL /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:32
pub const ArgKind_OPAQUE_VAL: i32 = 0;
// GARRAY /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:97
pub const GShape_GARRAY: i32 = 2;
// GFRAME /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:99
pub const GShape_GFRAME: i32 = 4;
// GMAT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:95
pub const GShape_GMAT: i32 = 0;
// GOPAQUE /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:98
pub const GShape_GOPAQUE: i32 = 3;
// GSCALAR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:96
pub const GShape_GSCALAR: i32 = 1;
// BGR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:87
pub const MediaFormat_BGR: i32 = 0;
// NV12 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:88
pub const MediaFormat_NV12: i32 = 1;
// CV_BOOL /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:45
pub const OpaqueKind_CV_BOOL: i32 = 1;
// CV_DOUBLE /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:48
pub const OpaqueKind_CV_DOUBLE: i32 = 4;
// CV_DRAW_PRIM /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:58
pub const OpaqueKind_CV_DRAW_PRIM: i32 = 14;
// CV_FLOAT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:49
pub const OpaqueKind_CV_FLOAT: i32 = 5;
// CV_INT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:46
pub const OpaqueKind_CV_INT: i32 = 2;
// CV_INT64 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:47
pub const OpaqueKind_CV_INT64: i32 = 3;
// CV_MAT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:57
pub const OpaqueKind_CV_MAT: i32 = 13;
// CV_POINT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:52
pub const OpaqueKind_CV_POINT: i32 = 8;
// CV_POINT2F /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:53
pub const OpaqueKind_CV_POINT2F: i32 = 9;
// CV_RECT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:55
pub const OpaqueKind_CV_RECT: i32 = 11;
// CV_SCALAR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:56
pub const OpaqueKind_CV_SCALAR: i32 = 12;
// CV_SIZE /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:54
pub const OpaqueKind_CV_SIZE: i32 = 10;
// CV_STRING /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:51
pub const OpaqueKind_CV_STRING: i32 = 7;
// CV_UINT64 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:50
pub const OpaqueKind_CV_UINT64: i32 = 6;
// CV_UNKNOWN /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:44
pub const OpaqueKind_CV_UNKNOWN: i32 = 0;
// ArgKind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtype_traits.hpp:30
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ArgKind {
	OPAQUE_VAL = 0,
	// OPAQUE = 0 as isize, // duplicate discriminant
	GOBJREF = 1,
	GMAT = 2,
	GMATP = 3,
	GFRAME = 4,
	GSCALAR = 5,
	GARRAY = 6,
	GOPAQUE = 7,
}

opencv_type_enum! { crate::gapi::ArgKind }

// GShape /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:93
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum GShape {
	GMAT = 0,
	GSCALAR = 1,
	GARRAY = 2,
	GOPAQUE = 3,
	GFRAME = 4,
}

opencv_type_enum! { crate::gapi::GShape }

// MediaFormat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:85
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MediaFormat {
	BGR = 0,
	NV12 = 1,
}

opencv_type_enum! { crate::gapi::MediaFormat }

/// This enum defines different types of cv::MediaFrame provided
/// access to the underlying data. Note that different flags can't
/// be combined in this version.
// Access /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:57
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum MediaFrame_Access {
	/// Access data for reading
	R = 0,
	/// Access data for writing
	W = 1,
}

opencv_type_enum! { crate::gapi::MediaFrame_Access }

// OpaqueKind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcommon.hpp:42
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum OpaqueKind {
	CV_UNKNOWN = 0,
	CV_BOOL = 1,
	CV_INT = 2,
	CV_INT64 = 3,
	CV_DOUBLE = 4,
	CV_FLOAT = 5,
	CV_UINT64 = 6,
	CV_STRING = 7,
	CV_POINT = 8,
	CV_POINT2F = 9,
	CV_SIZE = 10,
	CV_RECT = 11,
	CV_SCALAR = 12,
	CV_MAT = 13,
	CV_DRAW_PRIM = 14,
}

opencv_type_enum! { crate::gapi::OpaqueKind }

// Access /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:103
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum RMat_Access {
	R = 0,
	W = 1,
}

opencv_type_enum! { crate::gapi::RMat_Access }

// stepsT /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:60
pub type RMat_View_stepsT = core::Vector<size_t>;
// ContMethod /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:162
pub type cont_method = crate::imgproc::ContourApproximationModes;
// RetrMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:161
pub type retr_mode = crate::imgproc::RetrievalModes;
// descr_of(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:268
#[inline]
pub fn descr_of_3(mat: &core::Mat) -> Result<crate::gapi::GMatDesc> {
	let ret = unsafe { sys::cv_descr_of_const_MatR(mat.as_raw_Mat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatDesc::opencv_from_extern(ret) };
	Ok(ret)
}

// descr_of(const cv::MediaFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:106
#[inline]
pub fn descr_of_5(frame: &crate::gapi::MediaFrame) -> Result<crate::gapi::GFrameDesc> {
	let ret = unsafe { sys::cv_descr_of_const_MediaFrameR(frame.as_raw_MediaFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GFrameDesc::opencv_from_extern(ret) };
	Ok(ret)
}

// descr_of(const cv::RMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:265
#[inline]
pub fn descr_of_2(mat: &crate::gapi::RMat) -> Result<crate::gapi::GMatDesc> {
	let ret = unsafe { sys::cv_descr_of_const_RMatR(mat.as_raw_RMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatDesc::opencv_from_extern(ret) };
	Ok(ret)
}

// descr_of(const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gscalar.hpp:134
#[inline]
pub fn descr_of_4(scalar: core::Scalar) -> Result<crate::gapi::GScalarDesc> {
	let ret = unsafe { sys::cv_descr_of_const_ScalarR(&scalar) }.into_result()?;
	let ret = unsafe { crate::gapi::GScalarDesc::opencv_from_extern(ret) };
	Ok(ret)
}

// descr_of(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:256
#[inline]
pub fn descr_of(mat: &core::UMat) -> Result<crate::gapi::GMatDesc> {
	let ret = unsafe { sys::cv_descr_of_const_UMatR(mat.as_raw_UMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatDesc::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from BGR color space to gray-scaled.
/// 
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// Resulting gray color value computed as
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7B0%2E114%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EB%20%2B%20%5Ctexttt%7B0%2E587%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EG%20%20%2B%20%5Ctexttt%7B0%2E299%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2ER%20)
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.bgr2gray"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC1.
/// ## See also
/// BGR2LUV
// BGR2Gray(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1388
#[inline]
pub fn bgr2_gray(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_BGR2Gray_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from BGR color space to I420 color space.
/// 
/// The function converts an input image from BGR color space to I420.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 1-channel image. @ref CV_8UC1.
/// Width of I420 output image must be the same as width of input image.
/// Height of I420 output image must be equal 3/2 from height of input image.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.bgr2i420"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// I4202BGR
// BGR2I420(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1421
#[inline]
pub fn bgr2_i420(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_BGR2I420_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from BGR color space to LUV color space.
/// 
/// The function converts an input image from BGR color space to LUV.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.bgr2luv"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// RGB2Lab, RGB2LUV
// BGR2LUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1483
#[inline]
pub fn bgr2_luv(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_BGR2LUV_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from BGR color space to YUV color space.
/// 
/// The function converts an input image from BGR color space to YUV.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.bgr2yuv"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// YUV2BGR
// BGR2YUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1525
#[inline]
pub fn bgr2_yuv(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_BGR2YUV_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from BayerGR color space to RGB.
/// The function converts an input image from BayerGR color space to RGB.
/// The conventional ranges for G, R, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.bayergr2rgb"
/// 
/// ## Parameters
/// * src_gr: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// ## See also
/// YUV2BGR, NV12toRGB
// BayerGR2RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1612
#[inline]
pub fn bayer_gr2_rgb(src_gr: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_BayerGR2RGB_const_GMatR(src_gr.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Finds edges in an image using the Canny algorithm.
/// 
/// The function finds edges in the input image and marks them in the output map edges using the
/// Canny algorithm. The smallest value between threshold1 and threshold2 is used for edge linking. The
/// largest value is used to find initial segments of strong edges. See
/// <http://en.wikipedia.org/wiki/Canny_edge_detector>
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.feature.canny"
/// 
/// ## Parameters
/// * image: 8-bit input image.
/// * threshold1: first threshold for the hysteresis procedure.
/// * threshold2: second threshold for the hysteresis procedure.
/// * apertureSize: aperture size for the Sobel operator.
/// * L2gradient: a flag, indicating whether a more accurate ![inline formula](https://latex.codecogs.com/png.latex?L%5F2) norm
/// ![inline formula](https://latex.codecogs.com/png.latex?%3D%5Csqrt%7B%28dI%2Fdx%29%5E2%20%2B%20%28dI%2Fdy%29%5E2%7D) should be used to calculate the image gradient magnitude (
/// L2gradient=true ), or whether the default ![inline formula](https://latex.codecogs.com/png.latex?L%5F1) norm ![inline formula](https://latex.codecogs.com/png.latex?%3D%7CdI%2Fdx%7C%2B%7CdI%2Fdy%7C) is enough (
/// L2gradient=false ).
/// 
/// ## C++ default parameters
/// * aperture_size: 3
/// * l2gradient: false
// Canny(const cv::GMat &, double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:999
#[inline]
pub fn canny(image: &crate::gapi::GMat, threshold1: f64, threshold2: f64, aperture_size: i32, l2gradient: bool) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_Canny_const_GMatR_double_double_int_bool(image.as_raw_GMat(), threshold1, threshold2, aperture_size, l2gradient) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from I420 color space to BGR color space.
/// 
/// The function converts an input image from I420 color space to BGR.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image. @ref CV_8UC3.
/// Width of BGR output image must be the same as width of input image.
/// Height of BGR output image must be equal 2/3 from height of input image.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.i4202bgr"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// ## See also
/// BGR2I420
// I4202BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1453
#[inline]
pub fn i4202_bgr(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_I4202BGR_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from I420 color space to BGR color space.
/// 
/// The function converts an input image from I420 color space to BGR.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image. @ref CV_8UC3.
/// Width of RGB output image must be the same as width of input image.
/// Height of RGB output image must be equal 2/3 from height of input image.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.i4202rgb"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// ## See also
/// RGB2I420
// I4202RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1469
#[inline]
pub fn i4202_rgb(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_I4202RGB_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs a look-up table transform of a matrix.
/// 
/// The function LUT fills the output matrix with values from the look-up table. Indices of the entries
/// are taken from the input matrix. That is, the function processes each element of src as follows:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%20%5Cleftarrow%20%5Ctexttt%7Blut%28src%28I%29%29%7D)
/// 
/// Supported matrix data types are @ref CV_8UC1.
/// Output is a matrix of the same size and number of channels as src, and the same depth as lut.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.transform.LUT"
/// 
/// ## Parameters
/// * src: input matrix of 8-bit elements.
/// * lut: look-up table of 256 elements; in case of multi-channel input array, the table should
/// either have a single channel (in this case the same table is used for all channels) or the same
/// number of channels as in the input matrix.
// LUT(const cv::GMat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1775
#[inline]
pub fn lut(src: &crate::gapi::GMat, lut: &core::Mat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_LUT_const_GMatR_const_MatR(src.as_raw_GMat(), lut.as_raw_Mat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from LUV color space to BGR color space.
/// 
/// The function converts an input image from LUV color space to BGR.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.luv2bgr"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// BGR2LUV
// LUV2BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1497
#[inline]
pub fn luv2_bgr(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_LUV2BGR_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the Laplacian of an image.
/// 
/// The function calculates the Laplacian of the source image by adding up the second x and y
/// derivatives calculated using the Sobel operator:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%5CDelta%20%5Ctexttt%7Bsrc%7D%20%3D%20%20%5Cfrac%7B%5Cpartial%5E2%20%5Ctexttt%7Bsrc%7D%7D%7B%5Cpartial%20x%5E2%7D%20%2B%20%20%5Cfrac%7B%5Cpartial%5E2%20%5Ctexttt%7Bsrc%7D%7D%7B%5Cpartial%20y%5E2%7D)
/// 
/// This is done when `ksize > 1`. When `ksize == 1`, the Laplacian is computed by filtering the image
/// with the following ![inline formula](https://latex.codecogs.com/png.latex?3%20%5Ctimes%203) aperture:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Cbegin%7Bbmatrix%7D%200%20%26%201%20%26%200%5C%5C%201%20%26%20%2D4%20%26%201%5C%5C%200%20%26%201%20%26%200%20%5Cend%7Bbmatrix%7D)
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.filters.laplacian"
/// 
/// ## Parameters
/// * src: Source image.
/// * ddepth: Desired depth of the destination image.
/// * ksize: Aperture size used to compute the second-derivative filters. See #getDerivKernels for
/// details. The size must be positive and odd.
/// * scale: Optional scale factor for the computed Laplacian values. By default, no scaling is
/// applied. See #getDerivKernels for details.
/// * delta: Optional delta value that is added to the results prior to storing them in dst .
/// * borderType: Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.
/// ## Returns
/// Destination image of the same size and the same number of channels as src.
/// ## See also
/// Sobel, Scharr
/// 
/// ## C++ default parameters
/// * ksize: 1
/// * scale: 1
/// * delta: 0
/// * border_type: BORDER_DEFAULT
// Laplacian(const cv::GMat &, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:940
#[inline]
pub fn laplacian(src: &crate::gapi::GMat, ddepth: i32, ksize: i32, scale: f64, delta: f64, border_type: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_Laplacian_const_GMatR_int_int_double_double_int(src.as_raw_GMat(), ddepth, ksize, scale, delta, border_type) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from NV12 (YUV420p) color space to BGR.
/// The function converts an input image from NV12 color space to RGB.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.nv12tobgr"
/// 
/// ## Parameters
/// * src_y: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// * src_uv: input image: 8-bit unsigned 2-channel image @ref CV_8UC2.
/// ## See also
/// YUV2BGR, NV12toRGB
// NV12toBGR(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1598
#[inline]
pub fn nv12to_bgr(src_y: &crate::gapi::GMat, src_uv: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_NV12toBGR_const_GMatR_const_GMatR(src_y.as_raw_GMat(), src_uv.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from NV12 (YUV420p) color space to BGR.
/// The function converts an input image from NV12 color space to BGR.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned planar 3-channel image @ref CV_8UC1.
/// Planar image memory layout is three planes laying in the memory contiguously,
/// so the image height should be plane_height*plane_number,
/// image type is @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.nv12torgbp"
/// 
/// ## Parameters
/// * src_y: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// * src_uv: input image: 8-bit unsigned 2-channel image @ref CV_8UC2.
/// ## See also
/// YUV2RGB, NV12toRGBp, NV12toBGR
// NV12toBGRp(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1676
#[inline]
pub fn nv12to_bg_rp(src_y: &crate::gapi::GMat, src_uv: &crate::gapi::GMat) -> Result<crate::gapi::GMatP> {
	let ret = unsafe { sys::cv_gapi_NV12toBGRp_const_GMatR_const_GMatR(src_y.as_raw_GMat(), src_uv.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatP::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from NV12 (YUV420p) color space to gray-scaled.
/// The function converts an input image from NV12 color space to gray-scaled.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 1-channel image @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.nv12togray"
/// 
/// ## Parameters
/// * src_y: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// * src_uv: input image: 8-bit unsigned 2-channel image @ref CV_8UC2.
/// ## See also
/// YUV2RGB, NV12toBGR
// NV12toGray(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1583
#[inline]
pub fn nv12to_gray(src_y: &crate::gapi::GMat, src_uv: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_NV12toGray_const_GMatR_const_GMatR(src_y.as_raw_GMat(), src_uv.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from NV12 (YUV420p) color space to RGB.
/// The function converts an input image from NV12 color space to RGB.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.nv12torgb"
/// 
/// ## Parameters
/// * src_y: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// * src_uv: input image: 8-bit unsigned 2-channel image @ref CV_8UC2.
/// ## See also
/// YUV2RGB, NV12toBGR
// NV12toRGB(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1568
#[inline]
pub fn nv12to_rgb(src_y: &crate::gapi::GMat, src_uv: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_NV12toRGB_const_GMatR_const_GMatR(src_y.as_raw_GMat(), src_uv.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from NV12 (YUV420p) color space to RGB.
/// The function converts an input image from NV12 color space to RGB.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned planar 3-channel image @ref CV_8UC1.
/// Planar image memory layout is three planes laying in the memory contiguously,
/// so the image height should be plane_height*plane_number,
/// image type is @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.nv12torgbp"
/// 
/// ## Parameters
/// * src_y: input image: 8-bit unsigned 1-channel image @ref CV_8UC1.
/// * src_uv: input image: 8-bit unsigned 2-channel image @ref CV_8UC2.
/// ## See also
/// YUV2RGB, NV12toBGRp, NV12toRGB
// NV12toRGBp(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1658
#[inline]
pub fn nv12to_rg_bp(src_y: &crate::gapi::GMat, src_uv: &crate::gapi::GMat) -> Result<crate::gapi::GMatP> {
	let ret = unsafe { sys::cv_gapi_NV12toRGBp_const_GMatR_const_GMatR(src_y.as_raw_GMat(), src_uv.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatP::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to gray-scaled.
/// 
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// Resulting gray color value computed as
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7B0%2E299%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2ER%20%2B%20%5Ctexttt%7B0%2E587%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EG%20%20%2B%20%5Ctexttt%7B0%2E114%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EB%20)
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2gray"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC1.
/// ## See also
/// RGB2YUV
/// 
/// ## Overloaded parameters
/// 
/// Resulting gray color value computed as
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7BrY%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2ER%20%2B%20%5Ctexttt%7BgY%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EG%20%20%2B%20%5Ctexttt%7BbY%7D%20%2A%20%5Ctexttt%7Bsrc%7D%28I%29%2EB%20)
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2graycustom"
/// 
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC1.
/// * rY: float multiplier for R channel.
/// * gY: float multiplier for G channel.
/// * bY: float multiplier for B channel.
/// RGB2YUV
// RGB2Gray(const cv::GMat &, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1375
#[inline]
pub fn rgb2_gray(src: &crate::gapi::GMat, r_y: f32, g_y: f32, b_y: f32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2Gray_const_GMatR_float_float_float(src.as_raw_GMat(), r_y, g_y, b_y) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to HSV.
/// The function converts an input image from RGB color space to HSV.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2hsv"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// YUV2BGR, NV12toRGB
// RGB2HSV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1626
#[inline]
pub fn rgb2_hsv(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2HSV_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to I420 color space.
/// 
/// The function converts an input image from RGB color space to I420.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 1-channel image. @ref CV_8UC1.
/// Width of I420 output image must be the same as width of input image.
/// Height of I420 output image must be equal 3/2 from height of input image.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2i420"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// I4202RGB
// RGB2I420(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1437
#[inline]
pub fn rgb2_i420(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2I420_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to Lab color space.
/// 
/// The function converts an input image from BGR color space to Lab.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2lab"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC1.
/// ## See also
/// RGB2YUV, RGB2LUV
// RGB2Lab(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1539
#[inline]
pub fn rgb2_lab(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2Lab_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to YUV422.
/// The function converts an input image from RGB color space to YUV422.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 2-channel image @ref CV_8UC2.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2yuv422"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// YUV2BGR, NV12toRGB
// RGB2YUV422(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1640
#[inline]
pub fn rgb2_yuv422(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2YUV422_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from RGB color space to YUV color space.
/// 
/// The function converts an input image from RGB color space to YUV.
/// The conventional ranges for R, G, and B channel values are 0 to 255.
/// 
/// In case of linear transformations, the range does not matter. But in case of a non-linear
/// transformation, an input RGB image should be normalized to the proper value range to get the correct
/// results, like here, at RGB ![inline formula](https://latex.codecogs.com/png.latex?%5Crightarrow) Y\*u\*v\* transformation.
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.rgb2yuv"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// YUV2RGB, RGB2Lab
// RGB2YUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1405
#[inline]
pub fn rgb2_yuv(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_RGB2YUV_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the first, second, third, or mixed image derivatives using an extended Sobel operator.
/// 
/// In all cases except one, the ![inline formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bksize%7D%20%5Ctimes%20%5Ctexttt%7Bksize%7D) separable kernel is used to
/// calculate the derivative. When ![inline formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bksize%20%3D%201%7D), the ![inline formula](https://latex.codecogs.com/png.latex?3%20%5Ctimes%201) or ![inline formula](https://latex.codecogs.com/png.latex?1%20%5Ctimes%203)
/// kernel is used (that is, no Gaussian smoothing is done). `ksize = 1` can only be used for the first
/// or the second x- or y- derivatives.
/// 
/// There is also the special value `ksize = FILTER_SCHARR (-1)` that corresponds to the ![inline formula](https://latex.codecogs.com/png.latex?3%5Ctimes3) Scharr
/// filter that may give more accurate results than the ![inline formula](https://latex.codecogs.com/png.latex?3%5Ctimes3) Sobel. The Scharr aperture is
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Cbegin%7Bbmatrix%7D%20%2D3%20%26%200%20%26%203%5C%5C%20%2D10%20%26%200%20%26%2010%5C%5C%20%2D3%20%26%200%20%26%203%20%5Cend%7Bbmatrix%7D)
/// 
/// for the x-derivative, or transposed for the y-derivative.
/// 
/// The function calculates an image derivative by convolving the image with the appropriate kernel:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%5Cfrac%7B%5Cpartial%5E%7Bxorder%2Byorder%7D%20%5Ctexttt%7Bsrc%7D%7D%7B%5Cpartial%20x%5E%7Bxorder%7D%20%5Cpartial%20y%5E%7Byorder%7D%7D)
/// 
/// The Sobel operators combine Gaussian smoothing and differentiation, so the result is more or less
/// resistant to the noise. Most often, the function is called with ( xorder = 1, yorder = 0, ksize = 3)
/// or ( xorder = 0, yorder = 1, ksize = 3) to calculate the first x- or y- image derivative. The first
/// case corresponds to a kernel of:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Cbegin%7Bbmatrix%7D%20%2D1%20%26%200%20%26%201%5C%5C%20%2D2%20%26%200%20%26%202%5C%5C%20%2D1%20%26%200%20%26%201%20%5Cend%7Bbmatrix%7D)
/// 
/// The second case corresponds to a kernel of:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Cbegin%7Bbmatrix%7D%20%2D1%20%26%20%2D2%20%26%20%2D1%5C%5C%200%20%26%200%20%26%200%5C%5C%201%20%26%202%20%26%201%20%5Cend%7Bbmatrix%7D)
/// 
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.sobel"
/// 
/// ## Parameters
/// * src: input image.
/// * ddepth: output image depth, see @ref filter_depths "combinations"; in the case of
///    8-bit input images it will result in truncated derivatives.
/// * dx: order of the derivative x.
/// * dy: order of the derivative y.
/// * ksize: size of the extended Sobel kernel; it must be odd.
/// * scale: optional scale factor for the computed derivative values; by default, no scaling is
/// applied (see cv::getDerivKernels for details).
/// * delta: optional delta value that is added to the results prior to storing them in dst.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// filter2D, gaussianBlur, cartToPolar
/// 
/// ## C++ default parameters
/// * ksize: 3
/// * scale: 1
/// * delta: 0
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// Sobel(const cv::GMat &, int, int, int, int, double, double, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:859
#[inline]
pub fn sobel(src: &crate::gapi::GMat, ddepth: i32, dx: i32, dy: i32, ksize: i32, scale: f64, delta: f64, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_Sobel_const_GMatR_int_int_int_int_double_double_int_const_ScalarR(src.as_raw_GMat(), ddepth, dx, dy, ksize, scale, delta, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from YUV color space to BGR color space.
/// 
/// The function converts an input image from YUV color space to BGR.
/// The conventional ranges for B, G, and R channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.yuv2bgr"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// BGR2YUV
// YUV2BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1511
#[inline]
pub fn yuv2_bgr(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_YUV2BGR_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts an image from YUV color space to RGB.
/// The function converts an input image from YUV color space to RGB.
/// The conventional ranges for Y, U, and V channel values are 0 to 255.
/// 
/// Output image must be 8-bit unsigned 3-channel image @ref CV_8UC3.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.colorconvert.yuv2rgb"
/// 
/// ## Parameters
/// * src: input image: 8-bit unsigned 3-channel image @ref CV_8UC3.
/// ## See also
/// RGB2Lab, RGB2YUV
// YUV2RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1553
#[inline]
pub fn yuv2_rgb(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_YUV2RGB_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates absolute value of matrix elements.
/// 
/// The function abs calculates absolute difference between matrix elements and given scalar value:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%28I%29%20%3D%20%20%5Ctexttt%7Bsaturate%7D%20%28%7C%20%5Ctexttt%7Bsrc1%7D%28I%29%20%2D%20%20%5Ctexttt%7BmatC%7D%28I%29%7C%29)
///    where matC is constructed from given scalar c and has the same sizes and depth as input matrix src.
/// 
/// Output matrix must be of the same size and depth as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.absdiffC"
/// ## Parameters
/// * src: input matrix.
/// * c: scalar to be subtracted.
/// ## See also
/// min, max
// absDiffC(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1273
#[inline]
pub fn abs_diff_c(src: &crate::gapi::GMat, c: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_absDiffC_const_GMatR_const_GScalarR(src.as_raw_GMat(), c.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element absolute difference between two matrices.
/// 
/// The function absDiff calculates absolute difference between two matrices of the same size and depth:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%28I%29%20%3D%20%20%5Ctexttt%7Bsaturate%7D%20%28%7C%20%5Ctexttt%7Bsrc1%7D%28I%29%20%2D%20%20%5Ctexttt%7Bsrc2%7D%28I%29%7C%29)
///    where I is a multi-dimensional index of matrix elements. In case of
///    multi-channel matrices, each channel is processed independently.
/// Output matrix must have the same size and depth as input matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.absdiff"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// ## See also
/// abs
// absDiff(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1256
#[inline]
pub fn abs_diff(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_absDiff_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element sum of matrix and given scalar.
/// 
/// The function addC adds a given scalar value to each element of given matrix.
/// The function can be replaced with matrix expressions:
/// 
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%2B%20%5Ctexttt%7Bc%7D)
/// 
/// Depth of the output matrix is determined by the ddepth parameter.
/// If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.
/// The matrices can be single or multi channel. Output matrix must have the same size and number of channels as the input matrix.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.addC"
/// ## Parameters
/// * src1: first input matrix.
/// * c: scalar value to be added.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// sub, addWeighted
/// 
/// ## Overloaded parameters
/// 
/// ## C++ default parameters
/// * ddepth: -1
// addC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:660
#[inline]
pub fn add_c(c: &crate::gapi::GScalar, src1: &crate::gapi::GMat, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_addC_const_GScalarR_const_GMatR_int(c.as_raw_GScalar(), src1.as_raw_GMat(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the weighted sum of two matrices.
/// 
/// The function addWeighted calculates the weighted sum of two matrices as follows:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bsaturate%7D%20%28%20%5Ctexttt%7Bsrc1%7D%20%28I%29%2A%20%5Ctexttt%7Balpha%7D%20%2B%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29%2A%20%5Ctexttt%7Bbeta%7D%20%2B%20%20%5Ctexttt%7Bgamma%7D%20%29)
/// where I is a multi-dimensional index of array elements. In case of multi-channel matrices, each
/// channel is processed independently.
/// 
/// The function can be replaced with a matrix expression:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%28I%29%20%3D%20%20%5Ctexttt%7Balpha%7D%20%2A%20%5Ctexttt%7Bsrc1%7D%28I%29%20%2D%20%5Ctexttt%7Bbeta%7D%20%2A%20%5Ctexttt%7Bsrc2%7D%28I%29%20%2B%20%5Ctexttt%7Bgamma%7D%20)
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.addweighted"
/// ## Parameters
/// * src1: first input matrix.
/// * alpha: weight of the first matrix elements.
/// * src2: second input matrix of the same size and channel number as src1.
/// * beta: weight of the second matrix elements.
/// * gamma: scalar added to each sum.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// add, sub
/// 
/// ## C++ default parameters
/// * ddepth: -1
// addWeighted(const cv::GMat &, double, const cv::GMat &, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1321
#[inline]
pub fn add_weighted(src1: &crate::gapi::GMat, alpha: f64, src2: &crate::gapi::GMat, beta: f64, gamma: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_addWeighted_const_GMatR_double_const_GMatR_double_double_int(src1.as_raw_GMat(), alpha, src2.as_raw_GMat(), beta, gamma, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies the bilateral filter to an image.
/// 
/// The function applies bilateral filtering to the input image, as described in
/// http://www.dai.ed.ac.uk/CVonline/LOCAL_COPIES/MANDUCHI1/Bilateral_Filtering.html
/// bilateralFilter can reduce unwanted noise very well while keeping edges fairly sharp. However, it is
/// very slow compared to most filters.
/// 
/// _Sigma values_: For simplicity, you can set the 2 sigma values to be the same. If they are small (\<
/// 10), the filter will not have much effect, whereas if they are large (\> 150), they will have a very
/// strong effect, making the image look "cartoonish".
/// 
/// _Filter size_: Large filters (d \> 5) are very slow, so it is recommended to use d=5 for real-time
/// applications, and perhaps d=9 for offline applications that need heavy noise filtering.
/// 
/// This filter does not work inplace.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.filters.bilateralfilter"
/// 
/// ## Parameters
/// * src: Source 8-bit or floating-point, 1-channel or 3-channel image.
/// * d: Diameter of each pixel neighborhood that is used during filtering. If it is non-positive,
/// it is computed from sigmaSpace.
/// * sigmaColor: Filter sigma in the color space. A larger value of the parameter means that
/// farther colors within the pixel neighborhood (see sigmaSpace) will be mixed together, resulting
/// in larger areas of semi-equal color.
/// * sigmaSpace: Filter sigma in the coordinate space. A larger value of the parameter means that
/// farther pixels will influence each other as long as their colors are close enough (see sigmaColor
/// ). When d\>0, it specifies the neighborhood size regardless of sigmaSpace. Otherwise, d is
/// proportional to sigmaSpace.
/// * borderType: border mode used to extrapolate pixels outside of the image, see #BorderTypes
/// ## Returns
/// Destination image of the same size and type as src.
/// 
/// ## C++ default parameters
/// * border_type: BORDER_DEFAULT
// bilateralFilter(const cv::GMat &, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:974
#[inline]
pub fn bilateral_filter(src: &crate::gapi::GMat, d: i32, sigma_color: f64, sigma_space: f64, border_type: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bilateralFilter_const_GMatR_int_double_double_int(src.as_raw_GMat(), d, sigma_color, sigma_space, border_type) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise conjunction of the two matrixes (src1 & src2)
/// Calculates the per-element bit-wise logical conjunction of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_and"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
// bitwise_and(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1108
#[inline]
pub fn bitwise_and(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_and_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise conjunction of the two matrixes (src1 & src2)
/// Calculates the per-element bit-wise logical conjunction of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_and"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_andS"
/// * src1: first input matrix.
/// * src2: scalar, which will be per-lemenetly conjuncted with elements of src1.
// bitwise_and(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1114
#[inline]
pub fn bitwise_and_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_and_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Inverts every bit of an array.
/// 
/// The function bitwise_not calculates per-element bit-wise inversion of the input
/// matrix:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Cneg%20%5Ctexttt%7Bsrc%7D%20%28I%29)
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrix.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_not"
/// 
/// ## Parameters
/// * src: input matrix.
// bitwise_not(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1184
#[inline]
pub fn bitwise_not(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_not_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise disjunction of the two matrixes (src1 | src2)
/// Calculates the per-element bit-wise logical disjunction of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_or"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
// bitwise_or(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1132
#[inline]
pub fn bitwise_or(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_or_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise disjunction of the two matrixes (src1 | src2)
/// Calculates the per-element bit-wise logical disjunction of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_or"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_orS"
/// * src1: first input matrix.
/// * src2: scalar, which will be per-lemenetly disjuncted with elements of src1.
// bitwise_or(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1138
#[inline]
pub fn bitwise_or_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_or_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise logical "exclusive or" of the two matrixes (src1 ^ src2)
/// Calculates the per-element bit-wise logical "exclusive or" of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_xor"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
// bitwise_xor(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1157
#[inline]
pub fn bitwise_xor(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_xor_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// computes bitwise logical "exclusive or" of the two matrixes (src1 ^ src2)
/// Calculates the per-element bit-wise logical "exclusive or" of two matrices of the same size.
/// 
/// In case of floating-point matrices, their machine-specific bit
/// representations (usually IEEE754-compliant) are used for the operation.
/// In case of multi-channel matrices, each channel is processed
/// independently. Output matrix must have the same size and depth as the input
/// matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_xor"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.bitwise_xorS"
/// * src1: first input matrix.
/// * src2: scalar, for which per-lemenet "logical or" operation on elements of src1 will be performed.
// bitwise_xor(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1163
#[inline]
pub fn bitwise_xor_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_bitwise_xor_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Blurs an image using the normalized box filter.
/// 
/// The function smooths an image using the kernel:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7BK%7D%20%3D%20%20%5Cfrac%7B1%7D%7B%5Ctexttt%7Bksize%2Ewidth%2Aksize%2Eheight%7D%7D%20%5Cbegin%7Bbmatrix%7D%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%20%5C%5C%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%20%5C%5C%20%5Cdots%20%5C%5C%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%20%5C%5C%20%5Cend%7Bbmatrix%7D)
/// 
/// The call `blur(src, ksize, anchor, borderType)` is equivalent to `boxFilter(src, src.type(), ksize, anchor,
/// true, borderType)`.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.blur"
/// 
/// ## Parameters
/// * src: Source image.
/// * ksize: blurring kernel size.
/// * anchor: anchor point; default value Point(-1,-1) means that the anchor is at the kernel
/// center.
/// * borderType: border mode used to extrapolate pixels outside of the image, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// boxFilter, bilateralFilter, GaussianBlur, medianBlur
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// blur(const cv::GMat &, const cv::Size &, const cv::Point &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:630
#[inline]
pub fn blur(src: &crate::gapi::GMat, ksize: core::Size, anchor: core::Point, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_blur_const_GMatR_const_SizeR_const_PointR_int_const_ScalarR(src.as_raw_GMat(), &ksize, &anchor, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Blurs an image using the box filter.
/// 
/// The function smooths an image using the kernel:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7BK%7D%20%3D%20%20%5Calpha%20%5Cbegin%7Bbmatrix%7D%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%20%5C%5C%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%20%5C%5C%20%5Cdots%20%5C%5C%201%20%26%201%20%26%201%20%26%20%20%5Ccdots%20%26%201%20%26%201%20%5Cend%7Bbmatrix%7D)
/// 
/// where
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Calpha%20%3D%20%5Cbegin%7Bcases%7D%20%5Cfrac%7B1%7D%7B%5Ctexttt%7Bksize%2Ewidth%2Aksize%2Eheight%7D%7D%20%26%20%5Ctexttt%7Bwhen%20%7D%20%5Ctexttt%7Bnormalize%3Dtrue%7D%20%20%5C%5C1%20%26%20%5Ctexttt%7Botherwise%7D%20%5Cend%7Bcases%7D)
/// 
/// Unnormalized box filter is useful for computing various integral characteristics over each pixel
/// neighborhood, such as covariance matrices of image derivatives (used in dense optical flow
/// algorithms, and so on). If you need to compute pixel sums over variable-size windows, use cv::integral.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.boxfilter"
/// 
/// ## Parameters
/// * src: Source image.
/// * dtype: the output image depth (-1 to set the input image data type).
/// * ksize: blurring kernel size.
/// * anchor: Anchor position within the kernel. The default value ![inline formula](https://latex.codecogs.com/png.latex?%28%2D1%2C%2D1%29) means that the anchor
/// is at the kernel center.
/// * normalize: flag, specifying whether the kernel is normalized by its area or not.
/// * borderType: Pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// sepFilter, gaussianBlur, medianBlur, integral
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * normalize: true
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// boxFilter(const cv::GMat &, int, const cv::Size &, const cv::Point &, bool, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:603
#[inline]
pub fn box_filter(src: &crate::gapi::GMat, dtype: i32, ksize: core::Size, anchor: core::Point, normalize: bool, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_boxFilter_const_GMatR_int_const_SizeR_const_PointR_bool_int_const_ScalarR(src.as_raw_GMat(), dtype, &ksize, &anchor, normalize, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are equal to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3D%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3D%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpEQ"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpNE
// cmpEQ(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1060
#[inline]
pub fn cmp_eq(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpEQ_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are equal to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3D%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3D%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpEQ"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpNE
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpEQScalar"
// cmpEQ(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1064
#[inline]
pub fn cmp_eq_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpEQ_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are greater or equal compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3E%3D%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3E%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpGE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGT, cmpLT
// cmpGE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1008
#[inline]
pub fn cmp_ge(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpGE_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are greater or equal compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3E%3D%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3E%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpGE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGT, cmpLT
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLGEcalar"
// cmpGE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1012
#[inline]
pub fn cmp_ge_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpGE_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are greater compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3E%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3E%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices/matrix.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpGT"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGE, cmpLT
// cmpGT(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:956
#[inline]
pub fn cmp_gt(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpGT_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are greater compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3E%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3E%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices/matrix.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpGT"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGE, cmpLT
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpGTScalar"
// cmpGT(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:960
#[inline]
pub fn cmp_gt_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpGT_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are less or equal compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3C%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3C%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpGT, cmpGE, cmpLT
// cmpLE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1034
#[inline]
pub fn cmp_le(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpLE_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are less or equal compare to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3C%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3C%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpGT, cmpGE, cmpLT
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLEScalar"
// cmpLE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1038
#[inline]
pub fn cmp_le_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpLE_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are less than elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3C%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3C%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices/matrix.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLT"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGE, cmpGT
// cmpLT(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:982
#[inline]
pub fn cmp_lt(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpLT_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are less than elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%3C%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%3C%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices/matrix.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLT"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpLE, cmpGE, cmpGT
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpLTScalar"
// cmpLT(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:986
#[inline]
pub fn cmp_lt_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpLT_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are not equal to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%21%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%21%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpNE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpEQ
// cmpNE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1086
#[inline]
pub fn cmp_ne(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpNE_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs the per-element comparison of two matrices checking if elements from first matrix are not equal to elements in second.
/// 
/// The function compares elements of two matrices src1 and src2 of the same size:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%21%3D%20%20%5Ctexttt%7Bsrc2%7D%20%28I%29)
/// 
/// When the comparison result is true, the corresponding element of output
/// array is set to 255. The comparison operations can be replaced with the
/// equivalent matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%21%3D%20%5Ctexttt%7Bsrc2%7D)
/// 
/// Output matrix of depth @ref CV_8U must have the same size and the same number of channels as
///    the input matrices.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpNE"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix/scalar of the same depth as first input matrix.
/// ## See also
/// min, max, threshold, cmpEQ
/// 
/// ## Overloaded parameters
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.compare.cmpNEScalar"
// cmpNE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1090
#[inline]
pub fn cmp_ne_1(src1: &crate::gapi::GMat, src2: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_cmpNE_const_GMatR_const_GScalarR(src1.as_raw_GMat(), src2.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// combine(const cv::gapi::GKernelPackage &, const cv::gapi::GKernelPackage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:699
#[inline]
pub fn combine(lhs: &crate::gapi::GKernelPackage, rhs: &crate::gapi::GKernelPackage) -> Result<crate::gapi::GKernelPackage> {
	let ret = unsafe { sys::cv_gapi_combine_const_GKernelPackageR_const_GKernelPackageR(lhs.as_raw_GKernelPackage(), rhs.as_raw_GKernelPackage()) }.into_result()?;
	let ret = unsafe { crate::gapi::GKernelPackage::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies horizontal concatenation to given matrices.
/// 
/// The function horizontally concatenates two GMat matrices (with the same number of rows).
/// ```ignore
///    GMat A = { 1, 4,
///                2, 5,
///                3, 6 };
///    GMat B = { 7, 10,
///                8, 11,
///                9, 12 };
/// 
///    GMat C = gapi::concatHor(A, B);
///    //C:
///    //[1, 4, 7, 10;
///    // 2, 5, 8, 11;
///    // 3, 6, 9, 12]
/// ```
/// 
/// Output matrix must the same number of rows and depth as the src1 and src2, and the sum of cols of the src1 and src2.
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.transform.concatHor"
/// 
/// ## Parameters
/// * src1: first input matrix to be considered for horizontal concatenation.
/// * src2: second input matrix to be considered for horizontal concatenation.
/// ## See also
/// concatVert
// concatHor(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1708
#[inline]
pub fn concat_hor(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_concatHor_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies horizontal concatenation to given matrices.
/// 
/// The function horizontally concatenates two GMat matrices (with the same number of rows).
/// ```ignore
///    GMat A = { 1, 4,
///                2, 5,
///                3, 6 };
///    GMat B = { 7, 10,
///                8, 11,
///                9, 12 };
/// 
///    GMat C = gapi::concatHor(A, B);
///    //C:
///    //[1, 4, 7, 10;
///    // 2, 5, 8, 11;
///    // 3, 6, 9, 12]
/// ```
/// 
/// Output matrix must the same number of rows and depth as the src1 and src2, and the sum of cols of the src1 and src2.
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.transform.concatHor"
/// 
/// ## Parameters
/// * src1: first input matrix to be considered for horizontal concatenation.
/// * src2: second input matrix to be considered for horizontal concatenation.
/// ## See also
/// concatVert
/// 
/// ## Overloaded parameters
/// 
/// The function horizontally concatenates given number of GMat matrices (with the same number of columns).
/// Output matrix must the same number of columns and depth as the input matrices, and the sum of rows of input matrices.
/// 
/// * v: vector of input matrices to be concatenated horizontally.
// concatHor(const std::vector<GMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1716
#[inline]
pub fn concat_hor_1(v: &core::Vector<crate::gapi::GMat>) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_concatHor_const_vector_GMat_R(v.as_raw_VectorOfGMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies vertical concatenation to given matrices.
/// 
/// The function vertically concatenates two GMat matrices (with the same number of cols).
///  ```ignore
///    GMat A = { 1, 7,
///                2, 8,
///                3, 9 };
///    GMat B = { 4, 10,
///                5, 11,
///                6, 12 };
/// 
///    GMat C = gapi::concatVert(A, B);
///    //C:
///    //[1, 7;
///    // 2, 8;
///    // 3, 9;
///    // 4, 10;
///    // 5, 11;
///    // 6, 12]
///  ```
/// 
/// 
/// Output matrix must the same number of cols and depth as the src1 and src2, and the sum of rows of the src1 and src2.
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.transform.concatVert"
/// 
/// ## Parameters
/// * src1: first input matrix to be considered for vertical concatenation.
/// * src2: second input matrix to be considered for vertical concatenation.
/// ## See also
/// concatHor
// concatVert(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1748
#[inline]
pub fn concat_vert(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_concatVert_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies vertical concatenation to given matrices.
/// 
/// The function vertically concatenates two GMat matrices (with the same number of cols).
///  ```ignore
///    GMat A = { 1, 7,
///                2, 8,
///                3, 9 };
///    GMat B = { 4, 10,
///                5, 11,
///                6, 12 };
/// 
///    GMat C = gapi::concatVert(A, B);
///    //C:
///    //[1, 7;
///    // 2, 8;
///    // 3, 9;
///    // 4, 10;
///    // 5, 11;
///    // 6, 12]
///  ```
/// 
/// 
/// Output matrix must the same number of cols and depth as the src1 and src2, and the sum of rows of the src1 and src2.
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.imgproc.transform.concatVert"
/// 
/// ## Parameters
/// * src1: first input matrix to be considered for vertical concatenation.
/// * src2: second input matrix to be considered for vertical concatenation.
/// ## See also
/// concatHor
/// 
/// ## Overloaded parameters
/// 
/// The function vertically concatenates given number of GMat matrices (with the same number of columns).
/// Output matrix must the same number of columns and depth as the input matrices, and the sum of rows of input matrices.
/// 
/// * v: vector of input matrices to be concatenated vertically.
// concatVert(const std::vector<GMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1756
#[inline]
pub fn concat_vert_1(v: &core::Vector<crate::gapi::GMat>) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_concatVert_const_vector_GMat_R(v.as_raw_VectorOfGMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Converts a matrix to another data depth with optional scaling.
/// 
/// The method converts source pixel values to the target data depth. saturate_cast\<\> is applied at
/// the end to avoid possible overflows:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?m%28x%2Cy%29%20%3D%20saturate%20%5C%5F%20cast%3CrType%3E%28%20%5Calpha%20%28%2Athis%29%28x%2Cy%29%20%2B%20%20%5Cbeta%20%29)
/// Output matrix must be of the same size as input one.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.transform.convertTo"
/// ## Parameters
/// * src: input matrix to be converted from.
/// * rdepth: desired output matrix depth or, rather, the depth since the number of channels are the
/// same as the input has; if rdepth is negative, the output matrix will have the same depth as the input.
/// * alpha: optional scale factor.
/// * beta: optional delta added to the scaled values.
/// 
/// ## C++ default parameters
/// * alpha: 1
/// * beta: 0
// convertTo(const cv::GMat &, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1792
#[inline]
pub fn convert_to(src: &crate::gapi::GMat, rdepth: i32, alpha: f64, beta: f64) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_convertTo_const_GMatR_int_double_double(src.as_raw_GMat(), rdepth, alpha, beta) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Makes a copy of the input frame. Note that this copy may be not real
/// (no actual data copied). Use this function to maintain graph contracts,
/// e.g when graph's input needs to be passed directly to output, like in Streaming mode.
/// 
/// 
/// Note: Function textual ID is "org.opencv.streaming.copy"
/// 
/// ## Parameters
/// * in: Input frame
/// ## Returns
/// Copy of the input
// copy(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:88
#[inline]
pub fn copy(in_: &crate::gapi::GFrame) -> Result<crate::gapi::GFrame> {
	let ret = unsafe { sys::cv_gapi_copy_const_GFrameR(in_.as_raw_GFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GFrame::opencv_from_extern(ret) };
	Ok(ret)
}

/// Crops a 2D matrix.
/// 
/// The function crops the matrix by given cv::Rect.
/// 
/// Output matrix must be of the same depth as input one, size is specified by given rect size.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.transform.crop"
/// 
/// ## Parameters
/// * src: input matrix.
/// * rect: a rect to crop a matrix to
/// ## See also
/// resize
// crop(const cv::GMat &, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1680
#[inline]
pub fn crop(src: &crate::gapi::GMat, rect: core::Rect) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_crop_const_GMatR_const_RectR(src.as_raw_GMat(), &rect) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Dilates an image by using 3 by 3 rectangular structuring element.
/// 
/// The function dilates the source image using the specified structuring element that determines the
/// shape of a pixel neighborhood over which the maximum is taken:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Cmax%20%5F%7B%28x%27%2Cy%27%29%3A%20%20%5C%2C%20%5Ctexttt%7Belement%7D%20%28x%27%2Cy%27%29%20%5Cne0%20%7D%20%5Ctexttt%7Bsrc%7D%20%28x%2Bx%27%2Cy%2By%27%29)
/// 
/// Dilation can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.dilate"
/// 
/// ## Parameters
/// * src: input image.
/// * iterations: number of times dilation is applied.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of a constant border
/// ## See also
/// dilate, erode3x3
/// 
/// ## C++ default parameters
/// * iterations: 1
/// * border_type: BORDER_CONSTANT
/// * border_value: morphologyDefaultBorderValue()
// dilate3x3(const cv::GMat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:777
#[inline]
pub fn dilate3x3(src: &crate::gapi::GMat, iterations: i32, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_dilate3x3_const_GMatR_int_int_const_ScalarR(src.as_raw_GMat(), iterations, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Dilates an image by using a specific structuring element.
/// 
/// The function dilates the source image using the specified structuring element that determines the
/// shape of a pixel neighborhood over which the maximum is taken:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Cmax%20%5F%7B%28x%27%2Cy%27%29%3A%20%20%5C%2C%20%5Ctexttt%7Belement%7D%20%28x%27%2Cy%27%29%20%5Cne0%20%7D%20%5Ctexttt%7Bsrc%7D%20%28x%2Bx%27%2Cy%2By%27%29)
/// 
/// Dilation can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.dilate"
/// 
/// ## Parameters
/// * src: input image.
/// * kernel: structuring element used for dilation; if elemenat=Mat(), a 3 x 3 rectangular
/// structuring element is used. Kernel can be created using getStructuringElement
/// * anchor: position of the anchor within the element; default value (-1, -1) means that the
/// anchor is at the element center.
/// * iterations: number of times dilation is applied.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of a constant border
/// ## See also
/// erode, morphologyEx, getStructuringElement
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * iterations: 1
/// * border_type: BORDER_CONSTANT
/// * border_value: morphologyDefaultBorderValue()
// dilate(const cv::GMat &, const cv::Mat &, const cv::Point &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:753
#[inline]
pub fn dilate(src: &crate::gapi::GMat, kernel: &core::Mat, anchor: core::Point, iterations: i32, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_dilate_const_GMatR_const_MatR_const_PointR_int_int_const_ScalarR(src.as_raw_GMat(), kernel.as_raw_Mat(), &anchor, iterations, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Divides matrix by scalar.
/// 
/// The function divC divides each element of matrix src by given scalar value:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%28I%29%20%3D%20saturate%28src%28I%29%2Ascale%2Fdivisor%29%7D)
/// 
/// When divisor is zero, dst(I) will also be zero. Different channels of
/// multi-channel matrices are processed independently.
/// The matrices can be single or multi channel. Output matrix must have the same size and depth as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.divC"
/// ## Parameters
/// * src: input matrix.
/// * divisor: number to be divided by.
/// * ddepth: optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.
/// * scale: scale factor.
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## C++ default parameters
/// * ddepth: -1
// divC(const cv::GMat &, const cv::GScalar &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:807
#[inline]
pub fn div_c(src: &crate::gapi::GMat, divisor: &crate::gapi::GScalar, scale: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_divC_const_GMatR_const_GScalarR_double_int(src.as_raw_GMat(), divisor.as_raw_GScalar(), scale, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Divides scalar by matrix.
/// 
/// The function divRC divides given scalar by each element of matrix src and keep the division result in new matrix of the same size and type as src:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%28I%29%20%3D%20saturate%28divident%2Ascale%2Fsrc%28I%29%29%7D)
/// 
/// When src(I) is zero, dst(I) will also be zero. Different channels of
/// multi-channel matrices are processed independently.
/// The matrices can be single or multi channel. Output matrix must have the same size and depth as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.divRC"
/// ## Parameters
/// * src: input matrix.
/// * divident: number to be divided.
/// * ddepth: optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.
/// * scale: scale factor
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## C++ default parameters
/// * ddepth: -1
// divRC(const cv::GScalar &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:828
#[inline]
pub fn div_rc(divident: &crate::gapi::GScalar, src: &crate::gapi::GMat, scale: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_divRC_const_GScalarR_const_GMatR_double_int(divident.as_raw_GScalar(), src.as_raw_GMat(), scale, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs per-element division of two matrices.
/// 
/// The function divides one matrix by another:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%28I%29%20%3D%20saturate%28src1%28I%29%2Ascale%2Fsrc2%28I%29%29%7D)
/// 
/// When src2(I) is zero, dst(I) will also be zero. Different channels of
/// multi-channel matrices are processed independently.
/// The matrices can be single or multi channel. Output matrix must have the same size and depth as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.div"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix of the same size and depth as src1.
/// * scale: scalar factor.
/// * ddepth: optional depth of the output matrix; you can only pass -1 when src1.depth() == src2.depth().
/// ## See also
/// mul, add, sub
/// 
/// ## C++ default parameters
/// * ddepth: -1
// div(const cv::GMat &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:786
#[inline]
pub fn div_3(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, scale: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_div_const_GMatR_const_GMatR_double_int(src1.as_raw_GMat(), src2.as_raw_GMat(), scale, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Equalizes the histogram of a grayscale image.
/// 
/// //!
/// 
/// The function equalizes the histogram of the input image using the following algorithm:
/// 
/// - Calculate the histogram ![inline formula](https://latex.codecogs.com/png.latex?H) for src .
/// - Normalize the histogram so that the sum of histogram bins is 255.
/// - Compute the integral of the histogram:
/// ![block formula](https://latex.codecogs.com/png.latex?H%27%5Fi%20%3D%20%20%5Csum%20%5F%7B0%20%20%5Cle%20j%20%3C%20i%7D%20H%28j%29)
/// - Transform the image using ![inline formula](https://latex.codecogs.com/png.latex?H%27) as a look-up table: ![inline formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%28x%2Cy%29%20%3D%20H%27%28%5Ctexttt%7Bsrc%7D%28x%2Cy%29%29)
/// 
/// The algorithm normalizes the brightness and increases the contrast of the image.
/// 
/// Note:
///  - The returned image is of the same size and type as input.
///  - Function textual ID is "org.opencv.imgproc.equalizeHist"
/// 
/// ## Parameters
/// * src: Source 8-bit single channel image.
// equalizeHist(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1074
#[inline]
pub fn equalize_hist(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_equalizeHist_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Erodes an image by using 3 by 3 rectangular structuring element.
/// 
/// The function erodes the source image using the rectangular structuring element with rectangle center as an anchor.
/// Erosion can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.erode"
/// 
/// ## Parameters
/// * src: input image
/// * iterations: number of times erosion is applied.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of a constant border
/// ## See also
/// erode, dilate3x3
/// 
/// ## C++ default parameters
/// * iterations: 1
/// * border_type: BORDER_CONSTANT
/// * border_value: morphologyDefaultBorderValue()
// erode3x3(const cv::GMat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:726
#[inline]
pub fn erode3x3(src: &crate::gapi::GMat, iterations: i32, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_erode3x3_const_GMatR_int_int_const_ScalarR(src.as_raw_GMat(), iterations, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Erodes an image by using a specific structuring element.
/// 
/// The function erodes the source image using the specified structuring element that determines the
/// shape of a pixel neighborhood over which the minimum is taken:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Cmin%20%5F%7B%28x%27%2Cy%27%29%3A%20%20%5C%2C%20%5Ctexttt%7Belement%7D%20%28x%27%2Cy%27%29%20%5Cne0%20%7D%20%5Ctexttt%7Bsrc%7D%20%28x%2Bx%27%2Cy%2By%27%29)
/// 
/// Erosion can be applied several (iterations) times. In case of multi-channel images, each channel is processed independently.
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, and @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.erode"
/// 
/// ## Parameters
/// * src: input image
/// * kernel: structuring element used for erosion; if `element=Mat()`, a `3 x 3` rectangular
/// structuring element is used. Kernel can be created using getStructuringElement.
/// * anchor: position of the anchor within the element; default value (-1, -1) means that the
/// anchor is at the element center.
/// * iterations: number of times erosion is applied.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of a constant border
/// ## See also
/// dilate, morphologyEx
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * iterations: 1
/// * border_type: BORDER_CONSTANT
/// * border_value: morphologyDefaultBorderValue()
// erode(const cv::GMat &, const cv::Mat &, const cv::Point &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:706
#[inline]
pub fn erode(src: &crate::gapi::GMat, kernel: &core::Mat, anchor: core::Point, iterations: i32, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_erode_const_GMatR_const_MatR_const_PointR_int_int_const_ScalarR(src.as_raw_GMat(), kernel.as_raw_Mat(), &anchor, iterations, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Convolves an image with the kernel.
/// 
/// The function applies an arbitrary linear filter to an image. When
/// the aperture is partially outside the image, the function interpolates outlier pixel values
/// according to the specified border mode.
/// 
/// The function does actually compute correlation, not the convolution:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Csum%20%5F%7B%20%5Csubstack%7B0%5Cleq%20x%27%20%3C%20%5Ctexttt%7Bkernel%2Ecols%7D%5C%5C%7B0%5Cleq%20y%27%20%3C%20%5Ctexttt%7Bkernel%2Erows%7D%7D%7D%7D%20%20%5Ctexttt%7Bkernel%7D%20%28x%27%2Cy%27%29%2A%20%5Ctexttt%7Bsrc%7D%20%28x%2Bx%27%2D%20%5Ctexttt%7Banchor%2Ex%7D%20%2Cy%2By%27%2D%20%5Ctexttt%7Banchor%2Ey%7D%20%29)
/// 
/// That is, the kernel is not mirrored around the anchor point. If you need a real convolution, flip
/// the kernel using flip and set the new anchor to `(kernel.cols - anchor.x - 1, kernel.rows -
/// anchor.y - 1)`.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// Output image must have the same size and number of channels an input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.filter2D"
/// 
/// ## Parameters
/// * src: input image.
/// * ddepth: desired depth of the destination image
/// * kernel: convolution kernel (or rather a correlation kernel), a single-channel floating point
/// matrix; if you want to apply different kernels to different channels, split the image into
/// separate color planes using split and process them individually.
/// * anchor: anchor of the kernel that indicates the relative position of a filtered point within
/// the kernel; the anchor should lie within the kernel; default value (-1,-1) means that the anchor
/// is at the kernel center.
/// * delta: optional value added to the filtered pixels before storing them in dst.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// sepFilter
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * delta: Scalar(0)
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// filter2D(const cv::GMat &, int, const cv::Mat &, const cv::Point &, const cv::Scalar &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:569
#[inline]
pub fn filter_2d(src: &crate::gapi::GMat, ddepth: i32, kernel: &core::Mat, anchor: core::Point, delta: core::Scalar, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_filter2D_const_GMatR_int_const_MatR_const_PointR_const_ScalarR_int_const_ScalarR(src.as_raw_GMat(), ddepth, kernel.as_raw_Mat(), &anchor, &delta, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Flips a 2D matrix around vertical, horizontal, or both axes.
/// 
/// The function flips the matrix in one of three different ways (row
/// and column indices are 0-based):
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%5F%7Bij%7D%20%3D%0A%5Cleft%5C%7B%0A%5Cbegin%7Barray%7D%7Bl%20l%7D%0A%5Ctexttt%7Bsrc%7D%20%5F%7B%5Ctexttt%7Bsrc%2Erows%7D%2Di%2D1%2Cj%7D%20%26%20if%5C%3B%20%20%5Ctexttt%7BflipCode%7D%20%3D%200%20%5C%5C%0A%5Ctexttt%7Bsrc%7D%20%5F%7Bi%2C%20%5Ctexttt%7Bsrc%2Ecols%7D%20%2Dj%2D1%7D%20%26%20if%5C%3B%20%20%5Ctexttt%7BflipCode%7D%20%3E%200%20%5C%5C%0A%5Ctexttt%7Bsrc%7D%20%5F%7B%20%5Ctexttt%7Bsrc%2Erows%7D%20%2Di%2D1%2C%20%5Ctexttt%7Bsrc%2Ecols%7D%20%2Dj%2D1%7D%20%26%20if%5C%3B%20%5Ctexttt%7BflipCode%7D%20%3C%200%20%5C%5C%0A%5Cend%7Barray%7D%0A%5Cright%2E)
/// The example scenarios of using the function are the following:
/// *   Vertical flipping of the image (flipCode == 0) to switch between
///    top-left and bottom-left image origin. This is a typical operation
///    in video processing on Microsoft Windows\* OS.
/// *   Horizontal flipping of the image with the subsequent horizontal
///    shift and absolute difference calculation to check for a
///    vertical-axis symmetry (flipCode \> 0).
/// *   Simultaneous horizontal and vertical flipping of the image with
///    the subsequent shift and absolute difference calculation to check
///    for a central symmetry (flipCode \< 0).
/// *   Reversing the order of point arrays (flipCode \> 0 or
///    flipCode == 0).
/// Output image must be of the same depth as input one, size should be correct for given flipCode.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.transform.flip"
/// 
/// ## Parameters
/// * src: input matrix.
/// * flipCode: a flag to specify how to flip the array; 0 means
/// flipping around the x-axis and positive value (for example, 1) means
/// flipping around y-axis. Negative value (for example, -1) means flipping
/// around both axes.
/// ## See also
/// remap
// flip(const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1666
#[inline]
pub fn flip(src: &crate::gapi::GMat, flip_code: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_flip_const_GMatR_int(src.as_raw_GMat(), flip_code) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Blurs an image using a Gaussian filter.
/// 
/// The function filter2Ds the source image with the specified Gaussian kernel.
/// Output image must have the same type and number of channels an input image.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - Rounding to nearest even is procedeed if hardware supports it, if not - to nearest.
///  - Function textual ID is "org.opencv.imgproc.filters.gaussianBlur"
/// 
/// ## Parameters
/// * src: input image;
/// * ksize: Gaussian kernel size. ksize.width and ksize.height can differ but they both must be
/// positive and odd. Or, they can be zero's and then they are computed from sigma.
/// * sigmaX: Gaussian kernel standard deviation in X direction.
/// * sigmaY: Gaussian kernel standard deviation in Y direction; if sigmaY is zero, it is set to be
/// equal to sigmaX, if both sigmas are zeros, they are computed from ksize.width and ksize.height,
/// respectively (see cv::getGaussianKernel for details); to fully control the result regardless of
/// possible future modifications of all this semantics, it is recommended to specify all of ksize,
/// sigmaX, and sigmaY.
/// * borderType: pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// sepFilter, boxFilter, medianBlur
/// 
/// ## C++ default parameters
/// * sigma_y: 0
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// gaussianBlur(const cv::GMat &, const cv::Size &, double, double, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:663
#[inline]
pub fn gaussian_blur(src: &crate::gapi::GMat, ksize: core::Size, sigma_x: f64, sigma_y: f64, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_gaussianBlur_const_GMatR_const_SizeR_double_double_int_const_ScalarR(src.as_raw_GMat(), &ksize, sigma_x, sigma_y, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a range-level threshold to each matrix element.
/// 
/// The function applies range-level thresholding to a single- or multiple-channel matrix.
/// It sets output pixel value to OxFF if the corresponding pixel value of input matrix is in specified range,or 0 otherwise.
/// 
/// Input and output matrices must be CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.inRange"
/// 
/// ## Parameters
/// * src: input matrix (CV_8UC1).
/// * threshLow: lower boundary value.
/// * threshUp: upper boundary value.
/// ## See also
/// threshold
// inRange(const cv::GMat &, const cv::GScalar &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1460
#[inline]
pub fn in_range(src: &crate::gapi::GMat, thresh_low: &crate::gapi::GScalar, thresh_up: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_inRange_const_GMatR_const_GScalarR_const_GScalarR(src.as_raw_GMat(), thresh_low.as_raw_GScalar(), thresh_up.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a mask to a matrix.
/// 
/// The function mask set value from given matrix if the corresponding pixel value in mask matrix set to true,
/// and set the matrix value to 0 otherwise.
/// 
/// Supported src matrix data types are @ref CV_8UC1, @ref CV_16SC1, @ref CV_16UC1. Supported mask data type is @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.mask"
/// ## Parameters
/// * src: input matrix.
/// * mask: input mask matrix.
// mask(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:841
#[inline]
pub fn mask(src: &crate::gapi::GMat, mask: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_mask_const_GMatR_const_GMatR(src.as_raw_GMat(), mask.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates per-element maximum of two matrices.
/// 
/// The function max calculates the per-element maximum of two matrices of the same size, number of channels and depth:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Cmax%20%28%20%5Ctexttt%7Bsrc1%7D%20%28I%29%2C%20%5Ctexttt%7Bsrc2%7D%20%28I%29%29)
///    where I is a multi-dimensional index of matrix elements. In case of
///    multi-channel matrices, each channel is processed independently.
/// Output matrix must be of the same size and depth as src1.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.max"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix of the same size and depth as src1.
/// ## See also
/// min, compare, cmpEQ, cmpGT, cmpGE
// max(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1239
#[inline]
pub fn max(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_max_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates one 3-channel matrix out of 3 single-channel ones.
/// 
/// The function merges several matrices to make a single multi-channel matrix. That is, each
/// element of the output matrix will be a concatenation of the elements of the input matrices, where
/// elements of i-th input matrix are treated as mv[i].channels()-element vectors.
/// Output matrix must be of @ref CV_8UC3 type.
/// 
/// The function split3 does the reverse operation.
/// 
/// 
/// Note:
///  - Function textual ID is "org.opencv.core.transform.merge3"
/// 
/// ## Parameters
/// * src1: first input @ref CV_8UC1 matrix to be merged.
/// * src2: second input @ref CV_8UC1 matrix to be merged.
/// * src3: third input @ref CV_8UC1 matrix to be merged.
/// ## See also
/// merge4, split4, split3
// merge3(const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1560
#[inline]
pub fn merge3(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, src3: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_merge3_const_GMatR_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat(), src3.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates one 4-channel matrix out of 4 single-channel ones.
/// 
/// The function merges several matrices to make a single multi-channel matrix. That is, each
/// element of the output matrix will be a concatenation of the elements of the input matrices, where
/// elements of i-th input matrix are treated as mv[i].channels()-element vectors.
/// Output matrix must be of @ref CV_8UC4 type.
/// 
/// The function split4 does the reverse operation.
/// 
/// 
/// Note:
///  - Function textual ID is "org.opencv.core.transform.merge4"
/// 
/// ## Parameters
/// * src1: first input @ref CV_8UC1 matrix to be merged.
/// * src2: second input @ref CV_8UC1 matrix to be merged.
/// * src3: third input @ref CV_8UC1 matrix to be merged.
/// * src4: fourth input @ref CV_8UC1 matrix to be merged.
/// ## See also
/// merge3, split4, split3
// merge4(const cv::GMat &, const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1541
#[inline]
pub fn merge4(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, src3: &crate::gapi::GMat, src4: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_merge4_const_GMatR_const_GMatR_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat(), src3.as_raw_GMat(), src4.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates per-element minimum of two matrices.
/// 
/// The function min calculates the per-element minimum of two matrices of the same size, number of channels and depth:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Cmin%20%28%20%5Ctexttt%7Bsrc1%7D%20%28I%29%2C%20%5Ctexttt%7Bsrc2%7D%20%28I%29%29)
///    where I is a multi-dimensional index of matrix elements. In case of
///    multi-channel matrices, each channel is processed independently.
/// Output matrix must be of the same size and depth as src1.
/// 
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.min"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix of the same size and depth as src1.
/// ## See also
/// max, cmpEQ, cmpLT, cmpLE
// min(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1222
#[inline]
pub fn min(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_min_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Performs advanced morphological transformations.
/// 
/// The function can perform advanced morphological transformations using an erosion and dilation as
/// basic operations.
/// 
/// Any of the operations can be done in-place. In case of multi-channel images, each channel is
/// processed independently.
/// 
/// 
/// Note:
///  - Function textual ID is "org.opencv.imgproc.filters.morphologyEx"
///  - The number of iterations is the number of times erosion or dilatation operation will be
/// applied. For instance, an opening operation (#MORPH_OPEN) with two iterations is equivalent to
/// apply successively: erode -> erode -> dilate -> dilate
/// (and not erode -> dilate -> erode -> dilate).
/// 
/// ## Parameters
/// * src: Input image.
/// * op: Type of a morphological operation, see #MorphTypes
/// * kernel: Structuring element. It can be created using #getStructuringElement.
/// * anchor: Anchor position within the element. Both negative values mean that the anchor is at
/// the kernel center.
/// * iterations: Number of times erosion and dilation are applied.
/// * borderType: Pixel extrapolation method, see #BorderTypes. #BORDER_WRAP is not supported.
/// * borderValue: Border value in case of a constant border. The default value has a special
/// meaning.
/// ## See also
/// dilate, erode, getStructuringElement
/// 
/// ## C++ default parameters
/// * anchor: Point(-1,-1)
/// * iterations: 1
/// * border_type: BORDER_CONSTANT
/// * border_value: morphologyDefaultBorderValue()
// morphologyEx(const cv::GMat &, const cv::MorphTypes, const cv::Mat &, const cv::Point &, const int, const cv::BorderTypes, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:807
#[inline]
pub fn morphology_ex(src: &crate::gapi::GMat, op: crate::imgproc::MorphTypes, kernel: &core::Mat, anchor: core::Point, iterations: i32, border_type: core::BorderTypes, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_morphologyEx_const_GMatR_const_MorphTypes_const_MatR_const_PointR_const_int_const_BorderTypes_const_ScalarR(src.as_raw_GMat(), op, kernel.as_raw_Mat(), &anchor, iterations, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Multiplies matrix by scalar.
/// 
/// The function mulC multiplies each element of matrix src by given scalar value:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bsaturate%7D%20%28%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%5Ccdot%20%5Ctexttt%7Bmultiplier%7D%20%29)
/// 
/// The matrices can be single or multi channel. Output matrix must have the same size as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.mulC"
/// ## Parameters
/// * src: input matrix.
/// * multiplier: factor to be multiplied.
/// * ddepth: optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## Overloaded parameters
/// 
/// ## C++ default parameters
/// * ddepth: -1
// mulC(const cv::GMat &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:764
#[inline]
pub fn mul_c_1(src: &crate::gapi::GMat, multiplier: &crate::gapi::GScalar, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_mulC_const_GMatR_const_GScalarR_int(src.as_raw_GMat(), multiplier.as_raw_GScalar(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Multiplies matrix by scalar.
/// 
/// The function mulC multiplies each element of matrix src by given scalar value:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bsaturate%7D%20%28%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%5Ccdot%20%5Ctexttt%7Bmultiplier%7D%20%29)
/// 
/// The matrices can be single or multi channel. Output matrix must have the same size as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.mulC"
/// ## Parameters
/// * src: input matrix.
/// * multiplier: factor to be multiplied.
/// * ddepth: optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## C++ default parameters
/// * ddepth: -1
// mulC(const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:762
#[inline]
pub fn mul_c(src: &crate::gapi::GMat, multiplier: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_mulC_const_GMatR_double_int(src.as_raw_GMat(), multiplier, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Multiplies matrix by scalar.
/// 
/// The function mulC multiplies each element of matrix src by given scalar value:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bsaturate%7D%20%28%20%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%5Ccdot%20%5Ctexttt%7Bmultiplier%7D%20%29)
/// 
/// The matrices can be single or multi channel. Output matrix must have the same size as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.mulC"
/// ## Parameters
/// * src: input matrix.
/// * multiplier: factor to be multiplied.
/// * ddepth: optional depth of the output matrix. If -1, the depth of output matrix will be the same as input matrix depth.
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## Overloaded parameters
/// 
/// ## C++ default parameters
/// * ddepth: -1
// mulC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:766
#[inline]
pub fn mul_c_2(multiplier: &crate::gapi::GScalar, src: &crate::gapi::GMat, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_mulC_const_GScalarR_const_GMatR_int(multiplier.as_raw_GScalar(), src.as_raw_GMat(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element scaled product of two matrices.
/// 
/// The function mul calculates the per-element product of two matrices:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bsaturate%7D%20%28%20%5Ctexttt%7Bscale%7D%20%5Ccdot%20%5Ctexttt%7Bsrc1%7D%20%28I%29%20%20%5Ccdot%20%5Ctexttt%7Bsrc2%7D%20%28I%29%29)
/// 
/// If src1.depth() == src2.depth(), ddepth can be set to the default -1. In this case, the output matrix will have
/// the same depth as the input matrices. The matrices can be single or multi channel.
/// Output matrix must have the same size as input matrices.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.mul"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix of the same size and the same depth as src1.
/// * scale: optional scale factor.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// add, sub, div, addWeighted
/// 
/// ## C++ default parameters
/// * scale: 1.0
/// * ddepth: -1
// mul(const cv::GMat &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:744
#[inline]
pub fn mul_4(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, scale: f64, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_mul_const_GMatR_const_GMatR_double_int(src1.as_raw_GMat(), src2.as_raw_GMat(), scale, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the absolute infinite norm of a matrix.
/// 
/// This version of normInf calculates the absolute infinite norm of src.
/// 
/// As example for one array consider the function ![inline formula](https://latex.codecogs.com/png.latex?r%28x%29%3D%20%5Cbegin%7Bpmatrix%7D%20x%20%5C%5C%201%2Dx%20%5Cend%7Bpmatrix%7D%2C%20x%20%5Cin%20%5B%2D1%3B1%5D).
/// The ![inline formula](https://latex.codecogs.com/png.latex?%20L%5F%7B%5Cinfty%7D%20) norm for the sample value ![inline formula](https://latex.codecogs.com/png.latex?r%28%2D1%29%20%3D%20%5Cbegin%7Bpmatrix%7D%20%2D1%20%5C%5C%202%20%5Cend%7Bpmatrix%7D)
/// is calculated as follows
/// \f{align*}
///    \| r(-1) \|_{L_\infty} &= \max(|-1|,|2|) = 2
/// \f}
/// and for ![inline formula](https://latex.codecogs.com/png.latex?r%280%2E5%29%20%3D%20%5Cbegin%7Bpmatrix%7D%200%2E5%20%5C%5C%200%2E5%20%5Cend%7Bpmatrix%7D) the calculation is
/// \f{align*}
///    \| r(0.5) \|_{L_\infty} &= \max(|0.5|,|0.5|) = 0.5.
/// \f}
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.norminf"
/// ## Parameters
/// * src: input matrix.
/// ## See also
/// normL1, normL2
// normInf(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1389
#[inline]
pub fn norm_inf(src: &crate::gapi::GMat) -> Result<crate::gapi::GScalar> {
	let ret = unsafe { sys::cv_gapi_normInf_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GScalar::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the  absolute L1 norm of a matrix.
/// 
/// This version of normL1 calculates the absolute L1 norm of src.
/// 
/// As example for one array consider the function ![inline formula](https://latex.codecogs.com/png.latex?r%28x%29%3D%20%5Cbegin%7Bpmatrix%7D%20x%20%5C%5C%201%2Dx%20%5Cend%7Bpmatrix%7D%2C%20x%20%5Cin%20%5B%2D1%3B1%5D).
/// The ![inline formula](https://latex.codecogs.com/png.latex?%20L%5F%7B1%7D%20) norm for the sample value ![inline formula](https://latex.codecogs.com/png.latex?r%28%2D1%29%20%3D%20%5Cbegin%7Bpmatrix%7D%20%2D1%20%5C%5C%202%20%5Cend%7Bpmatrix%7D)
/// is calculated as follows
/// \f{align*}
///    \| r(-1) \|_{L_1} &= |-1| + |2| = 3 \\
/// \f}
/// and for ![inline formula](https://latex.codecogs.com/png.latex?r%280%2E5%29%20%3D%20%5Cbegin%7Bpmatrix%7D%200%2E5%20%5C%5C%200%2E5%20%5Cend%7Bpmatrix%7D) the calculation is
/// \f{align*}
///    \| r(0.5) \|_{L_1} &= |0.5| + |0.5| = 1 \\
/// \f}
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.norml1"
/// ## Parameters
/// * src: input matrix.
/// ## See also
/// normL2, normInf
// normL1(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1344
#[inline]
pub fn norm_l1(src: &crate::gapi::GMat) -> Result<crate::gapi::GScalar> {
	let ret = unsafe { sys::cv_gapi_normL1_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GScalar::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the absolute L2 norm of a matrix.
/// 
/// This version of normL2 calculates the absolute L2 norm of src.
/// 
/// As example for one array consider the function ![inline formula](https://latex.codecogs.com/png.latex?r%28x%29%3D%20%5Cbegin%7Bpmatrix%7D%20x%20%5C%5C%201%2Dx%20%5Cend%7Bpmatrix%7D%2C%20x%20%5Cin%20%5B%2D1%3B1%5D).
/// The ![inline formula](https://latex.codecogs.com/png.latex?%20L%5F%7B2%7D%20)  norm for the sample value ![inline formula](https://latex.codecogs.com/png.latex?r%28%2D1%29%20%3D%20%5Cbegin%7Bpmatrix%7D%20%2D1%20%5C%5C%202%20%5Cend%7Bpmatrix%7D)
/// is calculated as follows
/// \f{align*}
///    \| r(-1) \|_{L_2} &= \sqrt{(-1)^{2} + (2)^{2}} = \sqrt{5} \\
/// \f}
/// and for ![inline formula](https://latex.codecogs.com/png.latex?r%280%2E5%29%20%3D%20%5Cbegin%7Bpmatrix%7D%200%2E5%20%5C%5C%200%2E5%20%5Cend%7Bpmatrix%7D) the calculation is
/// \f{align*}
///    \| r(0.5) \|_{L_2} &= \sqrt{(0.5)^{2} + (0.5)^{2}} = \sqrt{0.5} \\
/// \f}
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.norml2"
/// ## Parameters
/// * src: input matrix.
/// ## See also
/// normL1, normInf
// normL2(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1366
#[inline]
pub fn norm_l2(src: &crate::gapi::GMat) -> Result<crate::gapi::GScalar> {
	let ret = unsafe { sys::cv_gapi_normL2_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GScalar::opencv_from_extern(ret) };
	Ok(ret)
}

/// Normalizes the norm or value range of an array.
/// 
/// The function normalizes scale and shift the input array elements so that
/// ![block formula](https://latex.codecogs.com/png.latex?%5C%7C%20%5Ctexttt%7Bdst%7D%20%5C%7C%20%5F%7BL%5Fp%7D%3D%20%5Ctexttt%7Balpha%7D)
/// (where p=Inf, 1 or 2) when normType=NORM_INF, NORM_L1, or NORM_L2, respectively; or so that
/// ![block formula](https://latex.codecogs.com/png.latex?%5Cmin%20%5FI%20%20%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Balpha%7D%20%2C%20%5C%2C%20%5C%2C%20%5Cmax%20%5FI%20%20%5Ctexttt%7Bdst%7D%20%28I%29%3D%20%5Ctexttt%7Bbeta%7D)
/// when normType=NORM_MINMAX (for dense arrays only).
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.normalize"
/// 
/// ## Parameters
/// * src: input array.
/// * alpha: norm value to normalize to or the lower range boundary in case of the range
/// normalization.
/// * beta: upper range boundary in case of the range normalization; it is not used for the norm
/// normalization.
/// * norm_type: normalization type (see cv::NormTypes).
/// * ddepth: when negative, the output array has the same type as src; otherwise, it has the same
/// number of channels as src and the depth =ddepth.
/// ## See also
/// norm, Mat::convertTo
/// 
/// ## C++ default parameters
/// * ddepth: -1
// normalize(const cv::GMat &, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1814
#[inline]
pub fn normalize(src: &crate::gapi::GMat, alpha: f64, beta: f64, norm_type: i32, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_normalize_const_GMatR_double_double_int_int(src.as_raw_GMat(), alpha, beta, norm_type, ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// descr_of(const cv::gapi::own::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:262
#[inline]
pub fn descr_of_1(mat: &crate::gapi::Own_Mat) -> Result<crate::gapi::GMatDesc> {
	let ret = unsafe { sys::cv_gapi_own_descr_of_const_MatR(mat) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatDesc::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the rotation angle of 2D vectors.
/// 
/// The function cv::phase calculates the rotation angle of each 2D vector that
/// is formed from the corresponding elements of x and y :
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bangle%7D%20%28I%29%20%3D%20%20%5Ctexttt%7Batan2%7D%20%28%20%5Ctexttt%7By%7D%20%28I%29%2C%20%5Ctexttt%7Bx%7D%20%28I%29%29)
/// 
/// The angle estimation accuracy is about 0.3 degrees. When x(I)=y(I)=0 ,
/// the corresponding angle(I) is set to 0.
/// ## Parameters
/// * x: input floating-point array of x-coordinates of 2D vectors.
/// * y: input array of y-coordinates of 2D vectors; it must have the
/// same size and the same type as x.
/// * angleInDegrees: when true, the function calculates the angle in
/// degrees, otherwise, they are measured in radians.
/// ## Returns
/// array of vector angles; it has the same size and same type as x.
/// 
/// ## C++ default parameters
/// * angle_in_degrees: false
// phase(const cv::GMat &, const cv::GMat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:918
#[inline]
pub fn phase(x: &crate::gapi::GMat, y: &crate::gapi::GMat, angle_in_degrees: bool) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_phase_const_GMatR_const_GMatR_bool(x.as_raw_GMat(), y.as_raw_GMat(), angle_in_degrees) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a generic geometrical transformation to an image.
/// 
/// The function remap transforms the source image using the specified map:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Ctexttt%7Bsrc%7D%20%28map%5Fx%28x%2Cy%29%2Cmap%5Fy%28x%2Cy%29%29)
/// 
/// where values of pixels with non-integer coordinates are computed using one of available
/// interpolation methods. ![inline formula](https://latex.codecogs.com/png.latex?map%5Fx) and ![inline formula](https://latex.codecogs.com/png.latex?map%5Fy) can be encoded as separate floating-point maps
/// in ![inline formula](https://latex.codecogs.com/png.latex?map%5F1) and ![inline formula](https://latex.codecogs.com/png.latex?map%5F2) respectively, or interleaved floating-point maps of ![inline formula](https://latex.codecogs.com/png.latex?%28x%2Cy%29) in
/// ![inline formula](https://latex.codecogs.com/png.latex?map%5F1), or fixed-point maps created by using convertMaps. The reason you might want to
/// convert from floating to fixed-point representations of a map is that they can yield much faster
/// (\~2x) remapping operations. In the converted case, ![inline formula](https://latex.codecogs.com/png.latex?map%5F1) contains pairs (cvFloor(x),
/// cvFloor(y)) and ![inline formula](https://latex.codecogs.com/png.latex?map%5F2) contains indices in a table of interpolation coefficients.
/// Output image must be of the same size and depth as input one.
/// 
/// 
/// Note:
///  - Function textual ID is "org.opencv.core.transform.remap"
///  - Due to current implementation limitations the size of an input and output images should be less than 32767x32767.
/// 
/// ## Parameters
/// * src: Source image.
/// * map1: The first map of either (x,y) points or just x values having the type CV_16SC2,
/// CV_32FC1, or CV_32FC2.
/// * map2: The second map of y values having the type CV_16UC1, CV_32FC1, or none (empty map
/// if map1 is (x,y) points), respectively.
/// * interpolation: Interpolation method (see cv::InterpolationFlags). The methods #INTER_AREA
/// and #INTER_LINEAR_EXACT are not supported by this function.
/// * borderMode: Pixel extrapolation method (see cv::BorderTypes). When
/// borderMode=BORDER_TRANSPARENT, it means that the pixels in the destination image that
/// corresponds to the "outliers" in the source image are not modified by the function.
/// * borderValue: Value used in case of a constant border. By default, it is 0.
/// 
/// ## C++ default parameters
/// * border_mode: BORDER_CONSTANT
/// * border_value: Scalar()
// remap(const cv::GMat &, const cv::Mat &, const cv::Mat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1627
#[inline]
pub fn remap(src: &crate::gapi::GMat, map1: &core::Mat, map2: &core::Mat, interpolation: i32, border_mode: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_remap_const_GMatR_const_MatR_const_MatR_int_int_const_ScalarR(src.as_raw_GMat(), map1.as_raw_Mat(), map2.as_raw_Mat(), interpolation, border_mode, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Resizes a planar image.
/// 
/// The function resizes the image src down to or up to the specified size.
/// Planar image memory layout is three planes laying in the memory contiguously,
/// so the image height should be plane_height*plane_number, image type is @ref CV_8UC1.
/// 
/// Output image size will have the size dsize, the depth of output is the same as of src.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.transform.resizeP"
/// 
/// ## Parameters
/// * src: input image, must be of @ref CV_8UC1 type;
/// * dsize: output image size;
/// * interpolation: interpolation method, only cv::INTER_LINEAR is supported at the moment
/// ## See also
/// warpAffine, warpPerspective, remap, resize
/// 
/// ## C++ default parameters
/// * interpolation: cv::INTER_LINEAR
// resizeP(const cv::GMatP &, const cv::Size &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1521
#[inline]
pub fn resize_p(src: &crate::gapi::GMatP, dsize: core::Size, interpolation: i32) -> Result<crate::gapi::GMatP> {
	let ret = unsafe { sys::cv_gapi_resizeP_const_GMatPR_const_SizeR_int(src.as_raw_GMatP(), &dsize, interpolation) }.into_result()?;
	let ret = unsafe { crate::gapi::GMatP::opencv_from_extern(ret) };
	Ok(ret)
}

/// Select values from either first or second of input matrices by given mask.
/// The function set to the output matrix either the value from the first input matrix if corresponding value of mask matrix is 255,
///  or value from the second input matrix (if value of mask matrix set to 0).
/// 
/// Input mask matrix must be of @ref CV_8UC1 type, two other inout matrices and output matrix should be of the same type. The size should
/// be the same for all input and output matrices.
/// Supported input matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.pixelwise.select"
/// 
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// * mask: mask input matrix.
// select(const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1200
#[inline]
pub fn select(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, mask: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_select_const_GMatR_const_GMatR_const_GMatR(src1.as_raw_GMat(), src2.as_raw_GMat(), mask.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a separable linear filter to a matrix(image).
/// 
/// The function applies a separable linear filter to the matrix. That is, first, every row of src is
/// filtered with the 1D kernel kernelX. Then, every column of the result is filtered with the 1D
/// kernel kernelY. The final result is returned.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// Output image must have the same type, size, and number of channels as the input image.
/// 
/// Note:
///  - In case of floating-point computation, rounding to nearest even is procedeed
/// if hardware supports it (if not - to nearest value).
///  - Function textual ID is "org.opencv.imgproc.filters.sepfilter"
/// ## Parameters
/// * src: Source image.
/// * ddepth: desired depth of the destination image (the following combinations of src.depth() and ddepth are supported:
/// 
///        src.depth() = CV_8U, ddepth = -1/CV_16S/CV_32F/CV_64F
///        src.depth() = CV_16U/CV_16S, ddepth = -1/CV_32F/CV_64F
///        src.depth() = CV_32F, ddepth = -1/CV_32F/CV_64F
///        src.depth() = CV_64F, ddepth = -1/CV_64F
/// 
/// when ddepth=-1, the output image will have the same depth as the source)
/// * kernelX: Coefficients for filtering each row.
/// * kernelY: Coefficients for filtering each column.
/// * anchor: Anchor position within the kernel. The default value ![inline formula](https://latex.codecogs.com/png.latex?%28%2D1%2C%2D1%29) means that the anchor
/// is at the kernel center.
/// * delta: Value added to the filtered results before storing them.
/// * borderType: Pixel extrapolation method, see cv::BorderTypes
/// * borderValue: border value in case of constant border type
/// ## See also
/// boxFilter, gaussianBlur, medianBlur
/// 
/// ## C++ default parameters
/// * border_type: BORDER_DEFAULT
/// * border_value: Scalar(0)
// sepFilter(const cv::GMat &, int, const cv::Mat &, const cv::Mat &, const cv::Point &, const cv::Scalar &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:532
#[inline]
pub fn sep_filter(src: &crate::gapi::GMat, ddepth: i32, kernel_x: &core::Mat, kernel_y: &core::Mat, anchor: core::Point, delta: core::Scalar, border_type: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_sepFilter_const_GMatR_int_const_MatR_const_MatR_const_PointR_const_ScalarR_int_const_ScalarR(src.as_raw_GMat(), ddepth, kernel_x.as_raw_Mat(), kernel_y.as_raw_Mat(), &anchor, &delta, border_type, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates a square root of array elements.
/// 
/// The function cv::gapi::sqrt calculates a square root of each input array element.
/// In case of multi-channel arrays, each channel is processed
/// independently. The accuracy is approximately the same as of the built-in
/// std::sqrt .
/// ## Parameters
/// * src: input floating-point array.
/// ## Returns
/// output array of the same size and type as src.
// sqrt(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:929
#[inline]
pub fn sqrt(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_sqrt_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Gets bgr plane from input frame
/// 
/// 
/// Note: Function textual ID is "org.opencv.streaming.BGR"
/// 
/// ## Parameters
/// * in: Input frame
/// ## Returns
/// Image in BGR format
// BGR(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:43
#[inline]
pub fn bgr(in_: &crate::gapi::GFrame) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_streaming_BGR_const_GFrameR(in_.as_raw_GFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Extracts UV plane from media frame.
/// 
/// Output image is 8-bit 2-channel image of @ref CV_8UC2.
/// 
/// 
/// Note: Function textual ID is "org.opencv.streaming.UV"
/// 
/// ## Parameters
/// * frame: input media frame.
// UV(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:63
#[inline]
pub fn uv(frame: &crate::gapi::GFrame) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_streaming_UV_const_GFrameR(frame.as_raw_GFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Extracts Y plane from media frame.
/// 
/// Output image is 8-bit 1-channel image of @ref CV_8UC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.streaming.Y"
/// 
/// ## Parameters
/// * frame: input media frame.
// Y(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:53
#[inline]
pub fn y(frame: &crate::gapi::GFrame) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_streaming_Y_const_GFrameR(frame.as_raw_GFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// desync(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/desync.hpp:79
#[inline]
pub fn desync_1(f: &crate::gapi::GFrame) -> Result<crate::gapi::GFrame> {
	let ret = unsafe { sys::cv_gapi_streaming_desync_const_GFrameR(f.as_raw_GFrame()) }.into_result()?;
	let ret = unsafe { crate::gapi::GFrame::opencv_from_extern(ret) };
	Ok(ret)
}

/// Starts a desynchronized branch in the graph.
/// 
/// This operation takes a single G-API data object and returns a
/// graph-level "duplicate" of this object.
/// 
/// Operations which use this data object can be desynchronized
/// from the rest of the graph.
/// 
/// This operation has no effect when a GComputation is compiled with
/// regular cv::GComputation::compile(), since cv::GCompiled objects
/// always produce their full output vectors.
/// 
/// This operation only makes sense when a GComputation is compiled in
/// straming mode with cv::GComputation::compileStreaming(). If this
/// operation is used and there are desynchronized outputs, the user
/// should use a special version of cv::GStreamingCompiled::pull()
/// which produces an array of cv::util::optional<> objects.
/// 
/// 
/// Note: This feature is highly experimental now and is currently
/// limited to a single GMat/GFrame argument only.
// desync(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/desync.hpp:78
#[inline]
pub fn desync(g: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_streaming_desync_const_GMatR(g.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// kernels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:16
#[inline]
pub fn kernels() -> Result<crate::gapi::GKernelPackage> {
	let ret = unsafe { sys::cv_gapi_streaming_kernels() }.into_result()?;
	let ret = unsafe { crate::gapi::GKernelPackage::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element difference between matrix and given scalar.
/// 
/// The function can be replaced with matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%5Ctexttt%7Bsrc%7D%20%2D%20%5Ctexttt%7Bc%7D)
/// 
/// Depth of the output matrix is determined by the ddepth parameter.
/// If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.
/// The matrices can be single or multi channel. Output matrix must have the same size as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.subC"
/// ## Parameters
/// * src: first input matrix.
/// * c: scalar value to subtracted.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// add, addC, subRC
/// 
/// ## C++ default parameters
/// * ddepth: -1
// subC(const cv::GMat &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:704
#[inline]
pub fn sub_c(src: &crate::gapi::GMat, c: &crate::gapi::GScalar, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_subC_const_GMatR_const_GScalarR_int(src.as_raw_GMat(), c.as_raw_GScalar(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element difference between given scalar and the matrix.
/// 
/// The function can be replaced with matrix expressions:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%5Ctexttt%7Bval%7D%20%2D%20%5Ctexttt%7Bsrc%7D)
/// 
/// Depth of the output matrix is determined by the ddepth parameter.
/// If ddepth is set to default -1, the depth of output matrix will be the same as the depth of input matrix.
/// The matrices can be single or multi channel. Output matrix must have the same size as src.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.subRC"
/// ## Parameters
/// * c: scalar value to subtract from.
/// * src: input matrix to be subtracted.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// add, addC, subC
/// 
/// ## C++ default parameters
/// * ddepth: -1
// subRC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:723
#[inline]
pub fn sub_rc(c: &crate::gapi::GScalar, src: &crate::gapi::GMat, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_subRC_const_GScalarR_const_GMatR_int(c.as_raw_GScalar(), src.as_raw_GMat(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates the per-element difference between two matrices.
/// 
/// The function sub calculates difference between two matrices, when both matrices have the same size and the same number of
/// channels:
///    ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%28I%29%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%28I%29%20%2D%20%20%5Ctexttt%7Bsrc2%7D%28I%29)
/// 
/// The function can be replaced with matrix expressions:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%3D%20%20%20%5Ctexttt%7Bsrc1%7D%20%2D%20%20%5Ctexttt%7Bsrc2%7D)
/// 
/// The input matrices and the output matrix can all have the same or different depths. For example, you
/// can subtract two 8-bit unsigned matrices store the result as a 16-bit signed matrix.
/// Depth of the output matrix is determined by the ddepth parameter.
/// If src1.depth() == src2.depth(), ddepth can be set to the default -1. In this case, the output matrix will have
/// the same depth as the input matrices. The matrices can be single or multi channel.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.math.sub"
/// ## Parameters
/// * src1: first input matrix.
/// * src2: second input matrix.
/// * ddepth: optional depth of the output matrix.
/// ## See also
/// add, addC
/// 
/// ## C++ default parameters
/// * ddepth: -1
// sub(const cv::GMat &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:685
#[inline]
pub fn sub_3(src1: &crate::gapi::GMat, src2: &crate::gapi::GMat, ddepth: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_sub_const_GMatR_const_GMatR_int(src1.as_raw_GMat(), src2.as_raw_GMat(), ddepth) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Calculates sum of all matrix elements.
/// 
/// The function sum calculates sum of all matrix elements, independently for each channel.
/// 
/// Supported matrix data types are @ref CV_8UC1, @ref CV_8UC3, @ref CV_16UC1, @ref CV_16SC1, @ref CV_32FC1.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.sum"
/// ## Parameters
/// * src: input matrix.
/// ## See also
/// countNonZero, mean, min, max
// sum(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1285
#[inline]
pub fn sum(src: &crate::gapi::GMat) -> Result<crate::gapi::GScalar> {
	let ret = unsafe { sys::cv_gapi_sum_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GScalar::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a fixed-level threshold to each matrix element.
/// 
/// The function applies fixed-level thresholding to a single- or multiple-channel matrix.
/// The function is typically used to get a bi-level (binary) image out of a grayscale image ( cmp functions could be also used for
/// this purpose) or for removing a noise, that is, filtering out pixels with too small or too large
/// values. There are several types of thresholding supported by the function. They are determined by
/// type parameter.
/// 
/// Also, the special values cv::THRESH_OTSU or cv::THRESH_TRIANGLE may be combined with one of the
/// above values. In these cases, the function determines the optimal threshold value using the Otsu's
/// or Triangle algorithm and uses it instead of the specified thresh . The function returns the
/// computed threshold value in addititon to thresholded matrix.
/// The Otsu's and Triangle methods are implemented only for 8-bit matrices.
/// 
/// Input image should be single channel only in case of cv::THRESH_OTSU or cv::THRESH_TRIANGLE flags.
/// Output matrix must be of the same size and depth as src.
/// 
/// 
/// Note: Function textual ID is "org.opencv.core.matrixop.threshold"
/// 
/// ## Parameters
/// * src: input matrix (@ref CV_8UC1, @ref CV_8UC3, or @ref CV_32FC1).
/// * thresh: threshold value.
/// * maxval: maximum value to use with the cv::THRESH_BINARY and cv::THRESH_BINARY_INV thresholding
/// types.
/// * type: thresholding type (see the cv::ThresholdTypes).
/// ## See also
/// min, max, cmpGT, cmpLE, cmpGE, cmpLT
// threshold(const cv::GMat &, const cv::GScalar &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1438
#[inline]
pub fn threshold(src: &crate::gapi::GMat, thresh: &crate::gapi::GScalar, maxval: &crate::gapi::GScalar, typ: i32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_threshold_const_GMatR_const_GScalarR_const_GScalarR_int(src.as_raw_GMat(), thresh.as_raw_GScalar(), maxval.as_raw_GScalar(), typ) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Transposes a matrix.
/// 
/// The function transposes the matrix:
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28i%2Cj%29%20%3D%20%20%5Ctexttt%7Bsrc%7D%20%28j%2Ci%29)
/// 
/// 
/// Note:
///  - Function textual ID is "org.opencv.core.transpose"
///  - No complex conjugation is done in case of a complex matrix. It should be done separately if needed.
/// 
/// ## Parameters
/// * src: input array.
// transpose(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1952
#[inline]
pub fn transpose(src: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_transpose_const_GMatR(src.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies an affine transformation to an image.
/// 
/// The function warpAffine transforms the source image using the specified matrix:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Ctexttt%7Bsrc%7D%20%28%20%5Ctexttt%7BM%7D%20%5F%7B11%7D%20x%20%2B%20%20%5Ctexttt%7BM%7D%20%5F%7B12%7D%20y%20%2B%20%20%5Ctexttt%7BM%7D%20%5F%7B13%7D%2C%20%5Ctexttt%7BM%7D%20%5F%7B21%7D%20x%20%2B%20%20%5Ctexttt%7BM%7D%20%5F%7B22%7D%20y%20%2B%20%20%5Ctexttt%7BM%7D%20%5F%7B23%7D%29)
/// 
/// when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted
/// with #invertAffineTransform and then put in the formula above instead of M. The function cannot
/// operate in-place.
/// 
/// ## Parameters
/// * src: input image.
/// * M: ![inline formula](https://latex.codecogs.com/png.latex?2%5Ctimes%203) transformation matrix.
/// * dsize: size of the output image.
/// * flags: combination of interpolation methods (see #InterpolationFlags) and the optional
/// flag #WARP_INVERSE_MAP that means that M is the inverse transformation (
/// ![inline formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%5Crightarrow%5Ctexttt%7Bsrc%7D) ).
/// * borderMode: pixel extrapolation method (see #BorderTypes);
/// borderMode=#BORDER_TRANSPARENT isn't supported
/// * borderValue: value used in case of a constant border; by default, it is 0.
/// ## See also
/// warpPerspective, resize, remap, getRectSubPix, transform
/// 
/// ## C++ default parameters
/// * flags: cv::INTER_LINEAR
/// * border_mode: cv::BORDER_CONSTANT
/// * border_value: Scalar()
// warpAffine(const cv::GMat &, const cv::Mat &, const cv::Size &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1863
#[inline]
pub fn warp_affine(src: &crate::gapi::GMat, m: &core::Mat, dsize: core::Size, flags: i32, border_mode: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_warpAffine_const_GMatR_const_MatR_const_SizeR_int_int_const_ScalarR(src.as_raw_GMat(), m.as_raw_Mat(), &dsize, flags, border_mode, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

/// Applies a perspective transformation to an image.
/// 
/// The function warpPerspective transforms the source image using the specified matrix:
/// 
/// ![block formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%20%28x%2Cy%29%20%3D%20%20%5Ctexttt%7Bsrc%7D%20%5Cleft%20%28%20%5Cfrac%7BM%5F%7B11%7D%20x%20%2B%20M%5F%7B12%7D%20y%20%2B%20M%5F%7B13%7D%7D%7BM%5F%7B31%7D%20x%20%2B%20M%5F%7B32%7D%20y%20%2B%20M%5F%7B33%7D%7D%20%2C%0A%20%20%20%20%20%5Cfrac%7BM%5F%7B21%7D%20x%20%2B%20M%5F%7B22%7D%20y%20%2B%20M%5F%7B23%7D%7D%7BM%5F%7B31%7D%20x%20%2B%20M%5F%7B32%7D%20y%20%2B%20M%5F%7B33%7D%7D%20%5Cright%20%29)
/// 
/// when the flag #WARP_INVERSE_MAP is set. Otherwise, the transformation is first inverted with invert
/// and then put in the formula above instead of M. The function cannot operate in-place.
/// 
/// ## Parameters
/// * src: input image.
/// * M: ![inline formula](https://latex.codecogs.com/png.latex?3%5Ctimes%203) transformation matrix.
/// * dsize: size of the output image.
/// * flags: combination of interpolation methods (#INTER_LINEAR or #INTER_NEAREST) and the
/// optional flag #WARP_INVERSE_MAP, that sets M as the inverse transformation (
/// ![inline formula](https://latex.codecogs.com/png.latex?%5Ctexttt%7Bdst%7D%5Crightarrow%5Ctexttt%7Bsrc%7D) ).
/// * borderMode: pixel extrapolation method (#BORDER_CONSTANT or #BORDER_REPLICATE).
/// * borderValue: value used in case of a constant border; by default, it equals 0.
/// ## See also
/// warpAffine, resize, remap, getRectSubPix, perspectiveTransform
/// 
/// ## C++ default parameters
/// * flags: cv::INTER_LINEAR
/// * border_mode: cv::BORDER_CONSTANT
/// * border_value: Scalar()
// warpPerspective(const cv::GMat &, const cv::Mat &, const cv::Size &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1838
#[inline]
pub fn warp_perspective(src: &crate::gapi::GMat, m: &core::Mat, dsize: core::Size, flags: i32, border_mode: i32, border_value: core::Scalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_gapi_warpPerspective_const_GMatR_const_MatR_const_SizeR_int_int_const_ScalarR(src.as_raw_GMat(), m.as_raw_Mat(), &dsize, flags, border_mode, &border_value) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator+(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:16
#[inline]
pub fn add(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorA_const_GMatR_const_GMatR(lhs.as_raw_GMat(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator+(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:18
#[inline]
pub fn add_1(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorA_const_GMatR_const_GScalarR(lhs.as_raw_GMat(), rhs.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator+(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:19
#[inline]
pub fn add_2(lhs: &crate::gapi::GScalar, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorA_const_GScalarR_const_GMatR(lhs.as_raw_GScalar(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator/(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:33
#[inline]
pub fn div_2(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorD_const_GMatR_const_GMatR(lhs.as_raw_GMat(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator/(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:31
#[inline]
pub fn div(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorD_const_GMatR_const_GScalarR(lhs.as_raw_GMat(), rhs.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator/(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:32
#[inline]
pub fn div_1(lhs: &crate::gapi::GScalar, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorD_const_GScalarR_const_GMatR(lhs.as_raw_GScalar(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator==(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:52
#[inline]
pub fn equals(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorEQ_const_GMatR_const_GMatR(lhs.as_raw_GMat(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator==(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:59
#[inline]
pub fn equals_1(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorEQ_const_GMatR_const_GScalarR(lhs.as_raw_GMat(), rhs.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator==(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:66
#[inline]
pub fn equals_2(lhs: &crate::gapi::GScalar, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorEQ_const_GScalarR_const_GMatR(lhs.as_raw_GScalar(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator-(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:21
#[inline]
pub fn sub(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorS_const_GMatR_const_GMatR(lhs.as_raw_GMat(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator-(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:23
#[inline]
pub fn sub_1(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorS_const_GMatR_const_GScalarR(lhs.as_raw_GMat(), rhs.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator-(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:24
#[inline]
pub fn sub_2(lhs: &crate::gapi::GScalar, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorS_const_GScalarR_const_GMatR(lhs.as_raw_GScalar(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator*(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:28
#[inline]
pub fn mul_2(lhs: &crate::gapi::GMat, rhs: &crate::gapi::GScalar) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorX_const_GMatR_const_GScalarR(lhs.as_raw_GMat(), rhs.as_raw_GScalar()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator*(const cv::GMat &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:26
#[inline]
pub fn mul(lhs: &crate::gapi::GMat, rhs: f32) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorX_const_GMatR_float(lhs.as_raw_GMat(), rhs) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator*(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:29
#[inline]
pub fn mul_3(lhs: &crate::gapi::GScalar, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorX_const_GScalarR_const_GMatR(lhs.as_raw_GScalar(), rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// operator*(float, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:27
#[inline]
pub fn mul_1(lhs: f32, rhs: &crate::gapi::GMat) -> Result<crate::gapi::GMat> {
	let ret = unsafe { sys::cv_operatorX_float_const_GMatR(lhs, rhs.as_raw_GMat()) }.into_result()?;
	let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
	Ok(ret)
}

// validate_input_arg(const cv::GRunArg &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gproto.hpp:154
#[inline]
pub fn validate_input_arg(arg: &crate::gapi::GRunArg) -> Result<()> {
	let ret = unsafe { sys::cv_validate_input_arg_const_GRunArgR(arg.as_raw_GRunArg()) }.into_result()?;
	Ok(ret)
}

// validate_input_args(const cv::GRunArgs &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gproto.hpp:155
#[inline]
pub fn validate_input_args(args: &crate::gapi::GRunArgs) -> Result<()> {
	let ret = unsafe { sys::cv_validate_input_args_const_GRunArgsR(args.as_raw_VectorOfGRunArg()) }.into_result()?;
	Ok(ret)
}

// GArg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:46
pub trait GArgTraitConst {
	fn as_raw_GArg(&self) -> *const c_void;

	// kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:87
	#[inline]
	fn kind(&self) -> crate::gapi::ArgKind {
		let ret = unsafe { sys::cv_GArg_getPropKind_const(self.as_raw_GArg()) };
		ret
	}
	
	// opaque_kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:88
	#[inline]
	fn opaque_kind(&self) -> crate::gapi::OpaqueKind {
		let ret = unsafe { sys::cv_GArg_getPropOpaque_kind_const(self.as_raw_GArg()) };
		ret
	}
	
}

pub trait GArgTrait: crate::gapi::GArgTraitConst {
	fn as_raw_mut_GArg(&mut self) -> *mut c_void;

	/// ## C++ default parameters
	/// * val: detail::ArgKind::OPAQUE_VAL
	// kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:87
	#[inline]
	fn set_kind(&mut self, val: crate::gapi::ArgKind) {
		let ret = unsafe { sys::cv_GArg_setPropKind_ArgKind(self.as_raw_mut_GArg(), val) };
		ret
	}
	
	/// ## C++ default parameters
	/// * val: detail::OpaqueKind::CV_UNKNOWN
	// opaque_kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:88
	#[inline]
	fn set_opaque_kind(&mut self, val: crate::gapi::OpaqueKind) {
		let ret = unsafe { sys::cv_GArg_setPropOpaque_kind_OpaqueKind(self.as_raw_mut_GArg(), val) };
		ret
	}
	
}

// GArg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:46
pub struct GArg {
	ptr: *mut c_void
}

opencv_type_boxed! { GArg }

impl Drop for GArg {
	fn drop(&mut self) {
		extern "C" { fn cv_GArg_delete(instance: *mut c_void); }
		unsafe { cv_GArg_delete(self.as_raw_mut_GArg()) };
	}
}

unsafe impl Send for GArg {}

impl crate::gapi::GArgTraitConst for GArg {
	#[inline] fn as_raw_GArg(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GArgTrait for GArg {
	#[inline] fn as_raw_mut_GArg(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GArg {
	// GArg() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:49
	#[inline]
	pub fn default() -> Result<crate::gapi::GArg> {
		let ret = unsafe { sys::cv_GArg_GArg() }.into_result()?;
		let ret = unsafe { crate::gapi::GArg::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

// GCall /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:26
pub trait GCallTraitConst {
	fn as_raw_GCall(&self) -> *const c_void;

}

pub trait GCallTrait: crate::gapi::GCallTraitConst {
	fn as_raw_mut_GCall(&mut self) -> *mut c_void;

	/// ## C++ default parameters
	/// * output: 0
	// yield(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:42
	#[inline]
	fn yield_(&mut self, output: i32) -> Result<crate::gapi::GMat> {
		let ret = unsafe { sys::cv_GCall_yield_int(self.as_raw_mut_GCall(), output) }.into_result()?;
		let ret = unsafe { crate::gapi::GMat::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// ## C++ default parameters
	/// * output: 0
	// yieldP(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:43
	#[inline]
	fn yield_p(&mut self, output: i32) -> Result<crate::gapi::GMatP> {
		let ret = unsafe { sys::cv_GCall_yieldP_int(self.as_raw_mut_GCall(), output) }.into_result()?;
		let ret = unsafe { crate::gapi::GMatP::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// ## C++ default parameters
	/// * output: 0
	// yieldScalar(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:44
	#[inline]
	fn yield_scalar(&mut self, output: i32) -> Result<crate::gapi::GScalar> {
		let ret = unsafe { sys::cv_GCall_yieldScalar_int(self.as_raw_mut_GCall(), output) }.into_result()?;
		let ret = unsafe { crate::gapi::GScalar::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// ## C++ default parameters
	/// * output: 0
	// yieldFrame(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:45
	#[inline]
	fn yield_frame(&mut self, output: i32) -> Result<crate::gapi::GFrame> {
		let ret = unsafe { sys::cv_GCall_yieldFrame_int(self.as_raw_mut_GCall(), output) }.into_result()?;
		let ret = unsafe { crate::gapi::GFrame::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// kernel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:63
	#[inline]
	fn kernel(&mut self) -> Result<crate::gapi::GKernel> {
		let ret = unsafe { sys::cv_GCall_kernel(self.as_raw_mut_GCall()) }.into_result()?;
		let ret = unsafe { crate::gapi::GKernel::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:64
	#[inline]
	fn params(&mut self) -> Result<crate::gapi::any> {
		let ret = unsafe { sys::cv_GCall_params(self.as_raw_mut_GCall()) }.into_result()?;
		Ok(ret)
	}
	
	// setArgs(std::vector<GArg> &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:66
	#[inline]
	fn set_args(&mut self, args: &mut core::Vector<crate::gapi::GArg>) -> Result<()> {
		let ret = unsafe { sys::cv_GCall_setArgs_vector_GArg_R(self.as_raw_mut_GCall(), args.as_raw_mut_VectorOfGArg()) }.into_result()?;
		Ok(ret)
	}
	
}

// GCall /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:26
pub struct GCall {
	ptr: *mut c_void
}

opencv_type_boxed! { GCall }

impl Drop for GCall {
	fn drop(&mut self) {
		extern "C" { fn cv_GCall_delete(instance: *mut c_void); }
		unsafe { cv_GCall_delete(self.as_raw_mut_GCall()) };
	}
}

unsafe impl Send for GCall {}

impl crate::gapi::GCallTraitConst for GCall {
	#[inline] fn as_raw_GCall(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GCallTrait for GCall {
	#[inline] fn as_raw_mut_GCall(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GCall {
	// GCall(const cv::GKernel &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:31
	#[inline]
	pub fn new(k: &crate::gapi::GKernel) -> Result<crate::gapi::GCall> {
		let ret = unsafe { sys::cv_GCall_GCall_const_GKernelR(k.as_raw_GKernel()) }.into_result()?;
		let ret = unsafe { crate::gapi::GCall::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

/// \addtogroup gapi_main_classes
/// /
/// 
///  Represents a compiled computation (graph). Can only be used
///  with image / data formats & resolutions it was compiled for, with
///  some exceptions.
/// 
///  This class represents a product of graph compilation (calling
///  cv::GComputation::compile()). Objects of this class actually do
///  data processing, and graph execution is incapsulated into objects
///  of this class. Execution model itself depends on kernels and
///  backends which were using during the compilation, see @ref
///  gapi_compile_args for details.
/// 
///  In a general case, GCompiled objects can be applied to data only in
///  that formats/resolutions they were compiled for (see @ref
///  gapi_meta_args). However, if the underlying backends allow, a
///  compiled object can be _reshaped_ to handle data (images) of
///  different resolution, though formats and types must remain the same.
/// 
///  GCompiled is very similar to `std::function<>` in its semantics --
///  running it looks like a function call in the user code.
/// 
///  At the moment, GCompiled objects are not reentrant -- generally,
///  the objects are stateful since graph execution itself is a stateful
///  process and this state is now maintained in GCompiled's own memory
///  (not on the process stack).
/// 
///  At the same time, two different GCompiled objects produced from the
///  single cv::GComputation are completely independent and can be used
///  concurrently.
/// ## See also
/// GStreamingCompiled
// GCompiled /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:66
pub trait GCompiledTraitConst {
	fn as_raw_GCompiled(&self) -> *const c_void;

	/// Check if compiled object is valid (non-empty)
	/// 
	/// ## Returns
	/// true if the object is runnable (valid), false otherwise
	// operator bool() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:165
	#[inline]
	fn to_bool(&self) -> Result<bool> {
		let ret = unsafe { sys::cv_GCompiled_operator_bool_const(self.as_raw_GCompiled()) }.into_result()?;
		Ok(ret)
	}
	
	/// Check if the underlying backends support reshape or not.
	/// 
	/// ## Returns
	/// true if supported, false otherwise.
	// canReshape() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:196
	#[inline]
	fn can_reshape(&self) -> Result<bool> {
		let ret = unsafe { sys::cv_GCompiled_canReshape_const(self.as_raw_GCompiled()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait GCompiledTrait: crate::gapi::GCompiledTraitConst {
	fn as_raw_mut_GCompiled(&mut self) -> *mut c_void;

	/// Prepare inner kernels states for a new video-stream.
	/// 
	/// GCompiled objects may be used to process video streams frame by frame.
	/// In this case, a GCompiled is called on every image frame individually.
	/// Starting OpenCV 4.4, some kernels in the graph may have their internal
	/// states (see GAPI_OCV_KERNEL_ST for the OpenCV backend).
	/// In this case, if user starts processing another video stream with
	/// this GCompiled, this method needs to be called to let kernels re-initialize
	/// their internal states to a new video stream.
	// prepareForNewStream() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:222
	#[inline]
	fn prepare_for_new_stream(&mut self) -> Result<()> {
		let ret = unsafe { sys::cv_GCompiled_prepareForNewStream(self.as_raw_mut_GCompiled()) }.into_result()?;
		Ok(ret)
	}
	
}

/// \addtogroup gapi_main_classes
/// /
/// 
///  Represents a compiled computation (graph). Can only be used
///  with image / data formats & resolutions it was compiled for, with
///  some exceptions.
/// 
///  This class represents a product of graph compilation (calling
///  cv::GComputation::compile()). Objects of this class actually do
///  data processing, and graph execution is incapsulated into objects
///  of this class. Execution model itself depends on kernels and
///  backends which were using during the compilation, see @ref
///  gapi_compile_args for details.
/// 
///  In a general case, GCompiled objects can be applied to data only in
///  that formats/resolutions they were compiled for (see @ref
///  gapi_meta_args). However, if the underlying backends allow, a
///  compiled object can be _reshaped_ to handle data (images) of
///  different resolution, though formats and types must remain the same.
/// 
///  GCompiled is very similar to `std::function<>` in its semantics --
///  running it looks like a function call in the user code.
/// 
///  At the moment, GCompiled objects are not reentrant -- generally,
///  the objects are stateful since graph execution itself is a stateful
///  process and this state is now maintained in GCompiled's own memory
///  (not on the process stack).
/// 
///  At the same time, two different GCompiled objects produced from the
///  single cv::GComputation are completely independent and can be used
///  concurrently.
/// ## See also
/// GStreamingCompiled
// GCompiled /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:66
pub struct GCompiled {
	ptr: *mut c_void
}

opencv_type_boxed! { GCompiled }

impl Drop for GCompiled {
	fn drop(&mut self) {
		extern "C" { fn cv_GCompiled_delete(instance: *mut c_void); }
		unsafe { cv_GCompiled_delete(self.as_raw_mut_GCompiled()) };
	}
}

unsafe impl Send for GCompiled {}

impl crate::gapi::GCompiledTraitConst for GCompiled {
	#[inline] fn as_raw_GCompiled(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GCompiledTrait for GCompiled {
	#[inline] fn as_raw_mut_GCompiled(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GCompiled {
	/// Constructs an empty object
	// GCompiled() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:75
	#[inline]
	pub fn default() -> Result<crate::gapi::GCompiled> {
		let ret = unsafe { sys::cv_GCompiled_GCompiled() }.into_result()?;
		let ret = unsafe { crate::gapi::GCompiled::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

/// \addtogroup gapi_meta_args
// GFrameDesc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:95
pub trait GFrameDescTraitConst {
	fn as_raw_GFrameDesc(&self) -> *const c_void;

	// fmt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:97
	#[inline]
	fn fmt(&self) -> crate::gapi::MediaFormat {
		let ret = unsafe { sys::cv_GFrameDesc_getPropFmt_const(self.as_raw_GFrameDesc()) };
		ret
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:98
	#[inline]
	fn size(&self) -> core::Size {
		let ret = unsafe { sys::cv_GFrameDesc_getPropSize_const(self.as_raw_GFrameDesc()) };
		ret
	}
	
	// operator==(const cv::GFrameDesc &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:100
	#[inline]
	fn equals(&self, unnamed: &crate::gapi::GFrameDesc) -> Result<bool> {
		let ret = unsafe { sys::cv_GFrameDesc_operatorEQ_const_const_GFrameDescR(self.as_raw_GFrameDesc(), unnamed.as_raw_GFrameDesc()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait GFrameDescTrait: crate::gapi::GFrameDescTraitConst {
	fn as_raw_mut_GFrameDesc(&mut self) -> *mut c_void;

	// fmt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:97
	#[inline]
	fn set_fmt(&mut self, val: crate::gapi::MediaFormat) {
		let ret = unsafe { sys::cv_GFrameDesc_setPropFmt_MediaFormat(self.as_raw_mut_GFrameDesc(), val) };
		ret
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:98
	#[inline]
	fn set_size(&mut self, val: core::Size) {
		let ret = unsafe { sys::cv_GFrameDesc_setPropSize_Size(self.as_raw_mut_GFrameDesc(), val.opencv_as_extern()) };
		ret
	}
	
}

/// \addtogroup gapi_meta_args
// GFrameDesc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:95
pub struct GFrameDesc {
	ptr: *mut c_void
}

opencv_type_boxed! { GFrameDesc }

impl Drop for GFrameDesc {
	fn drop(&mut self) {
		extern "C" { fn cv_GFrameDesc_delete(instance: *mut c_void); }
		unsafe { cv_GFrameDesc_delete(self.as_raw_mut_GFrameDesc()) };
	}
}

unsafe impl Send for GFrameDesc {}

impl crate::gapi::GFrameDescTraitConst for GFrameDesc {
	#[inline] fn as_raw_GFrameDesc(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GFrameDescTrait for GFrameDesc {
	#[inline] fn as_raw_mut_GFrameDesc(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GFrameDesc {
}

// GKernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:44
pub trait GKernelTraitConst {
	fn as_raw_GKernel(&self) -> *const c_void;

	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:48
	#[inline]
	fn name(&self) -> String {
		let ret = unsafe { sys::cv_GKernel_getPropName_const(self.as_raw_GKernel()) };
		let ret = unsafe { String::opencv_from_extern(ret) };
		ret
	}
	
	// tag /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:49
	#[inline]
	fn tag(&self) -> String {
		let ret = unsafe { sys::cv_GKernel_getPropTag_const(self.as_raw_GKernel()) };
		let ret = unsafe { String::opencv_from_extern(ret) };
		ret
	}
	
	// outShapes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:51
	#[inline]
	fn out_shapes(&self) -> core::Vector<crate::gapi::GShape> {
		let ret = unsafe { sys::cv_GKernel_getPropOutShapes_const(self.as_raw_GKernel()) };
		let ret = unsafe { core::Vector::<crate::gapi::GShape>::opencv_from_extern(ret) };
		ret
	}
	
	// inKinds /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:52
	#[inline]
	fn in_kinds(&self) -> core::Vector<crate::gapi::OpaqueKind> {
		let ret = unsafe { sys::cv_GKernel_getPropInKinds_const(self.as_raw_GKernel()) };
		let ret = unsafe { core::Vector::<crate::gapi::OpaqueKind>::opencv_from_extern(ret) };
		ret
	}
	
}

pub trait GKernelTrait: crate::gapi::GKernelTraitConst {
	fn as_raw_mut_GKernel(&mut self) -> *mut c_void;

	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:48
	#[inline]
	fn set_name(&mut self, val: &str) {
		extern_container_arg!(nofail mut val);
		let ret = unsafe { sys::cv_GKernel_setPropName_string(self.as_raw_mut_GKernel(), val.opencv_as_extern_mut()) };
		ret
	}
	
	// tag /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:49
	#[inline]
	fn set_tag(&mut self, val: &str) {
		extern_container_arg!(nofail mut val);
		let ret = unsafe { sys::cv_GKernel_setPropTag_string(self.as_raw_mut_GKernel(), val.opencv_as_extern_mut()) };
		ret
	}
	
	// outShapes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:51
	#[inline]
	fn set_out_shapes(&mut self, mut val: crate::gapi::GShapes) {
		let ret = unsafe { sys::cv_GKernel_setPropOutShapes_GShapes(self.as_raw_mut_GKernel(), val.as_raw_mut_VectorOfGShape()) };
		ret
	}
	
	// inKinds /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:52
	#[inline]
	fn set_in_kinds(&mut self, mut val: crate::gapi::GKinds) {
		let ret = unsafe { sys::cv_GKernel_setPropInKinds_GKinds(self.as_raw_mut_GKernel(), val.as_raw_mut_VectorOfOpaqueKind()) };
		ret
	}
	
}

// GKernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:44
pub struct GKernel {
	ptr: *mut c_void
}

opencv_type_boxed! { GKernel }

impl Drop for GKernel {
	fn drop(&mut self) {
		extern "C" { fn cv_GKernel_delete(instance: *mut c_void); }
		unsafe { cv_GKernel_delete(self.as_raw_mut_GKernel()) };
	}
}

unsafe impl Send for GKernel {}

impl crate::gapi::GKernelTraitConst for GKernel {
	#[inline] fn as_raw_GKernel(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GKernelTrait for GKernel {
	#[inline] fn as_raw_mut_GKernel(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GKernel {
}

// GKernelImpl /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:59
pub trait GKernelImplTraitConst {
	fn as_raw_GKernelImpl(&self) -> *const c_void;

	// opaque /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:61
	#[inline]
	fn opaque(&self) -> crate::gapi::any {
		let ret = unsafe { sys::cv_GKernelImpl_getPropOpaque_const(self.as_raw_GKernelImpl()) };
		ret
	}
	
}

pub trait GKernelImplTrait: crate::gapi::GKernelImplTraitConst {
	fn as_raw_mut_GKernelImpl(&mut self) -> *mut c_void;

	// opaque /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:61
	#[inline]
	fn set_opaque(&mut self, val: crate::gapi::any) {
		let ret = unsafe { sys::cv_GKernelImpl_setPropOpaque_any(self.as_raw_mut_GKernelImpl(), val) };
		ret
	}
	
}

// GKernelImpl /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:59
pub struct GKernelImpl {
	ptr: *mut c_void
}

opencv_type_boxed! { GKernelImpl }

impl Drop for GKernelImpl {
	fn drop(&mut self) {
		extern "C" { fn cv_GKernelImpl_delete(instance: *mut c_void); }
		unsafe { cv_GKernelImpl_delete(self.as_raw_mut_GKernelImpl()) };
	}
}

unsafe impl Send for GKernelImpl {}

impl crate::gapi::GKernelImplTraitConst for GKernelImpl {
	#[inline] fn as_raw_GKernelImpl(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GKernelImplTrait for GKernelImpl {
	#[inline] fn as_raw_mut_GKernelImpl(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GKernelImpl {
}

// GMatP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:90
pub trait GMatPTraitConst: crate::gapi::GMatTraitConst {
	fn as_raw_GMatP(&self) -> *const c_void;

}

pub trait GMatPTrait: crate::gapi::GMatPTraitConst + crate::gapi::GMatTrait {
	fn as_raw_mut_GMatP(&mut self) -> *mut c_void;

}

// GMatP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:90
pub struct GMatP {
	ptr: *mut c_void
}

opencv_type_boxed! { GMatP }

impl Drop for GMatP {
	fn drop(&mut self) {
		extern "C" { fn cv_GMatP_delete(instance: *mut c_void); }
		unsafe { cv_GMatP_delete(self.as_raw_mut_GMatP()) };
	}
}

unsafe impl Send for GMatP {}

impl crate::gapi::GMatTraitConst for GMatP {
	#[inline] fn as_raw_GMat(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GMatTrait for GMatP {
	#[inline] fn as_raw_mut_GMat(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl crate::gapi::GMatPTraitConst for GMatP {
	#[inline] fn as_raw_GMatP(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GMatPTrait for GMatP {
	#[inline] fn as_raw_mut_GMatP(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GMatP {
}

boxed_cast_base! { GMatP, crate::gapi::GMat, cv_GMatP_to_GMat }

// GRunArg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:121
pub trait GRunArgTraitConst {
	fn as_raw_GRunArg(&self) -> *const c_void;

}

pub trait GRunArgTrait: crate::gapi::GRunArgTraitConst {
	fn as_raw_mut_GRunArg(&mut self) -> *mut c_void;

}

// GRunArg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:121
pub struct GRunArg {
	ptr: *mut c_void
}

opencv_type_boxed! { GRunArg }

impl Drop for GRunArg {
	fn drop(&mut self) {
		extern "C" { fn cv_GRunArg_delete(instance: *mut c_void); }
		unsafe { cv_GRunArg_delete(self.as_raw_mut_GRunArg()) };
	}
}

unsafe impl Send for GRunArg {}

impl crate::gapi::GRunArgTraitConst for GRunArg {
	#[inline] fn as_raw_GRunArg(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GRunArgTrait for GRunArg {
	#[inline] fn as_raw_mut_GRunArg(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GRunArg {
	// GRunArg() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:129
	#[inline]
	pub fn default() -> Result<crate::gapi::GRunArg> {
		let ret = unsafe { sys::cv_GRunArg_GRunArg() }.into_result()?;
		let ret = unsafe { crate::gapi::GRunArg::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// GRunArg(const cv::GRunArg &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:130
	#[inline]
	pub fn copy(arg: &crate::gapi::GRunArg) -> Result<crate::gapi::GRunArg> {
		let ret = unsafe { sys::cv_GRunArg_GRunArg_const_GRunArgR(arg.as_raw_GRunArg()) }.into_result()?;
		let ret = unsafe { crate::gapi::GRunArg::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// GRunArg(cv::GRunArg &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:131
	#[inline]
	pub fn copy_mut(arg: &mut crate::gapi::GRunArg) -> Result<crate::gapi::GRunArg> {
		let ret = unsafe { sys::cv_GRunArg_GRunArg_GRunArgR(arg.as_raw_mut_GRunArg()) }.into_result()?;
		let ret = unsafe { crate::gapi::GRunArg::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

// GTransform /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:24
pub trait GTransformTraitConst {
	fn as_raw_GTransform(&self) -> *const c_void;

	// description /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:30
	#[inline]
	fn description(&self) -> String {
		let ret = unsafe { sys::cv_GTransform_getPropDescription_const(self.as_raw_GTransform()) };
		let ret = unsafe { String::opencv_from_extern(ret) };
		ret
	}
	
}

pub trait GTransformTrait: crate::gapi::GTransformTraitConst {
	fn as_raw_mut_GTransform(&mut self) -> *mut c_void;

	// description /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:30
	#[inline]
	fn set_description(&mut self, val: &str) {
		extern_container_arg!(nofail mut val);
		let ret = unsafe { sys::cv_GTransform_setPropDescription_string(self.as_raw_mut_GTransform(), val.opencv_as_extern_mut()) };
		ret
	}
	
}

// GTransform /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:24
pub struct GTransform {
	ptr: *mut c_void
}

opencv_type_boxed! { GTransform }

impl Drop for GTransform {
	fn drop(&mut self) {
		extern "C" { fn cv_GTransform_delete(instance: *mut c_void); }
		unsafe { cv_GTransform_delete(self.as_raw_mut_GTransform()) };
	}
}

unsafe impl Send for GTransform {}

impl crate::gapi::GTransformTraitConst for GTransform {
	#[inline] fn as_raw_GTransform(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GTransformTrait for GTransform {
	#[inline] fn as_raw_mut_GTransform(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GTransform {
}

/// \addtogroup gapi_data_structures
/// 
///  Extra G-API data structures used to pass input/output data
///  to the graph for processing.
/// /
/// 
///  cv::MediaFrame class represents an image/media frame
///  obtained from an external source.
/// 
///  cv::MediaFrame represents image data as specified in
///  cv::MediaFormat. cv::MediaFrame is designed to be a thin wrapper over some
///  external memory of buffer; the class itself provides an uniform
///  interface over such types of memory. cv::MediaFrame wraps data from
///  a camera driver or from a media codec and provides an abstraction
///  layer over this memory to G-API. MediaFrame defines a compact interface
///  to access and manage the underlying data; the implementation is
///  fully defined by the associated Adapter (which is usually
///  user-defined).
/// ## See also
/// cv::RMat
// MediaFrame /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:52
pub trait MediaFrameTraitConst {
	fn as_raw_MediaFrame(&self) -> *const c_void;

	/// Obtain access to the underlying data with the given
	/// mode.
	/// 
	/// Depending on the associated Adapter and the data wrapped, this
	/// method may be cheap (e.g., the underlying memory is local) or
	/// costly (if the underlying memory is external or device
	/// memory).
	/// 
	/// ## Parameters
	/// * mode: an access mode flag
	/// ## Returns
	/// a MediaFrame::View object. The views should be handled
	/// carefully, refer to the MediaFrame::View documentation for details.
	// access(cv::MediaFrame::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:103
	#[inline]
	fn access(&self, mode: crate::gapi::MediaFrame_Access) -> Result<crate::gapi::MediaFrame_View> {
		let ret = unsafe { sys::cv_MediaFrame_access_const_Access(self.as_raw_MediaFrame(), mode) }.into_result()?;
		let ret = unsafe { crate::gapi::MediaFrame_View::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// Returns a media frame descriptor -- the information
	/// about the media format, dimensions, etc.
	/// ## Returns
	/// a cv::GFrameDesc
	// desc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:110
	#[inline]
	fn desc(&self) -> Result<crate::gapi::GFrameDesc> {
		let ret = unsafe { sys::cv_MediaFrame_desc_const(self.as_raw_MediaFrame()) }.into_result()?;
		let ret = unsafe { crate::gapi::GFrameDesc::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// @private -- exclude from the OpenCV documentation for now.
	// blobParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:115
	#[inline]
	fn blob_params(&self) -> Result<crate::gapi::any> {
		let ret = unsafe { sys::cv_MediaFrame_blobParams_const(self.as_raw_MediaFrame()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait MediaFrameTrait: crate::gapi::MediaFrameTraitConst {
	fn as_raw_mut_MediaFrame(&mut self) -> *mut c_void;

}

/// \addtogroup gapi_data_structures
/// 
///  Extra G-API data structures used to pass input/output data
///  to the graph for processing.
/// /
/// 
///  cv::MediaFrame class represents an image/media frame
///  obtained from an external source.
/// 
///  cv::MediaFrame represents image data as specified in
///  cv::MediaFormat. cv::MediaFrame is designed to be a thin wrapper over some
///  external memory of buffer; the class itself provides an uniform
///  interface over such types of memory. cv::MediaFrame wraps data from
///  a camera driver or from a media codec and provides an abstraction
///  layer over this memory to G-API. MediaFrame defines a compact interface
///  to access and manage the underlying data; the implementation is
///  fully defined by the associated Adapter (which is usually
///  user-defined).
/// ## See also
/// cv::RMat
// MediaFrame /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:52
pub struct MediaFrame {
	ptr: *mut c_void
}

opencv_type_boxed! { MediaFrame }

impl Drop for MediaFrame {
	fn drop(&mut self) {
		extern "C" { fn cv_MediaFrame_delete(instance: *mut c_void); }
		unsafe { cv_MediaFrame_delete(self.as_raw_mut_MediaFrame()) };
	}
}

unsafe impl Send for MediaFrame {}

impl crate::gapi::MediaFrameTraitConst for MediaFrame {
	#[inline] fn as_raw_MediaFrame(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::MediaFrameTrait for MediaFrame {
	#[inline] fn as_raw_mut_MediaFrame(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl MediaFrame {
	/// Constructs an empty MediaFrame
	/// 
	/// The constructed object has no any data associated with it.
	// MediaFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:70
	#[inline]
	pub fn default() -> Result<crate::gapi::MediaFrame> {
		let ret = unsafe { sys::cv_MediaFrame_MediaFrame() }.into_result()?;
		let ret = unsafe { crate::gapi::MediaFrame::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

/// An interface class for MediaFrame data adapters.
/// 
/// Implement this interface to wrap media data in the MediaFrame. It
/// makes sense to implement this class if there is a custom
/// cv::gapi::wip::IStreamSource defined -- in this case, a stream
/// source can produce MediaFrame objects with this adapter and the
/// media data may be passed to graph without any copy. For example, a
/// GStreamer-based stream source can implement an adapter over
/// `GstBuffer` and G-API will transparently use it in the graph.
// IAdapter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:236
pub trait MediaFrame_IAdapterConst {
	fn as_raw_MediaFrame_IAdapter(&self) -> *const c_void;

	// meta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:239
	#[inline]
	fn meta(&self) -> Result<crate::gapi::GFrameDesc> {
		let ret = unsafe { sys::cv_MediaFrame_IAdapter_meta_const(self.as_raw_MediaFrame_IAdapter()) }.into_result()?;
		let ret = unsafe { crate::gapi::GFrameDesc::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// blobParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:243
	#[inline]
	fn blob_params(&self) -> Result<crate::gapi::any> {
		let ret = unsafe { sys::cv_MediaFrame_IAdapter_blobParams_const(self.as_raw_MediaFrame_IAdapter()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait MediaFrame_IAdapter: crate::gapi::MediaFrame_IAdapterConst {
	fn as_raw_mut_MediaFrame_IAdapter(&mut self) -> *mut c_void;

	// access(MediaFrame::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:240
	#[inline]
	fn access(&mut self, unnamed: crate::gapi::MediaFrame_Access) -> Result<crate::gapi::MediaFrame_View> {
		let ret = unsafe { sys::cv_MediaFrame_IAdapter_access_Access(self.as_raw_mut_MediaFrame_IAdapter(), unnamed) }.into_result()?;
		let ret = unsafe { crate::gapi::MediaFrame_View::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

/// Provides access to the MediaFrame's underlying data.
/// 
/// This object contains the necessary information to access the pixel
/// data of the associated MediaFrame: arrays of pointers and strides
/// (distance between every plane row, in bytes) for every image
/// plane, as defined in cv::MediaFormat.
/// There may be up to four image planes in MediaFrame.
/// 
/// Depending on the MediaFrame::Access flag passed in
/// MediaFrame::access(), a MediaFrame::View may be read- or
/// write-only.
/// 
/// Depending on the MediaFrame::IAdapter implementation associated
/// with the parent MediaFrame, writing to memory with
/// MediaFrame::Access::R flag may have no effect or lead to
/// undefined behavior. Same applies to reading the memory with
/// MediaFrame::Access::W flag -- again, depending on the IAdapter
/// implementation, the host-side buffer the view provides access to
/// may have no current data stored in (so in-place editing of the
/// buffer contents may not be possible).
/// 
/// MediaFrame::View objects must be handled carefully, as an external
/// resource associated with MediaFrame may be locked for the time the
/// MediaFrame::View object exists. Obtaining MediaFrame::View should
/// be seen as "map" and destroying it as "unmap" in the "map/unmap"
/// idiom (applicable to OpenCL, device memory, remote
/// memory).
/// 
/// When a MediaFrame buffer is accessed for writing, and the memory
/// under MediaFrame::View::Ptrs is altered, the data synchronization
/// of a host-side and device/remote buffer is not guaranteed until the
/// MediaFrame::View is destroyed. In other words, the real data on the
/// device or in a remote target may be updated at the MediaFrame::View
/// destruction only -- but it depends on the associated
/// MediaFrame::IAdapter implementation.
// View /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:197
pub trait MediaFrame_ViewTraitConst {
	fn as_raw_MediaFrame_View(&self) -> *const c_void;

}

pub trait MediaFrame_ViewTrait: crate::gapi::MediaFrame_ViewTraitConst {
	fn as_raw_mut_MediaFrame_View(&mut self) -> *mut c_void;

}

/// Provides access to the MediaFrame's underlying data.
/// 
/// This object contains the necessary information to access the pixel
/// data of the associated MediaFrame: arrays of pointers and strides
/// (distance between every plane row, in bytes) for every image
/// plane, as defined in cv::MediaFormat.
/// There may be up to four image planes in MediaFrame.
/// 
/// Depending on the MediaFrame::Access flag passed in
/// MediaFrame::access(), a MediaFrame::View may be read- or
/// write-only.
/// 
/// Depending on the MediaFrame::IAdapter implementation associated
/// with the parent MediaFrame, writing to memory with
/// MediaFrame::Access::R flag may have no effect or lead to
/// undefined behavior. Same applies to reading the memory with
/// MediaFrame::Access::W flag -- again, depending on the IAdapter
/// implementation, the host-side buffer the view provides access to
/// may have no current data stored in (so in-place editing of the
/// buffer contents may not be possible).
/// 
/// MediaFrame::View objects must be handled carefully, as an external
/// resource associated with MediaFrame may be locked for the time the
/// MediaFrame::View object exists. Obtaining MediaFrame::View should
/// be seen as "map" and destroying it as "unmap" in the "map/unmap"
/// idiom (applicable to OpenCL, device memory, remote
/// memory).
/// 
/// When a MediaFrame buffer is accessed for writing, and the memory
/// under MediaFrame::View::Ptrs is altered, the data synchronization
/// of a host-side and device/remote buffer is not guaranteed until the
/// MediaFrame::View is destroyed. In other words, the real data on the
/// device or in a remote target may be updated at the MediaFrame::View
/// destruction only -- but it depends on the associated
/// MediaFrame::IAdapter implementation.
// View /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:197
pub struct MediaFrame_View {
	ptr: *mut c_void
}

opencv_type_boxed! { MediaFrame_View }

impl Drop for MediaFrame_View {
	fn drop(&mut self) {
		extern "C" { fn cv_MediaFrame_View_delete(instance: *mut c_void); }
		unsafe { cv_MediaFrame_View_delete(self.as_raw_mut_MediaFrame_View()) };
	}
}

unsafe impl Send for MediaFrame_View {}

impl crate::gapi::MediaFrame_ViewTraitConst for MediaFrame_View {
	#[inline] fn as_raw_MediaFrame_View(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::MediaFrame_ViewTrait for MediaFrame_View {
	#[inline] fn as_raw_mut_MediaFrame_View(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl MediaFrame_View {
	// MAX_PLANES /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:199
	pub const MAX_PLANES: u32 = 4;
	/// @private
	// View(cv::MediaFrame::View &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:211
	#[inline]
	pub fn copy_mut(unnamed: &mut crate::gapi::MediaFrame_View) -> crate::gapi::MediaFrame_View {
		let ret = unsafe { sys::cv_MediaFrame_View_View_ViewR(unnamed.as_raw_mut_MediaFrame_View()) };
		let ret = unsafe { crate::gapi::MediaFrame_View::opencv_from_extern(ret) };
		ret
	}
	
}

/// \addtogroup gapi_data_structures
// RMat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:48
pub trait RMatTraitConst {
	fn as_raw_RMat(&self) -> *const c_void;

	// desc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:126
	#[inline]
	fn desc(&self) -> Result<crate::gapi::GMatDesc> {
		let ret = unsafe { sys::cv_RMat_desc_const(self.as_raw_RMat()) }.into_result()?;
		let ret = unsafe { crate::gapi::GMatDesc::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// access(cv::RMat::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:133
	#[inline]
	fn access(&self, a: crate::gapi::RMat_Access) -> Result<crate::gapi::RMat_View> {
		let ret = unsafe { sys::cv_RMat_access_const_Access(self.as_raw_RMat(), a) }.into_result()?;
		let ret = unsafe { crate::gapi::RMat_View::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

pub trait RMatTrait: crate::gapi::RMatTraitConst {
	fn as_raw_mut_RMat(&mut self) -> *mut c_void;

}

/// \addtogroup gapi_data_structures
// RMat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:48
pub struct RMat {
	ptr: *mut c_void
}

opencv_type_boxed! { RMat }

impl Drop for RMat {
	fn drop(&mut self) {
		extern "C" { fn cv_RMat_delete(instance: *mut c_void); }
		unsafe { cv_RMat_delete(self.as_raw_mut_RMat()) };
	}
}

unsafe impl Send for RMat {}

impl crate::gapi::RMatTraitConst for RMat {
	#[inline] fn as_raw_RMat(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::RMatTrait for RMat {
	#[inline] fn as_raw_mut_RMat(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl RMat {
	// RMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:124
	#[inline]
	pub fn default() -> crate::gapi::RMat {
		let ret = unsafe { sys::cv_RMat_RMat() };
		let ret = unsafe { crate::gapi::RMat::opencv_from_extern(ret) };
		ret
	}
	
}

impl Default for RMat {
	#[inline]
	/// Forwards to infallible Self::default()
	fn default() -> Self {
		Self::default()
	}
}

// View /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:56
pub trait RMat_ViewTraitConst {
	fn as_raw_RMat_View(&self) -> *const c_void;

	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:72
	#[inline]
	fn size(&self) -> Result<core::Size> {
		let ret = unsafe { sys::cv_RMat_View_size_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// dims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:73
	#[inline]
	fn dims(&self) -> Result<core::Vector<i32>> {
		let ret = unsafe { sys::cv_RMat_View_dims_const(self.as_raw_RMat_View()) }.into_result()?;
		let ret = unsafe { core::Vector::<i32>::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// cols() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:74
	#[inline]
	fn cols(&self) -> Result<i32> {
		let ret = unsafe { sys::cv_RMat_View_cols_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// rows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:75
	#[inline]
	fn rows(&self) -> Result<i32> {
		let ret = unsafe { sys::cv_RMat_View_rows_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:76
	#[inline]
	fn typ(&self) -> Result<i32> {
		let ret = unsafe { sys::cv_RMat_View_type_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:77
	#[inline]
	fn depth(&self) -> Result<i32> {
		let ret = unsafe { sys::cv_RMat_View_depth_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// chan() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:78
	#[inline]
	fn chan(&self) -> Result<i32> {
		let ret = unsafe { sys::cv_RMat_View_chan_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:79
	#[inline]
	fn elem_size(&self) -> Result<size_t> {
		let ret = unsafe { sys::cv_RMat_View_elemSize_const(self.as_raw_RMat_View()) }.into_result()?;
		Ok(ret)
	}
	
	/// ## C++ default parameters
	/// * i: 0
	// step(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:93
	#[inline]
	fn step(&self, i: size_t) -> Result<size_t> {
		let ret = unsafe { sys::cv_RMat_View_step_const_size_t(self.as_raw_RMat_View(), i) }.into_result()?;
		Ok(ret)
	}
	
	// steps() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:94
	#[inline]
	fn steps(&self) -> Result<core::Vector<size_t>> {
		let ret = unsafe { sys::cv_RMat_View_steps_const(self.as_raw_RMat_View()) }.into_result()?;
		let ret = unsafe { core::Vector::<size_t>::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

pub trait RMat_ViewTrait: crate::gapi::RMat_ViewTraitConst {
	fn as_raw_mut_RMat_View(&mut self) -> *mut c_void;

}

// View /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:56
pub struct RMat_View {
	ptr: *mut c_void
}

opencv_type_boxed! { RMat_View }

impl Drop for RMat_View {
	fn drop(&mut self) {
		extern "C" { fn cv_RMat_View_delete(instance: *mut c_void); }
		unsafe { cv_RMat_View_delete(self.as_raw_mut_RMat_View()) };
	}
}

unsafe impl Send for RMat_View {}

impl crate::gapi::RMat_ViewTraitConst for RMat_View {
	#[inline] fn as_raw_RMat_View(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::RMat_ViewTrait for RMat_View {
	#[inline] fn as_raw_mut_RMat_View(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl RMat_View {
	// View() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:62
	#[inline]
	pub fn default() -> crate::gapi::RMat_View {
		let ret = unsafe { sys::cv_RMat_View_View() };
		let ret = unsafe { crate::gapi::RMat_View::opencv_from_extern(ret) };
		ret
	}
	
	// View(cv::RMat::View &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:68
	#[inline]
	pub fn copy_mut(unnamed: &mut crate::gapi::RMat_View) -> crate::gapi::RMat_View {
		let ret = unsafe { sys::cv_RMat_View_View_ViewR(unnamed.as_raw_mut_RMat_View()) };
		let ret = unsafe { crate::gapi::RMat_View::opencv_from_extern(ret) };
		ret
	}
	
}

impl Default for RMat_View {
	#[inline]
	/// Forwards to infallible Self::default()
	fn default() -> Self {
		Self::default()
	}
}

// GArrayU /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garray.hpp:70
pub trait GArrayUTraitConst {
	fn as_raw_GArrayU(&self) -> *const c_void;

}

pub trait GArrayUTrait: crate::gapi::GArrayUTraitConst {
	fn as_raw_mut_GArrayU(&mut self) -> *mut c_void;

}

// GArrayU /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garray.hpp:70
pub struct GArrayU {
	ptr: *mut c_void
}

opencv_type_boxed! { GArrayU }

impl Drop for GArrayU {
	fn drop(&mut self) {
		extern "C" { fn cv_GArrayU_delete(instance: *mut c_void); }
		unsafe { cv_GArrayU_delete(self.as_raw_mut_GArrayU()) };
	}
}

unsafe impl Send for GArrayU {}

impl crate::gapi::GArrayUTraitConst for GArrayU {
	#[inline] fn as_raw_GArrayU(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GArrayUTrait for GArrayU {
	#[inline] fn as_raw_mut_GArrayU(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GArrayU {
}

// GOpaqueU /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gopaque.hpp:67
pub trait GOpaqueUTraitConst {
	fn as_raw_GOpaqueU(&self) -> *const c_void;

}

pub trait GOpaqueUTrait: crate::gapi::GOpaqueUTraitConst {
	fn as_raw_mut_GOpaqueU(&mut self) -> *mut c_void;

}

// GOpaqueU /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gopaque.hpp:67
pub struct GOpaqueU {
	ptr: *mut c_void
}

opencv_type_boxed! { GOpaqueU }

impl Drop for GOpaqueU {
	fn drop(&mut self) {
		extern "C" { fn cv_GOpaqueU_delete(instance: *mut c_void); }
		unsafe { cv_GOpaqueU_delete(self.as_raw_mut_GOpaqueU()) };
	}
}

unsafe impl Send for GOpaqueU {}

impl crate::gapi::GOpaqueUTraitConst for GOpaqueU {
	#[inline] fn as_raw_GOpaqueU(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GOpaqueUTrait for GOpaqueU {
	#[inline] fn as_raw_mut_GOpaqueU(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GOpaqueU {
}

/// @private
// GBackend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:376
pub trait GBackendTraitConst {
	fn as_raw_GBackend(&self) -> *const c_void;

	// operator==(const cv::gapi::GBackend &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:389
	#[inline]
	fn equals(&self, rhs: &crate::gapi::GBackend) -> Result<bool> {
		let ret = unsafe { sys::cv_gapi_GBackend_operatorEQ_const_const_GBackendR(self.as_raw_GBackend(), rhs.as_raw_GBackend()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait GBackendTrait: crate::gapi::GBackendTraitConst {
	fn as_raw_mut_GBackend(&mut self) -> *mut c_void;

}

/// @private
// GBackend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:376
pub struct GBackend {
	ptr: *mut c_void
}

opencv_type_boxed! { GBackend }

impl Drop for GBackend {
	fn drop(&mut self) {
		extern "C" { fn cv_GBackend_delete(instance: *mut c_void); }
		unsafe { cv_GBackend_delete(self.as_raw_mut_GBackend()) };
	}
}

unsafe impl Send for GBackend {}

impl crate::gapi::GBackendTraitConst for GBackend {
	#[inline] fn as_raw_GBackend(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GBackendTrait for GBackend {
	#[inline] fn as_raw_mut_GBackend(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl GBackend {
	// GBackend() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:382
	#[inline]
	pub fn default() -> Result<crate::gapi::GBackend> {
		let ret = unsafe { sys::cv_gapi_GBackend_GBackend() }.into_result()?;
		let ret = unsafe { crate::gapi::GBackend::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

// Scalar /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:20
pub trait Own_ScalarTraitConst {
	fn as_raw_Own_Scalar(&self) -> *const c_void;

	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:30
	#[inline]
	fn get(&self, i: i32) -> Result<f64> {
		let ret = unsafe { sys::cv_gapi_own_Scalar_operator___const_int(self.as_raw_Own_Scalar(), i) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait Own_ScalarTrait: crate::gapi::Own_ScalarTraitConst {
	fn as_raw_mut_Own_Scalar(&mut self) -> *mut c_void;

	// val /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:35
	#[inline]
	fn val(&mut self) -> &mut [f64; 4] {
		let ret = unsafe { sys::cv_gapi_own_Scalar_getPropVal(self.as_raw_mut_Own_Scalar()) };
		let ret = unsafe { ret.as_mut() }.ok_or_else(|| Error::new(core::StsNullPtr, "Function returned Null pointer".to_string())).expect("Infallible function failed: val");
		ret
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:31
	#[inline]
	fn get_mut(&mut self, i: i32) -> Result<f64> {
		let ret = unsafe { sys::cv_gapi_own_Scalar_operator___int(self.as_raw_mut_Own_Scalar(), i) }.into_result()?;
		Ok(ret)
	}
	
}

// Scalar /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:20
pub struct Own_Scalar {
	ptr: *mut c_void
}

opencv_type_boxed! { Own_Scalar }

impl Drop for Own_Scalar {
	fn drop(&mut self) {
		extern "C" { fn cv_Own_Scalar_delete(instance: *mut c_void); }
		unsafe { cv_Own_Scalar_delete(self.as_raw_mut_Own_Scalar()) };
	}
}

unsafe impl Send for Own_Scalar {}

impl crate::gapi::Own_ScalarTraitConst for Own_Scalar {
	#[inline] fn as_raw_Own_Scalar(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::Own_ScalarTrait for Own_Scalar {
	#[inline] fn as_raw_mut_Own_Scalar(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl Own_Scalar {
	// Scalar() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:23
	#[inline]
	pub fn default() -> crate::gapi::Own_Scalar {
		let ret = unsafe { sys::cv_gapi_own_Scalar_Scalar() };
		let ret = unsafe { crate::gapi::Own_Scalar::opencv_from_extern(ret) };
		ret
	}
	
	// Scalar(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:24
	#[inline]
	pub fn new(v0: f64) -> Result<crate::gapi::Own_Scalar> {
		let ret = unsafe { sys::cv_gapi_own_Scalar_Scalar_double(v0) }.into_result()?;
		let ret = unsafe { crate::gapi::Own_Scalar::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// ## C++ default parameters
	/// * v2: 0
	/// * v3: 0
	// Scalar(double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:25
	#[inline]
	pub fn new_1(v0: f64, v1: f64, v2: f64, v3: f64) -> Result<crate::gapi::Own_Scalar> {
		let ret = unsafe { sys::cv_gapi_own_Scalar_Scalar_double_double_double_double(v0, v1, v2, v3) }.into_result()?;
		let ret = unsafe { crate::gapi::Own_Scalar::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	// all(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:33
	#[inline]
	pub fn all(v0: f64) -> Result<crate::gapi::Own_Scalar> {
		let ret = unsafe { sys::cv_gapi_own_Scalar_all_double(v0) }.into_result()?;
		let ret = unsafe { crate::gapi::Own_Scalar::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

impl Default for Own_Scalar {
	#[inline]
	/// Forwards to infallible Self::default()
	fn default() -> Self {
		Self::default()
	}
}

/// \addtogroup gapi_compile_args
/// /
/// 
///  cv::use_only() is a special combinator which hints G-API to use only
///  kernels specified in cv::GComputation::compile() (and not to extend kernels available by
///  default with that package).
// use_only /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:726
pub trait use_onlyTraitConst {
	fn as_raw_use_only(&self) -> *const c_void;

	// pkg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:728
	#[inline]
	fn pkg(&self) -> crate::gapi::GKernelPackage {
		let ret = unsafe { sys::cv_gapi_use_only_getPropPkg_const(self.as_raw_use_only()) };
		let ret = unsafe { crate::gapi::GKernelPackage::opencv_from_extern(ret) };
		ret
	}
	
}

pub trait use_onlyTrait: crate::gapi::use_onlyTraitConst {
	fn as_raw_mut_use_only(&mut self) -> *mut c_void;

	// pkg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:728
	#[inline]
	fn set_pkg(&mut self, mut val: crate::gapi::GKernelPackage) {
		let ret = unsafe { sys::cv_gapi_use_only_setPropPkg_GKernelPackage(self.as_raw_mut_use_only(), val.as_raw_mut_GKernelPackage()) };
		ret
	}
	
}

/// \addtogroup gapi_compile_args
/// /
/// 
///  cv::use_only() is a special combinator which hints G-API to use only
///  kernels specified in cv::GComputation::compile() (and not to extend kernels available by
///  default with that package).
// use_only /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:726
pub struct use_only {
	ptr: *mut c_void
}

opencv_type_boxed! { use_only }

impl Drop for use_only {
	fn drop(&mut self) {
		extern "C" { fn cv_use_only_delete(instance: *mut c_void); }
		unsafe { cv_use_only_delete(self.as_raw_mut_use_only()) };
	}
}

unsafe impl Send for use_only {}

impl crate::gapi::use_onlyTraitConst for use_only {
	#[inline] fn as_raw_use_only(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::use_onlyTrait for use_only {
	#[inline] fn as_raw_mut_use_only(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl use_only {
}

/// This aggregate type represents all types which G-API can
/// handle (via variant).
/// 
/// It only exists to overcome C++ language limitations (where a
/// `using`-defined class can't be forward-declared).
// Data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:195
pub trait DataTraitConst: crate::gapi::GRunArgTraitConst {
	fn as_raw_Data(&self) -> *const c_void;

}

pub trait DataTrait: crate::gapi::DataTraitConst + crate::gapi::GRunArgTrait {
	fn as_raw_mut_Data(&mut self) -> *mut c_void;

}

/// This aggregate type represents all types which G-API can
/// handle (via variant).
/// 
/// It only exists to overcome C++ language limitations (where a
/// `using`-defined class can't be forward-declared).
// Data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:195
pub struct Data {
	ptr: *mut c_void
}

opencv_type_boxed! { Data }

impl Drop for Data {
	fn drop(&mut self) {
		extern "C" { fn cv_Data_delete(instance: *mut c_void); }
		unsafe { cv_Data_delete(self.as_raw_mut_Data()) };
	}
}

unsafe impl Send for Data {}

impl crate::gapi::GRunArgTraitConst for Data {
	#[inline] fn as_raw_GRunArg(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::GRunArgTrait for Data {
	#[inline] fn as_raw_mut_GRunArg(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl crate::gapi::DataTraitConst for Data {
	#[inline] fn as_raw_Data(&self) -> *const c_void { self.as_raw() }
}

impl crate::gapi::DataTrait for Data {
	#[inline] fn as_raw_mut_Data(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl Data {
}

boxed_cast_base! { Data, crate::gapi::GRunArg, cv_Data_to_GRunArg }
