#include "gapi.hpp"
#include "gapi_types.hpp"

extern "C" {
	// descr_of(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:268
	Result<cv::GMatDesc*> cv_descr_of_const_MatR(const cv::Mat* mat) {
		try {
			cv::GMatDesc ret = cv::descr_of(*mat);
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// descr_of(const cv::MediaFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:106
	Result<cv::GFrameDesc*> cv_descr_of_const_MediaFrameR(const cv::MediaFrame* frame) {
		try {
			cv::GFrameDesc ret = cv::descr_of(*frame);
			return Ok(new cv::GFrameDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrameDesc*>))
	}
	
	// descr_of(const cv::RMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:265
	Result<cv::GMatDesc*> cv_descr_of_const_RMatR(const cv::RMat* mat) {
		try {
			cv::GMatDesc ret = cv::descr_of(*mat);
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// descr_of(const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gscalar.hpp:134
	Result<cv::GScalarDesc*> cv_descr_of_const_ScalarR(const cv::Scalar* scalar) {
		try {
			cv::GScalarDesc ret = cv::descr_of(*scalar);
			return Ok(new cv::GScalarDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalarDesc*>))
	}
	
	// descr_of(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:256
	Result<cv::GMatDesc*> cv_descr_of_const_UMatR(const cv::UMat* mat) {
		try {
			cv::GMatDesc ret = cv::descr_of(*mat);
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// BGR2Gray(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1388
	Result<cv::GMat*> cv_gapi_BGR2Gray_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::BGR2Gray(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// BGR2I420(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1421
	Result<cv::GMat*> cv_gapi_BGR2I420_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::BGR2I420(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// BGR2LUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1483
	Result<cv::GMat*> cv_gapi_BGR2LUV_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::BGR2LUV(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// BGR2YUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1525
	Result<cv::GMat*> cv_gapi_BGR2YUV_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::BGR2YUV(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// BayerGR2RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1612
	Result<cv::GMat*> cv_gapi_BayerGR2RGB_const_GMatR(const cv::GMat* src_gr) {
		try {
			cv::GMat ret = cv::gapi::BayerGR2RGB(*src_gr);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// Canny(const cv::GMat &, double, double, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:999
	Result<cv::GMat*> cv_gapi_Canny_const_GMatR_double_double_int_bool(const cv::GMat* image, double threshold1, double threshold2, int apertureSize, bool L2gradient) {
		try {
			cv::GMat ret = cv::gapi::Canny(*image, threshold1, threshold2, apertureSize, L2gradient);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// I4202BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1453
	Result<cv::GMat*> cv_gapi_I4202BGR_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::I4202BGR(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// I4202RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1469
	Result<cv::GMat*> cv_gapi_I4202RGB_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::I4202RGB(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// LUT(const cv::GMat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1775
	Result<cv::GMat*> cv_gapi_LUT_const_GMatR_const_MatR(const cv::GMat* src, const cv::Mat* lut) {
		try {
			cv::GMat ret = cv::gapi::LUT(*src, *lut);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// LUV2BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1497
	Result<cv::GMat*> cv_gapi_LUV2BGR_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::LUV2BGR(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// Laplacian(const cv::GMat &, int, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:940
	Result<cv::GMat*> cv_gapi_Laplacian_const_GMatR_int_int_double_double_int(const cv::GMat* src, int ddepth, int ksize, double scale, double delta, int borderType) {
		try {
			cv::GMat ret = cv::gapi::Laplacian(*src, ddepth, ksize, scale, delta, borderType);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// NV12toBGR(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1598
	Result<cv::GMat*> cv_gapi_NV12toBGR_const_GMatR_const_GMatR(const cv::GMat* src_y, const cv::GMat* src_uv) {
		try {
			cv::GMat ret = cv::gapi::NV12toBGR(*src_y, *src_uv);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// NV12toBGRp(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1676
	Result<cv::GMatP*> cv_gapi_NV12toBGRp_const_GMatR_const_GMatR(const cv::GMat* src_y, const cv::GMat* src_uv) {
		try {
			cv::GMatP ret = cv::gapi::NV12toBGRp(*src_y, *src_uv);
			return Ok(new cv::GMatP(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatP*>))
	}
	
	// NV12toGray(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1583
	Result<cv::GMat*> cv_gapi_NV12toGray_const_GMatR_const_GMatR(const cv::GMat* src_y, const cv::GMat* src_uv) {
		try {
			cv::GMat ret = cv::gapi::NV12toGray(*src_y, *src_uv);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// NV12toRGB(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1568
	Result<cv::GMat*> cv_gapi_NV12toRGB_const_GMatR_const_GMatR(const cv::GMat* src_y, const cv::GMat* src_uv) {
		try {
			cv::GMat ret = cv::gapi::NV12toRGB(*src_y, *src_uv);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// NV12toRGBp(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1658
	Result<cv::GMatP*> cv_gapi_NV12toRGBp_const_GMatR_const_GMatR(const cv::GMat* src_y, const cv::GMat* src_uv) {
		try {
			cv::GMatP ret = cv::gapi::NV12toRGBp(*src_y, *src_uv);
			return Ok(new cv::GMatP(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatP*>))
	}
	
	// RGB2Gray(const cv::GMat &, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1375
	Result<cv::GMat*> cv_gapi_RGB2Gray_const_GMatR_float_float_float(const cv::GMat* src, float rY, float gY, float bY) {
		try {
			cv::GMat ret = cv::gapi::RGB2Gray(*src, rY, gY, bY);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// RGB2HSV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1626
	Result<cv::GMat*> cv_gapi_RGB2HSV_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::RGB2HSV(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// RGB2I420(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1437
	Result<cv::GMat*> cv_gapi_RGB2I420_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::RGB2I420(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// RGB2Lab(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1539
	Result<cv::GMat*> cv_gapi_RGB2Lab_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::RGB2Lab(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// RGB2YUV422(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1640
	Result<cv::GMat*> cv_gapi_RGB2YUV422_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::RGB2YUV422(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// RGB2YUV(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1405
	Result<cv::GMat*> cv_gapi_RGB2YUV_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::RGB2YUV(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// Sobel(const cv::GMat &, int, int, int, int, double, double, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:859
	Result<cv::GMat*> cv_gapi_Sobel_const_GMatR_int_int_int_int_double_double_int_const_ScalarR(const cv::GMat* src, int ddepth, int dx, int dy, int ksize, double scale, double delta, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::Sobel(*src, ddepth, dx, dy, ksize, scale, delta, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// YUV2BGR(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1511
	Result<cv::GMat*> cv_gapi_YUV2BGR_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::YUV2BGR(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// YUV2RGB(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1553
	Result<cv::GMat*> cv_gapi_YUV2RGB_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::YUV2RGB(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// absDiffC(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1273
	Result<cv::GMat*> cv_gapi_absDiffC_const_GMatR_const_GScalarR(const cv::GMat* src, const cv::GScalar* c) {
		try {
			cv::GMat ret = cv::gapi::absDiffC(*src, *c);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// absDiff(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1256
	Result<cv::GMat*> cv_gapi_absDiff_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::absDiff(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// addC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:660
	Result<cv::GMat*> cv_gapi_addC_const_GScalarR_const_GMatR_int(const cv::GScalar* c, const cv::GMat* src1, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::addC(*c, *src1, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// addWeighted(const cv::GMat &, double, const cv::GMat &, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1321
	Result<cv::GMat*> cv_gapi_addWeighted_const_GMatR_double_const_GMatR_double_double_int(const cv::GMat* src1, double alpha, const cv::GMat* src2, double beta, double gamma, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::addWeighted(*src1, alpha, *src2, beta, gamma, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bilateralFilter(const cv::GMat &, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:974
	Result<cv::GMat*> cv_gapi_bilateralFilter_const_GMatR_int_double_double_int(const cv::GMat* src, int d, double sigmaColor, double sigmaSpace, int borderType) {
		try {
			cv::GMat ret = cv::gapi::bilateralFilter(*src, d, sigmaColor, sigmaSpace, borderType);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_and(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1108
	Result<cv::GMat*> cv_gapi_bitwise_and_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_and(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_and(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1114
	Result<cv::GMat*> cv_gapi_bitwise_and_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_and(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_not(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1184
	Result<cv::GMat*> cv_gapi_bitwise_not_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::bitwise_not(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_or(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1132
	Result<cv::GMat*> cv_gapi_bitwise_or_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_or(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_or(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1138
	Result<cv::GMat*> cv_gapi_bitwise_or_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_or(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_xor(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1157
	Result<cv::GMat*> cv_gapi_bitwise_xor_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_xor(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// bitwise_xor(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1163
	Result<cv::GMat*> cv_gapi_bitwise_xor_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::bitwise_xor(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// blur(const cv::GMat &, const cv::Size &, const cv::Point &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:630
	Result<cv::GMat*> cv_gapi_blur_const_GMatR_const_SizeR_const_PointR_int_const_ScalarR(const cv::GMat* src, const cv::Size* ksize, const cv::Point* anchor, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::blur(*src, *ksize, *anchor, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// boxFilter(const cv::GMat &, int, const cv::Size &, const cv::Point &, bool, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:603
	Result<cv::GMat*> cv_gapi_boxFilter_const_GMatR_int_const_SizeR_const_PointR_bool_int_const_ScalarR(const cv::GMat* src, int dtype, const cv::Size* ksize, const cv::Point* anchor, bool normalize, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::boxFilter(*src, dtype, *ksize, *anchor, normalize, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpEQ(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1060
	Result<cv::GMat*> cv_gapi_cmpEQ_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpEQ(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpEQ(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1064
	Result<cv::GMat*> cv_gapi_cmpEQ_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpEQ(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpGE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1008
	Result<cv::GMat*> cv_gapi_cmpGE_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpGE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpGE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1012
	Result<cv::GMat*> cv_gapi_cmpGE_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpGE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpGT(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:956
	Result<cv::GMat*> cv_gapi_cmpGT_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpGT(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpGT(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:960
	Result<cv::GMat*> cv_gapi_cmpGT_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpGT(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpLE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1034
	Result<cv::GMat*> cv_gapi_cmpLE_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpLE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpLE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1038
	Result<cv::GMat*> cv_gapi_cmpLE_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpLE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpLT(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:982
	Result<cv::GMat*> cv_gapi_cmpLT_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpLT(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpLT(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:986
	Result<cv::GMat*> cv_gapi_cmpLT_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpLT(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpNE(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1086
	Result<cv::GMat*> cv_gapi_cmpNE_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpNE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// cmpNE(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1090
	Result<cv::GMat*> cv_gapi_cmpNE_const_GMatR_const_GScalarR(const cv::GMat* src1, const cv::GScalar* src2) {
		try {
			cv::GMat ret = cv::gapi::cmpNE(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// combine(const cv::gapi::GKernelPackage &, const cv::gapi::GKernelPackage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:699
	Result<cv::gapi::GKernelPackage*> cv_gapi_combine_const_GKernelPackageR_const_GKernelPackageR(const cv::gapi::GKernelPackage* lhs, const cv::gapi::GKernelPackage* rhs) {
		try {
			cv::gapi::GKernelPackage ret = cv::gapi::combine(*lhs, *rhs);
			return Ok(new cv::gapi::GKernelPackage(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::GKernelPackage*>))
	}
	
	// concatHor(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1708
	Result<cv::GMat*> cv_gapi_concatHor_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::concatHor(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// concatHor(const std::vector<GMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1716
	Result<cv::GMat*> cv_gapi_concatHor_const_vector_GMat_R(const std::vector<cv::GMat>* v) {
		try {
			cv::GMat ret = cv::gapi::concatHor(*v);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// concatVert(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1748
	Result<cv::GMat*> cv_gapi_concatVert_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::concatVert(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// concatVert(const std::vector<GMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1756
	Result<cv::GMat*> cv_gapi_concatVert_const_vector_GMat_R(const std::vector<cv::GMat>* v) {
		try {
			cv::GMat ret = cv::gapi::concatVert(*v);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// convertTo(const cv::GMat &, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1792
	Result<cv::GMat*> cv_gapi_convertTo_const_GMatR_int_double_double(const cv::GMat* src, int rdepth, double alpha, double beta) {
		try {
			cv::GMat ret = cv::gapi::convertTo(*src, rdepth, alpha, beta);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// copy(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:88
	Result<cv::GFrame*> cv_gapi_copy_const_GFrameR(const cv::GFrame* in) {
		try {
			cv::GFrame ret = cv::gapi::copy(*in);
			return Ok(new cv::GFrame(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrame*>))
	}
	
	// crop(const cv::GMat &, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1680
	Result<cv::GMat*> cv_gapi_crop_const_GMatR_const_RectR(const cv::GMat* src, const cv::Rect* rect) {
		try {
			cv::GMat ret = cv::gapi::crop(*src, *rect);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// dilate3x3(const cv::GMat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:777
	Result<cv::GMat*> cv_gapi_dilate3x3_const_GMatR_int_int_const_ScalarR(const cv::GMat* src, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::dilate3x3(*src, iterations, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// dilate(const cv::GMat &, const cv::Mat &, const cv::Point &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:753
	Result<cv::GMat*> cv_gapi_dilate_const_GMatR_const_MatR_const_PointR_int_int_const_ScalarR(const cv::GMat* src, const cv::Mat* kernel, const cv::Point* anchor, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::dilate(*src, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// divC(const cv::GMat &, const cv::GScalar &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:807
	Result<cv::GMat*> cv_gapi_divC_const_GMatR_const_GScalarR_double_int(const cv::GMat* src, const cv::GScalar* divisor, double scale, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::divC(*src, *divisor, scale, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// divRC(const cv::GScalar &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:828
	Result<cv::GMat*> cv_gapi_divRC_const_GScalarR_const_GMatR_double_int(const cv::GScalar* divident, const cv::GMat* src, double scale, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::divRC(*divident, *src, scale, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// div(const cv::GMat &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:786
	Result<cv::GMat*> cv_gapi_div_const_GMatR_const_GMatR_double_int(const cv::GMat* src1, const cv::GMat* src2, double scale, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::div(*src1, *src2, scale, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// equalizeHist(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:1074
	Result<cv::GMat*> cv_gapi_equalizeHist_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::equalizeHist(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// erode3x3(const cv::GMat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:726
	Result<cv::GMat*> cv_gapi_erode3x3_const_GMatR_int_int_const_ScalarR(const cv::GMat* src, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::erode3x3(*src, iterations, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// erode(const cv::GMat &, const cv::Mat &, const cv::Point &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:706
	Result<cv::GMat*> cv_gapi_erode_const_GMatR_const_MatR_const_PointR_int_int_const_ScalarR(const cv::GMat* src, const cv::Mat* kernel, const cv::Point* anchor, int iterations, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::erode(*src, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// filter2D(const cv::GMat &, int, const cv::Mat &, const cv::Point &, const cv::Scalar &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:569
	Result<cv::GMat*> cv_gapi_filter2D_const_GMatR_int_const_MatR_const_PointR_const_ScalarR_int_const_ScalarR(const cv::GMat* src, int ddepth, const cv::Mat* kernel, const cv::Point* anchor, const cv::Scalar* delta, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::filter2D(*src, ddepth, *kernel, *anchor, *delta, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// flip(const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1666
	Result<cv::GMat*> cv_gapi_flip_const_GMatR_int(const cv::GMat* src, int flipCode) {
		try {
			cv::GMat ret = cv::gapi::flip(*src, flipCode);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// gaussianBlur(const cv::GMat &, const cv::Size &, double, double, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:663
	Result<cv::GMat*> cv_gapi_gaussianBlur_const_GMatR_const_SizeR_double_double_int_const_ScalarR(const cv::GMat* src, const cv::Size* ksize, double sigmaX, double sigmaY, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::gaussianBlur(*src, *ksize, sigmaX, sigmaY, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// inRange(const cv::GMat &, const cv::GScalar &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1460
	Result<cv::GMat*> cv_gapi_inRange_const_GMatR_const_GScalarR_const_GScalarR(const cv::GMat* src, const cv::GScalar* threshLow, const cv::GScalar* threshUp) {
		try {
			cv::GMat ret = cv::gapi::inRange(*src, *threshLow, *threshUp);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// mask(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:841
	Result<cv::GMat*> cv_gapi_mask_const_GMatR_const_GMatR(const cv::GMat* src, const cv::GMat* mask) {
		try {
			cv::GMat ret = cv::gapi::mask(*src, *mask);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// max(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1239
	Result<cv::GMat*> cv_gapi_max_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::max(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// merge3(const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1560
	Result<cv::GMat*> cv_gapi_merge3_const_GMatR_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2, const cv::GMat* src3) {
		try {
			cv::GMat ret = cv::gapi::merge3(*src1, *src2, *src3);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// merge4(const cv::GMat &, const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1541
	Result<cv::GMat*> cv_gapi_merge4_const_GMatR_const_GMatR_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2, const cv::GMat* src3, const cv::GMat* src4) {
		try {
			cv::GMat ret = cv::gapi::merge4(*src1, *src2, *src3, *src4);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// min(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1222
	Result<cv::GMat*> cv_gapi_min_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2) {
		try {
			cv::GMat ret = cv::gapi::min(*src1, *src2);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// morphologyEx(const cv::GMat &, const cv::MorphTypes, const cv::Mat &, const cv::Point &, const int, const cv::BorderTypes, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:807
	Result<cv::GMat*> cv_gapi_morphologyEx_const_GMatR_const_MorphTypes_const_MatR_const_PointR_const_int_const_BorderTypes_const_ScalarR(const cv::GMat* src, const cv::MorphTypes op, const cv::Mat* kernel, const cv::Point* anchor, const int iterations, const cv::BorderTypes borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::morphologyEx(*src, op, *kernel, *anchor, iterations, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// mulC(const cv::GMat &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:764
	Result<cv::GMat*> cv_gapi_mulC_const_GMatR_const_GScalarR_int(const cv::GMat* src, const cv::GScalar* multiplier, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::mulC(*src, *multiplier, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// mulC(const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:762
	Result<cv::GMat*> cv_gapi_mulC_const_GMatR_double_int(const cv::GMat* src, double multiplier, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::mulC(*src, multiplier, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// mulC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:766
	Result<cv::GMat*> cv_gapi_mulC_const_GScalarR_const_GMatR_int(const cv::GScalar* multiplier, const cv::GMat* src, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::mulC(*multiplier, *src, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// mul(const cv::GMat &, const cv::GMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:744
	Result<cv::GMat*> cv_gapi_mul_const_GMatR_const_GMatR_double_int(const cv::GMat* src1, const cv::GMat* src2, double scale, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::mul(*src1, *src2, scale, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// normInf(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1389
	Result<cv::GScalar*> cv_gapi_normInf_const_GMatR(const cv::GMat* src) {
		try {
			cv::GScalar ret = cv::gapi::normInf(*src);
			return Ok(new cv::GScalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalar*>))
	}
	
	// normL1(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1344
	Result<cv::GScalar*> cv_gapi_normL1_const_GMatR(const cv::GMat* src) {
		try {
			cv::GScalar ret = cv::gapi::normL1(*src);
			return Ok(new cv::GScalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalar*>))
	}
	
	// normL2(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1366
	Result<cv::GScalar*> cv_gapi_normL2_const_GMatR(const cv::GMat* src) {
		try {
			cv::GScalar ret = cv::gapi::normL2(*src);
			return Ok(new cv::GScalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalar*>))
	}
	
	// normalize(const cv::GMat &, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1814
	Result<cv::GMat*> cv_gapi_normalize_const_GMatR_double_double_int_int(const cv::GMat* src, double alpha, double beta, int norm_type, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::normalize(*src, alpha, beta, norm_type, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// descr_of(const cv::gapi::own::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gmat.hpp:262
	Result<cv::GMatDesc*> cv_gapi_own_descr_of_const_MatR(const cv::gapi::own::Mat* mat) {
		try {
			cv::GMatDesc ret = cv::gapi::own::descr_of(*mat);
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// phase(const cv::GMat &, const cv::GMat &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:918
	Result<cv::GMat*> cv_gapi_phase_const_GMatR_const_GMatR_bool(const cv::GMat* x, const cv::GMat* y, bool angleInDegrees) {
		try {
			cv::GMat ret = cv::gapi::phase(*x, *y, angleInDegrees);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// remap(const cv::GMat &, const cv::Mat &, const cv::Mat &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1627
	Result<cv::GMat*> cv_gapi_remap_const_GMatR_const_MatR_const_MatR_int_int_const_ScalarR(const cv::GMat* src, const cv::Mat* map1, const cv::Mat* map2, int interpolation, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::remap(*src, *map1, *map2, interpolation, borderMode, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// resizeP(const cv::GMatP &, const cv::Size &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1521
	Result<cv::GMatP*> cv_gapi_resizeP_const_GMatPR_const_SizeR_int(const cv::GMatP* src, const cv::Size* dsize, int interpolation) {
		try {
			cv::GMatP ret = cv::gapi::resizeP(*src, *dsize, interpolation);
			return Ok(new cv::GMatP(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatP*>))
	}
	
	// select(const cv::GMat &, const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1200
	Result<cv::GMat*> cv_gapi_select_const_GMatR_const_GMatR_const_GMatR(const cv::GMat* src1, const cv::GMat* src2, const cv::GMat* mask) {
		try {
			cv::GMat ret = cv::gapi::select(*src1, *src2, *mask);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// sepFilter(const cv::GMat &, int, const cv::Mat &, const cv::Mat &, const cv::Point &, const cv::Scalar &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/imgproc.hpp:532
	Result<cv::GMat*> cv_gapi_sepFilter_const_GMatR_int_const_MatR_const_MatR_const_PointR_const_ScalarR_int_const_ScalarR(const cv::GMat* src, int ddepth, const cv::Mat* kernelX, const cv::Mat* kernelY, const cv::Point* anchor, const cv::Scalar* delta, int borderType, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::sepFilter(*src, ddepth, *kernelX, *kernelY, *anchor, *delta, borderType, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// sqrt(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:929
	Result<cv::GMat*> cv_gapi_sqrt_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::sqrt(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// BGR(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:43
	Result<cv::GMat*> cv_gapi_streaming_BGR_const_GFrameR(const cv::GFrame* in) {
		try {
			cv::GMat ret = cv::gapi::streaming::BGR(*in);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// UV(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:63
	Result<cv::GMat*> cv_gapi_streaming_UV_const_GFrameR(const cv::GFrame* frame) {
		try {
			cv::GMat ret = cv::gapi::streaming::UV(*frame);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// Y(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:53
	Result<cv::GMat*> cv_gapi_streaming_Y_const_GFrameR(const cv::GFrame* frame) {
		try {
			cv::GMat ret = cv::gapi::streaming::Y(*frame);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// desync(const cv::GFrame &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/desync.hpp:79
	Result<cv::GFrame*> cv_gapi_streaming_desync_const_GFrameR(const cv::GFrame* f) {
		try {
			cv::GFrame ret = cv::gapi::streaming::desync(*f);
			return Ok(new cv::GFrame(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrame*>))
	}
	
	// desync(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/desync.hpp:78
	Result<cv::GMat*> cv_gapi_streaming_desync_const_GMatR(const cv::GMat* g) {
		try {
			cv::GMat ret = cv::gapi::streaming::desync(*g);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// kernels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/streaming/format.hpp:16
	Result<cv::gapi::GKernelPackage*> cv_gapi_streaming_kernels() {
		try {
			cv::gapi::GKernelPackage ret = cv::gapi::streaming::kernels();
			return Ok(new cv::gapi::GKernelPackage(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::GKernelPackage*>))
	}
	
	// subC(const cv::GMat &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:704
	Result<cv::GMat*> cv_gapi_subC_const_GMatR_const_GScalarR_int(const cv::GMat* src, const cv::GScalar* c, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::subC(*src, *c, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// subRC(const cv::GScalar &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:723
	Result<cv::GMat*> cv_gapi_subRC_const_GScalarR_const_GMatR_int(const cv::GScalar* c, const cv::GMat* src, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::subRC(*c, *src, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// sub(const cv::GMat &, const cv::GMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:685
	Result<cv::GMat*> cv_gapi_sub_const_GMatR_const_GMatR_int(const cv::GMat* src1, const cv::GMat* src2, int ddepth) {
		try {
			cv::GMat ret = cv::gapi::sub(*src1, *src2, ddepth);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// sum(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1285
	Result<cv::GScalar*> cv_gapi_sum_const_GMatR(const cv::GMat* src) {
		try {
			cv::GScalar ret = cv::gapi::sum(*src);
			return Ok(new cv::GScalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalar*>))
	}
	
	// threshold(const cv::GMat &, const cv::GScalar &, const cv::GScalar &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1438
	Result<cv::GMat*> cv_gapi_threshold_const_GMatR_const_GScalarR_const_GScalarR_int(const cv::GMat* src, const cv::GScalar* thresh, const cv::GScalar* maxval, int type) {
		try {
			cv::GMat ret = cv::gapi::threshold(*src, *thresh, *maxval, type);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// transpose(const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1952
	Result<cv::GMat*> cv_gapi_transpose_const_GMatR(const cv::GMat* src) {
		try {
			cv::GMat ret = cv::gapi::transpose(*src);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// warpAffine(const cv::GMat &, const cv::Mat &, const cv::Size &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1863
	Result<cv::GMat*> cv_gapi_warpAffine_const_GMatR_const_MatR_const_SizeR_int_int_const_ScalarR(const cv::GMat* src, const cv::Mat* M, const cv::Size* dsize, int flags, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::warpAffine(*src, *M, *dsize, flags, borderMode, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// warpPerspective(const cv::GMat &, const cv::Mat &, const cv::Size &, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/core.hpp:1838
	Result<cv::GMat*> cv_gapi_warpPerspective_const_GMatR_const_MatR_const_SizeR_int_int_const_ScalarR(const cv::GMat* src, const cv::Mat* M, const cv::Size* dsize, int flags, int borderMode, const cv::Scalar* borderValue) {
		try {
			cv::GMat ret = cv::gapi::warpPerspective(*src, *M, *dsize, flags, borderMode, *borderValue);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator+(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:16
	Result<cv::GMat*> cv_operatorA_const_GMatR_const_GMatR(const cv::GMat* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator+(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator+(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:18
	Result<cv::GMat*> cv_operatorA_const_GMatR_const_GScalarR(const cv::GMat* lhs, const cv::GScalar* rhs) {
		try {
			cv::GMat ret = cv::operator+(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator+(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:19
	Result<cv::GMat*> cv_operatorA_const_GScalarR_const_GMatR(const cv::GScalar* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator+(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator/(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:33
	Result<cv::GMat*> cv_operatorD_const_GMatR_const_GMatR(const cv::GMat* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator/(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator/(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:31
	Result<cv::GMat*> cv_operatorD_const_GMatR_const_GScalarR(const cv::GMat* lhs, const cv::GScalar* rhs) {
		try {
			cv::GMat ret = cv::operator/(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator/(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:32
	Result<cv::GMat*> cv_operatorD_const_GScalarR_const_GMatR(const cv::GScalar* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator/(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator==(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:52
	Result<cv::GMat*> cv_operatorEQ_const_GMatR_const_GMatR(const cv::GMat* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator==(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator==(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:59
	Result<cv::GMat*> cv_operatorEQ_const_GMatR_const_GScalarR(const cv::GMat* lhs, const cv::GScalar* rhs) {
		try {
			cv::GMat ret = cv::operator==(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator==(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:66
	Result<cv::GMat*> cv_operatorEQ_const_GScalarR_const_GMatR(const cv::GScalar* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator==(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator-(const cv::GMat &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:21
	Result<cv::GMat*> cv_operatorS_const_GMatR_const_GMatR(const cv::GMat* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator-(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator-(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:23
	Result<cv::GMat*> cv_operatorS_const_GMatR_const_GScalarR(const cv::GMat* lhs, const cv::GScalar* rhs) {
		try {
			cv::GMat ret = cv::operator-(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator-(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:24
	Result<cv::GMat*> cv_operatorS_const_GScalarR_const_GMatR(const cv::GScalar* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator-(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator*(const cv::GMat &, const cv::GScalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:28
	Result<cv::GMat*> cv_operatorX_const_GMatR_const_GScalarR(const cv::GMat* lhs, const cv::GScalar* rhs) {
		try {
			cv::GMat ret = cv::operator*(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator*(const cv::GMat &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:26
	Result<cv::GMat*> cv_operatorX_const_GMatR_float(const cv::GMat* lhs, float rhs) {
		try {
			cv::GMat ret = cv::operator*(*lhs, rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator*(const cv::GScalar &, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:29
	Result<cv::GMat*> cv_operatorX_const_GScalarR_const_GMatR(const cv::GScalar* lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator*(*lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// operator*(float, const cv::GMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/operators.hpp:27
	Result<cv::GMat*> cv_operatorX_float_const_GMatR(float lhs, const cv::GMat* rhs) {
		try {
			cv::GMat ret = cv::operator*(lhs, *rhs);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// validate_input_arg(const cv::GRunArg &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gproto.hpp:154
	Result_void cv_validate_input_arg_const_GRunArgR(const cv::GRunArg* arg) {
		try {
			cv::validate_input_arg(*arg);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// validate_input_args(const cv::GRunArgs &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gproto.hpp:155
	Result_void cv_validate_input_args_const_GRunArgsR(const cv::GRunArgs* args) {
		try {
			cv::validate_input_args(*args);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:87
	cv::detail::ArgKind cv_GArg_getPropKind_const(const cv::GArg* instance) {
		cv::detail::ArgKind ret = instance->kind;
		return (cv::detail::ArgKind)ret;
	}
	
	// kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:87
	void cv_GArg_setPropKind_ArgKind(cv::GArg* instance, cv::detail::ArgKind val) {
		instance->kind = val;
	}
	
	// opaque_kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:88
	cv::detail::OpaqueKind cv_GArg_getPropOpaque_kind_const(const cv::GArg* instance) {
		cv::detail::OpaqueKind ret = instance->opaque_kind;
		return (cv::detail::OpaqueKind)ret;
	}
	
	// opaque_kind /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:88
	void cv_GArg_setPropOpaque_kind_OpaqueKind(cv::GArg* instance, cv::detail::OpaqueKind val) {
		instance->opaque_kind = val;
	}
	
	void cv_GArg_delete(cv::GArg* instance) {
		delete instance;
	}
	// GArg() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:49
	Result<cv::GArg*> cv_GArg_GArg() {
		try {
			cv::GArg* ret = new cv::GArg();
			return Ok<cv::GArg*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GArg*>))
	}
	
	void cv_GCall_delete(cv::GCall* instance) {
		delete instance;
	}
	// GCall(const cv::GKernel &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:31
	Result<cv::GCall*> cv_GCall_GCall_const_GKernelR(const cv::GKernel* k) {
		try {
			cv::GCall* ret = new cv::GCall(*k);
			return Ok<cv::GCall*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GCall*>))
	}
	
	// yield(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:42
	Result<cv::GMat*> cv_GCall_yield_int(cv::GCall* instance, int output) {
		try {
			cv::GMat ret = instance->yield(output);
			return Ok(new cv::GMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMat*>))
	}
	
	// yieldP(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:43
	Result<cv::GMatP*> cv_GCall_yieldP_int(cv::GCall* instance, int output) {
		try {
			cv::GMatP ret = instance->yieldP(output);
			return Ok(new cv::GMatP(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatP*>))
	}
	
	// yieldScalar(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:44
	Result<cv::GScalar*> cv_GCall_yieldScalar_int(cv::GCall* instance, int output) {
		try {
			cv::GScalar ret = instance->yieldScalar(output);
			return Ok(new cv::GScalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GScalar*>))
	}
	
	// yieldFrame(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:45
	Result<cv::GFrame*> cv_GCall_yieldFrame_int(cv::GCall* instance, int output) {
		try {
			cv::GFrame ret = instance->yieldFrame(output);
			return Ok(new cv::GFrame(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrame*>))
	}
	
	// kernel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:63
	Result<cv::GKernel*> cv_GCall_kernel(cv::GCall* instance) {
		try {
			cv::GKernel ret = instance->kernel();
			return Ok(new cv::GKernel(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GKernel*>))
	}
	
	// params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:64
	Result<cv::util::any> cv_GCall_params(cv::GCall* instance) {
		try {
			cv::util::any ret = instance->params();
			return Ok<cv::util::any>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::util::any>))
	}
	
	// setArgs(std::vector<GArg> &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcall.hpp:66
	Result_void cv_GCall_setArgs_vector_GArg_R(cv::GCall* instance, std::vector<cv::GArg>* args) {
		try {
			instance->setArgs(*args);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_GCompiled_delete(cv::GCompiled* instance) {
		delete instance;
	}
	// GCompiled() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:75
	Result<cv::GCompiled*> cv_GCompiled_GCompiled() {
		try {
			cv::GCompiled* ret = new cv::GCompiled();
			return Ok<cv::GCompiled*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GCompiled*>))
	}
	
	// operator bool() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:165
	Result<bool> cv_GCompiled_operator_bool_const(const cv::GCompiled* instance) {
		try {
			bool ret = instance->operator bool();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// canReshape() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:196
	Result<bool> cv_GCompiled_canReshape_const(const cv::GCompiled* instance) {
		try {
			bool ret = instance->canReshape();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// prepareForNewStream() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gcompiled.hpp:222
	Result_void cv_GCompiled_prepareForNewStream(cv::GCompiled* instance) {
		try {
			instance->prepareForNewStream();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fmt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:97
	cv::MediaFormat cv_GFrameDesc_getPropFmt_const(const cv::GFrameDesc* instance) {
		cv::MediaFormat ret = instance->fmt;
		return (cv::MediaFormat)ret;
	}
	
	// fmt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:97
	void cv_GFrameDesc_setPropFmt_MediaFormat(cv::GFrameDesc* instance, cv::MediaFormat val) {
		instance->fmt = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:98
	cv::Size cv_GFrameDesc_getPropSize_const(const cv::GFrameDesc* instance) {
		cv::Size ret = instance->size;
		return (cv::Size)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:98
	void cv_GFrameDesc_setPropSize_Size(cv::GFrameDesc* instance, cv::Size* val) {
		instance->size = *val;
	}
	
	void cv_GFrameDesc_delete(cv::GFrameDesc* instance) {
		delete instance;
	}
	// operator==(const cv::GFrameDesc &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gframe.hpp:100
	Result<bool> cv_GFrameDesc_operatorEQ_const_const_GFrameDescR(const cv::GFrameDesc* instance, const cv::GFrameDesc* unnamed) {
		try {
			bool ret = instance->operator==(*unnamed);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:48
	void* cv_GKernel_getPropName_const(const cv::GKernel* instance) {
		std::string ret = instance->name;
		return ocvrs_create_string(ret.c_str());
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:48
	void cv_GKernel_setPropName_string(cv::GKernel* instance, char* val) {
		instance->name = std::string(val);
	}
	
	// tag /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:49
	void* cv_GKernel_getPropTag_const(const cv::GKernel* instance) {
		std::string ret = instance->tag;
		return ocvrs_create_string(ret.c_str());
	}
	
	// tag /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:49
	void cv_GKernel_setPropTag_string(cv::GKernel* instance, char* val) {
		instance->tag = std::string(val);
	}
	
	// outShapes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:51
	cv::GShapes* cv_GKernel_getPropOutShapes_const(const cv::GKernel* instance) {
		cv::GShapes ret = instance->outShapes;
		return new cv::GShapes(ret);
	}
	
	// outShapes /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:51
	void cv_GKernel_setPropOutShapes_GShapes(cv::GKernel* instance, cv::GShapes* val) {
		instance->outShapes = *val;
	}
	
	// inKinds /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:52
	cv::GKinds* cv_GKernel_getPropInKinds_const(const cv::GKernel* instance) {
		cv::GKinds ret = instance->inKinds;
		return new cv::GKinds(ret);
	}
	
	// inKinds /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:52
	void cv_GKernel_setPropInKinds_GKinds(cv::GKernel* instance, cv::GKinds* val) {
		instance->inKinds = *val;
	}
	
	void cv_GKernel_delete(cv::GKernel* instance) {
		delete instance;
	}
	// opaque /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:61
	cv::util::any cv_GKernelImpl_getPropOpaque_const(const cv::GKernelImpl* instance) {
		cv::util::any ret = instance->opaque;
		return (cv::util::any)ret;
	}
	
	// opaque /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:61
	void cv_GKernelImpl_setPropOpaque_any(cv::GKernelImpl* instance, cv::util::any val) {
		instance->opaque = val;
	}
	
	void cv_GKernelImpl_delete(cv::GKernelImpl* instance) {
		delete instance;
	}
	cv::GMat* cv_GMatP_to_GMat(cv::GMatP* instance) {
		return dynamic_cast<cv::GMat*>(instance);
	}
	
	void cv_GMatP_delete(cv::GMatP* instance) {
		delete instance;
	}
	void cv_GRunArg_delete(cv::GRunArg* instance) {
		delete instance;
	}
	// GRunArg() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:129
	Result<cv::GRunArg*> cv_GRunArg_GRunArg() {
		try {
			cv::GRunArg* ret = new cv::GRunArg();
			return Ok<cv::GRunArg*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GRunArg*>))
	}
	
	// GRunArg(const cv::GRunArg &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:130
	Result<cv::GRunArg*> cv_GRunArg_GRunArg_const_GRunArgR(const cv::GRunArg* arg) {
		try {
			cv::GRunArg* ret = new cv::GRunArg(*arg);
			return Ok<cv::GRunArg*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GRunArg*>))
	}
	
	// GRunArg(cv::GRunArg &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/garg.hpp:131
	Result<cv::GRunArg*> cv_GRunArg_GRunArg_GRunArgR(cv::GRunArg* arg) {
		try {
			cv::GRunArg* ret = new cv::GRunArg(*arg);
			return Ok<cv::GRunArg*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GRunArg*>))
	}
	
	// description /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:30
	void* cv_GTransform_getPropDescription_const(const cv::GTransform* instance) {
		std::string ret = instance->description;
		return ocvrs_create_string(ret.c_str());
	}
	
	// description /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gtransform.hpp:30
	void cv_GTransform_setPropDescription_string(cv::GTransform* instance, char* val) {
		instance->description = std::string(val);
	}
	
	void cv_GTransform_delete(cv::GTransform* instance) {
		delete instance;
	}
	void cv_MediaFrame_delete(cv::MediaFrame* instance) {
		delete instance;
	}
	// MediaFrame() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:70
	Result<cv::MediaFrame*> cv_MediaFrame_MediaFrame() {
		try {
			cv::MediaFrame* ret = new cv::MediaFrame();
			return Ok<cv::MediaFrame*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MediaFrame*>))
	}
	
	// access(cv::MediaFrame::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:103
	Result<cv::MediaFrame::View*> cv_MediaFrame_access_const_Access(const cv::MediaFrame* instance, cv::MediaFrame::Access mode) {
		try {
			cv::MediaFrame::View ret = instance->access(mode);
			return Ok(new cv::MediaFrame::View(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MediaFrame::View*>))
	}
	
	// desc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:110
	Result<cv::GFrameDesc*> cv_MediaFrame_desc_const(const cv::MediaFrame* instance) {
		try {
			cv::GFrameDesc ret = instance->desc();
			return Ok(new cv::GFrameDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrameDesc*>))
	}
	
	// blobParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:115
	Result<cv::util::any> cv_MediaFrame_blobParams_const(const cv::MediaFrame* instance) {
		try {
			cv::util::any ret = instance->blobParams();
			return Ok<cv::util::any>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::util::any>))
	}
	
	// meta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:239
	Result<cv::GFrameDesc*> cv_MediaFrame_IAdapter_meta_const(const cv::MediaFrame::IAdapter* instance) {
		try {
			cv::GFrameDesc ret = instance->meta();
			return Ok(new cv::GFrameDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GFrameDesc*>))
	}
	
	// access(MediaFrame::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:240
	Result<cv::MediaFrame::View*> cv_MediaFrame_IAdapter_access_Access(cv::MediaFrame::IAdapter* instance, cv::MediaFrame::Access unnamed) {
		try {
			cv::MediaFrame::View ret = instance->access(unnamed);
			return Ok(new cv::MediaFrame::View(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MediaFrame::View*>))
	}
	
	// blobParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:243
	Result<cv::util::any> cv_MediaFrame_IAdapter_blobParams_const(const cv::MediaFrame::IAdapter* instance) {
		try {
			cv::util::any ret = instance->blobParams();
			return Ok<cv::util::any>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::util::any>))
	}
	
	void cv_MediaFrame_View_delete(cv::MediaFrame::View* instance) {
		delete instance;
	}
	// View(cv::MediaFrame::View &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/media.hpp:211
	cv::MediaFrame::View* cv_MediaFrame_View_View_ViewR(cv::MediaFrame::View* unnamed) {
		cv::MediaFrame::View* ret = new cv::MediaFrame::View(*unnamed);
		return (cv::MediaFrame::View*)ret;
	}
	
	void cv_RMat_delete(cv::RMat* instance) {
		delete instance;
	}
	// RMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:124
	cv::RMat* cv_RMat_RMat() {
		cv::RMat* ret = new cv::RMat();
		return (cv::RMat*)ret;
	}
	
	// desc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:126
	Result<cv::GMatDesc*> cv_RMat_desc_const(const cv::RMat* instance) {
		try {
			cv::GMatDesc ret = instance->desc();
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// access(cv::RMat::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:133
	Result<cv::RMat::View*> cv_RMat_access_const_Access(const cv::RMat* instance, cv::RMat::Access a) {
		try {
			cv::RMat::View ret = instance->access(a);
			return Ok(new cv::RMat::View(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RMat::View*>))
	}
	
	// desc() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:108
	Result<cv::GMatDesc*> cv_RMat_Adapter_desc_const(const cv::RMat::Adapter instance) {
		try {
			cv::GMatDesc ret = instance.desc();
			return Ok(new cv::GMatDesc(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::GMatDesc*>))
	}
	
	// access(cv::RMat::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:112
	Result<cv::RMat::View*> cv_RMat_Adapter_access_Access(cv::RMat::Adapter instance, cv::RMat::Access unnamed) {
		try {
			cv::RMat::View ret = instance.access(unnamed);
			return Ok(new cv::RMat::View(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RMat::View*>))
	}
	
	void cv_RMat_View_delete(cv::RMat::View* instance) {
		delete instance;
	}
	// View() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:62
	cv::RMat::View* cv_RMat_View_View() {
		cv::RMat::View* ret = new cv::RMat::View();
		return (cv::RMat::View*)ret;
	}
	
	// View(cv::RMat::View &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:68
	cv::RMat::View* cv_RMat_View_View_ViewR(cv::RMat::View* unnamed) {
		cv::RMat::View* ret = new cv::RMat::View(*unnamed);
		return (cv::RMat::View*)ret;
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:72
	Result<cv::Size> cv_RMat_View_size_const(const cv::RMat::View* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// dims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:73
	Result<const std::vector<int>*> cv_RMat_View_dims_const(const cv::RMat::View* instance) {
		try {
			const std::vector<int> ret = instance->dims();
			return Ok(new const std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<int>*>))
	}
	
	// cols() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:74
	Result<int> cv_RMat_View_cols_const(const cv::RMat::View* instance) {
		try {
			int ret = instance->cols();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// rows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:75
	Result<int> cv_RMat_View_rows_const(const cv::RMat::View* instance) {
		try {
			int ret = instance->rows();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:76
	Result<int> cv_RMat_View_type_const(const cv::RMat::View* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:77
	Result<int> cv_RMat_View_depth_const(const cv::RMat::View* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// chan() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:78
	Result<int> cv_RMat_View_chan_const(const cv::RMat::View* instance) {
		try {
			int ret = instance->chan();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:79
	Result<size_t> cv_RMat_View_elemSize_const(const cv::RMat::View* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// step(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:93
	Result<size_t> cv_RMat_View_step_const_size_t(const cv::RMat::View* instance, size_t i) {
		try {
			size_t ret = instance->step(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// steps() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/rmat.hpp:94
	Result<const cv::RMat::View::stepsT*> cv_RMat_View_steps_const(const cv::RMat::View* instance) {
		try {
			const cv::RMat::View::stepsT ret = instance->steps();
			return Ok(new const cv::RMat::View::stepsT(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::RMat::View::stepsT*>))
	}
	
	void cv_GArrayU_delete(cv::detail::GArrayU* instance) {
		delete instance;
	}
	void cv_GOpaqueU_delete(cv::detail::GOpaqueU* instance) {
		delete instance;
	}
	void cv_GBackend_delete(cv::gapi::GBackend* instance) {
		delete instance;
	}
	// GBackend() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:382
	Result<cv::gapi::GBackend*> cv_gapi_GBackend_GBackend() {
		try {
			cv::gapi::GBackend* ret = new cv::gapi::GBackend();
			return Ok<cv::gapi::GBackend*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::GBackend*>))
	}
	
	// operator==(const cv::gapi::GBackend &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:389
	Result<bool> cv_gapi_GBackend_operatorEQ_const_const_GBackendR(const cv::gapi::GBackend* instance, const cv::gapi::GBackend* rhs) {
		try {
			bool ret = instance->operator==(*rhs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// val /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:35
	double** cv_gapi_own_Scalar_getPropVal(cv::gapi::own::Scalar* instance) {
		double(*ret)[4] = &instance->val;
		return (double**)ret;
	}
	
	void cv_Own_Scalar_delete(cv::gapi::own::Scalar* instance) {
		delete instance;
	}
	// Scalar() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:23
	cv::gapi::own::Scalar* cv_gapi_own_Scalar_Scalar() {
		cv::gapi::own::Scalar* ret = new cv::gapi::own::Scalar();
		return (cv::gapi::own::Scalar*)ret;
	}
	
	// Scalar(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:24
	Result<cv::gapi::own::Scalar*> cv_gapi_own_Scalar_Scalar_double(double v0) {
		try {
			cv::gapi::own::Scalar* ret = new cv::gapi::own::Scalar(v0);
			return Ok<cv::gapi::own::Scalar*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::own::Scalar*>))
	}
	
	// Scalar(double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:25
	Result<cv::gapi::own::Scalar*> cv_gapi_own_Scalar_Scalar_double_double_double_double(double v0, double v1, double v2, double v3) {
		try {
			cv::gapi::own::Scalar* ret = new cv::gapi::own::Scalar(v0, v1, v2, v3);
			return Ok<cv::gapi::own::Scalar*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::own::Scalar*>))
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:30
	Result<const double> cv_gapi_own_Scalar_operator___const_int(const cv::gapi::own::Scalar* instance, int i) {
		try {
			const double ret = instance->operator[](i);
			return Ok<const double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const double>))
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:31
	Result<double> cv_gapi_own_Scalar_operator___int(cv::gapi::own::Scalar* instance, int i) {
		try {
			double ret = instance->operator[](i);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// all(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/own/scalar.hpp:33
	Result<cv::gapi::own::Scalar*> cv_gapi_own_Scalar_all_double(double v0) {
		try {
			cv::gapi::own::Scalar ret = cv::gapi::own::Scalar::all(v0);
			return Ok(new cv::gapi::own::Scalar(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::gapi::own::Scalar*>))
	}
	
	// pkg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:728
	cv::gapi::GKernelPackage* cv_gapi_use_only_getPropPkg_const(const cv::gapi::use_only* instance) {
		cv::gapi::GKernelPackage ret = instance->pkg;
		return new cv::gapi::GKernelPackage(ret);
	}
	
	// pkg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/gapi/gkernel.hpp:728
	void cv_gapi_use_only_setPropPkg_GKernelPackage(cv::gapi::use_only* instance, cv::gapi::GKernelPackage* val) {
		instance->pkg = *val;
	}
	
	void cv_use_only_delete(cv::gapi::use_only* instance) {
		delete instance;
	}
	cv::GRunArg* cv_Data_to_GRunArg(cv::gapi::wip::Data* instance) {
		return dynamic_cast<cv::GRunArg*>(instance);
	}
	
	void cv_Data_delete(cv::gapi::wip::Data* instance) {
		delete instance;
	}
}
