#include "ocvrs_common.hpp"
#include <opencv2/freetype.hpp>
#include "freetype_types.hpp"

extern "C" {
	// createFreeType2() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/freetype.hpp:184
	Result<cv::Ptr<cv::freetype::FreeType2>*> cv_freetype_createFreeType2() {
		try {
			cv::Ptr<cv::freetype::FreeType2> ret = cv::freetype::createFreeType2();
			return Ok(new cv::Ptr<cv::freetype::FreeType2>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::freetype::FreeType2>*>))
	}
	
	// loadFontData(cv::String, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/freetype.hpp:85
	Result_void cv_freetype_FreeType2_loadFontData_String_int(cv::freetype::FreeType2* instance, char* fontFileName, int id) {
		try {
			instance->loadFontData(std::string(fontFileName), id);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setSplitNumber(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/freetype.hpp:96
	Result_void cv_freetype_FreeType2_setSplitNumber_int(cv::freetype::FreeType2* instance, int num) {
		try {
			instance->setSplitNumber(num);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// putText(cv::InputOutputArray, const cv::String &, cv::Point, int, cv::Scalar, int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/freetype.hpp:112
	Result_void cv_freetype_FreeType2_putText_const__InputOutputArrayR_const_StringR_Point_int_Scalar_int_int_bool(cv::freetype::FreeType2* instance, const cv::_InputOutputArray* img, const char* text, cv::Point* org, int fontHeight, cv::Scalar* color, int thickness, int line_type, bool bottomLeftOrigin) {
		try {
			instance->putText(*img, std::string(text), *org, fontHeight, *color, thickness, line_type, bottomLeftOrigin);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTextSize(const cv::String &, int, int, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/freetype.hpp:173
	Result<cv::Size> cv_freetype_FreeType2_getTextSize_const_StringR_int_int_intX(cv::freetype::FreeType2* instance, const char* text, int fontHeight, int thickness, int* baseLine) {
		try {
			cv::Size ret = instance->getTextSize(std::string(text), fontHeight, thickness, baseLine);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
}
