#include "ocvrs_common.hpp"
#include <opencv2/flann.hpp>
#include "flann_types.hpp"

extern "C" {
	// flann_distance_type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann.hpp:61
	Result<cvflann::flann_distance_t> cvflann_flann_distance_type() {
		try {
			cvflann::flann_distance_t ret = cvflann::flann_distance_type();
			return Ok<cvflann::flann_distance_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cvflann::flann_distance_t>))
	}
	
	// set_distance_type(cvflann::flann_distance_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann.hpp:62
	Result_void cvflann_set_distance_type_flann_distance_t_int(cvflann::flann_distance_t distance_type, int order) {
		try {
			cvflann::set_distance_type(distance_type, order);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::flann::IndexParams* cv_AutotunedIndexParams_to_IndexParams(cv::flann::AutotunedIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_AutotunedIndexParams_delete(cv::flann::AutotunedIndexParams* instance) {
		delete instance;
	}
	// AutotunedIndexParams(float, float, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:118
	Result<cv::flann::AutotunedIndexParams*> cv_flann_AutotunedIndexParams_AutotunedIndexParams_float_float_float_float(float target_precision, float build_weight, float memory_weight, float sample_fraction) {
		try {
			cv::flann::AutotunedIndexParams* ret = new cv::flann::AutotunedIndexParams(target_precision, build_weight, memory_weight, sample_fraction);
			return Ok<cv::flann::AutotunedIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::AutotunedIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_CompositeIndexParams_to_IndexParams(cv::flann::CompositeIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_CompositeIndexParams_delete(cv::flann::CompositeIndexParams* instance) {
		delete instance;
	}
	// CompositeIndexParams(int, int, int, cvflann::flann_centers_init_t, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:112
	Result<cv::flann::CompositeIndexParams*> cv_flann_CompositeIndexParams_CompositeIndexParams_int_int_int_flann_centers_init_t_float(int trees, int branching, int iterations, cvflann::flann_centers_init_t centers_init, float cb_index) {
		try {
			cv::flann::CompositeIndexParams* ret = new cv::flann::CompositeIndexParams(trees, branching, iterations, centers_init, cb_index);
			return Ok<cv::flann::CompositeIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::CompositeIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_HierarchicalClusteringIndexParams_to_IndexParams(cv::flann::HierarchicalClusteringIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_HierarchicalClusteringIndexParams_delete(cv::flann::HierarchicalClusteringIndexParams* instance) {
		delete instance;
	}
	// HierarchicalClusteringIndexParams(int, cvflann::flann_centers_init_t, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:124
	Result<cv::flann::HierarchicalClusteringIndexParams*> cv_flann_HierarchicalClusteringIndexParams_HierarchicalClusteringIndexParams_int_flann_centers_init_t_int_int(int branching, cvflann::flann_centers_init_t centers_init, int trees, int leaf_size) {
		try {
			cv::flann::HierarchicalClusteringIndexParams* ret = new cv::flann::HierarchicalClusteringIndexParams(branching, centers_init, trees, leaf_size);
			return Ok<cv::flann::HierarchicalClusteringIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::HierarchicalClusteringIndexParams*>))
	}
	
	void cv_Index_delete(cv::flann::Index* instance) {
		delete instance;
	}
	// Index() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:153
	Result<cv::flann::Index*> cv_flann_Index_Index() {
		try {
			cv::flann::Index* ret = new cv::flann::Index();
			return Ok<cv::flann::Index*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::Index*>))
	}
	
	// Index(cv::InputArray, const cv::flann::IndexParams &, cvflann::flann_distance_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:154
	Result<cv::flann::Index*> cv_flann_Index_Index_const__InputArrayR_const_IndexParamsR_flann_distance_t(const cv::_InputArray* features, const cv::flann::IndexParams* params, cvflann::flann_distance_t distType) {
		try {
			cv::flann::Index* ret = new cv::flann::Index(*features, *params, distType);
			return Ok<cv::flann::Index*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::Index*>))
	}
	
	// build(cv::InputArray, const cv::flann::IndexParams &, cvflann::flann_distance_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:157
	Result_void cv_flann_Index_build_const__InputArrayR_const_IndexParamsR_flann_distance_t(cv::flann::Index* instance, const cv::_InputArray* features, const cv::flann::IndexParams* params, cvflann::flann_distance_t distType) {
		try {
			instance->build(*features, *params, distType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnSearch(cv::InputArray, cv::OutputArray, cv::OutputArray, int, const cv::flann::SearchParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:158
	Result_void cv_flann_Index_knnSearch_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_int_const_SearchParamsR(cv::flann::Index* instance, const cv::_InputArray* query, const cv::_OutputArray* indices, const cv::_OutputArray* dists, int knn, const cv::flann::SearchParams* params) {
		try {
			instance->knnSearch(*query, *indices, *dists, knn, *params);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusSearch(cv::InputArray, cv::OutputArray, cv::OutputArray, double, int, const cv::flann::SearchParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:161
	Result<int> cv_flann_Index_radiusSearch_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_double_int_const_SearchParamsR(cv::flann::Index* instance, const cv::_InputArray* query, const cv::_OutputArray* indices, const cv::_OutputArray* dists, double radius, int maxResults, const cv::flann::SearchParams* params) {
		try {
			int ret = instance->radiusSearch(*query, *indices, *dists, radius, maxResults, *params);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// save(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:165
	Result_void cv_flann_Index_save_const_const_StringR(const cv::flann::Index* instance, const char* filename) {
		try {
			instance->save(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// load(cv::InputArray, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:166
	Result<bool> cv_flann_Index_load_const__InputArrayR_const_StringR(cv::flann::Index* instance, const cv::_InputArray* features, const char* filename) {
		try {
			bool ret = instance->load(*features, std::string(filename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:167
	Result_void cv_flann_Index_release(cv::flann::Index* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDistance() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:168
	Result<cvflann::flann_distance_t> cv_flann_Index_getDistance_const(const cv::flann::Index* instance) {
		try {
			cvflann::flann_distance_t ret = instance->getDistance();
			return Ok<cvflann::flann_distance_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cvflann::flann_distance_t>))
	}
	
	// getAlgorithm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:169
	Result<cvflann::flann_algorithm_t> cv_flann_Index_getAlgorithm_const(const cv::flann::Index* instance) {
		try {
			cvflann::flann_algorithm_t ret = instance->getAlgorithm();
			return Ok<cvflann::flann_algorithm_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cvflann::flann_algorithm_t>))
	}
	
	// params /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:93
	void* cv_flann_IndexParams_getPropParams(cv::flann::IndexParams* instance) {
		void* ret = instance->params;
		return (void*)ret;
	}
	
	// params /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:93
	void cv_flann_IndexParams_setPropParams_voidX(cv::flann::IndexParams* instance, void* val) {
		instance->params = val;
	}
	
	void cv_IndexParams_delete(cv::flann::IndexParams* instance) {
		delete instance;
	}
	// IndexParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:73
	Result<cv::flann::IndexParams*> cv_flann_IndexParams_IndexParams() {
		try {
			cv::flann::IndexParams* ret = new cv::flann::IndexParams();
			return Ok<cv::flann::IndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::IndexParams*>))
	}
	
	// getString(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:76
	Result<void*> cv_flann_IndexParams_getString_const_const_StringR_const_StringR(const cv::flann::IndexParams* instance, const char* key, const char* defaultVal) {
		try {
			cv::String ret = instance->getString(std::string(key), std::string(defaultVal));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getInt(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:77
	Result<int> cv_flann_IndexParams_getInt_const_const_StringR_int(const cv::flann::IndexParams* instance, const char* key, int defaultVal) {
		try {
			int ret = instance->getInt(std::string(key), defaultVal);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getDouble(const cv::String &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:78
	Result<double> cv_flann_IndexParams_getDouble_const_const_StringR_double(const cv::flann::IndexParams* instance, const char* key, double defaultVal) {
		try {
			double ret = instance->getDouble(std::string(key), defaultVal);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setString(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:80
	Result_void cv_flann_IndexParams_setString_const_StringR_const_StringR(cv::flann::IndexParams* instance, const char* key, const char* value) {
		try {
			instance->setString(std::string(key), std::string(value));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInt(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:81
	Result_void cv_flann_IndexParams_setInt_const_StringR_int(cv::flann::IndexParams* instance, const char* key, int value) {
		try {
			instance->setInt(std::string(key), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setDouble(const cv::String &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:82
	Result_void cv_flann_IndexParams_setDouble_const_StringR_double(cv::flann::IndexParams* instance, const char* key, double value) {
		try {
			instance->setDouble(std::string(key), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFloat(const cv::String &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:83
	Result_void cv_flann_IndexParams_setFloat_const_StringR_float(cv::flann::IndexParams* instance, const char* key, float value) {
		try {
			instance->setFloat(std::string(key), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBool(const cv::String &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:84
	Result_void cv_flann_IndexParams_setBool_const_StringR_bool(cv::flann::IndexParams* instance, const char* key, bool value) {
		try {
			instance->setBool(std::string(key), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setAlgorithm(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:85
	Result_void cv_flann_IndexParams_setAlgorithm_int(cv::flann::IndexParams* instance, int value) {
		try {
			instance->setAlgorithm(value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAll(std::vector<String> &, std::vector<FlannIndexType> &, std::vector<String> &, std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:88
	Result_void cv_flann_IndexParams_getAll_const_vector_String_R_vector_FlannIndexType_R_vector_String_R_vector_double_R(const cv::flann::IndexParams* instance, std::vector<cv::String>* names, std::vector<cv::flann::FlannIndexType>* types, std::vector<cv::String>* strValues, std::vector<double>* numValues) {
		try {
			instance->getAll(*names, *types, *strValues, *numValues);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::flann::IndexParams* cv_KDTreeIndexParams_to_IndexParams(cv::flann::KDTreeIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_KDTreeIndexParams_delete(cv::flann::KDTreeIndexParams* instance) {
		delete instance;
	}
	// KDTreeIndexParams(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:102
	Result<cv::flann::KDTreeIndexParams*> cv_flann_KDTreeIndexParams_KDTreeIndexParams_int(int trees) {
		try {
			cv::flann::KDTreeIndexParams* ret = new cv::flann::KDTreeIndexParams(trees);
			return Ok<cv::flann::KDTreeIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::KDTreeIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_KMeansIndexParams_to_IndexParams(cv::flann::KMeansIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_KMeansIndexParams_delete(cv::flann::KMeansIndexParams* instance) {
		delete instance;
	}
	// KMeansIndexParams(int, int, cvflann::flann_centers_init_t, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:130
	Result<cv::flann::KMeansIndexParams*> cv_flann_KMeansIndexParams_KMeansIndexParams_int_int_flann_centers_init_t_float(int branching, int iterations, cvflann::flann_centers_init_t centers_init, float cb_index) {
		try {
			cv::flann::KMeansIndexParams* ret = new cv::flann::KMeansIndexParams(branching, iterations, centers_init, cb_index);
			return Ok<cv::flann::KMeansIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::KMeansIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_LinearIndexParams_to_IndexParams(cv::flann::LinearIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_LinearIndexParams_delete(cv::flann::LinearIndexParams* instance) {
		delete instance;
	}
	// LinearIndexParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:107
	Result<cv::flann::LinearIndexParams*> cv_flann_LinearIndexParams_LinearIndexParams() {
		try {
			cv::flann::LinearIndexParams* ret = new cv::flann::LinearIndexParams();
			return Ok<cv::flann::LinearIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::LinearIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_LshIndexParams_to_IndexParams(cv::flann::LshIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_LshIndexParams_delete(cv::flann::LshIndexParams* instance) {
		delete instance;
	}
	// LshIndexParams(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:136
	Result<cv::flann::LshIndexParams*> cv_flann_LshIndexParams_LshIndexParams_int_int_int(int table_number, int key_size, int multi_probe_level) {
		try {
			cv::flann::LshIndexParams* ret = new cv::flann::LshIndexParams(table_number, key_size, multi_probe_level);
			return Ok<cv::flann::LshIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::LshIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_SavedIndexParams_to_IndexParams(cv::flann::SavedIndexParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_SavedIndexParams_delete(cv::flann::SavedIndexParams* instance) {
		delete instance;
	}
	// SavedIndexParams(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:141
	Result<cv::flann::SavedIndexParams*> cv_flann_SavedIndexParams_SavedIndexParams_const_StringR(const char* filename) {
		try {
			cv::flann::SavedIndexParams* ret = new cv::flann::SavedIndexParams(std::string(filename));
			return Ok<cv::flann::SavedIndexParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::SavedIndexParams*>))
	}
	
	cv::flann::IndexParams* cv_SearchParams_to_IndexParams(cv::flann::SearchParams* instance) {
		return dynamic_cast<cv::flann::IndexParams*>(instance);
	}
	
	void cv_SearchParams_delete(cv::flann::SearchParams* instance) {
		delete instance;
	}
	// SearchParams(int, float, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:146
	Result<cv::flann::SearchParams*> cv_flann_SearchParams_SearchParams_int_float_bool_bool(int checks, float eps, bool sorted, bool explore_all_trees) {
		try {
			cv::flann::SearchParams* ret = new cv::flann::SearchParams(checks, eps, sorted, explore_all_trees);
			return Ok<cv::flann::SearchParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::SearchParams*>))
	}
	
	// SearchParams(int, float, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/flann/miniflann.hpp:147
	Result<cv::flann::SearchParams*> cv_flann_SearchParams_SearchParams_int_float_bool(int checks, float eps, bool sorted) {
		try {
			cv::flann::SearchParams* ret = new cv::flann::SearchParams(checks, eps, sorted);
			return Ok<cv::flann::SearchParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::flann::SearchParams*>))
	}
	
}
