#include "ocvrs_common.hpp"
#include <opencv2/features2d.hpp>
#include "features2d_types.hpp"

extern "C" {
	// AGAST(cv::InputArray, std::vector<KeyPoint> &, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:611
	Result_void cv_AGAST_const__InputArrayR_vector_KeyPoint_R_int_bool(const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, int threshold, bool nonmaxSuppression) {
		try {
			cv::AGAST(*image, *keypoints, threshold, nonmaxSuppression);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// AGAST(cv::InputArray, std::vector<KeyPoint> &, int, bool, AgastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:632
	Result_void cv_AGAST_const__InputArrayR_vector_KeyPoint_R_int_bool_DetectorType(const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, int threshold, bool nonmaxSuppression, cv::AgastFeatureDetector::DetectorType type) {
		try {
			cv::AGAST(*image, *keypoints, threshold, nonmaxSuppression, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// FAST(cv::InputArray, std::vector<KeyPoint> &, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:551
	Result_void cv_FAST_const__InputArrayR_vector_KeyPoint_R_int_bool(const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, int threshold, bool nonmaxSuppression) {
		try {
			cv::FAST(*image, *keypoints, threshold, nonmaxSuppression);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// FAST(cv::InputArray, std::vector<KeyPoint> &, int, bool, FastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:572
	Result_void cv_FAST_const__InputArrayR_vector_KeyPoint_R_int_bool_DetectorType(const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, int threshold, bool nonmaxSuppression, cv::FastFeatureDetector::DetectorType type) {
		try {
			cv::FAST(*image, *keypoints, threshold, nonmaxSuppression, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeRecallPrecisionCurve(const std::vector<std::vector<DMatch>> &, const std::vector<std::vector<uchar>> &, std::vector<Point2f> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1364
	Result_void cv_computeRecallPrecisionCurve_const_vector_vector_DMatch__R_const_vector_vector_unsigned_char__R_vector_Point2f_R(const std::vector<std::vector<cv::DMatch>>* matches1to2, const std::vector<std::vector<unsigned char>>* correctMatches1to2Mask, std::vector<cv::Point2f>* recallPrecisionCurve) {
		try {
			cv::computeRecallPrecisionCurve(*matches1to2, *correctMatches1to2Mask, *recallPrecisionCurve);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawKeypoints(cv::InputArray, const std::vector<KeyPoint> &, cv::InputOutputArray, const cv::Scalar &, cv::DrawMatchesFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1308
	Result_void cv_drawKeypoints_const__InputArrayR_const_vector_KeyPoint_R_const__InputOutputArrayR_const_ScalarR_DrawMatchesFlags(const cv::_InputArray* image, const std::vector<cv::KeyPoint>* keypoints, const cv::_InputOutputArray* outImage, const cv::Scalar* color, cv::DrawMatchesFlags flags) {
		try {
			cv::drawKeypoints(*image, *keypoints, *outImage, *color, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawMatches(cv::InputArray, const std::vector<KeyPoint> &, cv::InputArray, const std::vector<KeyPoint> &, const std::vector<DMatch> &, cv::InputOutputArray, const cv::Scalar &, const cv::Scalar &, const std::vector<char> &, cv::DrawMatchesFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1333
	Result_void cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_DMatch_R_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vector_char_R_DrawMatchesFlags(const cv::_InputArray* img1, const std::vector<cv::KeyPoint>* keypoints1, const cv::_InputArray* img2, const std::vector<cv::KeyPoint>* keypoints2, const std::vector<cv::DMatch>* matches1to2, const cv::_InputOutputArray* outImg, const cv::Scalar* matchColor, const cv::Scalar* singlePointColor, const std::vector<char>* matchesMask, cv::DrawMatchesFlags flags) {
		try {
			cv::drawMatches(*img1, *keypoints1, *img2, *keypoints2, *matches1to2, *outImg, *matchColor, *singlePointColor, *matchesMask, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawMatches(cv::InputArray, const std::vector<KeyPoint> &, cv::InputArray, const std::vector<KeyPoint> &, const std::vector<DMatch> &, cv::InputOutputArray, const int, const cv::Scalar &, const cv::Scalar &, const std::vector<char> &, cv::DrawMatchesFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1340
	Result_void cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_DMatch_R_const__InputOutputArrayR_const_int_const_ScalarR_const_ScalarR_const_vector_char_R_DrawMatchesFlags(const cv::_InputArray* img1, const std::vector<cv::KeyPoint>* keypoints1, const cv::_InputArray* img2, const std::vector<cv::KeyPoint>* keypoints2, const std::vector<cv::DMatch>* matches1to2, const cv::_InputOutputArray* outImg, const int matchesThickness, const cv::Scalar* matchColor, const cv::Scalar* singlePointColor, const std::vector<char>* matchesMask, cv::DrawMatchesFlags flags) {
		try {
			cv::drawMatches(*img1, *keypoints1, *img2, *keypoints2, *matches1to2, *outImg, matchesThickness, *matchColor, *singlePointColor, *matchesMask, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawMatches(cv::InputArray, const std::vector<KeyPoint> &, cv::InputArray, const std::vector<KeyPoint> &, const std::vector<std::vector<DMatch>> &, cv::InputOutputArray, const cv::Scalar &, const cv::Scalar &, const std::vector<std::vector<char>> &, cv::DrawMatchesFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1347
	Result_void cv_drawMatches_const__InputArrayR_const_vector_KeyPoint_R_const__InputArrayR_const_vector_KeyPoint_R_const_vector_vector_DMatch__R_const__InputOutputArrayR_const_ScalarR_const_ScalarR_const_vector_vector_char__R_DrawMatchesFlags(const cv::_InputArray* img1, const std::vector<cv::KeyPoint>* keypoints1, const cv::_InputArray* img2, const std::vector<cv::KeyPoint>* keypoints2, const std::vector<std::vector<cv::DMatch>>* matches1to2, const cv::_InputOutputArray* outImg, const cv::Scalar* matchColor, const cv::Scalar* singlePointColor, const std::vector<std::vector<char>>* matchesMask, cv::DrawMatchesFlags flags) {
		try {
			cv::drawMatches(*img1, *keypoints1, *img2, *keypoints2, *matches1to2, *outImg, *matchColor, *singlePointColor, *matchesMask, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// evaluateFeatureDetector(const cv::Mat &, const cv::Mat &, const cv::Mat &, std::vector<KeyPoint> *, std::vector<KeyPoint> *, float &, int &, const Ptr<cv::FeatureDetector> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1359
	Result_void cv_evaluateFeatureDetector_const_MatR_const_MatR_const_MatR_vector_KeyPoint_X_vector_KeyPoint_X_floatR_intR_const_Ptr_Feature2D_R(const cv::Mat* img1, const cv::Mat* img2, const cv::Mat* H1to2, std::vector<cv::KeyPoint>* keypoints1, std::vector<cv::KeyPoint>* keypoints2, float* repeatability, int* correspCount, const cv::Ptr<cv::Feature2D>* fdetector) {
		try {
			cv::evaluateFeatureDetector(*img1, *img2, *H1to2, keypoints1, keypoints2, *repeatability, *correspCount, *fdetector);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNearestPoint(const std::vector<Point2f> &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1369
	Result<int> cv_getNearestPoint_const_vector_Point2f_R_float(const std::vector<cv::Point2f>* recallPrecisionCurve, float l_precision) {
		try {
			int ret = cv::getNearestPoint(*recallPrecisionCurve, l_precision);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getRecall(const std::vector<Point2f> &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1368
	Result<float> cv_getRecall_const_vector_Point2f_R_float(const std::vector<cv::Point2f>* recallPrecisionCurve, float l_precision) {
		try {
			float ret = cv::getRecall(*recallPrecisionCurve, l_precision);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// create(AKAZE::DescriptorType, int, int, float, int, int, KAZE::DiffusivityType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:828
	Result<cv::Ptr<cv::AKAZE>*> cv_AKAZE_create_DescriptorType_int_int_float_int_int_DiffusivityType(cv::AKAZE::DescriptorType descriptor_type, int descriptor_size, int descriptor_channels, float threshold, int nOctaves, int nOctaveLayers, cv::KAZE::DiffusivityType diffusivity) {
		try {
			cv::Ptr<cv::AKAZE> ret = cv::AKAZE::create(descriptor_type, descriptor_size, descriptor_channels, threshold, nOctaves, nOctaveLayers, diffusivity);
			return Ok(new cv::Ptr<cv::AKAZE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::AKAZE>*>))
	}
	
	// setDescriptorType(AKAZE::DescriptorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:833
	Result_void cv_AKAZE_setDescriptorType_DescriptorType(cv::AKAZE* instance, cv::AKAZE::DescriptorType dtype) {
		try {
			instance->setDescriptorType(dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDescriptorType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:834
	Result<cv::AKAZE::DescriptorType> cv_AKAZE_getDescriptorType_const(const cv::AKAZE* instance) {
		try {
			cv::AKAZE::DescriptorType ret = instance->getDescriptorType();
			return Ok<cv::AKAZE::DescriptorType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AKAZE::DescriptorType>))
	}
	
	// setDescriptorSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:836
	Result_void cv_AKAZE_setDescriptorSize_int(cv::AKAZE* instance, int dsize) {
		try {
			instance->setDescriptorSize(dsize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDescriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:837
	Result<int> cv_AKAZE_getDescriptorSize_const(const cv::AKAZE* instance) {
		try {
			int ret = instance->getDescriptorSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDescriptorChannels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:839
	Result_void cv_AKAZE_setDescriptorChannels_int(cv::AKAZE* instance, int dch) {
		try {
			instance->setDescriptorChannels(dch);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDescriptorChannels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:840
	Result<int> cv_AKAZE_getDescriptorChannels_const(const cv::AKAZE* instance) {
		try {
			int ret = instance->getDescriptorChannels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:842
	Result_void cv_AKAZE_setThreshold_double(cv::AKAZE* instance, double threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:843
	Result<double> cv_AKAZE_getThreshold_const(const cv::AKAZE* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNOctaves(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:845
	Result_void cv_AKAZE_setNOctaves_int(cv::AKAZE* instance, int octaves) {
		try {
			instance->setNOctaves(octaves);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNOctaves() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:846
	Result<int> cv_AKAZE_getNOctaves_const(const cv::AKAZE* instance) {
		try {
			int ret = instance->getNOctaves();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNOctaveLayers(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:848
	Result_void cv_AKAZE_setNOctaveLayers_int(cv::AKAZE* instance, int octaveLayers) {
		try {
			instance->setNOctaveLayers(octaveLayers);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNOctaveLayers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:849
	Result<int> cv_AKAZE_getNOctaveLayers_const(const cv::AKAZE* instance) {
		try {
			int ret = instance->getNOctaveLayers();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDiffusivity(KAZE::DiffusivityType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:851
	Result_void cv_AKAZE_setDiffusivity_DiffusivityType(cv::AKAZE* instance, cv::KAZE::DiffusivityType diff) {
		try {
			instance->setDiffusivity(diff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDiffusivity() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:852
	Result<cv::KAZE::DiffusivityType> cv_AKAZE_getDiffusivity_const(const cv::AKAZE* instance) {
		try {
			cv::KAZE::DiffusivityType ret = instance->getDiffusivity();
			return Ok<cv::KAZE::DiffusivityType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KAZE::DiffusivityType>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:853
	Result<void*> cv_AKAZE_getDefaultName_const(const cv::AKAZE* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(const Ptr<cv::Feature2D> &, int, int, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:244
	Result<cv::Ptr<cv::AffineFeature>*> cv_AffineFeature_create_const_Ptr_Feature2D_R_int_int_float_float(const cv::Ptr<cv::Feature2D>* backend, int maxTilt, int minTilt, float tiltStep, float rotateStepBase) {
		try {
			cv::Ptr<cv::AffineFeature> ret = cv::AffineFeature::create(*backend, maxTilt, minTilt, tiltStep, rotateStepBase);
			return Ok(new cv::Ptr<cv::AffineFeature>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::AffineFeature>*>))
	}
	
	// setViewParams(const std::vector<float> &, const std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:247
	Result_void cv_AffineFeature_setViewParams_const_vector_float_R_const_vector_float_R(cv::AffineFeature* instance, const std::vector<float>* tilts, const std::vector<float>* rolls) {
		try {
			instance->setViewParams(*tilts, *rolls);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getViewParams(std::vector<float> &, std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:248
	Result_void cv_AffineFeature_getViewParams_const_vector_float_R_vector_float_R(const cv::AffineFeature* instance, std::vector<float>* tilts, std::vector<float>* rolls) {
		try {
			instance->getViewParams(*tilts, *rolls);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:249
	Result<void*> cv_AffineFeature_getDefaultName_const(const cv::AffineFeature* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(int, bool, AgastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:595
	Result<cv::Ptr<cv::AgastFeatureDetector>*> cv_AgastFeatureDetector_create_int_bool_DetectorType(int threshold, bool nonmaxSuppression, cv::AgastFeatureDetector::DetectorType type) {
		try {
			cv::Ptr<cv::AgastFeatureDetector> ret = cv::AgastFeatureDetector::create(threshold, nonmaxSuppression, type);
			return Ok(new cv::Ptr<cv::AgastFeatureDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::AgastFeatureDetector>*>))
	}
	
	// setThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:599
	Result_void cv_AgastFeatureDetector_setThreshold_int(cv::AgastFeatureDetector* instance, int threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:600
	Result<int> cv_AgastFeatureDetector_getThreshold_const(const cv::AgastFeatureDetector* instance) {
		try {
			int ret = instance->getThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNonmaxSuppression(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:602
	Result_void cv_AgastFeatureDetector_setNonmaxSuppression_bool(cv::AgastFeatureDetector* instance, bool f) {
		try {
			instance->setNonmaxSuppression(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNonmaxSuppression() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:603
	Result<bool> cv_AgastFeatureDetector_getNonmaxSuppression_const(const cv::AgastFeatureDetector* instance) {
		try {
			bool ret = instance->getNonmaxSuppression();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setType(AgastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:605
	Result_void cv_AgastFeatureDetector_setType_DetectorType(cv::AgastFeatureDetector* instance, cv::AgastFeatureDetector::DetectorType type) {
		try {
			instance->setType(type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:606
	Result<cv::AgastFeatureDetector::DetectorType> cv_AgastFeatureDetector_getType_const(const cv::AgastFeatureDetector* instance) {
		try {
			cv::AgastFeatureDetector::DetectorType ret = instance->getType();
			return Ok<cv::AgastFeatureDetector::DetectorType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AgastFeatureDetector::DetectorType>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:607
	Result<void*> cv_AgastFeatureDetector_getDefaultName_const(const cv::AgastFeatureDetector* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::Algorithm* cv_BFMatcher_to_Algorithm(cv::BFMatcher* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_BFMatcher_delete(cv::BFMatcher* instance) {
		delete instance;
	}
	// BFMatcher(int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1189
	Result<cv::BFMatcher*> cv_BFMatcher_BFMatcher_int_bool(int normType, bool crossCheck) {
		try {
			cv::BFMatcher* ret = new cv::BFMatcher(normType, crossCheck);
			return Ok<cv::BFMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::BFMatcher*>))
	}
	
	// isMaskSupported() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1193
	Result<bool> cv_BFMatcher_isMaskSupported_const(const cv::BFMatcher* instance) {
		try {
			bool ret = instance->isMaskSupported();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1207
	Result<cv::Ptr<cv::BFMatcher>*> cv_BFMatcher_create_int_bool(int normType, bool crossCheck) {
		try {
			cv::Ptr<cv::BFMatcher> ret = cv::BFMatcher::create(normType, crossCheck);
			return Ok(new cv::Ptr<cv::BFMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BFMatcher>*>))
	}
	
	// clone(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1209
	Result<cv::Ptr<cv::DescriptorMatcher>*> cv_BFMatcher_clone_const_bool(const cv::BFMatcher* instance, bool emptyTrainData) {
		try {
			cv::Ptr<cv::DescriptorMatcher> ret = instance->clone(emptyTrainData);
			return Ok(new cv::Ptr<cv::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DescriptorMatcher>*>))
	}
	
	void cv_BOWImgDescriptorExtractor_delete(cv::BOWImgDescriptorExtractor* instance) {
		delete instance;
	}
	// BOWImgDescriptorExtractor(const Ptr<cv::DescriptorExtractor> &, const Ptr<cv::DescriptorMatcher> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1472
	Result<cv::BOWImgDescriptorExtractor*> cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_Ptr_Feature2D_R_const_Ptr_DescriptorMatcher_R(const cv::Ptr<cv::Feature2D>* dextractor, const cv::Ptr<cv::DescriptorMatcher>* dmatcher) {
		try {
			cv::BOWImgDescriptorExtractor* ret = new cv::BOWImgDescriptorExtractor(*dextractor, *dmatcher);
			return Ok<cv::BOWImgDescriptorExtractor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::BOWImgDescriptorExtractor*>))
	}
	
	// BOWImgDescriptorExtractor(const Ptr<cv::DescriptorMatcher> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1475
	Result<cv::BOWImgDescriptorExtractor*> cv_BOWImgDescriptorExtractor_BOWImgDescriptorExtractor_const_Ptr_DescriptorMatcher_R(const cv::Ptr<cv::DescriptorMatcher>* dmatcher) {
		try {
			cv::BOWImgDescriptorExtractor* ret = new cv::BOWImgDescriptorExtractor(*dmatcher);
			return Ok<cv::BOWImgDescriptorExtractor*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::BOWImgDescriptorExtractor*>))
	}
	
	// setVocabulary(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1483
	Result_void cv_BOWImgDescriptorExtractor_setVocabulary_const_MatR(cv::BOWImgDescriptorExtractor* instance, const cv::Mat* vocabulary) {
		try {
			instance->setVocabulary(*vocabulary);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getVocabulary() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1487
	Result<const cv::Mat*> cv_BOWImgDescriptorExtractor_getVocabulary_const(const cv::BOWImgDescriptorExtractor* instance) {
		try {
			const cv::Mat ret = instance->getVocabulary();
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// compute(cv::InputArray, std::vector<KeyPoint> &, cv::OutputArray, std::vector<std::vector<int>> *, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1499
	Result_void cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR_vector_vector_int__X_MatX(cv::BOWImgDescriptorExtractor* instance, const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, const cv::_OutputArray* imgDescriptor, std::vector<std::vector<int>>* pointIdxsOfClusters, cv::Mat* descriptors) {
		try {
			instance->compute(*image, *keypoints, *imgDescriptor, pointIdxsOfClusters, descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::OutputArray, std::vector<std::vector<int>> *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1508
	Result_void cv_BOWImgDescriptorExtractor_compute_const__InputArrayR_const__OutputArrayR_vector_vector_int__X(cv::BOWImgDescriptorExtractor* instance, const cv::_InputArray* keypointDescriptors, const cv::_OutputArray* imgDescriptor, std::vector<std::vector<int>>* pointIdxsOfClusters) {
		try {
			instance->compute(*keypointDescriptors, *imgDescriptor, pointIdxsOfClusters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute2(const cv::Mat &, std::vector<KeyPoint> &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1512
	Result_void cv_BOWImgDescriptorExtractor_compute2_const_MatR_vector_KeyPoint_R_MatR(cv::BOWImgDescriptorExtractor* instance, const cv::Mat* image, std::vector<cv::KeyPoint>* keypoints, cv::Mat* imgDescriptor) {
		try {
			instance->compute2(*image, *keypoints, *imgDescriptor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// descriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1517
	Result<int> cv_BOWImgDescriptorExtractor_descriptorSize_const(const cv::BOWImgDescriptorExtractor* instance) {
		try {
			int ret = instance->descriptorSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// descriptorType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1521
	Result<int> cv_BOWImgDescriptorExtractor_descriptorType_const(const cv::BOWImgDescriptorExtractor* instance) {
		try {
			int ret = instance->descriptorType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	void cv_BOWKMeansTrainer_delete(cv::BOWKMeansTrainer* instance) {
		delete instance;
	}
	// BOWKMeansTrainer(int, const cv::TermCriteria &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1436
	Result<cv::BOWKMeansTrainer*> cv_BOWKMeansTrainer_BOWKMeansTrainer_int_const_TermCriteriaR_int_int(int clusterCount, const cv::TermCriteria* termcrit, int attempts, int flags) {
		try {
			cv::BOWKMeansTrainer* ret = new cv::BOWKMeansTrainer(clusterCount, *termcrit, attempts, flags);
			return Ok<cv::BOWKMeansTrainer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::BOWKMeansTrainer*>))
	}
	
	// cluster() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1441
	Result<cv::Mat*> cv_BOWKMeansTrainer_cluster_const(const cv::BOWKMeansTrainer* instance) {
		try {
			cv::Mat ret = instance->cluster();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// cluster(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1442
	Result<cv::Mat*> cv_BOWKMeansTrainer_cluster_const_const_MatR(const cv::BOWKMeansTrainer* instance, const cv::Mat* descriptors) {
		try {
			cv::Mat ret = instance->cluster(*descriptors);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// add(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1396
	Result_void cv_BOWTrainer_add_const_MatR(cv::BOWTrainer* instance, const cv::Mat* descriptors) {
		try {
			instance->add(*descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDescriptors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1400
	Result<const std::vector<cv::Mat>*> cv_BOWTrainer_getDescriptors_const(const cv::BOWTrainer* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->getDescriptors();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// descriptorsCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1404
	Result<int> cv_BOWTrainer_descriptorsCount_const(const cv::BOWTrainer* instance) {
		try {
			int ret = instance->descriptorsCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1406
	Result_void cv_BOWTrainer_clear(cv::BOWTrainer* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cluster() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1409
	Result<cv::Mat*> cv_BOWTrainer_cluster_const(const cv::BOWTrainer* instance) {
		try {
			cv::Mat ret = instance->cluster();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// cluster(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1420
	Result<cv::Mat*> cv_BOWTrainer_cluster_const_const_MatR(const cv::BOWTrainer* instance, const cv::Mat* descriptors) {
		try {
			cv::Mat ret = instance->cluster(*descriptors);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	cv::Algorithm* cv_BRISK_to_Algorithm(cv::BRISK* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::Feature2D* cv_BRISK_to_Feature2D(cv::BRISK* instance) {
		return dynamic_cast<cv::Feature2D*>(instance);
	}
	
	void cv_BRISK_delete(cv::BRISK* instance) {
		delete instance;
	}
	// create(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:333
	Result<cv::Ptr<cv::BRISK>*> cv_BRISK_create_int_int_float(int thresh, int octaves, float patternScale) {
		try {
			cv::Ptr<cv::BRISK> ret = cv::BRISK::create(thresh, octaves, patternScale);
			return Ok(new cv::Ptr<cv::BRISK>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BRISK>*>))
	}
	
	// create(const std::vector<float> &, const std::vector<int> &, float, float, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:346
	Result<cv::Ptr<cv::BRISK>*> cv_BRISK_create_const_vector_float_R_const_vector_int_R_float_float_const_vector_int_R(const std::vector<float>* radiusList, const std::vector<int>* numberList, float dMax, float dMin, const std::vector<int>* indexChange) {
		try {
			cv::Ptr<cv::BRISK> ret = cv::BRISK::create(*radiusList, *numberList, dMax, dMin, *indexChange);
			return Ok(new cv::Ptr<cv::BRISK>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BRISK>*>))
	}
	
	// create(int, int, const std::vector<float> &, const std::vector<int> &, float, float, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:362
	Result<cv::Ptr<cv::BRISK>*> cv_BRISK_create_int_int_const_vector_float_R_const_vector_int_R_float_float_const_vector_int_R(int thresh, int octaves, const std::vector<float>* radiusList, const std::vector<int>* numberList, float dMax, float dMin, const std::vector<int>* indexChange) {
		try {
			cv::Ptr<cv::BRISK> ret = cv::BRISK::create(thresh, octaves, *radiusList, *numberList, dMax, dMin, *indexChange);
			return Ok(new cv::Ptr<cv::BRISK>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::BRISK>*>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:365
	Result<void*> cv_BRISK_getDefaultName_const(const cv::BRISK* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// setThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:370
	Result_void cv_BRISK_setThreshold_int(cv::BRISK* instance, int threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:371
	Result<int> cv_BRISK_getThreshold_const(const cv::BRISK* instance) {
		try {
			int ret = instance->getThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setOctaves(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:376
	Result_void cv_BRISK_setOctaves_int(cv::BRISK* instance, int octaves) {
		try {
			instance->setOctaves(octaves);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOctaves() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:377
	Result<int> cv_BRISK_getOctaves_const(const cv::BRISK* instance) {
		try {
			int ret = instance->getOctaves();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// add(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:956
	Result_void cv_DescriptorMatcher_add_const__InputArrayR(cv::DescriptorMatcher* instance, const cv::_InputArray* descriptors) {
		try {
			instance->add(*descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTrainDescriptors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:960
	Result<const std::vector<cv::Mat>*> cv_DescriptorMatcher_getTrainDescriptors_const(const cv::DescriptorMatcher* instance) {
		try {
			const std::vector<cv::Mat> ret = instance->getTrainDescriptors();
			return Ok(new const std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::Mat>*>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:964
	Result_void cv_DescriptorMatcher_clear(cv::DescriptorMatcher* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:968
	Result<bool> cv_DescriptorMatcher_empty_const(const cv::DescriptorMatcher* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isMaskSupported() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:972
	Result<bool> cv_DescriptorMatcher_isMaskSupported_const(const cv::DescriptorMatcher* instance) {
		try {
			bool ret = instance->isMaskSupported();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// train() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:981
	Result_void cv_DescriptorMatcher_train(cv::DescriptorMatcher* instance) {
		try {
			instance->train();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(cv::InputArray, cv::InputArray, std::vector<DMatch> &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:999
	Result_void cv_DescriptorMatcher_match_const_const__InputArrayR_const__InputArrayR_vector_DMatch_R_const__InputArrayR(const cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<cv::DMatch>* matches, const cv::_InputArray* mask) {
		try {
			instance->match(*queryDescriptors, *trainDescriptors, *matches, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(cv::InputArray, cv::InputArray, std::vector<std::vector<DMatch>> &, int, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1020
	Result_void cv_DescriptorMatcher_knnMatch_const_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(const cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const cv::_InputArray* mask, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *trainDescriptors, *matches, k, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(cv::InputArray, cv::InputArray, std::vector<std::vector<DMatch>> &, float, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1043
	Result_void cv_DescriptorMatcher_radiusMatch_const_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(const cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const cv::_InputArray* mask, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *trainDescriptors, *matches, maxDistance, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(cv::InputArray, std::vector<DMatch> &, cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1054
	Result_void cv_DescriptorMatcher_match_const__InputArrayR_vector_DMatch_R_const__InputArrayR(cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<cv::DMatch>* matches, const cv::_InputArray* masks) {
		try {
			instance->match(*queryDescriptors, *matches, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(cv::InputArray, std::vector<std::vector<DMatch>> &, int, cv::InputArrayOfArrays, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1067
	Result_void cv_DescriptorMatcher_knnMatch_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const cv::_InputArray* masks, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *matches, k, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(cv::InputArray, std::vector<std::vector<DMatch>> &, float, cv::InputArrayOfArrays, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1081
	Result_void cv_DescriptorMatcher_radiusMatch_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(cv::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const cv::_InputArray* masks, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *matches, maxDistance, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1085
	Result_void cv_DescriptorMatcher_write_const_const_StringR(const cv::DescriptorMatcher* instance, const char* fileName) {
		try {
			instance->write(std::string(fileName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1091
	Result_void cv_DescriptorMatcher_read_const_StringR(cv::DescriptorMatcher* instance, const char* fileName) {
		try {
			instance->read(std::string(fileName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1098
	Result_void cv_DescriptorMatcher_read_const_FileNodeR(cv::DescriptorMatcher* instance, const cv::FileNode* unnamed) {
		try {
			instance->read(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1100
	Result_void cv_DescriptorMatcher_write_const_FileStorageR(const cv::DescriptorMatcher* instance, cv::FileStorage* unnamed) {
		try {
			instance->write(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clone(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1108
	Result<cv::Ptr<cv::DescriptorMatcher>*> cv_DescriptorMatcher_clone_const_bool(const cv::DescriptorMatcher* instance, bool emptyTrainData) {
		try {
			cv::Ptr<cv::DescriptorMatcher> ret = instance->clone(emptyTrainData);
			return Ok(new cv::Ptr<cv::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DescriptorMatcher>*>))
	}
	
	// create(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1121
	Result<cv::Ptr<cv::DescriptorMatcher>*> cv_DescriptorMatcher_create_const_StringR(const char* descriptorMatcherType) {
		try {
			cv::Ptr<cv::DescriptorMatcher> ret = cv::DescriptorMatcher::create(std::string(descriptorMatcherType));
			return Ok(new cv::Ptr<cv::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DescriptorMatcher>*>))
	}
	
	// create(const DescriptorMatcher::MatcherType &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1123
	Result<cv::Ptr<cv::DescriptorMatcher>*> cv_DescriptorMatcher_create_const_MatcherTypeR(const cv::DescriptorMatcher::MatcherType* matcherType) {
		try {
			cv::Ptr<cv::DescriptorMatcher> ret = cv::DescriptorMatcher::create(*matcherType);
			return Ok(new cv::Ptr<cv::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DescriptorMatcher>*>))
	}
	
	// write(const Ptr<cv::FileStorage> &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1127
	Result_void cv_DescriptorMatcher_write_const_const_Ptr_FileStorage_R_const_StringR(const cv::DescriptorMatcher* instance, const cv::Ptr<cv::FileStorage>* fs, const char* name) {
		try {
			instance->write(*fs, std::string(name));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, bool, FastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:535
	Result<cv::Ptr<cv::FastFeatureDetector>*> cv_FastFeatureDetector_create_int_bool_DetectorType(int threshold, bool nonmaxSuppression, cv::FastFeatureDetector::DetectorType type) {
		try {
			cv::Ptr<cv::FastFeatureDetector> ret = cv::FastFeatureDetector::create(threshold, nonmaxSuppression, type);
			return Ok(new cv::Ptr<cv::FastFeatureDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::FastFeatureDetector>*>))
	}
	
	// setThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:539
	Result_void cv_FastFeatureDetector_setThreshold_int(cv::FastFeatureDetector* instance, int threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:540
	Result<int> cv_FastFeatureDetector_getThreshold_const(const cv::FastFeatureDetector* instance) {
		try {
			int ret = instance->getThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNonmaxSuppression(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:542
	Result_void cv_FastFeatureDetector_setNonmaxSuppression_bool(cv::FastFeatureDetector* instance, bool f) {
		try {
			instance->setNonmaxSuppression(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNonmaxSuppression() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:543
	Result<bool> cv_FastFeatureDetector_getNonmaxSuppression_const(const cv::FastFeatureDetector* instance) {
		try {
			bool ret = instance->getNonmaxSuppression();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setType(FastFeatureDetector::DetectorType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:545
	Result_void cv_FastFeatureDetector_setType_DetectorType(cv::FastFeatureDetector* instance, cv::FastFeatureDetector::DetectorType type) {
		try {
			instance->setType(type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:546
	Result<cv::FastFeatureDetector::DetectorType> cv_FastFeatureDetector_getType_const(const cv::FastFeatureDetector* instance) {
		try {
			cv::FastFeatureDetector::DetectorType ret = instance->getType();
			return Ok<cv::FastFeatureDetector::DetectorType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FastFeatureDetector::DetectorType>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:547
	Result<void*> cv_FastFeatureDetector_getDefaultName_const(const cv::FastFeatureDetector* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	 Result<cv::BRISK*> cv_Feature2D_to_BRISK(cv::Feature2D* instance) {
		try {
			return Ok(dynamic_cast<cv::BRISK*>(instance));
		} OCVRS_CATCH(Result<cv::BRISK*>)
	}
	
	 Result<cv::SIFT*> cv_Feature2D_to_SIFT(cv::Feature2D* instance) {
		try {
			return Ok(dynamic_cast<cv::SIFT*>(instance));
		} OCVRS_CATCH(Result<cv::SIFT*>)
	}
	
	 Result<cv::SimpleBlobDetector*> cv_Feature2D_to_SimpleBlobDetector(cv::Feature2D* instance) {
		try {
			return Ok(dynamic_cast<cv::SimpleBlobDetector*>(instance));
		} OCVRS_CATCH(Result<cv::SimpleBlobDetector*>)
	}
	
	cv::Algorithm* cv_Feature2D_to_Algorithm(cv::Feature2D* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_Feature2D_delete(cv::Feature2D* instance) {
		delete instance;
	}
	// detect(cv::InputArray, std::vector<KeyPoint> &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:147
	Result_void cv_Feature2D_detect_const__InputArrayR_vector_KeyPoint_R_const__InputArrayR(cv::Feature2D* instance, const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, const cv::_InputArray* mask) {
		try {
			instance->detect(*image, *keypoints, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArrayOfArrays, std::vector<std::vector<KeyPoint>> &, cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:158
	Result_void cv_Feature2D_detect_const__InputArrayR_vector_vector_KeyPoint__R_const__InputArrayR(cv::Feature2D* instance, const cv::_InputArray* images, std::vector<std::vector<cv::KeyPoint>>* keypoints, const cv::_InputArray* masks) {
		try {
			instance->detect(*images, *keypoints, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, std::vector<KeyPoint> &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:173
	Result_void cv_Feature2D_compute_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR(cv::Feature2D* instance, const cv::_InputArray* image, std::vector<cv::KeyPoint>* keypoints, const cv::_OutputArray* descriptors) {
		try {
			instance->compute(*image, *keypoints, *descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArrayOfArrays, std::vector<std::vector<KeyPoint>> &, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:187
	Result_void cv_Feature2D_compute_const__InputArrayR_vector_vector_KeyPoint__R_const__OutputArrayR(cv::Feature2D* instance, const cv::_InputArray* images, std::vector<std::vector<cv::KeyPoint>>* keypoints, const cv::_OutputArray* descriptors) {
		try {
			instance->compute(*images, *keypoints, *descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectAndCompute(cv::InputArray, cv::InputArray, std::vector<KeyPoint> &, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:192
	Result_void cv_Feature2D_detectAndCompute_const__InputArrayR_const__InputArrayR_vector_KeyPoint_R_const__OutputArrayR_bool(cv::Feature2D* instance, const cv::_InputArray* image, const cv::_InputArray* mask, std::vector<cv::KeyPoint>* keypoints, const cv::_OutputArray* descriptors, bool useProvidedKeypoints) {
		try {
			instance->detectAndCompute(*image, *mask, *keypoints, *descriptors, useProvidedKeypoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// descriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:197
	Result<int> cv_Feature2D_descriptorSize_const(const cv::Feature2D* instance) {
		try {
			int ret = instance->descriptorSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// descriptorType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:198
	Result<int> cv_Feature2D_descriptorType_const(const cv::Feature2D* instance) {
		try {
			int ret = instance->descriptorType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// defaultNorm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:199
	Result<int> cv_Feature2D_defaultNorm_const(const cv::Feature2D* instance) {
		try {
			int ret = instance->defaultNorm();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// write(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:201
	Result_void cv_Feature2D_write_const_const_StringR(const cv::Feature2D* instance, const char* fileName) {
		try {
			instance->write(std::string(fileName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:203
	Result_void cv_Feature2D_read_const_StringR(cv::Feature2D* instance, const char* fileName) {
		try {
			instance->read(std::string(fileName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:205
	Result_void cv_Feature2D_write_const_FileStorageR(const cv::Feature2D* instance, cv::FileStorage* unnamed) {
		try {
			instance->write(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:208
	Result_void cv_Feature2D_read_const_FileNodeR(cv::Feature2D* instance, const cv::FileNode* unnamed) {
		try {
			instance->read(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:211
	Result<bool> cv_Feature2D_empty_const(const cv::Feature2D* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:212
	Result<void*> cv_Feature2D_getDefaultName_const(const cv::Feature2D* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// write(const Ptr<cv::FileStorage> &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:215
	Result_void cv_Feature2D_write_const_const_Ptr_FileStorage_R_const_StringR(const cv::Feature2D* instance, const cv::Ptr<cv::FileStorage>* fs, const char* name) {
		try {
			instance->write(*fs, std::string(name));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_FlannBasedMatcher_to_Algorithm(cv::FlannBasedMatcher* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_FlannBasedMatcher_delete(cv::FlannBasedMatcher* instance) {
		delete instance;
	}
	// FlannBasedMatcher(const Ptr<flann::IndexParams> &, const Ptr<flann::SearchParams> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1232
	Result<cv::FlannBasedMatcher*> cv_FlannBasedMatcher_FlannBasedMatcher_const_Ptr_IndexParams_R_const_Ptr_SearchParams_R(const cv::Ptr<cv::flann::IndexParams>* indexParams, const cv::Ptr<cv::flann::SearchParams>* searchParams) {
		try {
			cv::FlannBasedMatcher* ret = new cv::FlannBasedMatcher(*indexParams, *searchParams);
			return Ok<cv::FlannBasedMatcher*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FlannBasedMatcher*>))
	}
	
	// add(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1235
	Result_void cv_FlannBasedMatcher_add_const__InputArrayR(cv::FlannBasedMatcher* instance, const cv::_InputArray* descriptors) {
		try {
			instance->add(*descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1236
	Result_void cv_FlannBasedMatcher_clear(cv::FlannBasedMatcher* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1239
	Result_void cv_FlannBasedMatcher_read_const_FileNodeR(cv::FlannBasedMatcher* instance, const cv::FileNode* unnamed) {
		try {
			instance->read(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1241
	Result_void cv_FlannBasedMatcher_write_const_FileStorageR(const cv::FlannBasedMatcher* instance, cv::FileStorage* unnamed) {
		try {
			instance->write(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// train() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1243
	Result_void cv_FlannBasedMatcher_train(cv::FlannBasedMatcher* instance) {
		try {
			instance->train();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isMaskSupported() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1244
	Result<bool> cv_FlannBasedMatcher_isMaskSupported_const(const cv::FlannBasedMatcher* instance) {
		try {
			bool ret = instance->isMaskSupported();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1246
	Result<cv::Ptr<cv::FlannBasedMatcher>*> cv_FlannBasedMatcher_create() {
		try {
			cv::Ptr<cv::FlannBasedMatcher> ret = cv::FlannBasedMatcher::create();
			return Ok(new cv::Ptr<cv::FlannBasedMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::FlannBasedMatcher>*>))
	}
	
	// clone(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:1248
	Result<cv::Ptr<cv::DescriptorMatcher>*> cv_FlannBasedMatcher_clone_const_bool(const cv::FlannBasedMatcher* instance, bool emptyTrainData) {
		try {
			cv::Ptr<cv::DescriptorMatcher> ret = instance->clone(emptyTrainData);
			return Ok(new cv::Ptr<cv::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DescriptorMatcher>*>))
	}
	
	// create(int, double, double, int, bool, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:640
	Result<cv::Ptr<cv::GFTTDetector>*> cv_GFTTDetector_create_int_double_double_int_bool_double(int maxCorners, double qualityLevel, double minDistance, int blockSize, bool useHarrisDetector, double k) {
		try {
			cv::Ptr<cv::GFTTDetector> ret = cv::GFTTDetector::create(maxCorners, qualityLevel, minDistance, blockSize, useHarrisDetector, k);
			return Ok(new cv::Ptr<cv::GFTTDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::GFTTDetector>*>))
	}
	
	// create(int, double, double, int, int, bool, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:642
	Result<cv::Ptr<cv::GFTTDetector>*> cv_GFTTDetector_create_int_double_double_int_int_bool_double(int maxCorners, double qualityLevel, double minDistance, int blockSize, int gradiantSize, bool useHarrisDetector, double k) {
		try {
			cv::Ptr<cv::GFTTDetector> ret = cv::GFTTDetector::create(maxCorners, qualityLevel, minDistance, blockSize, gradiantSize, useHarrisDetector, k);
			return Ok(new cv::Ptr<cv::GFTTDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::GFTTDetector>*>))
	}
	
	// setMaxFeatures(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:644
	Result_void cv_GFTTDetector_setMaxFeatures_int(cv::GFTTDetector* instance, int maxFeatures) {
		try {
			instance->setMaxFeatures(maxFeatures);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxFeatures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:645
	Result<int> cv_GFTTDetector_getMaxFeatures_const(const cv::GFTTDetector* instance) {
		try {
			int ret = instance->getMaxFeatures();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setQualityLevel(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:647
	Result_void cv_GFTTDetector_setQualityLevel_double(cv::GFTTDetector* instance, double qlevel) {
		try {
			instance->setQualityLevel(qlevel);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getQualityLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:648
	Result<double> cv_GFTTDetector_getQualityLevel_const(const cv::GFTTDetector* instance) {
		try {
			double ret = instance->getQualityLevel();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinDistance(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:650
	Result_void cv_GFTTDetector_setMinDistance_double(cv::GFTTDetector* instance, double minDistance) {
		try {
			instance->setMinDistance(minDistance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinDistance() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:651
	Result<double> cv_GFTTDetector_getMinDistance_const(const cv::GFTTDetector* instance) {
		try {
			double ret = instance->getMinDistance();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBlockSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:653
	Result_void cv_GFTTDetector_setBlockSize_int(cv::GFTTDetector* instance, int blockSize) {
		try {
			instance->setBlockSize(blockSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBlockSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:654
	Result<int> cv_GFTTDetector_getBlockSize_const(const cv::GFTTDetector* instance) {
		try {
			int ret = instance->getBlockSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setHarrisDetector(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:656
	Result_void cv_GFTTDetector_setHarrisDetector_bool(cv::GFTTDetector* instance, bool val) {
		try {
			instance->setHarrisDetector(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHarrisDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:657
	Result<bool> cv_GFTTDetector_getHarrisDetector_const(const cv::GFTTDetector* instance) {
		try {
			bool ret = instance->getHarrisDetector();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setK(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:659
	Result_void cv_GFTTDetector_setK_double(cv::GFTTDetector* instance, double k) {
		try {
			instance->setK(k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getK() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:660
	Result<double> cv_GFTTDetector_getK_const(const cv::GFTTDetector* instance) {
		try {
			double ret = instance->getK();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:661
	Result<void*> cv_GFTTDetector_getDefaultName_const(const cv::GFTTDetector* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(bool, bool, float, int, int, KAZE::DiffusivityType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:763
	Result<cv::Ptr<cv::KAZE>*> cv_KAZE_create_bool_bool_float_int_int_DiffusivityType(bool extended, bool upright, float threshold, int nOctaves, int nOctaveLayers, cv::KAZE::DiffusivityType diffusivity) {
		try {
			cv::Ptr<cv::KAZE> ret = cv::KAZE::create(extended, upright, threshold, nOctaves, nOctaveLayers, diffusivity);
			return Ok(new cv::Ptr<cv::KAZE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::KAZE>*>))
	}
	
	// setExtended(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:768
	Result_void cv_KAZE_setExtended_bool(cv::KAZE* instance, bool extended) {
		try {
			instance->setExtended(extended);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getExtended() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:769
	Result<bool> cv_KAZE_getExtended_const(const cv::KAZE* instance) {
		try {
			bool ret = instance->getExtended();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUpright(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:771
	Result_void cv_KAZE_setUpright_bool(cv::KAZE* instance, bool upright) {
		try {
			instance->setUpright(upright);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUpright() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:772
	Result<bool> cv_KAZE_getUpright_const(const cv::KAZE* instance) {
		try {
			bool ret = instance->getUpright();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:774
	Result_void cv_KAZE_setThreshold_double(cv::KAZE* instance, double threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:775
	Result<double> cv_KAZE_getThreshold_const(const cv::KAZE* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNOctaves(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:777
	Result_void cv_KAZE_setNOctaves_int(cv::KAZE* instance, int octaves) {
		try {
			instance->setNOctaves(octaves);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNOctaves() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:778
	Result<int> cv_KAZE_getNOctaves_const(const cv::KAZE* instance) {
		try {
			int ret = instance->getNOctaves();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNOctaveLayers(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:780
	Result_void cv_KAZE_setNOctaveLayers_int(cv::KAZE* instance, int octaveLayers) {
		try {
			instance->setNOctaveLayers(octaveLayers);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNOctaveLayers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:781
	Result<int> cv_KAZE_getNOctaveLayers_const(const cv::KAZE* instance) {
		try {
			int ret = instance->getNOctaveLayers();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDiffusivity(KAZE::DiffusivityType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:783
	Result_void cv_KAZE_setDiffusivity_DiffusivityType(cv::KAZE* instance, cv::KAZE::DiffusivityType diff) {
		try {
			instance->setDiffusivity(diff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDiffusivity() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:784
	Result<cv::KAZE::DiffusivityType> cv_KAZE_getDiffusivity_const(const cv::KAZE* instance) {
		try {
			cv::KAZE::DiffusivityType ret = instance->getDiffusivity();
			return Ok<cv::KAZE::DiffusivityType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KAZE::DiffusivityType>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:785
	Result<void*> cv_KAZE_getDefaultName_const(const cv::KAZE* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	void cv_KeyPointsFilter_delete(cv::KeyPointsFilter* instance) {
		delete instance;
	}
	// KeyPointsFilter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:95
	Result<cv::KeyPointsFilter*> cv_KeyPointsFilter_KeyPointsFilter() {
		try {
			cv::KeyPointsFilter* ret = new cv::KeyPointsFilter();
			return Ok<cv::KeyPointsFilter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KeyPointsFilter*>))
	}
	
	// runByImageBorder(std::vector<KeyPoint> &, cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:100
	Result_void cv_KeyPointsFilter_runByImageBorder_vector_KeyPoint_R_Size_int(std::vector<cv::KeyPoint>* keypoints, cv::Size* imageSize, int borderSize) {
		try {
			cv::KeyPointsFilter::runByImageBorder(*keypoints, *imageSize, borderSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// runByKeypointSize(std::vector<KeyPoint> &, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:104
	Result_void cv_KeyPointsFilter_runByKeypointSize_vector_KeyPoint_R_float_float(std::vector<cv::KeyPoint>* keypoints, float minSize, float maxSize) {
		try {
			cv::KeyPointsFilter::runByKeypointSize(*keypoints, minSize, maxSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// runByPixelsMask(std::vector<KeyPoint> &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:109
	Result_void cv_KeyPointsFilter_runByPixelsMask_vector_KeyPoint_R_const_MatR(std::vector<cv::KeyPoint>* keypoints, const cv::Mat* mask) {
		try {
			cv::KeyPointsFilter::runByPixelsMask(*keypoints, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// removeDuplicated(std::vector<KeyPoint> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:113
	Result_void cv_KeyPointsFilter_removeDuplicated_vector_KeyPoint_R(std::vector<cv::KeyPoint>* keypoints) {
		try {
			cv::KeyPointsFilter::removeDuplicated(*keypoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// removeDuplicatedSorted(std::vector<KeyPoint> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:117
	Result_void cv_KeyPointsFilter_removeDuplicatedSorted_vector_KeyPoint_R(std::vector<cv::KeyPoint>* keypoints) {
		try {
			cv::KeyPointsFilter::removeDuplicatedSorted(*keypoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// retainBest(std::vector<KeyPoint> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:122
	Result_void cv_KeyPointsFilter_retainBest_vector_KeyPoint_R_int(std::vector<cv::KeyPoint>* keypoints, int npoints) {
		try {
			cv::KeyPointsFilter::retainBest(*keypoints, npoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, int, int, double, double, int, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:486
	Result<cv::Ptr<cv::MSER>*> cv_MSER_create_int_int_int_double_double_int_double_double_int(int delta, int min_area, int max_area, double max_variation, double min_diversity, int max_evolution, double area_threshold, double min_margin, int edge_blur_size) {
		try {
			cv::Ptr<cv::MSER> ret = cv::MSER::create(delta, min_area, max_area, max_variation, min_diversity, max_evolution, area_threshold, min_margin, edge_blur_size);
			return Ok(new cv::Ptr<cv::MSER>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::MSER>*>))
	}
	
	// detectRegions(cv::InputArray, std::vector<std::vector<Point>> &, std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:497
	Result_void cv_MSER_detectRegions_const__InputArrayR_vector_vector_Point__R_vector_Rect_R(cv::MSER* instance, const cv::_InputArray* image, std::vector<std::vector<cv::Point>>* msers, std::vector<cv::Rect>* bboxes) {
		try {
			instance->detectRegions(*image, *msers, *bboxes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setDelta(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:501
	Result_void cv_MSER_setDelta_int(cv::MSER* instance, int delta) {
		try {
			instance->setDelta(delta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDelta() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:502
	Result<int> cv_MSER_getDelta_const(const cv::MSER* instance) {
		try {
			int ret = instance->getDelta();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMinArea(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:504
	Result_void cv_MSER_setMinArea_int(cv::MSER* instance, int minArea) {
		try {
			instance->setMinArea(minArea);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinArea() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:505
	Result<int> cv_MSER_getMinArea_const(const cv::MSER* instance) {
		try {
			int ret = instance->getMinArea();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMaxArea(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:507
	Result_void cv_MSER_setMaxArea_int(cv::MSER* instance, int maxArea) {
		try {
			instance->setMaxArea(maxArea);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxArea() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:508
	Result<int> cv_MSER_getMaxArea_const(const cv::MSER* instance) {
		try {
			int ret = instance->getMaxArea();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setPass2Only(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:510
	Result_void cv_MSER_setPass2Only_bool(cv::MSER* instance, bool f) {
		try {
			instance->setPass2Only(f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPass2Only() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:511
	Result<bool> cv_MSER_getPass2Only_const(const cv::MSER* instance) {
		try {
			bool ret = instance->getPass2Only();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:512
	Result<void*> cv_MSER_getDefaultName_const(const cv::MSER* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// create(int, float, int, int, int, int, ORB::ScoreType, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:424
	Result<cv::Ptr<cv::ORB>*> cv_ORB_create_int_float_int_int_int_int_ScoreType_int_int(int nfeatures, float scaleFactor, int nlevels, int edgeThreshold, int firstLevel, int WTA_K, cv::ORB::ScoreType scoreType, int patchSize, int fastThreshold) {
		try {
			cv::Ptr<cv::ORB> ret = cv::ORB::create(nfeatures, scaleFactor, nlevels, edgeThreshold, firstLevel, WTA_K, scoreType, patchSize, fastThreshold);
			return Ok(new cv::Ptr<cv::ORB>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ORB>*>))
	}
	
	// setMaxFeatures(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:427
	Result_void cv_ORB_setMaxFeatures_int(cv::ORB* instance, int maxFeatures) {
		try {
			instance->setMaxFeatures(maxFeatures);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxFeatures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:428
	Result<int> cv_ORB_getMaxFeatures_const(const cv::ORB* instance) {
		try {
			int ret = instance->getMaxFeatures();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setScaleFactor(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:430
	Result_void cv_ORB_setScaleFactor_double(cv::ORB* instance, double scaleFactor) {
		try {
			instance->setScaleFactor(scaleFactor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleFactor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:431
	Result<double> cv_ORB_getScaleFactor_const(const cv::ORB* instance) {
		try {
			double ret = instance->getScaleFactor();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:433
	Result_void cv_ORB_setNLevels_int(cv::ORB* instance, int nlevels) {
		try {
			instance->setNLevels(nlevels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:434
	Result<int> cv_ORB_getNLevels_const(const cv::ORB* instance) {
		try {
			int ret = instance->getNLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setEdgeThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:436
	Result_void cv_ORB_setEdgeThreshold_int(cv::ORB* instance, int edgeThreshold) {
		try {
			instance->setEdgeThreshold(edgeThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:437
	Result<int> cv_ORB_getEdgeThreshold_const(const cv::ORB* instance) {
		try {
			int ret = instance->getEdgeThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFirstLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:439
	Result_void cv_ORB_setFirstLevel_int(cv::ORB* instance, int firstLevel) {
		try {
			instance->setFirstLevel(firstLevel);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFirstLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:440
	Result<int> cv_ORB_getFirstLevel_const(const cv::ORB* instance) {
		try {
			int ret = instance->getFirstLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setWTA_K(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:442
	Result_void cv_ORB_setWTA_K_int(cv::ORB* instance, int wta_k) {
		try {
			instance->setWTA_K(wta_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWTA_K() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:443
	Result<int> cv_ORB_getWTA_K_const(const cv::ORB* instance) {
		try {
			int ret = instance->getWTA_K();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setScoreType(ORB::ScoreType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:445
	Result_void cv_ORB_setScoreType_ScoreType(cv::ORB* instance, cv::ORB::ScoreType scoreType) {
		try {
			instance->setScoreType(scoreType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScoreType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:446
	Result<cv::ORB::ScoreType> cv_ORB_getScoreType_const(const cv::ORB* instance) {
		try {
			cv::ORB::ScoreType ret = instance->getScoreType();
			return Ok<cv::ORB::ScoreType>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ORB::ScoreType>))
	}
	
	// setPatchSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:448
	Result_void cv_ORB_setPatchSize_int(cv::ORB* instance, int patchSize) {
		try {
			instance->setPatchSize(patchSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPatchSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:449
	Result<int> cv_ORB_getPatchSize_const(const cv::ORB* instance) {
		try {
			int ret = instance->getPatchSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFastThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:451
	Result_void cv_ORB_setFastThreshold_int(cv::ORB* instance, int fastThreshold) {
		try {
			instance->setFastThreshold(fastThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFastThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:452
	Result<int> cv_ORB_getFastThreshold_const(const cv::ORB* instance) {
		try {
			int ret = instance->getFastThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:453
	Result<void*> cv_ORB_getDefaultName_const(const cv::ORB* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::Algorithm* cv_SIFT_to_Algorithm(cv::SIFT* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::Feature2D* cv_SIFT_to_Feature2D(cv::SIFT* instance) {
		return dynamic_cast<cv::Feature2D*>(instance);
	}
	
	void cv_SIFT_delete(cv::SIFT* instance) {
		delete instance;
	}
	// create(int, int, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:283
	Result<cv::Ptr<cv::SIFT>*> cv_SIFT_create_int_int_double_double_double(int nfeatures, int nOctaveLayers, double contrastThreshold, double edgeThreshold, double sigma) {
		try {
			cv::Ptr<cv::SIFT> ret = cv::SIFT::create(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma);
			return Ok(new cv::Ptr<cv::SIFT>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::SIFT>*>))
	}
	
	// create(int, int, double, double, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:310
	Result<cv::Ptr<cv::SIFT>*> cv_SIFT_create_int_int_double_double_double_int(int nfeatures, int nOctaveLayers, double contrastThreshold, double edgeThreshold, double sigma, int descriptorType) {
		try {
			cv::Ptr<cv::SIFT> ret = cv::SIFT::create(nfeatures, nOctaveLayers, contrastThreshold, edgeThreshold, sigma, descriptorType);
			return Ok(new cv::Ptr<cv::SIFT>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::SIFT>*>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:314
	Result<void*> cv_SIFT_getDefaultName_const(const cv::SIFT* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::Algorithm* cv_SimpleBlobDetector_to_Algorithm(cv::SimpleBlobDetector* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::Feature2D* cv_SimpleBlobDetector_to_Feature2D(cv::SimpleBlobDetector* instance) {
		return dynamic_cast<cv::Feature2D*>(instance);
	}
	
	void cv_SimpleBlobDetector_delete(cv::SimpleBlobDetector* instance) {
		delete instance;
	}
	// create(const SimpleBlobDetector::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:727
	Result<cv::Ptr<cv::SimpleBlobDetector>*> cv_SimpleBlobDetector_create_const_ParamsR(const cv::SimpleBlobDetector::Params* parameters) {
		try {
			cv::Ptr<cv::SimpleBlobDetector> ret = cv::SimpleBlobDetector::create(*parameters);
			return Ok(new cv::Ptr<cv::SimpleBlobDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::SimpleBlobDetector>*>))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:728
	Result<void*> cv_SimpleBlobDetector_getDefaultName_const(const cv::SimpleBlobDetector* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:700
	Result<cv::SimpleBlobDetector::Params> cv_SimpleBlobDetector_Params_Params() {
		try {
			cv::SimpleBlobDetector::Params ret;
			return Ok<cv::SimpleBlobDetector::Params>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SimpleBlobDetector::Params>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:722
	Result_void cv_SimpleBlobDetector_Params_read_const_FileNodeR(cv::SimpleBlobDetector::Params instance, const cv::FileNode* fn) {
		try {
			instance.read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/features2d.hpp:723
	Result_void cv_SimpleBlobDetector_Params_write_const_FileStorageR(const cv::SimpleBlobDetector::Params instance, cv::FileStorage* fs) {
		try {
			instance.write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
