#include "face.hpp"
#include "face_types.hpp"

extern "C" {
	// createFacemarkAAM() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark.hpp:83
	Result<cv::Ptr<cv::face::Facemark>*> cv_face_createFacemarkAAM() {
		try {
			cv::Ptr<cv::face::Facemark> ret = cv::face::createFacemarkAAM();
			return Ok(new cv::Ptr<cv::face::Facemark>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::Facemark>*>))
	}
	
	// createFacemarkKazemi() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark.hpp:89
	Result<cv::Ptr<cv::face::Facemark>*> cv_face_createFacemarkKazemi() {
		try {
			cv::Ptr<cv::face::Facemark> ret = cv::face::createFacemarkKazemi();
			return Ok(new cv::Ptr<cv::face::Facemark>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::Facemark>*>))
	}
	
	// createFacemarkLBF() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark.hpp:86
	Result<cv::Ptr<cv::face::Facemark>*> cv_face_createFacemarkLBF() {
		try {
			cv::Ptr<cv::face::Facemark> ret = cv::face::createFacemarkLBF();
			return Ok(new cv::Ptr<cv::face::Facemark>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::Facemark>*>))
	}
	
	// drawFacemarks(cv::InputOutputArray, cv::InputArray, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:232
	Result_void cv_face_drawFacemarks_const__InputOutputArrayR_const__InputArrayR_Scalar(const cv::_InputOutputArray* image, const cv::_InputArray* points, cv::Scalar* color) {
		try {
			cv::face::drawFacemarks(*image, *points, *color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFacesHAAR(cv::InputArray, cv::OutputArray, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:76
	Result<bool> cv_face_getFacesHAAR_const__InputArrayR_const__OutputArrayR_const_StringR(const cv::_InputArray* image, const cv::_OutputArray* faces, const char* face_cascade_name) {
		try {
			bool ret = cv::face::getFacesHAAR(*image, *faces, std::string(face_cascade_name));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getFaces(cv::InputArray, cv::OutputArray, cv::face::CParams *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:74
	Result<bool> cv_face_getFaces_const__InputArrayR_const__OutputArrayR_CParamsX(const cv::_InputArray* image, const cv::_OutputArray* faces, cv::face::CParams* params) {
		try {
			bool ret = cv::face::getFaces(*image, *faces, params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// loadDatasetList(cv::String, cv::String, std::vector<String> &, std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:93
	Result<bool> cv_face_loadDatasetList_String_String_vector_String_R_vector_String_R(char* imageList, char* annotationList, std::vector<cv::String>* images, std::vector<cv::String>* annotations) {
		try {
			bool ret = cv::face::loadDatasetList(std::string(imageList), std::string(annotationList), *images, *annotations);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// loadFacePoints(cv::String, cv::OutputArray, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:212
	Result<bool> cv_face_loadFacePoints_String_const__OutputArrayR_float(char* filename, const cv::_OutputArray* points, float offset) {
		try {
			bool ret = cv::face::loadFacePoints(std::string(filename), *points, offset);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// loadTrainingData(cv::String, cv::String, std::vector<String> &, cv::OutputArray, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:163
	Result<bool> cv_face_loadTrainingData_String_String_vector_String_R_const__OutputArrayR_float(char* imageList, char* groundTruth, std::vector<cv::String>* images, const cv::_OutputArray* facePoints, float offset) {
		try {
			bool ret = cv::face::loadTrainingData(std::string(imageList), std::string(groundTruth), *images, *facePoints, offset);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// loadTrainingData(cv::String, std::vector<String> &, cv::OutputArray, char, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:123
	Result<bool> cv_face_loadTrainingData_String_vector_String_R_const__OutputArrayR_char_float(char* filename, std::vector<cv::String>* images, const cv::_OutputArray* facePoints, char delim, float offset) {
		try {
			bool ret = cv::face::loadTrainingData(std::string(filename), *images, *facePoints, delim, offset);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// loadTrainingData(std::vector<String>, std::vector<std::vector<Point2f>> &, std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:184
	Result<bool> cv_face_loadTrainingData_vector_String__vector_vector_Point2f__R_vector_String_R(std::vector<cv::String>* filename, std::vector<std::vector<cv::Point2f>>* trainlandmarks, std::vector<cv::String>* trainimages) {
		try {
			bool ret = cv::face::loadTrainingData(*filename, *trainlandmarks, *trainimages);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getNumBands() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/bif.hpp:60
	Result<int> cv_face_BIF_getNumBands_const(const cv::face::BIF* instance) {
		try {
			int ret = instance->getNumBands();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNumRotations() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/bif.hpp:63
	Result<int> cv_face_BIF_getNumRotations_const(const cv::face::BIF* instance) {
		try {
			int ret = instance->getNumRotations();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// compute(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/bif.hpp:69
	Result_void cv_face_BIF_compute_const_const__InputArrayR_const__OutputArrayR(const cv::face::BIF* instance, const cv::_InputArray* image, const cv::_OutputArray* features) {
		try {
			instance->compute(*image, *features);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/bif.hpp:77
	Result<cv::Ptr<cv::face::BIF>*> cv_face_BIF_create_int_int(int num_bands, int num_rotations) {
		try {
			cv::Ptr<cv::face::BIF> ret = cv::face::BIF::create(num_bands, num_rotations);
			return Ok(new cv::Ptr<cv::face::BIF>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::BIF>*>))
	}
	
	// getNumComponents() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:24
	Result<int> cv_face_BasicFaceRecognizer_getNumComponents_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			int ret = instance->getNumComponents();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumComponents(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:26
	Result_void cv_face_BasicFaceRecognizer_setNumComponents_int(cv::face::BasicFaceRecognizer* instance, int val) {
		try {
			instance->setNumComponents(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:28
	Result<double> cv_face_BasicFaceRecognizer_getThreshold_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:30
	Result_void cv_face_BasicFaceRecognizer_setThreshold_double(cv::face::BasicFaceRecognizer* instance, double val) {
		try {
			instance->setThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getProjections() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:31
	Result<std::vector<cv::Mat>*> cv_face_BasicFaceRecognizer_getProjections_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			std::vector<cv::Mat> ret = instance->getProjections();
			return Ok(new std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Mat>*>))
	}
	
	// getLabels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:32
	Result<cv::Mat*> cv_face_BasicFaceRecognizer_getLabels_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			cv::Mat ret = instance->getLabels();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getEigenValues() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:33
	Result<cv::Mat*> cv_face_BasicFaceRecognizer_getEigenValues_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			cv::Mat ret = instance->getEigenValues();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getEigenVectors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:34
	Result<cv::Mat*> cv_face_BasicFaceRecognizer_getEigenVectors_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			cv::Mat ret = instance->getEigenVectors();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getMean() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:35
	Result<cv::Mat*> cv_face_BasicFaceRecognizer_getMean_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			cv::Mat ret = instance->getMean();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:37
	Result_void cv_face_BasicFaceRecognizer_read_const_FileNodeR(cv::face::BasicFaceRecognizer* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:38
	Result_void cv_face_BasicFaceRecognizer_write_const_FileStorageR(const cv::face::BasicFaceRecognizer* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:39
	Result<bool> cv_face_BasicFaceRecognizer_empty_const(const cv::face::BasicFaceRecognizer* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// cascade /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:36
	void* cv_face_CParams_getPropCascade_const(const cv::face::CParams* instance) {
		cv::String ret = instance->cascade;
		return ocvrs_create_string(ret.c_str());
	}
	
	// cascade /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:36
	void cv_face_CParams_setPropCascade_String(cv::face::CParams* instance, char* val) {
		instance->cascade = std::string(val);
	}
	
	// scaleFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:37
	double cv_face_CParams_getPropScaleFactor_const(const cv::face::CParams* instance) {
		double ret = instance->scaleFactor;
		return (double)ret;
	}
	
	// scaleFactor /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:37
	void cv_face_CParams_setPropScaleFactor_double(cv::face::CParams* instance, double val) {
		instance->scaleFactor = val;
	}
	
	// minNeighbors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:38
	int cv_face_CParams_getPropMinNeighbors_const(const cv::face::CParams* instance) {
		int ret = instance->minNeighbors;
		return (int)ret;
	}
	
	// minNeighbors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:38
	void cv_face_CParams_setPropMinNeighbors_int(cv::face::CParams* instance, int val) {
		instance->minNeighbors = val;
	}
	
	// minSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:39
	cv::Size cv_face_CParams_getPropMinSize_const(const cv::face::CParams* instance) {
		cv::Size ret = instance->minSize;
		return (cv::Size)ret;
	}
	
	// minSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:39
	void cv_face_CParams_setPropMinSize_Size(cv::face::CParams* instance, cv::Size* val) {
		instance->minSize = *val;
	}
	
	// maxSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:40
	cv::Size cv_face_CParams_getPropMaxSize_const(const cv::face::CParams* instance) {
		cv::Size ret = instance->maxSize;
		return (cv::Size)ret;
	}
	
	// maxSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:40
	void cv_face_CParams_setPropMaxSize_Size(cv::face::CParams* instance, cv::Size* val) {
		instance->maxSize = *val;
	}
	
	// face_cascade /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:50
	cv::CascadeClassifier* cv_face_CParams_getPropFace_cascade_const(const cv::face::CParams* instance) {
		cv::CascadeClassifier ret = instance->face_cascade;
		return new cv::CascadeClassifier(ret);
	}
	
	// face_cascade /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:50
	void cv_face_CParams_setPropFace_cascade_CascadeClassifier(cv::face::CParams* instance, cv::CascadeClassifier* val) {
		instance->face_cascade = *val;
	}
	
	void cv_CParams_delete(cv::face::CParams* instance) {
		delete instance;
	}
	// CParams(cv::String, double, int, cv::Size, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:42
	Result<cv::face::CParams*> cv_face_CParams_CParams_String_double_int_Size_Size(char* cascade_model, double sf, int minN, cv::Size* minSz, cv::Size* maxSz) {
		try {
			cv::face::CParams* ret = new cv::face::CParams(std::string(cascade_model), sf, minN, *minSz, *maxSz);
			return Ok<cv::face::CParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::CParams*>))
	}
	
	// create(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:86
	Result<cv::Ptr<cv::face::EigenFaceRecognizer>*> cv_face_EigenFaceRecognizer_create_int_double(int num_components, double threshold) {
		try {
			cv::Ptr<cv::face::EigenFaceRecognizer> ret = cv::face::EigenFaceRecognizer::create(num_components, threshold);
			return Ok(new cv::Ptr<cv::face::EigenFaceRecognizer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::EigenFaceRecognizer>*>))
	}
	
	// train(cv::InputArrayOfArrays, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:209
	Result_void cv_face_FaceRecognizer_train_const__InputArrayR_const__InputArrayR(cv::face::FaceRecognizer* instance, const cv::_InputArray* src, const cv::_InputArray* labels) {
		try {
			instance->train(*src, *labels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// update(cv::InputArrayOfArrays, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:258
	Result_void cv_face_FaceRecognizer_update_const__InputArrayR_const__InputArrayR(cv::face::FaceRecognizer* instance, const cv::_InputArray* src, const cv::_InputArray* labels) {
		try {
			instance->update(*src, *labels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:261
	Result<int> cv_face_FaceRecognizer_predict_const_const__InputArrayR(const cv::face::FaceRecognizer* instance, const cv::_InputArray* src) {
		try {
			int ret = instance->predict(*src);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// predict(cv::InputArray, int &, double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:299
	Result_void cv_face_FaceRecognizer_predict_const_const__InputArrayR_intR_doubleR(const cv::face::FaceRecognizer* instance, const cv::_InputArray* src, int* label, double* confidence) {
		try {
			instance->predict(*src, *label, *confidence);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(cv::InputArray, Ptr<cv::face::PredictCollector>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:309
	Result_void cv_face_FaceRecognizer_predict_const_const__InputArrayR_Ptr_PredictCollector_(const cv::face::FaceRecognizer* instance, const cv::_InputArray* src, cv::Ptr<cv::face::PredictCollector>* collector) {
		try {
			instance->predict(*src, *collector);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:323
	Result_void cv_face_FaceRecognizer_write_const_const_StringR(const cv::face::FaceRecognizer* instance, const char* filename) {
		try {
			instance->write(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:332
	Result_void cv_face_FaceRecognizer_read_const_StringR(cv::face::FaceRecognizer* instance, const char* filename) {
		try {
			instance->read(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:338
	Result_void cv_face_FaceRecognizer_write_const_FileStorageR(const cv::face::FaceRecognizer* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:341
	Result_void cv_face_FaceRecognizer_read_const_FileNodeR(cv::face::FaceRecognizer* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:344
	Result<bool> cv_face_FaceRecognizer_empty_const(const cv::face::FaceRecognizer* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setLabelInfo(int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:350
	Result_void cv_face_FaceRecognizer_setLabelInfo_int_const_StringR(cv::face::FaceRecognizer* instance, int label, const char* strInfo) {
		try {
			instance->setLabelInfo(label, std::string(strInfo));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLabelInfo(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:357
	Result<void*> cv_face_FaceRecognizer_getLabelInfo_const_int(const cv::face::FaceRecognizer* instance, int label) {
		try {
			cv::String ret = instance->getLabelInfo(label);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getLabelsByString(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:364
	Result<std::vector<int>*> cv_face_FaceRecognizer_getLabelsByString_const_const_StringR(const cv::face::FaceRecognizer* instance, const char* str) {
		try {
			std::vector<int> ret = instance->getLabelsByString(std::string(str));
			return Ok(new std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<int>*>))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:366
	Result<double> cv_face_FaceRecognizer_getThreshold_const(const cv::face::FaceRecognizer* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face.hpp:368
	Result_void cv_face_FaceRecognizer_setThreshold_double(cv::face::FaceRecognizer* instance, double val) {
		try {
			instance->setThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// loadModel(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark.hpp:59
	Result_void cv_face_Facemark_loadModel_String(cv::face::Facemark* instance, char* model) {
		try {
			instance->loadModel(std::string(model));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fit(cv::InputArray, cv::InputArray, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark.hpp:76
	Result<bool> cv_face_Facemark_fit_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::face::Facemark* instance, const cv::_InputArray* image, const cv::_InputArray* faces, const cv::_OutputArray* landmarks) {
		try {
			bool ret = instance->fit(*image, *faces, *landmarks);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// fitConfig(cv::InputArray, cv::InputArray, cv::OutputArrayOfArrays, const std::vector<Config> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:149
	Result<bool> cv_face_FacemarkAAM_fitConfig_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const_vector_Config_R(cv::face::FacemarkAAM* instance, const cv::_InputArray* image, const cv::_InputArray* roi, const cv::_OutputArray* _landmarks, const std::vector<cv::face::FacemarkAAM::Config>* runtime_params) {
		try {
			bool ret = instance->fitConfig(*image, *roi, *_landmarks, *runtime_params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(const FacemarkAAM::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:153
	Result<cv::Ptr<cv::face::FacemarkAAM>*> cv_face_FacemarkAAM_create_const_ParamsR(const cv::face::FacemarkAAM::Params* parameters) {
		try {
			cv::Ptr<cv::face::FacemarkAAM> ret = cv::face::FacemarkAAM::create(*parameters);
			return Ok(new cv::Ptr<cv::face::FacemarkAAM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::FacemarkAAM>*>))
	}
	
	// R /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:88
	cv::Mat* cv_face_FacemarkAAM_Config_getPropR_const(const cv::face::FacemarkAAM::Config* instance) {
		cv::Mat ret = instance->R;
		return new cv::Mat(ret);
	}
	
	// R /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:88
	void cv_face_FacemarkAAM_Config_setPropR_Mat(cv::face::FacemarkAAM::Config* instance, cv::Mat* val) {
		instance->R = *val;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:89
	cv::Point2f cv_face_FacemarkAAM_Config_getPropT_const(const cv::face::FacemarkAAM::Config* instance) {
		cv::Point2f ret = instance->t;
		return (cv::Point2f)ret;
	}
	
	// t /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:89
	void cv_face_FacemarkAAM_Config_setPropT_Point2f(cv::face::FacemarkAAM::Config* instance, cv::Point2f* val) {
		instance->t = *val;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:90
	float cv_face_FacemarkAAM_Config_getPropScale_const(const cv::face::FacemarkAAM::Config* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:90
	void cv_face_FacemarkAAM_Config_setPropScale_float(cv::face::FacemarkAAM::Config* instance, float val) {
		instance->scale = val;
	}
	
	// model_scale_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:91
	int cv_face_FacemarkAAM_Config_getPropModel_scale_idx_const(const cv::face::FacemarkAAM::Config* instance) {
		int ret = instance->model_scale_idx;
		return (int)ret;
	}
	
	// model_scale_idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:91
	void cv_face_FacemarkAAM_Config_setPropModel_scale_idx_int(cv::face::FacemarkAAM::Config* instance, int val) {
		instance->model_scale_idx = val;
	}
	
	void cv_FacemarkAAM_Config_delete(cv::face::FacemarkAAM::Config* instance) {
		delete instance;
	}
	// Config(cv::Mat, cv::Point2f, float, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:82
	Result<cv::face::FacemarkAAM::Config*> cv_face_FacemarkAAM_Config_Config_Mat_Point2f_float_int(cv::Mat* rot, cv::Point2f* trans, float scaling, int scale_id) {
		try {
			cv::face::FacemarkAAM::Config* ret = new cv::face::FacemarkAAM::Config(*rot, *trans, scaling, scale_id);
			return Ok<cv::face::FacemarkAAM::Config*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::FacemarkAAM::Config*>))
	}
	
	// s0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:100
	std::vector<cv::Point2f>* cv_face_FacemarkAAM_Data_getPropS0_const(const cv::face::FacemarkAAM::Data* instance) {
		std::vector<cv::Point2f> ret = instance->s0;
		return new std::vector<cv::Point2f>(ret);
	}
	
	// s0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:100
	void cv_face_FacemarkAAM_Data_setPropS0_vector_Point2f_(cv::face::FacemarkAAM::Data* instance, std::vector<cv::Point2f>* val) {
		instance->s0 = *val;
	}
	
	void cv_FacemarkAAM_Data_delete(cv::face::FacemarkAAM::Data* instance) {
		delete instance;
	}
	// scales /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:108
	std::vector<float>* cv_face_FacemarkAAM_Model_getPropScales_const(const cv::face::FacemarkAAM::Model* instance) {
		std::vector<float> ret = instance->scales;
		return new std::vector<float>(ret);
	}
	
	// scales /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:108
	void cv_face_FacemarkAAM_Model_setPropScales_vector_float_(cv::face::FacemarkAAM::Model* instance, std::vector<float>* val) {
		instance->scales = *val;
	}
	
	// triangles /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:112
	std::vector<cv::Vec3i>* cv_face_FacemarkAAM_Model_getPropTriangles_const(const cv::face::FacemarkAAM::Model* instance) {
		std::vector<cv::Vec3i> ret = instance->triangles;
		return new std::vector<cv::Vec3i>(ret);
	}
	
	// triangles /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:112
	void cv_face_FacemarkAAM_Model_setPropTriangles_vector_Vec3i_(cv::face::FacemarkAAM::Model* instance, std::vector<cv::Vec3i>* val) {
		instance->triangles = *val;
	}
	
	// textures /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:137
	std::vector<cv::face::FacemarkAAM::Model::Texture>* cv_face_FacemarkAAM_Model_getPropTextures_const(const cv::face::FacemarkAAM::Model* instance) {
		std::vector<cv::face::FacemarkAAM::Model::Texture> ret = instance->textures;
		return new std::vector<cv::face::FacemarkAAM::Model::Texture>(ret);
	}
	
	// textures /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:137
	void cv_face_FacemarkAAM_Model_setPropTextures_vector_Texture_(cv::face::FacemarkAAM::Model* instance, std::vector<cv::face::FacemarkAAM::Model::Texture>* val) {
		instance->textures = *val;
	}
	
	// s0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:141
	std::vector<cv::Point2f>* cv_face_FacemarkAAM_Model_getPropS0_const(const cv::face::FacemarkAAM::Model* instance) {
		std::vector<cv::Point2f> ret = instance->s0;
		return new std::vector<cv::Point2f>(ret);
	}
	
	// s0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:141
	void cv_face_FacemarkAAM_Model_setPropS0_vector_Point2f_(cv::face::FacemarkAAM::Model* instance, std::vector<cv::Point2f>* val) {
		instance->s0 = *val;
	}
	
	// S /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:143
	cv::Mat* cv_face_FacemarkAAM_Model_getPropS_const(const cv::face::FacemarkAAM::Model* instance) {
		cv::Mat ret = instance->S;
		return new cv::Mat(ret);
	}
	
	// S /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:143
	void cv_face_FacemarkAAM_Model_setPropS_Mat(cv::face::FacemarkAAM::Model* instance, cv::Mat* val) {
		instance->S = *val;
	}
	
	// Q /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:143
	cv::Mat* cv_face_FacemarkAAM_Model_getPropQ_const(const cv::face::FacemarkAAM::Model* instance) {
		cv::Mat ret = instance->Q;
		return new cv::Mat(ret);
	}
	
	// Q /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:143
	void cv_face_FacemarkAAM_Model_setPropQ_Mat(cv::face::FacemarkAAM::Model* instance, cv::Mat* val) {
		instance->Q = *val;
	}
	
	void cv_FacemarkAAM_Model_delete(cv::face::FacemarkAAM::Model* instance) {
		delete instance;
	}
	// max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:116
	int cv_face_FacemarkAAM_Model_Texture_getPropMax_m_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		int ret = instance->max_m;
		return (int)ret;
	}
	
	// max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:116
	void cv_face_FacemarkAAM_Model_Texture_setPropMax_m_int(cv::face::FacemarkAAM::Model::Texture* instance, int val) {
		instance->max_m = val;
	}
	
	// resolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:117
	cv::Rect cv_face_FacemarkAAM_Model_Texture_getPropResolution_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		cv::Rect ret = instance->resolution;
		return (cv::Rect)ret;
	}
	
	// resolution /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:117
	void cv_face_FacemarkAAM_Model_Texture_setPropResolution_Rect(cv::face::FacemarkAAM::Model::Texture* instance, cv::Rect* val) {
		instance->resolution = *val;
	}
	
	// A /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:119
	cv::Mat* cv_face_FacemarkAAM_Model_Texture_getPropA_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		cv::Mat ret = instance->A;
		return new cv::Mat(ret);
	}
	
	// A /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:119
	void cv_face_FacemarkAAM_Model_Texture_setPropA_Mat(cv::face::FacemarkAAM::Model::Texture* instance, cv::Mat* val) {
		instance->A = *val;
	}
	
	// A0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:121
	cv::Mat* cv_face_FacemarkAAM_Model_Texture_getPropA0_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		cv::Mat ret = instance->A0;
		return new cv::Mat(ret);
	}
	
	// A0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:121
	void cv_face_FacemarkAAM_Model_Texture_setPropA0_Mat(cv::face::FacemarkAAM::Model::Texture* instance, cv::Mat* val) {
		instance->A0 = *val;
	}
	
	// AA /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:123
	cv::Mat* cv_face_FacemarkAAM_Model_Texture_getPropAA_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		cv::Mat ret = instance->AA;
		return new cv::Mat(ret);
	}
	
	// AA /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:123
	void cv_face_FacemarkAAM_Model_Texture_setPropAA_Mat(cv::face::FacemarkAAM::Model::Texture* instance, cv::Mat* val) {
		instance->AA = *val;
	}
	
	// AA0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:125
	cv::Mat* cv_face_FacemarkAAM_Model_Texture_getPropAA0_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		cv::Mat ret = instance->AA0;
		return new cv::Mat(ret);
	}
	
	// AA0 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:125
	void cv_face_FacemarkAAM_Model_Texture_setPropAA0_Mat(cv::face::FacemarkAAM::Model::Texture* instance, cv::Mat* val) {
		instance->AA0 = *val;
	}
	
	// textureIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:128
	std::vector<std::vector<cv::Point>>* cv_face_FacemarkAAM_Model_Texture_getPropTextureIdx_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		std::vector<std::vector<cv::Point>> ret = instance->textureIdx;
		return new std::vector<std::vector<cv::Point>>(ret);
	}
	
	// textureIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:128
	void cv_face_FacemarkAAM_Model_Texture_setPropTextureIdx_vector_vector_Point__(cv::face::FacemarkAAM::Model::Texture* instance, std::vector<std::vector<cv::Point>>* val) {
		instance->textureIdx = *val;
	}
	
	// base_shape /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:130
	std::vector<cv::Point2f>* cv_face_FacemarkAAM_Model_Texture_getPropBase_shape_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		std::vector<cv::Point2f> ret = instance->base_shape;
		return new std::vector<cv::Point2f>(ret);
	}
	
	// base_shape /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:130
	void cv_face_FacemarkAAM_Model_Texture_setPropBase_shape_vector_Point2f_(cv::face::FacemarkAAM::Model::Texture* instance, std::vector<cv::Point2f>* val) {
		instance->base_shape = *val;
	}
	
	// ind1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:132
	std::vector<int>* cv_face_FacemarkAAM_Model_Texture_getPropInd1_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		std::vector<int> ret = instance->ind1;
		return new std::vector<int>(ret);
	}
	
	// ind1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:132
	void cv_face_FacemarkAAM_Model_Texture_setPropInd1_vector_int_(cv::face::FacemarkAAM::Model::Texture* instance, std::vector<int>* val) {
		instance->ind1 = *val;
	}
	
	// ind2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:134
	std::vector<int>* cv_face_FacemarkAAM_Model_Texture_getPropInd2_const(const cv::face::FacemarkAAM::Model::Texture* instance) {
		std::vector<int> ret = instance->ind2;
		return new std::vector<int>(ret);
	}
	
	// ind2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:134
	void cv_face_FacemarkAAM_Model_Texture_setPropInd2_vector_int_(cv::face::FacemarkAAM::Model::Texture* instance, std::vector<int>* val) {
		instance->ind2 = *val;
	}
	
	void cv_FacemarkAAM_Model_Texture_delete(cv::face::FacemarkAAM::Model::Texture* instance) {
		delete instance;
	}
	// model_filename /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:67
	void* cv_face_FacemarkAAM_Params_getPropModel_filename_const(const cv::face::FacemarkAAM::Params* instance) {
		std::string ret = instance->model_filename;
		return ocvrs_create_string(ret.c_str());
	}
	
	// model_filename /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:67
	void cv_face_FacemarkAAM_Params_setPropModel_filename_string(cv::face::FacemarkAAM::Params* instance, char* val) {
		instance->model_filename = std::string(val);
	}
	
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:68
	int cv_face_FacemarkAAM_Params_getPropM_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->m;
		return (int)ret;
	}
	
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:68
	void cv_face_FacemarkAAM_Params_setPropM_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->m = val;
	}
	
	// n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:69
	int cv_face_FacemarkAAM_Params_getPropN_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->n;
		return (int)ret;
	}
	
	// n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:69
	void cv_face_FacemarkAAM_Params_setPropN_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->n = val;
	}
	
	// n_iter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:70
	int cv_face_FacemarkAAM_Params_getPropN_iter_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->n_iter;
		return (int)ret;
	}
	
	// n_iter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:70
	void cv_face_FacemarkAAM_Params_setPropN_iter_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->n_iter = val;
	}
	
	// verbose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:71
	bool cv_face_FacemarkAAM_Params_getPropVerbose_const(const cv::face::FacemarkAAM::Params* instance) {
		bool ret = instance->verbose;
		return (bool)ret;
	}
	
	// verbose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:71
	void cv_face_FacemarkAAM_Params_setPropVerbose_bool(cv::face::FacemarkAAM::Params* instance, bool val) {
		instance->verbose = val;
	}
	
	// save_model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:72
	bool cv_face_FacemarkAAM_Params_getPropSave_model_const(const cv::face::FacemarkAAM::Params* instance) {
		bool ret = instance->save_model;
		return (bool)ret;
	}
	
	// save_model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:72
	void cv_face_FacemarkAAM_Params_setPropSave_model_bool(cv::face::FacemarkAAM::Params* instance, bool val) {
		instance->save_model = val;
	}
	
	// max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	int cv_face_FacemarkAAM_Params_getPropMax_m_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->max_m;
		return (int)ret;
	}
	
	// max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	void cv_face_FacemarkAAM_Params_setPropMax_m_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->max_m = val;
	}
	
	// max_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	int cv_face_FacemarkAAM_Params_getPropMax_n_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->max_n;
		return (int)ret;
	}
	
	// max_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	void cv_face_FacemarkAAM_Params_setPropMax_n_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->max_n = val;
	}
	
	// texture_max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	int cv_face_FacemarkAAM_Params_getPropTexture_max_m_const(const cv::face::FacemarkAAM::Params* instance) {
		int ret = instance->texture_max_m;
		return (int)ret;
	}
	
	// texture_max_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:73
	void cv_face_FacemarkAAM_Params_setPropTexture_max_m_int(cv::face::FacemarkAAM::Params* instance, int val) {
		instance->texture_max_m = val;
	}
	
	// scales /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:74
	std::vector<float>* cv_face_FacemarkAAM_Params_getPropScales_const(const cv::face::FacemarkAAM::Params* instance) {
		std::vector<float> ret = instance->scales;
		return new std::vector<float>(ret);
	}
	
	// scales /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:74
	void cv_face_FacemarkAAM_Params_setPropScales_vector_float_(cv::face::FacemarkAAM::Params* instance, std::vector<float>* val) {
		instance->scales = *val;
	}
	
	void cv_FacemarkAAM_Params_delete(cv::face::FacemarkAAM::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:55
	Result<cv::face::FacemarkAAM::Params*> cv_face_FacemarkAAM_Params_Params() {
		try {
			cv::face::FacemarkAAM::Params* ret = new cv::face::FacemarkAAM::Params();
			return Ok<cv::face::FacemarkAAM::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::FacemarkAAM::Params*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:60
	Result_void cv_face_FacemarkAAM_Params_read_const_FileNodeR(cv::face::FacemarkAAM::Params* instance, const cv::FileNode* unnamed) {
		try {
			instance->read(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkAAM.hpp:65
	Result_void cv_face_FacemarkAAM_Params_write_const_FileStorageR(const cv::face::FacemarkAAM::Params* instance, cv::FileStorage* unnamed) {
		try {
			instance->write(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const FacemarkKazemi::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:39
	Result<cv::Ptr<cv::face::FacemarkKazemi>*> cv_face_FacemarkKazemi_create_const_ParamsR(const cv::face::FacemarkKazemi::Params* parameters) {
		try {
			cv::Ptr<cv::face::FacemarkKazemi> ret = cv::face::FacemarkKazemi::create(*parameters);
			return Ok(new cv::Ptr<cv::face::FacemarkKazemi>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::FacemarkKazemi>*>))
	}
	
	// training(std::vector<Mat> &, std::vector<std::vector<Point2f>> &, std::string, cv::Size, std::string) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:51
	Result<bool> cv_face_FacemarkKazemi_training_vector_Mat_R_vector_vector_Point2f__R_string_Size_string(cv::face::FacemarkKazemi* instance, std::vector<cv::Mat>* images, std::vector<std::vector<cv::Point2f>>* landmarks, char* configfile, cv::Size* scale, char* modelFilename) {
		try {
			bool ret = instance->training(*images, *landmarks, std::string(configfile), *scale, std::string(modelFilename));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setFaceDetector(bool (*)(cv::InputArray, cv::OutputArray, void *), void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:54
	Result<bool> cv_face_FacemarkKazemi_setFaceDetector_bool__X__const_cv__InputArrayR__const_cv__OutputArrayR__voidX__voidX(cv::face::FacemarkKazemi* instance, bool (*f)(const cv::_InputArray&, const cv::_OutputArray&, void*), void* userData) {
		try {
			bool ret = instance->setFaceDetector(f, userData);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getFaces(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:56
	Result<bool> cv_face_FacemarkKazemi_getFaces_const__InputArrayR_const__OutputArrayR(cv::face::FacemarkKazemi* instance, const cv::_InputArray* image, const cv::_OutputArray* faces) {
		try {
			bool ret = instance->getFaces(*image, *faces);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// cascade_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:21
	unsigned long cv_face_FacemarkKazemi_Params_getPropCascade_depth_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->cascade_depth;
		return (unsigned long)ret;
	}
	
	// cascade_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:21
	void cv_face_FacemarkKazemi_Params_setPropCascade_depth_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->cascade_depth = val;
	}
	
	// tree_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:23
	unsigned long cv_face_FacemarkKazemi_Params_getPropTree_depth_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->tree_depth;
		return (unsigned long)ret;
	}
	
	// tree_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:23
	void cv_face_FacemarkKazemi_Params_setPropTree_depth_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->tree_depth = val;
	}
	
	// num_trees_per_cascade_level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:25
	unsigned long cv_face_FacemarkKazemi_Params_getPropNum_trees_per_cascade_level_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->num_trees_per_cascade_level;
		return (unsigned long)ret;
	}
	
	// num_trees_per_cascade_level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:25
	void cv_face_FacemarkKazemi_Params_setPropNum_trees_per_cascade_level_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->num_trees_per_cascade_level = val;
	}
	
	// learning_rate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:27
	float cv_face_FacemarkKazemi_Params_getPropLearning_rate_const(const cv::face::FacemarkKazemi::Params* instance) {
		float ret = instance->learning_rate;
		return (float)ret;
	}
	
	// learning_rate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:27
	void cv_face_FacemarkKazemi_Params_setPropLearning_rate_float(cv::face::FacemarkKazemi::Params* instance, float val) {
		instance->learning_rate = val;
	}
	
	// oversampling_amount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:29
	unsigned long cv_face_FacemarkKazemi_Params_getPropOversampling_amount_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->oversampling_amount;
		return (unsigned long)ret;
	}
	
	// oversampling_amount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:29
	void cv_face_FacemarkKazemi_Params_setPropOversampling_amount_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->oversampling_amount = val;
	}
	
	// num_test_coordinates /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:31
	unsigned long cv_face_FacemarkKazemi_Params_getPropNum_test_coordinates_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->num_test_coordinates;
		return (unsigned long)ret;
	}
	
	// num_test_coordinates /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:31
	void cv_face_FacemarkKazemi_Params_setPropNum_test_coordinates_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->num_test_coordinates = val;
	}
	
	// lambda /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:33
	float cv_face_FacemarkKazemi_Params_getPropLambda_const(const cv::face::FacemarkKazemi::Params* instance) {
		float ret = instance->lambda;
		return (float)ret;
	}
	
	// lambda /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:33
	void cv_face_FacemarkKazemi_Params_setPropLambda_float(cv::face::FacemarkKazemi::Params* instance, float val) {
		instance->lambda = val;
	}
	
	// num_test_splits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:35
	unsigned long cv_face_FacemarkKazemi_Params_getPropNum_test_splits_const(const cv::face::FacemarkKazemi::Params* instance) {
		unsigned long ret = instance->num_test_splits;
		return (unsigned long)ret;
	}
	
	// num_test_splits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:35
	void cv_face_FacemarkKazemi_Params_setPropNum_test_splits_unsigned_long(cv::face::FacemarkKazemi::Params* instance, unsigned long val) {
		instance->num_test_splits = val;
	}
	
	// configfile /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:37
	void* cv_face_FacemarkKazemi_Params_getPropConfigfile_const(const cv::face::FacemarkKazemi::Params* instance) {
		cv::String ret = instance->configfile;
		return ocvrs_create_string(ret.c_str());
	}
	
	// configfile /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:37
	void cv_face_FacemarkKazemi_Params_setPropConfigfile_String(cv::face::FacemarkKazemi::Params* instance, char* val) {
		instance->configfile = std::string(val);
	}
	
	void cv_FacemarkKazemi_Params_delete(cv::face::FacemarkKazemi::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/face_alignment.hpp:19
	Result<cv::face::FacemarkKazemi::Params*> cv_face_FacemarkKazemi_Params_Params() {
		try {
			cv::face::FacemarkKazemi::Params* ret = new cv::face::FacemarkKazemi::Params();
			return Ok<cv::face::FacemarkKazemi::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::FacemarkKazemi::Params*>))
	}
	
	// create(const FacemarkLBF::Params &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:111
	Result<cv::Ptr<cv::face::FacemarkLBF>*> cv_face_FacemarkLBF_create_const_ParamsR(const cv::face::FacemarkLBF::Params* parameters) {
		try {
			cv::Ptr<cv::face::FacemarkLBF> ret = cv::face::FacemarkLBF::create(*parameters);
			return Ok(new cv::Ptr<cv::face::FacemarkLBF>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::FacemarkLBF>*>))
	}
	
	// shape_offset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:58
	double cv_face_FacemarkLBF_Params_getPropShape_offset_const(const cv::face::FacemarkLBF::Params* instance) {
		double ret = instance->shape_offset;
		return (double)ret;
	}
	
	// shape_offset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:58
	void cv_face_FacemarkLBF_Params_setPropShape_offset_double(cv::face::FacemarkLBF::Params* instance, double val) {
		instance->shape_offset = val;
	}
	
	// cascade_face /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:60
	void* cv_face_FacemarkLBF_Params_getPropCascade_face_const(const cv::face::FacemarkLBF::Params* instance) {
		cv::String ret = instance->cascade_face;
		return ocvrs_create_string(ret.c_str());
	}
	
	// cascade_face /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:60
	void cv_face_FacemarkLBF_Params_setPropCascade_face_String(cv::face::FacemarkLBF::Params* instance, char* val) {
		instance->cascade_face = std::string(val);
	}
	
	// verbose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:62
	bool cv_face_FacemarkLBF_Params_getPropVerbose_const(const cv::face::FacemarkLBF::Params* instance) {
		bool ret = instance->verbose;
		return (bool)ret;
	}
	
	// verbose /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:62
	void cv_face_FacemarkLBF_Params_setPropVerbose_bool(cv::face::FacemarkLBF::Params* instance, bool val) {
		instance->verbose = val;
	}
	
	// n_landmarks /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:65
	int cv_face_FacemarkLBF_Params_getPropN_landmarks_const(const cv::face::FacemarkLBF::Params* instance) {
		int ret = instance->n_landmarks;
		return (int)ret;
	}
	
	// n_landmarks /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:65
	void cv_face_FacemarkLBF_Params_setPropN_landmarks_int(cv::face::FacemarkLBF::Params* instance, int val) {
		instance->n_landmarks = val;
	}
	
	// initShape_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:67
	int cv_face_FacemarkLBF_Params_getPropInitShape_n_const(const cv::face::FacemarkLBF::Params* instance) {
		int ret = instance->initShape_n;
		return (int)ret;
	}
	
	// initShape_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:67
	void cv_face_FacemarkLBF_Params_setPropInitShape_n_int(cv::face::FacemarkLBF::Params* instance, int val) {
		instance->initShape_n = val;
	}
	
	// stages_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:70
	int cv_face_FacemarkLBF_Params_getPropStages_n_const(const cv::face::FacemarkLBF::Params* instance) {
		int ret = instance->stages_n;
		return (int)ret;
	}
	
	// stages_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:70
	void cv_face_FacemarkLBF_Params_setPropStages_n_int(cv::face::FacemarkLBF::Params* instance, int val) {
		instance->stages_n = val;
	}
	
	// tree_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:72
	int cv_face_FacemarkLBF_Params_getPropTree_n_const(const cv::face::FacemarkLBF::Params* instance) {
		int ret = instance->tree_n;
		return (int)ret;
	}
	
	// tree_n /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:72
	void cv_face_FacemarkLBF_Params_setPropTree_n_int(cv::face::FacemarkLBF::Params* instance, int val) {
		instance->tree_n = val;
	}
	
	// tree_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:74
	int cv_face_FacemarkLBF_Params_getPropTree_depth_const(const cv::face::FacemarkLBF::Params* instance) {
		int ret = instance->tree_depth;
		return (int)ret;
	}
	
	// tree_depth /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:74
	void cv_face_FacemarkLBF_Params_setPropTree_depth_int(cv::face::FacemarkLBF::Params* instance, int val) {
		instance->tree_depth = val;
	}
	
	// bagging_overlap /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:76
	double cv_face_FacemarkLBF_Params_getPropBagging_overlap_const(const cv::face::FacemarkLBF::Params* instance) {
		double ret = instance->bagging_overlap;
		return (double)ret;
	}
	
	// bagging_overlap /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:76
	void cv_face_FacemarkLBF_Params_setPropBagging_overlap_double(cv::face::FacemarkLBF::Params* instance, double val) {
		instance->bagging_overlap = val;
	}
	
	// model_filename /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:79
	void* cv_face_FacemarkLBF_Params_getPropModel_filename_const(const cv::face::FacemarkLBF::Params* instance) {
		std::string ret = instance->model_filename;
		return ocvrs_create_string(ret.c_str());
	}
	
	// model_filename /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:79
	void cv_face_FacemarkLBF_Params_setPropModel_filename_string(cv::face::FacemarkLBF::Params* instance, char* val) {
		instance->model_filename = std::string(val);
	}
	
	// save_model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:81
	bool cv_face_FacemarkLBF_Params_getPropSave_model_const(const cv::face::FacemarkLBF::Params* instance) {
		bool ret = instance->save_model;
		return (bool)ret;
	}
	
	// save_model /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:81
	void cv_face_FacemarkLBF_Params_setPropSave_model_bool(cv::face::FacemarkLBF::Params* instance, bool val) {
		instance->save_model = val;
	}
	
	// seed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:82
	unsigned int cv_face_FacemarkLBF_Params_getPropSeed_const(const cv::face::FacemarkLBF::Params* instance) {
		unsigned int ret = instance->seed;
		return (unsigned int)ret;
	}
	
	// seed /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:82
	void cv_face_FacemarkLBF_Params_setPropSeed_unsigned_int(cv::face::FacemarkLBF::Params* instance, unsigned int val) {
		instance->seed = val;
	}
	
	// feats_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:84
	std::vector<int>* cv_face_FacemarkLBF_Params_getPropFeats_m_const(const cv::face::FacemarkLBF::Params* instance) {
		std::vector<int> ret = instance->feats_m;
		return new std::vector<int>(ret);
	}
	
	// feats_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:84
	void cv_face_FacemarkLBF_Params_setPropFeats_m_vector_int_(cv::face::FacemarkLBF::Params* instance, std::vector<int>* val) {
		instance->feats_m = *val;
	}
	
	// radius_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:85
	std::vector<double>* cv_face_FacemarkLBF_Params_getPropRadius_m_const(const cv::face::FacemarkLBF::Params* instance) {
		std::vector<double> ret = instance->radius_m;
		return new std::vector<double>(ret);
	}
	
	// radius_m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:85
	void cv_face_FacemarkLBF_Params_setPropRadius_m_vector_double_(cv::face::FacemarkLBF::Params* instance, std::vector<double>* val) {
		instance->radius_m = *val;
	}
	
	// detectROI /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:89
	cv::Rect cv_face_FacemarkLBF_Params_getPropDetectROI_const(const cv::face::FacemarkLBF::Params* instance) {
		cv::Rect ret = instance->detectROI;
		return (cv::Rect)ret;
	}
	
	// detectROI /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:89
	void cv_face_FacemarkLBF_Params_setPropDetectROI_Rect(cv::face::FacemarkLBF::Params* instance, cv::Rect* val) {
		instance->detectROI = *val;
	}
	
	void cv_FacemarkLBF_Params_delete(cv::face::FacemarkLBF::Params* instance) {
		delete instance;
	}
	// Params() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:56
	Result<cv::face::FacemarkLBF::Params*> cv_face_FacemarkLBF_Params_Params() {
		try {
			cv::face::FacemarkLBF::Params* ret = new cv::face::FacemarkLBF::Params();
			return Ok<cv::face::FacemarkLBF::Params*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::FacemarkLBF::Params*>))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:91
	Result_void cv_face_FacemarkLBF_Params_read_const_FileNodeR(cv::face::FacemarkLBF::Params* instance, const cv::FileNode* unnamed) {
		try {
			instance->read(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemarkLBF.hpp:92
	Result_void cv_face_FacemarkLBF_Params_write_const_FileStorageR(const cv::face::FacemarkLBF::Params* instance, cv::FileStorage* unnamed) {
		try {
			instance->write(*unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addTrainingSample(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:308
	Result<bool> cv_face_FacemarkTrain_addTrainingSample_const__InputArrayR_const__InputArrayR(cv::face::FacemarkTrain* instance, const cv::_InputArray* image, const cv::_InputArray* landmarks) {
		try {
			bool ret = instance->addTrainingSample(*image, *landmarks);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// training(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:328
	Result_void cv_face_FacemarkTrain_training_voidX(cv::face::FacemarkTrain* instance, void* parameters) {
		try {
			instance->training(parameters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFaceDetector(cv::face::FN_FaceDetector, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:351
	Result<bool> cv_face_FacemarkTrain_setFaceDetector_FN_FaceDetector_voidX(cv::face::FacemarkTrain* instance, cv::face::FN_FaceDetector detector, void* userData) {
		try {
			bool ret = instance->setFaceDetector(detector, userData);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getFaces(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:368
	Result<bool> cv_face_FacemarkTrain_getFaces_const__InputArrayR_const__OutputArrayR(cv::face::FacemarkTrain* instance, const cv::_InputArray* image, const cv::_OutputArray* faces) {
		try {
			bool ret = instance->getFaces(*image, *faces);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getData(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facemark_train.hpp:386
	Result<bool> cv_face_FacemarkTrain_getData_voidX(cv::face::FacemarkTrain* instance, void* items) {
		try {
			bool ret = instance->getData(items);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:122
	Result<cv::Ptr<cv::face::FisherFaceRecognizer>*> cv_face_FisherFaceRecognizer_create_int_double(int num_components, double threshold) {
		try {
			cv::Ptr<cv::face::FisherFaceRecognizer> ret = cv::face::FisherFaceRecognizer::create(num_components, threshold);
			return Ok(new cv::Ptr<cv::face::FisherFaceRecognizer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::FisherFaceRecognizer>*>))
	}
	
	// getGridX() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:130
	Result<int> cv_face_LBPHFaceRecognizer_getGridX_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			int ret = instance->getGridX();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setGridX(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:132
	Result_void cv_face_LBPHFaceRecognizer_setGridX_int(cv::face::LBPHFaceRecognizer* instance, int val) {
		try {
			instance->setGridX(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGridY() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:134
	Result<int> cv_face_LBPHFaceRecognizer_getGridY_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			int ret = instance->getGridY();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setGridY(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:136
	Result_void cv_face_LBPHFaceRecognizer_setGridY_int(cv::face::LBPHFaceRecognizer* instance, int val) {
		try {
			instance->setGridY(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRadius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:138
	Result<int> cv_face_LBPHFaceRecognizer_getRadius_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			int ret = instance->getRadius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:140
	Result_void cv_face_LBPHFaceRecognizer_setRadius_int(cv::face::LBPHFaceRecognizer* instance, int val) {
		try {
			instance->setRadius(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNeighbors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:142
	Result<int> cv_face_LBPHFaceRecognizer_getNeighbors_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			int ret = instance->getNeighbors();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNeighbors(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:144
	Result_void cv_face_LBPHFaceRecognizer_setNeighbors_int(cv::face::LBPHFaceRecognizer* instance, int val) {
		try {
			instance->setNeighbors(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:146
	Result<double> cv_face_LBPHFaceRecognizer_getThreshold_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			double ret = instance->getThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:148
	Result_void cv_face_LBPHFaceRecognizer_setThreshold_double(cv::face::LBPHFaceRecognizer* instance, double val) {
		try {
			instance->setThreshold(val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHistograms() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:149
	Result<std::vector<cv::Mat>*> cv_face_LBPHFaceRecognizer_getHistograms_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			std::vector<cv::Mat> ret = instance->getHistograms();
			return Ok(new std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Mat>*>))
	}
	
	// getLabels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:150
	Result<cv::Mat*> cv_face_LBPHFaceRecognizer_getLabels_const(const cv::face::LBPHFaceRecognizer* instance) {
		try {
			cv::Mat ret = instance->getLabels();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// create(int, int, int, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/facerec.hpp:184
	Result<cv::Ptr<cv::face::LBPHFaceRecognizer>*> cv_face_LBPHFaceRecognizer_create_int_int_int_int_double(int radius, int neighbors, int grid_x, int grid_y, double threshold) {
		try {
			cv::Ptr<cv::face::LBPHFaceRecognizer> ret = cv::face::LBPHFaceRecognizer::create(radius, neighbors, grid_x, grid_y, threshold);
			return Ok(new cv::Ptr<cv::face::LBPHFaceRecognizer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::LBPHFaceRecognizer>*>))
	}
	
	// salt(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/mace.hpp:78
	Result_void cv_face_MACE_salt_const_StringR(cv::face::MACE* instance, const char* passphrase) {
		try {
			instance->salt(std::string(passphrase));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// train(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/mace.hpp:86
	Result_void cv_face_MACE_train_const__InputArrayR(cv::face::MACE* instance, const cv::_InputArray* images) {
		try {
			instance->train(*images);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// same(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/mace.hpp:92
	Result<bool> cv_face_MACE_same_const_const__InputArrayR(const cv::face::MACE* instance, const cv::_InputArray* query) {
		try {
			bool ret = instance->same(*query);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// load(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/mace.hpp:100
	Result<cv::Ptr<cv::face::MACE>*> cv_face_MACE_load_const_StringR_const_StringR(const char* filename, const char* objname) {
		try {
			cv::Ptr<cv::face::MACE> ret = cv::face::MACE::load(std::string(filename), std::string(objname));
			return Ok(new cv::Ptr<cv::face::MACE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::MACE>*>))
	}
	
	// create(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/mace.hpp:106
	Result<cv::Ptr<cv::face::MACE>*> cv_face_MACE_create_int(int IMGSIZE) {
		try {
			cv::Ptr<cv::face::MACE> ret = cv::face::MACE::create(IMGSIZE);
			return Ok(new cv::Ptr<cv::face::MACE>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::MACE>*>))
	}
	
	// init(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:69
	Result_void cv_face_PredictCollector_init_size_t(cv::face::PredictCollector* instance, size_t size) {
		try {
			instance->init(size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collect(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:75
	Result<bool> cv_face_PredictCollector_collect_int_double(cv::face::PredictCollector* instance, int label, double dist) {
		try {
			bool ret = instance->collect(label, dist);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_StandardCollector_delete(cv::face::StandardCollector* instance) {
		delete instance;
	}
	// StandardCollector(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:99
	Result<cv::face::StandardCollector*> cv_face_StandardCollector_StandardCollector_double(double threshold_) {
		try {
			cv::face::StandardCollector* ret = new cv::face::StandardCollector(threshold_);
			return Ok<cv::face::StandardCollector*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::StandardCollector*>))
	}
	
	// init(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:101
	Result_void cv_face_StandardCollector_init_size_t(cv::face::StandardCollector* instance, size_t size) {
		try {
			instance->init(size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// collect(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:103
	Result<bool> cv_face_StandardCollector_collect_int_double(cv::face::StandardCollector* instance, int label, double dist) {
		try {
			bool ret = instance->collect(label, dist);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getMinLabel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:105
	Result<int> cv_face_StandardCollector_getMinLabel_const(const cv::face::StandardCollector* instance) {
		try {
			int ret = instance->getMinLabel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getMinDist() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:107
	Result<double> cv_face_StandardCollector_getMinDist_const(const cv::face::StandardCollector* instance) {
		try {
			double ret = instance->getMinDist();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// create(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:120
	Result<cv::Ptr<cv::face::StandardCollector>*> cv_face_StandardCollector_create_double(double threshold) {
		try {
			cv::Ptr<cv::face::StandardCollector> ret = cv::face::StandardCollector::create(threshold);
			return Ok(new cv::Ptr<cv::face::StandardCollector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::face::StandardCollector>*>))
	}
	
	// PredictResult(int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/face/predict_collector.hpp:89
	Result<cv::face::StandardCollector::PredictResult> cv_face_StandardCollector_PredictResult_PredictResult_int_double(int label_, double distance_) {
		try {
			cv::face::StandardCollector::PredictResult ret(label_, distance_);
			return Ok<cv::face::StandardCollector::PredictResult>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::face::StandardCollector::PredictResult>))
	}
	
}
