#include "dnn.hpp"
#include "dnn_types.hpp"

extern "C" {
	// NMSBoxes(const std::vector<Rect2d> &, const std::vector<float> &, const float, const float, std::vector<int> &, const float, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1123
	Result_void cv_dnn_NMSBoxes_const_vector_Rect2d_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(const std::vector<cv::Rect2d>* bboxes, const std::vector<float>* scores, const float score_threshold, const float nms_threshold, std::vector<int>* indices, const float eta, const int top_k) {
		try {
			cv::dnn::NMSBoxes(*bboxes, *scores, score_threshold, nms_threshold, *indices, eta, top_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// NMSBoxes(const std::vector<Rect> &, const std::vector<float> &, const float, const float, std::vector<int> &, const float, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1118
	Result_void cv_dnn_NMSBoxes_const_vector_Rect_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(const std::vector<cv::Rect>* bboxes, const std::vector<float>* scores, const float score_threshold, const float nms_threshold, std::vector<int>* indices, const float eta, const int top_k) {
		try {
			cv::dnn::NMSBoxes(*bboxes, *scores, score_threshold, nms_threshold, *indices, eta, top_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// NMSBoxes(const std::vector<RotatedRect> &, const std::vector<float> &, const float, const float, std::vector<int> &, const float, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1128
	Result_void cv_dnn_NMSBoxes_const_vector_RotatedRect_R_const_vector_float_R_const_float_const_float_vector_int_R_const_float_const_int(const std::vector<cv::RotatedRect>* bboxes, const std::vector<float>* scores, const float score_threshold, const float nms_threshold, std::vector<int>* indices, const float eta, const int top_k) {
		try {
			cv::dnn::NMSBoxes(*bboxes, *scores, score_threshold, nms_threshold, *indices, eta, top_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blobFromImage(cv::InputArray, cv::OutputArray, double, const cv::Size &, const cv::Scalar &, bool, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1039
	Result_void cv_dnn_blobFromImage_const__InputArrayR_const__OutputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(const cv::_InputArray* image, const cv::_OutputArray* blob, double scalefactor, const cv::Size* size, const cv::Scalar* mean, bool swapRB, bool crop, int ddepth) {
		try {
			cv::dnn::blobFromImage(*image, *blob, scalefactor, *size, *mean, swapRB, crop, ddepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blobFromImage(cv::InputArray, double, const cv::Size &, const cv::Scalar &, bool, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1031
	Result<cv::Mat*> cv_dnn_blobFromImage_const__InputArrayR_double_const_SizeR_const_ScalarR_bool_bool_int(const cv::_InputArray* image, double scalefactor, const cv::Size* size, const cv::Scalar* mean, bool swapRB, bool crop, int ddepth) {
		try {
			cv::Mat ret = cv::dnn::blobFromImage(*image, scalefactor, *size, *mean, swapRB, crop, ddepth);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// blobFromImages(cv::InputArrayOfArrays, cv::OutputArray, double, cv::Size, const cv::Scalar &, bool, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1069
	Result_void cv_dnn_blobFromImages_const__InputArrayR_const__OutputArrayR_double_Size_const_ScalarR_bool_bool_int(const cv::_InputArray* images, const cv::_OutputArray* blob, double scalefactor, cv::Size* size, const cv::Scalar* mean, bool swapRB, bool crop, int ddepth) {
		try {
			cv::dnn::blobFromImages(*images, *blob, scalefactor, *size, *mean, swapRB, crop, ddepth);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blobFromImages(cv::InputArrayOfArrays, double, cv::Size, const cv::Scalar &, bool, bool, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1061
	Result<cv::Mat*> cv_dnn_blobFromImages_const__InputArrayR_double_Size_const_ScalarR_bool_bool_int(const cv::_InputArray* images, double scalefactor, cv::Size* size, const cv::Scalar* mean, bool swapRB, bool crop, int ddepth) {
		try {
			cv::Mat ret = cv::dnn::blobFromImages(*images, scalefactor, *size, *mean, swapRB, crop, ddepth);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// concat(const cv::dnn::MatShape &, const cv::dnn::MatShape &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:179
	Result<cv::dnn::MatShape*> cv_dnn_concat_const_MatShapeR_const_MatShapeR(const cv::dnn::MatShape* a, const cv::dnn::MatShape* b) {
		try {
			cv::dnn::MatShape ret = cv::dnn::concat(*a, *b);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// enableModelDiagnostics(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:113
	Result_void cv_dnn_enableModelDiagnostics_bool(bool isDiagnosticsMode) {
		try {
			cv::dnn::enableModelDiagnostics(isDiagnosticsMode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getAvailableTargets(dnn::Backend) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:101
	Result<std::vector<cv::dnn::Target>*> cv_dnn_getAvailableTargets_Backend(cv::dnn::Backend be) {
		try {
			std::vector<cv::dnn::Target> ret = cv::dnn::getAvailableTargets(be);
			return Ok(new std::vector<cv::dnn::Target>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::dnn::Target>*>))
	}
	
	// getInferenceEngineBackendType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:27
	Result<void*> cv_dnn_getInferenceEngineBackendType() {
		try {
			cv::String ret = cv::dnn::getInferenceEngineBackendType();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getInferenceEngineCPUType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:66
	Result<void*> cv_dnn_getInferenceEngineCPUType() {
		try {
			cv::String ret = cv::dnn::getInferenceEngineCPUType();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getInferenceEngineVPUType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:60
	Result<void*> cv_dnn_getInferenceEngineVPUType() {
		try {
			cv::String ret = cv::dnn::getInferenceEngineVPUType();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getPlane(const cv::Mat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:108
	Result<cv::Mat*> cv_dnn_getPlane_const_MatR_int_int(const cv::Mat* m, int n, int cn) {
		try {
			cv::Mat ret = cv::dnn::getPlane(*m, n, cn);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// imagesFromBlob(const cv::Mat &, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1082
	Result_void cv_dnn_imagesFromBlob_const_MatR_const__OutputArrayR(const cv::Mat* blob_, const cv::_OutputArray* images_) {
		try {
			cv::dnn::imagesFromBlob(*blob_, *images_);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// print(const cv::dnn::MatShape &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:198
	Result_void cv_dnn_print_const_MatShapeR_const_StringR(const cv::dnn::MatShape* shape, const char* name) {
		try {
			cv::dnn::print(*shape, std::string(name));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// readNetFromCaffe(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:832
	Result<cv::dnn::Net*> cv_dnn_readNetFromCaffe_const_StringR_const_StringR(const char* prototxt, const char* caffeModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromCaffe(std::string(prototxt), std::string(caffeModel));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromCaffe(const char *, size_t, const char *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:851
	Result<cv::dnn::Net*> cv_dnn_readNetFromCaffe_const_charX_size_t_const_charX_size_t(const char* bufferProto, size_t lenProto, const char* bufferModel, size_t lenModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromCaffe(bufferProto, lenProto, bufferModel, lenModel);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromCaffe(const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:839
	Result<cv::dnn::Net*> cv_dnn_readNetFromCaffe_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const std::vector<unsigned char>* bufferProto, const std::vector<unsigned char>* bufferModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromCaffe(*bufferProto, *bufferModel);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromDarknet(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:807
	Result<cv::dnn::Net*> cv_dnn_readNetFromDarknet_const_StringR_const_StringR(const char* cfgFile, const char* darknetModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromDarknet(std::string(cfgFile), std::string(darknetModel));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromDarknet(const char *, size_t, const char *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:824
	Result<cv::dnn::Net*> cv_dnn_readNetFromDarknet_const_charX_size_t_const_charX_size_t(const char* bufferCfg, size_t lenCfg, const char* bufferModel, size_t lenModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromDarknet(bufferCfg, lenCfg, bufferModel, lenModel);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromDarknet(const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:814
	Result<cv::dnn::Net*> cv_dnn_readNetFromDarknet_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const std::vector<unsigned char>* bufferCfg, const std::vector<unsigned char>* bufferModel) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromDarknet(*bufferCfg, *bufferModel);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromModelOptimizer(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:961
	Result<cv::dnn::Net*> cv_dnn_readNetFromModelOptimizer_const_StringR_const_StringR(const char* xml, const char* bin) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromModelOptimizer(std::string(xml), std::string(bin));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromModelOptimizer(const uchar *, size_t, const uchar *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:983
	Result<cv::dnn::Net*> cv_dnn_readNetFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(const unsigned char* bufferModelConfigPtr, size_t bufferModelConfigSize, const unsigned char* bufferWeightsPtr, size_t bufferWeightsSize) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromModelOptimizer(bufferModelConfigPtr, bufferModelConfigSize, bufferWeightsPtr, bufferWeightsSize);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromModelOptimizer(const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:971
	Result<cv::dnn::Net*> cv_dnn_readNetFromModelOptimizer_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const std::vector<unsigned char>* bufferModelConfig, const std::vector<unsigned char>* bufferWeights) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromModelOptimizer(*bufferModelConfig, *bufferWeights);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromONNX(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:990
	Result<cv::dnn::Net*> cv_dnn_readNetFromONNX_const_StringR(const char* onnxFile) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromONNX(std::string(onnxFile));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromONNX(const char *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:999
	Result<cv::dnn::Net*> cv_dnn_readNetFromONNX_const_charX_size_t(const char* buffer, size_t sizeBuffer) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromONNX(buffer, sizeBuffer);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromONNX(const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1007
	Result<cv::dnn::Net*> cv_dnn_readNetFromONNX_const_vector_unsigned_char_R(const std::vector<unsigned char>* buffer) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromONNX(*buffer);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromTensorflow(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:861
	Result<cv::dnn::Net*> cv_dnn_readNetFromTensorflow_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromTensorflow(std::string(model), std::string(config));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromTensorflow(const char *, size_t, const char *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:879
	Result<cv::dnn::Net*> cv_dnn_readNetFromTensorflow_const_charX_size_t_const_charX_size_t(const char* bufferModel, size_t lenModel, const char* bufferConfig, size_t lenConfig) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromTensorflow(bufferModel, lenModel, bufferConfig, lenConfig);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromTensorflow(const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:868
	Result<cv::dnn::Net*> cv_dnn_readNetFromTensorflow_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const std::vector<unsigned char>* bufferModel, const std::vector<unsigned char>* bufferConfig) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromTensorflow(*bufferModel, *bufferConfig);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNetFromTorch(const cv::String &, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:908
	Result<cv::dnn::Net*> cv_dnn_readNetFromTorch_const_StringR_bool_bool(const char* model, bool isBinary, bool evaluate) {
		try {
			cv::dnn::Net ret = cv::dnn::readNetFromTorch(std::string(model), isBinary, evaluate);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNet(const cv::String &, const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:934
	Result<cv::dnn::Net*> cv_dnn_readNet_const_StringR_const_StringR_const_StringR(const char* model, const char* config, const char* framework) {
		try {
			cv::dnn::Net ret = cv::dnn::readNet(std::string(model), std::string(config), std::string(framework));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readNet(const cv::String &, const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:945
	Result<cv::dnn::Net*> cv_dnn_readNet_const_StringR_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const char* framework, const std::vector<unsigned char>* bufferModel, const std::vector<unsigned char>* bufferConfig) {
		try {
			cv::dnn::Net ret = cv::dnn::readNet(std::string(framework), *bufferModel, *bufferConfig);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readTensorFromONNX(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1013
	Result<cv::Mat*> cv_dnn_readTensorFromONNX_const_StringR(const char* path) {
		try {
			cv::Mat ret = cv::dnn::readTensorFromONNX(std::string(path));
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// readTorchBlob(const cv::String &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:951
	Result<cv::Mat*> cv_dnn_readTorchBlob_const_StringR_bool(const char* filename, bool isBinary) {
		try {
			cv::Mat ret = cv::dnn::readTorchBlob(std::string(filename), isBinary);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// releaseHDDLPlugin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:70
	Result_void cv_dnn_releaseHDDLPlugin() {
		try {
			cv::dnn::releaseHDDLPlugin();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetMyriadDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:43
	Result_void cv_dnn_resetMyriadDevice() {
		try {
			cv::dnn::resetMyriadDevice();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInferenceEngineBackendType(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/utils/inference_engine.hpp:35
	Result<void*> cv_dnn_setInferenceEngineBackendType_const_StringR(const char* newBackendType) {
		try {
			cv::String ret = cv::dnn::setInferenceEngineBackendType(std::string(newBackendType));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// shape(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:126
	Result<cv::dnn::MatShape*> cv_dnn_shape_const_MatR(const cv::Mat* mat) {
		try {
			cv::dnn::MatShape ret = cv::dnn::shape(*mat);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// shape(const cv::MatSize &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:131
	Result<cv::dnn::MatShape*> cv_dnn_shape_const_MatSizeR(const cv::MatSize* sz) {
		try {
			cv::dnn::MatShape ret = cv::dnn::shape(*sz);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// shape(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:136
	Result<cv::dnn::MatShape*> cv_dnn_shape_const_UMatR(const cv::UMat* mat) {
		try {
			cv::dnn::MatShape ret = cv::dnn::shape(*mat);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// shape(const int *, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:119
	Result<cv::dnn::MatShape*> cv_dnn_shape_const_intX_const_int(const int* dims, const int n) {
		try {
			cv::dnn::MatShape ret = cv::dnn::shape(dims, n);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// shape(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:153
	Result<cv::dnn::MatShape*> cv_dnn_shape_int_int_int_int(int a0, int a1, int a2, int a3) {
		try {
			cv::dnn::MatShape ret = cv::dnn::shape(a0, a1, a2, a3);
			return Ok(new cv::dnn::MatShape(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::MatShape*>))
	}
	
	// shrinkCaffeModel(const cv::String &, const cv::String &, const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1097
	Result_void cv_dnn_shrinkCaffeModel_const_StringR_const_StringR_const_vector_String_R(const char* src, const char* dst, const std::vector<cv::String>* layersTypes) {
		try {
			cv::dnn::shrinkCaffeModel(std::string(src), std::string(dst), *layersTypes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// slice(const cv::Mat &, const cv::dnn::_Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:63
	Result<cv::Mat*> cv_dnn_slice_const_MatR_const__RangeR(const cv::Mat* m, const cv::dnn::_Range* r0) {
		try {
			cv::Mat ret = cv::dnn::slice(*m, *r0);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// slice(const cv::Mat &, const cv::dnn::_Range &, const cv::dnn::_Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:72
	Result<cv::Mat*> cv_dnn_slice_const_MatR_const__RangeR_const__RangeR(const cv::Mat* m, const cv::dnn::_Range* r0, const cv::dnn::_Range* r1) {
		try {
			cv::Mat ret = cv::dnn::slice(*m, *r0, *r1);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// slice(const cv::Mat &, const cv::dnn::_Range &, const cv::dnn::_Range &, const cv::dnn::_Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:83
	Result<cv::Mat*> cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR(const cv::Mat* m, const cv::dnn::_Range* r0, const cv::dnn::_Range* r1, const cv::dnn::_Range* r2) {
		try {
			cv::Mat ret = cv::dnn::slice(*m, *r0, *r1, *r2);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// slice(const cv::Mat &, const cv::dnn::_Range &, const cv::dnn::_Range &, const cv::dnn::_Range &, const cv::dnn::_Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:95
	Result<cv::Mat*> cv_dnn_slice_const_MatR_const__RangeR_const__RangeR_const__RangeR_const__RangeR(const cv::Mat* m, const cv::dnn::_Range* r0, const cv::dnn::_Range* r1, const cv::dnn::_Range* r2, const cv::dnn::_Range* r3) {
		try {
			cv::Mat ret = cv::dnn::slice(*m, *r0, *r1, *r2, *r3);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// softNMSBoxes(const std::vector<Rect> &, const std::vector<float> &, std::vector<float> &, const float, const float, std::vector<int> &, size_t, const float, cv::dnn::SoftNMSMethod) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1156
	Result_void cv_dnn_softNMSBoxes_const_vector_Rect_R_const_vector_float_R_vector_float_R_const_float_const_float_vector_int_R_size_t_const_float_SoftNMSMethod(const std::vector<cv::Rect>* bboxes, const std::vector<float>* scores, std::vector<float>* updated_scores, const float score_threshold, const float nms_threshold, std::vector<int>* indices, size_t top_k, const float sigma, cv::dnn::SoftNMSMethod method) {
		try {
			cv::dnn::softNMSBoxes(*bboxes, *scores, *updated_scores, score_threshold, nms_threshold, *indices, top_k, sigma, method);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// toString(const cv::dnn::MatShape &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:187
	Result<void*> cv_dnn_toString_const_MatShapeR_const_StringR(const cv::dnn::MatShape* shape, const char* name) {
		try {
			std::string ret = cv::dnn::toString(*shape, std::string(name));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// total(const cv::dnn::MatShape &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:161
	Result<int> cv_dnn_total_const_MatShapeR_int_int(const cv::dnn::MatShape* shape, int start, int end) {
		try {
			int ret = cv::dnn::total(*shape, start, end);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// writeTextGraph(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1106
	Result_void cv_dnn_writeTextGraph_const_StringR_const_StringR(const char* model, const char* output) {
		try {
			cv::dnn::writeTextGraph(std::string(model), std::string(output));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::dnn::ActivationLayer* cv_AbsLayer_to_ActivationLayer(cv::dnn::AbsLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_AbsLayer_to_Algorithm(cv::dnn::AbsLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_AbsLayer_to_Layer(cv::dnn::AbsLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_AbsLayer_delete(cv::dnn::AbsLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:584
	Result<cv::Ptr<cv::dnn::AbsLayer>*> cv_dnn_AbsLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::AbsLayer> ret = cv::dnn::AbsLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::AbsLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::AbsLayer>*>))
	}
	
	cv::Algorithm* cv_AccumLayer_to_Algorithm(cv::dnn::AccumLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_AccumLayer_to_Layer(cv::dnn::AccumLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_AccumLayer_delete(cv::dnn::AccumLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:707
	Result<cv::Ptr<cv::dnn::AccumLayer>*> cv_dnn_AccumLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::AccumLayer> ret = cv::dnn::AccumLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::AccumLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::AccumLayer>*>))
	}
	
	 Result<cv::dnn::AbsLayer*> cv_ActivationLayer_to_AbsLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::AbsLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::AbsLayer*>)
	}
	
	 Result<cv::dnn::ActivationLayerInt8*> cv_ActivationLayer_to_ActivationLayerInt8(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ActivationLayerInt8*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ActivationLayerInt8*>)
	}
	
	 Result<cv::dnn::BNLLLayer*> cv_ActivationLayer_to_BNLLLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::BNLLLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::BNLLLayer*>)
	}
	
	 Result<cv::dnn::BatchNormLayer*> cv_ActivationLayer_to_BatchNormLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::BatchNormLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::BatchNormLayer*>)
	}
	
	 Result<cv::dnn::ChannelsPReLULayer*> cv_ActivationLayer_to_ChannelsPReLULayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ChannelsPReLULayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ChannelsPReLULayer*>)
	}
	
	 Result<cv::dnn::ELULayer*> cv_ActivationLayer_to_ELULayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ELULayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ELULayer*>)
	}
	
	 Result<cv::dnn::ExpLayer*> cv_ActivationLayer_to_ExpLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ExpLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ExpLayer*>)
	}
	
	 Result<cv::dnn::MishLayer*> cv_ActivationLayer_to_MishLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::MishLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::MishLayer*>)
	}
	
	 Result<cv::dnn::PowerLayer*> cv_ActivationLayer_to_PowerLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::PowerLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::PowerLayer*>)
	}
	
	 Result<cv::dnn::ReLU6Layer*> cv_ActivationLayer_to_ReLU6Layer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ReLU6Layer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ReLU6Layer*>)
	}
	
	 Result<cv::dnn::ReLULayer*> cv_ActivationLayer_to_ReLULayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ReLULayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ReLULayer*>)
	}
	
	 Result<cv::dnn::SigmoidLayer*> cv_ActivationLayer_to_SigmoidLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::SigmoidLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::SigmoidLayer*>)
	}
	
	 Result<cv::dnn::SwishLayer*> cv_ActivationLayer_to_SwishLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::SwishLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::SwishLayer*>)
	}
	
	 Result<cv::dnn::TanHLayer*> cv_ActivationLayer_to_TanHLayer(cv::dnn::ActivationLayer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::TanHLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::TanHLayer*>)
	}
	
	cv::Algorithm* cv_ActivationLayer_to_Algorithm(cv::dnn::ActivationLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ActivationLayer_to_Layer(cv::dnn::ActivationLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ActivationLayer_delete(cv::dnn::ActivationLayer* instance) {
		delete instance;
	}
	// forwardSlice(const float *, float *, int, size_t, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:515
	Result_void cv_dnn_ActivationLayer_forwardSlice_const_const_floatX_floatX_int_size_t_int_int(const cv::dnn::ActivationLayer* instance, const float* src, float* dst, int len, size_t outPlaneSize, int cn0, int cn1) {
		try {
			instance->forwardSlice(src, dst, len, outPlaneSize, cn0, cn1);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forwardSlice(const int *, const int *, int *, int, size_t, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:517
	Result_void cv_dnn_ActivationLayer_forwardSlice_const_const_intX_const_intX_intX_int_size_t_int_int(const cv::dnn::ActivationLayer* instance, const int* src, const int* lut, int* dst, int len, size_t outPlaneSize, int cn0, int cn1) {
		try {
			instance->forwardSlice(src, lut, dst, len, outPlaneSize, cn0, cn1);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::dnn::ActivationLayer* cv_ActivationLayerInt8_to_ActivationLayer(cv::dnn::ActivationLayerInt8* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ActivationLayerInt8_to_Algorithm(cv::dnn::ActivationLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ActivationLayerInt8_to_Layer(cv::dnn::ActivationLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ActivationLayerInt8_delete(cv::dnn::ActivationLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:606
	Result<cv::Ptr<cv::dnn::ActivationLayerInt8>*> cv_dnn_ActivationLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ActivationLayerInt8> ret = cv::dnn::ActivationLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ActivationLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ActivationLayerInt8>*>))
	}
	
	cv::dnn::ActivationLayer* cv_BNLLLayer_to_ActivationLayer(cv::dnn::BNLLLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_BNLLLayer_to_Algorithm(cv::dnn::BNLLLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_BNLLLayer_to_Layer(cv::dnn::BNLLLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_BNLLLayer_delete(cv::dnn::BNLLLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:578
	Result<cv::Ptr<cv::dnn::BNLLLayer>*> cv_dnn_BNLLLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BNLLLayer> ret = cv::dnn::BNLLLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BNLLLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BNLLLayer>*>))
	}
	
	// backendId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:140
	int cv_dnn_BackendNode_getPropBackendId_const(const cv::dnn::BackendNode* instance) {
		int ret = instance->backendId;
		return (int)ret;
	}
	
	// backendId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:140
	void cv_dnn_BackendNode_setPropBackendId_int(cv::dnn::BackendNode* instance, int val) {
		instance->backendId = val;
	}
	
	void cv_BackendNode_delete(cv::dnn::BackendNode* instance) {
		delete instance;
	}
	// backendId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:184
	int cv_dnn_BackendWrapper_getPropBackendId_const(const cv::dnn::BackendWrapper* instance) {
		int ret = instance->backendId;
		return (int)ret;
	}
	
	// backendId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:184
	void cv_dnn_BackendWrapper_setPropBackendId_int(cv::dnn::BackendWrapper* instance, int val) {
		instance->backendId = val;
	}
	
	// targetId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:185
	int cv_dnn_BackendWrapper_getPropTargetId_const(const cv::dnn::BackendWrapper* instance) {
		int ret = instance->targetId;
		return (int)ret;
	}
	
	// targetId /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:185
	void cv_dnn_BackendWrapper_setPropTargetId_int(cv::dnn::BackendWrapper* instance, int val) {
		instance->targetId = val;
	}
	
	// copyToHost() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:177
	Result_void cv_dnn_BackendWrapper_copyToHost(cv::dnn::BackendWrapper* instance) {
		try {
			instance->copyToHost();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setHostDirty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:182
	Result_void cv_dnn_BackendWrapper_setHostDirty(cv::dnn::BackendWrapper* instance) {
		try {
			instance->setHostDirty();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// kernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	cv::Size cv_dnn_BaseConvolutionLayer_getPropKernel_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::Size ret = instance->kernel;
		return (cv::Size)ret;
	}
	
	// kernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	void cv_dnn_BaseConvolutionLayer_setPropKernel_Size(cv::dnn::BaseConvolutionLayer* instance, cv::Size* val) {
		instance->kernel = *val;
	}
	
	// stride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	cv::Size cv_dnn_BaseConvolutionLayer_getPropStride_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::Size ret = instance->stride;
		return (cv::Size)ret;
	}
	
	// stride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	void cv_dnn_BaseConvolutionLayer_setPropStride_Size(cv::dnn::BaseConvolutionLayer* instance, cv::Size* val) {
		instance->stride = *val;
	}
	
	// pad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	cv::Size cv_dnn_BaseConvolutionLayer_getPropPad_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::Size ret = instance->pad;
		return (cv::Size)ret;
	}
	
	// pad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	void cv_dnn_BaseConvolutionLayer_setPropPad_Size(cv::dnn::BaseConvolutionLayer* instance, cv::Size* val) {
		instance->pad = *val;
	}
	
	// dilation /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	cv::Size cv_dnn_BaseConvolutionLayer_getPropDilation_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::Size ret = instance->dilation;
		return (cv::Size)ret;
	}
	
	// dilation /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	void cv_dnn_BaseConvolutionLayer_setPropDilation_Size(cv::dnn::BaseConvolutionLayer* instance, cv::Size* val) {
		instance->dilation = *val;
	}
	
	// adjustPad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	cv::Size cv_dnn_BaseConvolutionLayer_getPropAdjustPad_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::Size ret = instance->adjustPad;
		return (cv::Size)ret;
	}
	
	// adjustPad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:247
	void cv_dnn_BaseConvolutionLayer_setPropAdjustPad_Size(cv::dnn::BaseConvolutionLayer* instance, cv::Size* val) {
		instance->adjustPad = *val;
	}
	
	// adjust_pads /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:248
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropAdjust_pads_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->adjust_pads;
		return new std::vector<size_t>(ret);
	}
	
	// adjust_pads /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:248
	void cv_dnn_BaseConvolutionLayer_setPropAdjust_pads_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->adjust_pads = *val;
	}
	
	// kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropKernel_size_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->kernel_size;
		return new std::vector<size_t>(ret);
	}
	
	// kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	void cv_dnn_BaseConvolutionLayer_setPropKernel_size_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->kernel_size = *val;
	}
	
	// strides /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropStrides_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->strides;
		return new std::vector<size_t>(ret);
	}
	
	// strides /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	void cv_dnn_BaseConvolutionLayer_setPropStrides_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->strides = *val;
	}
	
	// dilations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropDilations_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->dilations;
		return new std::vector<size_t>(ret);
	}
	
	// dilations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:249
	void cv_dnn_BaseConvolutionLayer_setPropDilations_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->dilations = *val;
	}
	
	// pads_begin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:250
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropPads_begin_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->pads_begin;
		return new std::vector<size_t>(ret);
	}
	
	// pads_begin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:250
	void cv_dnn_BaseConvolutionLayer_setPropPads_begin_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->pads_begin = *val;
	}
	
	// pads_end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:250
	std::vector<size_t>* cv_dnn_BaseConvolutionLayer_getPropPads_end_const(const cv::dnn::BaseConvolutionLayer* instance) {
		std::vector<size_t> ret = instance->pads_end;
		return new std::vector<size_t>(ret);
	}
	
	// pads_end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:250
	void cv_dnn_BaseConvolutionLayer_setPropPads_end_vector_size_t_(cv::dnn::BaseConvolutionLayer* instance, std::vector<size_t>* val) {
		instance->pads_end = *val;
	}
	
	// padMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:251
	void* cv_dnn_BaseConvolutionLayer_getPropPadMode_const(const cv::dnn::BaseConvolutionLayer* instance) {
		cv::String ret = instance->padMode;
		return ocvrs_create_string(ret.c_str());
	}
	
	// padMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:251
	void cv_dnn_BaseConvolutionLayer_setPropPadMode_String(cv::dnn::BaseConvolutionLayer* instance, char* val) {
		instance->padMode = std::string(val);
	}
	
	// numOutput /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:252
	int cv_dnn_BaseConvolutionLayer_getPropNumOutput_const(const cv::dnn::BaseConvolutionLayer* instance) {
		int ret = instance->numOutput;
		return (int)ret;
	}
	
	// numOutput /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:252
	void cv_dnn_BaseConvolutionLayer_setPropNumOutput_int(cv::dnn::BaseConvolutionLayer* instance, int val) {
		instance->numOutput = val;
	}
	
	cv::Algorithm* cv_BaseConvolutionLayer_to_Algorithm(cv::dnn::BaseConvolutionLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_BaseConvolutionLayer_to_Layer(cv::dnn::BaseConvolutionLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_BaseConvolutionLayer_delete(cv::dnn::BaseConvolutionLayer* instance) {
		delete instance;
	}
	// hasWeights /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:639
	bool cv_dnn_BatchNormLayer_getPropHasWeights_const(const cv::dnn::BatchNormLayer* instance) {
		bool ret = instance->hasWeights;
		return (bool)ret;
	}
	
	// hasWeights /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:639
	void cv_dnn_BatchNormLayer_setPropHasWeights_bool(cv::dnn::BatchNormLayer* instance, bool val) {
		instance->hasWeights = val;
	}
	
	// hasBias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:639
	bool cv_dnn_BatchNormLayer_getPropHasBias_const(const cv::dnn::BatchNormLayer* instance) {
		bool ret = instance->hasBias;
		return (bool)ret;
	}
	
	// hasBias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:639
	void cv_dnn_BatchNormLayer_setPropHasBias_bool(cv::dnn::BatchNormLayer* instance, bool val) {
		instance->hasBias = val;
	}
	
	// epsilon /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:640
	float cv_dnn_BatchNormLayer_getPropEpsilon_const(const cv::dnn::BatchNormLayer* instance) {
		float ret = instance->epsilon;
		return (float)ret;
	}
	
	// epsilon /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:640
	void cv_dnn_BatchNormLayer_setPropEpsilon_float(cv::dnn::BatchNormLayer* instance, float val) {
		instance->epsilon = val;
	}
	
	cv::dnn::ActivationLayer* cv_BatchNormLayer_to_ActivationLayer(cv::dnn::BatchNormLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_BatchNormLayer_to_Algorithm(cv::dnn::BatchNormLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_BatchNormLayer_to_Layer(cv::dnn::BatchNormLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_BatchNormLayer_delete(cv::dnn::BatchNormLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:642
	Result<cv::Ptr<cv::dnn::BatchNormLayer>*> cv_dnn_BatchNormLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BatchNormLayer> ret = cv::dnn::BatchNormLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BatchNormLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BatchNormLayer>*>))
	}
	
	// input_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:648
	float cv_dnn_BatchNormLayerInt8_getPropInput_sc_const(const cv::dnn::BatchNormLayerInt8* instance) {
		float ret = instance->input_sc;
		return (float)ret;
	}
	
	// input_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:648
	void cv_dnn_BatchNormLayerInt8_setPropInput_sc_float(cv::dnn::BatchNormLayerInt8* instance, float val) {
		instance->input_sc = val;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:648
	float cv_dnn_BatchNormLayerInt8_getPropOutput_sc_const(const cv::dnn::BatchNormLayerInt8* instance) {
		float ret = instance->output_sc;
		return (float)ret;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:648
	void cv_dnn_BatchNormLayerInt8_setPropOutput_sc_float(cv::dnn::BatchNormLayerInt8* instance, float val) {
		instance->output_sc = val;
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:649
	int cv_dnn_BatchNormLayerInt8_getPropInput_zp_const(const cv::dnn::BatchNormLayerInt8* instance) {
		int ret = instance->input_zp;
		return (int)ret;
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:649
	void cv_dnn_BatchNormLayerInt8_setPropInput_zp_int(cv::dnn::BatchNormLayerInt8* instance, int val) {
		instance->input_zp = val;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:649
	int cv_dnn_BatchNormLayerInt8_getPropOutput_zp_const(const cv::dnn::BatchNormLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:649
	void cv_dnn_BatchNormLayerInt8_setPropOutput_zp_int(cv::dnn::BatchNormLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	cv::dnn::ActivationLayer* cv_BatchNormLayerInt8_to_ActivationLayer(cv::dnn::BatchNormLayerInt8* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_BatchNormLayerInt8_to_Algorithm(cv::dnn::BatchNormLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::BatchNormLayer* cv_BatchNormLayerInt8_to_BatchNormLayer(cv::dnn::BatchNormLayerInt8* instance) {
		return dynamic_cast<cv::dnn::BatchNormLayer*>(instance);
	}
	
	cv::dnn::Layer* cv_BatchNormLayerInt8_to_Layer(cv::dnn::BatchNormLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_BatchNormLayerInt8_delete(cv::dnn::BatchNormLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:650
	Result<cv::Ptr<cv::dnn::BatchNormLayerInt8>*> cv_dnn_BatchNormLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BatchNormLayerInt8> ret = cv::dnn::BatchNormLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BatchNormLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BatchNormLayerInt8>*>))
	}
	
	cv::Algorithm* cv_BlankLayer_to_Algorithm(cv::dnn::BlankLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_BlankLayer_to_Layer(cv::dnn::BlankLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_BlankLayer_delete(cv::dnn::BlankLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:77
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_BlankLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::BlankLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::dnn::ActivationLayer* cv_ChannelsPReLULayer_to_ActivationLayer(cv::dnn::ChannelsPReLULayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ChannelsPReLULayer_to_Algorithm(cv::dnn::ChannelsPReLULayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ChannelsPReLULayer_to_Layer(cv::dnn::ChannelsPReLULayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ChannelsPReLULayer_delete(cv::dnn::ChannelsPReLULayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:542
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_ChannelsPReLULayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::ChannelsPReLULayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::dnn::Model* cv_ClassificationModel_to_Model(cv::dnn::ClassificationModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_ClassificationModel_delete(cv::dnn::ClassificationModel* instance) {
		delete instance;
	}
	// ClassificationModel(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1289
	Result<cv::dnn::ClassificationModel*> cv_dnn_ClassificationModel_ClassificationModel_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::ClassificationModel* ret = new cv::dnn::ClassificationModel(std::string(model), std::string(config));
			return Ok<cv::dnn::ClassificationModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::ClassificationModel*>))
	}
	
	// ClassificationModel(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1295
	Result<cv::dnn::ClassificationModel*> cv_dnn_ClassificationModel_ClassificationModel_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::ClassificationModel* ret = new cv::dnn::ClassificationModel(*network);
			return Ok<cv::dnn::ClassificationModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::ClassificationModel*>))
	}
	
	// classify(cv::InputArray, int &, float &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1303
	Result_void cv_dnn_ClassificationModel_classify_const__InputArrayR_intR_floatR(cv::dnn::ClassificationModel* instance, const cv::_InputArray* frame, int* classId, float* conf) {
		try {
			instance->classify(*frame, *classId, *conf);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:400
	int cv_dnn_ConcatLayer_getPropAxis_const(const cv::dnn::ConcatLayer* instance) {
		int ret = instance->axis;
		return (int)ret;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:400
	void cv_dnn_ConcatLayer_setPropAxis_int(cv::dnn::ConcatLayer* instance, int val) {
		instance->axis = val;
	}
	
	// padding /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:407
	bool cv_dnn_ConcatLayer_getPropPadding_const(const cv::dnn::ConcatLayer* instance) {
		bool ret = instance->padding;
		return (bool)ret;
	}
	
	// padding /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:407
	void cv_dnn_ConcatLayer_setPropPadding_bool(cv::dnn::ConcatLayer* instance, bool val) {
		instance->padding = val;
	}
	
	// paddingValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:408
	int cv_dnn_ConcatLayer_getPropPaddingValue_const(const cv::dnn::ConcatLayer* instance) {
		int ret = instance->paddingValue;
		return (int)ret;
	}
	
	// paddingValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:408
	void cv_dnn_ConcatLayer_setPropPaddingValue_int(cv::dnn::ConcatLayer* instance, int val) {
		instance->paddingValue = val;
	}
	
	cv::Algorithm* cv_ConcatLayer_to_Algorithm(cv::dnn::ConcatLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ConcatLayer_to_Layer(cv::dnn::ConcatLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ConcatLayer_delete(cv::dnn::ConcatLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:410
	Result<cv::Ptr<cv::dnn::ConcatLayer>*> cv_dnn_ConcatLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ConcatLayer> ret = cv::dnn::ConcatLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ConcatLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ConcatLayer>*>))
	}
	
	cv::Algorithm* cv_ConstLayer_to_Algorithm(cv::dnn::ConstLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ConstLayer_to_Layer(cv::dnn::ConstLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ConstLayer_delete(cv::dnn::ConstLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:86
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_ConstLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::ConstLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::Algorithm* cv_ConvolutionLayer_to_Algorithm(cv::dnn::ConvolutionLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::BaseConvolutionLayer* cv_ConvolutionLayer_to_BaseConvolutionLayer(cv::dnn::ConvolutionLayer* instance) {
		return dynamic_cast<cv::dnn::BaseConvolutionLayer*>(instance);
	}
	
	cv::dnn::Layer* cv_ConvolutionLayer_to_Layer(cv::dnn::ConvolutionLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ConvolutionLayer_delete(cv::dnn::ConvolutionLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:258
	Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*> cv_dnn_ConvolutionLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BaseConvolutionLayer> ret = cv::dnn::ConvolutionLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BaseConvolutionLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*>))
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:264
	int cv_dnn_ConvolutionLayerInt8_getPropInput_zp_const(const cv::dnn::ConvolutionLayerInt8* instance) {
		int ret = instance->input_zp;
		return (int)ret;
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:264
	void cv_dnn_ConvolutionLayerInt8_setPropInput_zp_int(cv::dnn::ConvolutionLayerInt8* instance, int val) {
		instance->input_zp = val;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:264
	int cv_dnn_ConvolutionLayerInt8_getPropOutput_zp_const(const cv::dnn::ConvolutionLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:264
	void cv_dnn_ConvolutionLayerInt8_setPropOutput_zp_int(cv::dnn::ConvolutionLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:265
	float cv_dnn_ConvolutionLayerInt8_getPropOutput_sc_const(const cv::dnn::ConvolutionLayerInt8* instance) {
		float ret = instance->output_sc;
		return (float)ret;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:265
	void cv_dnn_ConvolutionLayerInt8_setPropOutput_sc_float(cv::dnn::ConvolutionLayerInt8* instance, float val) {
		instance->output_sc = val;
	}
	
	cv::Algorithm* cv_ConvolutionLayerInt8_to_Algorithm(cv::dnn::ConvolutionLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::BaseConvolutionLayer* cv_ConvolutionLayerInt8_to_BaseConvolutionLayer(cv::dnn::ConvolutionLayerInt8* instance) {
		return dynamic_cast<cv::dnn::BaseConvolutionLayer*>(instance);
	}
	
	cv::dnn::Layer* cv_ConvolutionLayerInt8_to_Layer(cv::dnn::ConvolutionLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ConvolutionLayerInt8_delete(cv::dnn::ConvolutionLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:266
	Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*> cv_dnn_ConvolutionLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BaseConvolutionLayer> ret = cv::dnn::ConvolutionLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BaseConvolutionLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*>))
	}
	
	cv::Algorithm* cv_CorrelationLayer_to_Algorithm(cv::dnn::CorrelationLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_CorrelationLayer_to_Layer(cv::dnn::CorrelationLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_CorrelationLayer_delete(cv::dnn::CorrelationLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:701
	Result<cv::Ptr<cv::dnn::CorrelationLayer>*> cv_dnn_CorrelationLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::CorrelationLayer> ret = cv::dnn::CorrelationLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::CorrelationLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::CorrelationLayer>*>))
	}
	
	cv::Algorithm* cv_CropAndResizeLayer_to_Algorithm(cv::dnn::CropAndResizeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_CropAndResizeLayer_to_Layer(cv::dnn::CropAndResizeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_CropAndResizeLayer_delete(cv::dnn::CropAndResizeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:815
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_CropAndResizeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::CropAndResizeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::Algorithm* cv_CropLayer_to_Algorithm(cv::dnn::CropLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_CropLayer_to_Layer(cv::dnn::CropLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_CropLayer_delete(cv::dnn::CropLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:614
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_CropLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::CropLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	// exclusive /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:821
	int cv_dnn_CumSumLayer_getPropExclusive_const(const cv::dnn::CumSumLayer* instance) {
		int ret = instance->exclusive;
		return (int)ret;
	}
	
	// exclusive /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:821
	void cv_dnn_CumSumLayer_setPropExclusive_int(cv::dnn::CumSumLayer* instance, int val) {
		instance->exclusive = val;
	}
	
	// reverse /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:822
	int cv_dnn_CumSumLayer_getPropReverse_const(const cv::dnn::CumSumLayer* instance) {
		int ret = instance->reverse;
		return (int)ret;
	}
	
	// reverse /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:822
	void cv_dnn_CumSumLayer_setPropReverse_int(cv::dnn::CumSumLayer* instance, int val) {
		instance->reverse = val;
	}
	
	cv::Algorithm* cv_CumSumLayer_to_Algorithm(cv::dnn::CumSumLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_CumSumLayer_to_Layer(cv::dnn::CumSumLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_CumSumLayer_delete(cv::dnn::CumSumLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:824
	Result<cv::Ptr<cv::dnn::CumSumLayer>*> cv_dnn_CumSumLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::CumSumLayer> ret = cv::dnn::CumSumLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::CumSumLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::CumSumLayer>*>))
	}
	
	cv::Algorithm* cv_DataAugmentationLayer_to_Algorithm(cv::dnn::DataAugmentationLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_DataAugmentationLayer_to_Layer(cv::dnn::DataAugmentationLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_DataAugmentationLayer_delete(cv::dnn::DataAugmentationLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:695
	Result<cv::Ptr<cv::dnn::DataAugmentationLayer>*> cv_dnn_DataAugmentationLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::DataAugmentationLayer> ret = cv::dnn::DataAugmentationLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::DataAugmentationLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::DataAugmentationLayer>*>))
	}
	
	cv::Algorithm* cv_DeconvolutionLayer_to_Algorithm(cv::dnn::DeconvolutionLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::BaseConvolutionLayer* cv_DeconvolutionLayer_to_BaseConvolutionLayer(cv::dnn::DeconvolutionLayer* instance) {
		return dynamic_cast<cv::dnn::BaseConvolutionLayer*>(instance);
	}
	
	cv::dnn::Layer* cv_DeconvolutionLayer_to_Layer(cv::dnn::DeconvolutionLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_DeconvolutionLayer_delete(cv::dnn::DeconvolutionLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:272
	Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*> cv_dnn_DeconvolutionLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::BaseConvolutionLayer> ret = cv::dnn::DeconvolutionLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::BaseConvolutionLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BaseConvolutionLayer>*>))
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:385
	float cv_dnn_DequantizeLayer_getPropScale_const(const cv::dnn::DequantizeLayer* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:385
	void cv_dnn_DequantizeLayer_setPropScale_float(cv::dnn::DequantizeLayer* instance, float val) {
		instance->scale = val;
	}
	
	// zeropoint /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:386
	int cv_dnn_DequantizeLayer_getPropZeropoint_const(const cv::dnn::DequantizeLayer* instance) {
		int ret = instance->zeropoint;
		return (int)ret;
	}
	
	// zeropoint /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:386
	void cv_dnn_DequantizeLayer_setPropZeropoint_int(cv::dnn::DequantizeLayer* instance, int val) {
		instance->zeropoint = val;
	}
	
	cv::Algorithm* cv_DequantizeLayer_to_Algorithm(cv::dnn::DequantizeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_DequantizeLayer_to_Layer(cv::dnn::DequantizeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_DequantizeLayer_delete(cv::dnn::DequantizeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:387
	Result<cv::Ptr<cv::dnn::DequantizeLayer>*> cv_dnn_DequantizeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::DequantizeLayer> ret = cv::dnn::DequantizeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::DequantizeLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::DequantizeLayer>*>))
	}
	
	cv::dnn::Model* cv_DetectionModel_to_Model(cv::dnn::DetectionModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_DetectionModel_delete(cv::dnn::DetectionModel* instance) {
		delete instance;
	}
	// DetectionModel(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1384
	Result<cv::dnn::DetectionModel*> cv_dnn_DetectionModel_DetectionModel_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::DetectionModel* ret = new cv::dnn::DetectionModel(std::string(model), std::string(config));
			return Ok<cv::dnn::DetectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DetectionModel*>))
	}
	
	// DetectionModel(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1390
	Result<cv::dnn::DetectionModel*> cv_dnn_DetectionModel_DetectionModel_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::DetectionModel* ret = new cv::dnn::DetectionModel(*network);
			return Ok<cv::dnn::DetectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DetectionModel*>))
	}
	
	// DetectionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1393
	Result<cv::dnn::DetectionModel*> cv_dnn_DetectionModel_DetectionModel() {
		try {
			cv::dnn::DetectionModel* ret = new cv::dnn::DetectionModel();
			return Ok<cv::dnn::DetectionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DetectionModel*>))
	}
	
	// setNmsAcrossClasses(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1401
	Result<cv::dnn::DetectionModel*> cv_dnn_DetectionModel_setNmsAcrossClasses_bool(cv::dnn::DetectionModel* instance, bool value) {
		try {
			cv::dnn::DetectionModel ret = instance->setNmsAcrossClasses(value);
			return Ok(new cv::dnn::DetectionModel(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DetectionModel*>))
	}
	
	// getNmsAcrossClasses() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1407
	Result<bool> cv_dnn_DetectionModel_getNmsAcrossClasses(cv::dnn::DetectionModel* instance) {
		try {
			bool ret = instance->getNmsAcrossClasses();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// detect(cv::InputArray, std::vector<int> &, std::vector<float> &, std::vector<Rect> &, float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1417
	Result_void cv_dnn_DetectionModel_detect_const__InputArrayR_vector_int_R_vector_float_R_vector_Rect_R_float_float(cv::dnn::DetectionModel* instance, const cv::_InputArray* frame, std::vector<int>* classIds, std::vector<float>* confidences, std::vector<cv::Rect>* boxes, float confThreshold, float nmsThreshold) {
		try {
			instance->detect(*frame, *classIds, *confidences, *boxes, confThreshold, nmsThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_DetectionOutputLayer_to_Algorithm(cv::dnn::DetectionOutputLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_DetectionOutputLayer_to_Layer(cv::dnn::DetectionOutputLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_DetectionOutputLayer_delete(cv::dnn::DetectionOutputLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:747
	Result<cv::Ptr<cv::dnn::DetectionOutputLayer>*> cv_dnn_DetectionOutputLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::DetectionOutputLayer> ret = cv::dnn::DetectionOutputLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::DetectionOutputLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::DetectionOutputLayer>*>))
	}
	
	void cv_Dict_delete(cv::dnn::Dict* instance) {
		delete instance;
	}
	// has(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:122
	Result<bool> cv_dnn_Dict_has_const_const_StringR(const cv::dnn::Dict* instance, const char* key) {
		try {
			bool ret = instance->has(std::string(key));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ptr(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:125
	Result<cv::dnn::DictValue**> cv_dnn_Dict_ptr_const_StringR(cv::dnn::Dict* instance, const char* key) {
		try {
			cv::dnn::DictValue* ret = instance->ptr(std::string(key));
			return Ok(new cv::dnn::DictValue*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue**>))
	}
	
	// ptr(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:128
	Result<const cv::dnn::DictValue**> cv_dnn_Dict_ptr_const_const_StringR(const cv::dnn::Dict* instance, const char* key) {
		try {
			const cv::dnn::DictValue* ret = instance->ptr(std::string(key));
			return Ok(new const cv::dnn::DictValue*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::dnn::DictValue**>))
	}
	
	// get(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:131
	Result<const cv::dnn::DictValue*> cv_dnn_Dict_get_const_const_StringR(const cv::dnn::Dict* instance, const char* key) {
		try {
			const cv::dnn::DictValue ret = instance->get(std::string(key));
			return Ok(new const cv::dnn::DictValue(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::dnn::DictValue*>))
	}
	
	// set(const cv::String &, const T &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:143
	Result<void*> cv_dnn_Dict_set_cv_String_const_StringR_const_StringR(cv::dnn::Dict* instance, const char* key, const char* value) {
		try {
			const cv::String ret = instance->set<cv::String>(std::string(key), std::string(value));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// set(const cv::String &, const T &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:143
	Result<const cv::dnn::DictValue*> cv_dnn_Dict_set_cv_dnn_DictValue_const_StringR_const_DictValueR(cv::dnn::Dict* instance, const char* key, const cv::dnn::DictValue* value) {
		try {
			const cv::dnn::DictValue ret = instance->set<cv::dnn::DictValue>(std::string(key), *value);
			return Ok(new const cv::dnn::DictValue(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::dnn::DictValue*>))
	}
	
	// set(const cv::String &, const T &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:143
	Result<const double> cv_dnn_Dict_set_double_const_StringR_const_doubleR(cv::dnn::Dict* instance, const char* key, const double* value) {
		try {
			const double ret = instance->set<double>(std::string(key), *value);
			return Ok<const double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const double>))
	}
	
	// set(const cv::String &, const T &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:143
	Result<const int64_t> cv_dnn_Dict_set_int64_t_const_StringR_const_int64_tR(cv::dnn::Dict* instance, const char* key, const int64_t* value) {
		try {
			const int64_t ret = instance->set<int64_t>(std::string(key), *value);
			return Ok<const int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const int64_t>))
	}
	
	// erase(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:146
	Result_void cv_dnn_Dict_erase_const_StringR(cv::dnn::Dict* instance, const char* key) {
		try {
			instance->erase(std::string(key));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_DictValue_delete(cv::dnn::DictValue* instance) {
		delete instance;
	}
	// DictValue(const cv::dnn::DictValue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:62
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_const_DictValueR(const cv::dnn::DictValue* r) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(*r);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:63
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_bool(bool i) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(i);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(int64) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:64
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_int64_t(int64_t i) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(i);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:65
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_int(int i) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(i);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(unsigned int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:66
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_unsigned_int(unsigned int p) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(p);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:67
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_double(double p) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(p);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// DictValue(const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:69
	Result<cv::dnn::DictValue*> cv_dnn_DictValue_DictValue_const_charX(const char* s) {
		try {
			cv::dnn::DictValue* ret = new cv::dnn::DictValue(s);
			return Ok<cv::dnn::DictValue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::DictValue*>))
	}
	
	// get(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:79
	Result<void*> cv_dnn_DictValue_get_cv_String_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			cv::String ret = instance->get<cv::String>(idx);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// get(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:79
	Result<double> cv_dnn_DictValue_get_double_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			double ret = instance->get<double>(idx);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// get(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:79
	Result<int> cv_dnn_DictValue_get_int_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			int ret = instance->get<int>(idx);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// get(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:79
	Result<int64_t> cv_dnn_DictValue_get_int64_t_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			int64_t ret = instance->get<int64_t>(idx);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:81
	Result<int> cv_dnn_DictValue_size_const(const cv::dnn::DictValue* instance) {
		try {
			int ret = instance->size();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// isInt() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:83
	Result<bool> cv_dnn_DictValue_isInt_const(const cv::dnn::DictValue* instance) {
		try {
			bool ret = instance->isInt();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isString() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:84
	Result<bool> cv_dnn_DictValue_isString_const(const cv::dnn::DictValue* instance) {
		try {
			bool ret = instance->isString();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isReal() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:85
	Result<bool> cv_dnn_DictValue_isReal_const(const cv::dnn::DictValue* instance) {
		try {
			bool ret = instance->isReal();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getIntValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:87
	Result<int> cv_dnn_DictValue_getIntValue_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			int ret = instance->getIntValue(idx);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getRealValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:88
	Result<double> cv_dnn_DictValue_getRealValue_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			double ret = instance->getRealValue(idx);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getStringValue(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dict.hpp:89
	Result<void*> cv_dnn_DictValue_getStringValue_const_int(const cv::dnn::DictValue* instance, int idx) {
		try {
			cv::String ret = instance->getStringValue(idx);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	cv::dnn::ActivationLayer* cv_ELULayer_to_ActivationLayer(cv::dnn::ELULayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ELULayer_to_Algorithm(cv::dnn::ELULayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ELULayer_to_Layer(cv::dnn::ELULayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ELULayer_delete(cv::dnn::ELULayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:548
	Result<cv::Ptr<cv::dnn::ELULayer>*> cv_dnn_ELULayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ELULayer> ret = cv::dnn::ELULayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ELULayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ELULayer>*>))
	}
	
	cv::Algorithm* cv_EltwiseLayer_to_Algorithm(cv::dnn::EltwiseLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_EltwiseLayer_to_Layer(cv::dnn::EltwiseLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_EltwiseLayer_delete(cv::dnn::EltwiseLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:627
	Result<cv::Ptr<cv::dnn::EltwiseLayer>*> cv_dnn_EltwiseLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::EltwiseLayer> ret = cv::dnn::EltwiseLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::EltwiseLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::EltwiseLayer>*>))
	}
	
	cv::Algorithm* cv_EltwiseLayerInt8_to_Algorithm(cv::dnn::EltwiseLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_EltwiseLayerInt8_to_Layer(cv::dnn::EltwiseLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_EltwiseLayerInt8_delete(cv::dnn::EltwiseLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:633
	Result<cv::Ptr<cv::dnn::EltwiseLayerInt8>*> cv_dnn_EltwiseLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::EltwiseLayerInt8> ret = cv::dnn::EltwiseLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::EltwiseLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::EltwiseLayerInt8>*>))
	}
	
	// base /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	float cv_dnn_ExpLayer_getPropBase_const(const cv::dnn::ExpLayer* instance) {
		float ret = instance->base;
		return (float)ret;
	}
	
	// base /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	void cv_dnn_ExpLayer_setPropBase_float(cv::dnn::ExpLayer* instance, float val) {
		instance->base = val;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	float cv_dnn_ExpLayer_getPropScale_const(const cv::dnn::ExpLayer* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	void cv_dnn_ExpLayer_setPropScale_float(cv::dnn::ExpLayer* instance, float val) {
		instance->scale = val;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	float cv_dnn_ExpLayer_getPropShift_const(const cv::dnn::ExpLayer* instance) {
		float ret = instance->shift;
		return (float)ret;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:598
	void cv_dnn_ExpLayer_setPropShift_float(cv::dnn::ExpLayer* instance, float val) {
		instance->shift = val;
	}
	
	cv::dnn::ActivationLayer* cv_ExpLayer_to_ActivationLayer(cv::dnn::ExpLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ExpLayer_to_Algorithm(cv::dnn::ExpLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ExpLayer_to_Layer(cv::dnn::ExpLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ExpLayer_delete(cv::dnn::ExpLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:600
	Result<cv::Ptr<cv::dnn::ExpLayer>*> cv_dnn_ExpLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ExpLayer> ret = cv::dnn::ExpLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ExpLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ExpLayer>*>))
	}
	
	cv::Algorithm* cv_FlattenLayer_to_Algorithm(cv::dnn::FlattenLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_FlattenLayer_to_Layer(cv::dnn::FlattenLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_FlattenLayer_delete(cv::dnn::FlattenLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:371
	Result<cv::Ptr<cv::dnn::FlattenLayer>*> cv_dnn_FlattenLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::FlattenLayer> ret = cv::dnn::FlattenLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::FlattenLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::FlattenLayer>*>))
	}
	
	cv::Algorithm* cv_FlowWarpLayer_to_Algorithm(cv::dnn::FlowWarpLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_FlowWarpLayer_to_Layer(cv::dnn::FlowWarpLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_FlowWarpLayer_delete(cv::dnn::FlowWarpLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:713
	Result<cv::Ptr<cv::dnn::FlowWarpLayer>*> cv_dnn_FlowWarpLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::FlowWarpLayer> ret = cv::dnn::FlowWarpLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::FlowWarpLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::FlowWarpLayer>*>))
	}
	
	cv::Algorithm* cv_GRULayer_to_Algorithm(cv::dnn::GRULayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_GRULayer_to_Layer(cv::dnn::GRULayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_GRULayer_delete(cv::dnn::GRULayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:199
	Result<cv::Ptr<cv::dnn::GRULayer>*> cv_dnn_GRULayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::GRULayer> ret = cv::dnn::GRULayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::GRULayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::GRULayer>*>))
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:337
	int cv_dnn_InnerProductLayer_getPropAxis_const(const cv::dnn::InnerProductLayer* instance) {
		int ret = instance->axis;
		return (int)ret;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:337
	void cv_dnn_InnerProductLayer_setPropAxis_int(cv::dnn::InnerProductLayer* instance, int val) {
		instance->axis = val;
	}
	
	cv::Algorithm* cv_InnerProductLayer_to_Algorithm(cv::dnn::InnerProductLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_InnerProductLayer_to_Layer(cv::dnn::InnerProductLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_InnerProductLayer_delete(cv::dnn::InnerProductLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:338
	Result<cv::Ptr<cv::dnn::InnerProductLayer>*> cv_dnn_InnerProductLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::InnerProductLayer> ret = cv::dnn::InnerProductLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::InnerProductLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::InnerProductLayer>*>))
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:344
	int cv_dnn_InnerProductLayerInt8_getPropOutput_zp_const(const cv::dnn::InnerProductLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:344
	void cv_dnn_InnerProductLayerInt8_setPropOutput_zp_int(cv::dnn::InnerProductLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	cv::Algorithm* cv_InnerProductLayerInt8_to_Algorithm(cv::dnn::InnerProductLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::InnerProductLayer* cv_InnerProductLayerInt8_to_InnerProductLayer(cv::dnn::InnerProductLayerInt8* instance) {
		return dynamic_cast<cv::dnn::InnerProductLayer*>(instance);
	}
	
	cv::dnn::Layer* cv_InnerProductLayerInt8_to_Layer(cv::dnn::InnerProductLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_InnerProductLayerInt8_delete(cv::dnn::InnerProductLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:345
	Result<cv::Ptr<cv::dnn::InnerProductLayerInt8>*> cv_dnn_InnerProductLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::InnerProductLayerInt8> ret = cv::dnn::InnerProductLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::InnerProductLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::InnerProductLayerInt8>*>))
	}
	
	cv::Algorithm* cv_InterpLayer_to_Algorithm(cv::dnn::InterpLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_InterpLayer_to_Layer(cv::dnn::InterpLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_InterpLayer_delete(cv::dnn::InterpLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:803
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_InterpLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::InterpLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::dnn::Model* cv_KeypointsModel_to_Model(cv::dnn::KeypointsModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_KeypointsModel_delete(cv::dnn::KeypointsModel* instance) {
		delete instance;
	}
	// KeypointsModel(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1321
	Result<cv::dnn::KeypointsModel*> cv_dnn_KeypointsModel_KeypointsModel_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::KeypointsModel* ret = new cv::dnn::KeypointsModel(std::string(model), std::string(config));
			return Ok<cv::dnn::KeypointsModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::KeypointsModel*>))
	}
	
	// KeypointsModel(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1327
	Result<cv::dnn::KeypointsModel*> cv_dnn_KeypointsModel_KeypointsModel_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::KeypointsModel* ret = new cv::dnn::KeypointsModel(*network);
			return Ok<cv::dnn::KeypointsModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::KeypointsModel*>))
	}
	
	// estimate(cv::InputArray, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1335
	Result<std::vector<cv::Point2f>*> cv_dnn_KeypointsModel_estimate_const__InputArrayR_float(cv::dnn::KeypointsModel* instance, const cv::_InputArray* frame, float thresh) {
		try {
			std::vector<cv::Point2f> ret = instance->estimate(*frame, thresh);
			return Ok(new std::vector<cv::Point2f>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Point2f>*>))
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:278
	int cv_dnn_LRNLayer_getPropType_const(const cv::dnn::LRNLayer* instance) {
		int ret = instance->type;
		return (int)ret;
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:278
	void cv_dnn_LRNLayer_setPropType_int(cv::dnn::LRNLayer* instance, int val) {
		instance->type = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:280
	int cv_dnn_LRNLayer_getPropSize_const(const cv::dnn::LRNLayer* instance) {
		int ret = instance->size;
		return (int)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:280
	void cv_dnn_LRNLayer_setPropSize_int(cv::dnn::LRNLayer* instance, int val) {
		instance->size = val;
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	float cv_dnn_LRNLayer_getPropAlpha_const(const cv::dnn::LRNLayer* instance) {
		float ret = instance->alpha;
		return (float)ret;
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	void cv_dnn_LRNLayer_setPropAlpha_float(cv::dnn::LRNLayer* instance, float val) {
		instance->alpha = val;
	}
	
	// beta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	float cv_dnn_LRNLayer_getPropBeta_const(const cv::dnn::LRNLayer* instance) {
		float ret = instance->beta;
		return (float)ret;
	}
	
	// beta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	void cv_dnn_LRNLayer_setPropBeta_float(cv::dnn::LRNLayer* instance, float val) {
		instance->beta = val;
	}
	
	// bias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	float cv_dnn_LRNLayer_getPropBias_const(const cv::dnn::LRNLayer* instance) {
		float ret = instance->bias;
		return (float)ret;
	}
	
	// bias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:281
	void cv_dnn_LRNLayer_setPropBias_float(cv::dnn::LRNLayer* instance, float val) {
		instance->bias = val;
	}
	
	// normBySize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:282
	bool cv_dnn_LRNLayer_getPropNormBySize_const(const cv::dnn::LRNLayer* instance) {
		bool ret = instance->normBySize;
		return (bool)ret;
	}
	
	// normBySize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:282
	void cv_dnn_LRNLayer_setPropNormBySize_bool(cv::dnn::LRNLayer* instance, bool val) {
		instance->normBySize = val;
	}
	
	cv::Algorithm* cv_LRNLayer_to_Algorithm(cv::dnn::LRNLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_LRNLayer_to_Layer(cv::dnn::LRNLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_LRNLayer_delete(cv::dnn::LRNLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:284
	Result<cv::Ptr<cv::dnn::LRNLayer>*> cv_dnn_LRNLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::LRNLayer> ret = cv::dnn::LRNLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::LRNLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::LRNLayer>*>))
	}
	
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:94
	Result<cv::Ptr<cv::dnn::LSTMLayer>*> cv_dnn_LSTMLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::LSTMLayer> ret = cv::dnn::LSTMLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::LSTMLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::LSTMLayer>*>))
	}
	
	// setWeights(const cv::Mat &, const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:128
	Result_void cv_dnn_LSTMLayer_setWeights_const_MatR_const_MatR_const_MatR(cv::dnn::LSTMLayer* instance, const cv::Mat* Wh, const cv::Mat* Wx, const cv::Mat* b) {
		try {
			instance->setWeights(*Wh, *Wx, *b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setOutShape(const cv::dnn::MatShape &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:134
	Result_void cv_dnn_LSTMLayer_setOutShape_const_MatShapeR(cv::dnn::LSTMLayer* instance, const cv::dnn::MatShape* outTailShape) {
		try {
			instance->setOutShape(*outTailShape);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseTimstampsDim(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:145
	Result_void cv_dnn_LSTMLayer_setUseTimstampsDim_bool(cv::dnn::LSTMLayer* instance, bool use) {
		try {
			instance->setUseTimstampsDim(use);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setProduceCellOutput(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:151
	Result_void cv_dnn_LSTMLayer_setProduceCellOutput_bool(cv::dnn::LSTMLayer* instance, bool produce) {
		try {
			instance->setProduceCellOutput(produce);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inputNameToIndex(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:164
	Result<int> cv_dnn_LSTMLayer_inputNameToIndex_String(cv::dnn::LSTMLayer* instance, char* inputName) {
		try {
			int ret = instance->inputNameToIndex(std::string(inputName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// outputNameToIndex(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:165
	Result<int> cv_dnn_LSTMLayer_outputNameToIndex_const_StringR(cv::dnn::LSTMLayer* instance, const char* outputName) {
		try {
			int ret = instance->outputNameToIndex(std::string(outputName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// blobs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:200
	std::vector<cv::Mat>* cv_dnn_Layer_getPropBlobs_const(const cv::dnn::Layer* instance) {
		std::vector<cv::Mat> ret = instance->blobs;
		return new std::vector<cv::Mat>(ret);
	}
	
	// blobs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:200
	void cv_dnn_Layer_setPropBlobs_vector_Mat_(cv::dnn::Layer* instance, std::vector<cv::Mat>* val) {
		instance->blobs = *val;
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:405
	void* cv_dnn_Layer_getPropName_const(const cv::dnn::Layer* instance) {
		cv::String ret = instance->name;
		return ocvrs_create_string(ret.c_str());
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:405
	void cv_dnn_Layer_setPropName_String(cv::dnn::Layer* instance, char* val) {
		instance->name = std::string(val);
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:406
	void* cv_dnn_Layer_getPropType_const(const cv::dnn::Layer* instance) {
		cv::String ret = instance->type;
		return ocvrs_create_string(ret.c_str());
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:406
	void cv_dnn_Layer_setPropType_String(cv::dnn::Layer* instance, char* val) {
		instance->type = std::string(val);
	}
	
	// preferableTarget /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:407
	int cv_dnn_Layer_getPropPreferableTarget_const(const cv::dnn::Layer* instance) {
		int ret = instance->preferableTarget;
		return (int)ret;
	}
	
	// preferableTarget /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:407
	void cv_dnn_Layer_setPropPreferableTarget_int(cv::dnn::Layer* instance, int val) {
		instance->preferableTarget = val;
	}
	
	 Result<cv::dnn::AccumLayer*> cv_Layer_to_AccumLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::AccumLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::AccumLayer*>)
	}
	
	 Result<cv::dnn::ActivationLayer*> cv_Layer_to_ActivationLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ActivationLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ActivationLayer*>)
	}
	
	 Result<cv::dnn::BaseConvolutionLayer*> cv_Layer_to_BaseConvolutionLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::BaseConvolutionLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::BaseConvolutionLayer*>)
	}
	
	 Result<cv::dnn::BlankLayer*> cv_Layer_to_BlankLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::BlankLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::BlankLayer*>)
	}
	
	 Result<cv::dnn::ConcatLayer*> cv_Layer_to_ConcatLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ConcatLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ConcatLayer*>)
	}
	
	 Result<cv::dnn::ConstLayer*> cv_Layer_to_ConstLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ConstLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ConstLayer*>)
	}
	
	 Result<cv::dnn::CorrelationLayer*> cv_Layer_to_CorrelationLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::CorrelationLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::CorrelationLayer*>)
	}
	
	 Result<cv::dnn::CropAndResizeLayer*> cv_Layer_to_CropAndResizeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::CropAndResizeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::CropAndResizeLayer*>)
	}
	
	 Result<cv::dnn::CropLayer*> cv_Layer_to_CropLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::CropLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::CropLayer*>)
	}
	
	 Result<cv::dnn::CumSumLayer*> cv_Layer_to_CumSumLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::CumSumLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::CumSumLayer*>)
	}
	
	 Result<cv::dnn::DataAugmentationLayer*> cv_Layer_to_DataAugmentationLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::DataAugmentationLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::DataAugmentationLayer*>)
	}
	
	 Result<cv::dnn::DequantizeLayer*> cv_Layer_to_DequantizeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::DequantizeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::DequantizeLayer*>)
	}
	
	 Result<cv::dnn::DetectionOutputLayer*> cv_Layer_to_DetectionOutputLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::DetectionOutputLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::DetectionOutputLayer*>)
	}
	
	 Result<cv::dnn::EltwiseLayer*> cv_Layer_to_EltwiseLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::EltwiseLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::EltwiseLayer*>)
	}
	
	 Result<cv::dnn::EltwiseLayerInt8*> cv_Layer_to_EltwiseLayerInt8(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::EltwiseLayerInt8*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::EltwiseLayerInt8*>)
	}
	
	 Result<cv::dnn::FlattenLayer*> cv_Layer_to_FlattenLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::FlattenLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::FlattenLayer*>)
	}
	
	 Result<cv::dnn::FlowWarpLayer*> cv_Layer_to_FlowWarpLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::FlowWarpLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::FlowWarpLayer*>)
	}
	
	 Result<cv::dnn::GRULayer*> cv_Layer_to_GRULayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::GRULayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::GRULayer*>)
	}
	
	 Result<cv::dnn::InnerProductLayer*> cv_Layer_to_InnerProductLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::InnerProductLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::InnerProductLayer*>)
	}
	
	 Result<cv::dnn::InterpLayer*> cv_Layer_to_InterpLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::InterpLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::InterpLayer*>)
	}
	
	 Result<cv::dnn::LRNLayer*> cv_Layer_to_LRNLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::LRNLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::LRNLayer*>)
	}
	
	 Result<cv::dnn::MVNLayer*> cv_Layer_to_MVNLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::MVNLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::MVNLayer*>)
	}
	
	 Result<cv::dnn::MaxUnpoolLayer*> cv_Layer_to_MaxUnpoolLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::MaxUnpoolLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::MaxUnpoolLayer*>)
	}
	
	 Result<cv::dnn::NormalizeBBoxLayer*> cv_Layer_to_NormalizeBBoxLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::NormalizeBBoxLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::NormalizeBBoxLayer*>)
	}
	
	 Result<cv::dnn::PaddingLayer*> cv_Layer_to_PaddingLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::PaddingLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::PaddingLayer*>)
	}
	
	 Result<cv::dnn::PermuteLayer*> cv_Layer_to_PermuteLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::PermuteLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::PermuteLayer*>)
	}
	
	 Result<cv::dnn::PoolingLayer*> cv_Layer_to_PoolingLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::PoolingLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::PoolingLayer*>)
	}
	
	 Result<cv::dnn::PriorBoxLayer*> cv_Layer_to_PriorBoxLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::PriorBoxLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::PriorBoxLayer*>)
	}
	
	 Result<cv::dnn::ProposalLayer*> cv_Layer_to_ProposalLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ProposalLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ProposalLayer*>)
	}
	
	 Result<cv::dnn::QuantizeLayer*> cv_Layer_to_QuantizeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::QuantizeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::QuantizeLayer*>)
	}
	
	 Result<cv::dnn::RegionLayer*> cv_Layer_to_RegionLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::RegionLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::RegionLayer*>)
	}
	
	 Result<cv::dnn::ReorgLayer*> cv_Layer_to_ReorgLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ReorgLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ReorgLayer*>)
	}
	
	 Result<cv::dnn::RequantizeLayer*> cv_Layer_to_RequantizeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::RequantizeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::RequantizeLayer*>)
	}
	
	 Result<cv::dnn::ReshapeLayer*> cv_Layer_to_ReshapeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ReshapeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ReshapeLayer*>)
	}
	
	 Result<cv::dnn::ResizeLayer*> cv_Layer_to_ResizeLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ResizeLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ResizeLayer*>)
	}
	
	 Result<cv::dnn::ScaleLayer*> cv_Layer_to_ScaleLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ScaleLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ScaleLayer*>)
	}
	
	 Result<cv::dnn::ShiftLayer*> cv_Layer_to_ShiftLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ShiftLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ShiftLayer*>)
	}
	
	 Result<cv::dnn::ShiftLayerInt8*> cv_Layer_to_ShiftLayerInt8(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ShiftLayerInt8*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ShiftLayerInt8*>)
	}
	
	 Result<cv::dnn::ShuffleChannelLayer*> cv_Layer_to_ShuffleChannelLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::ShuffleChannelLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::ShuffleChannelLayer*>)
	}
	
	 Result<cv::dnn::SliceLayer*> cv_Layer_to_SliceLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::SliceLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::SliceLayer*>)
	}
	
	 Result<cv::dnn::SoftmaxLayer*> cv_Layer_to_SoftmaxLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::SoftmaxLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::SoftmaxLayer*>)
	}
	
	 Result<cv::dnn::SplitLayer*> cv_Layer_to_SplitLayer(cv::dnn::Layer* instance) {
		try {
			return Ok(dynamic_cast<cv::dnn::SplitLayer*>(instance));
		} OCVRS_CATCH(Result<cv::dnn::SplitLayer*>)
	}
	
	cv::Algorithm* cv_Layer_to_Algorithm(cv::dnn::Layer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	void cv_Layer_delete(cv::dnn::Layer* instance) {
		delete instance;
	}
	// finalize(cv::InputArrayOfArrays, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:220
	Result_void cv_dnn_Layer_finalize_const__InputArrayR_const__OutputArrayR(cv::dnn::Layer* instance, const cv::_InputArray* inputs, const cv::_OutputArray* outputs) {
		try {
			instance->finalize(*inputs, *outputs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forward(std::vector<Mat *> &, std::vector<Mat> &, std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:229
	Result_void cv_dnn_Layer_forward_vector_MatX_R_vector_Mat_R_vector_Mat_R(cv::dnn::Layer* instance, std::vector<cv::Mat*>* input, std::vector<cv::Mat>* output, std::vector<cv::Mat>* internals) {
		try {
			instance->forward(*input, *output, *internals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forward(cv::InputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:236
	Result_void cv_dnn_Layer_forward_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::dnn::Layer* instance, const cv::_InputArray* inputs, const cv::_OutputArray* outputs, const cv::_OutputArray* internals) {
		try {
			instance->forward(*inputs, *outputs, *internals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// tryQuantize(const std::vector<std::vector<float>> &, const std::vector<std::vector<int>> &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:244
	Result<bool> cv_dnn_Layer_tryQuantize_const_vector_vector_float__R_const_vector_vector_int__R_LayerParamsR(cv::dnn::Layer* instance, const std::vector<std::vector<float>>* scales, const std::vector<std::vector<int>>* zeropoints, cv::dnn::LayerParams* params) {
		try {
			bool ret = instance->tryQuantize(*scales, *zeropoints, *params);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// forward_fallback(cv::InputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:252
	Result_void cv_dnn_Layer_forward_fallback_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(cv::dnn::Layer* instance, const cv::_InputArray* inputs, const cv::_OutputArray* outputs, const cv::_OutputArray* internals) {
		try {
			instance->forward_fallback(*inputs, *outputs, *internals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// finalize(const std::vector<Mat> &, std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:259
	Result_void cv_dnn_Layer_finalize_const_vector_Mat_R_vector_Mat_R(cv::dnn::Layer* instance, const std::vector<cv::Mat>* inputs, std::vector<cv::Mat>* outputs) {
		try {
			instance->finalize(*inputs, *outputs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// finalize(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:265
	Result<std::vector<cv::Mat>*> cv_dnn_Layer_finalize_const_vector_Mat_R(cv::dnn::Layer* instance, const std::vector<cv::Mat>* inputs) {
		try {
			std::vector<cv::Mat> ret = instance->finalize(*inputs);
			return Ok(new std::vector<cv::Mat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Mat>*>))
	}
	
	// run(const std::vector<Mat> &, std::vector<Mat> &, std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:270
	Result_void cv_dnn_Layer_run_const_vector_Mat_R_vector_Mat_R_vector_Mat_R(cv::dnn::Layer* instance, const std::vector<cv::Mat>* inputs, std::vector<cv::Mat>* outputs, std::vector<cv::Mat>* internals) {
		try {
			instance->run(*inputs, *outputs, *internals);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inputNameToIndex(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:279
	Result<int> cv_dnn_Layer_inputNameToIndex_String(cv::dnn::Layer* instance, char* inputName) {
		try {
			int ret = instance->inputNameToIndex(std::string(inputName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// outputNameToIndex(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:283
	Result<int> cv_dnn_Layer_outputNameToIndex_const_StringR(cv::dnn::Layer* instance, const char* outputName) {
		try {
			int ret = instance->outputNameToIndex(std::string(outputName));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// supportBackend(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:290
	Result<bool> cv_dnn_Layer_supportBackend_int(cv::dnn::Layer* instance, int backendId) {
		try {
			bool ret = instance->supportBackend(backendId);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// initHalide(const std::vector<Ptr<BackendWrapper>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:302
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_initHalide_const_vector_Ptr_BackendWrapper__R(cv::dnn::Layer* instance, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* inputs) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->initHalide(*inputs);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// initInfEngine(const std::vector<Ptr<BackendWrapper>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:304
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_initInfEngine_const_vector_Ptr_BackendWrapper__R(cv::dnn::Layer* instance, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* inputs) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->initInfEngine(*inputs);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// initNgraph(const std::vector<Ptr<BackendWrapper>> &, const std::vector<Ptr<BackendNode>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:306
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_initNgraph_const_vector_Ptr_BackendWrapper__R_const_vector_Ptr_BackendNode__R(cv::dnn::Layer* instance, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* inputs, const std::vector<cv::Ptr<cv::dnn::BackendNode>>* nodes) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->initNgraph(*inputs, *nodes);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// initVkCom(const std::vector<Ptr<BackendWrapper>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:308
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_initVkCom_const_vector_Ptr_BackendWrapper__R(cv::dnn::Layer* instance, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* inputs) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->initVkCom(*inputs);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// initCUDA(void *, const std::vector<Ptr<BackendWrapper>> &, const std::vector<Ptr<BackendWrapper>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:317
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_initCUDA_voidX_const_vector_Ptr_BackendWrapper__R_const_vector_Ptr_BackendWrapper__R(cv::dnn::Layer* instance, void* context, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* inputs, const std::vector<cv::Ptr<cv::dnn::BackendWrapper>>* outputs) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->initCUDA(context, *inputs, *outputs);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// applyHalideScheduler(Ptr<cv::dnn::BackendNode> &, const std::vector<Mat *> &, const std::vector<Mat> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:334
	Result_void cv_dnn_Layer_applyHalideScheduler_const_Ptr_BackendNode_R_const_vector_MatX_R_const_vector_Mat_R_int(const cv::dnn::Layer* instance, cv::Ptr<cv::dnn::BackendNode>* node, const std::vector<cv::Mat*>* inputs, const std::vector<cv::Mat>* outputs, int targetId) {
		try {
			instance->applyHalideScheduler(*node, *inputs, *outputs, targetId);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// tryAttach(const Ptr<cv::dnn::BackendNode> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:348
	Result<cv::Ptr<cv::dnn::BackendNode>*> cv_dnn_Layer_tryAttach_const_Ptr_BackendNode_R(cv::dnn::Layer* instance, const cv::Ptr<cv::dnn::BackendNode>* node) {
		try {
			cv::Ptr<cv::dnn::BackendNode> ret = instance->tryAttach(*node);
			return Ok(new cv::Ptr<cv::dnn::BackendNode>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::BackendNode>*>))
	}
	
	// setActivation(const Ptr<cv::dnn::ActivationLayer> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:356
	Result<bool> cv_dnn_Layer_setActivation_const_Ptr_ActivationLayer_R(cv::dnn::Layer* instance, const cv::Ptr<cv::dnn::ActivationLayer>* layer) {
		try {
			bool ret = instance->setActivation(*layer);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// tryFuse(Ptr<cv::dnn::Layer> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:363
	Result<bool> cv_dnn_Layer_tryFuse_Ptr_Layer_R(cv::dnn::Layer* instance, cv::Ptr<cv::dnn::Layer>* top) {
		try {
			bool ret = instance->tryFuse(*top);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getScaleShift(cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:378
	Result_void cv_dnn_Layer_getScaleShift_const_MatR_MatR(const cv::dnn::Layer* instance, cv::Mat* scale, cv::Mat* shift) {
		try {
			instance->getScaleShift(*scale, *shift);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleZeropoint(float &, int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:387
	Result_void cv_dnn_Layer_getScaleZeropoint_const_floatR_intR(const cv::dnn::Layer* instance, float* scale, int* zeropoint) {
		try {
			instance->getScaleZeropoint(*scale, *zeropoint);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unsetAttached() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:393
	Result_void cv_dnn_Layer_unsetAttached(cv::dnn::Layer* instance) {
		try {
			instance->unsetAttached();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryShapes(const std::vector<MatShape> &, const int, std::vector<MatShape> &, std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:395
	Result<bool> cv_dnn_Layer_getMemoryShapes_const_const_vector_MatShape_R_const_int_vector_MatShape_R_vector_MatShape_R(const cv::dnn::Layer* instance, const std::vector<cv::dnn::MatShape>* inputs, const int requiredOutputs, std::vector<cv::dnn::MatShape>* outputs, std::vector<cv::dnn::MatShape>* internals) {
		try {
			bool ret = instance->getMemoryShapes(*inputs, requiredOutputs, *outputs, *internals);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getFLOPS(const std::vector<MatShape> &, const std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:400
	Result<int64_t> cv_dnn_Layer_getFLOPS_const_const_vector_MatShape_R_const_vector_MatShape_R(const cv::dnn::Layer* instance, const std::vector<cv::dnn::MatShape>* inputs, const std::vector<cv::dnn::MatShape>* outputs) {
		try {
			int64_t ret = instance->getFLOPS(*inputs, *outputs);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// updateMemoryShapes(const std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:403
	Result<bool> cv_dnn_Layer_updateMemoryShapes_const_vector_MatShape_R(cv::dnn::Layer* instance, const std::vector<cv::dnn::MatShape>* inputs) {
		try {
			bool ret = instance->updateMemoryShapes(*inputs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// Layer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:409
	Result<cv::dnn::Layer*> cv_dnn_Layer_Layer() {
		try {
			cv::dnn::Layer* ret = new cv::dnn::Layer();
			return Ok<cv::dnn::Layer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Layer*>))
	}
	
	// Layer(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:410
	Result<cv::dnn::Layer*> cv_dnn_Layer_Layer_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::dnn::Layer* ret = new cv::dnn::Layer(*params);
			return Ok<cv::dnn::Layer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Layer*>))
	}
	
	// setParamsFrom(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:411
	Result_void cv_dnn_Layer_setParamsFrom_const_LayerParamsR(cv::dnn::Layer* instance, const cv::dnn::LayerParams* params) {
		try {
			instance->setParamsFrom(*params);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_LayerFactory_delete(cv::dnn::LayerFactory* instance) {
		delete instance;
	}
	// registerLayer(const cv::String &, cv::dnn::LayerFactory::Constructor) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/layer.hpp:64
	Result_void cv_dnn_LayerFactory_registerLayer_const_StringR_Constructor(const char* type, cv::dnn::LayerFactory::Constructor constructor) {
		try {
			cv::dnn::LayerFactory::registerLayer(std::string(type), constructor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unregisterLayer(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/layer.hpp:67
	Result_void cv_dnn_LayerFactory_unregisterLayer_const_StringR(const char* type) {
		try {
			cv::dnn::LayerFactory::unregisterLayer(std::string(type));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createLayerInstance(const cv::String &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/layer.hpp:74
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_LayerFactory_createLayerInstance_const_StringR_LayerParamsR(const char* type, cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::LayerFactory::createLayerInstance(std::string(type), *params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	// blobs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:124
	std::vector<cv::Mat>* cv_dnn_LayerParams_getPropBlobs_const(const cv::dnn::LayerParams* instance) {
		std::vector<cv::Mat> ret = instance->blobs;
		return new std::vector<cv::Mat>(ret);
	}
	
	// blobs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:124
	void cv_dnn_LayerParams_setPropBlobs_vector_Mat_(cv::dnn::LayerParams* instance, std::vector<cv::Mat>* val) {
		instance->blobs = *val;
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:126
	void* cv_dnn_LayerParams_getPropName_const(const cv::dnn::LayerParams* instance) {
		cv::String ret = instance->name;
		return ocvrs_create_string(ret.c_str());
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:126
	void cv_dnn_LayerParams_setPropName_String(cv::dnn::LayerParams* instance, char* val) {
		instance->name = std::string(val);
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:127
	void* cv_dnn_LayerParams_getPropType_const(const cv::dnn::LayerParams* instance) {
		cv::String ret = instance->type;
		return ocvrs_create_string(ret.c_str());
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:127
	void cv_dnn_LayerParams_setPropType_String(cv::dnn::LayerParams* instance, char* val) {
		instance->type = std::string(val);
	}
	
	cv::dnn::Dict* cv_LayerParams_to_Dict(cv::dnn::LayerParams* instance) {
		return dynamic_cast<cv::dnn::Dict*>(instance);
	}
	
	void cv_LayerParams_delete(cv::dnn::LayerParams* instance) {
		delete instance;
	}
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:351
	float cv_dnn_MVNLayer_getPropEps_const(const cv::dnn::MVNLayer* instance) {
		float ret = instance->eps;
		return (float)ret;
	}
	
	// eps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:351
	void cv_dnn_MVNLayer_setPropEps_float(cv::dnn::MVNLayer* instance, float val) {
		instance->eps = val;
	}
	
	// normVariance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:352
	bool cv_dnn_MVNLayer_getPropNormVariance_const(const cv::dnn::MVNLayer* instance) {
		bool ret = instance->normVariance;
		return (bool)ret;
	}
	
	// normVariance /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:352
	void cv_dnn_MVNLayer_setPropNormVariance_bool(cv::dnn::MVNLayer* instance, bool val) {
		instance->normVariance = val;
	}
	
	// acrossChannels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:352
	bool cv_dnn_MVNLayer_getPropAcrossChannels_const(const cv::dnn::MVNLayer* instance) {
		bool ret = instance->acrossChannels;
		return (bool)ret;
	}
	
	// acrossChannels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:352
	void cv_dnn_MVNLayer_setPropAcrossChannels_bool(cv::dnn::MVNLayer* instance, bool val) {
		instance->acrossChannels = val;
	}
	
	cv::Algorithm* cv_MVNLayer_to_Algorithm(cv::dnn::MVNLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_MVNLayer_to_Layer(cv::dnn::MVNLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_MVNLayer_delete(cv::dnn::MVNLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:354
	Result<cv::Ptr<cv::dnn::MVNLayer>*> cv_dnn_MVNLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::MVNLayer> ret = cv::dnn::MVNLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::MVNLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::MVNLayer>*>))
	}
	
	// poolKernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:656
	cv::Size cv_dnn_MaxUnpoolLayer_getPropPoolKernel_const(const cv::dnn::MaxUnpoolLayer* instance) {
		cv::Size ret = instance->poolKernel;
		return (cv::Size)ret;
	}
	
	// poolKernel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:656
	void cv_dnn_MaxUnpoolLayer_setPropPoolKernel_Size(cv::dnn::MaxUnpoolLayer* instance, cv::Size* val) {
		instance->poolKernel = *val;
	}
	
	// poolPad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:657
	cv::Size cv_dnn_MaxUnpoolLayer_getPropPoolPad_const(const cv::dnn::MaxUnpoolLayer* instance) {
		cv::Size ret = instance->poolPad;
		return (cv::Size)ret;
	}
	
	// poolPad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:657
	void cv_dnn_MaxUnpoolLayer_setPropPoolPad_Size(cv::dnn::MaxUnpoolLayer* instance, cv::Size* val) {
		instance->poolPad = *val;
	}
	
	// poolStride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:658
	cv::Size cv_dnn_MaxUnpoolLayer_getPropPoolStride_const(const cv::dnn::MaxUnpoolLayer* instance) {
		cv::Size ret = instance->poolStride;
		return (cv::Size)ret;
	}
	
	// poolStride /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:658
	void cv_dnn_MaxUnpoolLayer_setPropPoolStride_Size(cv::dnn::MaxUnpoolLayer* instance, cv::Size* val) {
		instance->poolStride = *val;
	}
	
	cv::Algorithm* cv_MaxUnpoolLayer_to_Algorithm(cv::dnn::MaxUnpoolLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_MaxUnpoolLayer_to_Layer(cv::dnn::MaxUnpoolLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_MaxUnpoolLayer_delete(cv::dnn::MaxUnpoolLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:660
	Result<cv::Ptr<cv::dnn::MaxUnpoolLayer>*> cv_dnn_MaxUnpoolLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::MaxUnpoolLayer> ret = cv::dnn::MaxUnpoolLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::MaxUnpoolLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::MaxUnpoolLayer>*>))
	}
	
	cv::dnn::ActivationLayer* cv_MishLayer_to_ActivationLayer(cv::dnn::MishLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_MishLayer_to_Algorithm(cv::dnn::MishLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_MishLayer_to_Layer(cv::dnn::MishLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_MishLayer_delete(cv::dnn::MishLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:566
	Result<cv::Ptr<cv::dnn::MishLayer>*> cv_dnn_MishLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::MishLayer> ret = cv::dnn::MishLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::MishLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::MishLayer>*>))
	}
	
	void cv_Model_delete(cv::dnn::Model* instance) {
		delete instance;
	}
	// Model() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1177
	Result<cv::dnn::Model*> cv_dnn_Model_Model() {
		try {
			cv::dnn::Model* ret = new cv::dnn::Model();
			return Ok<cv::dnn::Model*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// Model(const cv::dnn::Model &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1179
	cv::dnn::Model* cv_dnn_Model_Model_const_ModelR(const cv::dnn::Model* unnamed) {
		cv::dnn::Model* ret = new cv::dnn::Model(*unnamed);
		return (cv::dnn::Model*)ret;
	}
	
	// Model(cv::dnn::Model &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1180
	cv::dnn::Model* cv_dnn_Model_Model_ModelR(cv::dnn::Model* unnamed) {
		cv::dnn::Model* ret = new cv::dnn::Model(*unnamed);
		return (cv::dnn::Model*)ret;
	}
	
	// Model(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1190
	Result<cv::dnn::Model*> cv_dnn_Model_Model_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::Model* ret = new cv::dnn::Model(std::string(model), std::string(config));
			return Ok<cv::dnn::Model*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// Model(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1196
	Result<cv::dnn::Model*> cv_dnn_Model_Model_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::Model* ret = new cv::dnn::Model(*network);
			return Ok<cv::dnn::Model*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputSize(const cv::Size &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1202
	Result<cv::dnn::Model*> cv_dnn_Model_setInputSize_const_SizeR(cv::dnn::Model* instance, const cv::Size* size) {
		try {
			cv::dnn::Model ret = instance->setInputSize(*size);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputSize(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1209
	Result<cv::dnn::Model*> cv_dnn_Model_setInputSize_int_int(cv::dnn::Model* instance, int width, int height) {
		try {
			cv::dnn::Model ret = instance->setInputSize(width, height);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputMean(const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1214
	Result<cv::dnn::Model*> cv_dnn_Model_setInputMean_const_ScalarR(cv::dnn::Model* instance, const cv::Scalar* mean) {
		try {
			cv::dnn::Model ret = instance->setInputMean(*mean);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputScale(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1219
	Result<cv::dnn::Model*> cv_dnn_Model_setInputScale_double(cv::dnn::Model* instance, double scale) {
		try {
			cv::dnn::Model ret = instance->setInputScale(scale);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputCrop(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1224
	Result<cv::dnn::Model*> cv_dnn_Model_setInputCrop_bool(cv::dnn::Model* instance, bool crop) {
		try {
			cv::dnn::Model ret = instance->setInputCrop(crop);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputSwapRB(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1229
	Result<cv::dnn::Model*> cv_dnn_Model_setInputSwapRB_bool(cv::dnn::Model* instance, bool swapRB) {
		try {
			cv::dnn::Model ret = instance->setInputSwapRB(swapRB);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setInputParams(double, const cv::Size &, const cv::Scalar &, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1239
	Result_void cv_dnn_Model_setInputParams_double_const_SizeR_const_ScalarR_bool_bool(cv::dnn::Model* instance, double scale, const cv::Size* size, const cv::Scalar* mean, bool swapRB, bool crop) {
		try {
			instance->setInputParams(scale, *size, *mean, swapRB, crop);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// predict(cv::InputArray, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1246
	Result_void cv_dnn_Model_predict_const_const__InputArrayR_const__OutputArrayR(const cv::dnn::Model* instance, const cv::_InputArray* frame, const cv::_OutputArray* outs) {
		try {
			instance->predict(*frame, *outs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPreferableBackend(dnn::Backend) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1256
	Result<cv::dnn::Model*> cv_dnn_Model_setPreferableBackend_Backend(cv::dnn::Model* instance, cv::dnn::Backend backendId) {
		try {
			cv::dnn::Model ret = instance->setPreferableBackend(backendId);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// setPreferableTarget(dnn::Target) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1258
	Result<cv::dnn::Model*> cv_dnn_Model_setPreferableTarget_Target(cv::dnn::Model* instance, cv::dnn::Target targetId) {
		try {
			cv::dnn::Model ret = instance->setPreferableTarget(targetId);
			return Ok(new cv::dnn::Model(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Model*>))
	}
	
	// getNetwork_() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1264
	Result<cv::dnn::Net*> cv_dnn_Model_getNetwork__const(const cv::dnn::Model* instance) {
		try {
			cv::dnn::Net ret = instance->getNetwork_();
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// getNetwork_() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1265
	Result<cv::dnn::Net*> cv_dnn_Model_getNetwork_(cv::dnn::Model* instance) {
		try {
			cv::dnn::Net ret = instance->getNetwork_();
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	void cv_Net_delete(cv::dnn::Net* instance) {
		delete instance;
	}
	// Net() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:429
	Result<cv::dnn::Net*> cv_dnn_Net_Net() {
		try {
			cv::dnn::Net* ret = new cv::dnn::Net();
			return Ok<cv::dnn::Net*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readFromModelOptimizer(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:438
	Result<cv::dnn::Net*> cv_dnn_Net_readFromModelOptimizer_const_StringR_const_StringR(const char* xml, const char* bin) {
		try {
			cv::dnn::Net ret = cv::dnn::Net::readFromModelOptimizer(std::string(xml), std::string(bin));
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readFromModelOptimizer(const std::vector<uchar> &, const std::vector<uchar> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:446
	Result<cv::dnn::Net*> cv_dnn_Net_readFromModelOptimizer_const_vector_unsigned_char_R_const_vector_unsigned_char_R(const std::vector<unsigned char>* bufferModelConfig, const std::vector<unsigned char>* bufferWeights) {
		try {
			cv::dnn::Net ret = cv::dnn::Net::readFromModelOptimizer(*bufferModelConfig, *bufferWeights);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// readFromModelOptimizer(const uchar *, size_t, const uchar *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:456
	Result<cv::dnn::Net*> cv_dnn_Net_readFromModelOptimizer_const_unsigned_charX_size_t_const_unsigned_charX_size_t(const unsigned char* bufferModelConfigPtr, size_t bufferModelConfigSize, const unsigned char* bufferWeightsPtr, size_t bufferWeightsSize) {
		try {
			cv::dnn::Net ret = cv::dnn::Net::readFromModelOptimizer(bufferModelConfigPtr, bufferModelConfigSize, bufferWeightsPtr, bufferWeightsSize);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:460
	Result<bool> cv_dnn_Net_empty_const(const cv::dnn::Net* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// dump() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:466
	Result<void*> cv_dnn_Net_dump(cv::dnn::Net* instance) {
		try {
			cv::String ret = instance->dump();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpToFile(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:471
	Result_void cv_dnn_Net_dumpToFile_const_StringR(cv::dnn::Net* instance, const char* path) {
		try {
			instance->dumpToFile(std::string(path));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addLayer(const cv::String &, const cv::String &, const int &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:479
	Result<int> cv_dnn_Net_addLayer_const_StringR_const_StringR_const_intR_LayerParamsR(cv::dnn::Net* instance, const char* name, const char* type, const int* dtype, cv::dnn::LayerParams* params) {
		try {
			int ret = instance->addLayer(std::string(name), std::string(type), *dtype, *params);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addLayer(const cv::String &, const cv::String &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:482
	Result<int> cv_dnn_Net_addLayer_const_StringR_const_StringR_LayerParamsR(cv::dnn::Net* instance, const char* name, const char* type, cv::dnn::LayerParams* params) {
		try {
			int ret = instance->addLayer(std::string(name), std::string(type), *params);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addLayerToPrev(const cv::String &, const cv::String &, const int &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:487
	Result<int> cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_const_intR_LayerParamsR(cv::dnn::Net* instance, const char* name, const char* type, const int* dtype, cv::dnn::LayerParams* params) {
		try {
			int ret = instance->addLayerToPrev(std::string(name), std::string(type), *dtype, *params);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addLayerToPrev(const cv::String &, const cv::String &, cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:490
	Result<int> cv_dnn_Net_addLayerToPrev_const_StringR_const_StringR_LayerParamsR(cv::dnn::Net* instance, const char* name, const char* type, cv::dnn::LayerParams* params) {
		try {
			int ret = instance->addLayerToPrev(std::string(name), std::string(type), *params);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getLayerId(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:495
	Result<int> cv_dnn_Net_getLayerId_const_StringR(cv::dnn::Net* instance, const char* layer) {
		try {
			int ret = instance->getLayerId(std::string(layer));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getLayerNames() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:497
	Result<std::vector<cv::String>*> cv_dnn_Net_getLayerNames_const(const cv::dnn::Net* instance) {
		try {
			std::vector<cv::String> ret = instance->getLayerNames();
			return Ok(new std::vector<cv::String>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::String>*>))
	}
	
	// getLayer(cv::dnn::Net::LayerId) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:503
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_Net_getLayer_LayerId(cv::dnn::Net* instance, cv::dnn::Net::LayerId* layerId) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = instance->getLayer(*layerId);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	// getLayerInputs(cv::dnn::Net::LayerId) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:506
	Result<std::vector<cv::Ptr<cv::dnn::Layer>>*> cv_dnn_Net_getLayerInputs_LayerId(cv::dnn::Net* instance, cv::dnn::Net::LayerId* layerId) {
		try {
			std::vector<cv::Ptr<cv::dnn::Layer>> ret = instance->getLayerInputs(*layerId);
			return Ok(new std::vector<cv::Ptr<cv::dnn::Layer>>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::Ptr<cv::dnn::Layer>>*>))
	}
	
	// connect(cv::String, cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:521
	Result_void cv_dnn_Net_connect_String_String(cv::dnn::Net* instance, char* outPin, char* inpPin) {
		try {
			instance->connect(std::string(outPin), std::string(inpPin));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// connect(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:529
	Result_void cv_dnn_Net_connect_int_int_int_int(cv::dnn::Net* instance, int outLayerId, int outNum, int inpLayerId, int inpNum) {
		try {
			instance->connect(outLayerId, outNum, inpLayerId, inpNum);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInputsNames(const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:538
	Result_void cv_dnn_Net_setInputsNames_const_vector_String_R(cv::dnn::Net* instance, const std::vector<cv::String>* inputBlobNames) {
		try {
			instance->setInputsNames(*inputBlobNames);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInputShape(const cv::String &, const cv::dnn::MatShape &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:542
	Result_void cv_dnn_Net_setInputShape_const_StringR_const_MatShapeR(cv::dnn::Net* instance, const char* inputName, const cv::dnn::MatShape* shape) {
		try {
			instance->setInputShape(std::string(inputName), *shape);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forward(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:549
	Result<cv::Mat*> cv_dnn_Net_forward_const_StringR(cv::dnn::Net* instance, const char* outputName) {
		try {
			cv::Mat ret = instance->forward(std::string(outputName));
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// forwardAsync(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:558
	Result<cv::AsyncArray*> cv_dnn_Net_forwardAsync_const_StringR(cv::dnn::Net* instance, const char* outputName) {
		try {
			cv::AsyncArray ret = instance->forwardAsync(std::string(outputName));
			return Ok(new cv::AsyncArray(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncArray*>))
	}
	
	// forward(cv::OutputArrayOfArrays, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:565
	Result_void cv_dnn_Net_forward_const__OutputArrayR_const_StringR(cv::dnn::Net* instance, const cv::_OutputArray* outputBlobs, const char* outputName) {
		try {
			instance->forward(*outputBlobs, std::string(outputName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forward(cv::OutputArrayOfArrays, const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:571
	Result_void cv_dnn_Net_forward_const__OutputArrayR_const_vector_String_R(cv::dnn::Net* instance, const cv::_OutputArray* outputBlobs, const std::vector<cv::String>* outBlobNames) {
		try {
			instance->forward(*outputBlobs, *outBlobNames);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// forward(std::vector<std::vector<Mat>> &, const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:578
	Result_void cv_dnn_Net_forward_vector_vector_Mat__R_const_vector_String_R(cv::dnn::Net* instance, std::vector<std::vector<cv::Mat>>* outputBlobs, const std::vector<cv::String>* outBlobNames) {
		try {
			instance->forward(*outputBlobs, *outBlobNames);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// quantize(cv::InputArrayOfArrays, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:586
	Result<cv::dnn::Net*> cv_dnn_Net_quantize_const__InputArrayR_int_int(cv::dnn::Net* instance, const cv::_InputArray* calibData, int inputsDtype, int outputsDtype) {
		try {
			cv::dnn::Net ret = instance->quantize(*calibData, inputsDtype, outputsDtype);
			return Ok(new cv::dnn::Net(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::Net*>))
	}
	
	// getInputDetails(std::vector<float> &, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:592
	Result_void cv_dnn_Net_getInputDetails_const_vector_float_R_vector_int_R(const cv::dnn::Net* instance, std::vector<float>* scales, std::vector<int>* zeropoints) {
		try {
			instance->getInputDetails(*scales, *zeropoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOutputDetails(std::vector<float> &, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:598
	Result_void cv_dnn_Net_getOutputDetails_const_vector_float_R_vector_int_R(const cv::dnn::Net* instance, std::vector<float>* scales, std::vector<int>* zeropoints) {
		try {
			instance->getOutputDetails(*scales, *zeropoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setHalideScheduler(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:609
	Result_void cv_dnn_Net_setHalideScheduler_const_StringR(cv::dnn::Net* instance, const char* scheduler) {
		try {
			instance->setHalideScheduler(std::string(scheduler));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPreferableBackend(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:619
	Result_void cv_dnn_Net_setPreferableBackend_int(cv::dnn::Net* instance, int backendId) {
		try {
			instance->setPreferableBackend(backendId);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setPreferableTarget(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:638
	Result_void cv_dnn_Net_setPreferableTarget_int(cv::dnn::Net* instance, int targetId) {
		try {
			instance->setPreferableTarget(targetId);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInput(cv::InputArray, const cv::String &, double, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:651
	Result_void cv_dnn_Net_setInput_const__InputArrayR_const_StringR_double_const_ScalarR(cv::dnn::Net* instance, const cv::_InputArray* blob, const char* name, double scalefactor, const cv::Scalar* mean) {
		try {
			instance->setInput(*blob, std::string(name), scalefactor, *mean);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setParam(cv::dnn::Net::LayerId, int, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:662
	Result_void cv_dnn_Net_setParam_LayerId_int_const_MatR(cv::dnn::Net* instance, cv::dnn::Net::LayerId* layer, int numParam, const cv::Mat* blob) {
		try {
			instance->setParam(*layer, numParam, *blob);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getParam(cv::dnn::Net::LayerId, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:669
	Result<cv::Mat*> cv_dnn_Net_getParam_LayerId_int(cv::dnn::Net* instance, cv::dnn::Net::LayerId* layer, int numParam) {
		try {
			cv::Mat ret = instance->getParam(*layer, numParam);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getUnconnectedOutLayers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:673
	Result<std::vector<int>*> cv_dnn_Net_getUnconnectedOutLayers_const(const cv::dnn::Net* instance) {
		try {
			std::vector<int> ret = instance->getUnconnectedOutLayers();
			return Ok(new std::vector<int>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<int>*>))
	}
	
	// getUnconnectedOutLayersNames() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:677
	Result<std::vector<cv::String>*> cv_dnn_Net_getUnconnectedOutLayersNames_const(const cv::dnn::Net* instance) {
		try {
			std::vector<cv::String> ret = instance->getUnconnectedOutLayersNames();
			return Ok(new std::vector<cv::String>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::String>*>))
	}
	
	// getLayersShapes(const std::vector<MatShape> &, std::vector<int> &, std::vector<std::vector<MatShape>> &, std::vector<std::vector<MatShape>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:688
	Result_void cv_dnn_Net_getLayersShapes_const_const_vector_MatShape_R_vector_int_R_vector_vector_MatShape__R_vector_vector_MatShape__R(const cv::dnn::Net* instance, const std::vector<cv::dnn::MatShape>* netInputShapes, std::vector<int>* layersIds, std::vector<std::vector<cv::dnn::MatShape>>* inLayersShapes, std::vector<std::vector<cv::dnn::MatShape>>* outLayersShapes) {
		try {
			instance->getLayersShapes(*netInputShapes, *layersIds, *inLayersShapes, *outLayersShapes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLayersShapes(const cv::dnn::MatShape &, std::vector<int> &, std::vector<std::vector<MatShape>> &, std::vector<std::vector<MatShape>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:694
	Result_void cv_dnn_Net_getLayersShapes_const_const_MatShapeR_vector_int_R_vector_vector_MatShape__R_vector_vector_MatShape__R(const cv::dnn::Net* instance, const cv::dnn::MatShape* netInputShape, std::vector<int>* layersIds, std::vector<std::vector<cv::dnn::MatShape>>* inLayersShapes, std::vector<std::vector<cv::dnn::MatShape>>* outLayersShapes) {
		try {
			instance->getLayersShapes(*netInputShape, *layersIds, *inLayersShapes, *outLayersShapes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLayerShapes(const cv::dnn::MatShape &, const int, std::vector<MatShape> &, std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:708
	Result_void cv_dnn_Net_getLayerShapes_const_const_MatShapeR_const_int_vector_MatShape_R_vector_MatShape_R(const cv::dnn::Net* instance, const cv::dnn::MatShape* netInputShape, const int layerId, std::vector<cv::dnn::MatShape>* inLayerShapes, std::vector<cv::dnn::MatShape>* outLayerShapes) {
		try {
			instance->getLayerShapes(*netInputShape, layerId, *inLayerShapes, *outLayerShapes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLayerShapes(const std::vector<MatShape> &, const int, std::vector<MatShape> &, std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:714
	Result_void cv_dnn_Net_getLayerShapes_const_const_vector_MatShape_R_const_int_vector_MatShape_R_vector_MatShape_R(const cv::dnn::Net* instance, const std::vector<cv::dnn::MatShape>* netInputShapes, const int layerId, std::vector<cv::dnn::MatShape>* inLayerShapes, std::vector<cv::dnn::MatShape>* outLayerShapes) {
		try {
			instance->getLayerShapes(*netInputShapes, layerId, *inLayerShapes, *outLayerShapes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFLOPS(const std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:723
	Result<int64_t> cv_dnn_Net_getFLOPS_const_const_vector_MatShape_R(const cv::dnn::Net* instance, const std::vector<cv::dnn::MatShape>* netInputShapes) {
		try {
			int64_t ret = instance->getFLOPS(*netInputShapes);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getFLOPS(const cv::dnn::MatShape &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:725
	Result<int64_t> cv_dnn_Net_getFLOPS_const_const_MatShapeR(const cv::dnn::Net* instance, const cv::dnn::MatShape* netInputShape) {
		try {
			int64_t ret = instance->getFLOPS(*netInputShape);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getFLOPS(const int, const std::vector<MatShape> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:727
	Result<int64_t> cv_dnn_Net_getFLOPS_const_const_int_const_vector_MatShape_R(const cv::dnn::Net* instance, const int layerId, const std::vector<cv::dnn::MatShape>* netInputShapes) {
		try {
			int64_t ret = instance->getFLOPS(layerId, *netInputShapes);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getFLOPS(const int, const cv::dnn::MatShape &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:730
	Result<int64_t> cv_dnn_Net_getFLOPS_const_const_int_const_MatShapeR(const cv::dnn::Net* instance, const int layerId, const cv::dnn::MatShape* netInputShape) {
		try {
			int64_t ret = instance->getFLOPS(layerId, *netInputShape);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getLayerTypes(std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:736
	Result_void cv_dnn_Net_getLayerTypes_const_vector_String_R(const cv::dnn::Net* instance, std::vector<cv::String>* layersTypes) {
		try {
			instance->getLayerTypes(*layersTypes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getLayersCount(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:742
	Result<int> cv_dnn_Net_getLayersCount_const_const_StringR(const cv::dnn::Net* instance, const char* layerType) {
		try {
			int ret = instance->getLayersCount(std::string(layerType));
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getMemoryConsumption(const std::vector<MatShape> &, size_t &, size_t &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:750
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_vector_MatShape_R_size_tR_size_tR(const cv::dnn::Net* instance, const std::vector<cv::dnn::MatShape>* netInputShapes, size_t* weights, size_t* blobs) {
		try {
			instance->getMemoryConsumption(*netInputShapes, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryConsumption(const cv::dnn::MatShape &, size_t &, size_t &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:753
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_size_tR_size_tR(const cv::dnn::Net* instance, const cv::dnn::MatShape* netInputShape, size_t* weights, size_t* blobs) {
		try {
			instance->getMemoryConsumption(*netInputShape, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryConsumption(const int, const std::vector<MatShape> &, size_t &, size_t &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:756
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_int_const_vector_MatShape_R_size_tR_size_tR(const cv::dnn::Net* instance, const int layerId, const std::vector<cv::dnn::MatShape>* netInputShapes, size_t* weights, size_t* blobs) {
		try {
			instance->getMemoryConsumption(layerId, *netInputShapes, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryConsumption(const int, const cv::dnn::MatShape &, size_t &, size_t &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:760
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_int_const_MatShapeR_size_tR_size_tR(const cv::dnn::Net* instance, const int layerId, const cv::dnn::MatShape* netInputShape, size_t* weights, size_t* blobs) {
		try {
			instance->getMemoryConsumption(layerId, *netInputShape, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryConsumption(const std::vector<MatShape> &, std::vector<int> &, std::vector<size_t> &, std::vector<size_t> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:771
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_vector_MatShape_R_vector_int_R_vector_size_t_R_vector_size_t_R(const cv::dnn::Net* instance, const std::vector<cv::dnn::MatShape>* netInputShapes, std::vector<int>* layerIds, std::vector<size_t>* weights, std::vector<size_t>* blobs) {
		try {
			instance->getMemoryConsumption(*netInputShapes, *layerIds, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMemoryConsumption(const cv::dnn::MatShape &, std::vector<int> &, std::vector<size_t> &, std::vector<size_t> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:776
	Result_void cv_dnn_Net_getMemoryConsumption_const_const_MatShapeR_vector_int_R_vector_size_t_R_vector_size_t_R(const cv::dnn::Net* instance, const cv::dnn::MatShape* netInputShape, std::vector<int>* layerIds, std::vector<size_t>* weights, std::vector<size_t>* blobs) {
		try {
			instance->getMemoryConsumption(*netInputShape, *layerIds, *weights, *blobs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// enableFusion(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:784
	Result_void cv_dnn_Net_enableFusion_bool(cv::dnn::Net* instance, bool fusion) {
		try {
			instance->enableFusion(fusion);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPerfProfile(std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:794
	Result<int64_t> cv_dnn_Net_getPerfProfile_vector_double_R(cv::dnn::Net* instance, std::vector<double>* timings) {
		try {
			int64_t ret = instance->getPerfProfile(*timings);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// pnorm /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:778
	float cv_dnn_NormalizeBBoxLayer_getPropPnorm_const(const cv::dnn::NormalizeBBoxLayer* instance) {
		float ret = instance->pnorm;
		return (float)ret;
	}
	
	// pnorm /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:778
	void cv_dnn_NormalizeBBoxLayer_setPropPnorm_float(cv::dnn::NormalizeBBoxLayer* instance, float val) {
		instance->pnorm = val;
	}
	
	// epsilon /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:778
	float cv_dnn_NormalizeBBoxLayer_getPropEpsilon_const(const cv::dnn::NormalizeBBoxLayer* instance) {
		float ret = instance->epsilon;
		return (float)ret;
	}
	
	// epsilon /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:778
	void cv_dnn_NormalizeBBoxLayer_setPropEpsilon_float(cv::dnn::NormalizeBBoxLayer* instance, float val) {
		instance->epsilon = val;
	}
	
	// acrossSpatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:779
	bool cv_dnn_NormalizeBBoxLayer_getPropAcrossSpatial_const(const cv::dnn::NormalizeBBoxLayer* instance) {
		bool ret = instance->acrossSpatial;
		return (bool)ret;
	}
	
	// acrossSpatial /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:779
	void cv_dnn_NormalizeBBoxLayer_setPropAcrossSpatial_bool(cv::dnn::NormalizeBBoxLayer* instance, bool val) {
		instance->acrossSpatial = val;
	}
	
	cv::Algorithm* cv_NormalizeBBoxLayer_to_Algorithm(cv::dnn::NormalizeBBoxLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_NormalizeBBoxLayer_to_Layer(cv::dnn::NormalizeBBoxLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_NormalizeBBoxLayer_delete(cv::dnn::NormalizeBBoxLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:781
	Result<cv::Ptr<cv::dnn::NormalizeBBoxLayer>*> cv_dnn_NormalizeBBoxLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::NormalizeBBoxLayer> ret = cv::dnn::NormalizeBBoxLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::NormalizeBBoxLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::NormalizeBBoxLayer>*>))
	}
	
	cv::Algorithm* cv_PaddingLayer_to_Algorithm(cv::dnn::PaddingLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PaddingLayer_to_Layer(cv::dnn::PaddingLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_PaddingLayer_delete(cv::dnn::PaddingLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:508
	Result<cv::Ptr<cv::dnn::PaddingLayer>*> cv_dnn_PaddingLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PaddingLayer> ret = cv::dnn::PaddingLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PaddingLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PaddingLayer>*>))
	}
	
	cv::Algorithm* cv_PermuteLayer_to_Algorithm(cv::dnn::PermuteLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PermuteLayer_to_Layer(cv::dnn::PermuteLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_PermuteLayer_delete(cv::dnn::PermuteLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:465
	Result<cv::Ptr<cv::dnn::PermuteLayer>*> cv_dnn_PermuteLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PermuteLayer> ret = cv::dnn::PermuteLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PermuteLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PermuteLayer>*>))
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:290
	int cv_dnn_PoolingLayer_getPropType_const(const cv::dnn::PoolingLayer* instance) {
		int ret = instance->type;
		return (int)ret;
	}
	
	// type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:290
	void cv_dnn_PoolingLayer_setPropType_int(cv::dnn::PoolingLayer* instance, int val) {
		instance->type = val;
	}
	
	// kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:291
	std::vector<size_t>* cv_dnn_PoolingLayer_getPropKernel_size_const(const cv::dnn::PoolingLayer* instance) {
		std::vector<size_t> ret = instance->kernel_size;
		return new std::vector<size_t>(ret);
	}
	
	// kernel_size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:291
	void cv_dnn_PoolingLayer_setPropKernel_size_vector_size_t_(cv::dnn::PoolingLayer* instance, std::vector<size_t>* val) {
		instance->kernel_size = *val;
	}
	
	// strides /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:291
	std::vector<size_t>* cv_dnn_PoolingLayer_getPropStrides_const(const cv::dnn::PoolingLayer* instance) {
		std::vector<size_t> ret = instance->strides;
		return new std::vector<size_t>(ret);
	}
	
	// strides /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:291
	void cv_dnn_PoolingLayer_setPropStrides_vector_size_t_(cv::dnn::PoolingLayer* instance, std::vector<size_t>* val) {
		instance->strides = *val;
	}
	
	// pads_begin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:292
	std::vector<size_t>* cv_dnn_PoolingLayer_getPropPads_begin_const(const cv::dnn::PoolingLayer* instance) {
		std::vector<size_t> ret = instance->pads_begin;
		return new std::vector<size_t>(ret);
	}
	
	// pads_begin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:292
	void cv_dnn_PoolingLayer_setPropPads_begin_vector_size_t_(cv::dnn::PoolingLayer* instance, std::vector<size_t>* val) {
		instance->pads_begin = *val;
	}
	
	// pads_end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:292
	std::vector<size_t>* cv_dnn_PoolingLayer_getPropPads_end_const(const cv::dnn::PoolingLayer* instance) {
		std::vector<size_t> ret = instance->pads_end;
		return new std::vector<size_t>(ret);
	}
	
	// pads_end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:292
	void cv_dnn_PoolingLayer_setPropPads_end_vector_size_t_(cv::dnn::PoolingLayer* instance, std::vector<size_t>* val) {
		instance->pads_end = *val;
	}
	
	// globalPooling /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:293
	bool cv_dnn_PoolingLayer_getPropGlobalPooling_const(const cv::dnn::PoolingLayer* instance) {
		bool ret = instance->globalPooling;
		return (bool)ret;
	}
	
	// globalPooling /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:293
	void cv_dnn_PoolingLayer_setPropGlobalPooling_bool(cv::dnn::PoolingLayer* instance, bool val) {
		instance->globalPooling = val;
	}
	
	// isGlobalPooling /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:294
	std::vector<bool>* cv_dnn_PoolingLayer_getPropIsGlobalPooling_const(const cv::dnn::PoolingLayer* instance) {
		std::vector<bool> ret = instance->isGlobalPooling;
		return new std::vector<bool>(ret);
	}
	
	// isGlobalPooling /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:294
	void cv_dnn_PoolingLayer_setPropIsGlobalPooling_vector_bool_(cv::dnn::PoolingLayer* instance, std::vector<bool>* val) {
		instance->isGlobalPooling = *val;
	}
	
	// computeMaxIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:295
	bool cv_dnn_PoolingLayer_getPropComputeMaxIdx_const(const cv::dnn::PoolingLayer* instance) {
		bool ret = instance->computeMaxIdx;
		return (bool)ret;
	}
	
	// computeMaxIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:295
	void cv_dnn_PoolingLayer_setPropComputeMaxIdx_bool(cv::dnn::PoolingLayer* instance, bool val) {
		instance->computeMaxIdx = val;
	}
	
	// padMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:296
	void* cv_dnn_PoolingLayer_getPropPadMode_const(const cv::dnn::PoolingLayer* instance) {
		cv::String ret = instance->padMode;
		return ocvrs_create_string(ret.c_str());
	}
	
	// padMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:296
	void cv_dnn_PoolingLayer_setPropPadMode_String(cv::dnn::PoolingLayer* instance, char* val) {
		instance->padMode = std::string(val);
	}
	
	// ceilMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:297
	bool cv_dnn_PoolingLayer_getPropCeilMode_const(const cv::dnn::PoolingLayer* instance) {
		bool ret = instance->ceilMode;
		return (bool)ret;
	}
	
	// ceilMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:297
	void cv_dnn_PoolingLayer_setPropCeilMode_bool(cv::dnn::PoolingLayer* instance, bool val) {
		instance->ceilMode = val;
	}
	
	// avePoolPaddedArea /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:301
	bool cv_dnn_PoolingLayer_getPropAvePoolPaddedArea_const(const cv::dnn::PoolingLayer* instance) {
		bool ret = instance->avePoolPaddedArea;
		return (bool)ret;
	}
	
	// avePoolPaddedArea /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:301
	void cv_dnn_PoolingLayer_setPropAvePoolPaddedArea_bool(cv::dnn::PoolingLayer* instance, bool val) {
		instance->avePoolPaddedArea = val;
	}
	
	// pooledSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:303
	cv::Size cv_dnn_PoolingLayer_getPropPooledSize_const(const cv::dnn::PoolingLayer* instance) {
		cv::Size ret = instance->pooledSize;
		return (cv::Size)ret;
	}
	
	// pooledSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:303
	void cv_dnn_PoolingLayer_setPropPooledSize_Size(cv::dnn::PoolingLayer* instance, cv::Size* val) {
		instance->pooledSize = *val;
	}
	
	// spatialScale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:304
	float cv_dnn_PoolingLayer_getPropSpatialScale_const(const cv::dnn::PoolingLayer* instance) {
		float ret = instance->spatialScale;
		return (float)ret;
	}
	
	// spatialScale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:304
	void cv_dnn_PoolingLayer_setPropSpatialScale_float(cv::dnn::PoolingLayer* instance, float val) {
		instance->spatialScale = val;
	}
	
	// psRoiOutChannels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:306
	int cv_dnn_PoolingLayer_getPropPsRoiOutChannels_const(const cv::dnn::PoolingLayer* instance) {
		int ret = instance->psRoiOutChannels;
		return (int)ret;
	}
	
	// psRoiOutChannels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:306
	void cv_dnn_PoolingLayer_setPropPsRoiOutChannels_int(cv::dnn::PoolingLayer* instance, int val) {
		instance->psRoiOutChannels = val;
	}
	
	cv::Algorithm* cv_PoolingLayer_to_Algorithm(cv::dnn::PoolingLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PoolingLayer_to_Layer(cv::dnn::PoolingLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_PoolingLayer_delete(cv::dnn::PoolingLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:308
	Result<cv::Ptr<cv::dnn::PoolingLayer>*> cv_dnn_PoolingLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PoolingLayer> ret = cv::dnn::PoolingLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PoolingLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PoolingLayer>*>))
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:314
	int cv_dnn_PoolingLayerInt8_getPropInput_zp_const(const cv::dnn::PoolingLayerInt8* instance) {
		int ret = instance->input_zp;
		return (int)ret;
	}
	
	// input_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:314
	void cv_dnn_PoolingLayerInt8_setPropInput_zp_int(cv::dnn::PoolingLayerInt8* instance, int val) {
		instance->input_zp = val;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:314
	int cv_dnn_PoolingLayerInt8_getPropOutput_zp_const(const cv::dnn::PoolingLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:314
	void cv_dnn_PoolingLayerInt8_setPropOutput_zp_int(cv::dnn::PoolingLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	cv::Algorithm* cv_PoolingLayerInt8_to_Algorithm(cv::dnn::PoolingLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PoolingLayerInt8_to_Layer(cv::dnn::PoolingLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	cv::dnn::PoolingLayer* cv_PoolingLayerInt8_to_PoolingLayer(cv::dnn::PoolingLayerInt8* instance) {
		return dynamic_cast<cv::dnn::PoolingLayer*>(instance);
	}
	
	void cv_PoolingLayerInt8_delete(cv::dnn::PoolingLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:315
	Result<cv::Ptr<cv::dnn::PoolingLayerInt8>*> cv_dnn_PoolingLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PoolingLayerInt8> ret = cv::dnn::PoolingLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PoolingLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PoolingLayerInt8>*>))
	}
	
	// power /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	float cv_dnn_PowerLayer_getPropPower_const(const cv::dnn::PowerLayer* instance) {
		float ret = instance->power;
		return (float)ret;
	}
	
	// power /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	void cv_dnn_PowerLayer_setPropPower_float(cv::dnn::PowerLayer* instance, float val) {
		instance->power = val;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	float cv_dnn_PowerLayer_getPropScale_const(const cv::dnn::PowerLayer* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	void cv_dnn_PowerLayer_setPropScale_float(cv::dnn::PowerLayer* instance, float val) {
		instance->scale = val;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	float cv_dnn_PowerLayer_getPropShift_const(const cv::dnn::PowerLayer* instance) {
		float ret = instance->shift;
		return (float)ret;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:590
	void cv_dnn_PowerLayer_setPropShift_float(cv::dnn::PowerLayer* instance, float val) {
		instance->shift = val;
	}
	
	cv::dnn::ActivationLayer* cv_PowerLayer_to_ActivationLayer(cv::dnn::PowerLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_PowerLayer_to_Algorithm(cv::dnn::PowerLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PowerLayer_to_Layer(cv::dnn::PowerLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_PowerLayer_delete(cv::dnn::PowerLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:592
	Result<cv::Ptr<cv::dnn::PowerLayer>*> cv_dnn_PowerLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PowerLayer> ret = cv::dnn::PowerLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PowerLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PowerLayer>*>))
	}
	
	cv::Algorithm* cv_PriorBoxLayer_to_Algorithm(cv::dnn::PriorBoxLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_PriorBoxLayer_to_Layer(cv::dnn::PriorBoxLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_PriorBoxLayer_delete(cv::dnn::PriorBoxLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:719
	Result<cv::Ptr<cv::dnn::PriorBoxLayer>*> cv_dnn_PriorBoxLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::PriorBoxLayer> ret = cv::dnn::PriorBoxLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::PriorBoxLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::PriorBoxLayer>*>))
	}
	
	cv::Algorithm* cv_ProposalLayer_to_Algorithm(cv::dnn::ProposalLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ProposalLayer_to_Layer(cv::dnn::ProposalLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ProposalLayer_delete(cv::dnn::ProposalLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:809
	Result<cv::Ptr<cv::dnn::ProposalLayer>*> cv_dnn_ProposalLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ProposalLayer> ret = cv::dnn::ProposalLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ProposalLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ProposalLayer>*>))
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:377
	float cv_dnn_QuantizeLayer_getPropScale_const(const cv::dnn::QuantizeLayer* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:377
	void cv_dnn_QuantizeLayer_setPropScale_float(cv::dnn::QuantizeLayer* instance, float val) {
		instance->scale = val;
	}
	
	// zeropoint /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:378
	int cv_dnn_QuantizeLayer_getPropZeropoint_const(const cv::dnn::QuantizeLayer* instance) {
		int ret = instance->zeropoint;
		return (int)ret;
	}
	
	// zeropoint /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:378
	void cv_dnn_QuantizeLayer_setPropZeropoint_int(cv::dnn::QuantizeLayer* instance, int val) {
		instance->zeropoint = val;
	}
	
	cv::Algorithm* cv_QuantizeLayer_to_Algorithm(cv::dnn::QuantizeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_QuantizeLayer_to_Layer(cv::dnn::QuantizeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_QuantizeLayer_delete(cv::dnn::QuantizeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:379
	Result<cv::Ptr<cv::dnn::QuantizeLayer>*> cv_dnn_QuantizeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::QuantizeLayer> ret = cv::dnn::QuantizeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::QuantizeLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::QuantizeLayer>*>))
	}
	
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:219
	Result<cv::Ptr<cv::dnn::RNNLayer>*> cv_dnn_RNNLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::RNNLayer> ret = cv::dnn::RNNLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::RNNLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::RNNLayer>*>))
	}
	
	// setWeights(const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:235
	Result_void cv_dnn_RNNLayer_setWeights_const_MatR_const_MatR_const_MatR_const_MatR_const_MatR(cv::dnn::RNNLayer* instance, const cv::Mat* Wxh, const cv::Mat* bh, const cv::Mat* Whh, const cv::Mat* Who, const cv::Mat* bo) {
		try {
			instance->setWeights(*Wxh, *bh, *Whh, *Who, *bo);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setProduceHiddenOutput(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:240
	Result_void cv_dnn_RNNLayer_setProduceHiddenOutput_bool(cv::dnn::RNNLayer* instance, bool produce) {
		try {
			instance->setProduceHiddenOutput(produce);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:534
	float cv_dnn_ReLU6Layer_getPropMinValue_const(const cv::dnn::ReLU6Layer* instance) {
		float ret = instance->minValue;
		return (float)ret;
	}
	
	// minValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:534
	void cv_dnn_ReLU6Layer_setPropMinValue_float(cv::dnn::ReLU6Layer* instance, float val) {
		instance->minValue = val;
	}
	
	// maxValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:534
	float cv_dnn_ReLU6Layer_getPropMaxValue_const(const cv::dnn::ReLU6Layer* instance) {
		float ret = instance->maxValue;
		return (float)ret;
	}
	
	// maxValue /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:534
	void cv_dnn_ReLU6Layer_setPropMaxValue_float(cv::dnn::ReLU6Layer* instance, float val) {
		instance->maxValue = val;
	}
	
	cv::dnn::ActivationLayer* cv_ReLU6Layer_to_ActivationLayer(cv::dnn::ReLU6Layer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ReLU6Layer_to_Algorithm(cv::dnn::ReLU6Layer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ReLU6Layer_to_Layer(cv::dnn::ReLU6Layer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ReLU6Layer_delete(cv::dnn::ReLU6Layer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:536
	Result<cv::Ptr<cv::dnn::ReLU6Layer>*> cv_dnn_ReLU6Layer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ReLU6Layer> ret = cv::dnn::ReLU6Layer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ReLU6Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ReLU6Layer>*>))
	}
	
	// negativeSlope /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:526
	float cv_dnn_ReLULayer_getPropNegativeSlope_const(const cv::dnn::ReLULayer* instance) {
		float ret = instance->negativeSlope;
		return (float)ret;
	}
	
	// negativeSlope /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:526
	void cv_dnn_ReLULayer_setPropNegativeSlope_float(cv::dnn::ReLULayer* instance, float val) {
		instance->negativeSlope = val;
	}
	
	cv::dnn::ActivationLayer* cv_ReLULayer_to_ActivationLayer(cv::dnn::ReLULayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_ReLULayer_to_Algorithm(cv::dnn::ReLULayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ReLULayer_to_Layer(cv::dnn::ReLULayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ReLULayer_delete(cv::dnn::ReLULayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:528
	Result<cv::Ptr<cv::dnn::ReLULayer>*> cv_dnn_ReLULayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ReLULayer> ret = cv::dnn::ReLULayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ReLULayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ReLULayer>*>))
	}
	
	// nmsThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:731
	float cv_dnn_RegionLayer_getPropNmsThreshold_const(const cv::dnn::RegionLayer* instance) {
		float ret = instance->nmsThreshold;
		return (float)ret;
	}
	
	// nmsThreshold /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:731
	void cv_dnn_RegionLayer_setPropNmsThreshold_float(cv::dnn::RegionLayer* instance, float val) {
		instance->nmsThreshold = val;
	}
	
	cv::Algorithm* cv_RegionLayer_to_Algorithm(cv::dnn::RegionLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_RegionLayer_to_Layer(cv::dnn::RegionLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_RegionLayer_delete(cv::dnn::RegionLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:733
	Result<cv::Ptr<cv::dnn::RegionLayer>*> cv_dnn_RegionLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::RegionLayer> ret = cv::dnn::RegionLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::RegionLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::RegionLayer>*>))
	}
	
	cv::Algorithm* cv_ReorgLayer_to_Algorithm(cv::dnn::ReorgLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ReorgLayer_to_Layer(cv::dnn::ReorgLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ReorgLayer_delete(cv::dnn::ReorgLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:725
	Result<cv::Ptr<cv::dnn::ReorgLayer>*> cv_dnn_ReorgLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ReorgLayer> ret = cv::dnn::ReorgLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ReorgLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ReorgLayer>*>))
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:393
	float cv_dnn_RequantizeLayer_getPropScale_const(const cv::dnn::RequantizeLayer* instance) {
		float ret = instance->scale;
		return (float)ret;
	}
	
	// scale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:393
	void cv_dnn_RequantizeLayer_setPropScale_float(cv::dnn::RequantizeLayer* instance, float val) {
		instance->scale = val;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:393
	float cv_dnn_RequantizeLayer_getPropShift_const(const cv::dnn::RequantizeLayer* instance) {
		float ret = instance->shift;
		return (float)ret;
	}
	
	// shift /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:393
	void cv_dnn_RequantizeLayer_setPropShift_float(cv::dnn::RequantizeLayer* instance, float val) {
		instance->shift = val;
	}
	
	cv::Algorithm* cv_RequantizeLayer_to_Algorithm(cv::dnn::RequantizeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_RequantizeLayer_to_Layer(cv::dnn::RequantizeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_RequantizeLayer_delete(cv::dnn::RequantizeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:394
	Result<cv::Ptr<cv::dnn::RequantizeLayer>*> cv_dnn_RequantizeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::RequantizeLayer> ret = cv::dnn::RequantizeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::RequantizeLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::RequantizeLayer>*>))
	}
	
	// newShapeDesc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:362
	cv::dnn::MatShape* cv_dnn_ReshapeLayer_getPropNewShapeDesc_const(const cv::dnn::ReshapeLayer* instance) {
		cv::dnn::MatShape ret = instance->newShapeDesc;
		return new cv::dnn::MatShape(ret);
	}
	
	// newShapeDesc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:362
	void cv_dnn_ReshapeLayer_setPropNewShapeDesc_MatShape(cv::dnn::ReshapeLayer* instance, cv::dnn::MatShape* val) {
		instance->newShapeDesc = *val;
	}
	
	// newShapeRange /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:363
	cv::Range* cv_dnn_ReshapeLayer_getPropNewShapeRange_const(const cv::dnn::ReshapeLayer* instance) {
		cv::Range ret = instance->newShapeRange;
		return new cv::Range(ret);
	}
	
	// newShapeRange /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:363
	void cv_dnn_ReshapeLayer_setPropNewShapeRange_Range(cv::dnn::ReshapeLayer* instance, cv::Range* val) {
		instance->newShapeRange = *val;
	}
	
	cv::Algorithm* cv_ReshapeLayer_to_Algorithm(cv::dnn::ReshapeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ReshapeLayer_to_Layer(cv::dnn::ReshapeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ReshapeLayer_delete(cv::dnn::ReshapeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:365
	Result<cv::Ptr<cv::dnn::ReshapeLayer>*> cv_dnn_ReshapeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ReshapeLayer> ret = cv::dnn::ReshapeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ReshapeLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ReshapeLayer>*>))
	}
	
	cv::Algorithm* cv_ResizeLayer_to_Algorithm(cv::dnn::ResizeLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ResizeLayer_to_Layer(cv::dnn::ResizeLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ResizeLayer_delete(cv::dnn::ResizeLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:792
	Result<cv::Ptr<cv::dnn::ResizeLayer>*> cv_dnn_ResizeLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ResizeLayer> ret = cv::dnn::ResizeLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ResizeLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ResizeLayer>*>))
	}
	
	// hasBias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:666
	bool cv_dnn_ScaleLayer_getPropHasBias_const(const cv::dnn::ScaleLayer* instance) {
		bool ret = instance->hasBias;
		return (bool)ret;
	}
	
	// hasBias /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:666
	void cv_dnn_ScaleLayer_setPropHasBias_bool(cv::dnn::ScaleLayer* instance, bool val) {
		instance->hasBias = val;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:667
	int cv_dnn_ScaleLayer_getPropAxis_const(const cv::dnn::ScaleLayer* instance) {
		int ret = instance->axis;
		return (int)ret;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:667
	void cv_dnn_ScaleLayer_setPropAxis_int(cv::dnn::ScaleLayer* instance, int val) {
		instance->axis = val;
	}
	
	cv::Algorithm* cv_ScaleLayer_to_Algorithm(cv::dnn::ScaleLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ScaleLayer_to_Layer(cv::dnn::ScaleLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ScaleLayer_delete(cv::dnn::ScaleLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:669
	Result<cv::Ptr<cv::dnn::ScaleLayer>*> cv_dnn_ScaleLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ScaleLayer> ret = cv::dnn::ScaleLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ScaleLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ScaleLayer>*>))
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:675
	float cv_dnn_ScaleLayerInt8_getPropOutput_sc_const(const cv::dnn::ScaleLayerInt8* instance) {
		float ret = instance->output_sc;
		return (float)ret;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:675
	void cv_dnn_ScaleLayerInt8_setPropOutput_sc_float(cv::dnn::ScaleLayerInt8* instance, float val) {
		instance->output_sc = val;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:676
	int cv_dnn_ScaleLayerInt8_getPropOutput_zp_const(const cv::dnn::ScaleLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:676
	void cv_dnn_ScaleLayerInt8_setPropOutput_zp_int(cv::dnn::ScaleLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	cv::Algorithm* cv_ScaleLayerInt8_to_Algorithm(cv::dnn::ScaleLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ScaleLayerInt8_to_Layer(cv::dnn::ScaleLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	cv::dnn::ScaleLayer* cv_ScaleLayerInt8_to_ScaleLayer(cv::dnn::ScaleLayerInt8* instance) {
		return dynamic_cast<cv::dnn::ScaleLayer*>(instance);
	}
	
	void cv_ScaleLayerInt8_delete(cv::dnn::ScaleLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:677
	Result<cv::Ptr<cv::dnn::ScaleLayerInt8>*> cv_dnn_ScaleLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::ScaleLayerInt8> ret = cv::dnn::ScaleLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::ScaleLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::ScaleLayerInt8>*>))
	}
	
	cv::dnn::Model* cv_SegmentationModel_to_Model(cv::dnn::SegmentationModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_SegmentationModel_delete(cv::dnn::SegmentationModel* instance) {
		delete instance;
	}
	// SegmentationModel(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1353
	Result<cv::dnn::SegmentationModel*> cv_dnn_SegmentationModel_SegmentationModel_const_StringR_const_StringR(const char* model, const char* config) {
		try {
			cv::dnn::SegmentationModel* ret = new cv::dnn::SegmentationModel(std::string(model), std::string(config));
			return Ok<cv::dnn::SegmentationModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::SegmentationModel*>))
	}
	
	// SegmentationModel(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1359
	Result<cv::dnn::SegmentationModel*> cv_dnn_SegmentationModel_SegmentationModel_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::SegmentationModel* ret = new cv::dnn::SegmentationModel(*network);
			return Ok<cv::dnn::SegmentationModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::SegmentationModel*>))
	}
	
	// segment(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1365
	Result_void cv_dnn_SegmentationModel_segment_const__InputArrayR_const__OutputArrayR(cv::dnn::SegmentationModel* instance, const cv::_InputArray* frame, const cv::_OutputArray* mask) {
		try {
			instance->segment(*frame, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Algorithm* cv_ShiftLayer_to_Algorithm(cv::dnn::ShiftLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ShiftLayer_to_Layer(cv::dnn::ShiftLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ShiftLayer_delete(cv::dnn::ShiftLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:683
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_ShiftLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::ShiftLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::Algorithm* cv_ShiftLayerInt8_to_Algorithm(cv::dnn::ShiftLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ShiftLayerInt8_to_Layer(cv::dnn::ShiftLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ShiftLayerInt8_delete(cv::dnn::ShiftLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:689
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_ShiftLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::ShiftLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	// group /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:482
	int cv_dnn_ShuffleChannelLayer_getPropGroup_const(const cv::dnn::ShuffleChannelLayer* instance) {
		int ret = instance->group;
		return (int)ret;
	}
	
	// group /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:482
	void cv_dnn_ShuffleChannelLayer_setPropGroup_int(cv::dnn::ShuffleChannelLayer* instance, int val) {
		instance->group = val;
	}
	
	cv::Algorithm* cv_ShuffleChannelLayer_to_Algorithm(cv::dnn::ShuffleChannelLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_ShuffleChannelLayer_to_Layer(cv::dnn::ShuffleChannelLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_ShuffleChannelLayer_delete(cv::dnn::ShuffleChannelLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:480
	Result<cv::Ptr<cv::dnn::Layer>*> cv_dnn_ShuffleChannelLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::Layer> ret = cv::dnn::ShuffleChannelLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::Layer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::Layer>*>))
	}
	
	cv::dnn::ActivationLayer* cv_SigmoidLayer_to_ActivationLayer(cv::dnn::SigmoidLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_SigmoidLayer_to_Algorithm(cv::dnn::SigmoidLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SigmoidLayer_to_Layer(cv::dnn::SigmoidLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_SigmoidLayer_delete(cv::dnn::SigmoidLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:572
	Result<cv::Ptr<cv::dnn::SigmoidLayer>*> cv_dnn_SigmoidLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SigmoidLayer> ret = cv::dnn::SigmoidLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SigmoidLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SigmoidLayer>*>))
	}
	
	// sliceRanges /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:454
	std::vector<std::vector<cv::Range>>* cv_dnn_SliceLayer_getPropSliceRanges_const(const cv::dnn::SliceLayer* instance) {
		std::vector<std::vector<cv::Range>> ret = instance->sliceRanges;
		return new std::vector<std::vector<cv::Range>>(ret);
	}
	
	// sliceRanges /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:454
	void cv_dnn_SliceLayer_setPropSliceRanges_vector_vector_Range__(cv::dnn::SliceLayer* instance, std::vector<std::vector<cv::Range>>* val) {
		instance->sliceRanges = *val;
	}
	
	// sliceSteps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:455
	std::vector<std::vector<int>>* cv_dnn_SliceLayer_getPropSliceSteps_const(const cv::dnn::SliceLayer* instance) {
		std::vector<std::vector<int>> ret = instance->sliceSteps;
		return new std::vector<std::vector<int>>(ret);
	}
	
	// sliceSteps /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:455
	void cv_dnn_SliceLayer_setPropSliceSteps_vector_vector_int__(cv::dnn::SliceLayer* instance, std::vector<std::vector<int>>* val) {
		instance->sliceSteps = *val;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:456
	int cv_dnn_SliceLayer_getPropAxis_const(const cv::dnn::SliceLayer* instance) {
		int ret = instance->axis;
		return (int)ret;
	}
	
	// axis /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:456
	void cv_dnn_SliceLayer_setPropAxis_int(cv::dnn::SliceLayer* instance, int val) {
		instance->axis = val;
	}
	
	// num_split /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:457
	int cv_dnn_SliceLayer_getPropNum_split_const(const cv::dnn::SliceLayer* instance) {
		int ret = instance->num_split;
		return (int)ret;
	}
	
	// num_split /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:457
	void cv_dnn_SliceLayer_setPropNum_split_int(cv::dnn::SliceLayer* instance, int val) {
		instance->num_split = val;
	}
	
	cv::Algorithm* cv_SliceLayer_to_Algorithm(cv::dnn::SliceLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SliceLayer_to_Layer(cv::dnn::SliceLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_SliceLayer_delete(cv::dnn::SliceLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:459
	Result<cv::Ptr<cv::dnn::SliceLayer>*> cv_dnn_SliceLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SliceLayer> ret = cv::dnn::SliceLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SliceLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SliceLayer>*>))
	}
	
	// logSoftMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:321
	bool cv_dnn_SoftmaxLayer_getPropLogSoftMax_const(const cv::dnn::SoftmaxLayer* instance) {
		bool ret = instance->logSoftMax;
		return (bool)ret;
	}
	
	// logSoftMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:321
	void cv_dnn_SoftmaxLayer_setPropLogSoftMax_bool(cv::dnn::SoftmaxLayer* instance, bool val) {
		instance->logSoftMax = val;
	}
	
	cv::Algorithm* cv_SoftmaxLayer_to_Algorithm(cv::dnn::SoftmaxLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SoftmaxLayer_to_Layer(cv::dnn::SoftmaxLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_SoftmaxLayer_delete(cv::dnn::SoftmaxLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:323
	Result<cv::Ptr<cv::dnn::SoftmaxLayer>*> cv_dnn_SoftmaxLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SoftmaxLayer> ret = cv::dnn::SoftmaxLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SoftmaxLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SoftmaxLayer>*>))
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:329
	float cv_dnn_SoftmaxLayerInt8_getPropOutput_sc_const(const cv::dnn::SoftmaxLayerInt8* instance) {
		float ret = instance->output_sc;
		return (float)ret;
	}
	
	// output_sc /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:329
	void cv_dnn_SoftmaxLayerInt8_setPropOutput_sc_float(cv::dnn::SoftmaxLayerInt8* instance, float val) {
		instance->output_sc = val;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:330
	int cv_dnn_SoftmaxLayerInt8_getPropOutput_zp_const(const cv::dnn::SoftmaxLayerInt8* instance) {
		int ret = instance->output_zp;
		return (int)ret;
	}
	
	// output_zp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:330
	void cv_dnn_SoftmaxLayerInt8_setPropOutput_zp_int(cv::dnn::SoftmaxLayerInt8* instance, int val) {
		instance->output_zp = val;
	}
	
	cv::Algorithm* cv_SoftmaxLayerInt8_to_Algorithm(cv::dnn::SoftmaxLayerInt8* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SoftmaxLayerInt8_to_Layer(cv::dnn::SoftmaxLayerInt8* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	cv::dnn::SoftmaxLayer* cv_SoftmaxLayerInt8_to_SoftmaxLayer(cv::dnn::SoftmaxLayerInt8* instance) {
		return dynamic_cast<cv::dnn::SoftmaxLayer*>(instance);
	}
	
	void cv_SoftmaxLayerInt8_delete(cv::dnn::SoftmaxLayerInt8* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:331
	Result<cv::Ptr<cv::dnn::SoftmaxLayerInt8>*> cv_dnn_SoftmaxLayerInt8_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SoftmaxLayerInt8> ret = cv::dnn::SoftmaxLayerInt8::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SoftmaxLayerInt8>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SoftmaxLayerInt8>*>))
	}
	
	// outputsCount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:416
	int cv_dnn_SplitLayer_getPropOutputsCount_const(const cv::dnn::SplitLayer* instance) {
		int ret = instance->outputsCount;
		return (int)ret;
	}
	
	// outputsCount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:416
	void cv_dnn_SplitLayer_setPropOutputsCount_int(cv::dnn::SplitLayer* instance, int val) {
		instance->outputsCount = val;
	}
	
	cv::Algorithm* cv_SplitLayer_to_Algorithm(cv::dnn::SplitLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SplitLayer_to_Layer(cv::dnn::SplitLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_SplitLayer_delete(cv::dnn::SplitLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:418
	Result<cv::Ptr<cv::dnn::SplitLayer>*> cv_dnn_SplitLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SplitLayer> ret = cv::dnn::SplitLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SplitLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SplitLayer>*>))
	}
	
	cv::dnn::ActivationLayer* cv_SwishLayer_to_ActivationLayer(cv::dnn::SwishLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_SwishLayer_to_Algorithm(cv::dnn::SwishLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_SwishLayer_to_Layer(cv::dnn::SwishLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_SwishLayer_delete(cv::dnn::SwishLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:560
	Result<cv::Ptr<cv::dnn::SwishLayer>*> cv_dnn_SwishLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::SwishLayer> ret = cv::dnn::SwishLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::SwishLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::SwishLayer>*>))
	}
	
	cv::dnn::ActivationLayer* cv_TanHLayer_to_ActivationLayer(cv::dnn::TanHLayer* instance) {
		return dynamic_cast<cv::dnn::ActivationLayer*>(instance);
	}
	
	cv::Algorithm* cv_TanHLayer_to_Algorithm(cv::dnn::TanHLayer* instance) {
		return dynamic_cast<cv::Algorithm*>(instance);
	}
	
	cv::dnn::Layer* cv_TanHLayer_to_Layer(cv::dnn::TanHLayer* instance) {
		return dynamic_cast<cv::dnn::Layer*>(instance);
	}
	
	void cv_TanHLayer_delete(cv::dnn::TanHLayer* instance) {
		delete instance;
	}
	// create(const cv::dnn::LayerParams &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/all_layers.hpp:554
	Result<cv::Ptr<cv::dnn::TanHLayer>*> cv_dnn_TanHLayer_create_const_LayerParamsR(const cv::dnn::LayerParams* params) {
		try {
			cv::Ptr<cv::dnn::TanHLayer> ret = cv::dnn::TanHLayer::create(*params);
			return Ok(new cv::Ptr<cv::dnn::TanHLayer>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::dnn::TanHLayer>*>))
	}
	
	cv::dnn::Model* cv_TextDetectionModel_to_Model(cv::dnn::TextDetectionModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_TextDetectionModel_delete(cv::dnn::TextDetectionModel* instance) {
		delete instance;
	}
	// detect(cv::InputArray, std::vector<std::vector<Point>> &, std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1540
	Result_void cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vector_vector_Point__R_vector_float_R(const cv::dnn::TextDetectionModel* instance, const cv::_InputArray* frame, std::vector<std::vector<cv::Point>>* detections, std::vector<float>* confidences) {
		try {
			instance->detect(*frame, *detections, *confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, std::vector<std::vector<Point>> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1548
	Result_void cv_dnn_TextDetectionModel_detect_const_const__InputArrayR_vector_vector_Point__R(const cv::dnn::TextDetectionModel* instance, const cv::_InputArray* frame, std::vector<std::vector<cv::Point>>* detections) {
		try {
			instance->detect(*frame, *detections);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectTextRectangles(cv::InputArray, std::vector<cv::RotatedRect> &, std::vector<float> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1566
	Result_void cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vector_RotatedRect_R_vector_float_R(const cv::dnn::TextDetectionModel* instance, const cv::_InputArray* frame, std::vector<cv::RotatedRect>* detections, std::vector<float>* confidences) {
		try {
			instance->detectTextRectangles(*frame, *detections, *confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectTextRectangles(cv::InputArray, std::vector<cv::RotatedRect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1574
	Result_void cv_dnn_TextDetectionModel_detectTextRectangles_const_const__InputArrayR_vector_RotatedRect_R(const cv::dnn::TextDetectionModel* instance, const cv::_InputArray* frame, std::vector<cv::RotatedRect>* detections) {
		try {
			instance->detectTextRectangles(*frame, *detections);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::dnn::Model* cv_TextDetectionModel_DB_to_Model(cv::dnn::TextDetectionModel_DB* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	cv::dnn::TextDetectionModel* cv_TextDetectionModel_DB_to_TextDetectionModel(cv::dnn::TextDetectionModel_DB* instance) {
		return dynamic_cast<cv::dnn::TextDetectionModel*>(instance);
	}
	
	void cv_TextDetectionModel_DB_delete(cv::dnn::TextDetectionModel_DB* instance) {
		delete instance;
	}
	// TextDetectionModel_DB() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1651
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB() {
		try {
			cv::dnn::TextDetectionModel_DB* ret = new cv::dnn::TextDetectionModel_DB();
			return Ok<cv::dnn::TextDetectionModel_DB*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// TextDetectionModel_DB(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1657
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::TextDetectionModel_DB* ret = new cv::dnn::TextDetectionModel_DB(*network);
			return Ok<cv::dnn::TextDetectionModel_DB*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// TextDetectionModel_DB(const std::string &, const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1666
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_TextDetectionModel_DB_const_stringR_const_stringR(const char* model, const char* config) {
		try {
			cv::dnn::TextDetectionModel_DB* ret = new cv::dnn::TextDetectionModel_DB(std::string(model), std::string(config));
			return Ok<cv::dnn::TextDetectionModel_DB*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// setBinaryThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1669
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_setBinaryThreshold_float(cv::dnn::TextDetectionModel_DB* instance, float binaryThreshold) {
		try {
			cv::dnn::TextDetectionModel_DB ret = instance->setBinaryThreshold(binaryThreshold);
			return Ok(new cv::dnn::TextDetectionModel_DB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// getBinaryThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1670
	Result<float> cv_dnn_TextDetectionModel_DB_getBinaryThreshold_const(const cv::dnn::TextDetectionModel_DB* instance) {
		try {
			float ret = instance->getBinaryThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setPolygonThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1672
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_setPolygonThreshold_float(cv::dnn::TextDetectionModel_DB* instance, float polygonThreshold) {
		try {
			cv::dnn::TextDetectionModel_DB ret = instance->setPolygonThreshold(polygonThreshold);
			return Ok(new cv::dnn::TextDetectionModel_DB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// getPolygonThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1673
	Result<float> cv_dnn_TextDetectionModel_DB_getPolygonThreshold_const(const cv::dnn::TextDetectionModel_DB* instance) {
		try {
			float ret = instance->getPolygonThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setUnclipRatio(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1675
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_setUnclipRatio_double(cv::dnn::TextDetectionModel_DB* instance, double unclipRatio) {
		try {
			cv::dnn::TextDetectionModel_DB ret = instance->setUnclipRatio(unclipRatio);
			return Ok(new cv::dnn::TextDetectionModel_DB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// getUnclipRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1676
	Result<double> cv_dnn_TextDetectionModel_DB_getUnclipRatio_const(const cv::dnn::TextDetectionModel_DB* instance) {
		try {
			double ret = instance->getUnclipRatio();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxCandidates(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1678
	Result<cv::dnn::TextDetectionModel_DB*> cv_dnn_TextDetectionModel_DB_setMaxCandidates_int(cv::dnn::TextDetectionModel_DB* instance, int maxCandidates) {
		try {
			cv::dnn::TextDetectionModel_DB ret = instance->setMaxCandidates(maxCandidates);
			return Ok(new cv::dnn::TextDetectionModel_DB(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_DB*>))
	}
	
	// getMaxCandidates() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1679
	Result<int> cv_dnn_TextDetectionModel_DB_getMaxCandidates_const(const cv::dnn::TextDetectionModel_DB* instance) {
		try {
			int ret = instance->getMaxCandidates();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	cv::dnn::Model* cv_TextDetectionModel_EAST_to_Model(cv::dnn::TextDetectionModel_EAST* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	cv::dnn::TextDetectionModel* cv_TextDetectionModel_EAST_to_TextDetectionModel(cv::dnn::TextDetectionModel_EAST* instance) {
		return dynamic_cast<cv::dnn::TextDetectionModel*>(instance);
	}
	
	void cv_TextDetectionModel_EAST_delete(cv::dnn::TextDetectionModel_EAST* instance) {
		delete instance;
	}
	// TextDetectionModel_EAST() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1590
	Result<cv::dnn::TextDetectionModel_EAST*> cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST() {
		try {
			cv::dnn::TextDetectionModel_EAST* ret = new cv::dnn::TextDetectionModel_EAST();
			return Ok<cv::dnn::TextDetectionModel_EAST*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_EAST*>))
	}
	
	// TextDetectionModel_EAST(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1596
	Result<cv::dnn::TextDetectionModel_EAST*> cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::TextDetectionModel_EAST* ret = new cv::dnn::TextDetectionModel_EAST(*network);
			return Ok<cv::dnn::TextDetectionModel_EAST*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_EAST*>))
	}
	
	// TextDetectionModel_EAST(const std::string &, const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1605
	Result<cv::dnn::TextDetectionModel_EAST*> cv_dnn_TextDetectionModel_EAST_TextDetectionModel_EAST_const_stringR_const_stringR(const char* model, const char* config) {
		try {
			cv::dnn::TextDetectionModel_EAST* ret = new cv::dnn::TextDetectionModel_EAST(std::string(model), std::string(config));
			return Ok<cv::dnn::TextDetectionModel_EAST*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_EAST*>))
	}
	
	// setConfidenceThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1613
	Result<cv::dnn::TextDetectionModel_EAST*> cv_dnn_TextDetectionModel_EAST_setConfidenceThreshold_float(cv::dnn::TextDetectionModel_EAST* instance, float confThreshold) {
		try {
			cv::dnn::TextDetectionModel_EAST ret = instance->setConfidenceThreshold(confThreshold);
			return Ok(new cv::dnn::TextDetectionModel_EAST(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_EAST*>))
	}
	
	// getConfidenceThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1619
	Result<float> cv_dnn_TextDetectionModel_EAST_getConfidenceThreshold_const(const cv::dnn::TextDetectionModel_EAST* instance) {
		try {
			float ret = instance->getConfidenceThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// setNMSThreshold(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1626
	Result<cv::dnn::TextDetectionModel_EAST*> cv_dnn_TextDetectionModel_EAST_setNMSThreshold_float(cv::dnn::TextDetectionModel_EAST* instance, float nmsThreshold) {
		try {
			cv::dnn::TextDetectionModel_EAST ret = instance->setNMSThreshold(nmsThreshold);
			return Ok(new cv::dnn::TextDetectionModel_EAST(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextDetectionModel_EAST*>))
	}
	
	// getNMSThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1632
	Result<float> cv_dnn_TextDetectionModel_EAST_getNMSThreshold_const(const cv::dnn::TextDetectionModel_EAST* instance) {
		try {
			float ret = instance->getNMSThreshold();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	cv::dnn::Model* cv_TextRecognitionModel_to_Model(cv::dnn::TextRecognitionModel* instance) {
		return dynamic_cast<cv::dnn::Model*>(instance);
	}
	
	void cv_TextRecognitionModel_delete(cv::dnn::TextRecognitionModel* instance) {
		delete instance;
	}
	// TextRecognitionModel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1434
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_TextRecognitionModel() {
		try {
			cv::dnn::TextRecognitionModel* ret = new cv::dnn::TextRecognitionModel();
			return Ok<cv::dnn::TextRecognitionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// TextRecognitionModel(const cv::dnn::Net &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1441
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_TextRecognitionModel_const_NetR(const cv::dnn::Net* network) {
		try {
			cv::dnn::TextRecognitionModel* ret = new cv::dnn::TextRecognitionModel(*network);
			return Ok<cv::dnn::TextRecognitionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// TextRecognitionModel(const std::string &, const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1450
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_TextRecognitionModel_const_stringR_const_stringR(const char* model, const char* config) {
		try {
			cv::dnn::TextRecognitionModel* ret = new cv::dnn::TextRecognitionModel(std::string(model), std::string(config));
			return Ok<cv::dnn::TextRecognitionModel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// setDecodeType(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1460
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_setDecodeType_const_stringR(cv::dnn::TextRecognitionModel* instance, const char* decodeType) {
		try {
			cv::dnn::TextRecognitionModel ret = instance->setDecodeType(std::string(decodeType));
			return Ok(new cv::dnn::TextRecognitionModel(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// getDecodeType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1467
	Result<void*> cv_dnn_TextRecognitionModel_getDecodeType_const(const cv::dnn::TextRecognitionModel* instance) {
		try {
			const std::string ret = instance->getDecodeType();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// setDecodeOptsCTCPrefixBeamSearch(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1476
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_setDecodeOptsCTCPrefixBeamSearch_int_int(cv::dnn::TextRecognitionModel* instance, int beamSize, int vocPruneSize) {
		try {
			cv::dnn::TextRecognitionModel ret = instance->setDecodeOptsCTCPrefixBeamSearch(beamSize, vocPruneSize);
			return Ok(new cv::dnn::TextRecognitionModel(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// setVocabulary(const std::vector<std::string> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1483
	Result<cv::dnn::TextRecognitionModel*> cv_dnn_TextRecognitionModel_setVocabulary_const_vector_string_R(cv::dnn::TextRecognitionModel* instance, const std::vector<std::string>* vocabulary) {
		try {
			cv::dnn::TextRecognitionModel ret = instance->setVocabulary(*vocabulary);
			return Ok(new cv::dnn::TextRecognitionModel(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::TextRecognitionModel*>))
	}
	
	// getVocabulary() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1490
	Result<const std::vector<std::string>*> cv_dnn_TextRecognitionModel_getVocabulary_const(const cv::dnn::TextRecognitionModel* instance) {
		try {
			const std::vector<std::string> ret = instance->getVocabulary();
			return Ok(new const std::vector<std::string>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<std::string>*>))
	}
	
	// recognize(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1498
	Result<void*> cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR(const cv::dnn::TextRecognitionModel* instance, const cv::_InputArray* frame) {
		try {
			std::string ret = instance->recognize(*frame);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// recognize(cv::InputArray, cv::InputArrayOfArrays, std::vector<std::string> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/dnn.hpp:1507
	Result_void cv_dnn_TextRecognitionModel_recognize_const_const__InputArrayR_const__InputArrayR_vector_string_R(const cv::dnn::TextRecognitionModel* instance, const cv::_InputArray* frame, const cv::_InputArray* roiRects, std::vector<std::string>* results) {
		try {
			instance->recognize(*frame, *roiRects, *results);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::Range* cv__Range_to_Range(cv::dnn::_Range* instance) {
		return dynamic_cast<cv::Range*>(instance);
	}
	
	void cv__Range_delete(cv::dnn::_Range* instance) {
		delete instance;
	}
	// _Range(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:59
	Result<cv::dnn::_Range*> cv_dnn__Range__Range_const_RangeR(const cv::Range* r) {
		try {
			cv::dnn::_Range* ret = new cv::dnn::_Range(*r);
			return Ok<cv::dnn::_Range*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::_Range*>))
	}
	
	// _Range(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/dnn/shape_utils.hpp:60
	Result<cv::dnn::_Range*> cv_dnn__Range__Range_int_int(int start_, int size_) {
		try {
			cv::dnn::_Range* ret = new cv::dnn::_Range(start_, size_);
			return Ok<cv::dnn::_Range*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::dnn::_Range*>))
	}
	
}
