#include "ocvrs_common.hpp"
#include <opencv2/cudawarping.hpp>
#include "cudawarping_types.hpp"

extern "C" {
	// buildWarpAffineMaps(cv::Mat, bool, cv::Size, cv::cuda::GpuMat &, cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:156
	Result_void cv_cuda_buildWarpAffineMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(cv::Mat* M, bool inverse, cv::Size* dsize, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpAffineMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildWarpAffineMaps(cv::UMat, bool, cv::Size, cv::cuda::GpuMat &, cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:152
	Result_void cv_cuda_buildWarpAffineMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(cv::UMat* M, bool inverse, cv::Size* dsize, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpAffineMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildWarpAffineMaps(cv::InputArray, bool, cv::Size, cv::OutputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:150
	Result_void cv_cuda_buildWarpAffineMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* M, bool inverse, cv::Size* dsize, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpAffineMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildWarpPerspectiveMaps(cv::Mat, bool, cv::Size, cv::cuda::GpuMat &, cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:206
	Result_void cv_cuda_buildWarpPerspectiveMaps_Mat_bool_Size_GpuMatR_GpuMatR_StreamR(cv::Mat* M, bool inverse, cv::Size* dsize, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpPerspectiveMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildWarpPerspectiveMaps(cv::UMat, bool, cv::Size, cv::cuda::GpuMat &, cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:202
	Result_void cv_cuda_buildWarpPerspectiveMaps_UMat_bool_Size_GpuMatR_GpuMatR_StreamR(cv::UMat* M, bool inverse, cv::Size* dsize, cv::cuda::GpuMat* xmap, cv::cuda::GpuMat* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpPerspectiveMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildWarpPerspectiveMaps(cv::InputArray, bool, cv::Size, cv::OutputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:200
	Result_void cv_cuda_buildWarpPerspectiveMaps_const__InputArrayR_bool_Size_const__OutputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* M, bool inverse, cv::Size* dsize, const cv::_OutputArray* xmap, const cv::_OutputArray* ymap, cv::cuda::Stream* stream) {
		try {
			cv::cuda::buildWarpPerspectiveMaps(*M, inverse, *dsize, *xmap, *ymap, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyrDown(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:237
	Result_void cv_cuda_pyrDown_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::pyrDown(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pyrUp(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:246
	Result_void cv_cuda_pyrUp_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::pyrUp(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// remap(cv::InputArray, cv::OutputArray, cv::InputArray, cv::InputArray, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:86
	Result_void cv_cuda_remap_const__InputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* xmap, const cv::_InputArray* ymap, int interpolation, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::remap(*src, *dst, *xmap, *ymap, interpolation, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resize(cv::InputArray, cv::OutputArray, cv::Size, double, double, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:108
	Result_void cv_cuda_resize_const__InputArrayR_const__OutputArrayR_Size_double_double_int_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* dsize, double fx, double fy, int interpolation, cv::cuda::Stream* stream) {
		try {
			cv::cuda::resize(*src, *dst, *dsize, fx, fy, interpolation, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rotate(cv::InputArray, cv::OutputArray, cv::Size, double, double, double, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:225
	Result_void cv_cuda_rotate_const__InputArrayR_const__OutputArrayR_Size_double_double_double_int_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* dsize, double angle, double xShift, double yShift, int interpolation, cv::cuda::Stream* stream) {
		try {
			cv::cuda::rotate(*src, *dst, *dsize, angle, xShift, yShift, interpolation, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpAffine(cv::InputArray, cv::OutputArray, cv::Mat, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:134
	Result_void cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Mat* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpAffine(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpAffine(cv::InputArray, cv::OutputArray, cv::UMat, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:129
	Result_void cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::UMat* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpAffine(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpAffine(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:126
	Result_void cv_cuda_warpAffine_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpAffine(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPerspective(cv::InputArray, cv::OutputArray, cv::Mat, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:184
	Result_void cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_Mat_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Mat* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpPerspective(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPerspective(cv::InputArray, cv::OutputArray, cv::UMat, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:179
	Result_void cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_UMat_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::UMat* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpPerspective(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// warpPerspective(cv::InputArray, cv::OutputArray, cv::InputArray, cv::Size, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudawarping.hpp:176
	Result_void cv_cuda_warpPerspective_const__InputArrayR_const__OutputArrayR_const__InputArrayR_Size_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* M, cv::Size* dsize, int flags, int borderMode, cv::Scalar* borderValue, cv::cuda::Stream* stream) {
		try {
			cv::cuda::warpPerspective(*src, *dst, *M, *dsize, flags, borderMode, *borderValue, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
