#include "ocvrs_common.hpp"
#include <opencv2/cudastereo.hpp>
#include "cudastereo_types.hpp"

extern "C" {
	// createDisparityBilateralFilter(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:339
	Result<cv::Ptr<cv::cuda::DisparityBilateralFilter>*> cv_cuda_createDisparityBilateralFilter_int_int_int(int ndisp, int radius, int iters) {
		try {
			cv::Ptr<cv::cuda::DisparityBilateralFilter> ret = cv::cuda::createDisparityBilateralFilter(ndisp, radius, iters);
			return Ok(new cv::Ptr<cv::cuda::DisparityBilateralFilter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::DisparityBilateralFilter>*>))
	}
	
	// createStereoBM(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:90
	Result<cv::Ptr<cv::cuda::StereoBM>*> cv_cuda_createStereoBM_int_int(int numDisparities, int blockSize) {
		try {
			cv::Ptr<cv::cuda::StereoBM> ret = cv::cuda::createStereoBM(numDisparities, blockSize);
			return Ok(new cv::Ptr<cv::cuda::StereoBM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::StereoBM>*>))
	}
	
	// createStereoBeliefPropagation(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:189
	Result<cv::Ptr<cv::cuda::StereoBeliefPropagation>*> cv_cuda_createStereoBeliefPropagation_int_int_int_int(int ndisp, int iters, int levels, int msg_type) {
		try {
			cv::Ptr<cv::cuda::StereoBeliefPropagation> ret = cv::cuda::createStereoBeliefPropagation(ndisp, iters, levels, msg_type);
			return Ok(new cv::Ptr<cv::cuda::StereoBeliefPropagation>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::StereoBeliefPropagation>*>))
	}
	
	// createStereoConstantSpaceBP(int, int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:242
	Result<cv::Ptr<cv::cuda::StereoConstantSpaceBP>*> cv_cuda_createStereoConstantSpaceBP_int_int_int_int_int(int ndisp, int iters, int levels, int nr_plane, int msg_type) {
		try {
			cv::Ptr<cv::cuda::StereoConstantSpaceBP> ret = cv::cuda::createStereoConstantSpaceBP(ndisp, iters, levels, nr_plane, msg_type);
			return Ok(new cv::Ptr<cv::cuda::StereoConstantSpaceBP>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::StereoConstantSpaceBP>*>))
	}
	
	// createStereoSGM(int, int, int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:289
	Result<cv::Ptr<cv::cuda::StereoSGM>*> cv_cuda_createStereoSGM_int_int_int_int_int_int(int minDisparity, int numDisparities, int P1, int P2, int uniquenessRatio, int mode) {
		try {
			cv::Ptr<cv::cuda::StereoSGM> ret = cv::cuda::createStereoSGM(minDisparity, numDisparities, P1, P2, uniquenessRatio, mode);
			return Ok(new cv::Ptr<cv::cuda::StereoSGM>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::StereoSGM>*>))
	}
	
	// drawColorDisp(cv::InputArray, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:374
	Result_void cv_cuda_drawColorDisp_const__InputArrayR_const__OutputArrayR_int_StreamR(const cv::_InputArray* src_disp, const cv::_OutputArray* dst_disp, int ndisp, cv::cuda::Stream* stream) {
		try {
			cv::cuda::drawColorDisp(*src_disp, *dst_disp, ndisp, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reprojectImageTo3D(cv::InputArray, cv::OutputArray, cv::InputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:358
	Result_void cv_cuda_reprojectImageTo3D_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(const cv::_InputArray* disp, const cv::_OutputArray* xyzw, const cv::_InputArray* Q, int dst_cn, cv::cuda::Stream* stream) {
		try {
			cv::cuda::reprojectImageTo3D(*disp, *xyzw, *Q, dst_cn, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// apply(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:308
	Result_void cv_cuda_DisparityBilateralFilter_apply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::DisparityBilateralFilter* instance, const cv::_InputArray* disparity, const cv::_InputArray* image, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->apply(*disparity, *image, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumDisparities() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:310
	Result<int> cv_cuda_DisparityBilateralFilter_getNumDisparities_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			int ret = instance->getNumDisparities();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumDisparities(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:311
	Result_void cv_cuda_DisparityBilateralFilter_setNumDisparities_int(cv::cuda::DisparityBilateralFilter* instance, int numDisparities) {
		try {
			instance->setNumDisparities(numDisparities);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getRadius() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:313
	Result<int> cv_cuda_DisparityBilateralFilter_getRadius_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			int ret = instance->getRadius();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setRadius(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:314
	Result_void cv_cuda_DisparityBilateralFilter_setRadius_int(cv::cuda::DisparityBilateralFilter* instance, int radius) {
		try {
			instance->setRadius(radius);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumIters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:316
	Result<int> cv_cuda_DisparityBilateralFilter_getNumIters_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			int ret = instance->getNumIters();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumIters(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:317
	Result_void cv_cuda_DisparityBilateralFilter_setNumIters_int(cv::cuda::DisparityBilateralFilter* instance, int iters) {
		try {
			instance->setNumIters(iters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEdgeThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:320
	Result<double> cv_cuda_DisparityBilateralFilter_getEdgeThreshold_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			double ret = instance->getEdgeThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setEdgeThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:321
	Result_void cv_cuda_DisparityBilateralFilter_setEdgeThreshold_double(cv::cuda::DisparityBilateralFilter* instance, double edge_threshold) {
		try {
			instance->setEdgeThreshold(edge_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDiscThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:324
	Result<double> cv_cuda_DisparityBilateralFilter_getMaxDiscThreshold_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			double ret = instance->getMaxDiscThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDiscThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:325
	Result_void cv_cuda_DisparityBilateralFilter_setMaxDiscThreshold_double(cv::cuda::DisparityBilateralFilter* instance, double max_disc_threshold) {
		try {
			instance->setMaxDiscThreshold(max_disc_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSigmaRange() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:328
	Result<double> cv_cuda_DisparityBilateralFilter_getSigmaRange_const(const cv::cuda::DisparityBilateralFilter* instance) {
		try {
			double ret = instance->getSigmaRange();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setSigmaRange(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:329
	Result_void cv_cuda_DisparityBilateralFilter_setSigmaRange_double(cv::cuda::DisparityBilateralFilter* instance, double sigma_range) {
		try {
			instance->setSigmaRange(sigma_range);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:77
	Result_void cv_cuda_StereoBM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::StereoBM* instance, const cv::_InputArray* left, const cv::_InputArray* right, const cv::_OutputArray* disparity, cv::cuda::Stream* stream) {
		try {
			instance->compute(*left, *right, *disparity, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:134
	Result_void cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::StereoBeliefPropagation* instance, const cv::_InputArray* left, const cv::_InputArray* right, const cv::_OutputArray* disparity, cv::cuda::Stream* stream) {
		try {
			instance->compute(*left, *right, *disparity, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:145
	Result_void cv_cuda_StereoBeliefPropagation_compute_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::StereoBeliefPropagation* instance, const cv::_InputArray* data, const cv::_OutputArray* disparity, cv::cuda::Stream* stream) {
		try {
			instance->compute(*data, *disparity, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumIters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:148
	Result<int> cv_cuda_StereoBeliefPropagation_getNumIters_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			int ret = instance->getNumIters();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumIters(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:149
	Result_void cv_cuda_StereoBeliefPropagation_setNumIters_int(cv::cuda::StereoBeliefPropagation* instance, int iters) {
		try {
			instance->setNumIters(iters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:152
	Result<int> cv_cuda_StereoBeliefPropagation_getNumLevels_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			int ret = instance->getNumLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:153
	Result_void cv_cuda_StereoBeliefPropagation_setNumLevels_int(cv::cuda::StereoBeliefPropagation* instance, int levels) {
		try {
			instance->setNumLevels(levels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDataTerm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:156
	Result<double> cv_cuda_StereoBeliefPropagation_getMaxDataTerm_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			double ret = instance->getMaxDataTerm();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDataTerm(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:157
	Result_void cv_cuda_StereoBeliefPropagation_setMaxDataTerm_double(cv::cuda::StereoBeliefPropagation* instance, double max_data_term) {
		try {
			instance->setMaxDataTerm(max_data_term);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDataWeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:160
	Result<double> cv_cuda_StereoBeliefPropagation_getDataWeight_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			double ret = instance->getDataWeight();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setDataWeight(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:161
	Result_void cv_cuda_StereoBeliefPropagation_setDataWeight_double(cv::cuda::StereoBeliefPropagation* instance, double data_weight) {
		try {
			instance->setDataWeight(data_weight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxDiscTerm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:164
	Result<double> cv_cuda_StereoBeliefPropagation_getMaxDiscTerm_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			double ret = instance->getMaxDiscTerm();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMaxDiscTerm(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:165
	Result_void cv_cuda_StereoBeliefPropagation_setMaxDiscTerm_double(cv::cuda::StereoBeliefPropagation* instance, double max_disc_term) {
		try {
			instance->setMaxDiscTerm(max_disc_term);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDiscSingleJump() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:168
	Result<double> cv_cuda_StereoBeliefPropagation_getDiscSingleJump_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			double ret = instance->getDiscSingleJump();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setDiscSingleJump(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:169
	Result_void cv_cuda_StereoBeliefPropagation_setDiscSingleJump_double(cv::cuda::StereoBeliefPropagation* instance, double disc_single_jump) {
		try {
			instance->setDiscSingleJump(disc_single_jump);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMsgType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:172
	Result<int> cv_cuda_StereoBeliefPropagation_getMsgType_const(const cv::cuda::StereoBeliefPropagation* instance) {
		try {
			int ret = instance->getMsgType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setMsgType(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:173
	Result_void cv_cuda_StereoBeliefPropagation_setMsgType_int(cv::cuda::StereoBeliefPropagation* instance, int msg_type) {
		try {
			instance->setMsgType(msg_type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimateRecommendedParams(int, int, int &, int &, int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:178
	Result_void cv_cuda_StereoBeliefPropagation_estimateRecommendedParams_int_int_intR_intR_intR(int width, int height, int* ndisp, int* iters, int* levels) {
		try {
			cv::cuda::StereoBeliefPropagation::estimateRecommendedParams(width, height, *ndisp, *iters, *levels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNrPlane() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:221
	Result<int> cv_cuda_StereoConstantSpaceBP_getNrPlane_const(const cv::cuda::StereoConstantSpaceBP* instance) {
		try {
			int ret = instance->getNrPlane();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNrPlane(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:222
	Result_void cv_cuda_StereoConstantSpaceBP_setNrPlane_int(cv::cuda::StereoConstantSpaceBP* instance, int nr_plane) {
		try {
			instance->setNrPlane(nr_plane);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUseLocalInitDataCost() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:224
	Result<bool> cv_cuda_StereoConstantSpaceBP_getUseLocalInitDataCost_const(const cv::cuda::StereoConstantSpaceBP* instance) {
		try {
			bool ret = instance->getUseLocalInitDataCost();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseLocalInitDataCost(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:225
	Result_void cv_cuda_StereoConstantSpaceBP_setUseLocalInitDataCost_bool(cv::cuda::StereoConstantSpaceBP* instance, bool use_local_init_data_cost) {
		try {
			instance->setUseLocalInitDataCost(use_local_init_data_cost);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimateRecommendedParams(int, int, int &, int &, int &, int &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:230
	Result_void cv_cuda_StereoConstantSpaceBP_estimateRecommendedParams_int_int_intR_intR_intR_intR(int width, int height, int* ndisp, int* iters, int* levels, int* nr_plane) {
		try {
			cv::cuda::StereoConstantSpaceBP::estimateRecommendedParams(width, height, *ndisp, *iters, *levels, *nr_plane);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:268
	Result_void cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR(cv::cuda::StereoSGM* instance, const cv::_InputArray* left, const cv::_InputArray* right, const cv::_OutputArray* disparity) {
		try {
			instance->compute(*left, *right, *disparity);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudastereo.hpp:274
	Result_void cv_cuda_StereoSGM_compute_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::StereoSGM* instance, const cv::_InputArray* left, const cv::_InputArray* right, const cv::_OutputArray* disparity, cv::cuda::Stream* stream) {
		try {
			instance->compute(*left, *right, *disparity, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
