#include "ocvrs_common.hpp"
#include <opencv2/cudaobjdetect.hpp>
#include "cudaobjdetect_types.hpp"

extern "C" {
	// create(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:239
	Result<cv::Ptr<cv::cuda::CascadeClassifier>*> cv_cuda_CascadeClassifier_create_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::cuda::CascadeClassifier> ret = cv::cuda::CascadeClassifier::create(std::string(filename));
			return Ok(new cv::Ptr<cv::cuda::CascadeClassifier>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::CascadeClassifier>*>))
	}
	
	// create(const cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:242
	Result<cv::Ptr<cv::cuda::CascadeClassifier>*> cv_cuda_CascadeClassifier_create_const_FileStorageR(const cv::FileStorage* file) {
		try {
			cv::Ptr<cv::cuda::CascadeClassifier> ret = cv::cuda::CascadeClassifier::create(*file);
			return Ok(new cv::Ptr<cv::cuda::CascadeClassifier>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::CascadeClassifier>*>))
	}
	
	// setMaxObjectSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:246
	Result_void cv_cuda_CascadeClassifier_setMaxObjectSize_Size(cv::cuda::CascadeClassifier* instance, cv::Size* maxObjectSize) {
		try {
			instance->setMaxObjectSize(*maxObjectSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxObjectSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:247
	Result<cv::Size> cv_cuda_CascadeClassifier_getMaxObjectSize_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			cv::Size ret = instance->getMaxObjectSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setMinObjectSize(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:250
	Result_void cv_cuda_CascadeClassifier_setMinObjectSize_Size(cv::cuda::CascadeClassifier* instance, cv::Size* minSize) {
		try {
			instance->setMinObjectSize(*minSize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinObjectSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:251
	Result<cv::Size> cv_cuda_CascadeClassifier_getMinObjectSize_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			cv::Size ret = instance->getMinObjectSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setScaleFactor(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:254
	Result_void cv_cuda_CascadeClassifier_setScaleFactor_double(cv::cuda::CascadeClassifier* instance, double scaleFactor) {
		try {
			instance->setScaleFactor(scaleFactor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleFactor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:255
	Result<double> cv_cuda_CascadeClassifier_getScaleFactor_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			double ret = instance->getScaleFactor();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setMinNeighbors(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:259
	Result_void cv_cuda_CascadeClassifier_setMinNeighbors_int(cv::cuda::CascadeClassifier* instance, int minNeighbors) {
		try {
			instance->setMinNeighbors(minNeighbors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMinNeighbors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:260
	Result<int> cv_cuda_CascadeClassifier_getMinNeighbors_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			int ret = instance->getMinNeighbors();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setFindLargestObject(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:262
	Result_void cv_cuda_CascadeClassifier_setFindLargestObject_bool(cv::cuda::CascadeClassifier* instance, bool findLargestObject) {
		try {
			instance->setFindLargestObject(findLargestObject);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFindLargestObject() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:263
	Result<bool> cv_cuda_CascadeClassifier_getFindLargestObject(cv::cuda::CascadeClassifier* instance) {
		try {
			bool ret = instance->getFindLargestObject();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setMaxNumObjects(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:265
	Result_void cv_cuda_CascadeClassifier_setMaxNumObjects_int(cv::cuda::CascadeClassifier* instance, int maxNumObjects) {
		try {
			instance->setMaxNumObjects(maxNumObjects);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxNumObjects() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:266
	Result<int> cv_cuda_CascadeClassifier_getMaxNumObjects_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			int ret = instance->getMaxNumObjects();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getClassifierSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:268
	Result<cv::Size> cv_cuda_CascadeClassifier_getClassifierSize_const(const cv::cuda::CascadeClassifier* instance) {
		try {
			cv::Size ret = instance->getClassifierSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// detectMultiScale(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:298
	Result_void cv_cuda_CascadeClassifier_detectMultiScale_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::CascadeClassifier* instance, const cv::_InputArray* image, const cv::_OutputArray* objects, cv::cuda::Stream* stream) {
		try {
			instance->detectMultiScale(*image, *objects, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convert(cv::OutputArray, std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:307
	Result_void cv_cuda_CascadeClassifier_convert_const__OutputArrayR_vector_Rect_R(cv::cuda::CascadeClassifier* instance, const cv::_OutputArray* gpu_objects, std::vector<cv::Rect>* objects) {
		try {
			instance->convert(*gpu_objects, *objects);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, cv::Size, cv::Size, cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:90
	Result<cv::Ptr<cv::cuda::HOG>*> cv_cuda_HOG_create_Size_Size_Size_Size_int(cv::Size* win_size, cv::Size* block_size, cv::Size* block_stride, cv::Size* cell_size, int nbins) {
		try {
			cv::Ptr<cv::cuda::HOG> ret = cv::cuda::HOG::create(*win_size, *block_size, *block_stride, *cell_size, nbins);
			return Ok(new cv::Ptr<cv::cuda::HOG>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::HOG>*>))
	}
	
	// setWinSigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:97
	Result_void cv_cuda_HOG_setWinSigma_double(cv::cuda::HOG* instance, double win_sigma) {
		try {
			instance->setWinSigma(win_sigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWinSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:98
	Result<double> cv_cuda_HOG_getWinSigma_const(const cv::cuda::HOG* instance) {
		try {
			double ret = instance->getWinSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setL2HysThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:101
	Result_void cv_cuda_HOG_setL2HysThreshold_double(cv::cuda::HOG* instance, double threshold_L2hys) {
		try {
			instance->setL2HysThreshold(threshold_L2hys);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getL2HysThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:102
	Result<double> cv_cuda_HOG_getL2HysThreshold_const(const cv::cuda::HOG* instance) {
		try {
			double ret = instance->getL2HysThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setGammaCorrection(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:105
	Result_void cv_cuda_HOG_setGammaCorrection_bool(cv::cuda::HOG* instance, bool gamma_correction) {
		try {
			instance->setGammaCorrection(gamma_correction);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGammaCorrection() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:106
	Result<bool> cv_cuda_HOG_getGammaCorrection_const(const cv::cuda::HOG* instance) {
		try {
			bool ret = instance->getGammaCorrection();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setNumLevels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:109
	Result_void cv_cuda_HOG_setNumLevels_int(cv::cuda::HOG* instance, int nlevels) {
		try {
			instance->setNumLevels(nlevels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNumLevels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:110
	Result<int> cv_cuda_HOG_getNumLevels_const(const cv::cuda::HOG* instance) {
		try {
			int ret = instance->getNumLevels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setHitThreshold(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:116
	Result_void cv_cuda_HOG_setHitThreshold_double(cv::cuda::HOG* instance, double hit_threshold) {
		try {
			instance->setHitThreshold(hit_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHitThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:117
	Result<double> cv_cuda_HOG_getHitThreshold_const(const cv::cuda::HOG* instance) {
		try {
			double ret = instance->getHitThreshold();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setWinStride(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:120
	Result_void cv_cuda_HOG_setWinStride_Size(cv::cuda::HOG* instance, cv::Size* win_stride) {
		try {
			instance->setWinStride(*win_stride);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getWinStride() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:121
	Result<cv::Size> cv_cuda_HOG_getWinStride_const(const cv::cuda::HOG* instance) {
		try {
			cv::Size ret = instance->getWinStride();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setScaleFactor(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:124
	Result_void cv_cuda_HOG_setScaleFactor_double(cv::cuda::HOG* instance, double scale0) {
		try {
			instance->setScaleFactor(scale0);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getScaleFactor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:125
	Result<double> cv_cuda_HOG_getScaleFactor_const(const cv::cuda::HOG* instance) {
		try {
			double ret = instance->getScaleFactor();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setGroupThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:130
	Result_void cv_cuda_HOG_setGroupThreshold_int(cv::cuda::HOG* instance, int group_threshold) {
		try {
			instance->setGroupThreshold(group_threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGroupThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:131
	Result<int> cv_cuda_HOG_getGroupThreshold_const(const cv::cuda::HOG* instance) {
		try {
			int ret = instance->getGroupThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setDescriptorFormat(HOGDescriptor::DescriptorStorageFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:136
	Result_void cv_cuda_HOG_setDescriptorFormat_DescriptorStorageFormat(cv::cuda::HOG* instance, cv::HOGDescriptor::DescriptorStorageFormat descr_format) {
		try {
			instance->setDescriptorFormat(descr_format);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDescriptorFormat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:137
	Result<cv::HOGDescriptor::DescriptorStorageFormat> cv_cuda_HOG_getDescriptorFormat_const(const cv::cuda::HOG* instance) {
		try {
			cv::HOGDescriptor::DescriptorStorageFormat ret = instance->getDescriptorFormat();
			return Ok<cv::HOGDescriptor::DescriptorStorageFormat>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::HOGDescriptor::DescriptorStorageFormat>))
	}
	
	// getDescriptorSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:141
	Result<size_t> cv_cuda_HOG_getDescriptorSize_const(const cv::cuda::HOG* instance) {
		try {
			size_t ret = instance->getDescriptorSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// getBlockHistogramSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:145
	Result<size_t> cv_cuda_HOG_getBlockHistogramSize_const(const cv::cuda::HOG* instance) {
		try {
			size_t ret = instance->getBlockHistogramSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// setSVMDetector(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:149
	Result_void cv_cuda_HOG_setSVMDetector_const__InputArrayR(cv::cuda::HOG* instance, const cv::_InputArray* detector) {
		try {
			instance->setSVMDetector(*detector);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultPeopleDetector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:153
	Result<cv::Mat*> cv_cuda_HOG_getDefaultPeopleDetector_const(const cv::cuda::HOG* instance) {
		try {
			cv::Mat ret = instance->getDefaultPeopleDetector();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// detect(cv::InputArray, std::vector<Point> &, std::vector<double> *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:161
	Result_void cv_cuda_HOG_detect_const__InputArrayR_vector_Point_R_vector_double_X(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Point>* found_locations, std::vector<double>* confidences) {
		try {
			instance->detect(*img, *found_locations, confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detect(cv::InputArray, std::vector<Point> &, std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:165
	Result_void cv_cuda_HOG_detect_const__InputArrayR_vector_Point_R_vector_double_R(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Point>* found_locations, std::vector<double>* confidences) {
		try {
			instance->detect(*img, *found_locations, *confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectWithoutConf(cv::InputArray, std::vector<Point> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:176
	Result_void cv_cuda_HOG_detectWithoutConf_const__InputArrayR_vector_Point_R(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Point>* found_locations) {
		try {
			instance->detectWithoutConf(*img, *found_locations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<double> *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:187
	Result_void cv_cuda_HOG_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_double_X(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Rect>* found_locations, std::vector<double>* confidences) {
		try {
			instance->detectMultiScale(*img, *found_locations, confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScale(cv::InputArray, std::vector<Rect> &, std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:191
	Result_void cv_cuda_HOG_detectMultiScale_const__InputArrayR_vector_Rect_R_vector_double_R(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Rect>* found_locations, std::vector<double>* confidences) {
		try {
			instance->detectMultiScale(*img, *found_locations, *confidences);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMultiScaleWithoutConf(cv::InputArray, std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:202
	Result_void cv_cuda_HOG_detectMultiScaleWithoutConf_const__InputArrayR_vector_Rect_R(cv::cuda::HOG* instance, const cv::_InputArray* img, std::vector<cv::Rect>* found_locations) {
		try {
			instance->detectMultiScaleWithoutConf(*img, *found_locations);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaobjdetect.hpp:213
	Result_void cv_cuda_HOG_compute_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::HOG* instance, const cv::_InputArray* img, const cv::_OutputArray* descriptors, cv::cuda::Stream* stream) {
		try {
			instance->compute(*img, *descriptors, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
