#include "ocvrs_common.hpp"
#include <opencv2/cudafilters.hpp>
#include "cudafilters_types.hpp"

extern "C" {
	// createBoxFilter(int, int, cv::Size, cv::Point, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:102
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createBoxFilter_int_int_Size_Point_int_Scalar(int srcType, int dstType, cv::Size* ksize, cv::Point* anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createBoxFilter(srcType, dstType, *ksize, *anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createBoxMaxFilter(int, cv::Size, cv::Point, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:274
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createBoxMaxFilter_int_Size_Point_int_Scalar(int srcType, cv::Size* ksize, cv::Point* anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createBoxMaxFilter(srcType, *ksize, *anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createBoxMinFilter(int, cv::Size, cv::Point, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:286
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createBoxMinFilter_int_Size_Point_int_Scalar(int srcType, cv::Size* ksize, cv::Point* anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createBoxMinFilter(srcType, *ksize, *anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createColumnSumFilter(int, int, int, int, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:313
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createColumnSumFilter_int_int_int_int_int_Scalar(int srcType, int dstType, int ksize, int anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createColumnSumFilter(srcType, dstType, ksize, anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createDerivFilter(int, int, int, int, int, bool, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:180
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createDerivFilter_int_int_int_int_int_bool_double_int_int(int srcType, int dstType, int dx, int dy, int ksize, bool normalize, double scale, int rowBorderMode, int columnBorderMode) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createDerivFilter(srcType, dstType, dx, dy, ksize, normalize, scale, rowBorderMode, columnBorderMode);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createGaussianFilter(int, int, cv::Size, double, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:236
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createGaussianFilter_int_int_Size_double_double_int_int(int srcType, int dstType, cv::Size* ksize, double sigma1, double sigma2, int rowBorderMode, int columnBorderMode) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createGaussianFilter(srcType, dstType, *ksize, sigma1, sigma2, rowBorderMode, columnBorderMode);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createLaplacianFilter(int, int, int, double, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:139
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createLaplacianFilter_int_int_int_double_int_Scalar(int srcType, int dstType, int ksize, double scale, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createLaplacianFilter(srcType, dstType, ksize, scale, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createLinearFilter(int, int, cv::InputArray, cv::Point, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:120
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createLinearFilter_int_int_const__InputArrayR_Point_int_Scalar(int srcType, int dstType, const cv::_InputArray* kernel, cv::Point* anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createLinearFilter(srcType, dstType, *kernel, *anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createMedianFilter(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:331
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createMedianFilter_int_int_int(int srcType, int windowSize, int partition) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createMedianFilter(srcType, windowSize, partition);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createMorphologyFilter(int, int, cv::InputArray, cv::Point, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:261
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createMorphologyFilter_int_int_const__InputArrayR_Point_int(int op, int srcType, const cv::_InputArray* kernel, cv::Point* anchor, int iterations) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createMorphologyFilter(op, srcType, *kernel, *anchor, iterations);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createRowSumFilter(int, int, int, int, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:302
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createRowSumFilter_int_int_int_int_int_Scalar(int srcType, int dstType, int ksize, int anchor, int borderMode, cv::Scalar* borderVal) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createRowSumFilter(srcType, dstType, ksize, anchor, borderMode, *borderVal);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createScharrFilter(int, int, int, int, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:216
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createScharrFilter_int_int_int_int_double_int_int(int srcType, int dstType, int dx, int dy, double scale, int rowBorderMode, int columnBorderMode) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createScharrFilter(srcType, dstType, dx, dy, scale, rowBorderMode, columnBorderMode);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createSeparableLinearFilter(int, int, cv::InputArray, cv::InputArray, cv::Point, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:159
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createSeparableLinearFilter_int_int_const__InputArrayR_const__InputArrayR_Point_int_int(int srcType, int dstType, const cv::_InputArray* rowKernel, const cv::_InputArray* columnKernel, cv::Point* anchor, int rowBorderMode, int columnBorderMode) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createSeparableLinearFilter(srcType, dstType, *rowKernel, *columnKernel, *anchor, rowBorderMode, columnBorderMode);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// createSobelFilter(int, int, int, int, int, double, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:199
	Result<cv::Ptr<cv::cuda::Filter>*> cv_cuda_createSobelFilter_int_int_int_int_int_double_int_int(int srcType, int dstType, int dx, int dy, int ksize, double scale, int rowBorderMode, int columnBorderMode) {
		try {
			cv::Ptr<cv::cuda::Filter> ret = cv::cuda::createSobelFilter(srcType, dstType, dx, dy, ksize, scale, rowBorderMode, columnBorderMode);
			return Ok(new cv::Ptr<cv::cuda::Filter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Filter>*>))
	}
	
	// apply(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafilters.hpp:84
	Result_void cv_cuda_Filter_apply_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::Filter* instance, const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->apply(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
