#include "ocvrs_common.hpp"
#include <opencv2/cudafeatures2d.hpp>
#include "cudafeatures2d_types.hpp"

extern "C" {
	// createBFMatcher(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:92
	Result<cv::Ptr<cv::cuda::DescriptorMatcher>*> cv_cuda_DescriptorMatcher_createBFMatcher_int(int normType) {
		try {
			cv::Ptr<cv::cuda::DescriptorMatcher> ret = cv::cuda::DescriptorMatcher::createBFMatcher(normType);
			return Ok(new cv::Ptr<cv::cuda::DescriptorMatcher>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::DescriptorMatcher>*>))
	}
	
	// isMaskSupported() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:100
	Result<bool> cv_cuda_DescriptorMatcher_isMaskSupported_const(const cv::cuda::DescriptorMatcher* instance) {
		try {
			bool ret = instance->isMaskSupported();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// add(const std::vector<GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:113
	Result_void cv_cuda_DescriptorMatcher_add_const_vector_GpuMat_R(cv::cuda::DescriptorMatcher* instance, const std::vector<cv::cuda::GpuMat>* descriptors) {
		try {
			instance->add(*descriptors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTrainDescriptors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:117
	Result<const std::vector<cv::cuda::GpuMat>*> cv_cuda_DescriptorMatcher_getTrainDescriptors_const(const cv::cuda::DescriptorMatcher* instance) {
		try {
			const std::vector<cv::cuda::GpuMat> ret = instance->getTrainDescriptors();
			return Ok(new const std::vector<cv::cuda::GpuMat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const std::vector<cv::cuda::GpuMat>*>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:121
	Result_void cv_cuda_DescriptorMatcher_clear(cv::cuda::DescriptorMatcher* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:125
	Result<bool> cv_cuda_DescriptorMatcher_empty_const(const cv::cuda::DescriptorMatcher* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// train() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:132
	Result_void cv_cuda_DescriptorMatcher_train(cv::cuda::DescriptorMatcher* instance) {
		try {
			instance->train();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(cv::InputArray, cv::InputArray, std::vector<DMatch> &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:154
	Result_void cv_cuda_DescriptorMatcher_match_const__InputArrayR_const__InputArrayR_vector_DMatch_R_const__InputArrayR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<cv::DMatch>* matches, const cv::_InputArray* mask) {
		try {
			instance->match(*queryDescriptors, *trainDescriptors, *matches, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// match(cv::InputArray, std::vector<DMatch> &, const std::vector<GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:160
	Result_void cv_cuda_DescriptorMatcher_match_const__InputArrayR_vector_DMatch_R_const_vector_GpuMat_R(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<cv::DMatch>* matches, const std::vector<cv::cuda::GpuMat>* masks) {
		try {
			instance->match(*queryDescriptors, *matches, *masks);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matchAsync(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:181
	Result_void cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, const cv::_OutputArray* matches, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			instance->matchAsync(*queryDescriptors, *trainDescriptors, *matches, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matchAsync(cv::InputArray, cv::OutputArray, const std::vector<GpuMat> &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:188
	Result_void cv_cuda_DescriptorMatcher_matchAsync_const__InputArrayR_const__OutputArrayR_const_vector_GpuMat_R_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_OutputArray* matches, const std::vector<cv::cuda::GpuMat>* masks, cv::cuda::Stream* stream) {
		try {
			instance->matchAsync(*queryDescriptors, *matches, *masks, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matchConvert(cv::InputArray, std::vector<DMatch> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:201
	Result_void cv_cuda_DescriptorMatcher_matchConvert_const__InputArrayR_vector_DMatch_R(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* gpu_matches, std::vector<cv::DMatch>* matches) {
		try {
			instance->matchConvert(*gpu_matches, *matches);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(cv::InputArray, cv::InputArray, std::vector<std::vector<DMatch>> &, int, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:226
	Result_void cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_int_const__InputArrayR_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const cv::_InputArray* mask, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *trainDescriptors, *matches, k, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatch(cv::InputArray, std::vector<std::vector<DMatch>> &, int, const std::vector<GpuMat> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:234
	Result_void cv_cuda_DescriptorMatcher_knnMatch_const__InputArrayR_vector_vector_DMatch__R_int_const_vector_GpuMat_R_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, int k, const std::vector<cv::cuda::GpuMat>* masks, bool compactResult) {
		try {
			instance->knnMatch(*queryDescriptors, *matches, k, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatchAsync(cv::InputArray, cv::InputArray, cv::OutputArray, int, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:257
	Result_void cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, const cv::_OutputArray* matches, int k, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			instance->knnMatchAsync(*queryDescriptors, *trainDescriptors, *matches, k, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatchAsync(cv::InputArray, cv::OutputArray, int, const std::vector<GpuMat> &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:265
	Result_void cv_cuda_DescriptorMatcher_knnMatchAsync_const__InputArrayR_const__OutputArrayR_int_const_vector_GpuMat_R_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_OutputArray* matches, int k, const std::vector<cv::cuda::GpuMat>* masks, cv::cuda::Stream* stream) {
		try {
			instance->knnMatchAsync(*queryDescriptors, *matches, k, *masks, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// knnMatchConvert(cv::InputArray, std::vector<std::vector<DMatch>> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:282
	Result_void cv_cuda_DescriptorMatcher_knnMatchConvert_const__InputArrayR_vector_vector_DMatch__R_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* gpu_matches, std::vector<std::vector<cv::DMatch>>* matches, bool compactResult) {
		try {
			instance->knnMatchConvert(*gpu_matches, *matches, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(cv::InputArray, cv::InputArray, std::vector<std::vector<DMatch>> &, float, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:309
	Result_void cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_const__InputArrayR_vector_vector_DMatch__R_float_const__InputArrayR_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const cv::_InputArray* mask, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *trainDescriptors, *matches, maxDistance, *mask, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatch(cv::InputArray, std::vector<std::vector<DMatch>> &, float, const std::vector<GpuMat> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:317
	Result_void cv_cuda_DescriptorMatcher_radiusMatch_const__InputArrayR_vector_vector_DMatch__R_float_const_vector_GpuMat_R_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, std::vector<std::vector<cv::DMatch>>* matches, float maxDistance, const std::vector<cv::cuda::GpuMat>* masks, bool compactResult) {
		try {
			instance->radiusMatch(*queryDescriptors, *matches, maxDistance, *masks, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatchAsync(cv::InputArray, cv::InputArray, cv::OutputArray, float, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:341
	Result_void cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_float_const__InputArrayR_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_InputArray* trainDescriptors, const cv::_OutputArray* matches, float maxDistance, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			instance->radiusMatchAsync(*queryDescriptors, *trainDescriptors, *matches, maxDistance, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatchAsync(cv::InputArray, cv::OutputArray, float, const std::vector<GpuMat> &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:349
	Result_void cv_cuda_DescriptorMatcher_radiusMatchAsync_const__InputArrayR_const__OutputArrayR_float_const_vector_GpuMat_R_StreamR(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* queryDescriptors, const cv::_OutputArray* matches, float maxDistance, const std::vector<cv::cuda::GpuMat>* masks, cv::cuda::Stream* stream) {
		try {
			instance->radiusMatchAsync(*queryDescriptors, *matches, maxDistance, *masks, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// radiusMatchConvert(cv::InputArray, std::vector<std::vector<DMatch>> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:366
	Result_void cv_cuda_DescriptorMatcher_radiusMatchConvert_const__InputArrayR_vector_vector_DMatch__R_bool(cv::cuda::DescriptorMatcher* instance, const cv::_InputArray* gpu_matches, std::vector<std::vector<cv::DMatch>>* matches, bool compactResult) {
		try {
			instance->radiusMatchConvert(*gpu_matches, *matches, compactResult);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, bool, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:434
	Result<cv::Ptr<cv::cuda::FastFeatureDetector>*> cv_cuda_FastFeatureDetector_create_int_bool_int_int(int threshold, bool nonmaxSuppression, int type, int max_npoints) {
		try {
			cv::Ptr<cv::cuda::FastFeatureDetector> ret = cv::cuda::FastFeatureDetector::create(threshold, nonmaxSuppression, type, max_npoints);
			return Ok(new cv::Ptr<cv::cuda::FastFeatureDetector>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::FastFeatureDetector>*>))
	}
	
	// setThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:438
	Result_void cv_cuda_FastFeatureDetector_setThreshold_int(cv::cuda::FastFeatureDetector* instance, int threshold) {
		try {
			instance->setThreshold(threshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMaxNumPoints(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:440
	Result_void cv_cuda_FastFeatureDetector_setMaxNumPoints_int(cv::cuda::FastFeatureDetector* instance, int max_npoints) {
		try {
			instance->setMaxNumPoints(max_npoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMaxNumPoints() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:441
	Result<int> cv_cuda_FastFeatureDetector_getMaxNumPoints_const(const cv::cuda::FastFeatureDetector* instance) {
		try {
			int ret = instance->getMaxNumPoints();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// detectAsync(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:390
	Result_void cv_cuda_Feature2DAsync_detectAsync_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(cv::cuda::Feature2DAsync* instance, const cv::_InputArray* image, const cv::_OutputArray* keypoints, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			instance->detectAsync(*image, *keypoints, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// computeAsync(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:402
	Result_void cv_cuda_Feature2DAsync_computeAsync_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_StreamR(cv::cuda::Feature2DAsync* instance, const cv::_InputArray* image, const cv::_OutputArray* keypoints, const cv::_OutputArray* descriptors, cv::cuda::Stream* stream) {
		try {
			instance->computeAsync(*image, *keypoints, *descriptors, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectAndComputeAsync(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:408
	Result_void cv_cuda_Feature2DAsync_detectAndComputeAsync_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(cv::cuda::Feature2DAsync* instance, const cv::_InputArray* image, const cv::_InputArray* mask, const cv::_OutputArray* keypoints, const cv::_OutputArray* descriptors, bool useProvidedKeypoints, cv::cuda::Stream* stream) {
		try {
			instance->detectAndComputeAsync(*image, *mask, *keypoints, *descriptors, useProvidedKeypoints, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convert(cv::InputArray, std::vector<KeyPoint> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:416
	Result_void cv_cuda_Feature2DAsync_convert_const__InputArrayR_vector_KeyPoint_R(cv::cuda::Feature2DAsync* instance, const cv::_InputArray* gpu_keypoints, std::vector<cv::KeyPoint>* keypoints) {
		try {
			instance->convert(*gpu_keypoints, *keypoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, float, int, int, int, int, int, int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:463
	Result<cv::Ptr<cv::cuda::ORB>*> cv_cuda_ORB_create_int_float_int_int_int_int_int_int_int_bool(int nfeatures, float scaleFactor, int nlevels, int edgeThreshold, int firstLevel, int WTA_K, int scoreType, int patchSize, int fastThreshold, bool blurForDescriptor) {
		try {
			cv::Ptr<cv::cuda::ORB> ret = cv::cuda::ORB::create(nfeatures, scaleFactor, nlevels, edgeThreshold, firstLevel, WTA_K, scoreType, patchSize, fastThreshold, blurForDescriptor);
			return Ok(new cv::Ptr<cv::cuda::ORB>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::ORB>*>))
	}
	
	// setBlurForDescriptor(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:475
	Result_void cv_cuda_ORB_setBlurForDescriptor_bool(cv::cuda::ORB* instance, bool blurForDescriptor) {
		try {
			instance->setBlurForDescriptor(blurForDescriptor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBlurForDescriptor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:476
	Result<bool> cv_cuda_ORB_getBlurForDescriptor_const(const cv::cuda::ORB* instance) {
		try {
			bool ret = instance->getBlurForDescriptor();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setFastThreshold(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:478
	Result_void cv_cuda_ORB_setFastThreshold_int(cv::cuda::ORB* instance, int fastThreshold) {
		try {
			instance->setFastThreshold(fastThreshold);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFastThreshold() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudafeatures2d.hpp:479
	Result<int> cv_cuda_ORB_getFastThreshold_const(const cv::cuda::ORB* instance) {
		try {
			int ret = instance->getFastThreshold();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
}
