#![allow(
	unused_parens,
	clippy::excessive_precision,
	clippy::missing_safety_doc,
	clippy::not_unsafe_ptr_arg_deref,
	clippy::should_implement_trait,
	clippy::too_many_arguments,
	clippy::unused_unit,
)]
//! # Video Encoding/Decoding
use crate::{mod_prelude::*, core, sys, types};
pub mod prelude {
	pub use { super::EncoderParamsTraitConst, super::EncoderParamsTrait, super::EncoderCallBackConst, super::EncoderCallBack, super::VideoWriterConst, super::VideoWriter, super::VideoReaderConst, super::VideoReader, super::RawVideoSourceConst, super::RawVideoSource };
}

// AV1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:258
pub const AV1: i32 = 11;
// H264 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:251
pub const H264: i32 = 4;
// H264_MVC /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:254
pub const H264_MVC: i32 = 7;
// H264_SVC /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:253
pub const H264_SVC: i32 = 6;
// HEVC /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:255
pub const HEVC: i32 = 8;
// JPEG /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:252
pub const JPEG: i32 = 5;
// MPEG1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:247
pub const MPEG1: i32 = 0;
// MPEG2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:248
pub const MPEG2: i32 = 1;
// MPEG4 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:249
pub const MPEG4: i32 = 2;
// Monochrome /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:272
pub const Monochrome: i32 = 0;
// NumCodecs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:259
pub const NumCodecs: i32 = 12;
// NumFormats /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:276
pub const NumFormats: i32 = 4;
// SF_BGR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:79
pub const SF_BGR: i32 = 5;
// SF_GRAY /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:80
pub const SF_GRAY: i32 = 5;
// SF_IYUV /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:78
pub const SF_IYUV: i32 = 4;
// SF_NV12 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:77
pub const SF_NV12: i32 = 3;
// SF_UYVY /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:74
pub const SF_UYVY: i32 = 0;
// SF_YUY2 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:75
pub const SF_YUY2: i32 = 1;
// SF_YV12 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:76
pub const SF_YV12: i32 = 2;
/// Y,UV  (4:2:0)
// Uncompressed_NV12 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:263
pub const Uncompressed_NV12: i32 = 1314271538;
/// UYVY (4:2:2)
// Uncompressed_UYVY /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:265
pub const Uncompressed_UYVY: i32 = 1431918169;
/// Y,U,V (4:2:0)
// Uncompressed_YUV420 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:261
pub const Uncompressed_YUV420: i32 = 1230591318;
/// YUYV/YUY2 (4:2:2)
// Uncompressed_YUYV /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:264
pub const Uncompressed_YUYV: i32 = 1498765654;
/// Y,V,U (4:2:0)
// Uncompressed_YV12 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:262
pub const Uncompressed_YV12: i32 = 1498820914;
// VC1 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:250
pub const VC1: i32 = 3;
// VP8 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:256
pub const VP8: i32 = 9;
// VP9 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:257
pub const VP9: i32 = 10;
// YUV420 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:273
pub const YUV420: i32 = 1;
// YUV422 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:274
pub const YUV422: i32 = 2;
// YUV444 /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:275
pub const YUV444: i32 = 3;
/// Chroma formats supported by cudacodec::VideoReader .
// ChromaFormat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:270
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum ChromaFormat {
	Monochrome = 0,
	YUV420 = 1,
	YUV422 = 2,
	YUV444 = 3,
	NumFormats = 4,
}

opencv_type_enum! { crate::cudacodec::ChromaFormat }

/// Video codecs supported by cudacodec::VideoReader .
// Codec /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:245
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum Codec {
	MPEG1 = 0,
	MPEG2 = 1,
	MPEG4 = 2,
	VC1 = 3,
	H264 = 4,
	JPEG = 5,
	H264_SVC = 6,
	H264_MVC = 7,
	HEVC = 8,
	VP8 = 9,
	VP9 = 10,
	AV1 = 11,
	NumCodecs = 12,
	/// Y,U,V (4:2:0)
	Uncompressed_YUV420 = 1230591318,
	/// Y,V,U (4:2:0)
	Uncompressed_YV12 = 1498820914,
	/// Y,UV  (4:2:0)
	Uncompressed_NV12 = 1314271538,
	/// YUYV/YUY2 (4:2:2)
	Uncompressed_YUYV = 1498765654,
	/// UYVY (4:2:2)
	Uncompressed_UYVY = 1431918169,
}

opencv_type_enum! { crate::cudacodec::Codec }

// PicType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:133
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum EncoderCallBack_PicType {
	IFRAME = 1,
	PFRAME = 2,
	BFRAME = 3,
}

opencv_type_enum! { crate::cudacodec::EncoderCallBack_PicType }

/// /////////////////////////////// Video Encoding //////////////////////////////////
// SurfaceFormat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:72
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub enum SurfaceFormat {
	SF_UYVY = 0,
	SF_YUY2 = 1,
	SF_YV12 = 2,
	SF_NV12 = 3,
	SF_IYUV = 4,
	SF_BGR = 5,
	// SF_GRAY = 5 as isize, // duplicate discriminant
}

opencv_type_enum! { crate::cudacodec::SurfaceFormat }

/// Creates video reader.
/// 
/// ## Parameters
/// * filename: Name of the input video file.
/// 
/// FFMPEG is used to read videos. User can implement own demultiplexing with cudacodec::RawVideoSource
/// 
/// ## Overloaded parameters
/// 
/// * source: RAW video source implemented by user.
// createVideoReader(const Ptr<cv::cudacodec::RawVideoSource> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:350
#[inline]
pub fn create_video_reader_1(source: &core::Ptr<dyn crate::cudacodec::RawVideoSource>) -> Result<core::Ptr<dyn crate::cudacodec::VideoReader>> {
	let ret = unsafe { sys::cv_cudacodec_createVideoReader_const_Ptr_RawVideoSource_R(source.as_raw_PtrOfRawVideoSource()) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoReader>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates video reader.
/// 
/// ## Parameters
/// * filename: Name of the input video file.
/// 
/// FFMPEG is used to read videos. User can implement own demultiplexing with cudacodec::RawVideoSource
// createVideoReader(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:346
#[inline]
pub fn create_video_reader(filename: &str) -> Result<core::Ptr<dyn crate::cudacodec::VideoReader>> {
	extern_container_arg!(filename);
	let ret = unsafe { sys::cv_cudacodec_createVideoReader_const_StringR(filename.opencv_as_extern()) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoReader>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates video writer.
/// 
/// ## Parameters
/// * fileName: Name of the output video file. Only AVI file format is supported.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// The constructors initialize video writer. FFMPEG is used to write videos. User can implement own
/// multiplexing with cudacodec::EncoderCallBack .
/// 
/// ## Overloaded parameters
/// 
/// * encoderCallback: Callbacks for video encoder. See cudacodec::EncoderCallBack . Use it if you
/// want to work with raw video stream.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// ## C++ default parameters
/// * format: SF_BGR
// createVideoWriter(const Ptr<cv::cudacodec::EncoderCallBack> &, cv::Size, double, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:228
#[inline]
pub fn create_video_writer_2(encoder_callback: &core::Ptr<dyn crate::cudacodec::EncoderCallBack>, frame_size: core::Size, fps: f64, format: crate::cudacodec::SurfaceFormat) -> Result<core::Ptr<dyn crate::cudacodec::VideoWriter>> {
	let ret = unsafe { sys::cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_SurfaceFormat(encoder_callback.as_raw_PtrOfEncoderCallBack(), frame_size.opencv_as_extern(), fps, format) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoWriter>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates video writer.
/// 
/// ## Parameters
/// * fileName: Name of the output video file. Only AVI file format is supported.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// The constructors initialize video writer. FFMPEG is used to write videos. User can implement own
/// multiplexing with cudacodec::EncoderCallBack .
/// 
/// ## Overloaded parameters
/// 
/// * encoderCallback: Callbacks for video encoder. See cudacodec::EncoderCallBack . Use it if you
/// want to work with raw video stream.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * params: Encoder parameters. See cudacodec::EncoderParams .
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// ## C++ default parameters
/// * format: SF_BGR
// createVideoWriter(const Ptr<cv::cudacodec::EncoderCallBack> &, cv::Size, double, const cv::cudacodec::EncoderParams &, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:239
#[inline]
pub fn create_video_writer_3(encoder_callback: &core::Ptr<dyn crate::cudacodec::EncoderCallBack>, frame_size: core::Size, fps: f64, params: &crate::cudacodec::EncoderParams, format: crate::cudacodec::SurfaceFormat) -> Result<core::Ptr<dyn crate::cudacodec::VideoWriter>> {
	let ret = unsafe { sys::cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_const_EncoderParamsR_SurfaceFormat(encoder_callback.as_raw_PtrOfEncoderCallBack(), frame_size.opencv_as_extern(), fps, params.as_raw_EncoderParams(), format) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoWriter>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates video writer.
/// 
/// ## Parameters
/// * fileName: Name of the output video file. Only AVI file format is supported.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// The constructors initialize video writer. FFMPEG is used to write videos. User can implement own
/// multiplexing with cudacodec::EncoderCallBack .
/// 
/// ## C++ default parameters
/// * format: SF_BGR
// createVideoWriter(const cv::String &, cv::Size, double, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:207
#[inline]
pub fn create_video_writer(file_name: &str, frame_size: core::Size, fps: f64, format: crate::cudacodec::SurfaceFormat) -> Result<core::Ptr<dyn crate::cudacodec::VideoWriter>> {
	extern_container_arg!(file_name);
	let ret = unsafe { sys::cv_cudacodec_createVideoWriter_const_StringR_Size_double_SurfaceFormat(file_name.opencv_as_extern(), frame_size.opencv_as_extern(), fps, format) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoWriter>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Creates video writer.
/// 
/// ## Parameters
/// * fileName: Name of the output video file. Only AVI file format is supported.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// The constructors initialize video writer. FFMPEG is used to write videos. User can implement own
/// multiplexing with cudacodec::EncoderCallBack .
/// 
/// ## Overloaded parameters
/// 
/// * fileName: Name of the output video file. Only AVI file format is supported.
/// * frameSize: Size of the input video frames.
/// * fps: Framerate of the created video stream.
/// * params: Encoder parameters. See cudacodec::EncoderParams .
/// * format: Surface format of input frames ( SF_UYVY , SF_YUY2 , SF_YV12 , SF_NV12 ,
/// SF_IYUV , SF_BGR or SF_GRAY). BGR or gray frames will be converted to YV12 format before
/// encoding, frames with other formats will be used as is.
/// 
/// ## C++ default parameters
/// * format: SF_BGR
// createVideoWriter(const cv::String &, cv::Size, double, const cv::cudacodec::EncoderParams &, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:217
#[inline]
pub fn create_video_writer_1(file_name: &str, frame_size: core::Size, fps: f64, params: &crate::cudacodec::EncoderParams, format: crate::cudacodec::SurfaceFormat) -> Result<core::Ptr<dyn crate::cudacodec::VideoWriter>> {
	extern_container_arg!(file_name);
	let ret = unsafe { sys::cv_cudacodec_createVideoWriter_const_StringR_Size_double_const_EncoderParamsR_SurfaceFormat(file_name.opencv_as_extern(), frame_size.opencv_as_extern(), fps, params.as_raw_EncoderParams(), format) }.into_result()?;
	let ret = unsafe { core::Ptr::<dyn crate::cudacodec::VideoWriter>::opencv_from_extern(ret) };
	Ok(ret)
}

/// Callbacks for CUDA video encoder.
// EncoderCallBack /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:130
pub trait EncoderCallBackConst {
	fn as_raw_EncoderCallBack(&self) -> *const c_void;

}

pub trait EncoderCallBack: crate::cudacodec::EncoderCallBackConst {
	fn as_raw_mut_EncoderCallBack(&mut self) -> *mut c_void;

	/// Callback function to signal the start of bitstream that is to be encoded.
	/// 
	/// Callback must allocate buffer for CUDA encoder and return pointer to it and it's size.
	// acquireBitStream(int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:146
	#[inline]
	fn acquire_bit_stream(&mut self, buffer_size: &mut i32) -> Result<&mut u8> {
		let ret = unsafe { sys::cv_cudacodec_EncoderCallBack_acquireBitStream_intX(self.as_raw_mut_EncoderCallBack(), buffer_size) }.into_result()?;
		let ret = unsafe { ret.as_mut() }.ok_or_else(|| Error::new(core::StsNullPtr, "Function returned Null pointer".to_string()))?;
		Ok(ret)
	}
	
	/// Callback function to signal that the encoded bitstream is ready to be written to file.
	// releaseBitStream(unsigned char *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:150
	#[inline]
	fn release_bit_stream(&mut self, data: &mut u8, size: i32) -> Result<()> {
		let ret = unsafe { sys::cv_cudacodec_EncoderCallBack_releaseBitStream_unsigned_charX_int(self.as_raw_mut_EncoderCallBack(), data, size) }.into_result()?;
		Ok(ret)
	}
	
	/// Callback function to signal that the encoding operation on the frame has started.
	/// 
	/// ## Parameters
	/// * frameNumber: 
	/// * picType: Specify frame type (I-Frame, P-Frame or B-Frame).
	// onBeginFrame(int, EncoderCallBack::PicType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:157
	#[inline]
	fn on_begin_frame(&mut self, frame_number: i32, pic_type: crate::cudacodec::EncoderCallBack_PicType) -> Result<()> {
		let ret = unsafe { sys::cv_cudacodec_EncoderCallBack_onBeginFrame_int_PicType(self.as_raw_mut_EncoderCallBack(), frame_number, pic_type) }.into_result()?;
		Ok(ret)
	}
	
	/// Callback function signals that the encoding operation on the frame has finished.
	/// 
	/// ## Parameters
	/// * frameNumber: 
	/// * picType: Specify frame type (I-Frame, P-Frame or B-Frame).
	// onEndFrame(int, EncoderCallBack::PicType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:164
	#[inline]
	fn on_end_frame(&mut self, frame_number: i32, pic_type: crate::cudacodec::EncoderCallBack_PicType) -> Result<()> {
		let ret = unsafe { sys::cv_cudacodec_EncoderCallBack_onEndFrame_int_PicType(self.as_raw_mut_EncoderCallBack(), frame_number, pic_type) }.into_result()?;
		Ok(ret)
	}
	
}

/// Different parameters for CUDA video encoder.
// EncoderParams /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:85
pub trait EncoderParamsTraitConst {
	fn as_raw_EncoderParams(&self) -> *const c_void;

	/// NVVE_P_INTERVAL,
	// P_Interval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:87
	#[inline]
	fn p_interval(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropP_Interval_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_IDR_PERIOD,
	// IDR_Period /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:88
	#[inline]
	fn idr_period(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropIDR_Period_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_DYNAMIC_GOP,
	// DynamicGOP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:89
	#[inline]
	fn dynamic_gop(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropDynamicGOP_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_RC_TYPE,
	// RCType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:90
	#[inline]
	fn rc_type(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropRCType_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_AVG_BITRATE,
	// AvgBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:91
	#[inline]
	fn avg_bitrate(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropAvgBitrate_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_PEAK_BITRATE,
	// PeakBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:92
	#[inline]
	fn peak_bitrate(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropPeakBitrate_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTRA,
	// QP_Level_Intra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:93
	#[inline]
	fn qp_level_intra(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropQP_Level_Intra_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTER_P,
	// QP_Level_InterP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:94
	#[inline]
	fn qp_level_inter_p(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropQP_Level_InterP_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTER_B,
	// QP_Level_InterB /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:95
	#[inline]
	fn qp_level_inter_b(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropQP_Level_InterB_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_DEBLOCK_MODE,
	// DeblockMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:96
	#[inline]
	fn deblock_mode(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropDeblockMode_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_PROFILE_LEVEL,
	// ProfileLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:97
	#[inline]
	fn profile_level(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropProfileLevel_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_FORCE_INTRA,
	// ForceIntra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:98
	#[inline]
	fn force_intra(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropForceIntra_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_FORCE_IDR,
	// ForceIDR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:99
	#[inline]
	fn force_idr(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropForceIDR_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_CLEAR_STAT,
	// ClearStat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:100
	#[inline]
	fn clear_stat(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropClearStat_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_SET_DEINTERLACE,
	// DIMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:101
	#[inline]
	fn di_mode(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropDIMode_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_PRESETS,
	// Presets /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:102
	#[inline]
	fn presets(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropPresets_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_DISABLE_CABAC,
	// DisableCabac /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:103
	#[inline]
	fn disable_cabac(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropDisableCabac_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_CONFIGURE_NALU_FRAMING_TYPE
	// NaluFramingType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:104
	#[inline]
	fn nalu_framing_type(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropNaluFramingType_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// NVVE_DISABLE_SPS_PPS
	// DisableSPSPPS /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:105
	#[inline]
	fn disable_spspps(&self) -> i32 {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_getPropDisableSPSPPS_const(self.as_raw_EncoderParams()) };
		ret
	}
	
	/// Saves parameters to config file.
	/// 
	/// ## Parameters
	/// * configFile: Config file name.
	// save(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:125
	#[inline]
	fn save(&self, config_file: &str) -> Result<()> {
		extern_container_arg!(config_file);
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_save_const_const_StringR(self.as_raw_EncoderParams(), config_file.opencv_as_extern()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait EncoderParamsTrait: crate::cudacodec::EncoderParamsTraitConst {
	fn as_raw_mut_EncoderParams(&mut self) -> *mut c_void;

	/// NVVE_P_INTERVAL,
	// P_Interval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:87
	#[inline]
	fn set_p_interval(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropP_Interval_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_IDR_PERIOD,
	// IDR_Period /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:88
	#[inline]
	fn set_idr_period(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropIDR_Period_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_DYNAMIC_GOP,
	// DynamicGOP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:89
	#[inline]
	fn set_dynamic_gop(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropDynamicGOP_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_RC_TYPE,
	// RCType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:90
	#[inline]
	fn set_rc_type(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropRCType_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_AVG_BITRATE,
	// AvgBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:91
	#[inline]
	fn set_avg_bitrate(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropAvgBitrate_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_PEAK_BITRATE,
	// PeakBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:92
	#[inline]
	fn set_peak_bitrate(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropPeakBitrate_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTRA,
	// QP_Level_Intra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:93
	#[inline]
	fn set_qp_level_intra(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropQP_Level_Intra_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTER_P,
	// QP_Level_InterP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:94
	#[inline]
	fn set_qp_level_inter_p(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropQP_Level_InterP_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_QP_LEVEL_INTER_B,
	// QP_Level_InterB /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:95
	#[inline]
	fn set_qp_level_inter_b(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropQP_Level_InterB_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_DEBLOCK_MODE,
	// DeblockMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:96
	#[inline]
	fn set_deblock_mode(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropDeblockMode_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_PROFILE_LEVEL,
	// ProfileLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:97
	#[inline]
	fn set_profile_level(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropProfileLevel_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_FORCE_INTRA,
	// ForceIntra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:98
	#[inline]
	fn set_force_intra(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropForceIntra_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_FORCE_IDR,
	// ForceIDR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:99
	#[inline]
	fn set_force_idr(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropForceIDR_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_CLEAR_STAT,
	// ClearStat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:100
	#[inline]
	fn set_clear_stat(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropClearStat_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_SET_DEINTERLACE,
	// DIMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:101
	#[inline]
	fn set_di_mode(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropDIMode_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_PRESETS,
	// Presets /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:102
	#[inline]
	fn set_presets(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropPresets_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_DISABLE_CABAC,
	// DisableCabac /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:103
	#[inline]
	fn set_disable_cabac(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropDisableCabac_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_CONFIGURE_NALU_FRAMING_TYPE
	// NaluFramingType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:104
	#[inline]
	fn set_nalu_framing_type(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropNaluFramingType_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// NVVE_DISABLE_SPS_PPS
	// DisableSPSPPS /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:105
	#[inline]
	fn set_disable_spspps(&mut self, val: i32) {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_setPropDisableSPSPPS_int(self.as_raw_mut_EncoderParams(), val) };
		ret
	}
	
	/// Reads parameters from config file.
	/// 
	/// ## Parameters
	/// * configFile: Config file name.
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:120
	#[inline]
	fn load(&mut self, config_file: &str) -> Result<()> {
		extern_container_arg!(config_file);
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_load_const_StringR(self.as_raw_mut_EncoderParams(), config_file.opencv_as_extern()) }.into_result()?;
		Ok(ret)
	}
	
}

/// Different parameters for CUDA video encoder.
// EncoderParams /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:85
pub struct EncoderParams {
	ptr: *mut c_void
}

opencv_type_boxed! { EncoderParams }

impl Drop for EncoderParams {
	fn drop(&mut self) {
		extern "C" { fn cv_EncoderParams_delete(instance: *mut c_void); }
		unsafe { cv_EncoderParams_delete(self.as_raw_mut_EncoderParams()) };
	}
}

unsafe impl Send for EncoderParams {}

impl crate::cudacodec::EncoderParamsTraitConst for EncoderParams {
	#[inline] fn as_raw_EncoderParams(&self) -> *const c_void { self.as_raw() }
}

impl crate::cudacodec::EncoderParamsTrait for EncoderParams {
	#[inline] fn as_raw_mut_EncoderParams(&mut self) -> *mut c_void { self.as_raw_mut() }
}

impl EncoderParams {
	// EncoderParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:107
	#[inline]
	pub fn default() -> Result<crate::cudacodec::EncoderParams> {
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_EncoderParams() }.into_result()?;
		let ret = unsafe { crate::cudacodec::EncoderParams::opencv_from_extern(ret) };
		Ok(ret)
	}
	
	/// Constructors.
	/// 
	/// ## Parameters
	/// * configFile: Config file name.
	/// 
	/// Creates default parameters or reads parameters from config file.
	// EncoderParams(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:114
	#[inline]
	pub fn new(config_file: &str) -> Result<crate::cudacodec::EncoderParams> {
		extern_container_arg!(config_file);
		let ret = unsafe { sys::cv_cudacodec_EncoderParams_EncoderParams_const_StringR(config_file.opencv_as_extern()) }.into_result()?;
		let ret = unsafe { crate::cudacodec::EncoderParams::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

/// Struct providing information about video file format. :
// FormatInfo /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:281
#[repr(C)]
#[derive(Copy, Clone, Debug, PartialEq)]
pub struct FormatInfo {
	pub codec: crate::cudacodec::Codec,
	pub chroma_format: crate::cudacodec::ChromaFormat,
	pub n_bit_depth_minus8: i32,
	/// Width of the decoded frame returned by nextFrame(frame)
	pub width: i32,
	/// Height of the decoded frame returned by nextFrame(frame)
	pub height: i32,
	/// ROI inside the decoded frame returned by nextFrame(frame), containing the useable video frame.
	pub display_area: core::Rect,
	pub valid: bool,
}

opencv_type_simple! { crate::cudacodec::FormatInfo }

impl FormatInfo {
}

/// Interface for video demultiplexing. :
/// 
/// User can implement own demultiplexing by implementing this interface.
// RawVideoSource /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:319
pub trait RawVideoSourceConst {
	fn as_raw_RawVideoSource(&self) -> *const c_void;

	/// Returns information about video file format.
	// format() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:333
	#[inline]
	fn format(&self) -> Result<crate::cudacodec::FormatInfo> {
		let ret = unsafe { sys::cv_cudacodec_RawVideoSource_format_const(self.as_raw_RawVideoSource()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait RawVideoSource: crate::cudacodec::RawVideoSourceConst {
	fn as_raw_mut_RawVideoSource(&mut self) -> *mut c_void;

	/// Returns next packet with RAW video frame.
	/// 
	/// ## Parameters
	/// * data: Pointer to frame data.
	/// * size: Size in bytes of current frame.
	// getNextPacket(unsigned char **, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:329
	#[inline]
	fn get_next_packet(&mut self, data: &mut &mut u8, size: &mut size_t) -> Result<bool> {
		let ret = unsafe { sys::cv_cudacodec_RawVideoSource_getNextPacket_unsigned_charXX_size_tX(self.as_raw_mut_RawVideoSource(), data as *mut  _ as *mut  *mut  _, size) }.into_result()?;
		Ok(ret)
	}
	
	/// Updates the coded width and height inside format.
	// updateFormat(const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:337
	#[inline]
	fn update_format(&mut self, coded_width: i32, coded_height: i32) -> Result<()> {
		let ret = unsafe { sys::cv_cudacodec_RawVideoSource_updateFormat_const_int_const_int(self.as_raw_mut_RawVideoSource(), coded_width, coded_height) }.into_result()?;
		Ok(ret)
	}
	
}

/// Video reader interface.
/// 
/// 
/// Note:
///    *   An example on how to use the videoReader class can be found at
///        opencv_source_code/samples/gpu/video_reader.cpp
// VideoReader /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:298
pub trait VideoReaderConst {
	fn as_raw_VideoReader(&self) -> *const c_void;

	/// Returns information about video file format.
	// format() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:312
	#[inline]
	fn format(&self) -> Result<crate::cudacodec::FormatInfo> {
		let ret = unsafe { sys::cv_cudacodec_VideoReader_format_const(self.as_raw_VideoReader()) }.into_result()?;
		Ok(ret)
	}
	
}

pub trait VideoReader: crate::cudacodec::VideoReaderConst {
	fn as_raw_mut_VideoReader(&mut self) -> *mut c_void;

	/// Grabs, decodes and returns the next video frame.
	/// 
	/// If no frames has been grabbed (there are no more frames in video file), the methods return false .
	/// The method throws Exception if error occurs.
	/// 
	/// ## C++ default parameters
	/// * stream: Stream::Null()
	// nextFrame(cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:308
	#[inline]
	fn next_frame(&mut self, frame: &mut core::GpuMat, stream: &mut core::Stream) -> Result<bool> {
		let ret = unsafe { sys::cv_cudacodec_VideoReader_nextFrame_GpuMatR_StreamR(self.as_raw_mut_VideoReader(), frame.as_raw_mut_GpuMat(), stream.as_raw_mut_Stream()) }.into_result()?;
		Ok(ret)
	}
	
}

/// Video writer interface.
/// 
/// The implementation uses H264 video codec.
/// 
/// 
/// Note: Currently only Windows platform is supported.
/// 
/// 
/// Note:
///    *   An example on how to use the videoWriter class can be found at
///        opencv_source_code/samples/gpu/video_writer.cpp
// VideoWriter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:177
pub trait VideoWriterConst {
	fn as_raw_VideoWriter(&self) -> *const c_void;

	// getEncoderParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:192
	#[inline]
	fn get_encoder_params(&self) -> Result<crate::cudacodec::EncoderParams> {
		let ret = unsafe { sys::cv_cudacodec_VideoWriter_getEncoderParams_const(self.as_raw_VideoWriter()) }.into_result()?;
		let ret = unsafe { crate::cudacodec::EncoderParams::opencv_from_extern(ret) };
		Ok(ret)
	}
	
}

pub trait VideoWriter: crate::cudacodec::VideoWriterConst {
	fn as_raw_mut_VideoWriter(&mut self) -> *mut c_void;

	/// Writes the next video frame.
	/// 
	/// ## Parameters
	/// * frame: The written frame.
	/// * lastFrame: Indicates that it is end of stream. The parameter can be ignored.
	/// 
	/// The method write the specified image to video file. The image must have the same size and the same
	/// surface format as has been specified when opening the video writer.
	/// 
	/// ## C++ default parameters
	/// * last_frame: false
	// write(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:190
	#[inline]
	fn write(&mut self, frame: &dyn core::ToInputArray, last_frame: bool) -> Result<()> {
		input_array_arg!(frame);
		let ret = unsafe { sys::cv_cudacodec_VideoWriter_write_const__InputArrayR_bool(self.as_raw_mut_VideoWriter(), frame.as_raw__InputArray(), last_frame) }.into_result()?;
		Ok(ret)
	}
	
}
