#include "ocvrs_common.hpp"
#include <opencv2/cudacodec.hpp>
#include "cudacodec_types.hpp"

extern "C" {
	// createVideoReader(const Ptr<cv::cudacodec::RawVideoSource> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:350
	Result<cv::Ptr<cv::cudacodec::VideoReader>*> cv_cudacodec_createVideoReader_const_Ptr_RawVideoSource_R(const cv::Ptr<cv::cudacodec::RawVideoSource>* source) {
		try {
			cv::Ptr<cv::cudacodec::VideoReader> ret = cv::cudacodec::createVideoReader(*source);
			return Ok(new cv::Ptr<cv::cudacodec::VideoReader>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoReader>*>))
	}
	
	// createVideoReader(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:346
	Result<cv::Ptr<cv::cudacodec::VideoReader>*> cv_cudacodec_createVideoReader_const_StringR(const char* filename) {
		try {
			cv::Ptr<cv::cudacodec::VideoReader> ret = cv::cudacodec::createVideoReader(std::string(filename));
			return Ok(new cv::Ptr<cv::cudacodec::VideoReader>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoReader>*>))
	}
	
	// createVideoWriter(const Ptr<cv::cudacodec::EncoderCallBack> &, cv::Size, double, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:228
	Result<cv::Ptr<cv::cudacodec::VideoWriter>*> cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_SurfaceFormat(const cv::Ptr<cv::cudacodec::EncoderCallBack>* encoderCallback, cv::Size* frameSize, double fps, cv::cudacodec::SurfaceFormat format) {
		try {
			cv::Ptr<cv::cudacodec::VideoWriter> ret = cv::cudacodec::createVideoWriter(*encoderCallback, *frameSize, fps, format);
			return Ok(new cv::Ptr<cv::cudacodec::VideoWriter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoWriter>*>))
	}
	
	// createVideoWriter(const Ptr<cv::cudacodec::EncoderCallBack> &, cv::Size, double, const cv::cudacodec::EncoderParams &, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:239
	Result<cv::Ptr<cv::cudacodec::VideoWriter>*> cv_cudacodec_createVideoWriter_const_Ptr_EncoderCallBack_R_Size_double_const_EncoderParamsR_SurfaceFormat(const cv::Ptr<cv::cudacodec::EncoderCallBack>* encoderCallback, cv::Size* frameSize, double fps, const cv::cudacodec::EncoderParams* params, cv::cudacodec::SurfaceFormat format) {
		try {
			cv::Ptr<cv::cudacodec::VideoWriter> ret = cv::cudacodec::createVideoWriter(*encoderCallback, *frameSize, fps, *params, format);
			return Ok(new cv::Ptr<cv::cudacodec::VideoWriter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoWriter>*>))
	}
	
	// createVideoWriter(const cv::String &, cv::Size, double, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:207
	Result<cv::Ptr<cv::cudacodec::VideoWriter>*> cv_cudacodec_createVideoWriter_const_StringR_Size_double_SurfaceFormat(const char* fileName, cv::Size* frameSize, double fps, cv::cudacodec::SurfaceFormat format) {
		try {
			cv::Ptr<cv::cudacodec::VideoWriter> ret = cv::cudacodec::createVideoWriter(std::string(fileName), *frameSize, fps, format);
			return Ok(new cv::Ptr<cv::cudacodec::VideoWriter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoWriter>*>))
	}
	
	// createVideoWriter(const cv::String &, cv::Size, double, const cv::cudacodec::EncoderParams &, cv::cudacodec::SurfaceFormat) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:217
	Result<cv::Ptr<cv::cudacodec::VideoWriter>*> cv_cudacodec_createVideoWriter_const_StringR_Size_double_const_EncoderParamsR_SurfaceFormat(const char* fileName, cv::Size* frameSize, double fps, const cv::cudacodec::EncoderParams* params, cv::cudacodec::SurfaceFormat format) {
		try {
			cv::Ptr<cv::cudacodec::VideoWriter> ret = cv::cudacodec::createVideoWriter(std::string(fileName), *frameSize, fps, *params, format);
			return Ok(new cv::Ptr<cv::cudacodec::VideoWriter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cudacodec::VideoWriter>*>))
	}
	
	// acquireBitStream(int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:146
	Result<unsigned char*> cv_cudacodec_EncoderCallBack_acquireBitStream_intX(cv::cudacodec::EncoderCallBack* instance, int* bufferSize) {
		try {
			unsigned char* ret = instance->acquireBitStream(bufferSize);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// releaseBitStream(unsigned char *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:150
	Result_void cv_cudacodec_EncoderCallBack_releaseBitStream_unsigned_charX_int(cv::cudacodec::EncoderCallBack* instance, unsigned char* data, int size) {
		try {
			instance->releaseBitStream(data, size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// onBeginFrame(int, EncoderCallBack::PicType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:157
	Result_void cv_cudacodec_EncoderCallBack_onBeginFrame_int_PicType(cv::cudacodec::EncoderCallBack* instance, int frameNumber, cv::cudacodec::EncoderCallBack::PicType picType) {
		try {
			instance->onBeginFrame(frameNumber, picType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// onEndFrame(int, EncoderCallBack::PicType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:164
	Result_void cv_cudacodec_EncoderCallBack_onEndFrame_int_PicType(cv::cudacodec::EncoderCallBack* instance, int frameNumber, cv::cudacodec::EncoderCallBack::PicType picType) {
		try {
			instance->onEndFrame(frameNumber, picType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// P_Interval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:87
	int cv_cudacodec_EncoderParams_getPropP_Interval_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->P_Interval;
		return (int)ret;
	}
	
	// P_Interval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:87
	void cv_cudacodec_EncoderParams_setPropP_Interval_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->P_Interval = val;
	}
	
	// IDR_Period /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:88
	int cv_cudacodec_EncoderParams_getPropIDR_Period_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->IDR_Period;
		return (int)ret;
	}
	
	// IDR_Period /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:88
	void cv_cudacodec_EncoderParams_setPropIDR_Period_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->IDR_Period = val;
	}
	
	// DynamicGOP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:89
	int cv_cudacodec_EncoderParams_getPropDynamicGOP_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->DynamicGOP;
		return (int)ret;
	}
	
	// DynamicGOP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:89
	void cv_cudacodec_EncoderParams_setPropDynamicGOP_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->DynamicGOP = val;
	}
	
	// RCType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:90
	int cv_cudacodec_EncoderParams_getPropRCType_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->RCType;
		return (int)ret;
	}
	
	// RCType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:90
	void cv_cudacodec_EncoderParams_setPropRCType_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->RCType = val;
	}
	
	// AvgBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:91
	int cv_cudacodec_EncoderParams_getPropAvgBitrate_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->AvgBitrate;
		return (int)ret;
	}
	
	// AvgBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:91
	void cv_cudacodec_EncoderParams_setPropAvgBitrate_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->AvgBitrate = val;
	}
	
	// PeakBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:92
	int cv_cudacodec_EncoderParams_getPropPeakBitrate_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->PeakBitrate;
		return (int)ret;
	}
	
	// PeakBitrate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:92
	void cv_cudacodec_EncoderParams_setPropPeakBitrate_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->PeakBitrate = val;
	}
	
	// QP_Level_Intra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:93
	int cv_cudacodec_EncoderParams_getPropQP_Level_Intra_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->QP_Level_Intra;
		return (int)ret;
	}
	
	// QP_Level_Intra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:93
	void cv_cudacodec_EncoderParams_setPropQP_Level_Intra_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->QP_Level_Intra = val;
	}
	
	// QP_Level_InterP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:94
	int cv_cudacodec_EncoderParams_getPropQP_Level_InterP_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->QP_Level_InterP;
		return (int)ret;
	}
	
	// QP_Level_InterP /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:94
	void cv_cudacodec_EncoderParams_setPropQP_Level_InterP_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->QP_Level_InterP = val;
	}
	
	// QP_Level_InterB /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:95
	int cv_cudacodec_EncoderParams_getPropQP_Level_InterB_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->QP_Level_InterB;
		return (int)ret;
	}
	
	// QP_Level_InterB /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:95
	void cv_cudacodec_EncoderParams_setPropQP_Level_InterB_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->QP_Level_InterB = val;
	}
	
	// DeblockMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:96
	int cv_cudacodec_EncoderParams_getPropDeblockMode_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->DeblockMode;
		return (int)ret;
	}
	
	// DeblockMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:96
	void cv_cudacodec_EncoderParams_setPropDeblockMode_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->DeblockMode = val;
	}
	
	// ProfileLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:97
	int cv_cudacodec_EncoderParams_getPropProfileLevel_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->ProfileLevel;
		return (int)ret;
	}
	
	// ProfileLevel /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:97
	void cv_cudacodec_EncoderParams_setPropProfileLevel_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->ProfileLevel = val;
	}
	
	// ForceIntra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:98
	int cv_cudacodec_EncoderParams_getPropForceIntra_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->ForceIntra;
		return (int)ret;
	}
	
	// ForceIntra /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:98
	void cv_cudacodec_EncoderParams_setPropForceIntra_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->ForceIntra = val;
	}
	
	// ForceIDR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:99
	int cv_cudacodec_EncoderParams_getPropForceIDR_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->ForceIDR;
		return (int)ret;
	}
	
	// ForceIDR /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:99
	void cv_cudacodec_EncoderParams_setPropForceIDR_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->ForceIDR = val;
	}
	
	// ClearStat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:100
	int cv_cudacodec_EncoderParams_getPropClearStat_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->ClearStat;
		return (int)ret;
	}
	
	// ClearStat /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:100
	void cv_cudacodec_EncoderParams_setPropClearStat_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->ClearStat = val;
	}
	
	// DIMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:101
	int cv_cudacodec_EncoderParams_getPropDIMode_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->DIMode;
		return (int)ret;
	}
	
	// DIMode /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:101
	void cv_cudacodec_EncoderParams_setPropDIMode_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->DIMode = val;
	}
	
	// Presets /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:102
	int cv_cudacodec_EncoderParams_getPropPresets_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->Presets;
		return (int)ret;
	}
	
	// Presets /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:102
	void cv_cudacodec_EncoderParams_setPropPresets_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->Presets = val;
	}
	
	// DisableCabac /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:103
	int cv_cudacodec_EncoderParams_getPropDisableCabac_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->DisableCabac;
		return (int)ret;
	}
	
	// DisableCabac /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:103
	void cv_cudacodec_EncoderParams_setPropDisableCabac_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->DisableCabac = val;
	}
	
	// NaluFramingType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:104
	int cv_cudacodec_EncoderParams_getPropNaluFramingType_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->NaluFramingType;
		return (int)ret;
	}
	
	// NaluFramingType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:104
	void cv_cudacodec_EncoderParams_setPropNaluFramingType_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->NaluFramingType = val;
	}
	
	// DisableSPSPPS /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:105
	int cv_cudacodec_EncoderParams_getPropDisableSPSPPS_const(const cv::cudacodec::EncoderParams* instance) {
		int ret = instance->DisableSPSPPS;
		return (int)ret;
	}
	
	// DisableSPSPPS /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:105
	void cv_cudacodec_EncoderParams_setPropDisableSPSPPS_int(cv::cudacodec::EncoderParams* instance, int val) {
		instance->DisableSPSPPS = val;
	}
	
	void cv_EncoderParams_delete(cv::cudacodec::EncoderParams* instance) {
		delete instance;
	}
	// EncoderParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:107
	Result<cv::cudacodec::EncoderParams*> cv_cudacodec_EncoderParams_EncoderParams() {
		try {
			cv::cudacodec::EncoderParams* ret = new cv::cudacodec::EncoderParams();
			return Ok<cv::cudacodec::EncoderParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cudacodec::EncoderParams*>))
	}
	
	// EncoderParams(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:114
	Result<cv::cudacodec::EncoderParams*> cv_cudacodec_EncoderParams_EncoderParams_const_StringR(const char* configFile) {
		try {
			cv::cudacodec::EncoderParams* ret = new cv::cudacodec::EncoderParams(std::string(configFile));
			return Ok<cv::cudacodec::EncoderParams*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cudacodec::EncoderParams*>))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:120
	Result_void cv_cudacodec_EncoderParams_load_const_StringR(cv::cudacodec::EncoderParams* instance, const char* configFile) {
		try {
			instance->load(std::string(configFile));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// save(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:125
	Result_void cv_cudacodec_EncoderParams_save_const_const_StringR(const cv::cudacodec::EncoderParams* instance, const char* configFile) {
		try {
			instance->save(std::string(configFile));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNextPacket(unsigned char **, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:329
	Result<bool> cv_cudacodec_RawVideoSource_getNextPacket_unsigned_charXX_size_tX(cv::cudacodec::RawVideoSource* instance, unsigned char** data, size_t* size) {
		try {
			bool ret = instance->getNextPacket(data, size);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// format() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:333
	Result<cv::cudacodec::FormatInfo> cv_cudacodec_RawVideoSource_format_const(const cv::cudacodec::RawVideoSource* instance) {
		try {
			cv::cudacodec::FormatInfo ret = instance->format();
			return Ok<cv::cudacodec::FormatInfo>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cudacodec::FormatInfo>))
	}
	
	// updateFormat(const int, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:337
	Result_void cv_cudacodec_RawVideoSource_updateFormat_const_int_const_int(cv::cudacodec::RawVideoSource* instance, const int codedWidth, const int codedHeight) {
		try {
			instance->updateFormat(codedWidth, codedHeight);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// nextFrame(cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:308
	Result<bool> cv_cudacodec_VideoReader_nextFrame_GpuMatR_StreamR(cv::cudacodec::VideoReader* instance, cv::cuda::GpuMat* frame, cv::cuda::Stream* stream) {
		try {
			bool ret = instance->nextFrame(*frame, *stream);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// format() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:312
	Result<cv::cudacodec::FormatInfo> cv_cudacodec_VideoReader_format_const(const cv::cudacodec::VideoReader* instance) {
		try {
			cv::cudacodec::FormatInfo ret = instance->format();
			return Ok<cv::cudacodec::FormatInfo>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cudacodec::FormatInfo>))
	}
	
	// write(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:190
	Result_void cv_cudacodec_VideoWriter_write_const__InputArrayR_bool(cv::cudacodec::VideoWriter* instance, const cv::_InputArray* frame, bool lastFrame) {
		try {
			instance->write(*frame, lastFrame);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getEncoderParams() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudacodec.hpp:192
	Result<cv::cudacodec::EncoderParams*> cv_cudacodec_VideoWriter_getEncoderParams_const(const cv::cudacodec::VideoWriter* instance) {
		try {
			cv::cudacodec::EncoderParams ret = instance->getEncoderParams();
			return Ok(new cv::cudacodec::EncoderParams(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cudacodec::EncoderParams*>))
	}
	
}
