#include "ocvrs_common.hpp"
#include <opencv2/cudabgsegm.hpp>
#include "cudabgsegm_types.hpp"

extern "C" {
	// createBackgroundSubtractorMOG2(int, double, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:155
	Result<cv::Ptr<cv::cuda::BackgroundSubtractorMOG2>*> cv_cuda_createBackgroundSubtractorMOG2_int_double_bool(int history, double varThreshold, bool detectShadows) {
		try {
			cv::Ptr<cv::cuda::BackgroundSubtractorMOG2> ret = cv::cuda::createBackgroundSubtractorMOG2(history, varThreshold, detectShadows);
			return Ok(new cv::Ptr<cv::cuda::BackgroundSubtractorMOG2>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::BackgroundSubtractorMOG2>*>))
	}
	
	// createBackgroundSubtractorMOG(int, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:116
	Result<cv::Ptr<cv::cuda::BackgroundSubtractorMOG>*> cv_cuda_createBackgroundSubtractorMOG_int_int_double_double(int history, int nmixtures, double backgroundRatio, double noiseSigma) {
		try {
			cv::Ptr<cv::cuda::BackgroundSubtractorMOG> ret = cv::cuda::createBackgroundSubtractorMOG(history, nmixtures, backgroundRatio, noiseSigma);
			return Ok(new cv::Ptr<cv::cuda::BackgroundSubtractorMOG>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::BackgroundSubtractorMOG>*>))
	}
	
	// apply(cv::InputArray, cv::OutputArray, double, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:85
	Result_void cv_cuda_BackgroundSubtractorMOG_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(cv::cuda::BackgroundSubtractorMOG* instance, const cv::_InputArray* image, const cv::_OutputArray* fgmask, double learningRate, cv::cuda::Stream* stream) {
		try {
			instance->apply(*image, *fgmask, learningRate, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundImage(cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:88
	Result_void cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_const_const__OutputArrayR_StreamR(const cv::cuda::BackgroundSubtractorMOG* instance, const cv::_OutputArray* backgroundImage, cv::cuda::Stream* stream) {
		try {
			instance->getBackgroundImage(*backgroundImage, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundImage(cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:90
	Result_void cv_cuda_BackgroundSubtractorMOG_getBackgroundImage_GpuMatR_StreamR(cv::cuda::BackgroundSubtractorMOG* instance, cv::cuda::GpuMat* backgroundImage, cv::cuda::Stream* stream) {
		try {
			instance->getBackgroundImage(*backgroundImage, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getHistory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:94
	Result<int> cv_cuda_BackgroundSubtractorMOG_getHistory_const(const cv::cuda::BackgroundSubtractorMOG* instance) {
		try {
			int ret = instance->getHistory();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setHistory(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:95
	Result_void cv_cuda_BackgroundSubtractorMOG_setHistory_int(cv::cuda::BackgroundSubtractorMOG* instance, int nframes) {
		try {
			instance->setHistory(nframes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNMixtures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:97
	Result<int> cv_cuda_BackgroundSubtractorMOG_getNMixtures_const(const cv::cuda::BackgroundSubtractorMOG* instance) {
		try {
			int ret = instance->getNMixtures();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNMixtures(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:98
	Result_void cv_cuda_BackgroundSubtractorMOG_setNMixtures_int(cv::cuda::BackgroundSubtractorMOG* instance, int nmix) {
		try {
			instance->setNMixtures(nmix);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundRatio() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:100
	Result<double> cv_cuda_BackgroundSubtractorMOG_getBackgroundRatio_const(const cv::cuda::BackgroundSubtractorMOG* instance) {
		try {
			double ret = instance->getBackgroundRatio();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setBackgroundRatio(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:101
	Result_void cv_cuda_BackgroundSubtractorMOG_setBackgroundRatio_double(cv::cuda::BackgroundSubtractorMOG* instance, double backgroundRatio) {
		try {
			instance->setBackgroundRatio(backgroundRatio);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getNoiseSigma() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:103
	Result<double> cv_cuda_BackgroundSubtractorMOG_getNoiseSigma_const(const cv::cuda::BackgroundSubtractorMOG* instance) {
		try {
			double ret = instance->getNoiseSigma();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// setNoiseSigma(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:104
	Result_void cv_cuda_BackgroundSubtractorMOG_setNoiseSigma_double(cv::cuda::BackgroundSubtractorMOG* instance, double noiseSigma) {
		try {
			instance->setNoiseSigma(noiseSigma);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// apply(cv::InputArray, cv::OutputArray, double, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:136
	Result_void cv_cuda_BackgroundSubtractorMOG2_apply_const__InputArrayR_const__OutputArrayR_double_StreamR(cv::cuda::BackgroundSubtractorMOG2* instance, const cv::_InputArray* image, const cv::_OutputArray* fgmask, double learningRate, cv::cuda::Stream* stream) {
		try {
			instance->apply(*image, *fgmask, learningRate, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundImage(cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:138
	Result_void cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_const_const__OutputArrayR_StreamR(const cv::cuda::BackgroundSubtractorMOG2* instance, const cv::_OutputArray* backgroundImage, cv::cuda::Stream* stream) {
		try {
			instance->getBackgroundImage(*backgroundImage, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBackgroundImage(cv::cuda::GpuMat &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudabgsegm.hpp:140
	Result_void cv_cuda_BackgroundSubtractorMOG2_getBackgroundImage_GpuMatR_StreamR(cv::cuda::BackgroundSubtractorMOG2* instance, cv::cuda::GpuMat* backgroundImage, cv::cuda::Stream* stream) {
		try {
			instance->getBackgroundImage(*backgroundImage, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
