#include "ocvrs_common.hpp"
#include <opencv2/cudaarithm.hpp>
#include "cudaarithm_types.hpp"

extern "C" {
	// absSum(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:599
	Result<cv::Scalar> cv_cuda_absSum_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputArray* mask) {
		try {
			cv::Scalar ret = cv::cuda::absSum(*src, *mask);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// abs(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:152
	Result_void cv_cuda_abs_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::abs(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// absdiff(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:142
	Result_void cv_cuda_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::absdiff(*src1, *src2, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addWeighted(cv::InputArray, double, cv::InputArray, double, double, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:338
	Result_void cv_cuda_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int_StreamR(const cv::_InputArray* src1, double alpha, const cv::_InputArray* src2, double beta, double gamma, const cv::_OutputArray* dst, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::addWeighted(*src1, alpha, *src2, beta, gamma, *dst, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// add(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:86
	Result_void cv_cuda_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::add(*src1, *src2, *dst, *mask, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_and(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:255
	Result_void cv_cuda_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::bitwise_and(*src1, *src2, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_not(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:233
	Result_void cv_cuda_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::bitwise_not(*src, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_or(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:244
	Result_void cv_cuda_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::bitwise_or(*src1, *src2, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_xor(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:266
	Result_void cv_cuda_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::bitwise_xor(*src1, *src2, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcAbsSum(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:601
	Result_void cv_cuda_calcAbsSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::calcAbsSum(*src, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcNormDiff(cv::InputArray, cv::InputArray, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:581
	Result_void cv_cuda_calcNormDiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int normType, cv::cuda::Stream* stream) {
		try {
			cv::cuda::calcNormDiff(*src1, *src2, *dst, normType, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcNorm(cv::InputArray, cv::OutputArray, int, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:569
	Result_void cv_cuda_calcNorm_const__InputArrayR_const__OutputArrayR_int_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, int normType, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::calcNorm(*src, *dst, normType, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcSqrSum(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:610
	Result_void cv_cuda_calcSqrSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::calcSqrSum(*src, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// calcSum(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:592
	Result_void cv_cuda_calcSum_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::calcSum(*src, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cartToPolar(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:447
	Result_void cv_cuda_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* magnitude, const cv::_OutputArray* angle, bool angleInDegrees, cv::cuda::Stream* stream) {
		try {
			cv::cuda::cartToPolar(*x, *y, *magnitude, *angle, angleInDegrees, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compare(cv::InputArray, cv::InputArray, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:223
	Result_void cv_cuda_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int cmpop, cv::cuda::Stream* stream) {
		try {
			cv::cuda::compare(*src1, *src2, *dst, cmpop, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyMakeBorder(cv::InputArray, cv::OutputArray, int, int, int, int, int, cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:551
	Result_void cv_cuda_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_Scalar_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, int top, int bottom, int left, int right, int borderType, cv::Scalar* value, cv::cuda::Stream* stream) {
		try {
			cv::cuda::copyMakeBorder(*src, *dst, top, bottom, left, right, borderType, *value, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// countNonZero(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:654
	Result<int> cv_cuda_countNonZero_const__InputArrayR(const cv::_InputArray* src) {
		try {
			int ret = cv::cuda::countNonZero(*src);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// countNonZero(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:656
	Result_void cv_cuda_countNonZero_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::countNonZero(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createConvolution(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:903
	Result<cv::Ptr<cv::cuda::Convolution>*> cv_cuda_createConvolution_Size(cv::Size* user_block_size) {
		try {
			cv::Ptr<cv::cuda::Convolution> ret = cv::cuda::createConvolution(*user_block_size);
			return Ok(new cv::Ptr<cv::cuda::Convolution>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::Convolution>*>))
	}
	
	// createDFT(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:877
	Result<cv::Ptr<cv::cuda::DFT>*> cv_cuda_createDFT_Size_int(cv::Size* dft_size, int flags) {
		try {
			cv::Ptr<cv::cuda::DFT> ret = cv::cuda::createDFT(*dft_size, flags);
			return Ok(new cv::Ptr<cv::cuda::DFT>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::DFT>*>))
	}
	
	// createLookUpTable(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:534
	Result<cv::Ptr<cv::cuda::LookUpTable>*> cv_cuda_createLookUpTable_const__InputArrayR(const cv::_InputArray* lut) {
		try {
			cv::Ptr<cv::cuda::LookUpTable> ret = cv::cuda::createLookUpTable(*lut);
			return Ok(new cv::Ptr<cv::cuda::LookUpTable>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::LookUpTable>*>))
	}
	
	// dft(cv::InputArray, cv::OutputArray, cv::Size, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:848
	Result_void cv_cuda_dft_const__InputArrayR_const__OutputArrayR_Size_int_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::Size* dft_size, int flags, cv::cuda::Stream* stream) {
		try {
			cv::cuda::dft(*src, *dst, *dft_size, flags, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// divide(cv::InputArray, cv::InputArray, cv::OutputArray, double, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:131
	Result_void cv_cuda_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, double scale, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::divide(*src1, *src2, *dst, scale, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// exp(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:180
	Result_void cv_cuda_exp_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::exp(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findMinMaxLoc(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:643
	Result_void cv_cuda_findMinMaxLoc_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* minMaxVals, const cv::_OutputArray* loc, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::findMinMaxLoc(*src, *minMaxVals, *loc, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findMinMax(cv::InputArray, cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:625
	Result_void cv_cuda_findMinMax_const__InputArrayR_const__OutputArrayR_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::findMinMax(*src, *dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flip(cv::InputArray, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:513
	Result_void cv_cuda_flip_const__InputArrayR_const__OutputArrayR_int_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, int flipCode, cv::cuda::Stream* stream) {
		try {
			cv::cuda::flip(*src, *dst, flipCode, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// gemm(cv::InputArray, cv::InputArray, double, cv::InputArray, double, cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:777
	Result_void cv_cuda_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, double alpha, const cv::_InputArray* src3, double beta, const cv::_OutputArray* dst, int flags, cv::cuda::Stream* stream) {
		try {
			cv::cuda::gemm(*src1, *src2, alpha, *src3, beta, *dst, flags, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inRange(cv::InputArray, const cv::Scalar &, const cv::Scalar &, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:384
	Result_void cv_cuda_inRange_const__InputArrayR_const_ScalarR_const_ScalarR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::Scalar* lowerb, const cv::Scalar* upperb, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::inRange(*src, *lowerb, *upperb, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// integral(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:736
	Result_void cv_cuda_integral_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* sum, cv::cuda::Stream* stream) {
		try {
			cv::cuda::integral(*src, *sum, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// log(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:190
	Result_void cv_cuda_log_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::log(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// lshift(cv::InputArray, Scalar_<int>, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:289
	Result_void cv_cuda_lshift_const__InputArrayR_Scalar__int__const__OutputArrayR_StreamR(const cv::_InputArray* src, cv::Scalar_<int>* val, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::lshift(*src, *val, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// lshift(cv::InputArray, cv::Scalar, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:291
	Result_void cv_cuda_lshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(const cv::_InputArray* src, cv::Scalar* val, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::lshift(*src, *val, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// magnitudeSqr(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:422
	Result_void cv_cuda_magnitudeSqr_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* magnitude, cv::cuda::Stream* stream) {
		try {
			cv::cuda::magnitudeSqr(*x, *y, *magnitude, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// magnitudeSqr(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:402
	Result_void cv_cuda_magnitudeSqr_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* xy, const cv::_OutputArray* magnitude, cv::cuda::Stream* stream) {
		try {
			cv::cuda::magnitudeSqr(*xy, *magnitude, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// magnitude(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:412
	Result_void cv_cuda_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* magnitude, cv::cuda::Stream* stream) {
		try {
			cv::cuda::magnitude(*x, *y, *magnitude, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// magnitude(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:394
	Result_void cv_cuda_magnitude_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* xy, const cv::_OutputArray* magnitude, cv::cuda::Stream* stream) {
		try {
			cv::cuda::magnitude(*xy, *magnitude, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// max(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:315
	Result_void cv_cuda_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::max(*src1, *src2, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// meanStdDev(cv::InputArray, cv::Scalar &, cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:694
	Result_void cv_cuda_meanStdDev_const__InputArrayR_ScalarR_ScalarR(const cv::_InputArray* mtx, cv::Scalar* mean, cv::Scalar* stddev) {
		try {
			cv::cuda::meanStdDev(*mtx, *mean, *stddev);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// meanStdDev(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:696
	Result_void cv_cuda_meanStdDev_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* mtx, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::meanStdDev(*mtx, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// merge(const cv::cuda::GpuMat *, size_t, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:474
	Result_void cv_cuda_merge_const_GpuMatX_size_t_const__OutputArrayR_StreamR(const cv::cuda::GpuMat* src, size_t n, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::merge(src, n, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// merge(const std::vector<GpuMat> &, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:476
	Result_void cv_cuda_merge_const_vector_GpuMat_R_const__OutputArrayR_StreamR(const std::vector<cv::cuda::GpuMat>* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::merge(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minMaxLoc(cv::InputArray, double *, double *, cv::Point *, cv::Point *, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:640
	Result_void cv_cuda_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(const cv::_InputArray* src, double* minVal, double* maxVal, cv::Point* minLoc, cv::Point* maxLoc, const cv::_InputArray* mask) {
		try {
			cv::cuda::minMaxLoc(*src, minVal, maxVal, minLoc, maxLoc, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minMax(cv::InputArray, double *, double *, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:623
	Result_void cv_cuda_minMax_const__InputArrayR_doubleX_doubleX_const__InputArrayR(const cv::_InputArray* src, double* minVal, double* maxVal, const cv::_InputArray* mask) {
		try {
			cv::cuda::minMax(*src, minVal, maxVal, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// min(cv::InputArray, cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:304
	Result_void cv_cuda_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::min(*src1, *src2, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mulAndScaleSpectrums(cv::InputArray, cv::InputArray, cv::OutputArray, int, float, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:811
	Result_void cv_cuda_mulAndScaleSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_float_bool_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int flags, float scale, bool conjB, cv::cuda::Stream* stream) {
		try {
			cv::cuda::mulAndScaleSpectrums(*src1, *src2, *dst, flags, scale, conjB, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mulSpectrums(cv::InputArray, cv::InputArray, cv::OutputArray, int, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:794
	Result_void cv_cuda_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int flags, bool conjB, cv::cuda::Stream* stream) {
		try {
			cv::cuda::mulSpectrums(*src1, *src2, *dst, flags, conjB, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// multiply(cv::InputArray, cv::InputArray, cv::OutputArray, double, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:115
	Result_void cv_cuda_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, double scale, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::multiply(*src1, *src2, *dst, scale, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// norm(cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:579
	Result<double> cv_cuda_norm_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, int normType) {
		try {
			double ret = cv::cuda::norm(*src1, *src2, normType);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// norm(cv::InputArray, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:567
	Result<double> cv_cuda_norm_const__InputArrayR_int_const__InputArrayR(const cv::_InputArray* src1, int normType, const cv::_InputArray* mask) {
		try {
			double ret = cv::cuda::norm(*src1, normType, *mask);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// normalize(cv::InputArray, cv::OutputArray, double, double, int, int, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:724
	Result_void cv_cuda_normalize_const__InputArrayR_const__OutputArrayR_double_double_int_int_const__InputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, double alpha, double beta, int norm_type, int dtype, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::normalize(*src, *dst, alpha, beta, norm_type, dtype, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// phase(cv::InputArray, cv::InputArray, cv::OutputArray, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:434
	Result_void cv_cuda_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* angle, bool angleInDegrees, cv::cuda::Stream* stream) {
		try {
			cv::cuda::phase(*x, *y, *angle, angleInDegrees, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// polarToCart(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:458
	Result_void cv_cuda_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool_StreamR(const cv::_InputArray* magnitude, const cv::_InputArray* angle, const cv::_OutputArray* x, const cv::_OutputArray* y, bool angleInDegrees, cv::cuda::Stream* stream) {
		try {
			cv::cuda::polarToCart(*magnitude, *angle, *x, *y, angleInDegrees, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pow(cv::InputArray, double, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:205
	Result_void cv_cuda_pow_const__InputArrayR_double_const__OutputArrayR_StreamR(const cv::_InputArray* src, double power, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::pow(*src, power, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rectStdDev(cv::InputArray, cv::InputArray, cv::OutputArray, cv::Rect, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:706
	Result_void cv_cuda_rectStdDev_const__InputArrayR_const__InputArrayR_const__OutputArrayR_Rect_StreamR(const cv::_InputArray* src, const cv::_InputArray* sqr, const cv::_OutputArray* dst, cv::Rect* rect, cv::cuda::Stream* stream) {
		try {
			cv::cuda::rectStdDev(*src, *sqr, *dst, *rect, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reduce(cv::InputArray, cv::OutputArray, int, int, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:684
	Result_void cv_cuda_reduce_const__InputArrayR_const__OutputArrayR_int_int_int_StreamR(const cv::_InputArray* mtx, const cv::_OutputArray* vec, int dim, int reduceOp, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::reduce(*mtx, *vec, dim, reduceOp, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rshift(cv::InputArray, Scalar_<int>, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:275
	Result_void cv_cuda_rshift_const__InputArrayR_Scalar__int__const__OutputArrayR_StreamR(const cv::_InputArray* src, cv::Scalar_<int>* val, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::rshift(*src, *val, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rshift(cv::InputArray, cv::Scalar, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:277
	Result_void cv_cuda_rshift_const__InputArrayR_Scalar_const__OutputArrayR_StreamR(const cv::_InputArray* src, cv::Scalar* val, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::rshift(*src, *val, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// split(cv::InputArray, cv::cuda::GpuMat *, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:486
	Result_void cv_cuda_split_const__InputArrayR_GpuMatX_StreamR(const cv::_InputArray* src, cv::cuda::GpuMat* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::split(*src, dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// split(cv::InputArray, std::vector<GpuMat> &, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:488
	Result_void cv_cuda_split_const__InputArrayR_vector_GpuMat_R_StreamR(const cv::_InputArray* src, std::vector<cv::cuda::GpuMat>* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::split(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sqrIntegral(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:745
	Result_void cv_cuda_sqrIntegral_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* sqsum, cv::cuda::Stream* stream) {
		try {
			cv::cuda::sqrIntegral(*src, *sqsum, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sqrSum(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:608
	Result<cv::Scalar> cv_cuda_sqrSum_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputArray* mask) {
		try {
			cv::Scalar ret = cv::cuda::sqrSum(*src, *mask);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// sqr(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:160
	Result_void cv_cuda_sqr_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::sqr(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sqrt(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:170
	Result_void cv_cuda_sqrt_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::sqrt(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// subtract(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:101
	Result_void cv_cuda_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int_StreamR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, int dtype, cv::cuda::Stream* stream) {
		try {
			cv::cuda::subtract(*src1, *src2, *dst, *mask, dtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sum(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:590
	Result<cv::Scalar> cv_cuda_sum_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputArray* mask) {
		try {
			cv::Scalar ret = cv::cuda::sum(*src, *mask);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// threshold(cv::InputArray, cv::OutputArray, double, double, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:359
	Result<double> cv_cuda_threshold_const__InputArrayR_const__OutputArrayR_double_double_int_StreamR(const cv::_InputArray* src, const cv::_OutputArray* dst, double thresh, double maxval, int type, cv::cuda::Stream* stream) {
		try {
			double ret = cv::cuda::threshold(*src, *dst, thresh, maxval, type, *stream);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// transpose(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:498
	Result_void cv_cuda_transpose_const__InputArrayR_const__OutputArrayR_StreamR(const cv::_InputArray* src1, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			cv::cuda::transpose(*src1, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convolve(cv::InputArray, cv::InputArray, cv::OutputArray, bool, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:894
	Result_void cv_cuda_Convolution_convolve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool_StreamR(cv::cuda::Convolution* instance, const cv::_InputArray* image, const cv::_InputArray* templ, const cv::_OutputArray* result, bool ccorr, cv::cuda::Stream* stream) {
		try {
			instance->convolve(*image, *templ, *result, ccorr, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:861
	Result_void cv_cuda_DFT_compute_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::DFT* instance, const cv::_InputArray* image, const cv::_OutputArray* result, cv::cuda::Stream* stream) {
		try {
			instance->compute(*image, *result, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// transform(cv::InputArray, cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/cudaarithm.hpp:527
	Result_void cv_cuda_LookUpTable_transform_const__InputArrayR_const__OutputArrayR_StreamR(cv::cuda::LookUpTable* instance, const cv::_InputArray* src, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->transform(*src, *dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
}
