#include "core.hpp"
#include "core_types.hpp"

extern "C" {
	// Cholesky(double *, size_t, int, double *, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:567
	Result<bool> cv_Cholesky_doubleX_size_t_int_doubleX_size_t_int(double* A, size_t astep, int m, double* b, size_t bstep, int n) {
		try {
			bool ret = cv::Cholesky(A, astep, m, b, bstep, n);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// Cholesky(float *, size_t, int, float *, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:565
	Result<bool> cv_Cholesky_floatX_size_t_int_floatX_size_t_int(float* A, size_t astep, int m, float* b, size_t bstep, int n) {
		try {
			bool ret = cv::Cholesky(A, astep, m, b, bstep, n);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// LUT(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:563
	Result_void cv_LUT_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_InputArray* lut, const cv::_OutputArray* dst) {
		try {
			cv::LUT(*src, *lut, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// LU(double *, size_t, int, double *, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:563
	Result<int> cv_LU_doubleX_size_t_int_doubleX_size_t_int(double* A, size_t astep, int m, double* b, size_t bstep, int n) {
		try {
			int ret = cv::LU(A, astep, m, b, bstep, n);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// LU(float *, size_t, int, float *, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:561
	Result<int> cv_LU_floatX_size_t_int_floatX_size_t_int(float* A, size_t astep, int m, float* b, size_t bstep, int n) {
		try {
			int ret = cv::LU(A, astep, m, b, bstep, n);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// Mahalanobis(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2040
	Result<double> cv_Mahalanobis_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* v1, const cv::_InputArray* v2, const cv::_InputArray* icovar) {
		try {
			double ret = cv::Mahalanobis(*v1, *v2, *icovar);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// PCABackProject(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2020
	Result_void cv_PCABackProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* data, const cv::_InputArray* mean, const cv::_InputArray* eigenvectors, const cv::_OutputArray* result) {
		try {
			cv::PCABackProject(*data, *mean, *eigenvectors, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PCACompute(cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2011
	Result_void cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_double(const cv::_InputArray* data, const cv::_InputOutputArray* mean, const cv::_OutputArray* eigenvectors, const cv::_OutputArray* eigenvalues, double retainedVariance) {
		try {
			cv::PCACompute(*data, *mean, *eigenvectors, *eigenvalues, retainedVariance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PCACompute(cv::InputArray, cv::InputOutputArray, cv::OutputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2002
	Result_void cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int(const cv::_InputArray* data, const cv::_InputOutputArray* mean, const cv::_OutputArray* eigenvectors, const cv::_OutputArray* eigenvalues, int maxComponents) {
		try {
			cv::PCACompute(*data, *mean, *eigenvectors, *eigenvalues, maxComponents);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PCACompute(cv::InputArray, cv::InputOutputArray, cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2007
	Result_void cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_double(const cv::_InputArray* data, const cv::_InputOutputArray* mean, const cv::_OutputArray* eigenvectors, double retainedVariance) {
		try {
			cv::PCACompute(*data, *mean, *eigenvectors, retainedVariance);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PCACompute(cv::InputArray, cv::InputOutputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1998
	Result_void cv_PCACompute_const__InputArrayR_const__InputOutputArrayR_const__OutputArrayR_int(const cv::_InputArray* data, const cv::_InputOutputArray* mean, const cv::_OutputArray* eigenvectors, int maxComponents) {
		try {
			cv::PCACompute(*data, *mean, *eigenvectors, maxComponents);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PCAProject(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2016
	Result_void cv_PCAProject_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* data, const cv::_InputArray* mean, const cv::_InputArray* eigenvectors, const cv::_OutputArray* result) {
		try {
			cv::PCAProject(*data, *mean, *eigenvectors, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// PSNR(cv::InputArray, cv::InputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:723
	Result<double> cv_PSNR_const__InputArrayR_const__InputArrayR_double(const cv::_InputArray* src1, const cv::_InputArray* src2, double R) {
		try {
			double ret = cv::PSNR(*src1, *src2, R);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// SVBackSubst(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2027
	Result_void cv_SVBackSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* w, const cv::_InputArray* u, const cv::_InputArray* vt, const cv::_InputArray* rhs, const cv::_OutputArray* dst) {
		try {
			cv::SVBackSubst(*w, *u, *vt, *rhs, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// SVDecomp(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2024
	Result_void cv_SVDecomp_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* w, const cv::_OutputArray* u, const cv::_OutputArray* vt, int flags) {
		try {
			cv::SVDecomp(*src, *w, *u, *vt, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// abs(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3759
	Result<cv::MatExpr*> cv_abs_const_MatExprR(const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::abs(*e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// abs(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3755
	Result<cv::MatExpr*> cv_abs_const_MatR(const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::abs(*m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// absdiff(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1364
	Result_void cv_absdiff_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::absdiff(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addWeighted(cv::InputArray, double, cv::InputArray, double, double, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:506
	Result_void cv_addWeighted_const__InputArrayR_double_const__InputArrayR_double_double_const__OutputArrayR_int(const cv::_InputArray* src1, double alpha, const cv::_InputArray* src2, double beta, double gamma, const cv::_OutputArray* dst, int dtype) {
		try {
			cv::addWeighted(*src1, alpha, *src2, beta, gamma, *dst, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// add(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:360
	Result_void cv_add_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, int dtype) {
		try {
			cv::add(*src1, *src2, *dst, *mask, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// batchDistance(cv::InputArray, cv::InputArray, cv::OutputArray, int, cv::OutputArray, int, int, cv::InputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:730
	Result_void cv_batchDistance_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_const__OutputArrayR_int_int_const__InputArrayR_int_bool(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dist, int dtype, const cv::_OutputArray* nidx, int normType, int K, const cv::_InputArray* mask, int update, bool crosscheck) {
		try {
			cv::batchDistance(*src1, *src2, *dist, dtype, *nidx, normType, K, *mask, update, crosscheck);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_and(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1266
	Result_void cv_bitwise_and_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::bitwise_and(*src1, *src2, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_not(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1338
	Result_void cv_bitwise_not_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::bitwise_not(*src, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_or(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1293
	Result_void cv_bitwise_or_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::bitwise_or(*src1, *src2, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bitwise_xor(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1321
	Result_void cv_bitwise_xor_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::bitwise_xor(*src1, *src2, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// borderInterpolate(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:270
	Result<int> cv_borderInterpolate_int_int_int(int p, int len, int borderType) {
		try {
			int ret = cv::borderInterpolate(p, len, borderType);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// calcCovarMatrix(cv::InputArray, cv::OutputArray, cv::InputOutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1994
	Result_void cv_calcCovarMatrix_const__InputArrayR_const__OutputArrayR_const__InputOutputArrayR_int_int(const cv::_InputArray* samples, const cv::_OutputArray* covar, const cv::_InputOutputArray* mean, int flags, int ctype) {
		try {
			cv::calcCovarMatrix(*samples, *covar, *mean, flags, ctype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cartToPolar(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1575
	Result_void cv_cartToPolar_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* magnitude, const cv::_OutputArray* angle, bool angleInDegrees) {
		try {
			cv::cartToPolar(*x, *y, *magnitude, *angle, angleInDegrees);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// checkHardwareSupport(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:425
	Result<bool> cv_checkHardwareSupport_int(int feature) {
		try {
			bool ret = cv::checkHardwareSupport(feature);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// checkRange(cv::InputArray, bool, cv::Point *, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1626
	Result<bool> cv_checkRange_const__InputArrayR_bool_PointX_double_double(const cv::_InputArray* a, bool quiet, cv::Point* pos, double minVal, double maxVal) {
		try {
			bool ret = cv::checkRange(*a, quiet, pos, minVal, maxVal);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// compare(cv::InputArray, cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1425
	Result_void cv_compare_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int cmpop) {
		try {
			cv::compare(*src1, *src2, *dst, cmpop);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// completeSymm(cv::InputOutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1776
	Result_void cv_completeSymm_const__InputOutputArrayR_bool(const cv::_InputOutputArray* m, bool lowerToUpper) {
		try {
			cv::completeSymm(*m, lowerToUpper);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertFp16(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:547
	Result_void cv_convertFp16_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::convertFp16(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertScaleAbs(cv::InputArray, cv::OutputArray, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:534
	Result_void cv_convertScaleAbs_const__InputArrayR_const__OutputArrayR_double_double(const cv::_InputArray* src, const cv::_OutputArray* dst, double alpha, double beta) {
		try {
			cv::convertScaleAbs(*src, *dst, alpha, beta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyMakeBorder(cv::InputArray, cv::OutputArray, int, int, int, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:320
	Result_void cv_copyMakeBorder_const__InputArrayR_const__OutputArrayR_int_int_int_int_int_const_ScalarR(const cv::_InputArray* src, const cv::_OutputArray* dst, int top, int bottom, int left, int right, int borderType, const cv::Scalar* value) {
		try {
			cv::copyMakeBorder(*src, *dst, top, bottom, left, right, borderType, *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1376
	Result_void cv_copyTo_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			cv::copyTo(*src, *dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// countNonZero(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:581
	Result<int> cv_countNonZero_const__InputArrayR(const cv::_InputArray* src) {
		try {
			int ret = cv::countNonZero(*src);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// cubeRoot(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:539
	Result<float> cv_cubeRoot_float(float val) {
		try {
			float ret = cv::cubeRoot(val);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// createContinuous(int, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:557
	Result_void cv_cuda_createContinuous_int_int_int_const__OutputArrayR(int rows, int cols, int type, const cv::_OutputArray* arr) {
		try {
			cv::cuda::createContinuous(rows, cols, type, *arr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// deviceSupports(cv::cuda::FeatureSet) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1009
	Result<bool> cv_cuda_deviceSupports_FeatureSet(cv::cuda::FeatureSet feature_set) {
		try {
			bool ret = cv::cuda::deviceSupports(feature_set);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ensureSizeIsEnough(int, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:568
	Result_void cv_cuda_ensureSizeIsEnough_int_int_int_const__OutputArrayR(int rows, int cols, int type, const cv::_OutputArray* arr) {
		try {
			cv::cuda::ensureSizeIsEnough(rows, cols, type, *arr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCudaEnabledDeviceCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:965
	Result<int> cv_cuda_getCudaEnabledDeviceCount() {
		try {
			int ret = cv::cuda::getCudaEnabledDeviceCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:977
	Result<int> cv_cuda_getDevice() {
		try {
			int ret = cv::cuda::getDevice();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// printCudaDeviceInfo(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1251
	Result_void cv_cuda_printCudaDeviceInfo_int(int device) {
		try {
			cv::cuda::printCudaDeviceInfo(device);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// printShortCudaDeviceInfo(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1252
	Result_void cv_cuda_printShortCudaDeviceInfo_int(int device) {
		try {
			cv::cuda::printShortCudaDeviceInfo(device);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// registerPageLocked(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:809
	Result_void cv_cuda_registerPageLocked_MatR(cv::Mat* m) {
		try {
			cv::cuda::registerPageLocked(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:984
	Result_void cv_cuda_resetDevice() {
		try {
			cv::cuda::resetDevice();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBufferPoolConfig(int, size_t, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:709
	Result_void cv_cuda_setBufferPoolConfig_int_size_t_int(int deviceId, size_t stackSize, int stackCount) {
		try {
			cv::cuda::setBufferPoolConfig(deviceId, stackSize, stackCount);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBufferPoolUsage(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:708
	Result_void cv_cuda_setBufferPoolUsage_bool(bool on) {
		try {
			cv::cuda::setBufferPoolUsage(on);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setDevice(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:973
	Result_void cv_cuda_setDevice_int(int device) {
		try {
			cv::cuda::setDevice(device);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setGlDevice(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:572
	Result_void cv_cuda_setGlDevice_int(int device) {
		try {
			cv::cuda::setGlDevice(device);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unregisterPageLocked(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:815
	Result_void cv_cuda_unregisterPageLocked_MatR(cv::Mat* m) {
		try {
			cv::cuda::unregisterPageLocked(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// dct(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2229
	Result_void cv_dct_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags) {
		try {
			cv::dct(*src, *dst, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// depthToString(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:13
	Result<void*> cv_depthToString_int(int depth) {
		try {
			const char* ret = cv::depthToString(depth);
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// check_failed_MatChannels(const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:85
	Result_void cv_detail_check_failed_MatChannels_const_int_const_CheckContextR(const int v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatChannels(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_MatChannels(const int, const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:75
	Result_void cv_detail_check_failed_MatChannels_const_int_const_int_const_CheckContextR(const int v1, const int v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatChannels(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_MatDepth(const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:83
	Result_void cv_detail_check_failed_MatDepth_const_int_const_CheckContextR(const int v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatDepth(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_MatDepth(const int, const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:73
	Result_void cv_detail_check_failed_MatDepth_const_int_const_int_const_CheckContextR(const int v1, const int v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatDepth(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_MatType(const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:84
	Result_void cv_detail_check_failed_MatType_const_int_const_CheckContextR(const int v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatType(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_MatType(const int, const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:74
	Result_void cv_detail_check_failed_MatType_const_int_const_int_const_CheckContextR(const int v1, const int v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_MatType(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const Size_<int>, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:81
	Result_void cv_detail_check_failed_auto_const_Size__int__const_CheckContextR(const cv::Size_<int>* v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(*v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const Size_<int>, const Size_<int>, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:72
	Result_void cv_detail_check_failed_auto_const_Size__int__const_Size__int__const_CheckContextR(const cv::Size_<int>* v1, const cv::Size_<int>* v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(*v1, *v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const double, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:80
	Result_void cv_detail_check_failed_auto_const_double_const_CheckContextR(const double v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const double, const double, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:71
	Result_void cv_detail_check_failed_auto_const_double_const_double_const_CheckContextR(const double v1, const double v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const float, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:79
	Result_void cv_detail_check_failed_auto_const_float_const_CheckContextR(const float v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const float, const float, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:70
	Result_void cv_detail_check_failed_auto_const_float_const_float_const_CheckContextR(const float v1, const float v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:77
	Result_void cv_detail_check_failed_auto_const_int_const_CheckContextR(const int v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const int, const int, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:68
	Result_void cv_detail_check_failed_auto_const_int_const_int_const_CheckContextR(const int v1, const int v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const size_t, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:78
	Result_void cv_detail_check_failed_auto_const_size_t_const_CheckContextR(const size_t v, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const size_t, const size_t, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:69
	Result_void cv_detail_check_failed_auto_const_size_t_const_size_t_const_CheckContextR(const size_t v1, const size_t v2, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(v1, v2, *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// check_failed_auto(const std::string &, const cv::detail::CheckContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:82
	Result_void cv_detail_check_failed_auto_const_stringR_const_CheckContextR(const char* v1, const cv::detail::CheckContext* ctx) {
		try {
			cv::detail::check_failed_auto(std::string(v1), *ctx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// determinant(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1808
	Result<double> cv_determinant_const__InputArrayR(const cv::_InputArray* mtx) {
		try {
			double ret = cv::determinant(*mtx);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// dft(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2174
	Result_void cv_dft_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags, int nonzeroRows) {
		try {
			cv::dft(*src, *dst, flags, nonzeroRows);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTypeFromD3DFORMAT(const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/directx.hpp:178
	Result<int> cv_directx_getTypeFromD3DFORMAT_const_int(const int iD3DFORMAT) {
		try {
			int ret = cv::directx::getTypeFromD3DFORMAT(iD3DFORMAT);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getTypeFromDXGI_FORMAT(const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/directx.hpp:173
	Result<int> cv_directx_getTypeFromDXGI_FORMAT_const_int(const int iDXGI_FORMAT) {
		try {
			int ret = cv::directx::getTypeFromDXGI_FORMAT(iDXGI_FORMAT);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// divide(cv::InputArray, cv::InputArray, cv::OutputArray, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:453
	Result_void cv_divide_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, double scale, int dtype) {
		try {
			cv::divide(*src1, *src2, *dst, scale, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// divide(double, cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:457
	Result_void cv_divide_double_const__InputArrayR_const__OutputArrayR_int(double scale, const cv::_InputArray* src2, const cv::_OutputArray* dst, int dtype) {
		try {
			cv::divide(scale, *src2, *dst, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// eigenNonSymmetric(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1967
	Result_void cv_eigenNonSymmetric_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* eigenvalues, const cv::_OutputArray* eigenvectors) {
		try {
			cv::eigenNonSymmetric(*src, *eigenvalues, *eigenvectors);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// eigen(cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1950
	Result<bool> cv_eigen_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* eigenvalues, const cv::_OutputArray* eigenvectors) {
		try {
			bool ret = cv::eigen(*src, *eigenvalues, *eigenvectors);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// error(const cv::Exception &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:155
	Result_void cv_error_const_ExceptionR(const cv::Exception* exc) {
		try {
			cv::error(*exc);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// error(int, const cv::String &, const char *, const char *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:298
	Result_void cv_error_int_const_StringR_const_charX_const_charX_int(int _code, const char* _err, const char* _func, const char* _file, int _line) {
		try {
			cv::error(_code, std::string(_err), _func, _file, _line);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// exp(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1519
	Result_void cv_exp_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::exp(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// extractChannel(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1028
	Result_void cv_extractChannel_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int coi) {
		try {
			cv::extractChannel(*src, *dst, coi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fastAtan2(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:558
	Result<float> cv_fastAtan2_float_float(float y, float x) {
		try {
			float ret = cv::fastAtan2(y, x);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// findNonZero(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:609
	Result_void cv_findNonZero_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* idx) {
		try {
			cv::findNonZero(*src, *idx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flip(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1070
	Result_void cv_flip_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flipCode) {
		try {
			cv::flip(*src, *dst, flipCode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// gemm(cv::InputArray, cv::InputArray, double, cv::InputArray, double, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1663
	Result_void cv_gemm_const__InputArrayR_const__InputArrayR_double_const__InputArrayR_double_const__OutputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, double alpha, const cv::_InputArray* src3, double beta, const cv::_OutputArray* dst, int flags) {
		try {
			cv::gemm(*src1, *src2, alpha, *src3, beta, *dst, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getBuildInformation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:242
	Result<void*> cv_getBuildInformation() {
		try {
			const cv::String ret = cv::getBuildInformation();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getCPUFeaturesLine() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:443
	Result<void*> cv_getCPUFeaturesLine() {
		try {
			std::string ret = cv::getCPUFeaturesLine();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getCPUTickCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:415
	Result<int64_t> cv_getCPUTickCount() {
		try {
			int64_t ret = cv::getCPUTickCount();
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getElemSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:568
	Result<size_t> cv_getElemSize_int(int type) {
		try {
			size_t ret = cv::getElemSize(type);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// getHardwareFeatureName(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:431
	Result<void*> cv_getHardwareFeatureName_int(int feature) {
		try {
			cv::String ret = cv::getHardwareFeatureName(feature);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getLogLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:224
	Result<int> cv_getLogLevel() {
		try {
			int ret = cv::getLogLevel();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNumThreads() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:218
	Result<int> cv_getNumThreads() {
		try {
			int ret = cv::getNumThreads();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getNumberOfCPUs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:447
	Result<int> cv_getNumberOfCPUs() {
		try {
			int ret = cv::getNumberOfCPUs();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getOptimalDFTSize(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2282
	Result<int> cv_getOptimalDFTSize_int(int vecsize) {
		try {
			int ret = cv::getOptimalDFTSize(vecsize);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getThreadNum() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:234
	Result<int> cv_getThreadNum() {
		try {
			int ret = cv::getThreadNum();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getTickCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:268
	Result<int64_t> cv_getTickCount() {
		try {
			int64_t ret = cv::getTickCount();
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getTickFrequency() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:281
	Result<double> cv_getTickFrequency() {
		try {
			double ret = cv::getTickFrequency();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getVersionMajor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:253
	Result<int> cv_getVersionMajor() {
		try {
			int ret = cv::getVersionMajor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getVersionMinor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:256
	Result<int> cv_getVersionMinor() {
		try {
			int ret = cv::getVersionMinor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getVersionRevision() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:259
	Result<int> cv_getVersionRevision() {
		try {
			int ret = cv::getVersionRevision();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getVersionString() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:250
	Result<void*> cv_getVersionString() {
		try {
			cv::String ret = cv::getVersionString();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// glob(cv::String, std::vector<String> &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:180
	Result_void cv_glob_String_vector_String_R_bool(char* pattern, std::vector<cv::String>* result, bool recursive) {
		try {
			cv::glob(std::string(pattern), *result, recursive);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// haveOpenVX() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ovx.hpp:19
	Result<bool> cv_haveOpenVX() {
		try {
			bool ret = cv::haveOpenVX();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hconcat(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1156
	Result_void cv_hconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::hconcat(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// hconcat(cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1175
	Result_void cv_hconcat_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::hconcat(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// idct(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2239
	Result_void cv_idct_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags) {
		try {
			cv::idct(*src, *dst, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// idft(cv::InputArray, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2188
	Result_void cv_idft_const__InputArrayR_const__OutputArrayR_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags, int nonzeroRows) {
		try {
			cv::idft(*src, *dst, flags, nonzeroRows);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// inRange(cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1396
	Result_void cv_inRange_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_InputArray* lowerb, const cv::_InputArray* upperb, const cv::_OutputArray* dst) {
		try {
			cv::inRange(*src, *lowerb, *upperb, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// insertChannel(cv::InputArray, cv::InputOutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1036
	Result_void cv_insertChannel_const__InputArrayR_const__InputOutputArrayR_int(const cv::_InputArray* src, const cv::_InputOutputArray* dst, int coi) {
		try {
			cv::insertChannel(*src, *dst, coi);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:117
	Result<cv::instr::FLAGS> cv_instr_getFlags() {
		try {
			cv::instr::FLAGS ret = cv::instr::getFlags();
			return Ok<cv::instr::FLAGS>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::instr::FLAGS>))
	}
	
	// resetTrace() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:106
	Result_void cv_instr_resetTrace() {
		try {
			cv::instr::resetTrace();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setFlags(cv::instr::FLAGS) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:115
	Result_void cv_instr_setFlags_FLAGS(cv::instr::FLAGS modeFlags) {
		try {
			cv::instr::setFlags(modeFlags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseInstrumentation(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:105
	Result_void cv_instr_setUseInstrumentation_bool(bool flag) {
		try {
			cv::instr::setUseInstrumentation(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// useInstrumentation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:104
	Result<bool> cv_instr_useInstrumentation() {
		try {
			bool ret = cv::instr::useInstrumentation();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// invert(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1844
	Result<double> cv_invert_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags) {
		try {
			double ret = cv::invert(*src, *dst, flags);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getIppErrorLocation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:635
	Result<void*> cv_ipp_getIppErrorLocation() {
		try {
			cv::String ret = cv::ipp::getIppErrorLocation();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getIppFeatures() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:631
	Result<unsigned long long> cv_ipp_getIppFeatures() {
		try {
			unsigned long long ret = cv::ipp::getIppFeatures();
			return Ok<unsigned long long>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned long long>))
	}
	
	// getIppStatus() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:634
	Result<int> cv_ipp_getIppStatus() {
		try {
			int ret = cv::ipp::getIppStatus();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getIppVersion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:638
	Result<void*> cv_ipp_getIppVersion() {
		try {
			cv::String ret = cv::ipp::getIppVersion();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// setIppStatus(int, const char *const, const char *const, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:632
	Result_void cv_ipp_setIppStatus_int_const_charX_const_charX_int(int status, const char* funcname, const char* filename, int line) {
		try {
			cv::ipp::setIppStatus(status, funcname, filename, line);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseIPP_NotExact(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:643
	Result_void cv_ipp_setUseIPP_NotExact_bool(bool flag) {
		try {
			cv::ipp::setUseIPP_NotExact(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseIPP(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:637
	Result_void cv_ipp_setUseIPP_bool(bool flag) {
		try {
			cv::ipp::setUseIPP(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// useIPP() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:636
	Result<bool> cv_ipp_useIPP() {
		try {
			bool ret = cv::ipp::useIPP();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// useIPP_NotExact() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/base.hpp:642
	Result<bool> cv_ipp_useIPP_NotExact() {
		try {
			bool ret = cv::ipp::useIPP_NotExact();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// kmeans(cv::InputArray, int, cv::InputOutputArray, cv::TermCriteria, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3011
	Result<double> cv_kmeans_const__InputArrayR_int_const__InputOutputArrayR_TermCriteria_int_int_const__OutputArrayR(const cv::_InputArray* data, int K, const cv::_InputOutputArray* bestLabels, cv::TermCriteria* criteria, int attempts, int flags, const cv::_OutputArray* centers) {
		try {
			double ret = cv::kmeans(*data, K, *bestLabels, *criteria, attempts, flags, *centers);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// log(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1532
	Result_void cv_log_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::log(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// magnitude(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1609
	Result_void cv_magnitude_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* magnitude) {
		try {
			cv::magnitude(*x, *y, *magnitude);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// max(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3734
	Result<cv::MatExpr*> cv_max_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::max(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// max(const cv::Mat &, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1463
	Result_void cv_max_const_MatR_const_MatR_MatR(const cv::Mat* src1, const cv::Mat* src2, cv::Mat* dst) {
		try {
			cv::max(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// max(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3735
	Result<cv::MatExpr*> cv_max_const_MatR_double(const cv::Mat* a, double s) {
		try {
			cv::MatExpr ret = cv::max(*a, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// max(const cv::UMat &, const cv::UMat &, cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1467
	Result_void cv_max_const_UMatR_const_UMatR_UMatR(const cv::UMat* src1, const cv::UMat* src2, cv::UMat* dst) {
		try {
			cv::max(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// max(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1459
	Result_void cv_max_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::max(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// max(double, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3736
	Result<cv::MatExpr*> cv_max_double_const_MatR(double s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::max(s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// meanStdDev(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:644
	Result_void cv_meanStdDev_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* mean, const cv::_OutputArray* stddev, const cv::_InputArray* mask) {
		try {
			cv::meanStdDev(*src, *mean, *stddev, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mean(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:622
	Result<cv::Scalar> cv_mean_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_InputArray* mask) {
		try {
			cv::Scalar ret = cv::mean(*src, *mask);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// merge(const cv::Mat *, size_t, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:912
	Result_void cv_merge_const_MatX_size_t_const__OutputArrayR(const cv::Mat* mv, size_t count, const cv::_OutputArray* dst) {
		try {
			cv::merge(mv, count, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// merge(cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:920
	Result_void cv_merge_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* mv, const cv::_OutputArray* dst) {
		try {
			cv::merge(*mv, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minMaxIdx(cv::InputArray, double *, double *, int *, int *, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:852
	Result_void cv_minMaxIdx_const__InputArrayR_doubleX_doubleX_intX_intX_const__InputArrayR(const cv::_InputArray* src, double* minVal, double* maxVal, int* minIdx, int* maxIdx, const cv::_InputArray* mask) {
		try {
			cv::minMaxIdx(*src, minVal, maxVal, minIdx, maxIdx, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minMaxLoc(const cv::SparseMat &, double *, double *, int *, int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:864
	Result_void cv_minMaxLoc_const_SparseMatR_doubleX_doubleX_intX_intX(const cv::SparseMat* a, double* minVal, double* maxVal, int* minIdx, int* maxIdx) {
		try {
			cv::minMaxLoc(*a, minVal, maxVal, minIdx, maxIdx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minMaxLoc(cv::InputArray, double *, double *, cv::Point *, cv::Point *, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:824
	Result_void cv_minMaxLoc_const__InputArrayR_doubleX_doubleX_PointX_PointX_const__InputArrayR(const cv::_InputArray* src, double* minVal, double* maxVal, cv::Point* minLoc, cv::Point* maxLoc, const cv::_InputArray* mask) {
		try {
			cv::minMaxLoc(*src, minVal, maxVal, minLoc, maxLoc, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// min(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3726
	Result<cv::MatExpr*> cv_min_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::min(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// min(const cv::Mat &, const cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1442
	Result_void cv_min_const_MatR_const_MatR_MatR(const cv::Mat* src1, const cv::Mat* src2, cv::Mat* dst) {
		try {
			cv::min(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// min(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3727
	Result<cv::MatExpr*> cv_min_const_MatR_double(const cv::Mat* a, double s) {
		try {
			cv::MatExpr ret = cv::min(*a, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// min(const cv::UMat &, const cv::UMat &, cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1446
	Result_void cv_min_const_UMatR_const_UMatR_UMatR(const cv::UMat* src1, const cv::UMat* src2, cv::UMat* dst) {
		try {
			cv::min(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// min(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1438
	Result_void cv_min_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::min(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// min(double, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3728
	Result<cv::MatExpr*> cv_min_double_const_MatR(double s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::min(s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// mixChannels(cv::InputArrayOfArrays, cv::InputOutputArrayOfArrays, const int *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1003
	Result_void cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_intX_size_t(const cv::_InputArray* src, const cv::_InputOutputArray* dst, const int* fromTo, size_t npairs) {
		try {
			cv::mixChannels(*src, *dst, fromTo, npairs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mixChannels(cv::InputArrayOfArrays, cv::InputOutputArrayOfArrays, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1019
	Result_void cv_mixChannels_const__InputArrayR_const__InputOutputArrayR_const_vector_int_R(const cv::_InputArray* src, const cv::_InputOutputArray* dst, const std::vector<int>* fromTo) {
		try {
			cv::mixChannels(*src, *dst, *fromTo);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mulSpectrums(cv::InputArray, cv::InputArray, cv::OutputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2258
	Result_void cv_mulSpectrums_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int_bool(const cv::_InputArray* a, const cv::_InputArray* b, const cv::_OutputArray* c, int flags, bool conjB) {
		try {
			cv::mulSpectrums(*a, *b, *c, flags, conjB);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mulTransposed(cv::InputArray, cv::OutputArray, bool, cv::InputArray, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1694
	Result_void cv_mulTransposed_const__InputArrayR_const__OutputArrayR_bool_const__InputArrayR_double_int(const cv::_InputArray* src, const cv::_OutputArray* dst, bool aTa, const cv::_InputArray* delta, double scale, int dtype) {
		try {
			cv::mulTransposed(*src, *dst, aTa, *delta, scale, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// multiply(cv::InputArray, cv::InputArray, cv::OutputArray, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:425
	Result_void cv_multiply_const__InputArrayR_const__InputArrayR_const__OutputArrayR_double_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, double scale, int dtype) {
		try {
			cv::multiply(*src1, *src2, *dst, scale, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// noArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:448
	Result<const cv::_InputOutputArray*> cv_noArray() {
		try {
			const cv::_InputOutputArray ret = cv::noArray();
			return Ok(new const cv::_InputOutputArray(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::_InputOutputArray*>))
	}
	
	// norm(const cv::SparseMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:702
	Result<double> cv_norm_const_SparseMatR_int(const cv::SparseMat* src, int normType) {
		try {
			double ret = cv::norm(*src, normType);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// norm(cv::InputArray, cv::InputArray, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:696
	Result<double> cv_norm_const__InputArrayR_const__InputArrayR_int_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, int normType, const cv::_InputArray* mask) {
		try {
			double ret = cv::norm(*src1, *src2, normType, *mask);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// norm(cv::InputArray, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:683
	Result<double> cv_norm_const__InputArrayR_int_const__InputArrayR(const cv::_InputArray* src1, int normType, const cv::_InputArray* mask) {
		try {
			double ret = cv::norm(*src1, normType, *mask);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// normalize(const cv::SparseMat &, cv::SparseMat &, double, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:804
	Result_void cv_normalize_const_SparseMatR_SparseMatR_double_int(const cv::SparseMat* src, cv::SparseMat* dst, double alpha, int normType) {
		try {
			cv::normalize(*src, *dst, alpha, normType);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// normalize(cv::InputArray, cv::InputOutputArray, double, double, int, int, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:794
	Result_void cv_normalize_const__InputArrayR_const__InputOutputArrayR_double_double_int_int_const__InputArrayR(const cv::_InputArray* src, const cv::_InputOutputArray* dst, double alpha, double beta, int norm_type, int dtype, const cv::_InputArray* mask) {
		try {
			cv::normalize(*src, *dst, alpha, beta, norm_type, dtype, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// attachContext(const cv::String &, void *, void *, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:361
	Result_void cv_ocl_attachContext_const_StringR_voidX_voidX_voidX(const char* platformName, void* platformID, void* context, void* deviceID) {
		try {
			cv::ocl::attachContext(std::string(platformName), platformID, context, deviceID);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// buildOptionsAddMatrixDescription(cv::String &, const cv::String &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:737
	Result_void cv_ocl_buildOptionsAddMatrixDescription_StringR_const_StringR_const__InputArrayR(void** buildOptions, const char* name, const cv::_InputArray* _m) {
		try {
			std::string buildOptions_out;
			cv::ocl::buildOptionsAddMatrixDescription(buildOptions_out, std::string(name), *_m);
			*buildOptions = ocvrs_create_string(buildOptions_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// checkOptimalVectorWidth(const int *, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::ocl::OclVectorStrategy) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:726
	Result<int> cv_ocl_checkOptimalVectorWidth_const_intX_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(const int* vectorWidths, const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputArray* src3, const cv::_InputArray* src4, const cv::_InputArray* src5, const cv::_InputArray* src6, const cv::_InputArray* src7, const cv::_InputArray* src8, const cv::_InputArray* src9, cv::ocl::OclVectorStrategy strat) {
		try {
			int ret = cv::ocl::checkOptimalVectorWidth(vectorWidths, *src1, *src2, *src3, *src4, *src5, *src6, *src7, *src8, *src9, strat);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// convertFromBuffer(void *, size_t, int, int, int, cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:375
	Result_void cv_ocl_convertFromBuffer_voidX_size_t_int_int_int_UMatR(void* cl_mem_buffer, size_t step, int rows, int cols, int type, cv::UMat* dst) {
		try {
			cv::ocl::convertFromBuffer(cl_mem_buffer, step, rows, cols, type, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertFromImage(void *, cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:384
	Result_void cv_ocl_convertFromImage_voidX_UMatR(void* cl_mem_image, cv::UMat* dst) {
		try {
			cv::ocl::convertFromImage(cl_mem_image, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTypeStr(int, int, int, char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:700
	Result<void*> cv_ocl_convertTypeStr_int_int_int_charX(int sdepth, int ddepth, int cn, void** buf) {
		try {
			char* buf_out = new char[1024]();
			const char* ret = cv::ocl::convertTypeStr(sdepth, ddepth, cn, buf_out);
			*buf = ocvrs_create_string(buf_out);
			Result<void*> f_ret = Ok(ocvrs_create_string(ret));
			delete[] buf_out;
			return f_ret;
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// finish() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:59
	Result_void cv_ocl_finish() {
		try {
			cv::ocl::finish();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getOpenCLErrorString(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:704
	Result<void*> cv_ocl_getOpenCLErrorString_int(int errorCode) {
		try {
			const char* ret = cv::ocl::getOpenCLErrorString(errorCode);
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getPlatfomsInfo(std::vector<PlatformInfo> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:706
	Result_void cv_ocl_getPlatfomsInfo_vector_PlatformInfo_R(std::vector<cv::ocl::PlatformInfo>* platform_info) {
		try {
			cv::ocl::getPlatfomsInfo(*platform_info);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// haveAmdBlas() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:56
	Result<bool> cv_ocl_haveAmdBlas() {
		try {
			bool ret = cv::ocl::haveAmdBlas();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// haveAmdFft() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:57
	Result<bool> cv_ocl_haveAmdFft() {
		try {
			bool ret = cv::ocl::haveAmdFft();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// haveOpenCL() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:54
	Result<bool> cv_ocl_haveOpenCL() {
		try {
			bool ret = cv::ocl::haveOpenCL();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// haveSVM() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:61
	Result<bool> cv_ocl_haveSVM() {
		try {
			bool ret = cv::ocl::haveSVM();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// kernelToStr(cv::InputArray, int, const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:705
	Result<void*> cv_ocl_kernelToStr_const__InputArrayR_int_const_charX(const cv::_InputArray* _kernel, int ddepth, const char* name) {
		try {
			cv::String ret = cv::ocl::kernelToStr(*_kernel, ddepth, name);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// memopTypeToStr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:702
	Result<void*> cv_ocl_memopTypeToStr_int(int t) {
		try {
			const char* ret = cv::ocl::memopTypeToStr(t);
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// predictOptimalVectorWidthMax(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:733
	Result<int> cv_ocl_predictOptimalVectorWidthMax_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputArray* src3, const cv::_InputArray* src4, const cv::_InputArray* src5, const cv::_InputArray* src6, const cv::_InputArray* src7, const cv::_InputArray* src8, const cv::_InputArray* src9) {
		try {
			int ret = cv::ocl::predictOptimalVectorWidthMax(*src1, *src2, *src3, *src4, *src5, *src6, *src7, *src8, *src9);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// predictOptimalVectorWidth(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::ocl::OclVectorStrategy) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:721
	Result<int> cv_ocl_predictOptimalVectorWidth_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_OclVectorStrategy(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_InputArray* src3, const cv::_InputArray* src4, const cv::_InputArray* src5, const cv::_InputArray* src6, const cv::_InputArray* src7, const cv::_InputArray* src8, const cv::_InputArray* src9, cv::ocl::OclVectorStrategy strat) {
		try {
			int ret = cv::ocl::predictOptimalVectorWidth(*src1, *src2, *src3, *src4, *src5, *src6, *src7, *src8, *src9, strat);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setUseOpenCL(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:58
	Result_void cv_ocl_setUseOpenCL_bool(bool flag) {
		try {
			cv::ocl::setUseOpenCL(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// typeToStr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:701
	Result<void*> cv_ocl_typeToStr_int(int t) {
		try {
			const char* ret = cv::ocl::typeToStr(t);
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// useOpenCL() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:55
	Result<bool> cv_ocl_useOpenCL() {
		try {
			bool ret = cv::ocl::useOpenCL();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// vecopTypeToStr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:703
	Result<void*> cv_ocl_vecopTypeToStr_int(int t) {
		try {
			const char* ret = cv::ocl::vecopTypeToStr(t);
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// convertFromGLTexture2D(const cv::ogl::Texture2D &, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:538
	Result_void cv_ogl_convertFromGLTexture2D_const_Texture2DR_const__OutputArrayR(const cv::ogl::Texture2D* texture, const cv::_OutputArray* dst) {
		try {
			cv::ogl::convertFromGLTexture2D(*texture, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertToGLTexture2D(cv::InputArray, cv::ogl::Texture2D &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:532
	Result_void cv_ogl_convertToGLTexture2D_const__InputArrayR_Texture2DR(const cv::_InputArray* src, cv::ogl::Texture2D* texture) {
		try {
			cv::ogl::convertToGLTexture2D(*src, *texture);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapGLBuffer(const cv::ogl::Buffer &, cv::AccessFlag) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:551
	Result<cv::UMat*> cv_ogl_mapGLBuffer_const_BufferR_AccessFlag(const cv::ogl::Buffer* buffer, cv::AccessFlag accessFlags) {
		try {
			cv::UMat ret = cv::ogl::mapGLBuffer(*buffer, accessFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// initializeContextFromGL() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:524
	Result<cv::ocl::Context*> cv_ogl_ocl_initializeContextFromGL() {
		try {
			cv::ocl::Context ret = cv::ogl::ocl::initializeContextFromGL();
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// render(const cv::ogl::Arrays &, cv::InputArray, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:513
	Result_void cv_ogl_render_const_ArraysR_const__InputArrayR_int_Scalar(const cv::ogl::Arrays* arr, const cv::_InputArray* indices, int mode, cv::Scalar* color) {
		try {
			cv::ogl::render(*arr, *indices, mode, *color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(const cv::ogl::Arrays &, int, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:505
	Result_void cv_ogl_render_const_ArraysR_int_Scalar(const cv::ogl::Arrays* arr, int mode, cv::Scalar* color) {
		try {
			cv::ogl::render(*arr, mode, *color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// render(const cv::ogl::Texture2D &, Rect_<double>, Rect_<double>) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:496
	Result_void cv_ogl_render_const_Texture2DR_Rect__double__Rect__double_(const cv::ogl::Texture2D* tex, cv::Rect_<double>* wndRect, cv::Rect_<double>* texRect) {
		try {
			cv::ogl::render(*tex, *wndRect, *texRect);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unmapGLBuffer(cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:559
	Result_void cv_ogl_unmapGLBuffer_UMatR(cv::UMat* u) {
		try {
			cv::ogl::unmapGLBuffer(*u);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// operator+(const cv::MatExpr &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3604
	Result<cv::MatExpr*> cv_operatorA_const_MatExprR_const_MatExprR(const cv::MatExpr* e1, const cv::MatExpr* e2) {
		try {
			cv::MatExpr ret = cv::operator+(*e1, *e2);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::MatExpr &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3600
	Result<cv::MatExpr*> cv_operatorA_const_MatExprR_const_MatR(const cv::MatExpr* e, const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::operator+(*e, *m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::MatExpr &, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3602
	Result<cv::MatExpr*> cv_operatorA_const_MatExprR_const_ScalarR(const cv::MatExpr* e, const cv::Scalar* s) {
		try {
			cv::MatExpr ret = cv::operator+(*e, *s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::Mat &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3601
	Result<cv::MatExpr*> cv_operatorA_const_MatR_const_MatExprR(const cv::Mat* m, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator+(*m, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3597
	Result<cv::MatExpr*> cv_operatorA_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::operator+(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::Mat &, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3598
	Result<cv::MatExpr*> cv_operatorA_const_MatR_const_ScalarR(const cv::Mat* a, const cv::Scalar* s) {
		try {
			cv::MatExpr ret = cv::operator+(*a, *s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::Scalar &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3603
	Result<cv::MatExpr*> cv_operatorA_const_ScalarR_const_MatExprR(const cv::Scalar* s, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator+(*s, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator+(const cv::Scalar &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3599
	Result<cv::MatExpr*> cv_operatorA_const_ScalarR_const_MatR(const cv::Scalar* s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::operator+(*s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::MatExpr &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3646
	Result<cv::MatExpr*> cv_operatorD_const_MatExprR_const_MatExprR(const cv::MatExpr* e1, const cv::MatExpr* e2) {
		try {
			cv::MatExpr ret = cv::operator/(*e1, *e2);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::MatExpr &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3642
	Result<cv::MatExpr*> cv_operatorD_const_MatExprR_const_MatR(const cv::MatExpr* e, const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::operator/(*e, *m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::MatExpr &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3644
	Result<cv::MatExpr*> cv_operatorD_const_MatExprR_double(const cv::MatExpr* e, double s) {
		try {
			cv::MatExpr ret = cv::operator/(*e, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::Mat &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3643
	Result<cv::MatExpr*> cv_operatorD_const_MatR_const_MatExprR(const cv::Mat* m, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator/(*m, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3639
	Result<cv::MatExpr*> cv_operatorD_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::operator/(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3640
	Result<cv::MatExpr*> cv_operatorD_const_MatR_double(const cv::Mat* a, double s) {
		try {
			cv::MatExpr ret = cv::operator/(*a, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(double, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3645
	Result<cv::MatExpr*> cv_operatorD_double_const_MatExprR(double s, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator/(s, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator/(double, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3641
	Result<cv::MatExpr*> cv_operatorD_double_const_MatR(double s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::operator/(s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator==(const cv::FileNodeIterator &, const cv::FileNodeIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:1331
	Result<bool> cv_operatorEQ_const_FileNodeIteratorR_const_FileNodeIteratorR(const cv::FileNodeIterator* it1, const cv::FileNodeIterator* it2) {
		try {
			bool ret = cv::operator==(*it1, *it2);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// operator==(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3668
	Result<cv::MatExpr*> cv_operatorEQ_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::operator==(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator==(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3669
	Result<cv::MatExpr*> cv_operatorEQ_const_MatR_double(const cv::Mat* a, double s) {
		try {
			cv::MatExpr ret = cv::operator==(*a, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator==(double, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3670
	Result<cv::MatExpr*> cv_operatorEQ_double_const_MatR(double s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::operator==(s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3624
	Result<cv::MatExpr*> cv_operatorS_const_MatExprR(const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator-(*e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::MatExpr &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3617
	Result<cv::MatExpr*> cv_operatorS_const_MatExprR_const_MatExprR(const cv::MatExpr* e1, const cv::MatExpr* e2) {
		try {
			cv::MatExpr ret = cv::operator-(*e1, *e2);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::MatExpr &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3613
	Result<cv::MatExpr*> cv_operatorS_const_MatExprR_const_MatR(const cv::MatExpr* e, const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::operator-(*e, *m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::MatExpr &, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3615
	Result<cv::MatExpr*> cv_operatorS_const_MatExprR_const_ScalarR(const cv::MatExpr* e, const cv::Scalar* s) {
		try {
			cv::MatExpr ret = cv::operator-(*e, *s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3623
	Result<cv::MatExpr*> cv_operatorS_const_MatR(const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::operator-(*m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Mat &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3614
	Result<cv::MatExpr*> cv_operatorS_const_MatR_const_MatExprR(const cv::Mat* m, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator-(*m, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3610
	Result<cv::MatExpr*> cv_operatorS_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::operator-(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Mat &, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3611
	Result<cv::MatExpr*> cv_operatorS_const_MatR_const_ScalarR(const cv::Mat* a, const cv::Scalar* s) {
		try {
			cv::MatExpr ret = cv::operator-(*a, *s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Scalar &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3616
	Result<cv::MatExpr*> cv_operatorS_const_ScalarR_const_MatExprR(const cv::Scalar* s, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator-(*s, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator-(const cv::Scalar &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3612
	Result<cv::MatExpr*> cv_operatorS_const_ScalarR_const_MatR(const cv::Scalar* s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::operator-(*s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::MatExpr &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3633
	Result<cv::MatExpr*> cv_operatorX_const_MatExprR_const_MatExprR(const cv::MatExpr* e1, const cv::MatExpr* e2) {
		try {
			cv::MatExpr ret = cv::operator*(*e1, *e2);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::MatExpr &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3629
	Result<cv::MatExpr*> cv_operatorX_const_MatExprR_const_MatR(const cv::MatExpr* e, const cv::Mat* m) {
		try {
			cv::MatExpr ret = cv::operator*(*e, *m);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::MatExpr &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3631
	Result<cv::MatExpr*> cv_operatorX_const_MatExprR_double(const cv::MatExpr* e, double s) {
		try {
			cv::MatExpr ret = cv::operator*(*e, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::Mat &, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3630
	Result<cv::MatExpr*> cv_operatorX_const_MatR_const_MatExprR(const cv::Mat* m, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator*(*m, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3626
	Result<cv::MatExpr*> cv_operatorX_const_MatR_const_MatR(const cv::Mat* a, const cv::Mat* b) {
		try {
			cv::MatExpr ret = cv::operator*(*a, *b);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3627
	Result<cv::MatExpr*> cv_operatorX_const_MatR_double(const cv::Mat* a, double s) {
		try {
			cv::MatExpr ret = cv::operator*(*a, s);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(double, const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3632
	Result<cv::MatExpr*> cv_operatorX_double_const_MatExprR(double s, const cv::MatExpr* e) {
		try {
			cv::MatExpr ret = cv::operator*(s, *e);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator*(double, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3628
	Result<cv::MatExpr*> cv_operatorX_double_const_MatR(double s, const cv::Mat* a) {
		try {
			cv::MatExpr ret = cv::operator*(s, *a);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// parallel_for_(const cv::Range &, const cv::ParallelLoopBody &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:587
	Result_void cv_parallel_for__const_RangeR_const_ParallelLoopBodyR_double(const cv::Range* range, const cv::ParallelLoopBody* body, double nstripes) {
		try {
			cv::parallel_for_(*range, *body, nstripes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// patchNaNs(cv::InputOutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1633
	Result_void cv_patchNaNs_const__InputOutputArrayR_double(const cv::_InputOutputArray* a, double val) {
		try {
			cv::patchNaNs(*a, val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// perspectiveTransform(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1760
	Result_void cv_perspectiveTransform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* m) {
		try {
			cv::perspectiveTransform(*src, *dst, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// phase(cv::InputArray, cv::InputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1595
	Result_void cv_phase_const__InputArrayR_const__InputArrayR_const__OutputArrayR_bool(const cv::_InputArray* x, const cv::_InputArray* y, const cv::_OutputArray* angle, bool angleInDegrees) {
		try {
			cv::phase(*x, *y, *angle, angleInDegrees);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// polarToCart(cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1554
	Result_void cv_polarToCart_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_bool(const cv::_InputArray* magnitude, const cv::_InputArray* angle, const cv::_OutputArray* x, const cv::_OutputArray* y, bool angleInDegrees) {
		try {
			cv::polarToCart(*magnitude, *angle, *x, *y, angleInDegrees);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pow(cv::InputArray, double, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1503
	Result_void cv_pow_const__InputArrayR_double_const__OutputArrayR(const cv::_InputArray* src, double power, const cv::_OutputArray* dst) {
		try {
			cv::pow(*src, power, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// randShuffle(cv::InputOutputArray, double, cv::RNG *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2339
	Result_void cv_randShuffle_const__InputOutputArrayR_double_RNGX(const cv::_InputOutputArray* dst, double iterFactor, cv::RNG* rng) {
		try {
			cv::randShuffle(*dst, iterFactor, rng);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// randn(cv::InputOutputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2326
	Result_void cv_randn_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputOutputArray* dst, const cv::_InputArray* mean, const cv::_InputArray* stddev) {
		try {
			cv::randn(*dst, *mean, *stddev);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// randu(cv::InputOutputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2313
	Result_void cv_randu_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputOutputArray* dst, const cv::_InputArray* low, const cv::_InputArray* high) {
		try {
			cv::randu(*dst, *low, *high);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, cv::DMatch &, const cv::DMatch &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:734
	Result_void cv_read_const_FileNodeR_DMatchR_const_DMatchR(const cv::FileNode* node, cv::DMatch* value, const cv::DMatch* default_value) {
		try {
			cv::read(*node, *value, *default_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, cv::KeyPoint &, const cv::KeyPoint &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:733
	Result_void cv_read_const_FileNodeR_KeyPointR_const_KeyPointR(const cv::FileNode* node, cv::KeyPoint* value, const cv::KeyPoint* default_value) {
		try {
			cv::read(*node, *value, *default_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, cv::Mat &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:727
	Result_void cv_read_const_FileNodeR_MatR_const_MatR(const cv::FileNode* node, cv::Mat* mat, const cv::Mat* default_mat) {
		try {
			cv::read(*node, *mat, *default_mat);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, cv::SparseMat &, const cv::SparseMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:728
	Result_void cv_read_const_FileNodeR_SparseMatR_const_SparseMatR(const cv::FileNode* node, cv::SparseMat* mat, const cv::SparseMat* default_mat) {
		try {
			cv::read(*node, *mat, *default_mat);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, double &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:725
	Result_void cv_read_const_FileNodeR_doubleR_double(const cv::FileNode* node, double* value, double default_value) {
		try {
			cv::read(*node, *value, default_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, float &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:724
	Result_void cv_read_const_FileNodeR_floatR_float(const cv::FileNode* node, float* value, float default_value) {
		try {
			cv::read(*node, *value, default_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, int &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:723
	Result_void cv_read_const_FileNodeR_intR_int(const cv::FileNode* node, int* value, int default_value) {
		try {
			cv::read(*node, *value, default_value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, std::string &, const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:726
	Result_void cv_read_const_FileNodeR_stringR_const_stringR(const cv::FileNode* node, void** value, const char* default_value) {
		try {
			std::string value_out;
			cv::read(*node, value_out, std::string(default_value));
			*value = ocvrs_create_string(value_out.c_str());
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, std::vector<DMatch> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:731
	Result_void cv_read_const_FileNodeR_vector_DMatch_R(const cv::FileNode* node, std::vector<cv::DMatch>* matches) {
		try {
			cv::read(*node, *matches);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &, std::vector<KeyPoint> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:730
	Result_void cv_read_const_FileNodeR_vector_KeyPoint_R(const cv::FileNode* node, std::vector<cv::KeyPoint>* keypoints) {
		try {
			cv::read(*node, *keypoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reduce(cv::InputArray, cv::OutputArray, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:891
	Result_void cv_reduce_const__InputArrayR_const__OutputArrayR_int_int_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int dim, int rtype, int dtype) {
		try {
			cv::reduce(*src, *dst, dim, rtype, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// repeat(const cv::Mat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1112
	Result<cv::Mat*> cv_repeat_const_MatR_int_int(const cv::Mat* src, int ny, int nx) {
		try {
			cv::Mat ret = cv::repeat(*src, ny, nx);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// repeat(cv::InputArray, int, int, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1103
	Result_void cv_repeat_const__InputArrayR_int_int_const__OutputArrayR(const cv::_InputArray* src, int ny, int nx, const cv::_OutputArray* dst) {
		try {
			cv::repeat(*src, ny, nx, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rotate(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1088
	Result_void cv_rotate_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int rotateCode) {
		try {
			cv::rotate(*src, *dst, rotateCode);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addSamplesDataSearchPath(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:1200
	Result_void cv_samples_addSamplesDataSearchPath_const_StringR(const char* path) {
		try {
			cv::samples::addSamplesDataSearchPath(std::string(path));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addSamplesDataSearchSubDirectory(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:1209
	Result_void cv_samples_addSamplesDataSearchSubDirectory_const_StringR(const char* subdir) {
		try {
			cv::samples::addSamplesDataSearchSubDirectory(std::string(subdir));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// findFileOrKeep(const cv::String &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:1183
	Result<void*> cv_samples_findFileOrKeep_const_StringR_bool(const char* relative_path, bool silentMode) {
		try {
			cv::String ret = cv::samples::findFileOrKeep(std::string(relative_path), silentMode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// findFile(const cv::String &, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:1181
	Result<void*> cv_samples_findFile_const_StringR_bool_bool(const char* relative_path, bool required, bool silentMode) {
		try {
			cv::String ret = cv::samples::findFile(std::string(relative_path), required, silentMode);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// scaleAdd(cv::InputArray, double, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:478
	Result_void cv_scaleAdd_const__InputArrayR_double_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, double alpha, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::scaleAdd(*src1, alpha, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setBreakOnError(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:160
	Result<bool> cv_setBreakOnError_bool(bool flag) {
		try {
			bool ret = cv::setBreakOnError(flag);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setIdentity(cv::InputOutputArray, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1793
	Result_void cv_setIdentity_const__InputOutputArrayR_const_ScalarR(const cv::_InputOutputArray* mtx, const cv::Scalar* s) {
		try {
			cv::setIdentity(*mtx, *s);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLogLevel(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:217
	Result<int> cv_setLogLevel_int(int level) {
		try {
			int ret = cv::setLogLevel(level);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// setNumThreads(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:200
	Result_void cv_setNumThreads_int(int nthreads) {
		try {
			cv::setNumThreads(nthreads);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setRNGSeed(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2301
	Result_void cv_setRNGSeed_int(int seed) {
		try {
			cv::setRNGSeed(seed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseOpenVX(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ovx.hpp:25
	Result_void cv_setUseOpenVX_bool(bool flag) {
		try {
			cv::setUseOpenVX(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setUseOptimized(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:560
	Result_void cv_setUseOptimized_bool(bool onoff) {
		try {
			cv::setUseOptimized(onoff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// solveCubic(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1919
	Result<int> cv_solveCubic_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* coeffs, const cv::_OutputArray* roots) {
		try {
			int ret = cv::solveCubic(*coeffs, *roots);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// solveLP(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:296
	Result<int> cv_solveLP_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* Func, const cv::_InputArray* Constr, const cv::_OutputArray* z) {
		try {
			int ret = cv::solveLP(*Func, *Constr, *z);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// solvePoly(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1929
	Result<double> cv_solvePoly_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* coeffs, const cv::_OutputArray* roots, int maxIters) {
		try {
			double ret = cv::solvePoly(*coeffs, *roots, maxIters);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// solve(cv::InputArray, cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1868
	Result<bool> cv_solve_const__InputArrayR_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, int flags) {
		try {
			bool ret = cv::solve(*src1, *src2, *dst, flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// sortIdx(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1904
	Result_void cv_sortIdx_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags) {
		try {
			cv::sortIdx(*src, *dst, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sort(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1884
	Result_void cv_sort_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* dst, int flags) {
		try {
			cv::sort(*src, *dst, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// split(const cv::Mat &, cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:937
	Result_void cv_split_const_MatR_MatX(const cv::Mat* src, cv::Mat* mvbegin) {
		try {
			cv::split(*src, mvbegin);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// split(cv::InputArray, cv::OutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:943
	Result_void cv_split_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* m, const cv::_OutputArray* mv) {
		try {
			cv::split(*m, *mv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sqrt(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1478
	Result_void cv_sqrt_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::sqrt(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// subtract(cv::InputArray, cv::InputArray, cv::OutputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:400
	Result_void cv_subtract_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__InputArrayR_int(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst, const cv::_InputArray* mask, int dtype) {
		try {
			cv::subtract(*src1, *src2, *dst, *mask, dtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// sum(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:572
	Result<cv::Scalar> cv_sum_const__InputArrayR(const cv::_InputArray* src) {
		try {
			cv::Scalar ret = cv::sum(*src);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// swap(cv::Mat &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:240
	Result_void cv_swap_MatR_MatR(cv::Mat* a, cv::Mat* b) {
		try {
			cv::swap(*a, *b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// swap(cv::UMat &, cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:242
	Result_void cv_swap_UMatR_UMatR(cv::UMat* a, cv::UMat* b) {
		try {
			cv::swap(*a, *b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// tempfile(const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:179
	Result<void*> cv_tempfile_const_charX(const char* suffix) {
		try {
			cv::String ret = cv::tempfile(suffix);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// theRNG() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2293
	Result<cv::RNG*> cv_theRNG() {
		try {
			cv::RNG ret = cv::theRNG();
			return Ok(new cv::RNG(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RNG*>))
	}
	
	// trace(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1817
	Result<cv::Scalar> cv_trace_const__InputArrayR(const cv::_InputArray* mtx) {
		try {
			cv::Scalar ret = cv::trace(*mtx);
			return Ok<cv::Scalar>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Scalar>))
	}
	
	// transform(cv::InputArray, cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1733
	Result_void cv_transform_const__InputArrayR_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst, const cv::_InputArray* m) {
		try {
			cv::transform(*src, *dst, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// transpose(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1707
	Result_void cv_transpose_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::transpose(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// typeToString(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:16
	Result<void*> cv_typeToString_int(int type) {
		try {
			const cv::String ret = cv::typeToString(type);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// useOpenVX() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ovx.hpp:22
	Result<bool> cv_useOpenVX() {
		try {
			bool ret = cv::useOpenVX();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// useOptimized() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:566
	Result<bool> cv_useOptimized() {
		try {
			bool ret = cv::useOptimized();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// dumpBool(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:27
	Result<void*> cv_utils_dumpBool_bool(bool argument) {
		try {
			cv::String ret = cv::utils::dumpBool(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpCString(const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:59
	Result<void*> cv_utils_dumpCString_const_charX(const char* argument) {
		try {
			cv::String ret = cv::utils::dumpCString(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpDouble(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:53
	Result<void*> cv_utils_dumpDouble_double(double argument) {
		try {
			cv::String ret = cv::utils::dumpDouble(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpFloat(float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:47
	Result<void*> cv_utils_dumpFloat_float(float argument) {
		try {
			cv::String ret = cv::utils::dumpFloat(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpInputArrayOfArrays(cv::InputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:20
	Result<void*> cv_utils_dumpInputArrayOfArrays_const__InputArrayR(const cv::_InputArray* argument) {
		try {
			cv::String ret = cv::utils::dumpInputArrayOfArrays(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpInputArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:18
	Result<void*> cv_utils_dumpInputArray_const__InputArrayR(const cv::_InputArray* argument) {
		try {
			cv::String ret = cv::utils::dumpInputArray(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpInputOutputArrayOfArrays(cv::InputOutputArrayOfArrays) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:24
	Result<void*> cv_utils_dumpInputOutputArrayOfArrays_const__InputOutputArrayR(const cv::_InputOutputArray* argument) {
		try {
			cv::String ret = cv::utils::dumpInputOutputArrayOfArrays(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpInputOutputArray(cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:22
	Result<void*> cv_utils_dumpInputOutputArray_const__InputOutputArrayR(const cv::_InputOutputArray* argument) {
		try {
			cv::String ret = cv::utils::dumpInputOutputArray(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpInt(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:33
	Result<void*> cv_utils_dumpInt_int(int argument) {
		try {
			cv::String ret = cv::utils::dumpInt(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpRange(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:107
	Result<void*> cv_utils_dumpRange_const_RangeR(const cv::Range* argument) {
		try {
			cv::String ret = cv::utils::dumpRange(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpRect(const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:85
	Result<void*> cv_utils_dumpRect_const_RectR(const cv::Rect* argument) {
		try {
			cv::String ret = cv::utils::dumpRect(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpRotatedRect(const cv::RotatedRect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:99
	Result<void*> cv_utils_dumpRotatedRect_const_RotatedRectR(const cv::RotatedRect* argument) {
		try {
			cv::String ret = cv::utils::dumpRotatedRect(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpSizeT(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:39
	Result<void*> cv_utils_dumpSizeT_size_t(size_t argument) {
		try {
			cv::String ret = cv::utils::dumpSizeT(argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpString(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:65
	Result<void*> cv_utils_dumpString_const_StringR(const char* argument) {
		try {
			cv::String ret = cv::utils::dumpString(std::string(argument));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:92
	Result<void*> cv_utils_dumpTermCriteria_const_TermCriteriaR(const cv::TermCriteria* argument) {
		try {
			cv::String ret = cv::utils::dumpTermCriteria(*argument);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpVectorOfDouble(const std::vector<double> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:133
	Result<void*> cv_utils_dumpVectorOfDouble_const_vector_double_R(const std::vector<double>* vec) {
		try {
			cv::String ret = cv::utils::dumpVectorOfDouble(*vec);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpVectorOfInt(const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:131
	Result<void*> cv_utils_dumpVectorOfInt_const_vector_int_R(const std::vector<int>* vec) {
		try {
			cv::String ret = cv::utils::dumpVectorOfInt(*vec);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// dumpVectorOfRect(const std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:135
	Result<void*> cv_utils_dumpVectorOfRect_const_vector_Rect_R(const std::vector<cv::Rect>* vec) {
		try {
			cv::String ret = cv::utils::dumpVectorOfRect(*vec);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getCacheDirectoryForDownloads() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:208
	Result<void*> cv_utils_fs_getCacheDirectoryForDownloads() {
		try {
			cv::String ret = cv::utils::fs::getCacheDirectoryForDownloads();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// generateVectorOfInt(size_t, std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:151
	Result_void cv_utils_generateVectorOfInt_size_t_vector_int_R(size_t len, std::vector<int>* vec) {
		try {
			cv::utils::generateVectorOfInt(len, *vec);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// generateVectorOfMat(size_t, int, int, int, std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:164
	Result_void cv_utils_generateVectorOfMat_size_t_int_int_int_vector_Mat_R(size_t len, int rows, int cols, int dtype, std::vector<cv::Mat>* vec) {
		try {
			cv::utils::generateVectorOfMat(len, rows, cols, dtype, *vec);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// generateVectorOfRect(size_t, std::vector<Rect> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:138
	Result_void cv_utils_generateVectorOfRect_size_t_vector_Rect_R(size_t len, std::vector<cv::Rect>* vec) {
		try {
			cv::utils::generateVectorOfRect(len, *vec);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getThreadID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:1216
	Result<int> cv_utils_getThreadID() {
		try {
			int ret = cv::utils::getThreadID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getLogLevel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:27
	Result<cv::utils::logging::LogLevel> cv_utils_logging_getLogLevel() {
		try {
			cv::utils::logging::LogLevel ret = cv::utils::logging::getLogLevel();
			return Ok<cv::utils::logging::LogLevel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::utils::logging::LogLevel>))
	}
	
	// getLogTagLevel(const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:33
	Result<cv::utils::logging::LogLevel> cv_utils_logging_getLogTagLevel_const_charX(const char* tag) {
		try {
			cv::utils::logging::LogLevel ret = cv::utils::logging::getLogTagLevel(tag);
			return Ok<cv::utils::logging::LogLevel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::utils::logging::LogLevel>))
	}
	
	// getGlobalLogTag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:38
	Result<cv::utils::logging::LogTag**> cv_utils_logging_internal_getGlobalLogTag() {
		try {
			cv::utils::logging::LogTag* ret = cv::utils::logging::internal::getGlobalLogTag();
			return Ok(new cv::utils::logging::LogTag*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::utils::logging::LogTag**>))
	}
	
	// writeLogMessageEx(cv::utils::logging::LogLevel, const char *, const char *, int, const char *, const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:44
	Result_void cv_utils_logging_internal_writeLogMessageEx_LogLevel_const_charX_const_charX_int_const_charX_const_charX(cv::utils::logging::LogLevel logLevel, const char* tag, const char* file, int line, const char* func, const char* message) {
		try {
			cv::utils::logging::internal::writeLogMessageEx(logLevel, tag, file, line, func, message);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeLogMessage(cv::utils::logging::LogLevel, const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:41
	Result_void cv_utils_logging_internal_writeLogMessage_LogLevel_const_charX(cv::utils::logging::LogLevel logLevel, const char* message) {
		try {
			cv::utils::logging::internal::writeLogMessage(logLevel, message);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// registerLogTag(cv::utils::logging::LogTag *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:29
	Result_void cv_utils_logging_registerLogTag_LogTagX(cv::utils::logging::LogTag* plogtag) {
		try {
			cv::utils::logging::registerLogTag(plogtag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setLogLevel(cv::utils::logging::LogLevel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:25
	Result<cv::utils::logging::LogLevel> cv_utils_logging_setLogLevel_LogLevel(cv::utils::logging::LogLevel logLevel) {
		try {
			cv::utils::logging::LogLevel ret = cv::utils::logging::setLogLevel(logLevel);
			return Ok<cv::utils::logging::LogLevel>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::utils::logging::LogLevel>))
	}
	
	// setLogTagLevel(const char *, cv::utils::logging::LogLevel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logger.hpp:31
	Result_void cv_utils_logging_setLogTagLevel_const_charX_LogLevel(const char* tag, cv::utils::logging::LogLevel level) {
		try {
			cv::utils::logging::setLogTagLevel(tag, level);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// testAsyncArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:185
	Result<cv::AsyncArray*> cv_utils_testAsyncArray_const__InputArrayR(const cv::_InputArray* argument) {
		try {
			cv::AsyncArray ret = cv::utils::testAsyncArray(*argument);
			return Ok(new cv::AsyncArray(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncArray*>))
	}
	
	// testAsyncException() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:193
	Result<cv::AsyncArray*> cv_utils_testAsyncException() {
		try {
			cv::AsyncArray ret = cv::utils::testAsyncException();
			return Ok(new cv::AsyncArray(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncArray*>))
	}
	
	// testOverloadResolution(const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:78
	Result<void*> cv_utils_testOverloadResolution_const_RectR(const cv::Rect* rect) {
		try {
			cv::String ret = cv::utils::testOverloadResolution(*rect);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// testOverloadResolution(int, const cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:71
	Result<void*> cv_utils_testOverloadResolution_int_const_PointR(int value, const cv::Point* point) {
		try {
			cv::String ret = cv::utils::testOverloadResolution(value, *point);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// testOverwriteNativeMethod(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:120
	Result<int> cv_utils_testOverwriteNativeMethod_int(int argument) {
		try {
			int ret = cv::utils::testOverwriteNativeMethod(argument);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// testRaiseGeneralException() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:179
	Result_void cv_utils_testRaiseGeneralException() {
		try {
			cv::utils::testRaiseGeneralException();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// testReservedKeywordConversion(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/bindings_utils.hpp:126
	Result<void*> cv_utils_testReservedKeywordConversion_int_int_int(int positional_argument, int lambda, int from) {
		try {
			cv::String ret = cv::utils::testReservedKeywordConversion(positional_argument, lambda, from);
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// convertFromVASurface(VADisplay, VASurfaceID, cv::Size, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/va_intel.hpp:69
	Result_void cv_va_intel_convertFromVASurface_VADisplay_VASurfaceID_Size_const__OutputArrayR(VADisplay display, VASurfaceID surface, cv::Size* size, const cv::_OutputArray* dst) {
		try {
			cv::va_intel::convertFromVASurface(display, surface, *size, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertToVASurface(VADisplay, cv::InputArray, VASurfaceID, cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/va_intel.hpp:61
	Result_void cv_va_intel_convertToVASurface_VADisplay_const__InputArrayR_VASurfaceID_Size(VADisplay display, const cv::_InputArray* src, VASurfaceID surface, cv::Size* size) {
		try {
			cv::va_intel::convertToVASurface(display, *src, surface, *size);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// initializeContextFromVA(VADisplay, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/va_intel.hpp:51
	Result<cv::ocl::Context*> cv_va_intel_ocl_initializeContextFromVA_VADisplay_bool(VADisplay display, bool tryInterop) {
		try {
			cv::ocl::Context ret = cv::va_intel::ocl::initializeContextFromVA(display, tryInterop);
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// vconcat(cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1221
	Result_void cv_vconcat_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src1, const cv::_InputArray* src2, const cv::_OutputArray* dst) {
		try {
			cv::vconcat(*src1, *src2, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// vconcat(cv::InputArrayOfArrays, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:1239
	Result_void cv_vconcat_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::vconcat(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeScalar(cv::FileStorage &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:716
	Result_void cv_writeScalar_FileStorageR_const_StringR(cv::FileStorage* fs, const char* value) {
		try {
			cv::writeScalar(*fs, std::string(value));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeScalar(cv::FileStorage &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:715
	Result_void cv_writeScalar_FileStorageR_double(cv::FileStorage* fs, double value) {
		try {
			cv::writeScalar(*fs, value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeScalar(cv::FileStorage &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:714
	Result_void cv_writeScalar_FileStorageR_float(cv::FileStorage* fs, float value) {
		try {
			cv::writeScalar(*fs, value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeScalar(cv::FileStorage &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:713
	Result_void cv_writeScalar_FileStorageR_int(cv::FileStorage* fs, int value) {
		try {
			cv::writeScalar(*fs, value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:706
	Result_void cv_write_FileStorageR_const_StringR_const_MatR(cv::FileStorage* fs, const char* name, const cv::Mat* value) {
		try {
			cv::write(*fs, std::string(name), *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const cv::SparseMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:707
	Result_void cv_write_FileStorageR_const_StringR_const_SparseMatR(cv::FileStorage* fs, const char* name, const cv::SparseMat* value) {
		try {
			cv::write(*fs, std::string(name), *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:705
	Result_void cv_write_FileStorageR_const_StringR_const_StringR(cv::FileStorage* fs, const char* name, const char* value) {
		try {
			cv::write(*fs, std::string(name), std::string(value));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const std::vector<DMatch> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:710
	Result_void cv_write_FileStorageR_const_StringR_const_vector_DMatch_R(cv::FileStorage* fs, const char* name, const std::vector<cv::DMatch>* value) {
		try {
			cv::write(*fs, std::string(name), *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, const std::vector<KeyPoint> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:709
	Result_void cv_write_FileStorageR_const_StringR_const_vector_KeyPoint_R(cv::FileStorage* fs, const char* name, const std::vector<cv::KeyPoint>* value) {
		try {
			cv::write(*fs, std::string(name), *value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:704
	Result_void cv_write_FileStorageR_const_StringR_double(cv::FileStorage* fs, const char* name, double value) {
		try {
			cv::write(*fs, std::string(name), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:703
	Result_void cv_write_FileStorageR_const_StringR_float(cv::FileStorage* fs, const char* name, float value) {
		try {
			cv::write(*fs, std::string(name), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:702
	Result_void cv_write_FileStorageR_const_StringR_int(cv::FileStorage* fs, const char* name, int value) {
		try {
			cv::write(*fs, std::string(name), value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Algorithm_delete(cv::Algorithm* instance) {
		delete instance;
	}
	// Algorithm() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3093
	Result<cv::Algorithm*> cv_Algorithm_Algorithm() {
		try {
			cv::Algorithm* ret = new cv::Algorithm();
			return Ok<cv::Algorithm*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Algorithm*>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3098
	Result_void cv_Algorithm_clear(cv::Algorithm* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3102
	Result_void cv_Algorithm_write_const_FileStorageR(const cv::Algorithm* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const Ptr<cv::FileStorage> &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3107
	Result_void cv_Algorithm_write_const_const_Ptr_FileStorage_R_const_StringR(const cv::Algorithm* instance, const cv::Ptr<cv::FileStorage>* fs, const char* name) {
		try {
			instance->write(*fs, std::string(name));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3111
	Result_void cv_Algorithm_read_const_FileNodeR(cv::Algorithm* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3115
	Result<bool> cv_Algorithm_empty_const(const cv::Algorithm* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// save(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3179
	Result_void cv_Algorithm_save_const_const_StringR(const cv::Algorithm* instance, const char* filename) {
		try {
			instance->save(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3183
	Result<void*> cv_Algorithm_getDefaultName_const(const cv::Algorithm* instance) {
		try {
			cv::String ret = instance->getDefaultName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	void cv_AsyncArray_delete(cv::AsyncArray* instance) {
		delete instance;
	}
	// AsyncArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:35
	cv::AsyncArray* cv_AsyncArray_AsyncArray() {
		cv::AsyncArray* ret = new cv::AsyncArray();
		return (cv::AsyncArray*)ret;
	}
	
	// AsyncArray(const cv::AsyncArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:36
	cv::AsyncArray* cv_AsyncArray_AsyncArray_const_AsyncArrayR(const cv::AsyncArray* o) {
		cv::AsyncArray* ret = new cv::AsyncArray(*o);
		return (cv::AsyncArray*)ret;
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:38
	void cv_AsyncArray_release(cv::AsyncArray* instance) {
		instance->release();
	}
	
	// get(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:50
	Result_void cv_AsyncArray_get_const_const__OutputArrayR(const cv::AsyncArray* instance, const cv::_OutputArray* dst) {
		try {
			instance->get(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// get(cv::OutputArray, int64) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:60
	Result<bool> cv_AsyncArray_get_const_const__OutputArrayR_int64_t(const cv::AsyncArray* instance, const cv::_OutputArray* dst, int64_t timeoutNs) {
		try {
			bool ret = instance->get(*dst, timeoutNs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// get(cv::OutputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:63
	Result<bool> cv_AsyncArray_get_const_const__OutputArrayR_double(const cv::AsyncArray* instance, const cv::_OutputArray* dst, double timeoutNs) {
		try {
			bool ret = instance->get(*dst, timeoutNs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// wait_for(int64) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:65
	Result<bool> cv_AsyncArray_wait_for_const_int64_t(const cv::AsyncArray* instance, int64_t timeoutNs) {
		try {
			bool ret = instance->wait_for(timeoutNs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// wait_for(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:68
	Result<bool> cv_AsyncArray_wait_for_const_double(const cv::AsyncArray* instance, double timeoutNs) {
		try {
			bool ret = instance->wait_for(timeoutNs);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// valid() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:70
	bool cv_AsyncArray_valid_const(const cv::AsyncArray* instance) {
		bool ret = instance->valid();
		return (bool)ret;
	}
	
	// AsyncArray(cv::AsyncArray &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/async.hpp:73
	Result<cv::AsyncArray*> cv_AsyncArray_AsyncArray_AsyncArrayR(cv::AsyncArray* o) {
		try {
			cv::AsyncArray* ret = new cv::AsyncArray(*o);
			return Ok<cv::AsyncArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncArray*>))
	}
	
	void cv_AsyncPromise_delete(cv::AsyncPromise* instance) {
		delete instance;
	}
	// AsyncPromise() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:26
	cv::AsyncPromise* cv_AsyncPromise_AsyncPromise() {
		cv::AsyncPromise* ret = new cv::AsyncPromise();
		return (cv::AsyncPromise*)ret;
	}
	
	// AsyncPromise(const cv::AsyncPromise &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:27
	cv::AsyncPromise* cv_AsyncPromise_AsyncPromise_const_AsyncPromiseR(const cv::AsyncPromise* o) {
		cv::AsyncPromise* ret = new cv::AsyncPromise(*o);
		return (cv::AsyncPromise*)ret;
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:29
	void cv_AsyncPromise_release(cv::AsyncPromise* instance) {
		instance->release();
	}
	
	// getArrayResult() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:34
	Result<cv::AsyncArray*> cv_AsyncPromise_getArrayResult(cv::AsyncPromise* instance) {
		try {
			cv::AsyncArray ret = instance->getArrayResult();
			return Ok(new cv::AsyncArray(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncArray*>))
	}
	
	// setValue(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:39
	Result_void cv_AsyncPromise_setValue_const__InputArrayR(cv::AsyncPromise* instance, const cv::_InputArray* value) {
		try {
			instance->setValue(*value);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setException(const cv::Exception &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:53
	Result_void cv_AsyncPromise_setException_const_ExceptionR(cv::AsyncPromise* instance, const cv::Exception* exception) {
		try {
			instance->setException(*exception);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// AsyncPromise(cv::AsyncPromise &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:56
	Result<cv::AsyncPromise*> cv_AsyncPromise_AsyncPromise_AsyncPromiseR(cv::AsyncPromise* o) {
		try {
			cv::AsyncPromise* ret = new cv::AsyncPromise(*o);
			return Ok<cv::AsyncPromise*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::AsyncPromise*>))
	}
	
	// _getImpl() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/detail/async_promise.hpp:63
	void* cv_AsyncPromise__getImpl_const(const cv::AsyncPromise* instance) {
		void* ret = instance->_getImpl();
		return (void*)ret;
	}
	
	void cv_CommandLineParser_delete(cv::CommandLineParser* instance) {
		delete instance;
	}
	// CommandLineParser(int, const char *const *, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:829
	Result<cv::CommandLineParser*> cv_CommandLineParser_CommandLineParser_int_const_charXX_const_StringR(int argc, const char** argv, const char* keys) {
		try {
			cv::CommandLineParser* ret = new cv::CommandLineParser(argc, argv, std::string(keys));
			return Ok<cv::CommandLineParser*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CommandLineParser*>))
	}
	
	// CommandLineParser(const cv::CommandLineParser &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:832
	Result<cv::CommandLineParser*> cv_CommandLineParser_CommandLineParser_const_CommandLineParserR(const cv::CommandLineParser* parser) {
		try {
			cv::CommandLineParser* ret = new cv::CommandLineParser(*parser);
			return Ok<cv::CommandLineParser*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::CommandLineParser*>))
	}
	
	// getPathToApplication() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:850
	Result<void*> cv_CommandLineParser_getPathToApplication_const(const cv::CommandLineParser* instance) {
		try {
			cv::String ret = instance->getPathToApplication();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// has(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:927
	Result<bool> cv_CommandLineParser_has_const_const_StringR(const cv::CommandLineParser* instance, const char* name) {
		try {
			bool ret = instance->has(std::string(name));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// check() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:934
	Result<bool> cv_CommandLineParser_check_const(const cv::CommandLineParser* instance) {
		try {
			bool ret = instance->check();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// about(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:940
	Result_void cv_CommandLineParser_about_const_StringR(cv::CommandLineParser* instance, const char* message) {
		try {
			instance->about(std::string(message));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// printMessage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:948
	Result_void cv_CommandLineParser_printMessage_const(const cv::CommandLineParser* instance) {
		try {
			instance->printMessage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// printErrors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:954
	Result_void cv_CommandLineParser_printErrors_const(const cv::CommandLineParser* instance) {
		try {
			instance->printErrors();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const Ptr<MinProblemSolver::Function> &, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:252
	Result<cv::Ptr<cv::ConjGradSolver>*> cv_ConjGradSolver_create_const_Ptr_Function_R_TermCriteria(const cv::Ptr<cv::MinProblemSolver::Function>* f, cv::TermCriteria* termcrit) {
		try {
			cv::Ptr<cv::ConjGradSolver> ret = cv::ConjGradSolver::create(*f, *termcrit);
			return Ok(new cv::Ptr<cv::ConjGradSolver>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::ConjGradSolver>*>))
	}
	
	// DMatch() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:833
	Result<cv::DMatch> cv_DMatch_DMatch() {
		try {
			cv::DMatch ret;
			return Ok<cv::DMatch>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DMatch>))
	}
	
	// DMatch(int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:834
	Result<cv::DMatch> cv_DMatch_DMatch_int_int_float(int _queryIdx, int _trainIdx, float _distance) {
		try {
			cv::DMatch ret(_queryIdx, _trainIdx, _distance);
			return Ok<cv::DMatch>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DMatch>))
	}
	
	// DMatch(int, int, int, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:835
	Result<cv::DMatch> cv_DMatch_DMatch_int_int_int_float(int _queryIdx, int _trainIdx, int _imgIdx, float _distance) {
		try {
			cv::DMatch ret(_queryIdx, _trainIdx, _imgIdx, _distance);
			return Ok<cv::DMatch>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::DMatch>))
	}
	
	// getInitStep(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:164
	Result_void cv_DownhillSolver_getInitStep_const_const__OutputArrayR(const cv::DownhillSolver* instance, const cv::_OutputArray* step) {
		try {
			instance->getInitStep(*step);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setInitStep(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:180
	Result_void cv_DownhillSolver_setInitStep_const__InputArrayR(cv::DownhillSolver* instance, const cv::_InputArray* step) {
		try {
			instance->setInitStep(*step);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const Ptr<MinProblemSolver::Function> &, cv::InputArray, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:198
	Result<cv::Ptr<cv::DownhillSolver>*> cv_DownhillSolver_create_const_Ptr_Function_R_const__InputArrayR_TermCriteria(const cv::Ptr<cv::MinProblemSolver::Function>* f, const cv::_InputArray* initStep, cv::TermCriteria* termcrit) {
		try {
			cv::Ptr<cv::DownhillSolver> ret = cv::DownhillSolver::create(*f, *initStep, *termcrit);
			return Ok(new cv::Ptr<cv::DownhillSolver>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::DownhillSolver>*>))
	}
	
	// msg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:138
	void* cv_Exception_getPropMsg_const(const cv::Exception* instance) {
		cv::String ret = instance->msg;
		return ocvrs_create_string(ret.c_str());
	}
	
	// msg /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:138
	void cv_Exception_setPropMsg_String(cv::Exception* instance, char* val) {
		instance->msg = std::string(val);
	}
	
	// code /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:140
	int cv_Exception_getPropCode_const(const cv::Exception* instance) {
		int ret = instance->code;
		return (int)ret;
	}
	
	// code /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:140
	void cv_Exception_setPropCode_int(cv::Exception* instance, int val) {
		instance->code = val;
	}
	
	// err /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:141
	void* cv_Exception_getPropErr_const(const cv::Exception* instance) {
		cv::String ret = instance->err;
		return ocvrs_create_string(ret.c_str());
	}
	
	// err /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:141
	void cv_Exception_setPropErr_String(cv::Exception* instance, char* val) {
		instance->err = std::string(val);
	}
	
	// func /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:142
	void* cv_Exception_getPropFunc_const(const cv::Exception* instance) {
		cv::String ret = instance->func;
		return ocvrs_create_string(ret.c_str());
	}
	
	// func /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:142
	void cv_Exception_setPropFunc_String(cv::Exception* instance, char* val) {
		instance->func = std::string(val);
	}
	
	// file /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:143
	void* cv_Exception_getPropFile_const(const cv::Exception* instance) {
		cv::String ret = instance->file;
		return ocvrs_create_string(ret.c_str());
	}
	
	// file /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:143
	void cv_Exception_setPropFile_String(cv::Exception* instance, char* val) {
		instance->file = std::string(val);
	}
	
	// line /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:144
	int cv_Exception_getPropLine_const(const cv::Exception* instance) {
		int ret = instance->line;
		return (int)ret;
	}
	
	// line /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:144
	void cv_Exception_setPropLine_int(cv::Exception* instance, int val) {
		instance->line = val;
	}
	
	void cv_Exception_delete(cv::Exception* instance) {
		delete instance;
	}
	// Exception() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:124
	Result<cv::Exception*> cv_Exception_Exception() {
		try {
			cv::Exception* ret = new cv::Exception();
			return Ok<cv::Exception*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Exception*>))
	}
	
	// Exception(int, const cv::String &, const cv::String &, const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:129
	Result<cv::Exception*> cv_Exception_Exception_int_const_StringR_const_StringR_const_StringR_int(int _code, const char* _err, const char* _func, const char* _file, int _line) {
		try {
			cv::Exception* ret = new cv::Exception(_code, std::string(_err), std::string(_func), std::string(_file), _line);
			return Ok<cv::Exception*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Exception*>))
	}
	
	// what() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:135
	Result<void*> cv_Exception_what_const(const cv::Exception* instance) {
		try {
			const char* ret = instance->what();
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// formatMessage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:136
	Result_void cv_Exception_formatMessage(cv::Exception* instance) {
		try {
			instance->formatMessage();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// blockIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:623
	size_t cv_FileNode_getPropBlockIdx_const(const cv::FileNode* instance) {
		size_t ret = instance->blockIdx;
		return (size_t)ret;
	}
	
	// blockIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:623
	void cv_FileNode_setPropBlockIdx_size_t(cv::FileNode* instance, size_t val) {
		instance->blockIdx = val;
	}
	
	// ofs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:624
	size_t cv_FileNode_getPropOfs_const(const cv::FileNode* instance) {
		size_t ret = instance->ofs;
		return (size_t)ret;
	}
	
	// ofs /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:624
	void cv_FileNode_setPropOfs_size_t(cv::FileNode* instance, size_t val) {
		instance->ofs = val;
	}
	
	void cv_FileNode_delete(cv::FileNode* instance) {
		delete instance;
	}
	// FileNode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:508
	Result<cv::FileNode*> cv_FileNode_FileNode() {
		try {
			cv::FileNode* ret = new cv::FileNode();
			return Ok<cv::FileNode*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// FileNode(const cv::FileStorage *, size_t, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:517
	Result<cv::FileNode*> cv_FileNode_FileNode_const_FileStorageX_size_t_size_t(const cv::FileStorage* fs, size_t blockIdx, size_t ofs) {
		try {
			cv::FileNode* ret = new cv::FileNode(fs, blockIdx, ofs);
			return Ok<cv::FileNode*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// FileNode(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:522
	Result<cv::FileNode*> cv_FileNode_FileNode_const_FileNodeR(const cv::FileNode* node) {
		try {
			cv::FileNode* ret = new cv::FileNode(*node);
			return Ok<cv::FileNode*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// operator[](const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:530
	Result<cv::FileNode*> cv_FileNode_operator___const_const_StringR(const cv::FileNode* instance, const char* nodename) {
		try {
			cv::FileNode ret = instance->operator[](std::string(nodename));
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// operator[](const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:535
	Result<cv::FileNode*> cv_FileNode_operator___const_const_charX(const cv::FileNode* instance, const char* nodename) {
		try {
			cv::FileNode ret = instance->operator[](nodename);
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:540
	Result<cv::FileNode*> cv_FileNode_operator___const_int(const cv::FileNode* instance, int i) {
		try {
			cv::FileNode ret = instance->operator[](i);
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// keys() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:545
	Result<std::vector<cv::String>*> cv_FileNode_keys_const(const cv::FileNode* instance) {
		try {
			std::vector<cv::String> ret = instance->keys();
			return Ok(new std::vector<cv::String>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::String>*>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:550
	Result<int> cv_FileNode_type_const(const cv::FileNode* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:553
	Result<bool> cv_FileNode_empty_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isNone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:555
	Result<bool> cv_FileNode_isNone_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isNone();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSeq() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:557
	Result<bool> cv_FileNode_isSeq_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isSeq();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isMap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:559
	Result<bool> cv_FileNode_isMap_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isMap();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isInt() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:561
	Result<bool> cv_FileNode_isInt_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isInt();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isReal() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:563
	Result<bool> cv_FileNode_isReal_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isReal();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isString() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:565
	Result<bool> cv_FileNode_isString_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isString();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isNamed() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:567
	Result<bool> cv_FileNode_isNamed_const(const cv::FileNode* instance) {
		try {
			bool ret = instance->isNamed();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:569
	Result<void*> cv_FileNode_name_const(const cv::FileNode* instance) {
		try {
			std::string ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:571
	Result<size_t> cv_FileNode_size_const(const cv::FileNode* instance) {
		try {
			size_t ret = instance->size();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// rawSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:573
	Result<size_t> cv_FileNode_rawSize_const(const cv::FileNode* instance) {
		try {
			size_t ret = instance->rawSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// operator int() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:575
	Result<int> cv_FileNode_operator_int_const(const cv::FileNode* instance) {
		try {
			int ret = instance->operator int();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// operator float() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:577
	Result<float> cv_FileNode_operator_float_const(const cv::FileNode* instance) {
		try {
			float ret = instance->operator float();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// operator double() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:579
	Result<double> cv_FileNode_operator_double_const(const cv::FileNode* instance) {
		try {
			double ret = instance->operator double();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// operator basic_string() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:581
	Result<void*> cv_FileNode_operator_std_string_const(const cv::FileNode* instance) {
		try {
			std::string ret = instance->operator std::string();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// isMap(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:583
	Result<bool> cv_FileNode_isMap_int(int flags) {
		try {
			bool ret = cv::FileNode::isMap(flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSeq(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:584
	Result<bool> cv_FileNode_isSeq_int(int flags) {
		try {
			bool ret = cv::FileNode::isSeq(flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isCollection(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:585
	Result<bool> cv_FileNode_isCollection_int(int flags) {
		try {
			bool ret = cv::FileNode::isCollection(flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isEmptyCollection(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:586
	Result<bool> cv_FileNode_isEmptyCollection_int(int flags) {
		try {
			bool ret = cv::FileNode::isEmptyCollection(flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isFlow(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:587
	Result<bool> cv_FileNode_isFlow_int(int flags) {
		try {
			bool ret = cv::FileNode::isFlow(flags);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:589
	Result<unsigned char*> cv_FileNode_ptr(cv::FileNode* instance) {
		try {
			unsigned char* ret = instance->ptr();
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:590
	Result<const unsigned char*> cv_FileNode_ptr_const(const cv::FileNode* instance) {
		try {
			const unsigned char* ret = instance->ptr();
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// begin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:593
	Result<cv::FileNodeIterator*> cv_FileNode_begin_const(const cv::FileNode* instance) {
		try {
			cv::FileNodeIterator ret = instance->begin();
			return Ok(new cv::FileNodeIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// end() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:595
	Result<cv::FileNodeIterator*> cv_FileNode_end_const(const cv::FileNode* instance) {
		try {
			cv::FileNodeIterator ret = instance->end();
			return Ok(new cv::FileNodeIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// readRaw(const cv::String &, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:605
	Result_void cv_FileNode_readRaw_const_const_StringR_voidX_size_t(const cv::FileNode* instance, const char* fmt, void* vec, size_t len) {
		try {
			instance->readRaw(std::string(fmt), vec, len);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setValue(int, const void *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:610
	Result_void cv_FileNode_setValue_int_const_voidX_int(cv::FileNode* instance, int type, const void* value, int len) {
		try {
			instance->setValue(type, value, len);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// real() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:613
	Result<double> cv_FileNode_real_const(const cv::FileNode* instance) {
		try {
			double ret = instance->real();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// string() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:615
	Result<void*> cv_FileNode_string_const(const cv::FileNode* instance) {
		try {
			std::string ret = instance->string();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// mat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:617
	Result<cv::Mat*> cv_FileNode_mat_const(const cv::FileNode* instance) {
		try {
			cv::Mat ret = instance->mat();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	void cv_FileNodeIterator_delete(cv::FileNodeIterator* instance) {
		delete instance;
	}
	// FileNodeIterator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:641
	Result<cv::FileNodeIterator*> cv_FileNodeIterator_FileNodeIterator() {
		try {
			cv::FileNodeIterator* ret = new cv::FileNodeIterator();
			return Ok<cv::FileNodeIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// FileNodeIterator(const cv::FileNode &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:651
	Result<cv::FileNodeIterator*> cv_FileNodeIterator_FileNodeIterator_const_FileNodeR_bool(const cv::FileNode* node, bool seekEnd) {
		try {
			cv::FileNodeIterator* ret = new cv::FileNodeIterator(*node, seekEnd);
			return Ok<cv::FileNodeIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// FileNodeIterator(const cv::FileNodeIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:656
	Result<cv::FileNodeIterator*> cv_FileNodeIterator_FileNodeIterator_const_FileNodeIteratorR(const cv::FileNodeIterator* it) {
		try {
			cv::FileNodeIterator* ret = new cv::FileNodeIterator(*it);
			return Ok<cv::FileNodeIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// operator*() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:661
	Result<cv::FileNode*> cv_FileNodeIterator_operatorX_const(const cv::FileNodeIterator* instance) {
		try {
			cv::FileNode ret = instance->operator*();
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// readRaw(const cv::String &, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:678
	Result<cv::FileNodeIterator*> cv_FileNodeIterator_readRaw_const_StringR_voidX_size_t(cv::FileNodeIterator* instance, const char* fmt, void* vec, size_t len) {
		try {
			cv::FileNodeIterator ret = instance->readRaw(std::string(fmt), vec, len);
			return Ok(new cv::FileNodeIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNodeIterator*>))
	}
	
	// remaining() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:682
	Result<size_t> cv_FileNodeIterator_remaining_const(const cv::FileNodeIterator* instance) {
		try {
			size_t ret = instance->remaining();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// equalTo(const cv::FileNodeIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:684
	Result<bool> cv_FileNodeIterator_equalTo_const_const_FileNodeIteratorR(const cv::FileNodeIterator* instance, const cv::FileNodeIterator* it) {
		try {
			bool ret = instance->equalTo(*it);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// state /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:462
	int cv_FileStorage_getPropState_const(const cv::FileStorage* instance) {
		int ret = instance->state;
		return (int)ret;
	}
	
	// state /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:462
	void cv_FileStorage_setPropState_int(cv::FileStorage* instance, int val) {
		instance->state = val;
	}
	
	// elname /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:463
	void* cv_FileStorage_getPropElname_const(const cv::FileStorage* instance) {
		std::string ret = instance->elname;
		return ocvrs_create_string(ret.c_str());
	}
	
	// elname /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:463
	void cv_FileStorage_setPropElname_string(cv::FileStorage* instance, char* val) {
		instance->elname = std::string(val);
	}
	
	void cv_FileStorage_delete(cv::FileStorage* instance) {
		delete instance;
	}
	// FileStorage() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:336
	Result<cv::FileStorage*> cv_FileStorage_FileStorage() {
		try {
			cv::FileStorage* ret = new cv::FileStorage();
			return Ok<cv::FileStorage*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileStorage*>))
	}
	
	// FileStorage(const cv::String &, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:341
	Result<cv::FileStorage*> cv_FileStorage_FileStorage_const_StringR_int_const_StringR(const char* filename, int flags, const char* encoding) {
		try {
			cv::FileStorage* ret = new cv::FileStorage(std::string(filename), flags, std::string(encoding));
			return Ok<cv::FileStorage*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileStorage*>))
	}
	
	// open(const cv::String &, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:361
	Result<bool> cv_FileStorage_open_const_StringR_int_const_StringR(cv::FileStorage* instance, const char* filename, int flags, const char* encoding) {
		try {
			bool ret = instance->open(std::string(filename), flags, std::string(encoding));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isOpened() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:368
	Result<bool> cv_FileStorage_isOpened_const(const cv::FileStorage* instance) {
		try {
			bool ret = instance->isOpened();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:374
	Result_void cv_FileStorage_release(cv::FileStorage* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// releaseAndGetString() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:381
	Result<void*> cv_FileStorage_releaseAndGetString(cv::FileStorage* instance) {
		try {
			cv::String ret = instance->releaseAndGetString();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getFirstTopLevelNode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:386
	Result<cv::FileNode*> cv_FileStorage_getFirstTopLevelNode_const(const cv::FileStorage* instance) {
		try {
			cv::FileNode ret = instance->getFirstTopLevelNode();
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// root(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:393
	Result<cv::FileNode*> cv_FileStorage_root_const_int(const cv::FileStorage* instance, int streamidx) {
		try {
			cv::FileNode ret = instance->root(streamidx);
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// operator[](const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:399
	Result<cv::FileNode*> cv_FileStorage_operator___const_const_StringR(const cv::FileStorage* instance, const char* nodename) {
		try {
			cv::FileNode ret = instance->operator[](std::string(nodename));
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// operator[](const char *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:402
	Result<cv::FileNode*> cv_FileStorage_operator___const_const_charX(const cv::FileStorage* instance, const char* nodename) {
		try {
			cv::FileNode ret = instance->operator[](nodename);
			return Ok(new cv::FileNode(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::FileNode*>))
	}
	
	// write(const cv::String &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:409
	Result_void cv_FileStorage_write_const_StringR_int(cv::FileStorage* instance, const char* name, int val) {
		try {
			instance->write(std::string(name), val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:411
	Result_void cv_FileStorage_write_const_StringR_double(cv::FileStorage* instance, const char* name, double val) {
		try {
			instance->write(std::string(name), val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:413
	Result_void cv_FileStorage_write_const_StringR_const_StringR(cv::FileStorage* instance, const char* name, const char* val) {
		try {
			instance->write(std::string(name), std::string(val));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &, const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:415
	Result_void cv_FileStorage_write_const_StringR_const_MatR(cv::FileStorage* instance, const char* name, const cv::Mat* val) {
		try {
			instance->write(std::string(name), *val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(const cv::String &, const std::vector<String> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:417
	Result_void cv_FileStorage_write_const_StringR_const_vector_String_R(cv::FileStorage* instance, const char* name, const std::vector<cv::String>* val) {
		try {
			instance->write(std::string(name), *val);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeRaw(const cv::String &, const void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:427
	Result_void cv_FileStorage_writeRaw_const_StringR_const_voidX_size_t(cv::FileStorage* instance, const char* fmt, const void* vec, size_t len) {
		try {
			instance->writeRaw(std::string(fmt), vec, len);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// writeComment(const cv::String &, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:437
	Result_void cv_FileStorage_writeComment_const_StringR_bool(cv::FileStorage* instance, const char* comment, bool append) {
		try {
			instance->writeComment(std::string(comment), append);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// startWriteStruct(const cv::String &, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:445
	Result_void cv_FileStorage_startWriteStruct_const_StringR_int_const_StringR(cv::FileStorage* instance, const char* name, int flags, const char* typeName) {
		try {
			instance->startWriteStruct(std::string(name), flags, std::string(typeName));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// endWriteStruct() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:449
	Result_void cv_FileStorage_endWriteStruct(cv::FileStorage* instance) {
		try {
			instance->endWriteStruct();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefaultObjectName(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:455
	Result<void*> cv_FileStorage_getDefaultObjectName_const_StringR(const char* filename) {
		try {
			cv::String ret = cv::FileStorage::getDefaultObjectName(std::string(filename));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getFormat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:460
	Result<int> cv_FileStorage_getFormat_const(const cv::FileStorage* instance) {
		try {
			int ret = instance->getFormat();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// next() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3026
	Result<void*> cv_Formatted_next(cv::Formatted* instance) {
		try {
			const char* ret = instance->next();
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3027
	Result_void cv_Formatted_reset(cv::Formatted* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// format(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3046
	Result<cv::Ptr<cv::Formatted>*> cv_Formatter_format_const_const_MatR(const cv::Formatter* instance, const cv::Mat* mtx) {
		try {
			cv::Ptr<cv::Formatted> ret = instance->format(*mtx);
			return Ok(new cv::Ptr<cv::Formatted>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::Formatted>*>))
	}
	
	// set16fPrecision(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3048
	Result_void cv_Formatter_set16fPrecision_int(cv::Formatter* instance, int p) {
		try {
			instance->set16fPrecision(p);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// set32fPrecision(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3049
	Result_void cv_Formatter_set32fPrecision_int(cv::Formatter* instance, int p) {
		try {
			instance->set32fPrecision(p);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// set64fPrecision(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3050
	Result_void cv_Formatter_set64fPrecision_int(cv::Formatter* instance, int p) {
		try {
			instance->set64fPrecision(p);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setMultiline(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3051
	Result_void cv_Formatter_setMultiline_bool(cv::Formatter* instance, bool ml) {
		try {
			instance->setMultiline(ml);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// get(Formatter::FormatType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:3053
	Result<cv::Ptr<cv::Formatter>*> cv_Formatter_get_FormatType(cv::Formatter::FormatType fmt) {
		try {
			cv::Ptr<cv::Formatter> ret = cv::Formatter::get(fmt);
			return Ok(new cv::Ptr<cv::Formatter>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::Formatter>*>))
	}
	
	void cv_Hamming_delete(cv::Hamming* instance) {
		delete instance;
	}
	// KeyPoint() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:737
	Result<cv::KeyPoint> cv_KeyPoint_KeyPoint() {
		try {
			cv::KeyPoint ret;
			return Ok<cv::KeyPoint>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KeyPoint>))
	}
	
	// KeyPoint(cv::Point2f, float, float, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:746
	Result<cv::KeyPoint> cv_KeyPoint_KeyPoint_Point2f_float_float_float_int_int(cv::Point2f* pt, float size, float angle, float response, int octave, int class_id) {
		try {
			cv::KeyPoint ret(*pt, size, angle, response, octave, class_id);
			return Ok<cv::KeyPoint>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KeyPoint>))
	}
	
	// KeyPoint(float, float, float, float, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:756
	Result<cv::KeyPoint> cv_KeyPoint_KeyPoint_float_float_float_float_float_int_int(float x, float y, float size, float angle, float response, int octave, int class_id) {
		try {
			cv::KeyPoint ret(x, y, size, angle, response, octave, class_id);
			return Ok<cv::KeyPoint>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::KeyPoint>))
	}
	
	// hash() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:758
	Result<size_t> cv_KeyPoint_hash_const(const cv::KeyPoint instance) {
		try {
			size_t ret = instance.hash();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// convert(const std::vector<KeyPoint> &, std::vector<Point2f> &, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:769
	Result_void cv_KeyPoint_convert_const_vector_KeyPoint_R_vector_Point2f_R_const_vector_int_R(const std::vector<cv::KeyPoint>* keypoints, std::vector<cv::Point2f>* points2f, const std::vector<int>* keypointIndexes) {
		try {
			cv::KeyPoint::convert(*keypoints, *points2f, *keypointIndexes);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convert(const std::vector<Point2f> &, std::vector<KeyPoint> &, float, float, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:780
	Result_void cv_KeyPoint_convert_const_vector_Point2f_R_vector_KeyPoint_R_float_float_int_int(const std::vector<cv::Point2f>* points2f, std::vector<cv::KeyPoint>* keypoints, float size, float response, int octave, int class_id) {
		try {
			cv::KeyPoint::convert(*points2f, *keypoints, size, response, octave, class_id);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// overlap(const cv::KeyPoint &, const cv::KeyPoint &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:791
	Result<float> cv_KeyPoint_overlap_const_KeyPointR_const_KeyPointR(const cv::KeyPoint* kp1, const cv::KeyPoint* kp2) {
		try {
			float ret = cv::KeyPoint::overlap(*kp1, *kp2);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	void cv_LDA_delete(cv::LDA* instance) {
		delete instance;
	}
	// LDA(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2568
	Result<cv::LDA*> cv_LDA_LDA_int(int num_components) {
		try {
			cv::LDA* ret = new cv::LDA(num_components);
			return Ok<cv::LDA*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LDA*>))
	}
	
	// LDA(cv::InputArrayOfArrays, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2575
	Result<cv::LDA*> cv_LDA_LDA_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* src, const cv::_InputArray* labels, int num_components) {
		try {
			cv::LDA* ret = new cv::LDA(*src, *labels, num_components);
			return Ok<cv::LDA*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::LDA*>))
	}
	
	// save(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2579
	Result_void cv_LDA_save_const_const_StringR(const cv::LDA* instance, const char* filename) {
		try {
			instance->save(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// load(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2583
	Result_void cv_LDA_load_const_StringR(cv::LDA* instance, const char* filename) {
		try {
			instance->load(std::string(filename));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// save(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2587
	Result_void cv_LDA_save_const_FileStorageR(const cv::LDA* instance, cv::FileStorage* fs) {
		try {
			instance->save(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// load(const cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2591
	Result_void cv_LDA_load_const_FileStorageR(cv::LDA* instance, const cv::FileStorage* node) {
		try {
			instance->load(*node);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArrayOfArrays, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2599
	Result_void cv_LDA_compute_const__InputArrayR_const__InputArrayR(cv::LDA* instance, const cv::_InputArray* src, const cv::_InputArray* labels) {
		try {
			instance->compute(*src, *labels);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// project(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2604
	Result<cv::Mat*> cv_LDA_project_const__InputArrayR(cv::LDA* instance, const cv::_InputArray* src) {
		try {
			cv::Mat ret = instance->project(*src);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// reconstruct(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2609
	Result<cv::Mat*> cv_LDA_reconstruct_const__InputArrayR(cv::LDA* instance, const cv::_InputArray* src) {
		try {
			cv::Mat ret = instance->reconstruct(*src);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// eigenvectors() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2613
	Result<cv::Mat*> cv_LDA_eigenvectors_const(const cv::LDA* instance) {
		try {
			cv::Mat ret = instance->eigenvectors();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// eigenvalues() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2617
	Result<cv::Mat*> cv_LDA_eigenvalues_const(const cv::LDA* instance) {
		try {
			cv::Mat ret = instance->eigenvalues();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// subspaceProject(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2619
	Result<cv::Mat*> cv_LDA_subspaceProject_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* W, const cv::_InputArray* mean, const cv::_InputArray* src) {
		try {
			cv::Mat ret = cv::LDA::subspaceProject(*W, *mean, *src);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// subspaceReconstruct(cv::InputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2620
	Result<cv::Mat*> cv_LDA_subspaceReconstruct_const__InputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* W, const cv::_InputArray* mean, const cv::_InputArray* src) {
		try {
			cv::Mat ret = cv::LDA::subspaceReconstruct(*W, *mean, *src);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2103
	int cv_Mat_getPropFlags_const(const cv::Mat* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2103
	void cv_Mat_setPropFlags_int(cv::Mat* instance, int val) {
		instance->flags = val;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2105
	int cv_Mat_getPropDims_const(const cv::Mat* instance) {
		int ret = instance->dims;
		return (int)ret;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2105
	void cv_Mat_setPropDims_int(cv::Mat* instance, int val) {
		instance->dims = val;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2107
	int cv_Mat_getPropRows_const(const cv::Mat* instance) {
		int ret = instance->rows;
		return (int)ret;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2107
	void cv_Mat_setPropRows_int(cv::Mat* instance, int val) {
		instance->rows = val;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2107
	int cv_Mat_getPropCols_const(const cv::Mat* instance) {
		int ret = instance->cols;
		return (int)ret;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2107
	void cv_Mat_setPropCols_int(cv::Mat* instance, int val) {
		instance->cols = val;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2109
	unsigned char* cv_Mat_getPropData(cv::Mat* instance) {
		unsigned char* ret = instance->data;
		return (unsigned char*)ret;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2109
	void cv_Mat_setPropData_unsigned_charX(cv::Mat* instance, unsigned char* val) {
		instance->data = val;
	}
	
	// datastart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2112
	const unsigned char* cv_Mat_getPropDatastart_const(const cv::Mat* instance) {
		const unsigned char* ret = instance->datastart;
		return (const unsigned char*)ret;
	}
	
	// dataend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2113
	const unsigned char* cv_Mat_getPropDataend_const(const cv::Mat* instance) {
		const unsigned char* ret = instance->dataend;
		return (const unsigned char*)ret;
	}
	
	// datalimit /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2114
	const unsigned char* cv_Mat_getPropDatalimit_const(const cv::Mat* instance) {
		const unsigned char* ret = instance->datalimit;
		return (const unsigned char*)ret;
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2127
	cv::UMatData** cv_Mat_getPropU(cv::Mat* instance) {
		cv::UMatData* ret = instance->u;
		return new cv::UMatData*(ret);
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2127
	void cv_Mat_setPropU_UMatDataX(cv::Mat* instance, cv::UMatData* val) {
		instance->u = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2129
	cv::MatSize* cv_Mat_getPropSize_const(const cv::Mat* instance) {
		cv::MatSize ret = instance->size;
		return new cv::MatSize(ret);
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2130
	cv::MatStep* cv_Mat_getPropStep_const(const cv::Mat* instance) {
		cv::MatStep ret = instance->step;
		return new cv::MatStep(ret);
	}
	
	void cv_Mat_delete(cv::Mat* instance) {
		delete instance;
	}
	// Mat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:810
	cv::Mat* cv_Mat_Mat() {
		cv::Mat* ret = new cv::Mat();
		return (cv::Mat*)ret;
	}
	
	// Mat(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:818
	Result<cv::Mat*> cv_Mat_Mat_int_int_int(int rows, int cols, int type) {
		try {
			cv::Mat* ret = new cv::Mat(rows, cols, type);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:826
	Result<cv::Mat*> cv_Mat_Mat_Size_int(cv::Size* size, int type) {
		try {
			cv::Mat* ret = new cv::Mat(*size, type);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(int, int, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:837
	Result<cv::Mat*> cv_Mat_Mat_int_int_int_const_ScalarR(int rows, int cols, int type, const cv::Scalar* s) {
		try {
			cv::Mat* ret = new cv::Mat(rows, cols, type, *s);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(cv::Size, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:848
	Result<cv::Mat*> cv_Mat_Mat_Size_int_const_ScalarR(cv::Size* size, int type, const cv::Scalar* s) {
		try {
			cv::Mat* ret = new cv::Mat(*size, type, *s);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:856
	Result<cv::Mat*> cv_Mat_Mat_int_const_intX_int(int ndims, const int* sizes, int type) {
		try {
			cv::Mat* ret = new cv::Mat(ndims, sizes, type);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const std::vector<int> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:863
	Result<cv::Mat*> cv_Mat_Mat_const_vector_int_R_int(const std::vector<int>* sizes, int type) {
		try {
			cv::Mat* ret = new cv::Mat(*sizes, type);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(int, const int *, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:874
	Result<cv::Mat*> cv_Mat_Mat_int_const_intX_int_const_ScalarR(int ndims, const int* sizes, int type, const cv::Scalar* s) {
		try {
			cv::Mat* ret = new cv::Mat(ndims, sizes, type, *s);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const std::vector<int> &, int, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:884
	Result<cv::Mat*> cv_Mat_Mat_const_vector_int_R_int_const_ScalarR(const std::vector<int>* sizes, int type, const cv::Scalar* s) {
		try {
			cv::Mat* ret = new cv::Mat(*sizes, type, *s);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:894
	Result<cv::Mat*> cv_Mat_Mat_const_MatR(const cv::Mat* m) {
		try {
			cv::Mat* ret = new cv::Mat(*m);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(int, int, int, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:910
	Result<cv::Mat*> cv_Mat_Mat_int_int_int_voidX_size_t(int rows, int cols, int type, void* data, size_t step) {
		try {
			cv::Mat* ret = new cv::Mat(rows, cols, type, data, step);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(cv::Size, int, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:926
	Result<cv::Mat*> cv_Mat_Mat_Size_int_voidX_size_t(cv::Size* size, int type, void* data, size_t step) {
		try {
			cv::Mat* ret = new cv::Mat(*size, type, data, step);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(int, const int *, int, void *, const size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:941
	Result<cv::Mat*> cv_Mat_Mat_int_const_intX_int_voidX_const_size_tX(int ndims, const int* sizes, int type, void* data, const size_t* steps) {
		try {
			cv::Mat* ret = new cv::Mat(ndims, sizes, type, data, steps);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const std::vector<int> &, int, void *, const size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:955
	Result<cv::Mat*> cv_Mat_Mat_const_vector_int_R_int_voidX_const_size_tX(const std::vector<int>* sizes, int type, void* data, const size_t* steps) {
		try {
			cv::Mat* ret = new cv::Mat(*sizes, type, data, steps);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const cv::Mat &, const cv::Range &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:967
	Result<cv::Mat*> cv_Mat_Mat_const_MatR_const_RangeR_const_RangeR(const cv::Mat* m, const cv::Range* rowRange, const cv::Range* colRange) {
		try {
			cv::Mat* ret = new cv::Mat(*m, *rowRange, *colRange);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const cv::Mat &, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:977
	Result<cv::Mat*> cv_Mat_Mat_const_MatR_const_RectR(const cv::Mat* m, const cv::Rect* roi) {
		try {
			cv::Mat* ret = new cv::Mat(*m, *roi);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const cv::Mat &, const std::vector<Range> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:997
	Result<cv::Mat*> cv_Mat_Mat_const_MatR_const_vector_Range_R(const cv::Mat* m, const std::vector<cv::Range>* ranges) {
		try {
			cv::Mat* ret = new cv::Mat(*m, *ranges);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// Mat(const cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1051
	Result<cv::Mat*> cv_Mat_Mat_const_GpuMatR(const cv::cuda::GpuMat* m) {
		try {
			cv::Mat* ret = new cv::Mat(*m);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getUMat(cv::AccessFlag, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1076
	Result<cv::UMat*> cv_Mat_getUMat_const_AccessFlag_UMatUsageFlags(const cv::Mat* instance, cv::AccessFlag accessFlags, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = instance->getUMat(accessFlags, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// row(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1111
	Result<cv::Mat*> cv_Mat_row_const_int(const cv::Mat* instance, int y) {
		try {
			cv::Mat ret = instance->row(y);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// col(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1120
	Result<cv::Mat*> cv_Mat_col_const_int(const cv::Mat* instance, int x) {
		try {
			cv::Mat ret = instance->col(x);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// rowRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1129
	Result<cv::Mat*> cv_Mat_rowRange_const_int_int(const cv::Mat* instance, int startrow, int endrow) {
		try {
			cv::Mat ret = instance->rowRange(startrow, endrow);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// rowRange(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1134
	Result<cv::Mat*> cv_Mat_rowRange_const_const_RangeR(const cv::Mat* instance, const cv::Range* r) {
		try {
			cv::Mat ret = instance->rowRange(*r);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// colRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1143
	Result<cv::Mat*> cv_Mat_colRange_const_int_int(const cv::Mat* instance, int startcol, int endcol) {
		try {
			cv::Mat ret = instance->colRange(startcol, endcol);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// colRange(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1148
	Result<cv::Mat*> cv_Mat_colRange_const_const_RangeR(const cv::Mat* instance, const cv::Range* r) {
		try {
			cv::Mat ret = instance->colRange(*r);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// diag(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1184
	Result<cv::Mat*> cv_Mat_diag_const_int(const cv::Mat* instance, int d) {
		try {
			cv::Mat ret = instance->diag(d);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// diag(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1191
	Result<cv::Mat*> cv_Mat_diag_const_MatR(const cv::Mat* d) {
		try {
			cv::Mat ret = cv::Mat::diag(*d);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1198
	Result<cv::Mat*> cv_Mat_clone_const(const cv::Mat* instance) {
		try {
			cv::Mat ret = instance->clone();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// copyTo(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1215
	Result_void cv_Mat_copyTo_const_const__OutputArrayR(const cv::Mat* instance, const cv::_OutputArray* m) {
		try {
			instance->copyTo(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1223
	Result_void cv_Mat_copyTo_const_const__OutputArrayR_const__InputArrayR(const cv::Mat* instance, const cv::_OutputArray* m, const cv::_InputArray* mask) {
		try {
			instance->copyTo(*m, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1238
	Result_void cv_Mat_convertTo_const_const__OutputArrayR_int_double_double(const cv::Mat* instance, const cv::_OutputArray* m, int rtype, double alpha, double beta) {
		try {
			instance->convertTo(*m, rtype, alpha, beta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assignTo(cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1246
	Result_void cv_Mat_assignTo_const_MatR_int(const cv::Mat* instance, cv::Mat* m, int type) {
		try {
			instance->assignTo(*m, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTo(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1260
	Result<cv::Mat*> cv_Mat_setTo_const__InputArrayR_const__InputArrayR(cv::Mat* instance, const cv::_InputArray* value, const cv::_InputArray* mask) {
		try {
			cv::Mat ret = instance->setTo(*value, *mask);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// reshape(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1286
	Result<cv::Mat*> cv_Mat_reshape_const_int_int(const cv::Mat* instance, int cn, int rows) {
		try {
			cv::Mat ret = instance->reshape(cn, rows);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// reshape(int, int, const int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1289
	Result<cv::Mat*> cv_Mat_reshape_const_int_int_const_intX(const cv::Mat* instance, int cn, int newndims, const int* newsz) {
		try {
			cv::Mat ret = instance->reshape(cn, newndims, newsz);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// reshape(int, const std::vector<int> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1292
	Result<cv::Mat*> cv_Mat_reshape_const_int_const_vector_int_R(const cv::Mat* instance, int cn, const std::vector<int>* newshape) {
		try {
			cv::Mat ret = instance->reshape(cn, *newshape);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// t() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1304
	Result<cv::MatExpr*> cv_Mat_t_const(const cv::Mat* instance) {
		try {
			cv::MatExpr ret = instance->t();
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// inv(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1313
	Result<cv::MatExpr*> cv_Mat_inv_const_int(const cv::Mat* instance, int method) {
		try {
			cv::MatExpr ret = instance->inv(method);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// mul(cv::InputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1327
	Result<cv::MatExpr*> cv_Mat_mul_const_const__InputArrayR_double(const cv::Mat* instance, const cv::_InputArray* m, double scale) {
		try {
			cv::MatExpr ret = instance->mul(*m, scale);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// cross(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1336
	Result<cv::Mat*> cv_Mat_cross_const_const__InputArrayR(const cv::Mat* instance, const cv::_InputArray* m) {
		try {
			cv::Mat ret = instance->cross(*m);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// dot(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1346
	Result<double> cv_Mat_dot_const_const__InputArrayR(const cv::Mat* instance, const cv::_InputArray* m) {
		try {
			double ret = instance->dot(*m);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// zeros(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1362
	Result<cv::MatExpr*> cv_Mat_zeros_int_int_int(int rows, int cols, int type) {
		try {
			cv::MatExpr ret = cv::Mat::zeros(rows, cols, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// zeros(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1368
	Result<cv::MatExpr*> cv_Mat_zeros_Size_int(cv::Size* size, int type) {
		try {
			cv::MatExpr ret = cv::Mat::zeros(*size, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// zeros(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1375
	Result<cv::MatExpr*> cv_Mat_zeros_int_const_intX_int(int ndims, const int* sz, int type) {
		try {
			cv::MatExpr ret = cv::Mat::zeros(ndims, sz, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// ones(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1393
	Result<cv::MatExpr*> cv_Mat_ones_int_int_int(int rows, int cols, int type) {
		try {
			cv::MatExpr ret = cv::Mat::ones(rows, cols, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// ones(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1399
	Result<cv::MatExpr*> cv_Mat_ones_Size_int(cv::Size* size, int type) {
		try {
			cv::MatExpr ret = cv::Mat::ones(*size, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// ones(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1406
	Result<cv::MatExpr*> cv_Mat_ones_int_const_intX_int(int ndims, const int* sz, int type) {
		try {
			cv::MatExpr ret = cv::Mat::ones(ndims, sz, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// eye(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1422
	Result<cv::MatExpr*> cv_Mat_eye_int_int_int(int rows, int cols, int type) {
		try {
			cv::MatExpr ret = cv::Mat::eye(rows, cols, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// eye(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1428
	Result<cv::MatExpr*> cv_Mat_eye_Size_int(cv::Size* size, int type) {
		try {
			cv::MatExpr ret = cv::Mat::eye(*size, type);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// create(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1463
	Result_void cv_Mat_create_int_int_int(cv::Mat* instance, int rows, int cols, int type) {
		try {
			instance->create(rows, cols, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1469
	Result_void cv_Mat_create_Size_int(cv::Mat* instance, cv::Size* size, int type) {
		try {
			instance->create(*size, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1476
	Result_void cv_Mat_create_int_const_intX_int(cv::Mat* instance, int ndims, const int* sizes, int type) {
		try {
			instance->create(ndims, sizes, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const std::vector<int> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1482
	Result_void cv_Mat_create_const_vector_int_R_int(cv::Mat* instance, const std::vector<int>* sizes, int type) {
		try {
			instance->create(*sizes, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addref() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1493
	Result_void cv_Mat_addref(cv::Mat* instance) {
		try {
			instance->addref();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1508
	Result_void cv_Mat_release(cv::Mat* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// deallocate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1511
	Result_void cv_Mat_deallocate(cv::Mat* instance) {
		try {
			instance->deallocate();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reserve(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1522
	Result_void cv_Mat_reserve_size_t(cv::Mat* instance, size_t sz) {
		try {
			instance->reserve(sz);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reserveBuffer(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1530
	Result_void cv_Mat_reserveBuffer_size_t(cv::Mat* instance, size_t sz) {
		try {
			instance->reserveBuffer(sz);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resize(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1539
	Result_void cv_Mat_resize_size_t(cv::Mat* instance, size_t sz) {
		try {
			instance->resize(sz);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resize(size_t, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1545
	Result_void cv_Mat_resize_size_t_const_ScalarR(cv::Mat* instance, size_t sz, const cv::Scalar* s) {
		try {
			instance->resize(sz, *s);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// push_back(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1572
	Result_void cv_Mat_push_back_const_MatR(cv::Mat* instance, const cv::Mat* m) {
		try {
			instance->push_back(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// pop_back(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1580
	Result_void cv_Mat_pop_back_size_t(cv::Mat* instance, size_t nelems) {
		try {
			instance->pop_back(nelems);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// locateROI(cv::Size &, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1593
	Result_void cv_Mat_locateROI_const_SizeR_PointR(const cv::Mat* instance, cv::Size* wholeSize, cv::Point* ofs) {
		try {
			instance->locateROI(*wholeSize, *ofs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// adjustROI(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1622
	Result<cv::Mat*> cv_Mat_adjustROI_int_int_int_int(cv::Mat* instance, int dtop, int dbottom, int dleft, int dright) {
		try {
			cv::Mat ret = instance->adjustROI(dtop, dbottom, dleft, dright);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// isContinuous() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1732
	Result<bool> cv_Mat_isContinuous_const(const cv::Mat* instance) {
		try {
			bool ret = instance->isContinuous();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSubmatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1735
	Result<bool> cv_Mat_isSubmatrix_const(const cv::Mat* instance) {
		try {
			bool ret = instance->isSubmatrix();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1742
	Result<size_t> cv_Mat_elemSize_const(const cv::Mat* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1749
	Result<size_t> cv_Mat_elemSize1_const(const cv::Mat* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1756
	Result<int> cv_Mat_type_const(const cv::Mat* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1771
	Result<int> cv_Mat_depth_const(const cv::Mat* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1777
	Result<int> cv_Mat_channels_const(const cv::Mat* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// step1(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1784
	Result<size_t> cv_Mat_step1_const_int(const cv::Mat* instance, int i) {
		try {
			size_t ret = instance->step1(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1791
	Result<bool> cv_Mat_empty_const(const cv::Mat* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// total() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1798
	Result<size_t> cv_Mat_total_const(const cv::Mat* instance) {
		try {
			size_t ret = instance->total();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// total(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1804
	Result<size_t> cv_Mat_total_const_int_int(const cv::Mat* instance, int startDim, int endDim) {
		try {
			size_t ret = instance->total(startDim, endDim);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// checkVector(int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1827
	Result<int> cv_Mat_checkVector_const_int_int_bool(const cv::Mat* instance, int elemChannels, int depth, bool requireContinuous) {
		try {
			int ret = instance->checkVector(elemChannels, depth, requireContinuous);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// ptr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1835
	Result<unsigned char*> cv_Mat_ptr_int(cv::Mat* instance, int i0) {
		try {
			unsigned char* ret = instance->ptr(i0);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1837
	Result<const unsigned char*> cv_Mat_ptr_const_int(const cv::Mat* instance, int i0) {
		try {
			const unsigned char* ret = instance->ptr(i0);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// ptr(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1843
	Result<unsigned char*> cv_Mat_ptr_int_int(cv::Mat* instance, int row, int col) {
		try {
			unsigned char* ret = instance->ptr(row, col);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1848
	Result<const unsigned char*> cv_Mat_ptr_const_int_int(const cv::Mat* instance, int row, int col) {
		try {
			const unsigned char* ret = instance->ptr(row, col);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// ptr(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1851
	Result<unsigned char*> cv_Mat_ptr_int_int_int(cv::Mat* instance, int i0, int i1, int i2) {
		try {
			unsigned char* ret = instance->ptr(i0, i1, i2);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1853
	Result<const unsigned char*> cv_Mat_ptr_const_int_int_int(const cv::Mat* instance, int i0, int i1, int i2) {
		try {
			const unsigned char* ret = instance->ptr(i0, i1, i2);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// ptr(const int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1856
	Result<unsigned char*> cv_Mat_ptr_const_intX(cv::Mat* instance, const int* idx) {
		try {
			unsigned char* ret = instance->ptr(idx);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(const int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:1858
	Result<const unsigned char*> cv_Mat_ptr_const_const_intX(const cv::Mat* instance, const int* idx) {
		try {
			const unsigned char* ret = instance->ptr(idx);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// Mat(cv::Mat &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2091
	Result<cv::Mat*> cv_Mat_Mat_MatR(cv::Mat* m) {
		try {
			cv::Mat* ret = new cv::Mat(*m);
			return Ok<cv::Mat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// updateContinuityFlag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2124
	Result_void cv_Mat_updateContinuityFlag(cv::Mat* instance) {
		try {
			instance->updateContinuityFlag();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3103
	const cv::Mat** cv_MatConstIterator_getPropM_const(const cv::MatConstIterator* instance) {
		const cv::Mat* ret = instance->m;
		return new const cv::Mat*(ret);
	}
	
	// elemSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3104
	size_t cv_MatConstIterator_getPropElemSize_const(const cv::MatConstIterator* instance) {
		size_t ret = instance->elemSize;
		return (size_t)ret;
	}
	
	// elemSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3104
	void cv_MatConstIterator_setPropElemSize_size_t(cv::MatConstIterator* instance, size_t val) {
		instance->elemSize = val;
	}
	
	// ptr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3105
	const unsigned char* cv_MatConstIterator_getPropPtr_const(const cv::MatConstIterator* instance) {
		const unsigned char* ret = instance->ptr;
		return (const unsigned char*)ret;
	}
	
	// sliceStart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3106
	const unsigned char* cv_MatConstIterator_getPropSliceStart_const(const cv::MatConstIterator* instance) {
		const unsigned char* ret = instance->sliceStart;
		return (const unsigned char*)ret;
	}
	
	// sliceEnd /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3107
	const unsigned char* cv_MatConstIterator_getPropSliceEnd_const(const cv::MatConstIterator* instance) {
		const unsigned char* ret = instance->sliceEnd;
		return (const unsigned char*)ret;
	}
	
	void cv_MatConstIterator_delete(cv::MatConstIterator* instance) {
		delete instance;
	}
	// MatConstIterator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3063
	Result<cv::MatConstIterator*> cv_MatConstIterator_MatConstIterator() {
		try {
			cv::MatConstIterator* ret = new cv::MatConstIterator();
			return Ok<cv::MatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatConstIterator*>))
	}
	
	// MatConstIterator(const cv::Mat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3065
	Result<cv::MatConstIterator*> cv_MatConstIterator_MatConstIterator_const_MatX(const cv::Mat* _m) {
		try {
			cv::MatConstIterator* ret = new cv::MatConstIterator(_m);
			return Ok<cv::MatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatConstIterator*>))
	}
	
	// MatConstIterator(const cv::Mat *, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3067
	Result<cv::MatConstIterator*> cv_MatConstIterator_MatConstIterator_const_MatX_int_int(const cv::Mat* _m, int _row, int _col) {
		try {
			cv::MatConstIterator* ret = new cv::MatConstIterator(_m, _row, _col);
			return Ok<cv::MatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatConstIterator*>))
	}
	
	// MatConstIterator(const cv::Mat *, cv::Point) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3069
	Result<cv::MatConstIterator*> cv_MatConstIterator_MatConstIterator_const_MatX_Point(const cv::Mat* _m, cv::Point* _pt) {
		try {
			cv::MatConstIterator* ret = new cv::MatConstIterator(_m, *_pt);
			return Ok<cv::MatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatConstIterator*>))
	}
	
	// MatConstIterator(const cv::MatConstIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3073
	Result<cv::MatConstIterator*> cv_MatConstIterator_MatConstIterator_const_MatConstIteratorR(const cv::MatConstIterator* it) {
		try {
			cv::MatConstIterator* ret = new cv::MatConstIterator(*it);
			return Ok<cv::MatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatConstIterator*>))
	}
	
	// operator*() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3078
	Result<const unsigned char*> cv_MatConstIterator_operatorX_const(const cv::MatConstIterator* instance) {
		try {
			const unsigned char* ret = instance->operator*();
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// operator[](ptrdiff_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3080
	Result<const unsigned char*> cv_MatConstIterator_operator___const_ptrdiff_t(const cv::MatConstIterator* instance, ptrdiff_t i) {
		try {
			const unsigned char* ret = instance->operator[](i);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// pos() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3095
	Result<cv::Point> cv_MatConstIterator_pos_const(const cv::MatConstIterator* instance) {
		try {
			cv::Point ret = instance->pos();
			return Ok<cv::Point>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Point>))
	}
	
	// pos(int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3097
	Result_void cv_MatConstIterator_pos_const_intX(const cv::MatConstIterator* instance, int* _idx) {
		try {
			instance->pos(_idx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// lpos() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3099
	Result<ptrdiff_t> cv_MatConstIterator_lpos_const(const cv::MatConstIterator* instance) {
		try {
			ptrdiff_t ret = instance->lpos();
			return Ok<ptrdiff_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<ptrdiff_t>))
	}
	
	// seek(ptrdiff_t, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3100
	Result_void cv_MatConstIterator_seek_ptrdiff_t_bool(cv::MatConstIterator* instance, ptrdiff_t ofs, bool relative) {
		try {
			instance->seek(ofs, relative);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// seek(const int *, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3101
	Result_void cv_MatConstIterator_seek_const_intX_bool(cv::MatConstIterator* instance, const int* _idx, bool relative) {
		try {
			instance->seek(_idx, relative);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3586
	int cv_MatExpr_getPropFlags_const(const cv::MatExpr* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3586
	void cv_MatExpr_setPropFlags_int(cv::MatExpr* instance, int val) {
		instance->flags = val;
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	cv::Mat* cv_MatExpr_getPropA_const(const cv::MatExpr* instance) {
		cv::Mat ret = instance->a;
		return new cv::Mat(ret);
	}
	
	// a /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	void cv_MatExpr_setPropA_Mat(cv::MatExpr* instance, cv::Mat* val) {
		instance->a = *val;
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	cv::Mat* cv_MatExpr_getPropB_const(const cv::MatExpr* instance) {
		cv::Mat ret = instance->b;
		return new cv::Mat(ret);
	}
	
	// b /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	void cv_MatExpr_setPropB_Mat(cv::MatExpr* instance, cv::Mat* val) {
		instance->b = *val;
	}
	
	// c /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	cv::Mat* cv_MatExpr_getPropC_const(const cv::MatExpr* instance) {
		cv::Mat ret = instance->c;
		return new cv::Mat(ret);
	}
	
	// c /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3588
	void cv_MatExpr_setPropC_Mat(cv::MatExpr* instance, cv::Mat* val) {
		instance->c = *val;
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3589
	double cv_MatExpr_getPropAlpha_const(const cv::MatExpr* instance) {
		double ret = instance->alpha;
		return (double)ret;
	}
	
	// alpha /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3589
	void cv_MatExpr_setPropAlpha_double(cv::MatExpr* instance, double val) {
		instance->alpha = val;
	}
	
	// beta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3589
	double cv_MatExpr_getPropBeta_const(const cv::MatExpr* instance) {
		double ret = instance->beta;
		return (double)ret;
	}
	
	// beta /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3589
	void cv_MatExpr_setPropBeta_double(cv::MatExpr* instance, double val) {
		instance->beta = val;
	}
	
	// s /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3590
	cv::Scalar cv_MatExpr_getPropS_const(const cv::MatExpr* instance) {
		cv::Scalar ret = instance->s;
		return (cv::Scalar)ret;
	}
	
	// s /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3590
	void cv_MatExpr_setPropS_Scalar(cv::MatExpr* instance, cv::Scalar* val) {
		instance->s = *val;
	}
	
	void cv_MatExpr_delete(cv::MatExpr* instance) {
		delete instance;
	}
	// MatExpr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3557
	Result<cv::MatExpr*> cv_MatExpr_MatExpr() {
		try {
			cv::MatExpr* ret = new cv::MatExpr();
			return Ok<cv::MatExpr*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// MatExpr(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3558
	Result<cv::MatExpr*> cv_MatExpr_MatExpr_const_MatR(const cv::Mat* m) {
		try {
			cv::MatExpr* ret = new cv::MatExpr(*m);
			return Ok<cv::MatExpr*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// MatExpr(const cv::MatOp *, int, const cv::Mat &, const cv::Mat &, const cv::Mat &, double, double, const cv::Scalar &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3560
	Result<cv::MatExpr*> cv_MatExpr_MatExpr_const_MatOpX_int_const_MatR_const_MatR_const_MatR_double_double_const_ScalarR(const cv::MatOp* _op, int _flags, const cv::Mat* _a, const cv::Mat* _b, const cv::Mat* _c, double _alpha, double _beta, const cv::Scalar* _s) {
		try {
			cv::MatExpr* ret = new cv::MatExpr(_op, _flags, *_a, *_b, *_c, _alpha, _beta, *_s);
			return Ok<cv::MatExpr*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// operator Mat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3563
	Result<cv::Mat*> cv_MatExpr_operator_cv_Mat_const(const cv::MatExpr* instance) {
		try {
			cv::Mat ret = instance->operator cv::Mat();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3566
	Result<cv::Size> cv_MatExpr_size_const(const cv::MatExpr* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3567
	Result<int> cv_MatExpr_type_const(const cv::MatExpr* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// row(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3569
	Result<cv::MatExpr*> cv_MatExpr_row_const_int(const cv::MatExpr* instance, int y) {
		try {
			cv::MatExpr ret = instance->row(y);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// col(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3570
	Result<cv::MatExpr*> cv_MatExpr_col_const_int(const cv::MatExpr* instance, int x) {
		try {
			cv::MatExpr ret = instance->col(x);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// diag(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3571
	Result<cv::MatExpr*> cv_MatExpr_diag_const_int(const cv::MatExpr* instance, int d) {
		try {
			cv::MatExpr ret = instance->diag(d);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// t() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3575
	Result<cv::MatExpr*> cv_MatExpr_t_const(const cv::MatExpr* instance) {
		try {
			cv::MatExpr ret = instance->t();
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// inv(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3576
	Result<cv::MatExpr*> cv_MatExpr_inv_const_int(const cv::MatExpr* instance, int method) {
		try {
			cv::MatExpr ret = instance->inv(method);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// mul(const cv::MatExpr &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3577
	Result<cv::MatExpr*> cv_MatExpr_mul_const_const_MatExprR_double(const cv::MatExpr* instance, const cv::MatExpr* e, double scale) {
		try {
			cv::MatExpr ret = instance->mul(*e, scale);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// mul(const cv::Mat &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3578
	Result<cv::MatExpr*> cv_MatExpr_mul_const_const_MatR_double(const cv::MatExpr* instance, const cv::Mat* m, double scale) {
		try {
			cv::MatExpr ret = instance->mul(*m, scale);
			return Ok(new cv::MatExpr(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::MatExpr*>))
	}
	
	// cross(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3580
	Result<cv::Mat*> cv_MatExpr_cross_const_const_MatR(const cv::MatExpr* instance, const cv::Mat* m) {
		try {
			cv::Mat ret = instance->cross(*m);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// dot(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3581
	Result<double> cv_MatExpr_dot_const_const_MatR(const cv::MatExpr* instance, const cv::Mat* m) {
		try {
			double ret = instance->dot(*m);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// swap(cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3583
	Result_void cv_MatExpr_swap_MatExprR(cv::MatExpr* instance, cv::MatExpr* b) {
		try {
			instance->swap(*b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// elementWise(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3473
	Result<bool> cv_MatOp_elementWise_const_const_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr) {
		try {
			bool ret = instance->elementWise(*expr);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// assign(const cv::MatExpr &, cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3474
	Result_void cv_MatOp_assign_const_const_MatExprR_MatR_int(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m, int type) {
		try {
			instance->assign(*expr, *m, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// roi(const cv::MatExpr &, const cv::Range &, const cv::Range &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3475
	Result_void cv_MatOp_roi_const_const_MatExprR_const_RangeR_const_RangeR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr, const cv::Range* rowRange, const cv::Range* colRange, cv::MatExpr* res) {
		try {
			instance->roi(*expr, *rowRange, *colRange, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// diag(const cv::MatExpr &, int, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3477
	Result_void cv_MatOp_diag_const_const_MatExprR_int_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr, int d, cv::MatExpr* res) {
		try {
			instance->diag(*expr, d, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignAdd(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3478
	Result_void cv_MatOp_augAssignAdd_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignAdd(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignSubtract(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3479
	Result_void cv_MatOp_augAssignSubtract_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignSubtract(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignMultiply(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3480
	Result_void cv_MatOp_augAssignMultiply_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignMultiply(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignDivide(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3481
	Result_void cv_MatOp_augAssignDivide_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignDivide(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignAnd(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3482
	Result_void cv_MatOp_augAssignAnd_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignAnd(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignOr(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3483
	Result_void cv_MatOp_augAssignOr_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignOr(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// augAssignXor(const cv::MatExpr &, cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3484
	Result_void cv_MatOp_augAssignXor_const_const_MatExprR_MatR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::Mat* m) {
		try {
			instance->augAssignXor(*expr, *m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// add(const cv::MatExpr &, const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3486
	Result_void cv_MatOp_add_const_const_MatExprR_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::MatExpr* expr2, cv::MatExpr* res) {
		try {
			instance->add(*expr1, *expr2, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// add(const cv::MatExpr &, const cv::Scalar &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3487
	Result_void cv_MatOp_add_const_const_MatExprR_const_ScalarR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::Scalar* s, cv::MatExpr* res) {
		try {
			instance->add(*expr1, *s, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// subtract(const cv::MatExpr &, const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3489
	Result_void cv_MatOp_subtract_const_const_MatExprR_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::MatExpr* expr2, cv::MatExpr* res) {
		try {
			instance->subtract(*expr1, *expr2, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// subtract(const cv::Scalar &, const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3490
	Result_void cv_MatOp_subtract_const_const_ScalarR_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::Scalar* s, const cv::MatExpr* expr, cv::MatExpr* res) {
		try {
			instance->subtract(*s, *expr, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// multiply(const cv::MatExpr &, const cv::MatExpr &, cv::MatExpr &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3492
	Result_void cv_MatOp_multiply_const_const_MatExprR_const_MatExprR_MatExprR_double(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::MatExpr* expr2, cv::MatExpr* res, double scale) {
		try {
			instance->multiply(*expr1, *expr2, *res, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// multiply(const cv::MatExpr &, double, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3493
	Result_void cv_MatOp_multiply_const_const_MatExprR_double_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr1, double s, cv::MatExpr* res) {
		try {
			instance->multiply(*expr1, s, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// divide(const cv::MatExpr &, const cv::MatExpr &, cv::MatExpr &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3495
	Result_void cv_MatOp_divide_const_const_MatExprR_const_MatExprR_MatExprR_double(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::MatExpr* expr2, cv::MatExpr* res, double scale) {
		try {
			instance->divide(*expr1, *expr2, *res, scale);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// divide(double, const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3496
	Result_void cv_MatOp_divide_const_double_const_MatExprR_MatExprR(const cv::MatOp* instance, double s, const cv::MatExpr* expr, cv::MatExpr* res) {
		try {
			instance->divide(s, *expr, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// abs(const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3498
	Result_void cv_MatOp_abs_const_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::MatExpr* res) {
		try {
			instance->abs(*expr, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// transpose(const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3500
	Result_void cv_MatOp_transpose_const_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr, cv::MatExpr* res) {
		try {
			instance->transpose(*expr, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// matmul(const cv::MatExpr &, const cv::MatExpr &, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3501
	Result_void cv_MatOp_matmul_const_const_MatExprR_const_MatExprR_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr1, const cv::MatExpr* expr2, cv::MatExpr* res) {
		try {
			instance->matmul(*expr1, *expr2, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// invert(const cv::MatExpr &, int, cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3502
	Result_void cv_MatOp_invert_const_const_MatExprR_int_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr, int method, cv::MatExpr* res) {
		try {
			instance->invert(*expr, method, *res);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// size(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3504
	Result<cv::Size> cv_MatOp_size_const_const_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr) {
		try {
			cv::Size ret = instance->size(*expr);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// type(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3505
	Result<int> cv_MatOp_type_const_const_MatExprR(const cv::MatOp* instance, const cv::MatExpr* expr) {
		try {
			int ret = instance->type(*expr);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:588
	int* cv_MatSize_getPropP(cv::MatSize* instance) {
		int* ret = instance->p;
		return (int*)ret;
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:588
	void cv_MatSize_setPropP_intX(cv::MatSize* instance, int* val) {
		instance->p = val;
	}
	
	void cv_MatSize_delete(cv::MatSize* instance) {
		delete instance;
	}
	// MatSize(int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:579
	cv::MatSize* cv_MatSize_MatSize_intX(int* _p) {
		cv::MatSize* ret = new cv::MatSize(_p);
		return (cv::MatSize*)ret;
	}
	
	// dims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:580
	int cv_MatSize_dims_const(const cv::MatSize* instance) {
		int ret = instance->dims();
		return (int)ret;
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:582
	Result<const int> cv_MatSize_operator___const_int(const cv::MatSize* instance, int i) {
		try {
			const int ret = instance->operator[](i);
			return Ok<const int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const int>))
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:583
	Result<int> cv_MatSize_operator___int(cv::MatSize* instance, int i) {
		try {
			int ret = instance->operator[](i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// operator const int *() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:584
	const int* cv_MatSize_operator_const_intX_const(const cv::MatSize* instance) {
		const int* ret = instance->operator const int*();
		return (const int*)ret;
	}
	
	// operator==(const cv::MatSize &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:585
	bool cv_MatSize_operatorEQ_const_const_MatSizeR(const cv::MatSize* instance, const cv::MatSize* sz) {
		bool ret = instance->operator==(*sz);
		return (bool)ret;
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:600
	size_t* cv_MatStep_getPropP(cv::MatStep* instance) {
		size_t* ret = instance->p;
		return (size_t*)ret;
	}
	
	// p /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:600
	void cv_MatStep_setPropP_size_tX(cv::MatStep* instance, size_t* val) {
		instance->p = val;
	}
	
	// buf /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:601
	size_t** cv_MatStep_getPropBuf(cv::MatStep* instance) {
		size_t(*ret)[2] = &instance->buf;
		return (size_t**)ret;
	}
	
	void cv_MatStep_delete(cv::MatStep* instance) {
		delete instance;
	}
	// MatStep() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:593
	cv::MatStep* cv_MatStep_MatStep() {
		cv::MatStep* ret = new cv::MatStep();
		return (cv::MatStep*)ret;
	}
	
	// MatStep(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:594
	cv::MatStep* cv_MatStep_MatStep_size_t(size_t s) {
		cv::MatStep* ret = new cv::MatStep(s);
		return (cv::MatStep*)ret;
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:595
	const size_t cv_MatStep_operator___const_int(const cv::MatStep* instance, int i) {
		const size_t ret = instance->operator[](i);
		return (const size_t)ret;
	}
	
	// operator[](int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:596
	size_t cv_MatStep_operator___int(cv::MatStep* instance, int i) {
		size_t ret = instance->operator[](i);
		return (size_t)ret;
	}
	
	// operator unsigned long() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:597
	Result<size_t> cv_MatStep_operator_size_t_const(const cv::MatStep* instance) {
		try {
			size_t ret = instance->operator size_t();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	void cv_Matx_AddOp_delete(cv::Matx_AddOp* instance) {
		delete instance;
	}
	// Matx_AddOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:68
	Result<cv::Matx_AddOp*> cv_Matx_AddOp_Matx_AddOp() {
		try {
			cv::Matx_AddOp* ret = new cv::Matx_AddOp();
			return Ok<cv::Matx_AddOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_AddOp*>))
	}
	
	// Matx_AddOp(const cv::Matx_AddOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:68
	Result<cv::Matx_AddOp*> cv_Matx_AddOp_Matx_AddOp_const_Matx_AddOpR(const cv::Matx_AddOp* unnamed) {
		try {
			cv::Matx_AddOp* ret = new cv::Matx_AddOp(*unnamed);
			return Ok<cv::Matx_AddOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_AddOp*>))
	}
	
	void cv_Matx_DivOp_delete(cv::Matx_DivOp* instance) {
		delete instance;
	}
	// Matx_DivOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:72
	Result<cv::Matx_DivOp*> cv_Matx_DivOp_Matx_DivOp() {
		try {
			cv::Matx_DivOp* ret = new cv::Matx_DivOp();
			return Ok<cv::Matx_DivOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_DivOp*>))
	}
	
	// Matx_DivOp(const cv::Matx_DivOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:72
	Result<cv::Matx_DivOp*> cv_Matx_DivOp_Matx_DivOp_const_Matx_DivOpR(const cv::Matx_DivOp* unnamed) {
		try {
			cv::Matx_DivOp* ret = new cv::Matx_DivOp(*unnamed);
			return Ok<cv::Matx_DivOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_DivOp*>))
	}
	
	void cv_Matx_MatMulOp_delete(cv::Matx_MatMulOp* instance) {
		delete instance;
	}
	// Matx_MatMulOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:73
	Result<cv::Matx_MatMulOp*> cv_Matx_MatMulOp_Matx_MatMulOp() {
		try {
			cv::Matx_MatMulOp* ret = new cv::Matx_MatMulOp();
			return Ok<cv::Matx_MatMulOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_MatMulOp*>))
	}
	
	// Matx_MatMulOp(const cv::Matx_MatMulOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:73
	Result<cv::Matx_MatMulOp*> cv_Matx_MatMulOp_Matx_MatMulOp_const_Matx_MatMulOpR(const cv::Matx_MatMulOp* unnamed) {
		try {
			cv::Matx_MatMulOp* ret = new cv::Matx_MatMulOp(*unnamed);
			return Ok<cv::Matx_MatMulOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_MatMulOp*>))
	}
	
	void cv_Matx_MulOp_delete(cv::Matx_MulOp* instance) {
		delete instance;
	}
	// Matx_MulOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:71
	Result<cv::Matx_MulOp*> cv_Matx_MulOp_Matx_MulOp() {
		try {
			cv::Matx_MulOp* ret = new cv::Matx_MulOp();
			return Ok<cv::Matx_MulOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_MulOp*>))
	}
	
	// Matx_MulOp(const cv::Matx_MulOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:71
	Result<cv::Matx_MulOp*> cv_Matx_MulOp_Matx_MulOp_const_Matx_MulOpR(const cv::Matx_MulOp* unnamed) {
		try {
			cv::Matx_MulOp* ret = new cv::Matx_MulOp(*unnamed);
			return Ok<cv::Matx_MulOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_MulOp*>))
	}
	
	void cv_Matx_ScaleOp_delete(cv::Matx_ScaleOp* instance) {
		delete instance;
	}
	// Matx_ScaleOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:70
	Result<cv::Matx_ScaleOp*> cv_Matx_ScaleOp_Matx_ScaleOp() {
		try {
			cv::Matx_ScaleOp* ret = new cv::Matx_ScaleOp();
			return Ok<cv::Matx_ScaleOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_ScaleOp*>))
	}
	
	// Matx_ScaleOp(const cv::Matx_ScaleOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:70
	Result<cv::Matx_ScaleOp*> cv_Matx_ScaleOp_Matx_ScaleOp_const_Matx_ScaleOpR(const cv::Matx_ScaleOp* unnamed) {
		try {
			cv::Matx_ScaleOp* ret = new cv::Matx_ScaleOp(*unnamed);
			return Ok<cv::Matx_ScaleOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_ScaleOp*>))
	}
	
	void cv_Matx_SubOp_delete(cv::Matx_SubOp* instance) {
		delete instance;
	}
	// Matx_SubOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:69
	Result<cv::Matx_SubOp*> cv_Matx_SubOp_Matx_SubOp() {
		try {
			cv::Matx_SubOp* ret = new cv::Matx_SubOp();
			return Ok<cv::Matx_SubOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_SubOp*>))
	}
	
	// Matx_SubOp(const cv::Matx_SubOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:69
	Result<cv::Matx_SubOp*> cv_Matx_SubOp_Matx_SubOp_const_Matx_SubOpR(const cv::Matx_SubOp* unnamed) {
		try {
			cv::Matx_SubOp* ret = new cv::Matx_SubOp(*unnamed);
			return Ok<cv::Matx_SubOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_SubOp*>))
	}
	
	void cv_Matx_TOp_delete(cv::Matx_TOp* instance) {
		delete instance;
	}
	// Matx_TOp() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:74
	Result<cv::Matx_TOp*> cv_Matx_TOp_Matx_TOp() {
		try {
			cv::Matx_TOp* ret = new cv::Matx_TOp();
			return Ok<cv::Matx_TOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_TOp*>))
	}
	
	// Matx_TOp(const cv::Matx_TOp &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/matx.hpp:74
	Result<cv::Matx_TOp*> cv_Matx_TOp_Matx_TOp_const_Matx_TOpR(const cv::Matx_TOp* unnamed) {
		try {
			cv::Matx_TOp* ret = new cv::Matx_TOp(*unnamed);
			return Ok<cv::Matx_TOp*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Matx_TOp*>))
	}
	
	// getFunction() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:81
	Result<cv::Ptr<cv::MinProblemSolver::Function>*> cv_MinProblemSolver_getFunction_const(const cv::MinProblemSolver* instance) {
		try {
			cv::Ptr<cv::MinProblemSolver::Function> ret = instance->getFunction();
			return Ok(new cv::Ptr<cv::MinProblemSolver::Function>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::MinProblemSolver::Function>*>))
	}
	
	// setFunction(const Ptr<cv::MinProblemSolver::Function> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:89
	Result_void cv_MinProblemSolver_setFunction_const_Ptr_Function_R(cv::MinProblemSolver* instance, const cv::Ptr<cv::MinProblemSolver::Function>* f) {
		try {
			instance->setFunction(*f);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:95
	Result<cv::TermCriteria> cv_MinProblemSolver_getTermCriteria_const(const cv::MinProblemSolver* instance) {
		try {
			cv::TermCriteria ret = instance->getTermCriteria();
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// setTermCriteria(const cv::TermCriteria &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:108
	Result_void cv_MinProblemSolver_setTermCriteria_const_TermCriteriaR(cv::MinProblemSolver* instance, const cv::TermCriteria* termcrit) {
		try {
			instance->setTermCriteria(*termcrit);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// minimize(cv::InputOutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:122
	Result<double> cv_MinProblemSolver_minimize_const__InputOutputArrayR(cv::MinProblemSolver* instance, const cv::_InputOutputArray* x) {
		try {
			double ret = instance->minimize(*x);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getDims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:67
	Result<int> cv_MinProblemSolver_Function_getDims_const(const cv::MinProblemSolver::Function* instance) {
		try {
			int ret = instance->getDims();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getGradientEps() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:68
	Result<double> cv_MinProblemSolver_Function_getGradientEps_const(const cv::MinProblemSolver::Function* instance) {
		try {
			double ret = instance->getGradientEps();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// calc(const double *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:69
	Result<double> cv_MinProblemSolver_Function_calc_const_const_doubleX(const cv::MinProblemSolver::Function* instance, const double* x) {
		try {
			double ret = instance->calc(x);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getGradient(const double *, double *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/optim.hpp:70
	Result_void cv_MinProblemSolver_Function_getGradient_const_doubleX_doubleX(cv::MinProblemSolver::Function* instance, const double* x, double* grad) {
		try {
			instance->getGradient(x, grad);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Moments() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:952
	Result<cv::Moments> cv_Moments_Moments() {
		try {
			cv::Moments ret;
			return Ok<cv::Moments>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Moments>))
	}
	
	// Moments(double, double, double, double, double, double, double, double, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:954
	Result<cv::Moments> cv_Moments_Moments_double_double_double_double_double_double_double_double_double_double(double m00, double m10, double m01, double m20, double m11, double m02, double m30, double m21, double m12, double m03) {
		try {
			cv::Moments ret(m00, m10, m01, m20, m11, m02, m30, m21, m12, m03);
			return Ok<cv::Moments>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Moments>))
	}
	
	// eigenvectors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2545
	cv::Mat* cv_PCA_getPropEigenvectors_const(const cv::PCA* instance) {
		cv::Mat ret = instance->eigenvectors;
		return new cv::Mat(ret);
	}
	
	// eigenvectors /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2545
	void cv_PCA_setPropEigenvectors_Mat(cv::PCA* instance, cv::Mat* val) {
		instance->eigenvectors = *val;
	}
	
	// eigenvalues /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2546
	cv::Mat* cv_PCA_getPropEigenvalues_const(const cv::PCA* instance) {
		cv::Mat ret = instance->eigenvalues;
		return new cv::Mat(ret);
	}
	
	// eigenvalues /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2546
	void cv_PCA_setPropEigenvalues_Mat(cv::PCA* instance, cv::Mat* val) {
		instance->eigenvalues = *val;
	}
	
	// mean /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2547
	cv::Mat* cv_PCA_getPropMean_const(const cv::PCA* instance) {
		cv::Mat ret = instance->mean;
		return new cv::Mat(ret);
	}
	
	// mean /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2547
	void cv_PCA_setPropMean_Mat(cv::PCA* instance, cv::Mat* val) {
		instance->mean = *val;
	}
	
	void cv_PCA_delete(cv::PCA* instance) {
		delete instance;
	}
	// PCA() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2419
	Result<cv::PCA*> cv_PCA_PCA() {
		try {
			cv::PCA* ret = new cv::PCA();
			return Ok<cv::PCA*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PCA*>))
	}
	
	// PCA(cv::InputArray, cv::InputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2430
	Result<cv::PCA*> cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_int(const cv::_InputArray* data, const cv::_InputArray* mean, int flags, int maxComponents) {
		try {
			cv::PCA* ret = new cv::PCA(*data, *mean, flags, maxComponents);
			return Ok<cv::PCA*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PCA*>))
	}
	
	// PCA(cv::InputArray, cv::InputArray, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2442
	Result<cv::PCA*> cv_PCA_PCA_const__InputArrayR_const__InputArrayR_int_double(const cv::_InputArray* data, const cv::_InputArray* mean, int flags, double retainedVariance) {
		try {
			cv::PCA* ret = new cv::PCA(*data, *mean, flags, retainedVariance);
			return Ok<cv::PCA*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::PCA*>))
	}
	
	// project(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2493
	Result<cv::Mat*> cv_PCA_project_const_const__InputArrayR(const cv::PCA* instance, const cv::_InputArray* vec) {
		try {
			cv::Mat ret = instance->project(*vec);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// project(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2507
	Result_void cv_PCA_project_const_const__InputArrayR_const__OutputArrayR(const cv::PCA* instance, const cv::_InputArray* vec, const cv::_OutputArray* result) {
		try {
			instance->project(*vec, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// backProject(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2522
	Result<cv::Mat*> cv_PCA_backProject_const_const__InputArrayR(const cv::PCA* instance, const cv::_InputArray* vec) {
		try {
			cv::Mat ret = instance->backProject(*vec);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// backProject(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2531
	Result_void cv_PCA_backProject_const_const__InputArrayR_const__OutputArrayR(const cv::PCA* instance, const cv::_InputArray* vec, const cv::_OutputArray* result) {
		try {
			instance->backProject(*vec, *result);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2537
	Result_void cv_PCA_write_const_FileStorageR(const cv::PCA* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// read(const cv::FileNode &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2543
	Result_void cv_PCA_read_const_FileNodeR(cv::PCA* instance, const cv::FileNode* fn) {
		try {
			instance->read(*fn);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// state /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2929
	uint64_t cv_RNG_getPropState_const(const cv::RNG* instance) {
		uint64_t ret = instance->state;
		return (uint64_t)ret;
	}
	
	// state /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2929
	void cv_RNG_setPropState_uint64_t(cv::RNG* instance, uint64_t val) {
		instance->state = val;
	}
	
	void cv_RNG_delete(cv::RNG* instance) {
		delete instance;
	}
	// RNG() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2797
	Result<cv::RNG*> cv_RNG_RNG() {
		try {
			cv::RNG* ret = new cv::RNG();
			return Ok<cv::RNG*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RNG*>))
	}
	
	// RNG(uint64) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2801
	Result<cv::RNG*> cv_RNG_RNG_uint64_t(uint64_t state) {
		try {
			cv::RNG* ret = new cv::RNG(state);
			return Ok<cv::RNG*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RNG*>))
	}
	
	// next() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2804
	Result<unsigned int> cv_RNG_next(cv::RNG* instance) {
		try {
			unsigned int ret = instance->next();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// operator unsigned char() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2812
	Result<unsigned char> cv_RNG_operator_unsigned_char(cv::RNG* instance) {
		try {
			unsigned char ret = instance->operator unsigned char();
			return Ok<unsigned char>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char>))
	}
	
	// operator signed char() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2814
	Result<signed char> cv_RNG_operator_signed_char(cv::RNG* instance) {
		try {
			signed char ret = instance->operator signed char();
			return Ok<signed char>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<signed char>))
	}
	
	// operator unsigned short() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2816
	Result<unsigned short> cv_RNG_operator_unsigned_short(cv::RNG* instance) {
		try {
			unsigned short ret = instance->operator unsigned short();
			return Ok<unsigned short>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned short>))
	}
	
	// operator short() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2818
	Result<short> cv_RNG_operator_short(cv::RNG* instance) {
		try {
			short ret = instance->operator short();
			return Ok<short>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<short>))
	}
	
	// operator unsigned int() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2820
	Result<unsigned int> cv_RNG_operator_unsigned_int(cv::RNG* instance) {
		try {
			unsigned int ret = instance->operator unsigned int();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// operator int() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2822
	Result<int> cv_RNG_operator_int(cv::RNG* instance) {
		try {
			int ret = instance->operator int();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// operator float() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2824
	Result<float> cv_RNG_operator_float(cv::RNG* instance) {
		try {
			float ret = instance->operator float();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// operator double() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2826
	Result<double> cv_RNG_operator_double(cv::RNG* instance) {
		try {
			double ret = instance->operator double();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// uniform(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2877
	Result<int> cv_RNG_uniform_int_int(cv::RNG* instance, int a, int b) {
		try {
			int ret = instance->uniform(a, b);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// uniform(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2879
	Result<float> cv_RNG_uniform_float_float(cv::RNG* instance, float a, float b) {
		try {
			float ret = instance->uniform(a, b);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// uniform(double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2881
	Result<double> cv_RNG_uniform_double_double(cv::RNG* instance, double a, double b) {
		try {
			double ret = instance->uniform(a, b);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// fill(cv::InputOutputArray, int, cv::InputArray, cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2917
	Result_void cv_RNG_fill_const__InputOutputArrayR_int_const__InputArrayR_const__InputArrayR_bool(cv::RNG* instance, const cv::_InputOutputArray* mat, int distType, const cv::_InputArray* a, const cv::_InputArray* b, bool saturateRange) {
		try {
			instance->fill(*mat, distType, *a, *b, saturateRange);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// gaussian(double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2927
	Result<double> cv_RNG_gaussian_double(cv::RNG* instance, double sigma) {
		try {
			double ret = instance->gaussian(sigma);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// operator==(const cv::RNG &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2931
	Result<bool> cv_RNG_operatorEQ_const_const_RNGR(const cv::RNG* instance, const cv::RNG* other) {
		try {
			bool ret = instance->operator==(*other);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_RNG_MT19937_delete(cv::RNG_MT19937* instance) {
		delete instance;
	}
	// RNG_MT19937() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2942
	Result<cv::RNG_MT19937*> cv_RNG_MT19937_RNG_MT19937() {
		try {
			cv::RNG_MT19937* ret = new cv::RNG_MT19937();
			return Ok<cv::RNG_MT19937*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RNG_MT19937*>))
	}
	
	// RNG_MT19937(unsigned int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2943
	Result<cv::RNG_MT19937*> cv_RNG_MT19937_RNG_MT19937_unsigned_int(unsigned int s) {
		try {
			cv::RNG_MT19937* ret = new cv::RNG_MT19937(s);
			return Ok<cv::RNG_MT19937*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RNG_MT19937*>))
	}
	
	// seed(unsigned int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2944
	Result_void cv_RNG_MT19937_seed_unsigned_int(cv::RNG_MT19937* instance, unsigned int s) {
		try {
			instance->seed(s);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// next() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2946
	Result<unsigned int> cv_RNG_MT19937_next(cv::RNG_MT19937* instance) {
		try {
			unsigned int ret = instance->next();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// operator int() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2948
	Result<int> cv_RNG_MT19937_operator_int(cv::RNG_MT19937* instance) {
		try {
			int ret = instance->operator int();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// operator unsigned int() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2949
	Result<unsigned int> cv_RNG_MT19937_operator_unsigned_int(cv::RNG_MT19937* instance) {
		try {
			unsigned int ret = instance->operator unsigned int();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// operator float() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2950
	Result<float> cv_RNG_MT19937_operator_float(cv::RNG_MT19937* instance) {
		try {
			float ret = instance->operator float();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// operator double() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2951
	Result<double> cv_RNG_MT19937_operator_double(cv::RNG_MT19937* instance) {
		try {
			double ret = instance->operator double();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// uniform(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2957
	Result<int> cv_RNG_MT19937_uniform_int_int(cv::RNG_MT19937* instance, int a, int b) {
		try {
			int ret = instance->uniform(a, b);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// uniform(float, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2959
	Result<float> cv_RNG_MT19937_uniform_float_float(cv::RNG_MT19937* instance, float a, float b) {
		try {
			float ret = instance->uniform(a, b);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// uniform(double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2961
	Result<double> cv_RNG_MT19937_uniform_double_double(cv::RNG_MT19937* instance, double a, double b) {
		try {
			double ret = instance->uniform(a, b);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// start /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:620
	int cv_Range_getPropStart_const(const cv::Range* instance) {
		int ret = instance->start;
		return (int)ret;
	}
	
	// start /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:620
	void cv_Range_setPropStart_int(cv::Range* instance, int val) {
		instance->start = val;
	}
	
	// end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:620
	int cv_Range_getPropEnd_const(const cv::Range* instance) {
		int ret = instance->end;
		return (int)ret;
	}
	
	// end /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:620
	void cv_Range_setPropEnd_int(cv::Range* instance, int val) {
		instance->end = val;
	}
	
	void cv_Range_delete(cv::Range* instance) {
		delete instance;
	}
	// Range() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:614
	Result<cv::Range*> cv_Range_Range() {
		try {
			cv::Range* ret = new cv::Range();
			return Ok<cv::Range*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Range*>))
	}
	
	// Range(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:615
	Result<cv::Range*> cv_Range_Range_int_int(int _start, int _end) {
		try {
			cv::Range* ret = new cv::Range(_start, _end);
			return Ok<cv::Range*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Range*>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:616
	Result<int> cv_Range_size_const(const cv::Range* instance) {
		try {
			int ret = instance->size();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:617
	Result<bool> cv_Range_empty_const(const cv::Range* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// all() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:618
	Result<cv::Range*> cv_Range_all() {
		try {
			cv::Range ret = cv::Range::all();
			return Ok(new cv::Range(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Range*>))
	}
	
	// center /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:552
	cv::Point2f cv_RotatedRect_getPropCenter_const(const cv::RotatedRect* instance) {
		cv::Point2f ret = instance->center;
		return (cv::Point2f)ret;
	}
	
	// center /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:552
	void cv_RotatedRect_setPropCenter_Point2f(cv::RotatedRect* instance, cv::Point2f* val) {
		instance->center = *val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:554
	cv::Size2f cv_RotatedRect_getPropSize_const(const cv::RotatedRect* instance) {
		cv::Size2f ret = instance->size;
		return (cv::Size2f)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:554
	void cv_RotatedRect_setPropSize_Size2f(cv::RotatedRect* instance, cv::Size2f* val) {
		instance->size = *val;
	}
	
	// angle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:556
	float cv_RotatedRect_getPropAngle_const(const cv::RotatedRect* instance) {
		float ret = instance->angle;
		return (float)ret;
	}
	
	// angle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:556
	void cv_RotatedRect_setPropAngle_float(cv::RotatedRect* instance, float val) {
		instance->angle = val;
	}
	
	void cv_RotatedRect_delete(cv::RotatedRect* instance) {
		delete instance;
	}
	// RotatedRect() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:529
	Result<cv::RotatedRect*> cv_RotatedRect_RotatedRect() {
		try {
			cv::RotatedRect* ret = new cv::RotatedRect();
			return Ok<cv::RotatedRect*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// RotatedRect(const cv::Point2f &, const cv::Size2f &, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:536
	Result<cv::RotatedRect*> cv_RotatedRect_RotatedRect_const_Point2fR_const_Size2fR_float(const cv::Point2f* center, const cv::Size2f* size, float angle) {
		try {
			cv::RotatedRect* ret = new cv::RotatedRect(*center, *size, angle);
			return Ok<cv::RotatedRect*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// RotatedRect(const cv::Point2f &, const cv::Point2f &, const cv::Point2f &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:541
	Result<cv::RotatedRect*> cv_RotatedRect_RotatedRect_const_Point2fR_const_Point2fR_const_Point2fR(const cv::Point2f* point1, const cv::Point2f* point2, const cv::Point2f* point3) {
		try {
			cv::RotatedRect* ret = new cv::RotatedRect(*point1, *point2, *point3);
			return Ok<cv::RotatedRect*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::RotatedRect*>))
	}
	
	// points(cv::Point2f *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:546
	Result_void cv_RotatedRect_points_const_Point2fX(const cv::RotatedRect* instance, cv::Point2f* pts) {
		try {
			instance->points(pts);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// boundingRect() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:548
	Result<cv::Rect> cv_RotatedRect_boundingRect_const(const cv::RotatedRect* instance) {
		try {
			cv::Rect ret = instance->boundingRect();
			return Ok<cv::Rect>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect>))
	}
	
	// boundingRect2f() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:550
	Result<cv::Rect_<float>> cv_RotatedRect_boundingRect2f_const(const cv::RotatedRect* instance) {
		try {
			cv::Rect_<float> ret = instance->boundingRect2f();
			return Ok<cv::Rect_<float>>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Rect_<float>>))
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	cv::Mat* cv_SVD_getPropU_const(const cv::SVD* instance) {
		cv::Mat ret = instance->u;
		return new cv::Mat(ret);
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	void cv_SVD_setPropU_Mat(cv::SVD* instance, cv::Mat* val) {
		instance->u = *val;
	}
	
	// w /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	cv::Mat* cv_SVD_getPropW_const(const cv::SVD* instance) {
		cv::Mat ret = instance->w;
		return new cv::Mat(ret);
	}
	
	// w /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	void cv_SVD_setPropW_Mat(cv::SVD* instance, cv::Mat* val) {
		instance->w = *val;
	}
	
	// vt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	cv::Mat* cv_SVD_getPropVt_const(const cv::SVD* instance) {
		cv::Mat ret = instance->vt;
		return new cv::Mat(ret);
	}
	
	// vt /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2767
	void cv_SVD_setPropVt_Mat(cv::SVD* instance, cv::Mat* val) {
		instance->vt = *val;
	}
	
	void cv_SVD_delete(cv::SVD* instance) {
		delete instance;
	}
	// SVD() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2663
	Result<cv::SVD*> cv_SVD_SVD() {
		try {
			cv::SVD* ret = new cv::SVD();
			return Ok<cv::SVD*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SVD*>))
	}
	
	// SVD(cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2670
	Result<cv::SVD*> cv_SVD_SVD_const__InputArrayR_int(const cv::_InputArray* src, int flags) {
		try {
			cv::SVD* ret = new cv::SVD(*src, flags);
			return Ok<cv::SVD*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SVD*>))
	}
	
	// compute(cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2702
	Result_void cv_SVD_compute_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* w, const cv::_OutputArray* u, const cv::_OutputArray* vt, int flags) {
		try {
			cv::SVD::compute(*src, *w, *u, *vt, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// compute(cv::InputArray, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2711
	Result_void cv_SVD_compute_const__InputArrayR_const__OutputArrayR_int(const cv::_InputArray* src, const cv::_OutputArray* w, int flags) {
		try {
			cv::SVD::compute(*src, *w, flags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// backSubst(cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2715
	Result_void cv_SVD_backSubst_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* w, const cv::_InputArray* u, const cv::_InputArray* vt, const cv::_InputArray* rhs, const cv::_OutputArray* dst) {
		try {
			cv::SVD::backSubst(*w, *u, *vt, *rhs, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// solveZ(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2729
	Result_void cv_SVD_solveZ_const__InputArrayR_const__OutputArrayR(const cv::_InputArray* src, const cv::_OutputArray* dst) {
		try {
			cv::SVD::solveZ(*src, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// backSubst(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core.hpp:2753
	Result_void cv_SVD_backSubst_const_const__InputArrayR_const__OutputArrayR(const cv::SVD* instance, const cv::_InputArray* rhs, const cv::_OutputArray* dst) {
		try {
			instance->backSubst(*rhs, *dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2962
	int cv_SparseMat_getPropFlags_const(const cv::SparseMat* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2962
	void cv_SparseMat_setPropFlags_int(cv::SparseMat* instance, int val) {
		instance->flags = val;
	}
	
	// hdr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2963
	cv::SparseMat::Hdr** cv_SparseMat_getPropHdr(cv::SparseMat* instance) {
		cv::SparseMat::Hdr* ret = instance->hdr;
		return new cv::SparseMat::Hdr*(ret);
	}
	
	// hdr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2963
	void cv_SparseMat_setPropHdr_HdrX(cv::SparseMat* instance, cv::SparseMat::Hdr* val) {
		instance->hdr = val;
	}
	
	void cv_SparseMat_delete(cv::SparseMat* instance) {
		delete instance;
	}
	// SparseMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2740
	Result<cv::SparseMat*> cv_SparseMat_SparseMat() {
		try {
			cv::SparseMat* ret = new cv::SparseMat();
			return Ok<cv::SparseMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat*>))
	}
	
	// SparseMat(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2747
	Result<cv::SparseMat*> cv_SparseMat_SparseMat_int_const_intX_int(int dims, const int* _sizes, int _type) {
		try {
			cv::SparseMat* ret = new cv::SparseMat(dims, _sizes, _type);
			return Ok<cv::SparseMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat*>))
	}
	
	// SparseMat(const cv::SparseMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2753
	Result<cv::SparseMat*> cv_SparseMat_SparseMat_const_SparseMatR(const cv::SparseMat* m) {
		try {
			cv::SparseMat* ret = new cv::SparseMat(*m);
			return Ok<cv::SparseMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat*>))
	}
	
	// SparseMat(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2759
	Result<cv::SparseMat*> cv_SparseMat_SparseMat_const_MatR(const cv::Mat* m) {
		try {
			cv::SparseMat* ret = new cv::SparseMat(*m);
			return Ok<cv::SparseMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat*>))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2770
	Result<cv::SparseMat*> cv_SparseMat_clone_const(const cv::SparseMat* instance) {
		try {
			cv::SparseMat ret = instance->clone();
			return Ok(new cv::SparseMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat*>))
	}
	
	// copyTo(cv::SparseMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2773
	Result_void cv_SparseMat_copyTo_const_SparseMatR(const cv::SparseMat* instance, cv::SparseMat* m) {
		try {
			instance->copyTo(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2775
	Result_void cv_SparseMat_copyTo_const_MatR(const cv::SparseMat* instance, cv::Mat* m) {
		try {
			instance->copyTo(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::SparseMat &, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2777
	Result_void cv_SparseMat_convertTo_const_SparseMatR_int_double(const cv::SparseMat* instance, cv::SparseMat* m, int rtype, double alpha) {
		try {
			instance->convertTo(*m, rtype, alpha);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::Mat &, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2788
	Result_void cv_SparseMat_convertTo_const_MatR_int_double_double(const cv::SparseMat* instance, cv::Mat* m, int rtype, double alpha, double beta) {
		try {
			instance->convertTo(*m, rtype, alpha, beta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assignTo(cv::SparseMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2791
	Result_void cv_SparseMat_assignTo_const_SparseMatR_int(const cv::SparseMat* instance, cv::SparseMat* m, int type) {
		try {
			instance->assignTo(*m, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2799
	Result_void cv_SparseMat_create_int_const_intX_int(cv::SparseMat* instance, int dims, const int* _sizes, int _type) {
		try {
			instance->create(dims, _sizes, _type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2801
	Result_void cv_SparseMat_clear(cv::SparseMat* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addref() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2803
	Result_void cv_SparseMat_addref(cv::SparseMat* instance) {
		try {
			instance->addref();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2805
	Result_void cv_SparseMat_release(cv::SparseMat* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2810
	Result<size_t> cv_SparseMat_elemSize_const(const cv::SparseMat* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2812
	Result<size_t> cv_SparseMat_elemSize1_const(const cv::SparseMat* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2815
	Result<int> cv_SparseMat_type_const(const cv::SparseMat* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2817
	Result<int> cv_SparseMat_depth_const(const cv::SparseMat* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2819
	Result<int> cv_SparseMat_channels_const(const cv::SparseMat* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2822
	Result<const int*> cv_SparseMat_size_const(const cv::SparseMat* instance) {
		try {
			const int* ret = instance->size();
			return Ok<const int*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const int*>))
	}
	
	// size(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2824
	Result<int> cv_SparseMat_size_const_int(const cv::SparseMat* instance, int i) {
		try {
			int ret = instance->size(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// dims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2826
	Result<int> cv_SparseMat_dims_const(const cv::SparseMat* instance) {
		try {
			int ret = instance->dims();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nzcount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2828
	Result<size_t> cv_SparseMat_nzcount_const(const cv::SparseMat* instance) {
		try {
			size_t ret = instance->nzcount();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// hash(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2831
	Result<size_t> cv_SparseMat_hash_const_int(const cv::SparseMat* instance, int i0) {
		try {
			size_t ret = instance->hash(i0);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// hash(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2833
	Result<size_t> cv_SparseMat_hash_const_int_int(const cv::SparseMat* instance, int i0, int i1) {
		try {
			size_t ret = instance->hash(i0, i1);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// hash(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2835
	Result<size_t> cv_SparseMat_hash_const_int_int_int(const cv::SparseMat* instance, int i0, int i1, int i2) {
		try {
			size_t ret = instance->hash(i0, i1, i2);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// hash(const int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2837
	Result<size_t> cv_SparseMat_hash_const_const_intX(const cv::SparseMat* instance, const int* idx) {
		try {
			size_t ret = instance->hash(idx);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// ptr(int, bool, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2851
	Result<unsigned char*> cv_SparseMat_ptr_int_bool_size_tX(cv::SparseMat* instance, int i0, bool createMissing, size_t* hashval) {
		try {
			unsigned char* ret = instance->ptr(i0, createMissing, hashval);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int, int, bool, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2853
	Result<unsigned char*> cv_SparseMat_ptr_int_int_bool_size_tX(cv::SparseMat* instance, int i0, int i1, bool createMissing, size_t* hashval) {
		try {
			unsigned char* ret = instance->ptr(i0, i1, createMissing, hashval);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int, int, int, bool, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2855
	Result<unsigned char*> cv_SparseMat_ptr_int_int_int_bool_size_tX(cv::SparseMat* instance, int i0, int i1, int i2, bool createMissing, size_t* hashval) {
		try {
			unsigned char* ret = instance->ptr(i0, i1, i2, createMissing, hashval);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(const int *, bool, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2857
	Result<unsigned char*> cv_SparseMat_ptr_const_intX_bool_size_tX(cv::SparseMat* instance, const int* idx, bool createMissing, size_t* hashval) {
		try {
			unsigned char* ret = instance->ptr(idx, createMissing, hashval);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// erase(int, int, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2918
	Result_void cv_SparseMat_erase_int_int_size_tX(cv::SparseMat* instance, int i0, int i1, size_t* hashval) {
		try {
			instance->erase(i0, i1, hashval);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erase(int, int, int, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2920
	Result_void cv_SparseMat_erase_int_int_int_size_tX(cv::SparseMat* instance, int i0, int i1, int i2, size_t* hashval) {
		try {
			instance->erase(i0, i1, i2, hashval);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// erase(const int *, size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2922
	Result_void cv_SparseMat_erase_const_intX_size_tX(cv::SparseMat* instance, const int* idx, size_t* hashval) {
		try {
			instance->erase(idx, hashval);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// begin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2929
	Result<cv::SparseMatIterator*> cv_SparseMat_begin(cv::SparseMat* instance) {
		try {
			cv::SparseMatIterator ret = instance->begin();
			return Ok(new cv::SparseMatIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatIterator*>))
	}
	
	// begin() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2933
	Result<cv::SparseMatConstIterator*> cv_SparseMat_begin_const(const cv::SparseMat* instance) {
		try {
			cv::SparseMatConstIterator ret = instance->begin();
			return Ok(new cv::SparseMatConstIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatConstIterator*>))
	}
	
	// end() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2941
	Result<cv::SparseMatIterator*> cv_SparseMat_end(cv::SparseMat* instance) {
		try {
			cv::SparseMatIterator ret = instance->end();
			return Ok(new cv::SparseMatIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatIterator*>))
	}
	
	// end() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2943
	Result<cv::SparseMatConstIterator*> cv_SparseMat_end_const(const cv::SparseMat* instance) {
		try {
			cv::SparseMatConstIterator ret = instance->end();
			return Ok(new cv::SparseMatConstIterator(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatConstIterator*>))
	}
	
	// node(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2955
	Result<cv::SparseMat::Node**> cv_SparseMat_node_size_t(cv::SparseMat* instance, size_t nidx) {
		try {
			cv::SparseMat::Node* ret = instance->node(nidx);
			return Ok(new cv::SparseMat::Node*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat::Node**>))
	}
	
	// node(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2956
	Result<const cv::SparseMat::Node**> cv_SparseMat_node_const_size_t(const cv::SparseMat* instance, size_t nidx) {
		try {
			const cv::SparseMat::Node* ret = instance->node(nidx);
			return Ok(new const cv::SparseMat::Node*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::SparseMat::Node**>))
	}
	
	// newNode(const int *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2958
	Result<unsigned char*> cv_SparseMat_newNode_const_intX_size_t(cv::SparseMat* instance, const int* idx, size_t hashval) {
		try {
			unsigned char* ret = instance->newNode(idx, hashval);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// removeNode(size_t, size_t, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2959
	Result_void cv_SparseMat_removeNode_size_t_size_t_size_t(cv::SparseMat* instance, size_t hidx, size_t nidx, size_t previdx) {
		try {
			instance->removeNode(hidx, nidx, previdx);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resizeHashTab(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2960
	Result_void cv_SparseMat_resizeHashTab_size_t(cv::SparseMat* instance, size_t newsize) {
		try {
			instance->resizeHashTab(newsize);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2716
	int cv_SparseMat_Hdr_getPropRefcount_const(const cv::SparseMat::Hdr* instance) {
		int ret = instance->refcount;
		return (int)ret;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2716
	void cv_SparseMat_Hdr_setPropRefcount_int(cv::SparseMat::Hdr* instance, int val) {
		instance->refcount = val;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2717
	int cv_SparseMat_Hdr_getPropDims_const(const cv::SparseMat::Hdr* instance) {
		int ret = instance->dims;
		return (int)ret;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2717
	void cv_SparseMat_Hdr_setPropDims_int(cv::SparseMat::Hdr* instance, int val) {
		instance->dims = val;
	}
	
	// valueOffset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2718
	int cv_SparseMat_Hdr_getPropValueOffset_const(const cv::SparseMat::Hdr* instance) {
		int ret = instance->valueOffset;
		return (int)ret;
	}
	
	// valueOffset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2718
	void cv_SparseMat_Hdr_setPropValueOffset_int(cv::SparseMat::Hdr* instance, int val) {
		instance->valueOffset = val;
	}
	
	// nodeSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2719
	size_t cv_SparseMat_Hdr_getPropNodeSize_const(const cv::SparseMat::Hdr* instance) {
		size_t ret = instance->nodeSize;
		return (size_t)ret;
	}
	
	// nodeSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2719
	void cv_SparseMat_Hdr_setPropNodeSize_size_t(cv::SparseMat::Hdr* instance, size_t val) {
		instance->nodeSize = val;
	}
	
	// nodeCount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2720
	size_t cv_SparseMat_Hdr_getPropNodeCount_const(const cv::SparseMat::Hdr* instance) {
		size_t ret = instance->nodeCount;
		return (size_t)ret;
	}
	
	// nodeCount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2720
	void cv_SparseMat_Hdr_setPropNodeCount_size_t(cv::SparseMat::Hdr* instance, size_t val) {
		instance->nodeCount = val;
	}
	
	// freeList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2721
	size_t cv_SparseMat_Hdr_getPropFreeList_const(const cv::SparseMat::Hdr* instance) {
		size_t ret = instance->freeList;
		return (size_t)ret;
	}
	
	// freeList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2721
	void cv_SparseMat_Hdr_setPropFreeList_size_t(cv::SparseMat::Hdr* instance, size_t val) {
		instance->freeList = val;
	}
	
	// pool /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2722
	std::vector<unsigned char>* cv_SparseMat_Hdr_getPropPool_const(const cv::SparseMat::Hdr* instance) {
		std::vector<unsigned char> ret = instance->pool;
		return new std::vector<unsigned char>(ret);
	}
	
	// pool /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2722
	void cv_SparseMat_Hdr_setPropPool_vector_unsigned_char_(cv::SparseMat::Hdr* instance, std::vector<unsigned char>* val) {
		instance->pool = *val;
	}
	
	// hashtab /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2723
	std::vector<size_t>* cv_SparseMat_Hdr_getPropHashtab_const(const cv::SparseMat::Hdr* instance) {
		std::vector<size_t> ret = instance->hashtab;
		return new std::vector<size_t>(ret);
	}
	
	// hashtab /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2723
	void cv_SparseMat_Hdr_setPropHashtab_vector_size_t_(cv::SparseMat::Hdr* instance, std::vector<size_t>* val) {
		instance->hashtab = *val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2724
	int** cv_SparseMat_Hdr_getPropSize(cv::SparseMat::Hdr* instance) {
		int(*ret)[32] = &instance->size;
		return (int**)ret;
	}
	
	void cv_SparseMat_Hdr_delete(cv::SparseMat::Hdr* instance) {
		delete instance;
	}
	// Hdr(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2714
	Result<cv::SparseMat::Hdr*> cv_SparseMat_Hdr_Hdr_int_const_intX_int(int _dims, const int* _sizes, int _type) {
		try {
			cv::SparseMat::Hdr* ret = new cv::SparseMat::Hdr(_dims, _sizes, _type);
			return Ok<cv::SparseMat::Hdr*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat::Hdr*>))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2715
	Result_void cv_SparseMat_Hdr_clear(cv::SparseMat::Hdr* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// hashval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2731
	size_t cv_SparseMat_Node_getPropHashval_const(const cv::SparseMat::Node* instance) {
		size_t ret = instance->hashval;
		return (size_t)ret;
	}
	
	// hashval /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2731
	void cv_SparseMat_Node_setPropHashval_size_t(cv::SparseMat::Node* instance, size_t val) {
		instance->hashval = val;
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2733
	size_t cv_SparseMat_Node_getPropNext_const(const cv::SparseMat::Node* instance) {
		size_t ret = instance->next;
		return (size_t)ret;
	}
	
	// next /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2733
	void cv_SparseMat_Node_setPropNext_size_t(cv::SparseMat::Node* instance, size_t val) {
		instance->next = val;
	}
	
	// idx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2735
	int** cv_SparseMat_Node_getPropIdx(cv::SparseMat::Node* instance) {
		int(*ret)[32] = &instance->idx;
		return (int**)ret;
	}
	
	void cv_SparseMat_Node_delete(cv::SparseMat::Node* instance) {
		delete instance;
	}
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3258
	const cv::SparseMat** cv_SparseMatConstIterator_getPropM_const(const cv::SparseMatConstIterator* instance) {
		const cv::SparseMat* ret = instance->m;
		return new const cv::SparseMat*(ret);
	}
	
	// hashidx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3259
	size_t cv_SparseMatConstIterator_getPropHashidx_const(const cv::SparseMatConstIterator* instance) {
		size_t ret = instance->hashidx;
		return (size_t)ret;
	}
	
	// hashidx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3259
	void cv_SparseMatConstIterator_setPropHashidx_size_t(cv::SparseMatConstIterator* instance, size_t val) {
		instance->hashidx = val;
	}
	
	// ptr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3260
	unsigned char* cv_SparseMatConstIterator_getPropPtr(cv::SparseMatConstIterator* instance) {
		unsigned char* ret = instance->ptr;
		return (unsigned char*)ret;
	}
	
	// ptr /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3260
	void cv_SparseMatConstIterator_setPropPtr_unsigned_charX(cv::SparseMatConstIterator* instance, unsigned char* val) {
		instance->ptr = val;
	}
	
	void cv_SparseMatConstIterator_delete(cv::SparseMatConstIterator* instance) {
		delete instance;
	}
	// SparseMatConstIterator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3232
	Result<cv::SparseMatConstIterator*> cv_SparseMatConstIterator_SparseMatConstIterator() {
		try {
			cv::SparseMatConstIterator* ret = new cv::SparseMatConstIterator();
			return Ok<cv::SparseMatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatConstIterator*>))
	}
	
	// SparseMatConstIterator(const cv::SparseMat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3234
	Result<cv::SparseMatConstIterator*> cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatX(const cv::SparseMat* _m) {
		try {
			cv::SparseMatConstIterator* ret = new cv::SparseMatConstIterator(_m);
			return Ok<cv::SparseMatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatConstIterator*>))
	}
	
	// SparseMatConstIterator(const cv::SparseMatConstIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3236
	Result<cv::SparseMatConstIterator*> cv_SparseMatConstIterator_SparseMatConstIterator_const_SparseMatConstIteratorR(const cv::SparseMatConstIterator* it) {
		try {
			cv::SparseMatConstIterator* ret = new cv::SparseMatConstIterator(*it);
			return Ok<cv::SparseMatConstIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatConstIterator*>))
	}
	
	// node() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3244
	Result<const cv::SparseMat::Node**> cv_SparseMatConstIterator_node_const(const cv::SparseMatConstIterator* instance) {
		try {
			const cv::SparseMat::Node* ret = instance->node();
			return Ok(new const cv::SparseMat::Node*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::SparseMat::Node**>))
	}
	
	// seekEnd() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3256
	Result_void cv_SparseMatConstIterator_seekEnd(cv::SparseMatConstIterator* instance) {
		try {
			instance->seekEnd();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	cv::SparseMatConstIterator* cv_SparseMatIterator_to_SparseMatConstIterator(cv::SparseMatIterator* instance) {
		return dynamic_cast<cv::SparseMatConstIterator*>(instance);
	}
	
	void cv_SparseMatIterator_delete(cv::SparseMatIterator* instance) {
		delete instance;
	}
	// SparseMatIterator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3276
	Result<cv::SparseMatIterator*> cv_SparseMatIterator_SparseMatIterator() {
		try {
			cv::SparseMatIterator* ret = new cv::SparseMatIterator();
			return Ok<cv::SparseMatIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatIterator*>))
	}
	
	// SparseMatIterator(cv::SparseMat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3278
	Result<cv::SparseMatIterator*> cv_SparseMatIterator_SparseMatIterator_SparseMatX(cv::SparseMat* _m) {
		try {
			cv::SparseMatIterator* ret = new cv::SparseMatIterator(_m);
			return Ok<cv::SparseMatIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatIterator*>))
	}
	
	// SparseMatIterator(const cv::SparseMatIterator &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3282
	Result<cv::SparseMatIterator*> cv_SparseMatIterator_SparseMatIterator_const_SparseMatIteratorR(const cv::SparseMatIterator* it) {
		try {
			cv::SparseMatIterator* ret = new cv::SparseMatIterator(*it);
			return Ok<cv::SparseMatIterator*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMatIterator*>))
	}
	
	// node() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:3289
	Result<cv::SparseMat::Node**> cv_SparseMatIterator_node_const(const cv::SparseMatIterator* instance) {
		try {
			cv::SparseMat::Node* ret = instance->node();
			return Ok(new cv::SparseMat::Node*(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::SparseMat::Node**>))
	}
	
	// cleanup() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/tls.hpp:49
	Result_void cv_TLSDataContainer_cleanup(cv::TLSDataContainer* instance) {
		try {
			instance->cleanup();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// TermCriteria() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:888
	Result<cv::TermCriteria> cv_TermCriteria_TermCriteria() {
		try {
			cv::TermCriteria ret;
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// TermCriteria(int, int, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:894
	Result<cv::TermCriteria> cv_TermCriteria_TermCriteria_int_int_double(int type, int maxCount, double epsilon) {
		try {
			cv::TermCriteria ret(type, maxCount, epsilon);
			return Ok<cv::TermCriteria>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TermCriteria>))
	}
	
	// isValid() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/types.hpp:896
	Result<bool> cv_TermCriteria_isValid_const(const cv::TermCriteria instance) {
		try {
			bool ret = instance.isValid();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_TickMeter_delete(cv::TickMeter* instance) {
		delete instance;
	}
	// TickMeter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:298
	Result<cv::TickMeter*> cv_TickMeter_TickMeter() {
		try {
			cv::TickMeter* ret = new cv::TickMeter();
			return Ok<cv::TickMeter*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::TickMeter*>))
	}
	
	// start() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:304
	Result_void cv_TickMeter_start(cv::TickMeter* instance) {
		try {
			instance->start();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stop() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:310
	Result_void cv_TickMeter_stop(cv::TickMeter* instance) {
		try {
			instance->stop();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getTimeTicks() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:321
	Result<int64_t> cv_TickMeter_getTimeTicks_const(const cv::TickMeter* instance) {
		try {
			int64_t ret = instance->getTimeTicks();
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getTimeMicro() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:327
	Result<double> cv_TickMeter_getTimeMicro_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getTimeMicro();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getTimeMilli() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:333
	Result<double> cv_TickMeter_getTimeMilli_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getTimeMilli();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getTimeSec() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:339
	Result<double> cv_TickMeter_getTimeSec_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getTimeSec();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getCounter() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:345
	Result<int64_t> cv_TickMeter_getCounter_const(const cv::TickMeter* instance) {
		try {
			int64_t ret = instance->getCounter();
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// getFPS() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:351
	Result<double> cv_TickMeter_getFPS_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getFPS();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getAvgTimeSec() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:360
	Result<double> cv_TickMeter_getAvgTimeSec_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getAvgTimeSec();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getAvgTimeMilli() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:368
	Result<double> cv_TickMeter_getAvgTimeMilli_const(const cv::TickMeter* instance) {
		try {
			double ret = instance->getAvgTimeMilli();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// reset() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utility.hpp:374
	Result_void cv_TickMeter_reset(cv::TickMeter* instance) {
		try {
			instance->reset();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2583
	int cv_UMat_getPropFlags_const(const cv::UMat* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2583
	void cv_UMat_setPropFlags_int(cv::UMat* instance, int val) {
		instance->flags = val;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2586
	int cv_UMat_getPropDims_const(const cv::UMat* instance) {
		int ret = instance->dims;
		return (int)ret;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2586
	void cv_UMat_setPropDims_int(cv::UMat* instance, int val) {
		instance->dims = val;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2589
	int cv_UMat_getPropRows_const(const cv::UMat* instance) {
		int ret = instance->rows;
		return (int)ret;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2589
	void cv_UMat_setPropRows_int(cv::UMat* instance, int val) {
		instance->rows = val;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2592
	int cv_UMat_getPropCols_const(const cv::UMat* instance) {
		int ret = instance->cols;
		return (int)ret;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2592
	void cv_UMat_setPropCols_int(cv::UMat* instance, int val) {
		instance->cols = val;
	}
	
	// usageFlags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2598
	cv::UMatUsageFlags cv_UMat_getPropUsageFlags_const(const cv::UMat* instance) {
		cv::UMatUsageFlags ret = instance->usageFlags;
		return (cv::UMatUsageFlags)ret;
	}
	
	// usageFlags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2598
	void cv_UMat_setPropUsageFlags_UMatUsageFlags(cv::UMat* instance, cv::UMatUsageFlags val) {
		instance->usageFlags = val;
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2607
	cv::UMatData** cv_UMat_getPropU(cv::UMat* instance) {
		cv::UMatData* ret = instance->u;
		return new cv::UMatData*(ret);
	}
	
	// u /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2607
	void cv_UMat_setPropU_UMatDataX(cv::UMat* instance, cv::UMatData* val) {
		instance->u = val;
	}
	
	// offset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2610
	size_t cv_UMat_getPropOffset_const(const cv::UMat* instance) {
		size_t ret = instance->offset;
		return (size_t)ret;
	}
	
	// offset /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2610
	void cv_UMat_setPropOffset_size_t(cv::UMat* instance, size_t val) {
		instance->offset = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2613
	cv::MatSize* cv_UMat_getPropSize_const(const cv::UMat* instance) {
		cv::MatSize ret = instance->size;
		return new cv::MatSize(ret);
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2616
	cv::MatStep* cv_UMat_getPropStep_const(const cv::UMat* instance) {
		cv::MatStep ret = instance->step;
		return new cv::MatStep(ret);
	}
	
	void cv_UMat_delete(cv::UMat* instance) {
		delete instance;
	}
	// UMat(cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2405
	cv::UMat* cv_UMat_UMat_UMatUsageFlags(cv::UMatUsageFlags usageFlags) {
		cv::UMat* ret = new cv::UMat(usageFlags);
		return (cv::UMat*)ret;
	}
	
	// UMat(int, int, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2408
	Result<cv::UMat*> cv_UMat_UMat_int_int_int_UMatUsageFlags(int rows, int cols, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(rows, cols, type, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(cv::Size, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2409
	Result<cv::UMat*> cv_UMat_UMat_Size_int_UMatUsageFlags(cv::Size* size, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(*size, type, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(int, int, int, const cv::Scalar &, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2411
	Result<cv::UMat*> cv_UMat_UMat_int_int_int_const_ScalarR_UMatUsageFlags(int rows, int cols, int type, const cv::Scalar* s, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(rows, cols, type, *s, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(cv::Size, int, const cv::Scalar &, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2412
	Result<cv::UMat*> cv_UMat_UMat_Size_int_const_ScalarR_UMatUsageFlags(cv::Size* size, int type, const cv::Scalar* s, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(*size, type, *s, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(int, const int *, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2415
	Result<cv::UMat*> cv_UMat_UMat_int_const_intX_int_UMatUsageFlags(int ndims, const int* sizes, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(ndims, sizes, type, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(int, const int *, int, const cv::Scalar &, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2416
	Result<cv::UMat*> cv_UMat_UMat_int_const_intX_int_const_ScalarR_UMatUsageFlags(int ndims, const int* sizes, int type, const cv::Scalar* s, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat* ret = new cv::UMat(ndims, sizes, type, *s, usageFlags);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2419
	cv::UMat* cv_UMat_UMat_const_UMatR(const cv::UMat* m) {
		cv::UMat* ret = new cv::UMat(*m);
		return (cv::UMat*)ret;
	}
	
	// UMat(const cv::UMat &, const cv::Range &, const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2422
	Result<cv::UMat*> cv_UMat_UMat_const_UMatR_const_RangeR_const_RangeR(const cv::UMat* m, const cv::Range* rowRange, const cv::Range* colRange) {
		try {
			cv::UMat* ret = new cv::UMat(*m, *rowRange, *colRange);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(const cv::UMat &, const cv::Rect &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2423
	Result<cv::UMat*> cv_UMat_UMat_const_UMatR_const_RectR(const cv::UMat* m, const cv::Rect* roi) {
		try {
			cv::UMat* ret = new cv::UMat(*m, *roi);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// UMat(const cv::UMat &, const std::vector<Range> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2425
	Result<cv::UMat*> cv_UMat_UMat_const_UMatR_const_vector_Range_R(const cv::UMat* m, const std::vector<cv::Range>* ranges) {
		try {
			cv::UMat* ret = new cv::UMat(*m, *ranges);
			return Ok<cv::UMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// getMat(cv::AccessFlag) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2436
	Result<cv::Mat*> cv_UMat_getMat_const_AccessFlag(const cv::UMat* instance, cv::AccessFlag flags) {
		try {
			cv::Mat ret = instance->getMat(flags);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// row(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2439
	Result<cv::UMat*> cv_UMat_row_const_int(const cv::UMat* instance, int y) {
		try {
			cv::UMat ret = instance->row(y);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// col(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2441
	Result<cv::UMat*> cv_UMat_col_const_int(const cv::UMat* instance, int x) {
		try {
			cv::UMat ret = instance->col(x);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// rowRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2443
	Result<cv::UMat*> cv_UMat_rowRange_const_int_int(const cv::UMat* instance, int startrow, int endrow) {
		try {
			cv::UMat ret = instance->rowRange(startrow, endrow);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// rowRange(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2444
	Result<cv::UMat*> cv_UMat_rowRange_const_const_RangeR(const cv::UMat* instance, const cv::Range* r) {
		try {
			cv::UMat ret = instance->rowRange(*r);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// colRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2446
	Result<cv::UMat*> cv_UMat_colRange_const_int_int(const cv::UMat* instance, int startcol, int endcol) {
		try {
			cv::UMat ret = instance->colRange(startcol, endcol);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// colRange(const cv::Range &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2447
	Result<cv::UMat*> cv_UMat_colRange_const_const_RangeR(const cv::UMat* instance, const cv::Range* r) {
		try {
			cv::UMat ret = instance->colRange(*r);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// diag(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2452
	Result<cv::UMat*> cv_UMat_diag_const_int(const cv::UMat* instance, int d) {
		try {
			cv::UMat ret = instance->diag(d);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// diag(const cv::UMat &, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2454
	Result<cv::UMat*> cv_UMat_diag_const_UMatR_UMatUsageFlags(const cv::UMat* d, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::diag(*d, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// diag(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2455
	Result<cv::UMat*> cv_UMat_diag_const_UMatR(const cv::UMat* d) {
		try {
			cv::UMat ret = cv::UMat::diag(*d);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2458
	Result<cv::UMat*> cv_UMat_clone_const(const cv::UMat* instance) {
		try {
			cv::UMat ret = instance->clone();
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// copyTo(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2461
	Result_void cv_UMat_copyTo_const_const__OutputArrayR(const cv::UMat* instance, const cv::_OutputArray* m) {
		try {
			instance->copyTo(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2463
	Result_void cv_UMat_copyTo_const_const__OutputArrayR_const__InputArrayR(const cv::UMat* instance, const cv::_OutputArray* m, const cv::_InputArray* mask) {
		try {
			instance->copyTo(*m, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2465
	Result_void cv_UMat_convertTo_const_const__OutputArrayR_int_double_double(const cv::UMat* instance, const cv::_OutputArray* m, int rtype, double alpha, double beta) {
		try {
			instance->convertTo(*m, rtype, alpha, beta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assignTo(cv::UMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2467
	Result_void cv_UMat_assignTo_const_UMatR_int(const cv::UMat* instance, cv::UMat* m, int type) {
		try {
			instance->assignTo(*m, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTo(cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2472
	Result<cv::UMat*> cv_UMat_setTo_const__InputArrayR_const__InputArrayR(cv::UMat* instance, const cv::_InputArray* value, const cv::_InputArray* mask) {
		try {
			cv::UMat ret = instance->setTo(*value, *mask);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// reshape(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2475
	Result<cv::UMat*> cv_UMat_reshape_const_int_int(const cv::UMat* instance, int cn, int rows) {
		try {
			cv::UMat ret = instance->reshape(cn, rows);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// reshape(int, int, const int *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2476
	Result<cv::UMat*> cv_UMat_reshape_const_int_int_const_intX(const cv::UMat* instance, int cn, int newndims, const int* newsz) {
		try {
			cv::UMat ret = instance->reshape(cn, newndims, newsz);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// t() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2479
	Result<cv::UMat*> cv_UMat_t_const(const cv::UMat* instance) {
		try {
			cv::UMat ret = instance->t();
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// inv(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2481
	Result<cv::UMat*> cv_UMat_inv_const_int(const cv::UMat* instance, int method) {
		try {
			cv::UMat ret = instance->inv(method);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// mul(cv::InputArray, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2483
	Result<cv::UMat*> cv_UMat_mul_const_const__InputArrayR_double(const cv::UMat* instance, const cv::_InputArray* m, double scale) {
		try {
			cv::UMat ret = instance->mul(*m, scale);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// dot(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2486
	Result<double> cv_UMat_dot_const_const__InputArrayR(const cv::UMat* instance, const cv::_InputArray* m) {
		try {
			double ret = instance->dot(*m);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// zeros(int, int, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2489
	Result<cv::UMat*> cv_UMat_zeros_int_int_int_UMatUsageFlags(int rows, int cols, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::zeros(rows, cols, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// zeros(cv::Size, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2490
	Result<cv::UMat*> cv_UMat_zeros_Size_int_UMatUsageFlags(cv::Size* size, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::zeros(*size, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// zeros(int, const int *, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2491
	Result<cv::UMat*> cv_UMat_zeros_int_const_intX_int_UMatUsageFlags(int ndims, const int* sz, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::zeros(ndims, sz, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// zeros(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2492
	Result<cv::UMat*> cv_UMat_zeros_int_int_int(int rows, int cols, int type) {
		try {
			cv::UMat ret = cv::UMat::zeros(rows, cols, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// zeros(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2493
	Result<cv::UMat*> cv_UMat_zeros_Size_int(cv::Size* size, int type) {
		try {
			cv::UMat ret = cv::UMat::zeros(*size, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// zeros(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2494
	Result<cv::UMat*> cv_UMat_zeros_int_const_intX_int(int ndims, const int* sz, int type) {
		try {
			cv::UMat ret = cv::UMat::zeros(ndims, sz, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(int, int, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2495
	Result<cv::UMat*> cv_UMat_ones_int_int_int_UMatUsageFlags(int rows, int cols, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::ones(rows, cols, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(cv::Size, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2496
	Result<cv::UMat*> cv_UMat_ones_Size_int_UMatUsageFlags(cv::Size* size, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::ones(*size, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(int, const int *, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2497
	Result<cv::UMat*> cv_UMat_ones_int_const_intX_int_UMatUsageFlags(int ndims, const int* sz, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::ones(ndims, sz, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2498
	Result<cv::UMat*> cv_UMat_ones_int_int_int(int rows, int cols, int type) {
		try {
			cv::UMat ret = cv::UMat::ones(rows, cols, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2499
	Result<cv::UMat*> cv_UMat_ones_Size_int(cv::Size* size, int type) {
		try {
			cv::UMat ret = cv::UMat::ones(*size, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// ones(int, const int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2500
	Result<cv::UMat*> cv_UMat_ones_int_const_intX_int(int ndims, const int* sz, int type) {
		try {
			cv::UMat ret = cv::UMat::ones(ndims, sz, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// eye(int, int, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2501
	Result<cv::UMat*> cv_UMat_eye_int_int_int_UMatUsageFlags(int rows, int cols, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::eye(rows, cols, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// eye(cv::Size, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2502
	Result<cv::UMat*> cv_UMat_eye_Size_int_UMatUsageFlags(cv::Size* size, int type, cv::UMatUsageFlags usageFlags) {
		try {
			cv::UMat ret = cv::UMat::eye(*size, type, usageFlags);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// eye(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2503
	Result<cv::UMat*> cv_UMat_eye_int_int_int(int rows, int cols, int type) {
		try {
			cv::UMat ret = cv::UMat::eye(rows, cols, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// eye(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2504
	Result<cv::UMat*> cv_UMat_eye_Size_int(cv::Size* size, int type) {
		try {
			cv::UMat ret = cv::UMat::eye(*size, type);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// create(int, int, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2508
	Result_void cv_UMat_create_int_int_int_UMatUsageFlags(cv::UMat* instance, int rows, int cols, int type, cv::UMatUsageFlags usageFlags) {
		try {
			instance->create(rows, cols, type, usageFlags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2509
	Result_void cv_UMat_create_Size_int_UMatUsageFlags(cv::UMat* instance, cv::Size* size, int type, cv::UMatUsageFlags usageFlags) {
		try {
			instance->create(*size, type, usageFlags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, const int *, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2510
	Result_void cv_UMat_create_int_const_intX_int_UMatUsageFlags(cv::UMat* instance, int ndims, const int* sizes, int type, cv::UMatUsageFlags usageFlags) {
		try {
			instance->create(ndims, sizes, type, usageFlags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(const std::vector<int> &, int, cv::UMatUsageFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2511
	Result_void cv_UMat_create_const_vector_int_R_int_UMatUsageFlags(cv::UMat* instance, const std::vector<int>* sizes, int type, cv::UMatUsageFlags usageFlags) {
		try {
			instance->create(*sizes, type, usageFlags);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// addref() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2514
	Result_void cv_UMat_addref(cv::UMat* instance) {
		try {
			instance->addref();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2517
	Result_void cv_UMat_release(cv::UMat* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// deallocate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2520
	Result_void cv_UMat_deallocate(cv::UMat* instance) {
		try {
			instance->deallocate();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// locateROI(cv::Size &, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2525
	Result_void cv_UMat_locateROI_const_SizeR_PointR(const cv::UMat* instance, cv::Size* wholeSize, cv::Point* ofs) {
		try {
			instance->locateROI(*wholeSize, *ofs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// adjustROI(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2527
	Result<cv::UMat*> cv_UMat_adjustROI_int_int_int_int(cv::UMat* instance, int dtop, int dbottom, int dleft, int dright) {
		try {
			cv::UMat ret = instance->adjustROI(dtop, dbottom, dleft, dright);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// isContinuous() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2538
	Result<bool> cv_UMat_isContinuous_const(const cv::UMat* instance) {
		try {
			bool ret = instance->isContinuous();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSubmatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2541
	Result<bool> cv_UMat_isSubmatrix_const(const cv::UMat* instance) {
		try {
			bool ret = instance->isSubmatrix();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2545
	Result<size_t> cv_UMat_elemSize_const(const cv::UMat* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2547
	Result<size_t> cv_UMat_elemSize1_const(const cv::UMat* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2549
	Result<int> cv_UMat_type_const(const cv::UMat* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2551
	Result<int> cv_UMat_depth_const(const cv::UMat* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2553
	Result<int> cv_UMat_channels_const(const cv::UMat* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// step1(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2555
	Result<size_t> cv_UMat_step1_const_int(const cv::UMat* instance, int i) {
		try {
			size_t ret = instance->step1(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2557
	Result<bool> cv_UMat_empty_const(const cv::UMat* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// total() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2559
	Result<size_t> cv_UMat_total_const(const cv::UMat* instance) {
		try {
			size_t ret = instance->total();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// checkVector(int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2562
	Result<int> cv_UMat_checkVector_const_int_int_bool(const cv::UMat* instance, int elemChannels, int depth, bool requireContinuous) {
		try {
			int ret = instance->checkVector(elemChannels, depth, requireContinuous);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// UMat(cv::UMat &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2564
	cv::UMat* cv_UMat_UMat_UMatR(cv::UMat* m) {
		cv::UMat* ret = new cv::UMat(*m);
		return (cv::UMat*)ret;
	}
	
	// handle(cv::AccessFlag) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2571
	Result<void*> cv_UMat_handle_const_AccessFlag(const cv::UMat* instance, cv::AccessFlag accessFlags) {
		try {
			void* ret = instance->handle(accessFlags);
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// ndoffset(size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2572
	Result_void cv_UMat_ndoffset_const_size_tX(const cv::UMat* instance, size_t* ofs) {
		try {
			instance->ndoffset(ofs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// updateContinuityFlag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:2604
	Result_void cv_UMat_updateContinuityFlag(cv::UMat* instance) {
		try {
			instance->updateContinuityFlag();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// urefcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:560
	int cv_UMatData_getPropUrefcount_const(const cv::UMatData* instance) {
		int ret = instance->urefcount;
		return (int)ret;
	}
	
	// urefcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:560
	void cv_UMatData_setPropUrefcount_int(cv::UMatData* instance, int val) {
		instance->urefcount = val;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:561
	int cv_UMatData_getPropRefcount_const(const cv::UMatData* instance) {
		int ret = instance->refcount;
		return (int)ret;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:561
	void cv_UMatData_setPropRefcount_int(cv::UMatData* instance, int val) {
		instance->refcount = val;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:562
	unsigned char* cv_UMatData_getPropData(cv::UMatData* instance) {
		unsigned char* ret = instance->data;
		return (unsigned char*)ret;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:562
	void cv_UMatData_setPropData_unsigned_charX(cv::UMatData* instance, unsigned char* val) {
		instance->data = val;
	}
	
	// origdata /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:563
	unsigned char* cv_UMatData_getPropOrigdata(cv::UMatData* instance) {
		unsigned char* ret = instance->origdata;
		return (unsigned char*)ret;
	}
	
	// origdata /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:563
	void cv_UMatData_setPropOrigdata_unsigned_charX(cv::UMatData* instance, unsigned char* val) {
		instance->origdata = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:564
	size_t cv_UMatData_getPropSize_const(const cv::UMatData* instance) {
		size_t ret = instance->size;
		return (size_t)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:564
	void cv_UMatData_setPropSize_size_t(cv::UMatData* instance, size_t val) {
		instance->size = val;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:566
	cv::UMatData::MemoryFlag cv_UMatData_getPropFlags_const(const cv::UMatData* instance) {
		cv::UMatData::MemoryFlag ret = instance->flags;
		return (cv::UMatData::MemoryFlag)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:566
	void cv_UMatData_setPropFlags_MemoryFlag(cv::UMatData* instance, cv::UMatData::MemoryFlag val) {
		instance->flags = val;
	}
	
	// handle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:567
	void* cv_UMatData_getPropHandle(cv::UMatData* instance) {
		void* ret = instance->handle;
		return (void*)ret;
	}
	
	// handle /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:567
	void cv_UMatData_setPropHandle_voidX(cv::UMatData* instance, void* val) {
		instance->handle = val;
	}
	
	// userdata /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:568
	void* cv_UMatData_getPropUserdata(cv::UMatData* instance) {
		void* ret = instance->userdata;
		return (void*)ret;
	}
	
	// userdata /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:568
	void cv_UMatData_setPropUserdata_voidX(cv::UMatData* instance, void* val) {
		instance->userdata = val;
	}
	
	// allocatorFlags_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:569
	int cv_UMatData_getPropAllocatorFlags__const(const cv::UMatData* instance) {
		int ret = instance->allocatorFlags_;
		return (int)ret;
	}
	
	// allocatorFlags_ /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:569
	void cv_UMatData_setPropAllocatorFlags__int(cv::UMatData* instance, int val) {
		instance->allocatorFlags_ = val;
	}
	
	// mapcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:570
	int cv_UMatData_getPropMapcount_const(const cv::UMatData* instance) {
		int ret = instance->mapcount;
		return (int)ret;
	}
	
	// mapcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:570
	void cv_UMatData_setPropMapcount_int(cv::UMatData* instance, int val) {
		instance->mapcount = val;
	}
	
	// originalUMatData /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:571
	cv::UMatData** cv_UMatData_getPropOriginalUMatData(cv::UMatData* instance) {
		cv::UMatData* ret = instance->originalUMatData;
		return new cv::UMatData*(ret);
	}
	
	// originalUMatData /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:571
	void cv_UMatData_setPropOriginalUMatData_UMatDataX(cv::UMatData* instance, cv::UMatData* val) {
		instance->originalUMatData = val;
	}
	
	void cv_UMatData_delete(cv::UMatData* instance) {
		delete instance;
	}
	// lock() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:545
	Result_void cv_UMatData_lock(cv::UMatData* instance) {
		try {
			instance->lock();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unlock() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:546
	Result_void cv_UMatData_unlock(cv::UMatData* instance) {
		try {
			instance->unlock();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// hostCopyObsolete() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:548
	Result<bool> cv_UMatData_hostCopyObsolete_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->hostCopyObsolete();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// deviceCopyObsolete() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:549
	Result<bool> cv_UMatData_deviceCopyObsolete_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->deviceCopyObsolete();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// deviceMemMapped() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:550
	Result<bool> cv_UMatData_deviceMemMapped_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->deviceMemMapped();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// copyOnMap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:551
	Result<bool> cv_UMatData_copyOnMap_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->copyOnMap();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// tempUMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:552
	Result<bool> cv_UMatData_tempUMat_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->tempUMat();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// tempCopiedUMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:553
	Result<bool> cv_UMatData_tempCopiedUMat_const(const cv::UMatData* instance) {
		try {
			bool ret = instance->tempCopiedUMat();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// markHostCopyObsolete(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:554
	Result_void cv_UMatData_markHostCopyObsolete_bool(cv::UMatData* instance, bool flag) {
		try {
			instance->markHostCopyObsolete(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// markDeviceCopyObsolete(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:555
	Result_void cv_UMatData_markDeviceCopyObsolete_bool(cv::UMatData* instance, bool flag) {
		try {
			instance->markDeviceCopyObsolete(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// markDeviceMemMapped(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:556
	Result_void cv_UMatData_markDeviceMemMapped_bool(cv::UMatData* instance, bool flag) {
		try {
			instance->markDeviceMemMapped(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv__InputArray_delete(cv::_InputArray* instance) {
		delete instance;
	}
	// _InputArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:189
	Result<cv::_InputArray*> cv__InputArray__InputArray() {
		try {
			cv::_InputArray* ret = new cv::_InputArray();
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(int, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:190
	Result<cv::_InputArray*> cv__InputArray__InputArray_int_voidX(int _flags, void* _obj) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(_flags, _obj);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:191
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_MatR(const cv::Mat* m) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*m);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const cv::MatExpr &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:192
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_MatExprR(const cv::MatExpr* expr) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*expr);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:193
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_vector_Mat_R(const std::vector<cv::Mat>* vec) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*vec);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const std::vector<bool> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:196
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_vector_bool_R(const std::vector<bool>* vec) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*vec);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const double &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:202
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_doubleR(const double* val) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*val);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:203
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_GpuMatR(const cv::cuda::GpuMat* d_mat) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*d_mat);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const std::vector<cuda::GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:204
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_vector_GpuMat_R(const std::vector<cv::cuda::GpuMat>* d_mat_array) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*d_mat_array);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const ogl::Buffer &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:205
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_BufferR(const cv::ogl::Buffer* buf) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*buf);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:206
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_HostMemR(const cv::cuda::HostMem* cuda_mem) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*cuda_mem);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:208
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_UMatR(const cv::UMat* um) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*um);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// _InputArray(const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:209
	Result<cv::_InputArray*> cv__InputArray__InputArray_const_vector_UMat_R(const std::vector<cv::UMat>* umv) {
		try {
			cv::_InputArray* ret = new cv::_InputArray(*umv);
			return Ok<cv::_InputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray*>))
	}
	
	// getMat(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:217
	Result<cv::Mat*> cv__InputArray_getMat_const_int(const cv::_InputArray* instance, int idx) {
		try {
			cv::Mat ret = instance->getMat(idx);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getMat_(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:218
	Result<cv::Mat*> cv__InputArray_getMat__const_int(const cv::_InputArray* instance, int idx) {
		try {
			cv::Mat ret = instance->getMat_(idx);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getUMat(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:219
	Result<cv::UMat*> cv__InputArray_getUMat_const_int(const cv::_InputArray* instance, int idx) {
		try {
			cv::UMat ret = instance->getUMat(idx);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// getMatVector(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:220
	Result_void cv__InputArray_getMatVector_const_vector_Mat_R(const cv::_InputArray* instance, std::vector<cv::Mat>* mv) {
		try {
			instance->getMatVector(*mv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getUMatVector(std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:221
	Result_void cv__InputArray_getUMatVector_const_vector_UMat_R(const cv::_InputArray* instance, std::vector<cv::UMat>* umv) {
		try {
			instance->getUMatVector(*umv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGpuMatVector(std::vector<cuda::GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:222
	Result_void cv__InputArray_getGpuMatVector_const_vector_GpuMat_R(const cv::_InputArray* instance, std::vector<cv::cuda::GpuMat>* gpumv) {
		try {
			instance->getGpuMatVector(*gpumv);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getGpuMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:223
	Result<cv::cuda::GpuMat*> cv__InputArray_getGpuMat_const(const cv::_InputArray* instance) {
		try {
			cv::cuda::GpuMat ret = instance->getGpuMat();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// getOGlBuffer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:224
	Result<cv::ogl::Buffer*> cv__InputArray_getOGlBuffer_const(const cv::_InputArray* instance) {
		try {
			cv::ogl::Buffer ret = instance->getOGlBuffer();
			return Ok(new cv::ogl::Buffer(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// getFlags() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:226
	Result<int> cv__InputArray_getFlags_const(const cv::_InputArray* instance) {
		try {
			int ret = instance->getFlags();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getObj() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:227
	Result<void*> cv__InputArray_getObj_const(const cv::_InputArray* instance) {
		try {
			void* ret = instance->getObj();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getSz() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:228
	Result<cv::Size> cv__InputArray_getSz_const(const cv::_InputArray* instance) {
		try {
			cv::Size ret = instance->getSz();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// kind() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:230
	Result<cv::_InputArray::KindFlag> cv__InputArray_kind_const(const cv::_InputArray* instance) {
		try {
			cv::_InputArray::KindFlag ret = instance->kind();
			return Ok<cv::_InputArray::KindFlag>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputArray::KindFlag>))
	}
	
	// dims(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:231
	Result<int> cv__InputArray_dims_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->dims(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// cols(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:232
	Result<int> cv__InputArray_cols_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->cols(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// rows(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:233
	Result<int> cv__InputArray_rows_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->rows(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// size(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:234
	Result<cv::Size> cv__InputArray_size_const_int(const cv::_InputArray* instance, int i) {
		try {
			cv::Size ret = instance->size(i);
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// sizend(int *, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:235
	Result<int> cv__InputArray_sizend_const_intX_int(const cv::_InputArray* instance, int* sz, int i) {
		try {
			int ret = instance->sizend(sz, i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// sameSize(const cv::_InputArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:236
	Result<bool> cv__InputArray_sameSize_const_const__InputArrayR(const cv::_InputArray* instance, const cv::_InputArray* arr) {
		try {
			bool ret = instance->sameSize(*arr);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// total(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:237
	Result<size_t> cv__InputArray_total_const_int(const cv::_InputArray* instance, int i) {
		try {
			size_t ret = instance->total(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:238
	Result<int> cv__InputArray_type_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->type(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:239
	Result<int> cv__InputArray_depth_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->depth(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:240
	Result<int> cv__InputArray_channels_const_int(const cv::_InputArray* instance, int i) {
		try {
			int ret = instance->channels(i);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// isContinuous(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:241
	Result<bool> cv__InputArray_isContinuous_const_int(const cv::_InputArray* instance, int i) {
		try {
			bool ret = instance->isContinuous(i);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSubmatrix(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:242
	Result<bool> cv__InputArray_isSubmatrix_const_int(const cv::_InputArray* instance, int i) {
		try {
			bool ret = instance->isSubmatrix(i);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:243
	Result<bool> cv__InputArray_empty_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// copyTo(const cv::_OutputArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:244
	Result_void cv__InputArray_copyTo_const_const__OutputArrayR(const cv::_InputArray* instance, const cv::_OutputArray* arr) {
		try {
			instance->copyTo(*arr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(const cv::_OutputArray &, const cv::_InputArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:245
	Result_void cv__InputArray_copyTo_const_const__OutputArrayR_const__InputArrayR(const cv::_InputArray* instance, const cv::_OutputArray* arr, const cv::_InputArray* mask) {
		try {
			instance->copyTo(*arr, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// offset(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:246
	Result<size_t> cv__InputArray_offset_const_int(const cv::_InputArray* instance, int i) {
		try {
			size_t ret = instance->offset(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// step(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:247
	Result<size_t> cv__InputArray_step_const_int(const cv::_InputArray* instance, int i) {
		try {
			size_t ret = instance->step(i);
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// isMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:248
	Result<bool> cv__InputArray_isMat_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isMat();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isUMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:249
	Result<bool> cv__InputArray_isUMat_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isUMat();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isMatVector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:250
	Result<bool> cv__InputArray_isMatVector_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isMatVector();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isUMatVector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:251
	Result<bool> cv__InputArray_isUMatVector_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isUMatVector();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isMatx() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:252
	Result<bool> cv__InputArray_isMatx_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isMatx();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isVector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:253
	Result<bool> cv__InputArray_isVector_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isVector();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isGpuMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:254
	Result<bool> cv__InputArray_isGpuMat_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isGpuMat();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isGpuMatVector() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:255
	Result<bool> cv__InputArray_isGpuMatVector_const(const cv::_InputArray* instance) {
		try {
			bool ret = instance->isGpuMatVector();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	cv::_InputArray* cv__InputOutputArray_to__InputArray(cv::_InputOutputArray* instance) {
		return dynamic_cast<cv::_InputArray*>(instance);
	}
	
	cv::_OutputArray* cv__InputOutputArray_to__OutputArray(cv::_InputOutputArray* instance) {
		return dynamic_cast<cv::_OutputArray*>(instance);
	}
	
	void cv__InputOutputArray_delete(cv::_InputOutputArray* instance) {
		delete instance;
	}
	// _InputOutputArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:388
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray() {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray();
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(int, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:389
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_int_voidX(int _flags, void* _obj) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(_flags, _obj);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:390
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_MatR(cv::Mat* m) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*m);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:391
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_vector_Mat_R(std::vector<cv::Mat>* vec) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*vec);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:392
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_GpuMatR(cv::cuda::GpuMat* d_mat) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*d_mat);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(ogl::Buffer &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:393
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_BufferR(cv::ogl::Buffer* buf) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*buf);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:394
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_HostMemR(cv::cuda::HostMem* cuda_mem) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*cuda_mem);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:403
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_UMatR(cv::UMat* m) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*m);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:404
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_vector_UMat_R(std::vector<cv::UMat>* vec) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*vec);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:406
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_MatR(const cv::Mat* m) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*m);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:407
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_vector_Mat_R(const std::vector<cv::Mat>* vec) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*vec);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:408
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_GpuMatR(const cv::cuda::GpuMat* d_mat) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*d_mat);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const std::vector<cuda::GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:409
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_vector_GpuMat_R(const std::vector<cv::cuda::GpuMat>* d_mat) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*d_mat);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const ogl::Buffer &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:410
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_BufferR(const cv::ogl::Buffer* buf) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*buf);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:411
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_HostMemR(const cv::cuda::HostMem* cuda_mem) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*cuda_mem);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:419
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_UMatR(const cv::UMat* m) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*m);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	// _InputOutputArray(const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:420
	Result<cv::_InputOutputArray*> cv__InputOutputArray__InputOutputArray_const_vector_UMat_R(const std::vector<cv::UMat>* vec) {
		try {
			cv::_InputOutputArray* ret = new cv::_InputOutputArray(*vec);
			return Ok<cv::_InputOutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_InputOutputArray*>))
	}
	
	cv::_InputArray* cv__OutputArray_to__InputArray(cv::_OutputArray* instance) {
		return dynamic_cast<cv::_InputArray*>(instance);
	}
	
	void cv__OutputArray_delete(cv::_OutputArray* instance) {
		delete instance;
	}
	// _OutputArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:313
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray() {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray();
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(int, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:314
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_int_voidX(int _flags, void* _obj) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(_flags, _obj);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:315
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_MatR(cv::Mat* m) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*m);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:316
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_vector_Mat_R(std::vector<cv::Mat>* vec) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*vec);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:317
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_GpuMatR(cv::cuda::GpuMat* d_mat) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*d_mat);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(std::vector<cuda::GpuMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:318
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_vector_GpuMat_R(std::vector<cv::cuda::GpuMat>* d_mat) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*d_mat);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(ogl::Buffer &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:319
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_BufferR(cv::ogl::Buffer* buf) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*buf);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:320
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_HostMemR(cv::cuda::HostMem* cuda_mem) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*cuda_mem);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:330
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_UMatR(cv::UMat* m) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*m);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:331
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_vector_UMat_R(std::vector<cv::UMat>* vec) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*vec);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:333
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_MatR(const cv::Mat* m) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*m);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:334
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_vector_Mat_R(const std::vector<cv::Mat>* vec) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*vec);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:335
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_GpuMatR(const cv::cuda::GpuMat* d_mat) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*d_mat);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const ogl::Buffer &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:337
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_BufferR(const cv::ogl::Buffer* buf) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*buf);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:338
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_HostMemR(const cv::cuda::HostMem* cuda_mem) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*cuda_mem);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:346
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_UMatR(const cv::UMat* m) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*m);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// _OutputArray(const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:347
	Result<cv::_OutputArray*> cv__OutputArray__OutputArray_const_vector_UMat_R(const std::vector<cv::UMat>* vec) {
		try {
			cv::_OutputArray* ret = new cv::_OutputArray(*vec);
			return Ok<cv::_OutputArray*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::_OutputArray*>))
	}
	
	// fixedSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:357
	Result<bool> cv__OutputArray_fixedSize_const(const cv::_OutputArray* instance) {
		try {
			bool ret = instance->fixedSize();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// fixedType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:358
	Result<bool> cv__OutputArray_fixedType_const(const cv::_OutputArray* instance) {
		try {
			bool ret = instance->fixedType();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// needed() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:359
	Result<bool> cv__OutputArray_needed_const(const cv::_OutputArray* instance) {
		try {
			bool ret = instance->needed();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getMatRef(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:360
	Result<cv::Mat*> cv__OutputArray_getMatRef_const_int(const cv::_OutputArray* instance, int i) {
		try {
			cv::Mat ret = instance->getMatRef(i);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getUMatRef(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:361
	Result<cv::UMat*> cv__OutputArray_getUMatRef_const_int(const cv::_OutputArray* instance, int i) {
		try {
			cv::UMat ret = instance->getUMatRef(i);
			return Ok(new cv::UMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::UMat*>))
	}
	
	// getGpuMatRef() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:362
	Result<cv::cuda::GpuMat*> cv__OutputArray_getGpuMatRef_const(const cv::_OutputArray* instance) {
		try {
			cv::cuda::GpuMat ret = instance->getGpuMatRef();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// getGpuMatVecRef() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:363
	Result<std::vector<cv::cuda::GpuMat>*> cv__OutputArray_getGpuMatVecRef_const(const cv::_OutputArray* instance) {
		try {
			std::vector<cv::cuda::GpuMat> ret = instance->getGpuMatVecRef();
			return Ok(new std::vector<cv::cuda::GpuMat>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<std::vector<cv::cuda::GpuMat>*>))
	}
	
	// getOGlBufferRef() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:364
	Result<cv::ogl::Buffer*> cv__OutputArray_getOGlBufferRef_const(const cv::_OutputArray* instance) {
		try {
			cv::ogl::Buffer ret = instance->getOGlBufferRef();
			return Ok(new cv::ogl::Buffer(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// getHostMemRef() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:365
	Result<cv::cuda::HostMem*> cv__OutputArray_getHostMemRef_const(const cv::_OutputArray* instance) {
		try {
			cv::cuda::HostMem ret = instance->getHostMemRef();
			return Ok(new cv::cuda::HostMem(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// create(cv::Size, int, int, bool, _OutputArray::DepthMask) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:366
	Result_void cv__OutputArray_create_const_Size_int_int_bool_DepthMask(const cv::_OutputArray* instance, cv::Size* sz, int type, int i, bool allowTransposed, cv::_OutputArray::DepthMask fixedDepthMask) {
		try {
			instance->create(*sz, type, i, allowTransposed, fixedDepthMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, int, int, int, bool, _OutputArray::DepthMask) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:367
	Result_void cv__OutputArray_create_const_int_int_int_int_bool_DepthMask(const cv::_OutputArray* instance, int rows, int cols, int type, int i, bool allowTransposed, cv::_OutputArray::DepthMask fixedDepthMask) {
		try {
			instance->create(rows, cols, type, i, allowTransposed, fixedDepthMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, const int *, int, int, bool, _OutputArray::DepthMask) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:368
	Result_void cv__OutputArray_create_const_int_const_intX_int_int_bool_DepthMask(const cv::_OutputArray* instance, int dims, const int* size, int type, int i, bool allowTransposed, cv::_OutputArray::DepthMask fixedDepthMask) {
		try {
			instance->create(dims, size, type, i, allowTransposed, fixedDepthMask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createSameSize(const cv::_InputArray &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:369
	Result_void cv__OutputArray_createSameSize_const_const__InputArrayR_int(const cv::_OutputArray* instance, const cv::_InputArray* arr, int mtype) {
		try {
			instance->createSameSize(*arr, mtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:370
	Result_void cv__OutputArray_release_const(const cv::_OutputArray* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:371
	Result_void cv__OutputArray_clear_const(const cv::_OutputArray* instance) {
		try {
			instance->clear();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTo(const cv::_InputArray &, const cv::_InputArray &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:372
	Result_void cv__OutputArray_setTo_const_const__InputArrayR_const__InputArrayR(const cv::_OutputArray* instance, const cv::_InputArray* value, const cv::_InputArray* mask) {
		try {
			instance->setTo(*value, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assign(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:374
	Result_void cv__OutputArray_assign_const_const_UMatR(const cv::_OutputArray* instance, const cv::UMat* u) {
		try {
			instance->assign(*u);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assign(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:375
	Result_void cv__OutputArray_assign_const_const_MatR(const cv::_OutputArray* instance, const cv::Mat* m) {
		try {
			instance->assign(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assign(const std::vector<UMat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:377
	Result_void cv__OutputArray_assign_const_const_vector_UMat_R(const cv::_OutputArray* instance, const std::vector<cv::UMat>* v) {
		try {
			instance->assign(*v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assign(const std::vector<Mat> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:378
	Result_void cv__OutputArray_assign_const_const_vector_Mat_R(const cv::_OutputArray* instance, const std::vector<cv::Mat>* v) {
		try {
			instance->assign(*v);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// move(cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:380
	Result_void cv__OutputArray_move_const_UMatR(const cv::_OutputArray* instance, cv::UMat* u) {
		try {
			instance->move(*u);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// move(cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/mat.hpp:381
	Result_void cv__OutputArray_move_const_MatR(const cv::_OutputArray* instance, cv::Mat* m) {
		try {
			instance->move(*m);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_BufferPool_delete(cv::cuda::BufferPool* instance) {
		delete instance;
	}
	// BufferPool(cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:692
	Result<cv::cuda::BufferPool*> cv_cuda_BufferPool_BufferPool_StreamR(cv::cuda::Stream* stream) {
		try {
			cv::cuda::BufferPool* ret = new cv::cuda::BufferPool(*stream);
			return Ok<cv::cuda::BufferPool*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::BufferPool*>))
	}
	
	// getBuffer(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:695
	Result<cv::cuda::GpuMat*> cv_cuda_BufferPool_getBuffer_int_int_int(cv::cuda::BufferPool* instance, int rows, int cols, int type) {
		try {
			cv::cuda::GpuMat ret = instance->getBuffer(rows, cols, type);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// getBuffer(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:698
	Result<cv::cuda::GpuMat*> cv_cuda_BufferPool_getBuffer_Size_int(cv::cuda::BufferPool* instance, cv::Size* size, int type) {
		try {
			cv::cuda::GpuMat ret = instance->getBuffer(*size, type);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// getAllocator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:701
	Result<cv::Ptr<cv::cuda::GpuMat::Allocator>*> cv_cuda_BufferPool_getAllocator_const(const cv::cuda::BufferPool* instance) {
		try {
			cv::Ptr<cv::cuda::GpuMat::Allocator> ret = instance->getAllocator();
			return Ok(new cv::Ptr<cv::cuda::GpuMat::Allocator>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::cuda::GpuMat::Allocator>*>))
	}
	
	void cv_DeviceInfo_delete(cv::cuda::DeviceInfo* instance) {
		delete instance;
	}
	// DeviceInfo() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1048
	Result<cv::cuda::DeviceInfo*> cv_cuda_DeviceInfo_DeviceInfo() {
		try {
			cv::cuda::DeviceInfo* ret = new cv::cuda::DeviceInfo();
			return Ok<cv::cuda::DeviceInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::DeviceInfo*>))
	}
	
	// DeviceInfo(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1057
	Result<cv::cuda::DeviceInfo*> cv_cuda_DeviceInfo_DeviceInfo_int(int device_id) {
		try {
			cv::cuda::DeviceInfo* ret = new cv::cuda::DeviceInfo(device_id);
			return Ok<cv::cuda::DeviceInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::DeviceInfo*>))
	}
	
	// deviceID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1061
	Result<int> cv_cuda_DeviceInfo_deviceID_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->deviceID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1064
	Result<void*> cv_cuda_DeviceInfo_name_const(const cv::cuda::DeviceInfo* instance) {
		try {
			const char* ret = instance->name();
			return Ok(ocvrs_create_string(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// totalGlobalMem() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1067
	Result<size_t> cv_cuda_DeviceInfo_totalGlobalMem_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->totalGlobalMem();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// sharedMemPerBlock() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1070
	Result<size_t> cv_cuda_DeviceInfo_sharedMemPerBlock_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->sharedMemPerBlock();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// regsPerBlock() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1073
	Result<int> cv_cuda_DeviceInfo_regsPerBlock_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->regsPerBlock();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// warpSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1076
	Result<int> cv_cuda_DeviceInfo_warpSize_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->warpSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// memPitch() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1079
	Result<size_t> cv_cuda_DeviceInfo_memPitch_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->memPitch();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// maxThreadsPerBlock() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1082
	Result<int> cv_cuda_DeviceInfo_maxThreadsPerBlock_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxThreadsPerBlock();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxThreadsDim() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1085
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxThreadsDim_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxThreadsDim();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxGridSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1088
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxGridSize_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxGridSize();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// clockRate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1091
	Result<int> cv_cuda_DeviceInfo_clockRate_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->clockRate();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// totalConstMem() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1094
	Result<size_t> cv_cuda_DeviceInfo_totalConstMem_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->totalConstMem();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// majorVersion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1097
	Result<int> cv_cuda_DeviceInfo_majorVersion_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->majorVersion();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// minorVersion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1100
	Result<int> cv_cuda_DeviceInfo_minorVersion_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->minorVersion();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// textureAlignment() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1103
	Result<size_t> cv_cuda_DeviceInfo_textureAlignment_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->textureAlignment();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// texturePitchAlignment() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1106
	Result<size_t> cv_cuda_DeviceInfo_texturePitchAlignment_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->texturePitchAlignment();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// multiProcessorCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1109
	Result<int> cv_cuda_DeviceInfo_multiProcessorCount_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->multiProcessorCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// kernelExecTimeoutEnabled() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1112
	Result<bool> cv_cuda_DeviceInfo_kernelExecTimeoutEnabled_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->kernelExecTimeoutEnabled();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// integrated() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1115
	Result<bool> cv_cuda_DeviceInfo_integrated_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->integrated();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// canMapHostMemory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1118
	Result<bool> cv_cuda_DeviceInfo_canMapHostMemory_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->canMapHostMemory();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// computeMode() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1129
	Result<cv::cuda::DeviceInfo::ComputeMode> cv_cuda_DeviceInfo_computeMode_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::cuda::DeviceInfo::ComputeMode ret = instance->computeMode();
			return Ok<cv::cuda::DeviceInfo::ComputeMode>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::DeviceInfo::ComputeMode>))
	}
	
	// maxTexture1D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1132
	Result<int> cv_cuda_DeviceInfo_maxTexture1D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxTexture1D();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxTexture1DMipmap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1135
	Result<int> cv_cuda_DeviceInfo_maxTexture1DMipmap_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxTexture1DMipmap();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxTexture1DLinear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1138
	Result<int> cv_cuda_DeviceInfo_maxTexture1DLinear_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxTexture1DLinear();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxTexture2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1141
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxTexture2D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxTexture2D();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxTexture2DMipmap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1144
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxTexture2DMipmap_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxTexture2DMipmap();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxTexture2DLinear() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1147
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxTexture2DLinear_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxTexture2DLinear();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxTexture2DGather() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1150
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxTexture2DGather_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxTexture2DGather();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxTexture3D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1153
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxTexture3D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxTexture3D();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxTextureCubemap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1156
	Result<int> cv_cuda_DeviceInfo_maxTextureCubemap_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxTextureCubemap();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxTexture1DLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1159
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxTexture1DLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxTexture1DLayered();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxTexture2DLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1162
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxTexture2DLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxTexture2DLayered();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxTextureCubemapLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1165
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxTextureCubemapLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxTextureCubemapLayered();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxSurface1D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1168
	Result<int> cv_cuda_DeviceInfo_maxSurface1D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxSurface1D();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxSurface2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1171
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxSurface2D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxSurface2D();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxSurface3D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1174
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxSurface3D_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxSurface3D();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxSurface1DLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1177
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxSurface1DLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxSurface1DLayered();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// maxSurface2DLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1180
	Result<cv::Vec3i> cv_cuda_DeviceInfo_maxSurface2DLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec3i ret = instance->maxSurface2DLayered();
			return Ok<cv::Vec3i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec3i>))
	}
	
	// maxSurfaceCubemap() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1183
	Result<int> cv_cuda_DeviceInfo_maxSurfaceCubemap_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxSurfaceCubemap();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxSurfaceCubemapLayered() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1186
	Result<cv::Vec2i> cv_cuda_DeviceInfo_maxSurfaceCubemapLayered_const(const cv::cuda::DeviceInfo* instance) {
		try {
			cv::Vec2i ret = instance->maxSurfaceCubemapLayered();
			return Ok<cv::Vec2i>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Vec2i>))
	}
	
	// surfaceAlignment() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1189
	Result<size_t> cv_cuda_DeviceInfo_surfaceAlignment_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->surfaceAlignment();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// concurrentKernels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1192
	Result<bool> cv_cuda_DeviceInfo_concurrentKernels_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->concurrentKernels();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ECCEnabled() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1195
	Result<bool> cv_cuda_DeviceInfo_ECCEnabled_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->ECCEnabled();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// pciBusID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1198
	Result<int> cv_cuda_DeviceInfo_pciBusID_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->pciBusID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// pciDeviceID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1201
	Result<int> cv_cuda_DeviceInfo_pciDeviceID_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->pciDeviceID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// pciDomainID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1204
	Result<int> cv_cuda_DeviceInfo_pciDomainID_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->pciDomainID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// tccDriver() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1207
	Result<bool> cv_cuda_DeviceInfo_tccDriver_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->tccDriver();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// asyncEngineCount() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1210
	Result<int> cv_cuda_DeviceInfo_asyncEngineCount_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->asyncEngineCount();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// unifiedAddressing() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1213
	Result<bool> cv_cuda_DeviceInfo_unifiedAddressing_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->unifiedAddressing();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// memoryClockRate() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1216
	Result<int> cv_cuda_DeviceInfo_memoryClockRate_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->memoryClockRate();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// memoryBusWidth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1219
	Result<int> cv_cuda_DeviceInfo_memoryBusWidth_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->memoryBusWidth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// l2CacheSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1222
	Result<int> cv_cuda_DeviceInfo_l2CacheSize_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->l2CacheSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxThreadsPerMultiProcessor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1225
	Result<int> cv_cuda_DeviceInfo_maxThreadsPerMultiProcessor_const(const cv::cuda::DeviceInfo* instance) {
		try {
			int ret = instance->maxThreadsPerMultiProcessor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// queryMemory(size_t &, size_t &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1228
	Result_void cv_cuda_DeviceInfo_queryMemory_const_size_tR_size_tR(const cv::cuda::DeviceInfo* instance, size_t* totalMemory, size_t* freeMemory) {
		try {
			instance->queryMemory(*totalMemory, *freeMemory);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// freeMemory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1229
	Result<size_t> cv_cuda_DeviceInfo_freeMemory_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->freeMemory();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// totalMemory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1230
	Result<size_t> cv_cuda_DeviceInfo_totalMemory_const(const cv::cuda::DeviceInfo* instance) {
		try {
			size_t ret = instance->totalMemory();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// supports(cv::cuda::FeatureSet) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1238
	Result<bool> cv_cuda_DeviceInfo_supports_const_FeatureSet(const cv::cuda::DeviceInfo* instance, cv::cuda::FeatureSet feature_set) {
		try {
			bool ret = instance->supports(feature_set);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isCompatible() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1245
	Result<bool> cv_cuda_DeviceInfo_isCompatible_const(const cv::cuda::DeviceInfo* instance) {
		try {
			bool ret = instance->isCompatible();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Event_delete(cv::cuda::Event* instance) {
		delete instance;
	}
	// Event(Event::CreateFlags) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:927
	Result<cv::cuda::Event*> cv_cuda_Event_Event_CreateFlags(cv::cuda::Event::CreateFlags flags) {
		try {
			cv::cuda::Event* ret = new cv::cuda::Event(flags);
			return Ok<cv::cuda::Event*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::Event*>))
	}
	
	// record(cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:930
	Result_void cv_cuda_Event_record_StreamR(cv::cuda::Event* instance, cv::cuda::Stream* stream) {
		try {
			instance->record(*stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// queryIfComplete() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:933
	Result<bool> cv_cuda_Event_queryIfComplete_const(const cv::cuda::Event* instance) {
		try {
			bool ret = instance->queryIfComplete();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// waitForCompletion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:936
	Result_void cv_cuda_Event_waitForCompletion(cv::cuda::Event* instance) {
		try {
			instance->waitForCompletion();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// elapsedTime(const cv::cuda::Event &, const cv::cuda::Event &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:939
	Result<float> cv_cuda_Event_elapsedTime_const_EventR_const_EventR(const cv::cuda::Event* start, const cv::cuda::Event* end) {
		try {
			float ret = cv::cuda::Event::elapsedTime(*start, *end);
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:354
	unsigned char* cv_cuda_GpuData_getPropData(cv::cuda::GpuData* instance) {
		unsigned char* ret = instance->data;
		return (unsigned char*)ret;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:354
	void cv_cuda_GpuData_setPropData_unsigned_charX(cv::cuda::GpuData* instance, unsigned char* val) {
		instance->data = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:355
	size_t cv_cuda_GpuData_getPropSize_const(const cv::cuda::GpuData* instance) {
		size_t ret = instance->size;
		return (size_t)ret;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:355
	void cv_cuda_GpuData_setPropSize_size_t(cv::cuda::GpuData* instance, size_t val) {
		instance->size = val;
	}
	
	void cv_GpuData_delete(cv::cuda::GpuData* instance) {
		delete instance;
	}
	// GpuData(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:345
	Result<cv::cuda::GpuData*> cv_cuda_GpuData_GpuData_size_t(size_t _size) {
		try {
			cv::cuda::GpuData* ret = new cv::cuda::GpuData(_size);
			return Ok<cv::cuda::GpuData*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuData*>))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:320
	int cv_cuda_GpuMat_getPropFlags_const(const cv::cuda::GpuMat* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:320
	void cv_cuda_GpuMat_setPropFlags_int(cv::cuda::GpuMat* instance, int val) {
		instance->flags = val;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:323
	int cv_cuda_GpuMat_getPropRows_const(const cv::cuda::GpuMat* instance) {
		int ret = instance->rows;
		return (int)ret;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:323
	void cv_cuda_GpuMat_setPropRows_int(cv::cuda::GpuMat* instance, int val) {
		instance->rows = val;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:323
	int cv_cuda_GpuMat_getPropCols_const(const cv::cuda::GpuMat* instance) {
		int ret = instance->cols;
		return (int)ret;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:323
	void cv_cuda_GpuMat_setPropCols_int(cv::cuda::GpuMat* instance, int val) {
		instance->cols = val;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:326
	size_t cv_cuda_GpuMat_getPropStep_const(const cv::cuda::GpuMat* instance) {
		size_t ret = instance->step;
		return (size_t)ret;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:326
	void cv_cuda_GpuMat_setPropStep_size_t(cv::cuda::GpuMat* instance, size_t val) {
		instance->step = val;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:329
	unsigned char* cv_cuda_GpuMat_getPropData(cv::cuda::GpuMat* instance) {
		unsigned char* ret = instance->data;
		return (unsigned char*)ret;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:329
	void cv_cuda_GpuMat_setPropData_unsigned_charX(cv::cuda::GpuMat* instance, unsigned char* val) {
		instance->data = val;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:333
	int* cv_cuda_GpuMat_getPropRefcount(cv::cuda::GpuMat* instance) {
		int* ret = instance->refcount;
		return (int*)ret;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:333
	void cv_cuda_GpuMat_setPropRefcount_intX(cv::cuda::GpuMat* instance, int* val) {
		instance->refcount = val;
	}
	
	// datastart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:336
	unsigned char* cv_cuda_GpuMat_getPropDatastart(cv::cuda::GpuMat* instance) {
		unsigned char* ret = instance->datastart;
		return (unsigned char*)ret;
	}
	
	// datastart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:336
	void cv_cuda_GpuMat_setPropDatastart_unsigned_charX(cv::cuda::GpuMat* instance, unsigned char* val) {
		instance->datastart = val;
	}
	
	// dataend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:337
	const unsigned char* cv_cuda_GpuMat_getPropDataend_const(const cv::cuda::GpuMat* instance) {
		const unsigned char* ret = instance->dataend;
		return (const unsigned char*)ret;
	}
	
	// allocator /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:340
	cv::cuda::GpuMat::Allocator* cv_cuda_GpuMat_getPropAllocator(cv::cuda::GpuMat* instance) {
		cv::cuda::GpuMat::Allocator* ret = instance->allocator;
		return ret;
	}
	
	// allocator /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:340
	void cv_cuda_GpuMat_setPropAllocator_AllocatorX(cv::cuda::GpuMat* instance, cv::cuda::GpuMat::Allocator* val) {
		instance->allocator = val;
	}
	
	void cv_GpuMat_delete(cv::cuda::GpuMat* instance) {
		delete instance;
	}
	// defaultAllocator() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:119
	Result<cv::cuda::GpuMat::Allocator*> cv_cuda_GpuMat_defaultAllocator() {
		try {
			cv::cuda::GpuMat::Allocator* ret = cv::cuda::GpuMat::defaultAllocator();
			return Ok(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat::Allocator*>))
	}
	
	// setDefaultAllocator(GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:120
	Result_void cv_cuda_GpuMat_setDefaultAllocator_AllocatorX(cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat::setDefaultAllocator(allocator);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// GpuMat(GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:123
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_AllocatorX(cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(int, int, int, GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:126
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_int_int_int_AllocatorX(int rows, int cols, int type, cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(rows, cols, type, allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(cv::Size, int, GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:127
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_Size_int_AllocatorX(cv::Size* size, int type, cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*size, type, allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(int, int, int, cv::Scalar, GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:130
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_int_int_int_Scalar_AllocatorX(int rows, int cols, int type, cv::Scalar* s, cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(rows, cols, type, *s, allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(cv::Size, int, cv::Scalar, GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:131
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_Size_int_Scalar_AllocatorX(cv::Size* size, int type, cv::Scalar* s, cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*size, type, *s, allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(const cv::cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:134
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_const_GpuMatR(const cv::cuda::GpuMat* m) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*m);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(int, int, int, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:137
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_int_int_int_voidX_size_t(int rows, int cols, int type, void* data, size_t step) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(rows, cols, type, data, step);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(cv::Size, int, void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:138
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_Size_int_voidX_size_t(cv::Size* size, int type, void* data, size_t step) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*size, type, data, step);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(const cv::cuda::GpuMat &, cv::Range, cv::Range) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:141
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_const_GpuMatR_Range_Range(const cv::cuda::GpuMat* m, cv::Range* rowRange, cv::Range* colRange) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*m, *rowRange, *colRange);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(const cv::cuda::GpuMat &, cv::Rect) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:142
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_const_GpuMatR_Rect(const cv::cuda::GpuMat* m, cv::Rect* roi) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*m, *roi);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMat(cv::InputArray, GpuMat::Allocator *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:145
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_GpuMat_const__InputArrayR_AllocatorX(const cv::_InputArray* arr, cv::cuda::GpuMat::Allocator* allocator) {
		try {
			cv::cuda::GpuMat* ret = new cv::cuda::GpuMat(*arr, allocator);
			return Ok<cv::cuda::GpuMat*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// create(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:154
	Result_void cv_cuda_GpuMat_create_int_int_int(cv::cuda::GpuMat* instance, int rows, int cols, int type) {
		try {
			instance->create(rows, cols, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:155
	Result_void cv_cuda_GpuMat_create_Size_int(cv::cuda::GpuMat* instance, cv::Size* size, int type) {
		try {
			instance->create(*size, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:158
	Result_void cv_cuda_GpuMat_release(cv::cuda::GpuMat* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// swap(cv::cuda::GpuMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:161
	Result_void cv_cuda_GpuMat_swap_GpuMatR(cv::cuda::GpuMat* instance, cv::cuda::GpuMat* mat) {
		try {
			instance->swap(*mat);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// upload(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:168
	Result_void cv_cuda_GpuMat_upload_const__InputArrayR(cv::cuda::GpuMat* instance, const cv::_InputArray* arr) {
		try {
			instance->upload(*arr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// upload(cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:178
	Result_void cv_cuda_GpuMat_upload_const__InputArrayR_StreamR(cv::cuda::GpuMat* instance, const cv::_InputArray* arr, cv::cuda::Stream* stream) {
		try {
			instance->upload(*arr, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// download(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:185
	Result_void cv_cuda_GpuMat_download_const_const__OutputArrayR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst) {
		try {
			instance->download(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// download(cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:195
	Result_void cv_cuda_GpuMat_download_const_const__OutputArrayR_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->download(*dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:198
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_clone_const(const cv::cuda::GpuMat* instance) {
		try {
			cv::cuda::GpuMat ret = instance->clone();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// copyTo(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:201
	Result_void cv_cuda_GpuMat_copyTo_const_const__OutputArrayR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst) {
		try {
			instance->copyTo(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:204
	Result_void cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->copyTo(*dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:207
	Result_void cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, const cv::_InputArray* mask) {
		try {
			instance->copyTo(*dst, *mask);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:210
	Result_void cv_cuda_GpuMat_copyTo_const_const__OutputArrayR_const__InputArrayR_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			instance->copyTo(*dst, *mask, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTo(cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:213
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_setTo_Scalar(cv::cuda::GpuMat* instance, cv::Scalar* s) {
		try {
			cv::cuda::GpuMat ret = instance->setTo(*s);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// setTo(cv::Scalar, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:216
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_setTo_Scalar_StreamR(cv::cuda::GpuMat* instance, cv::Scalar* s, cv::cuda::Stream* stream) {
		try {
			cv::cuda::GpuMat ret = instance->setTo(*s, *stream);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// setTo(cv::Scalar, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:219
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR(cv::cuda::GpuMat* instance, cv::Scalar* s, const cv::_InputArray* mask) {
		try {
			cv::cuda::GpuMat ret = instance->setTo(*s, *mask);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// setTo(cv::Scalar, cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:222
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_setTo_Scalar_const__InputArrayR_StreamR(cv::cuda::GpuMat* instance, cv::Scalar* s, const cv::_InputArray* mask, cv::cuda::Stream* stream) {
		try {
			cv::cuda::GpuMat ret = instance->setTo(*s, *mask, *stream);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// convertTo(cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:225
	Result_void cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, int rtype) {
		try {
			instance->convertTo(*dst, rtype);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:228
	Result_void cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, int rtype, cv::cuda::Stream* stream) {
		try {
			instance->convertTo(*dst, rtype, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, double, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:231
	Result_void cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, int rtype, double alpha, double beta) {
		try {
			instance->convertTo(*dst, rtype, alpha, beta);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, double, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:234
	Result_void cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, int rtype, double alpha, cv::cuda::Stream* stream) {
		try {
			instance->convertTo(*dst, rtype, alpha, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// convertTo(cv::OutputArray, int, double, double, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:237
	Result_void cv_cuda_GpuMat_convertTo_const_const__OutputArrayR_int_double_double_StreamR(const cv::cuda::GpuMat* instance, const cv::_OutputArray* dst, int rtype, double alpha, double beta, cv::cuda::Stream* stream) {
		try {
			instance->convertTo(*dst, rtype, alpha, beta, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// assignTo(cv::cuda::GpuMat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:239
	Result_void cv_cuda_GpuMat_assignTo_const_GpuMatR_int(const cv::cuda::GpuMat* instance, cv::cuda::GpuMat* m, int type) {
		try {
			instance->assignTo(*m, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ptr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:242
	Result<unsigned char*> cv_cuda_GpuMat_ptr_int(cv::cuda::GpuMat* instance, int y) {
		try {
			unsigned char* ret = instance->ptr(y);
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// ptr(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:243
	Result<const unsigned char*> cv_cuda_GpuMat_ptr_const_int(const cv::cuda::GpuMat* instance, int y) {
		try {
			const unsigned char* ret = instance->ptr(y);
			return Ok<const unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<const unsigned char*>))
	}
	
	// row(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:253
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_row_const_int(const cv::cuda::GpuMat* instance, int y) {
		try {
			cv::cuda::GpuMat ret = instance->row(y);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// col(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:256
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_col_const_int(const cv::cuda::GpuMat* instance, int x) {
		try {
			cv::cuda::GpuMat ret = instance->col(x);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// rowRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:259
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_rowRange_const_int_int(const cv::cuda::GpuMat* instance, int startrow, int endrow) {
		try {
			cv::cuda::GpuMat ret = instance->rowRange(startrow, endrow);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// rowRange(cv::Range) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:260
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_rowRange_const_Range(const cv::cuda::GpuMat* instance, cv::Range* r) {
		try {
			cv::cuda::GpuMat ret = instance->rowRange(*r);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// colRange(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:263
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_colRange_const_int_int(const cv::cuda::GpuMat* instance, int startcol, int endcol) {
		try {
			cv::cuda::GpuMat ret = instance->colRange(startcol, endcol);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// colRange(cv::Range) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:264
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_colRange_const_Range(const cv::cuda::GpuMat* instance, cv::Range* r) {
		try {
			cv::cuda::GpuMat ret = instance->colRange(*r);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// reshape(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:272
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_reshape_const_int_int(const cv::cuda::GpuMat* instance, int cn, int rows) {
		try {
			cv::cuda::GpuMat ret = instance->reshape(cn, rows);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// locateROI(cv::Size &, cv::Point &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:275
	Result_void cv_cuda_GpuMat_locateROI_const_SizeR_PointR(const cv::cuda::GpuMat* instance, cv::Size* wholeSize, cv::Point* ofs) {
		try {
			instance->locateROI(*wholeSize, *ofs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// adjustROI(int, int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:278
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMat_adjustROI_int_int_int_int(cv::cuda::GpuMat* instance, int dtop, int dbottom, int dleft, int dright) {
		try {
			cv::cuda::GpuMat ret = instance->adjustROI(dtop, dbottom, dleft, dright);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// isContinuous() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:282
	Result<bool> cv_cuda_GpuMat_isContinuous_const(const cv::cuda::GpuMat* instance) {
		try {
			bool ret = instance->isContinuous();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:285
	Result<size_t> cv_cuda_GpuMat_elemSize_const(const cv::cuda::GpuMat* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:288
	Result<size_t> cv_cuda_GpuMat_elemSize1_const(const cv::cuda::GpuMat* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:291
	Result<int> cv_cuda_GpuMat_type_const(const cv::cuda::GpuMat* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:294
	Result<int> cv_cuda_GpuMat_depth_const(const cv::cuda::GpuMat* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:297
	Result<int> cv_cuda_GpuMat_channels_const(const cv::cuda::GpuMat* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// step1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:300
	Result<size_t> cv_cuda_GpuMat_step1_const(const cv::cuda::GpuMat* instance) {
		try {
			size_t ret = instance->step1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:303
	Result<cv::Size> cv_cuda_GpuMat_size_const(const cv::cuda::GpuMat* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:306
	Result<bool> cv_cuda_GpuMat_empty_const(const cv::cuda::GpuMat* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// cudaPtr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:309
	Result<void*> cv_cuda_GpuMat_cudaPtr_const(const cv::cuda::GpuMat* instance) {
		try {
			void* ret = instance->cudaPtr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// updateContinuityFlag() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:312
	Result_void cv_cuda_GpuMat_updateContinuityFlag(cv::cuda::GpuMat* instance) {
		try {
			instance->updateContinuityFlag();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// allocate(cv::cuda::GpuMat *, int, int, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:114
	Result<bool> cv_cuda_GpuMat_Allocator_allocate_GpuMatX_int_int_size_t(cv::cuda::GpuMat::Allocator* instance, cv::cuda::GpuMat* mat, int rows, int cols, size_t elemSize) {
		try {
			bool ret = instance->allocate(mat, rows, cols, elemSize);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// free(cv::cuda::GpuMat *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:115
	Result_void cv_cuda_GpuMat_Allocator_free_GpuMatX(cv::cuda::GpuMat::Allocator* instance, cv::cuda::GpuMat* mat) {
		try {
			instance->free(mat);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:513
	int cv_cuda_GpuMatND_getPropFlags_const(const cv::cuda::GpuMatND* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:513
	void cv_cuda_GpuMatND_setPropFlags_int(cv::cuda::GpuMatND* instance, int val) {
		instance->flags = val;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:516
	int cv_cuda_GpuMatND_getPropDims_const(const cv::cuda::GpuMatND* instance) {
		int ret = instance->dims;
		return (int)ret;
	}
	
	// dims /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:516
	void cv_cuda_GpuMatND_setPropDims_int(cv::cuda::GpuMatND* instance, int val) {
		instance->dims = val;
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:519
	cv::cuda::GpuMatND::SizeArray* cv_cuda_GpuMatND_getPropSize_const(const cv::cuda::GpuMatND* instance) {
		cv::cuda::GpuMatND::SizeArray ret = instance->size;
		return new cv::cuda::GpuMatND::SizeArray(ret);
	}
	
	// size /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:519
	void cv_cuda_GpuMatND_setPropSize_SizeArray(cv::cuda::GpuMatND* instance, cv::cuda::GpuMatND::SizeArray* val) {
		instance->size = *val;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:524
	cv::cuda::GpuMatND::StepArray* cv_cuda_GpuMatND_getPropStep_const(const cv::cuda::GpuMatND* instance) {
		cv::cuda::GpuMatND::StepArray ret = instance->step;
		return new cv::cuda::GpuMatND::StepArray(ret);
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:524
	void cv_cuda_GpuMatND_setPropStep_StepArray(cv::cuda::GpuMatND* instance, cv::cuda::GpuMatND::StepArray* val) {
		instance->step = *val;
	}
	
	void cv_GpuMatND_delete(cv::cuda::GpuMatND* instance) {
		delete instance;
	}
	// GpuMatND() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:369
	Result<cv::cuda::GpuMatND*> cv_cuda_GpuMatND_GpuMatND() {
		try {
			cv::cuda::GpuMatND* ret = new cv::cuda::GpuMatND();
			return Ok<cv::cuda::GpuMatND*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMatND*>))
	}
	
	// GpuMatND(cv::cuda::GpuMatND::SizeArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:376
	Result<cv::cuda::GpuMatND*> cv_cuda_GpuMatND_GpuMatND_SizeArray_int(cv::cuda::GpuMatND::SizeArray* size, int type) {
		try {
			cv::cuda::GpuMatND* ret = new cv::cuda::GpuMatND(*size, type);
			return Ok<cv::cuda::GpuMatND*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMatND*>))
	}
	
	// GpuMatND(cv::cuda::GpuMatND::SizeArray, int, void *, cv::cuda::GpuMatND::StepArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:390
	Result<cv::cuda::GpuMatND*> cv_cuda_GpuMatND_GpuMatND_SizeArray_int_voidX_StepArray(cv::cuda::GpuMatND::SizeArray* size, int type, void* data, cv::cuda::GpuMatND::StepArray* step) {
		try {
			cv::cuda::GpuMatND* ret = new cv::cuda::GpuMatND(*size, type, data, *step);
			return Ok<cv::cuda::GpuMatND*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMatND*>))
	}
	
	// create(cv::cuda::GpuMatND::SizeArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:399
	Result_void cv_cuda_GpuMatND_create_SizeArray_int(cv::cuda::GpuMatND* instance, cv::cuda::GpuMatND::SizeArray* size, int type) {
		try {
			instance->create(*size, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:401
	Result_void cv_cuda_GpuMatND_release(cv::cuda::GpuMatND* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// swap(cv::cuda::GpuMatND &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:403
	void cv_cuda_GpuMatND_swap_GpuMatNDR(cv::cuda::GpuMatND* instance, cv::cuda::GpuMatND* m) {
		instance->swap(*m);
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:410
	Result<cv::cuda::GpuMatND*> cv_cuda_GpuMatND_clone_const(const cv::cuda::GpuMatND* instance) {
		try {
			cv::cuda::GpuMatND ret = instance->clone();
			return Ok(new cv::cuda::GpuMatND(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMatND*>))
	}
	
	// clone(cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:415
	Result<cv::cuda::GpuMatND*> cv_cuda_GpuMatND_clone_const_StreamR(const cv::cuda::GpuMatND* instance, cv::cuda::Stream* stream) {
		try {
			cv::cuda::GpuMatND ret = instance->clone(*stream);
			return Ok(new cv::cuda::GpuMatND(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMatND*>))
	}
	
	// createGpuMatHeader(cv::cuda::GpuMatND::IndexArray, cv::Range, cv::Range) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:429
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMatND_createGpuMatHeader_const_IndexArray_Range_Range(const cv::cuda::GpuMatND* instance, cv::cuda::GpuMatND::IndexArray* idx, cv::Range* rowRange, cv::Range* colRange) {
		try {
			cv::cuda::GpuMat ret = instance->createGpuMatHeader(*idx, *rowRange, *colRange);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// createGpuMatHeader() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:437
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMatND_createGpuMatHeader_const(const cv::cuda::GpuMatND* instance) {
		try {
			cv::cuda::GpuMat ret = instance->createGpuMatHeader();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// operator GpuMat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:450
	Result<cv::cuda::GpuMat*> cv_cuda_GpuMatND_operator_cv_cuda_GpuMat_const(const cv::cuda::GpuMatND* instance) {
		try {
			cv::cuda::GpuMat ret = instance->operator cv::cuda::GpuMat();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// GpuMatND(const cv::cuda::GpuMatND &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:452
	cv::cuda::GpuMatND* cv_cuda_GpuMatND_GpuMatND_const_GpuMatNDR(const cv::cuda::GpuMatND* unnamed) {
		cv::cuda::GpuMatND* ret = new cv::cuda::GpuMatND(*unnamed);
		return (cv::cuda::GpuMatND*)ret;
	}
	
	// GpuMatND(cv::cuda::GpuMatND &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:459
	cv::cuda::GpuMatND* cv_cuda_GpuMatND_GpuMatND_GpuMatNDR(cv::cuda::GpuMatND* unnamed) {
		cv::cuda::GpuMatND* ret = new cv::cuda::GpuMatND(*unnamed);
		return (cv::cuda::GpuMatND*)ret;
	}
	
	// upload(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:466
	Result_void cv_cuda_GpuMatND_upload_const__InputArrayR(cv::cuda::GpuMatND* instance, const cv::_InputArray* src) {
		try {
			instance->upload(*src);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// upload(cv::InputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:467
	Result_void cv_cuda_GpuMatND_upload_const__InputArrayR_StreamR(cv::cuda::GpuMatND* instance, const cv::_InputArray* src, cv::cuda::Stream* stream) {
		try {
			instance->upload(*src, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// download(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:468
	Result_void cv_cuda_GpuMatND_download_const_const__OutputArrayR(const cv::cuda::GpuMatND* instance, const cv::_OutputArray* dst) {
		try {
			instance->download(*dst);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// download(cv::OutputArray, cv::cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:469
	Result_void cv_cuda_GpuMatND_download_const_const__OutputArrayR_StreamR(const cv::cuda::GpuMatND* instance, const cv::_OutputArray* dst, cv::cuda::Stream* stream) {
		try {
			instance->download(*dst, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// isContinuous() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:473
	Result<bool> cv_cuda_GpuMatND_isContinuous_const(const cv::cuda::GpuMatND* instance) {
		try {
			bool ret = instance->isContinuous();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isSubmatrix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:476
	Result<bool> cv_cuda_GpuMatND_isSubmatrix_const(const cv::cuda::GpuMatND* instance) {
		try {
			bool ret = instance->isSubmatrix();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:479
	Result<size_t> cv_cuda_GpuMatND_elemSize_const(const cv::cuda::GpuMatND* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:482
	Result<size_t> cv_cuda_GpuMatND_elemSize1_const(const cv::cuda::GpuMatND* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:485
	Result<bool> cv_cuda_GpuMatND_empty_const(const cv::cuda::GpuMatND* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// external() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:488
	Result<bool> cv_cuda_GpuMatND_external_const(const cv::cuda::GpuMatND* instance) {
		try {
			bool ret = instance->external();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getDevicePtr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:491
	Result<unsigned char*> cv_cuda_GpuMatND_getDevicePtr_const(const cv::cuda::GpuMatND* instance) {
		try {
			unsigned char* ret = instance->getDevicePtr();
			return Ok<unsigned char*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned char*>))
	}
	
	// total() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:494
	Result<size_t> cv_cuda_GpuMatND_total_const(const cv::cuda::GpuMatND* instance) {
		try {
			size_t ret = instance->total();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// totalMemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:497
	Result<size_t> cv_cuda_GpuMatND_totalMemSize_const(const cv::cuda::GpuMatND* instance) {
		try {
			size_t ret = instance->totalMemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:500
	Result<int> cv_cuda_GpuMatND_type_const(const cv::cuda::GpuMatND* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:792
	int cv_cuda_HostMem_getPropFlags_const(const cv::cuda::HostMem* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:792
	void cv_cuda_HostMem_setPropFlags_int(cv::cuda::HostMem* instance, int val) {
		instance->flags = val;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:793
	int cv_cuda_HostMem_getPropRows_const(const cv::cuda::HostMem* instance) {
		int ret = instance->rows;
		return (int)ret;
	}
	
	// rows /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:793
	void cv_cuda_HostMem_setPropRows_int(cv::cuda::HostMem* instance, int val) {
		instance->rows = val;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:793
	int cv_cuda_HostMem_getPropCols_const(const cv::cuda::HostMem* instance) {
		int ret = instance->cols;
		return (int)ret;
	}
	
	// cols /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:793
	void cv_cuda_HostMem_setPropCols_int(cv::cuda::HostMem* instance, int val) {
		instance->cols = val;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:794
	size_t cv_cuda_HostMem_getPropStep_const(const cv::cuda::HostMem* instance) {
		size_t ret = instance->step;
		return (size_t)ret;
	}
	
	// step /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:794
	void cv_cuda_HostMem_setPropStep_size_t(cv::cuda::HostMem* instance, size_t val) {
		instance->step = val;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:796
	unsigned char* cv_cuda_HostMem_getPropData(cv::cuda::HostMem* instance) {
		unsigned char* ret = instance->data;
		return (unsigned char*)ret;
	}
	
	// data /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:796
	void cv_cuda_HostMem_setPropData_unsigned_charX(cv::cuda::HostMem* instance, unsigned char* val) {
		instance->data = val;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:797
	int* cv_cuda_HostMem_getPropRefcount(cv::cuda::HostMem* instance) {
		int* ret = instance->refcount;
		return (int*)ret;
	}
	
	// refcount /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:797
	void cv_cuda_HostMem_setPropRefcount_intX(cv::cuda::HostMem* instance, int* val) {
		instance->refcount = val;
	}
	
	// datastart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:799
	unsigned char* cv_cuda_HostMem_getPropDatastart(cv::cuda::HostMem* instance) {
		unsigned char* ret = instance->datastart;
		return (unsigned char*)ret;
	}
	
	// datastart /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:799
	void cv_cuda_HostMem_setPropDatastart_unsigned_charX(cv::cuda::HostMem* instance, unsigned char* val) {
		instance->datastart = val;
	}
	
	// dataend /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:800
	const unsigned char* cv_cuda_HostMem_getPropDataend_const(const cv::cuda::HostMem* instance) {
		const unsigned char* ret = instance->dataend;
		return (const unsigned char*)ret;
	}
	
	// alloc_type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:802
	cv::cuda::HostMem::AllocType cv_cuda_HostMem_getPropAlloc_type_const(const cv::cuda::HostMem* instance) {
		cv::cuda::HostMem::AllocType ret = instance->alloc_type;
		return (cv::cuda::HostMem::AllocType)ret;
	}
	
	// alloc_type /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:802
	void cv_cuda_HostMem_setPropAlloc_type_AllocType(cv::cuda::HostMem* instance, cv::cuda::HostMem::AllocType val) {
		instance->alloc_type = val;
	}
	
	void cv_HostMem_delete(cv::cuda::HostMem* instance) {
		delete instance;
	}
	// HostMem(HostMem::AllocType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:737
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_HostMem_AllocType(cv::cuda::HostMem::AllocType alloc_type) {
		try {
			cv::cuda::HostMem* ret = new cv::cuda::HostMem(alloc_type);
			return Ok<cv::cuda::HostMem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// HostMem(const cv::cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:739
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_HostMem_const_HostMemR(const cv::cuda::HostMem* m) {
		try {
			cv::cuda::HostMem* ret = new cv::cuda::HostMem(*m);
			return Ok<cv::cuda::HostMem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// HostMem(int, int, int, HostMem::AllocType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:741
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_HostMem_int_int_int_AllocType(int rows, int cols, int type, cv::cuda::HostMem::AllocType alloc_type) {
		try {
			cv::cuda::HostMem* ret = new cv::cuda::HostMem(rows, cols, type, alloc_type);
			return Ok<cv::cuda::HostMem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// HostMem(cv::Size, int, HostMem::AllocType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:742
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_HostMem_Size_int_AllocType(cv::Size* size, int type, cv::cuda::HostMem::AllocType alloc_type) {
		try {
			cv::cuda::HostMem* ret = new cv::cuda::HostMem(*size, type, alloc_type);
			return Ok<cv::cuda::HostMem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// HostMem(cv::InputArray, HostMem::AllocType) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:745
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_HostMem_const__InputArrayR_AllocType(const cv::_InputArray* arr, cv::cuda::HostMem::AllocType alloc_type) {
		try {
			cv::cuda::HostMem* ret = new cv::cuda::HostMem(*arr, alloc_type);
			return Ok<cv::cuda::HostMem*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// swap(cv::cuda::HostMem &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:752
	Result_void cv_cuda_HostMem_swap_HostMemR(cv::cuda::HostMem* instance, cv::cuda::HostMem* b) {
		try {
			instance->swap(*b);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clone() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:755
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_clone_const(const cv::cuda::HostMem* instance) {
		try {
			cv::cuda::HostMem ret = instance->clone();
			return Ok(new cv::cuda::HostMem(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// create(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:758
	Result_void cv_cuda_HostMem_create_int_int_int(cv::cuda::HostMem* instance, int rows, int cols, int type) {
		try {
			instance->create(rows, cols, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:759
	Result_void cv_cuda_HostMem_create_Size_int(cv::cuda::HostMem* instance, cv::Size* size, int type) {
		try {
			instance->create(*size, type);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// reshape(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:763
	Result<cv::cuda::HostMem*> cv_cuda_HostMem_reshape_const_int_int(const cv::cuda::HostMem* instance, int cn, int rows) {
		try {
			cv::cuda::HostMem ret = instance->reshape(cn, rows);
			return Ok(new cv::cuda::HostMem(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::HostMem*>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:766
	Result_void cv_cuda_HostMem_release(cv::cuda::HostMem* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// createMatHeader() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:769
	Result<cv::Mat*> cv_cuda_HostMem_createMatHeader_const(const cv::cuda::HostMem* instance) {
		try {
			cv::Mat ret = instance->createMatHeader();
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// createGpuMatHeader() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:778
	Result<cv::cuda::GpuMat*> cv_cuda_HostMem_createGpuMatHeader_const(const cv::cuda::HostMem* instance) {
		try {
			cv::cuda::GpuMat ret = instance->createGpuMatHeader();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// isContinuous() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:781
	Result<bool> cv_cuda_HostMem_isContinuous_const(const cv::cuda::HostMem* instance) {
		try {
			bool ret = instance->isContinuous();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:782
	Result<size_t> cv_cuda_HostMem_elemSize_const(const cv::cuda::HostMem* instance) {
		try {
			size_t ret = instance->elemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:783
	Result<size_t> cv_cuda_HostMem_elemSize1_const(const cv::cuda::HostMem* instance) {
		try {
			size_t ret = instance->elemSize1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:784
	Result<int> cv_cuda_HostMem_type_const(const cv::cuda::HostMem* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:785
	Result<int> cv_cuda_HostMem_depth_const(const cv::cuda::HostMem* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:786
	Result<int> cv_cuda_HostMem_channels_const(const cv::cuda::HostMem* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// step1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:787
	Result<size_t> cv_cuda_HostMem_step1_const(const cv::cuda::HostMem* instance) {
		try {
			size_t ret = instance->step1();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:788
	Result<cv::Size> cv_cuda_HostMem_size_const(const cv::cuda::HostMem* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:789
	Result<bool> cv_cuda_HostMem_empty_const(const cv::cuda::HostMem* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Stream_delete(cv::cuda::Stream* instance) {
		delete instance;
	}
	// Stream() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:857
	Result<cv::cuda::Stream*> cv_cuda_Stream_Stream() {
		try {
			cv::cuda::Stream* ret = new cv::cuda::Stream();
			return Ok<cv::cuda::Stream*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::Stream*>))
	}
	
	// Stream(const Ptr<GpuMat::Allocator> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:860
	Result<cv::cuda::Stream*> cv_cuda_Stream_Stream_const_Ptr_Allocator_R(const cv::Ptr<cv::cuda::GpuMat::Allocator>* allocator) {
		try {
			cv::cuda::Stream* ret = new cv::cuda::Stream(*allocator);
			return Ok<cv::cuda::Stream*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::Stream*>))
	}
	
	// Stream(const size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:872
	Result<cv::cuda::Stream*> cv_cuda_Stream_Stream_const_size_t(const size_t cudaFlags) {
		try {
			cv::cuda::Stream* ret = new cv::cuda::Stream(cudaFlags);
			return Ok<cv::cuda::Stream*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::Stream*>))
	}
	
	// queryIfComplete() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:876
	Result<bool> cv_cuda_Stream_queryIfComplete_const(const cv::cuda::Stream* instance) {
		try {
			bool ret = instance->queryIfComplete();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// waitForCompletion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:880
	Result_void cv_cuda_Stream_waitForCompletion(cv::cuda::Stream* instance) {
		try {
			instance->waitForCompletion();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// waitEvent(const cv::cuda::Event &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:884
	Result_void cv_cuda_Stream_waitEvent_const_EventR(cv::cuda::Stream* instance, const cv::cuda::Event* event) {
		try {
			instance->waitEvent(*event);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// enqueueHostCallback(cv::cuda::Stream::StreamCallback, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:894
	Result_void cv_cuda_Stream_enqueueHostCallback_StreamCallback_voidX(cv::cuda::Stream* instance, cv::cuda::Stream::StreamCallback callback, void* userData) {
		try {
			instance->enqueueHostCallback(callback, userData);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// Null() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:897
	Result<cv::cuda::Stream*> cv_cuda_Stream_Null() {
		try {
			cv::cuda::Stream ret = cv::cuda::Stream::Null();
			return Ok(new cv::cuda::Stream(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::Stream*>))
	}
	
	// cudaPtr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:903
	Result<void*> cv_cuda_Stream_cudaPtr_const(const cv::cuda::Stream* instance) {
		try {
			void* ret = instance->cudaPtr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	void cv_TargetArchs_delete(cv::cuda::TargetArchs* instance) {
		delete instance;
	}
	// builtWith(cv::cuda::FeatureSet) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1024
	Result<bool> cv_cuda_TargetArchs_builtWith_FeatureSet(cv::cuda::FeatureSet feature_set) {
		try {
			bool ret = cv::cuda::TargetArchs::builtWith(feature_set);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// has(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1032
	Result<bool> cv_cuda_TargetArchs_has_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::has(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasPtx(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1033
	Result<bool> cv_cuda_TargetArchs_hasPtx_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasPtx(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasBin(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1034
	Result<bool> cv_cuda_TargetArchs_hasBin_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasBin(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasEqualOrLessPtx(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1036
	Result<bool> cv_cuda_TargetArchs_hasEqualOrLessPtx_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasEqualOrLessPtx(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasEqualOrGreater(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1037
	Result<bool> cv_cuda_TargetArchs_hasEqualOrGreater_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasEqualOrGreater(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasEqualOrGreaterPtx(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1038
	Result<bool> cv_cuda_TargetArchs_hasEqualOrGreaterPtx_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasEqualOrGreaterPtx(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// hasEqualOrGreaterBin(int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/cuda.hpp:1039
	Result<bool> cv_cuda_TargetArchs_hasEqualOrGreaterBin_int_int(int major, int minor) {
		try {
			bool ret = cv::cuda::TargetArchs::hasEqualOrGreaterBin(major, minor);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// func /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:40
	void* cv_detail_CheckContext_getPropFunc_const(const cv::detail::CheckContext* instance) {
		const char* ret = instance->func;
		return ocvrs_create_string(ret);
	}
	
	// file /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:41
	void* cv_detail_CheckContext_getPropFile_const(const cv::detail::CheckContext* instance) {
		const char* ret = instance->file;
		return ocvrs_create_string(ret);
	}
	
	// line /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:42
	int cv_detail_CheckContext_getPropLine_const(const cv::detail::CheckContext* instance) {
		int ret = instance->line;
		return (int)ret;
	}
	
	// line /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:42
	void cv_detail_CheckContext_setPropLine_int(cv::detail::CheckContext* instance, int val) {
		instance->line = val;
	}
	
	// testOp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:43
	cv::detail::TestOp cv_detail_CheckContext_getPropTestOp_const(const cv::detail::CheckContext* instance) {
		cv::detail::TestOp ret = instance->testOp;
		return (cv::detail::TestOp)ret;
	}
	
	// testOp /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:43
	void cv_detail_CheckContext_setPropTestOp_TestOp(cv::detail::CheckContext* instance, cv::detail::TestOp val) {
		instance->testOp = val;
	}
	
	// message /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:44
	void* cv_detail_CheckContext_getPropMessage_const(const cv::detail::CheckContext* instance) {
		const char* ret = instance->message;
		return ocvrs_create_string(ret);
	}
	
	// p1_str /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:45
	void* cv_detail_CheckContext_getPropP1_str_const(const cv::detail::CheckContext* instance) {
		const char* ret = instance->p1_str;
		return ocvrs_create_string(ret);
	}
	
	// p2_str /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/check.hpp:46
	void* cv_detail_CheckContext_getPropP2_str_const(const cv::detail::CheckContext* instance) {
		const char* ret = instance->p2_str;
		return ocvrs_create_string(ret);
	}
	
	void cv_Detail_CheckContext_delete(cv::detail::CheckContext* instance) {
		delete instance;
	}
	// m_funName /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:77
	void* cv_instr_NodeData_getPropM_funName_const(const cv::instr::NodeData* instance) {
		cv::String ret = instance->m_funName;
		return ocvrs_create_string(ret.c_str());
	}
	
	// m_funName /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:77
	void cv_instr_NodeData_setPropM_funName_String(cv::instr::NodeData* instance, char* val) {
		instance->m_funName = std::string(val);
	}
	
	// m_instrType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:78
	cv::instr::TYPE cv_instr_NodeData_getPropM_instrType_const(const cv::instr::NodeData* instance) {
		cv::instr::TYPE ret = instance->m_instrType;
		return (cv::instr::TYPE)ret;
	}
	
	// m_instrType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:78
	void cv_instr_NodeData_setPropM_instrType_TYPE(cv::instr::NodeData* instance, cv::instr::TYPE val) {
		instance->m_instrType = val;
	}
	
	// m_implType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:79
	cv::instr::IMPL cv_instr_NodeData_getPropM_implType_const(const cv::instr::NodeData* instance) {
		cv::instr::IMPL ret = instance->m_implType;
		return (cv::instr::IMPL)ret;
	}
	
	// m_implType /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:79
	void cv_instr_NodeData_setPropM_implType_IMPL(cv::instr::NodeData* instance, cv::instr::IMPL val) {
		instance->m_implType = val;
	}
	
	// m_fileName /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:80
	void* cv_instr_NodeData_getPropM_fileName_const(const cv::instr::NodeData* instance) {
		const char* ret = instance->m_fileName;
		return ocvrs_create_string(ret);
	}
	
	// m_lineNum /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:81
	int cv_instr_NodeData_getPropM_lineNum_const(const cv::instr::NodeData* instance) {
		int ret = instance->m_lineNum;
		return (int)ret;
	}
	
	// m_lineNum /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:81
	void cv_instr_NodeData_setPropM_lineNum_int(cv::instr::NodeData* instance, int val) {
		instance->m_lineNum = val;
	}
	
	// m_retAddress /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:82
	void* cv_instr_NodeData_getPropM_retAddress(cv::instr::NodeData* instance) {
		void* ret = instance->m_retAddress;
		return (void*)ret;
	}
	
	// m_retAddress /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:82
	void cv_instr_NodeData_setPropM_retAddress_voidX(cv::instr::NodeData* instance, void* val) {
		instance->m_retAddress = val;
	}
	
	// m_alwaysExpand /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:83
	bool cv_instr_NodeData_getPropM_alwaysExpand_const(const cv::instr::NodeData* instance) {
		bool ret = instance->m_alwaysExpand;
		return (bool)ret;
	}
	
	// m_alwaysExpand /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:83
	void cv_instr_NodeData_setPropM_alwaysExpand_bool(cv::instr::NodeData* instance, bool val) {
		instance->m_alwaysExpand = val;
	}
	
	// m_funError /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:84
	bool cv_instr_NodeData_getPropM_funError_const(const cv::instr::NodeData* instance) {
		bool ret = instance->m_funError;
		return (bool)ret;
	}
	
	// m_funError /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:84
	void cv_instr_NodeData_setPropM_funError_bool(cv::instr::NodeData* instance, bool val) {
		instance->m_funError = val;
	}
	
	// m_counter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:86
	int cv_instr_NodeData_getPropM_counter_const(const cv::instr::NodeData* instance) {
		int ret = instance->m_counter;
		return (int)ret;
	}
	
	// m_counter /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:86
	void cv_instr_NodeData_setPropM_counter_int(cv::instr::NodeData* instance, int val) {
		instance->m_counter = val;
	}
	
	// m_ticksTotal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:87
	uint64_t cv_instr_NodeData_getPropM_ticksTotal_const(const cv::instr::NodeData* instance) {
		uint64_t ret = instance->m_ticksTotal;
		return (uint64_t)ret;
	}
	
	// m_ticksTotal /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:87
	void cv_instr_NodeData_setPropM_ticksTotal_uint64_t(cv::instr::NodeData* instance, uint64_t val) {
		instance->m_ticksTotal = val;
	}
	
	// m_threads /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:89
	int cv_instr_NodeData_getPropM_threads_const(const cv::instr::NodeData* instance) {
		int ret = instance->m_threads;
		return (int)ret;
	}
	
	// m_threads /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:89
	void cv_instr_NodeData_setPropM_threads_int(cv::instr::NodeData* instance, int val) {
		instance->m_threads = val;
	}
	
	void cv_NodeData_delete(cv::instr::NodeData* instance) {
		delete instance;
	}
	// NodeData(const char *, const char *, int, void *, bool, cv::instr::TYPE, cv::instr::IMPL) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:72
	Result<cv::instr::NodeData*> cv_instr_NodeData_NodeData_const_charX_const_charX_int_voidX_bool_TYPE_IMPL(const char* funName, const char* fileName, int lineNum, void* retAddress, bool alwaysExpand, cv::instr::TYPE instrType, cv::instr::IMPL implType) {
		try {
			cv::instr::NodeData* ret = new cv::instr::NodeData(funName, fileName, lineNum, retAddress, alwaysExpand, instrType, implType);
			return Ok<cv::instr::NodeData*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::instr::NodeData*>))
	}
	
	// NodeData(cv::instr::NodeData &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:73
	Result<cv::instr::NodeData*> cv_instr_NodeData_NodeData_NodeDataR(cv::instr::NodeData* ref) {
		try {
			cv::instr::NodeData* ret = new cv::instr::NodeData(*ref);
			return Ok<cv::instr::NodeData*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::instr::NodeData*>))
	}
	
	// getTotalMs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:92
	Result<double> cv_instr_NodeData_getTotalMs_const(const cv::instr::NodeData* instance) {
		try {
			double ret = instance->getTotalMs();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// getMeanMs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/instrumentation.hpp:93
	Result<double> cv_instr_NodeData_getMeanMs_const(const cv::instr::NodeData* instance) {
		try {
			double ret = instance->getMeanMs();
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	void cv_WriteStructContext_delete(cv::internal::WriteStructContext* instance) {
		delete instance;
	}
	// WriteStructContext(cv::FileStorage &, const cv::String &, int, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/persistence.hpp:813
	Result<cv::internal::WriteStructContext*> cv_internal_WriteStructContext_WriteStructContext_FileStorageR_const_StringR_int_const_StringR(cv::FileStorage* _fs, const char* name, int flags, const char* typeName) {
		try {
			cv::internal::WriteStructContext* ret = new cv::internal::WriteStructContext(*_fs, std::string(name), flags, std::string(typeName));
			return Ok<cv::internal::WriteStructContext*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::internal::WriteStructContext*>))
	}
	
	void cv_Context_delete(cv::ocl::Context* instance) {
		delete instance;
	}
	// Context() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:256
	cv::ocl::Context* cv_ocl_Context_Context() {
		cv::ocl::Context* ret = new cv::ocl::Context();
		return (cv::ocl::Context*)ret;
	}
	
	// Context(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:257
	Result<cv::ocl::Context*> cv_ocl_Context_Context_int(int dtype) {
		try {
			cv::ocl::Context* ret = new cv::ocl::Context(dtype);
			return Ok<cv::ocl::Context*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// Context(const cv::ocl::Context &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:259
	Result<cv::ocl::Context*> cv_ocl_Context_Context_const_ContextR(const cv::ocl::Context* c) {
		try {
			cv::ocl::Context* ret = new cv::ocl::Context(*c);
			return Ok<cv::ocl::Context*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// Context(cv::ocl::Context &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:261
	cv::ocl::Context* cv_ocl_Context_Context_ContextR(cv::ocl::Context* c) {
		cv::ocl::Context* ret = new cv::ocl::Context(*c);
		return (cv::ocl::Context*)ret;
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:265
	Result<bool> cv_ocl_Context_create(cv::ocl::Context* instance) {
		try {
			bool ret = instance->create();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:267
	Result<bool> cv_ocl_Context_create_int(cv::ocl::Context* instance, int dtype) {
		try {
			bool ret = instance->create(dtype);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ndevices() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:269
	Result<size_t> cv_ocl_Context_ndevices_const(const cv::ocl::Context* instance) {
		try {
			size_t ret = instance->ndevices();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// device(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:270
	Result<cv::ocl::Device*> cv_ocl_Context_device_const_size_t(const cv::ocl::Context* instance, size_t idx) {
		try {
			cv::ocl::Device ret = instance->device(idx);
			return Ok(new cv::ocl::Device(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Device*>))
	}
	
	// getProg(const cv::ocl::ProgramSource &, const cv::String &, cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:271
	Result<cv::ocl::Program*> cv_ocl_Context_getProg_const_ProgramSourceR_const_StringR_StringR(cv::ocl::Context* instance, const cv::ocl::ProgramSource* prog, const char* buildopt, void** errmsg) {
		try {
			std::string errmsg_out;
			cv::ocl::Program ret = instance->getProg(*prog, std::string(buildopt), errmsg_out);
			*errmsg = ocvrs_create_string(errmsg_out.c_str());
			return Ok(new cv::ocl::Program(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Program*>))
	}
	
	// unloadProg(cv::ocl::Program &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:273
	Result_void cv_ocl_Context_unloadProg_ProgramR(cv::ocl::Context* instance, cv::ocl::Program* prog) {
		try {
			instance->unloadProg(*prog);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getDefault(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:280
	Result<cv::ocl::Context*> cv_ocl_Context_getDefault_bool(bool initialize) {
		try {
			cv::ocl::Context ret = cv::ocl::Context::getDefault(initialize);
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:284
	Result<void*> cv_ocl_Context_ptr_const(const cv::ocl::Context* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getOpenCLContextProperty(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:291
	Result<void*> cv_ocl_Context_getOpenCLContextProperty_const_int(const cv::ocl::Context* instance, int propertyId) {
		try {
			void* ret = instance->getOpenCLContextProperty(propertyId);
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// useSVM() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:293
	Result<bool> cv_ocl_Context_useSVM_const(const cv::ocl::Context* instance) {
		try {
			bool ret = instance->useSVM();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseSVM(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:294
	Result_void cv_ocl_Context_setUseSVM_bool(cv::ocl::Context* instance, bool enabled) {
		try {
			instance->setUseSVM(enabled);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// fromHandle(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:299
	Result<cv::ocl::Context*> cv_ocl_Context_fromHandle_voidX(void* context) {
		try {
			cv::ocl::Context ret = cv::ocl::Context::fromHandle(context);
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// fromDevice(const ocl::Device &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:300
	Result<cv::ocl::Context*> cv_ocl_Context_fromDevice_const_DeviceR(const cv::ocl::Device* device) {
		try {
			cv::ocl::Context ret = cv::ocl::Context::fromDevice(*device);
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// create(const std::string &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:301
	Result<cv::ocl::Context*> cv_ocl_Context_create_const_stringR(const char* configuration) {
		try {
			cv::ocl::Context ret = cv::ocl::Context::create(std::string(configuration));
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:303
	Result_void cv_ocl_Context_release(cv::ocl::Context* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:322
	Result<bool> cv_ocl_Context_empty_const(const cv::ocl::Context* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Context_UserContext_delete(cv::ocl::Context::UserContext* instance) {
		delete instance;
	}
	void cv_Device_delete(cv::ocl::Device* instance) {
		delete instance;
	}
	// Device() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:75
	cv::ocl::Device* cv_ocl_Device_Device() {
		cv::ocl::Device* ret = new cv::ocl::Device();
		return (cv::ocl::Device*)ret;
	}
	
	// Device(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:76
	Result<cv::ocl::Device*> cv_ocl_Device_Device_voidX(void* d) {
		try {
			cv::ocl::Device* ret = new cv::ocl::Device(d);
			return Ok<cv::ocl::Device*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Device*>))
	}
	
	// Device(const cv::ocl::Device &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:77
	Result<cv::ocl::Device*> cv_ocl_Device_Device_const_DeviceR(const cv::ocl::Device* d) {
		try {
			cv::ocl::Device* ret = new cv::ocl::Device(*d);
			return Ok<cv::ocl::Device*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Device*>))
	}
	
	// Device(cv::ocl::Device &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:79
	cv::ocl::Device* cv_ocl_Device_Device_DeviceR(cv::ocl::Device* d) {
		cv::ocl::Device* ret = new cv::ocl::Device(*d);
		return (cv::ocl::Device*)ret;
	}
	
	// set(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:83
	Result_void cv_ocl_Device_set_voidX(cv::ocl::Device* instance, void* d) {
		try {
			instance->set(d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:96
	Result<void*> cv_ocl_Device_name_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// extensions() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:97
	Result<void*> cv_ocl_Device_extensions_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->extensions();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// isExtensionSupported(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:98
	Result<bool> cv_ocl_Device_isExtensionSupported_const_const_StringR(const cv::ocl::Device* instance, const char* extensionName) {
		try {
			bool ret = instance->isExtensionSupported(std::string(extensionName));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// version() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:99
	Result<void*> cv_ocl_Device_version_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->version();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// vendorName() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:100
	Result<void*> cv_ocl_Device_vendorName_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->vendorName();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// OpenCL_C_Version() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:101
	Result<void*> cv_ocl_Device_OpenCL_C_Version_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->OpenCL_C_Version();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// OpenCLVersion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:102
	Result<void*> cv_ocl_Device_OpenCLVersion_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->OpenCLVersion();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// deviceVersionMajor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:103
	Result<int> cv_ocl_Device_deviceVersionMajor_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->deviceVersionMajor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// deviceVersionMinor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:104
	Result<int> cv_ocl_Device_deviceVersionMinor_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->deviceVersionMinor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// driverVersion() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:105
	Result<void*> cv_ocl_Device_driverVersion_const(const cv::ocl::Device* instance) {
		try {
			cv::String ret = instance->driverVersion();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:106
	Result<void*> cv_ocl_Device_ptr_const(const cv::ocl::Device* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:108
	Result<int> cv_ocl_Device_type_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// addressBits() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:110
	Result<int> cv_ocl_Device_addressBits_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->addressBits();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// available() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:111
	Result<bool> cv_ocl_Device_available_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->available();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// compilerAvailable() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:112
	Result<bool> cv_ocl_Device_compilerAvailable_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->compilerAvailable();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// linkerAvailable() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:113
	Result<bool> cv_ocl_Device_linkerAvailable_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->linkerAvailable();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// doubleFPConfig() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:126
	Result<int> cv_ocl_Device_doubleFPConfig_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->doubleFPConfig();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// singleFPConfig() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:127
	Result<int> cv_ocl_Device_singleFPConfig_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->singleFPConfig();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// halfFPConfig() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:128
	Result<int> cv_ocl_Device_halfFPConfig_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->halfFPConfig();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// endianLittle() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:130
	Result<bool> cv_ocl_Device_endianLittle_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->endianLittle();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// errorCorrectionSupport() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:131
	Result<bool> cv_ocl_Device_errorCorrectionSupport_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->errorCorrectionSupport();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// executionCapabilities() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:138
	Result<int> cv_ocl_Device_executionCapabilities_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->executionCapabilities();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// globalMemCacheSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:140
	Result<size_t> cv_ocl_Device_globalMemCacheSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->globalMemCacheSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// globalMemCacheType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:148
	Result<int> cv_ocl_Device_globalMemCacheType_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->globalMemCacheType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// globalMemCacheLineSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:149
	Result<int> cv_ocl_Device_globalMemCacheLineSize_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->globalMemCacheLineSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// globalMemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:150
	Result<size_t> cv_ocl_Device_globalMemSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->globalMemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// localMemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:152
	Result<size_t> cv_ocl_Device_localMemSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->localMemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// localMemType() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:159
	Result<int> cv_ocl_Device_localMemType_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->localMemType();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// hostUnifiedMemory() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:160
	Result<bool> cv_ocl_Device_hostUnifiedMemory_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->hostUnifiedMemory();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imageSupport() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:162
	Result<bool> cv_ocl_Device_imageSupport_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->imageSupport();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imageFromBufferSupport() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:164
	Result<bool> cv_ocl_Device_imageFromBufferSupport_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->imageFromBufferSupport();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// imagePitchAlignment() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:165
	Result<unsigned int> cv_ocl_Device_imagePitchAlignment_const(const cv::ocl::Device* instance) {
		try {
			unsigned int ret = instance->imagePitchAlignment();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// imageBaseAddressAlignment() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:166
	Result<unsigned int> cv_ocl_Device_imageBaseAddressAlignment_const(const cv::ocl::Device* instance) {
		try {
			unsigned int ret = instance->imageBaseAddressAlignment();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// intelSubgroupsSupport() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:169
	Result<bool> cv_ocl_Device_intelSubgroupsSupport_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->intelSubgroupsSupport();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// image2DMaxWidth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:171
	Result<size_t> cv_ocl_Device_image2DMaxWidth_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->image2DMaxWidth();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// image2DMaxHeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:172
	Result<size_t> cv_ocl_Device_image2DMaxHeight_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->image2DMaxHeight();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// image3DMaxWidth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:174
	Result<size_t> cv_ocl_Device_image3DMaxWidth_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->image3DMaxWidth();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// image3DMaxHeight() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:175
	Result<size_t> cv_ocl_Device_image3DMaxHeight_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->image3DMaxHeight();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// image3DMaxDepth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:176
	Result<size_t> cv_ocl_Device_image3DMaxDepth_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->image3DMaxDepth();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// imageMaxBufferSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:178
	Result<size_t> cv_ocl_Device_imageMaxBufferSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->imageMaxBufferSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// imageMaxArraySize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:179
	Result<size_t> cv_ocl_Device_imageMaxArraySize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->imageMaxArraySize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// vendorID() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:188
	Result<int> cv_ocl_Device_vendorID_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->vendorID();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// isAMD() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:193
	Result<bool> cv_ocl_Device_isAMD_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->isAMD();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isIntel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:194
	Result<bool> cv_ocl_Device_isIntel_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->isIntel();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isNVidia() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:195
	Result<bool> cv_ocl_Device_isNVidia_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->isNVidia();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// maxClockFrequency() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:197
	Result<int> cv_ocl_Device_maxClockFrequency_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxClockFrequency();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxComputeUnits() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:198
	Result<int> cv_ocl_Device_maxComputeUnits_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxComputeUnits();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxConstantArgs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:199
	Result<int> cv_ocl_Device_maxConstantArgs_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxConstantArgs();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxConstantBufferSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:200
	Result<size_t> cv_ocl_Device_maxConstantBufferSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->maxConstantBufferSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// maxMemAllocSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:202
	Result<size_t> cv_ocl_Device_maxMemAllocSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->maxMemAllocSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// maxParameterSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:203
	Result<size_t> cv_ocl_Device_maxParameterSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->maxParameterSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// maxReadImageArgs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:205
	Result<int> cv_ocl_Device_maxReadImageArgs_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxReadImageArgs();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxWriteImageArgs() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:206
	Result<int> cv_ocl_Device_maxWriteImageArgs_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxWriteImageArgs();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxSamplers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:207
	Result<int> cv_ocl_Device_maxSamplers_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxSamplers();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxWorkGroupSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:209
	Result<size_t> cv_ocl_Device_maxWorkGroupSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->maxWorkGroupSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// maxWorkItemDims() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:210
	Result<int> cv_ocl_Device_maxWorkItemDims_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->maxWorkItemDims();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// maxWorkItemSizes(size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:211
	Result_void cv_ocl_Device_maxWorkItemSizes_const_size_tX(const cv::ocl::Device* instance, size_t* unnamed) {
		try {
			instance->maxWorkItemSizes(unnamed);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// memBaseAddrAlign() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:213
	Result<int> cv_ocl_Device_memBaseAddrAlign_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->memBaseAddrAlign();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthChar() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:215
	Result<int> cv_ocl_Device_nativeVectorWidthChar_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthChar();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthShort() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:216
	Result<int> cv_ocl_Device_nativeVectorWidthShort_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthShort();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthInt() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:217
	Result<int> cv_ocl_Device_nativeVectorWidthInt_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthInt();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthLong() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:218
	Result<int> cv_ocl_Device_nativeVectorWidthLong_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthLong();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthFloat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:219
	Result<int> cv_ocl_Device_nativeVectorWidthFloat_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthFloat();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthDouble() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:220
	Result<int> cv_ocl_Device_nativeVectorWidthDouble_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthDouble();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// nativeVectorWidthHalf() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:221
	Result<int> cv_ocl_Device_nativeVectorWidthHalf_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->nativeVectorWidthHalf();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthChar() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:223
	Result<int> cv_ocl_Device_preferredVectorWidthChar_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthChar();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthShort() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:224
	Result<int> cv_ocl_Device_preferredVectorWidthShort_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthShort();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthInt() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:225
	Result<int> cv_ocl_Device_preferredVectorWidthInt_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthInt();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthLong() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:226
	Result<int> cv_ocl_Device_preferredVectorWidthLong_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthLong();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthFloat() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:227
	Result<int> cv_ocl_Device_preferredVectorWidthFloat_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthFloat();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthDouble() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:228
	Result<int> cv_ocl_Device_preferredVectorWidthDouble_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthDouble();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// preferredVectorWidthHalf() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:229
	Result<int> cv_ocl_Device_preferredVectorWidthHalf_const(const cv::ocl::Device* instance) {
		try {
			int ret = instance->preferredVectorWidthHalf();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// printfBufferSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:231
	Result<size_t> cv_ocl_Device_printfBufferSize_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->printfBufferSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// profilingTimerResolution() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:232
	Result<size_t> cv_ocl_Device_profilingTimerResolution_const(const cv::ocl::Device* instance) {
		try {
			size_t ret = instance->profilingTimerResolution();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// getDefault() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:234
	Result<const cv::ocl::Device*> cv_ocl_Device_getDefault() {
		try {
			const cv::ocl::Device ret = cv::ocl::Device::getDefault();
			return Ok(new const cv::ocl::Device(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::ocl::Device*>))
	}
	
	// fromHandle(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:243
	Result<cv::ocl::Device*> cv_ocl_Device_fromHandle_voidX(void* d) {
		try {
			cv::ocl::Device ret = cv::ocl::Device::fromHandle(d);
			return Ok(new cv::ocl::Device(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Device*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:247
	Result<bool> cv_ocl_Device_empty_const(const cv::ocl::Device* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Image2D_delete(cv::ocl::Image2D* instance) {
		delete instance;
	}
	// Image2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:742
	cv::ocl::Image2D* cv_ocl_Image2D_Image2D() {
		cv::ocl::Image2D* ret = new cv::ocl::Image2D();
		return (cv::ocl::Image2D*)ret;
	}
	
	// Image2D(const cv::UMat &, bool, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:750
	Result<cv::ocl::Image2D*> cv_ocl_Image2D_Image2D_const_UMatR_bool_bool(const cv::UMat* src, bool norm, bool alias) {
		try {
			cv::ocl::Image2D* ret = new cv::ocl::Image2D(*src, norm, alias);
			return Ok<cv::ocl::Image2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Image2D*>))
	}
	
	// Image2D(const cv::ocl::Image2D &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:751
	Result<cv::ocl::Image2D*> cv_ocl_Image2D_Image2D_const_Image2DR(const cv::ocl::Image2D* i) {
		try {
			cv::ocl::Image2D* ret = new cv::ocl::Image2D(*i);
			return Ok<cv::ocl::Image2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Image2D*>))
	}
	
	// Image2D(cv::ocl::Image2D &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:755
	cv::ocl::Image2D* cv_ocl_Image2D_Image2D_Image2DR(cv::ocl::Image2D* unnamed) {
		cv::ocl::Image2D* ret = new cv::ocl::Image2D(*unnamed);
		return (cv::ocl::Image2D*)ret;
	}
	
	// canCreateAlias(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:761
	Result<bool> cv_ocl_Image2D_canCreateAlias_const_UMatR(const cv::UMat* u) {
		try {
			bool ret = cv::ocl::Image2D::canCreateAlias(*u);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// isFormatSupported(int, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:765
	Result<bool> cv_ocl_Image2D_isFormatSupported_int_int_bool(int depth, int cn, bool norm) {
		try {
			bool ret = cv::ocl::Image2D::isFormatSupported(depth, cn, norm);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:767
	Result<void*> cv_ocl_Image2D_ptr_const(const cv::ocl::Image2D* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	void cv_Kernel_delete(cv::ocl::Kernel* instance) {
		delete instance;
	}
	// Kernel() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:459
	cv::ocl::Kernel* cv_ocl_Kernel_Kernel() {
		cv::ocl::Kernel* ret = new cv::ocl::Kernel();
		return (cv::ocl::Kernel*)ret;
	}
	
	// Kernel(const char *, const cv::ocl::Program &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:460
	Result<cv::ocl::Kernel*> cv_ocl_Kernel_Kernel_const_charX_const_ProgramR(const char* kname, const cv::ocl::Program* prog) {
		try {
			cv::ocl::Kernel* ret = new cv::ocl::Kernel(kname, *prog);
			return Ok<cv::ocl::Kernel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Kernel*>))
	}
	
	// Kernel(const char *, const cv::ocl::ProgramSource &, const cv::String &, cv::String *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:461
	Result<cv::ocl::Kernel*> cv_ocl_Kernel_Kernel_const_charX_const_ProgramSourceR_const_StringR_StringX(const char* kname, const cv::ocl::ProgramSource* prog, const char* buildopts, void** errmsg) {
		try {
			std::string errmsg_out;
			cv::ocl::Kernel* ret = new cv::ocl::Kernel(kname, *prog, std::string(buildopts), &errmsg_out);
			*errmsg = ocvrs_create_string(errmsg_out.c_str());
			return Ok<cv::ocl::Kernel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Kernel*>))
	}
	
	// Kernel(const cv::ocl::Kernel &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:464
	Result<cv::ocl::Kernel*> cv_ocl_Kernel_Kernel_const_KernelR(const cv::ocl::Kernel* k) {
		try {
			cv::ocl::Kernel* ret = new cv::ocl::Kernel(*k);
			return Ok<cv::ocl::Kernel*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Kernel*>))
	}
	
	// Kernel(cv::ocl::Kernel &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:466
	cv::ocl::Kernel* cv_ocl_Kernel_Kernel_KernelR(cv::ocl::Kernel* k) {
		cv::ocl::Kernel* ret = new cv::ocl::Kernel(*k);
		return (cv::ocl::Kernel*)ret;
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:469
	Result<bool> cv_ocl_Kernel_empty_const(const cv::ocl::Kernel* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(const char *, const cv::ocl::Program &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:470
	Result<bool> cv_ocl_Kernel_create_const_charX_const_ProgramR(cv::ocl::Kernel* instance, const char* kname, const cv::ocl::Program* prog) {
		try {
			bool ret = instance->create(kname, *prog);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// create(const char *, const cv::ocl::ProgramSource &, const cv::String &, cv::String *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:471
	Result<bool> cv_ocl_Kernel_create_const_charX_const_ProgramSourceR_const_StringR_StringX(cv::ocl::Kernel* instance, const char* kname, const cv::ocl::ProgramSource* prog, const char* buildopts, void** errmsg) {
		try {
			std::string errmsg_out;
			bool ret = instance->create(kname, *prog, std::string(buildopts), &errmsg_out);
			*errmsg = ocvrs_create_string(errmsg_out.c_str());
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// set(int, const void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:474
	Result<int> cv_ocl_Kernel_set_int_const_voidX_size_t(cv::ocl::Kernel* instance, int i, const void* value, size_t sz) {
		try {
			int ret = instance->set(i, value, sz);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// set(int, const cv::ocl::Image2D &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:475
	Result<int> cv_ocl_Kernel_set_int_const_Image2DR(cv::ocl::Kernel* instance, int i, const cv::ocl::Image2D* image2D) {
		try {
			int ret = instance->set(i, *image2D);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// set(int, const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:476
	Result<int> cv_ocl_Kernel_set_int_const_UMatR(cv::ocl::Kernel* instance, int i, const cv::UMat* m) {
		try {
			int ret = instance->set(i, *m);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// set(int, const cv::ocl::KernelArg &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:477
	Result<int> cv_ocl_Kernel_set_int_const_KernelArgR(cv::ocl::Kernel* instance, int i, const cv::ocl::KernelArg* arg) {
		try {
			int ret = instance->set(i, *arg);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// run(int, size_t *, size_t *, bool, const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:515
	Result<bool> cv_ocl_Kernel_run_int_size_tX_size_tX_bool_const_QueueR(cv::ocl::Kernel* instance, int dims, size_t* globalsize, size_t* localsize, bool sync, const cv::ocl::Queue* q) {
		try {
			bool ret = instance->run(dims, globalsize, localsize, sync, *q);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// run_(int, size_t *, size_t *, bool, const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:526
	Result<bool> cv_ocl_Kernel_run__int_size_tX_size_tX_bool_const_QueueR(cv::ocl::Kernel* instance, int dims, size_t* globalsize, size_t* localsize, bool sync, const cv::ocl::Queue* q) {
		try {
			bool ret = instance->run_(dims, globalsize, localsize, sync, *q);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// runTask(bool, const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:528
	Result<bool> cv_ocl_Kernel_runTask_bool_const_QueueR(cv::ocl::Kernel* instance, bool sync, const cv::ocl::Queue* q) {
		try {
			bool ret = instance->runTask(sync, *q);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// runProfiling(int, size_t *, size_t *, const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:535
	Result<int64_t> cv_ocl_Kernel_runProfiling_int_size_tX_size_tX_const_QueueR(cv::ocl::Kernel* instance, int dims, size_t* globalsize, size_t* localsize, const cv::ocl::Queue* q) {
		try {
			int64_t ret = instance->runProfiling(dims, globalsize, localsize, *q);
			return Ok<int64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int64_t>))
	}
	
	// workGroupSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:537
	Result<size_t> cv_ocl_Kernel_workGroupSize_const(const cv::ocl::Kernel* instance) {
		try {
			size_t ret = instance->workGroupSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// preferedWorkGroupSizeMultiple() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:538
	Result<size_t> cv_ocl_Kernel_preferedWorkGroupSizeMultiple_const(const cv::ocl::Kernel* instance) {
		try {
			size_t ret = instance->preferedWorkGroupSizeMultiple();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// compileWorkGroupSize(size_t *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:539
	Result<bool> cv_ocl_Kernel_compileWorkGroupSize_const_size_tX(const cv::ocl::Kernel* instance, size_t* wsz) {
		try {
			bool ret = instance->compileWorkGroupSize(wsz);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// localMemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:540
	Result<size_t> cv_ocl_Kernel_localMemSize_const(const cv::ocl::Kernel* instance) {
		try {
			size_t ret = instance->localMemSize();
			return Ok<size_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<size_t>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:542
	Result<void*> cv_ocl_Kernel_ptr_const(const cv::ocl::Kernel* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:448
	int cv_ocl_KernelArg_getPropFlags_const(const cv::ocl::KernelArg* instance) {
		int ret = instance->flags;
		return (int)ret;
	}
	
	// flags /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:448
	void cv_ocl_KernelArg_setPropFlags_int(cv::ocl::KernelArg* instance, int val) {
		instance->flags = val;
	}
	
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:449
	cv::UMat** cv_ocl_KernelArg_getPropM(cv::ocl::KernelArg* instance) {
		cv::UMat* ret = instance->m;
		return new cv::UMat*(ret);
	}
	
	// m /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:449
	void cv_ocl_KernelArg_setPropM_UMatX(cv::ocl::KernelArg* instance, cv::UMat* val) {
		instance->m = val;
	}
	
	// obj /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:450
	const void* cv_ocl_KernelArg_getPropObj_const(const cv::ocl::KernelArg* instance) {
		const void* ret = instance->obj;
		return (const void*)ret;
	}
	
	// sz /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:451
	size_t cv_ocl_KernelArg_getPropSz_const(const cv::ocl::KernelArg* instance) {
		size_t ret = instance->sz;
		return (size_t)ret;
	}
	
	// sz /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:451
	void cv_ocl_KernelArg_setPropSz_size_t(cv::ocl::KernelArg* instance, size_t val) {
		instance->sz = val;
	}
	
	// wscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:452
	int cv_ocl_KernelArg_getPropWscale_const(const cv::ocl::KernelArg* instance) {
		int ret = instance->wscale;
		return (int)ret;
	}
	
	// wscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:452
	void cv_ocl_KernelArg_setPropWscale_int(cv::ocl::KernelArg* instance, int val) {
		instance->wscale = val;
	}
	
	// iwscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:452
	int cv_ocl_KernelArg_getPropIwscale_const(const cv::ocl::KernelArg* instance) {
		int ret = instance->iwscale;
		return (int)ret;
	}
	
	// iwscale /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:452
	void cv_ocl_KernelArg_setPropIwscale_int(cv::ocl::KernelArg* instance, int val) {
		instance->iwscale = val;
	}
	
	void cv_KernelArg_delete(cv::ocl::KernelArg* instance) {
		delete instance;
	}
	// KernelArg(int, cv::UMat *, int, int, const void *, size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:421
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_KernelArg_int_UMatX_int_int_const_voidX_size_t(int _flags, cv::UMat* _m, int wscale, int iwscale, const void* _obj, size_t _sz) {
		try {
			cv::ocl::KernelArg* ret = new cv::ocl::KernelArg(_flags, _m, wscale, iwscale, _obj, _sz);
			return Ok<cv::ocl::KernelArg*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// KernelArg() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:422
	cv::ocl::KernelArg* cv_ocl_KernelArg_KernelArg() {
		cv::ocl::KernelArg* ret = new cv::ocl::KernelArg();
		return (cv::ocl::KernelArg*)ret;
	}
	
	// Local(size_t) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:424
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_Local_size_t(size_t localMemSize) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::Local(localMemSize);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// PtrWriteOnly(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:426
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_PtrWriteOnly_const_UMatR(const cv::UMat* m) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::PtrWriteOnly(*m);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// PtrReadOnly(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:428
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_PtrReadOnly_const_UMatR(const cv::UMat* m) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::PtrReadOnly(*m);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// PtrReadWrite(const cv::UMat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:430
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_PtrReadWrite_const_UMatR(const cv::UMat* m) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::PtrReadWrite(*m);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// ReadWrite(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:432
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_ReadWrite_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::ReadWrite(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// ReadWriteNoSize(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:434
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_ReadWriteNoSize_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::ReadWriteNoSize(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// ReadOnly(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:436
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_ReadOnly_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::ReadOnly(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// WriteOnly(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:438
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_WriteOnly_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::WriteOnly(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// ReadOnlyNoSize(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:440
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_ReadOnlyNoSize_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::ReadOnlyNoSize(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// WriteOnlyNoSize(const cv::UMat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:442
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_WriteOnlyNoSize_const_UMatR_int_int(const cv::UMat* m, int wscale, int iwscale) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::WriteOnlyNoSize(*m, wscale, iwscale);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	// Constant(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:444
	Result<cv::ocl::KernelArg*> cv_ocl_KernelArg_Constant_const_MatR(const cv::Mat* m) {
		try {
			cv::ocl::KernelArg ret = cv::ocl::KernelArg::Constant(*m);
			return Ok(new cv::ocl::KernelArg(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::KernelArg*>))
	}
	
	void cv_OpenCLExecutionContext_delete(cv::ocl::OpenCLExecutionContext* instance) {
		delete instance;
	}
	// OpenCLExecutionContext() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:798
	cv::ocl::OpenCLExecutionContext* cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext() {
		cv::ocl::OpenCLExecutionContext* ret = new cv::ocl::OpenCLExecutionContext();
		return (cv::ocl::OpenCLExecutionContext*)ret;
	}
	
	// OpenCLExecutionContext(const cv::ocl::OpenCLExecutionContext &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:801
	cv::ocl::OpenCLExecutionContext* cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_const_OpenCLExecutionContextR(const cv::ocl::OpenCLExecutionContext* unnamed) {
		cv::ocl::OpenCLExecutionContext* ret = new cv::ocl::OpenCLExecutionContext(*unnamed);
		return (cv::ocl::OpenCLExecutionContext*)ret;
	}
	
	// OpenCLExecutionContext(cv::ocl::OpenCLExecutionContext &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:802
	cv::ocl::OpenCLExecutionContext* cv_ocl_OpenCLExecutionContext_OpenCLExecutionContext_OpenCLExecutionContextR(cv::ocl::OpenCLExecutionContext* unnamed) {
		cv::ocl::OpenCLExecutionContext* ret = new cv::ocl::OpenCLExecutionContext(*unnamed);
		return (cv::ocl::OpenCLExecutionContext*)ret;
	}
	
	// getContext() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:808
	Result<cv::ocl::Context*> cv_ocl_OpenCLExecutionContext_getContext_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			cv::ocl::Context ret = instance->getContext();
			return Ok(new cv::ocl::Context(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Context*>))
	}
	
	// getDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:810
	Result<cv::ocl::Device*> cv_ocl_OpenCLExecutionContext_getDevice_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			cv::ocl::Device ret = instance->getDevice();
			return Ok(new cv::ocl::Device(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Device*>))
	}
	
	// getQueue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:814
	Result<cv::ocl::Queue*> cv_ocl_OpenCLExecutionContext_getQueue_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			cv::ocl::Queue ret = instance->getQueue();
			return Ok(new cv::ocl::Queue(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Queue*>))
	}
	
	// useOpenCL() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:816
	Result<bool> cv_ocl_OpenCLExecutionContext_useOpenCL_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			bool ret = instance->useOpenCL();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// setUseOpenCL(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:817
	Result_void cv_ocl_OpenCLExecutionContext_setUseOpenCL_bool(cv::ocl::OpenCLExecutionContext* instance, bool flag) {
		try {
			instance->setUseOpenCL(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getCurrent() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:825
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_getCurrent() {
		try {
			cv::ocl::OpenCLExecutionContext ret = cv::ocl::OpenCLExecutionContext::getCurrent();
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// getCurrentRef() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:828
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_getCurrentRef() {
		try {
			cv::ocl::OpenCLExecutionContext ret = cv::ocl::OpenCLExecutionContext::getCurrentRef();
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// bind() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:836
	Result_void cv_ocl_OpenCLExecutionContext_bind_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			instance->bind();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// cloneWithNewQueue(const ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:842
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const_const_QueueR(const cv::ocl::OpenCLExecutionContext* instance, const cv::ocl::Queue* q) {
		try {
			cv::ocl::OpenCLExecutionContext ret = instance->cloneWithNewQueue(*q);
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// cloneWithNewQueue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:844
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_cloneWithNewQueue_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			cv::ocl::OpenCLExecutionContext ret = instance->cloneWithNewQueue();
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// create(const std::string &, void *, void *, void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:860
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_create_const_stringR_voidX_voidX_voidX(const char* platformName, void* platformID, void* context, void* deviceID) {
		try {
			cv::ocl::OpenCLExecutionContext ret = cv::ocl::OpenCLExecutionContext::create(std::string(platformName), platformID, context, deviceID);
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// create(const cv::ocl::Context &, const cv::ocl::Device &, const ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:868
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR_const_QueueR(const cv::ocl::Context* context, const cv::ocl::Device* device, const cv::ocl::Queue* queue) {
		try {
			cv::ocl::OpenCLExecutionContext ret = cv::ocl::OpenCLExecutionContext::create(*context, *device, *queue);
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// create(const cv::ocl::Context &, const cv::ocl::Device &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:870
	Result<cv::ocl::OpenCLExecutionContext*> cv_ocl_OpenCLExecutionContext_create_const_ContextR_const_DeviceR(const cv::ocl::Context* context, const cv::ocl::Device* device) {
		try {
			cv::ocl::OpenCLExecutionContext ret = cv::ocl::OpenCLExecutionContext::create(*context, *device);
			return Ok(new cv::ocl::OpenCLExecutionContext(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::OpenCLExecutionContext*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:873
	Result<bool> cv_ocl_OpenCLExecutionContext_empty_const(const cv::ocl::OpenCLExecutionContext* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:874
	Result_void cv_ocl_OpenCLExecutionContext_release(cv::ocl::OpenCLExecutionContext* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	void cv_Platform_delete(cv::ocl::Platform* instance) {
		delete instance;
	}
	// Platform() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:332
	cv::ocl::Platform* cv_ocl_Platform_Platform() {
		cv::ocl::Platform* ret = new cv::ocl::Platform();
		return (cv::ocl::Platform*)ret;
	}
	
	// Platform(const cv::ocl::Platform &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:334
	Result<cv::ocl::Platform*> cv_ocl_Platform_Platform_const_PlatformR(const cv::ocl::Platform* p) {
		try {
			cv::ocl::Platform* ret = new cv::ocl::Platform(*p);
			return Ok<cv::ocl::Platform*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Platform*>))
	}
	
	// Platform(cv::ocl::Platform &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:336
	cv::ocl::Platform* cv_ocl_Platform_Platform_PlatformR(cv::ocl::Platform* p) {
		cv::ocl::Platform* ret = new cv::ocl::Platform(*p);
		return (cv::ocl::Platform*)ret;
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:339
	Result<void*> cv_ocl_Platform_ptr_const(const cv::ocl::Platform* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getDefault() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:342
	Result<cv::ocl::Platform*> cv_ocl_Platform_getDefault() {
		try {
			cv::ocl::Platform ret = cv::ocl::Platform::getDefault();
			return Ok(new cv::ocl::Platform(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Platform*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:346
	Result<bool> cv_ocl_Platform_empty_const(const cv::ocl::Platform* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_PlatformInfo_delete(cv::ocl::PlatformInfo* instance) {
		delete instance;
	}
	// PlatformInfo() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:671
	cv::ocl::PlatformInfo* cv_ocl_PlatformInfo_PlatformInfo() {
		cv::ocl::PlatformInfo* ret = new cv::ocl::PlatformInfo();
		return (cv::ocl::PlatformInfo*)ret;
	}
	
	// PlatformInfo(void *) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:675
	Result<cv::ocl::PlatformInfo*> cv_ocl_PlatformInfo_PlatformInfo_voidX(void* id) {
		try {
			cv::ocl::PlatformInfo* ret = new cv::ocl::PlatformInfo(id);
			return Ok<cv::ocl::PlatformInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::PlatformInfo*>))
	}
	
	// PlatformInfo(const cv::ocl::PlatformInfo &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:678
	Result<cv::ocl::PlatformInfo*> cv_ocl_PlatformInfo_PlatformInfo_const_PlatformInfoR(const cv::ocl::PlatformInfo* i) {
		try {
			cv::ocl::PlatformInfo* ret = new cv::ocl::PlatformInfo(*i);
			return Ok<cv::ocl::PlatformInfo*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::PlatformInfo*>))
	}
	
	// PlatformInfo(cv::ocl::PlatformInfo &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:680
	cv::ocl::PlatformInfo* cv_ocl_PlatformInfo_PlatformInfo_PlatformInfoR(cv::ocl::PlatformInfo* i) {
		cv::ocl::PlatformInfo* ret = new cv::ocl::PlatformInfo(*i);
		return (cv::ocl::PlatformInfo*)ret;
	}
	
	// name() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:683
	Result<void*> cv_ocl_PlatformInfo_name_const(const cv::ocl::PlatformInfo* instance) {
		try {
			cv::String ret = instance->name();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// vendor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:684
	Result<void*> cv_ocl_PlatformInfo_vendor_const(const cv::ocl::PlatformInfo* instance) {
		try {
			cv::String ret = instance->vendor();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// version() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:687
	Result<void*> cv_ocl_PlatformInfo_version_const(const cv::ocl::PlatformInfo* instance) {
		try {
			cv::String ret = instance->version();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// versionMajor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:688
	Result<int> cv_ocl_PlatformInfo_versionMajor_const(const cv::ocl::PlatformInfo* instance) {
		try {
			int ret = instance->versionMajor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// versionMinor() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:689
	Result<int> cv_ocl_PlatformInfo_versionMinor_const(const cv::ocl::PlatformInfo* instance) {
		try {
			int ret = instance->versionMinor();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// deviceNumber() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:691
	Result<int> cv_ocl_PlatformInfo_deviceNumber_const(const cv::ocl::PlatformInfo* instance) {
		try {
			int ret = instance->deviceNumber();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// getDevice(cv::ocl::Device &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:692
	Result_void cv_ocl_PlatformInfo_getDevice_const_DeviceR_int(const cv::ocl::PlatformInfo* instance, cv::ocl::Device* device, int d) {
		try {
			instance->getDevice(*device, d);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:695
	Result<bool> cv_ocl_PlatformInfo_empty_const(const cv::ocl::PlatformInfo* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Program_delete(cv::ocl::Program* instance) {
		delete instance;
	}
	// Program() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:552
	cv::ocl::Program* cv_ocl_Program_Program() {
		cv::ocl::Program* ret = new cv::ocl::Program();
		return (cv::ocl::Program*)ret;
	}
	
	// Program(const cv::ocl::ProgramSource &, const cv::String &, cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:553
	Result<cv::ocl::Program*> cv_ocl_Program_Program_const_ProgramSourceR_const_StringR_StringR(const cv::ocl::ProgramSource* src, const char* buildflags, void** errmsg) {
		try {
			std::string errmsg_out;
			cv::ocl::Program* ret = new cv::ocl::Program(*src, std::string(buildflags), errmsg_out);
			*errmsg = ocvrs_create_string(errmsg_out.c_str());
			return Ok<cv::ocl::Program*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Program*>))
	}
	
	// Program(const cv::ocl::Program &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:555
	Result<cv::ocl::Program*> cv_ocl_Program_Program_const_ProgramR(const cv::ocl::Program* prog) {
		try {
			cv::ocl::Program* ret = new cv::ocl::Program(*prog);
			return Ok<cv::ocl::Program*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Program*>))
	}
	
	// Program(cv::ocl::Program &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:557
	cv::ocl::Program* cv_ocl_Program_Program_ProgramR(cv::ocl::Program* prog) {
		cv::ocl::Program* ret = new cv::ocl::Program(*prog);
		return (cv::ocl::Program*)ret;
	}
	
	// create(const cv::ocl::ProgramSource &, const cv::String &, cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:561
	Result<bool> cv_ocl_Program_create_const_ProgramSourceR_const_StringR_StringR(cv::ocl::Program* instance, const cv::ocl::ProgramSource* src, const char* buildflags, void** errmsg) {
		try {
			std::string errmsg_out;
			bool ret = instance->create(*src, std::string(buildflags), errmsg_out);
			*errmsg = ocvrs_create_string(errmsg_out.c_str());
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:564
	Result<void*> cv_ocl_Program_ptr_const(const cv::ocl::Program* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getBinary(std::vector<char> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:575
	Result_void cv_ocl_Program_getBinary_const_vector_char_R(const cv::ocl::Program* instance, std::vector<char>* binary) {
		try {
			instance->getBinary(*binary);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:579
	Result<bool> cv_ocl_Program_empty_const(const cv::ocl::Program* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// read(const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:585
	Result<bool> cv_ocl_Program_read_const_StringR_const_StringR(cv::ocl::Program* instance, const char* buf, const char* buildflags) {
		try {
			bool ret = instance->read(std::string(buf), std::string(buildflags));
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// write(cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:586
	Result<bool> cv_ocl_Program_write_const_StringR(const cv::ocl::Program* instance, void** buf) {
		try {
			std::string buf_out;
			bool ret = instance->write(buf_out);
			*buf = ocvrs_create_string(buf_out.c_str());
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// source() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:587
	Result<const cv::ocl::ProgramSource*> cv_ocl_Program_source_const(const cv::ocl::Program* instance) {
		try {
			const cv::ocl::ProgramSource ret = instance->source();
			return Ok(new const cv::ocl::ProgramSource(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::ocl::ProgramSource*>))
	}
	
	// getPrefix() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:588
	Result<void*> cv_ocl_Program_getPrefix_const(const cv::ocl::Program* instance) {
		try {
			cv::String ret = instance->getPrefix();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getPrefix(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:589
	Result<void*> cv_ocl_Program_getPrefix_const_StringR(const char* buildflags) {
		try {
			cv::String ret = cv::ocl::Program::getPrefix(std::string(buildflags));
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	void cv_ProgramSource_delete(cv::ocl::ProgramSource* instance) {
		delete instance;
	}
	// ProgramSource() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:599
	cv::ocl::ProgramSource* cv_ocl_ProgramSource_ProgramSource() {
		cv::ocl::ProgramSource* ret = new cv::ocl::ProgramSource();
		return (cv::ocl::ProgramSource*)ret;
	}
	
	// ProgramSource(const cv::String &, const cv::String &, const cv::String &, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:600
	Result<cv::ocl::ProgramSource*> cv_ocl_ProgramSource_ProgramSource_const_StringR_const_StringR_const_StringR_const_StringR(const char* module, const char* name, const char* codeStr, const char* codeHash) {
		try {
			cv::ocl::ProgramSource* ret = new cv::ocl::ProgramSource(std::string(module), std::string(name), std::string(codeStr), std::string(codeHash));
			return Ok<cv::ocl::ProgramSource*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource*>))
	}
	
	// ProgramSource(const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:601
	Result<cv::ocl::ProgramSource*> cv_ocl_ProgramSource_ProgramSource_const_StringR(const char* prog) {
		try {
			cv::ocl::ProgramSource* ret = new cv::ocl::ProgramSource(std::string(prog));
			return Ok<cv::ocl::ProgramSource*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource*>))
	}
	
	// ProgramSource(const cv::ocl::ProgramSource &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:604
	Result<cv::ocl::ProgramSource*> cv_ocl_ProgramSource_ProgramSource_const_ProgramSourceR(const cv::ocl::ProgramSource* prog) {
		try {
			cv::ocl::ProgramSource* ret = new cv::ocl::ProgramSource(*prog);
			return Ok<cv::ocl::ProgramSource*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource*>))
	}
	
	// ProgramSource(cv::ocl::ProgramSource &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:606
	cv::ocl::ProgramSource* cv_ocl_ProgramSource_ProgramSource_ProgramSourceR(cv::ocl::ProgramSource* prog) {
		cv::ocl::ProgramSource* ret = new cv::ocl::ProgramSource(*prog);
		return (cv::ocl::ProgramSource*)ret;
	}
	
	// source() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:609
	Result<void*> cv_ocl_ProgramSource_source_const(const cv::ocl::ProgramSource* instance) {
		try {
			const cv::String ret = instance->source();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// hash() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:610
	Result<cv::ocl::ProgramSource::hash_t> cv_ocl_ProgramSource_hash_const(const cv::ocl::ProgramSource* instance) {
		try {
			cv::ocl::ProgramSource::hash_t ret = instance->hash();
			return Ok<cv::ocl::ProgramSource::hash_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource::hash_t>))
	}
	
	// fromBinary(const cv::String &, const cv::String &, const unsigned char *, const size_t, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:627
	Result<cv::ocl::ProgramSource*> cv_ocl_ProgramSource_fromBinary_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(const char* module, const char* name, const unsigned char* binary, const size_t size, const char* buildOptions) {
		try {
			cv::ocl::ProgramSource ret = cv::ocl::ProgramSource::fromBinary(std::string(module), std::string(name), binary, size, std::string(buildOptions));
			return Ok(new cv::ocl::ProgramSource(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource*>))
	}
	
	// fromSPIR(const cv::String &, const cv::String &, const unsigned char *, const size_t, const cv::String &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:652
	Result<cv::ocl::ProgramSource*> cv_ocl_ProgramSource_fromSPIR_const_StringR_const_StringR_const_unsigned_charX_const_size_t_const_StringR(const char* module, const char* name, const unsigned char* binary, const size_t size, const char* buildOptions) {
		try {
			cv::ocl::ProgramSource ret = cv::ocl::ProgramSource::fromSPIR(std::string(module), std::string(name), binary, size, std::string(buildOptions));
			return Ok(new cv::ocl::ProgramSource(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::ProgramSource*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:663
	Result<bool> cv_ocl_ProgramSource_empty_const(const cv::ocl::ProgramSource* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Queue_delete(cv::ocl::Queue* instance) {
		delete instance;
	}
	// Queue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:393
	cv::ocl::Queue* cv_ocl_Queue_Queue() {
		cv::ocl::Queue* ret = new cv::ocl::Queue();
		return (cv::ocl::Queue*)ret;
	}
	
	// Queue(const cv::ocl::Context &, const cv::ocl::Device &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:394
	Result<cv::ocl::Queue*> cv_ocl_Queue_Queue_const_ContextR_const_DeviceR(const cv::ocl::Context* c, const cv::ocl::Device* d) {
		try {
			cv::ocl::Queue* ret = new cv::ocl::Queue(*c, *d);
			return Ok<cv::ocl::Queue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Queue*>))
	}
	
	// Queue(const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:396
	Result<cv::ocl::Queue*> cv_ocl_Queue_Queue_const_QueueR(const cv::ocl::Queue* q) {
		try {
			cv::ocl::Queue* ret = new cv::ocl::Queue(*q);
			return Ok<cv::ocl::Queue*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Queue*>))
	}
	
	// Queue(cv::ocl::Queue &&) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:398
	cv::ocl::Queue* cv_ocl_Queue_Queue_QueueR(cv::ocl::Queue* q) {
		cv::ocl::Queue* ret = new cv::ocl::Queue(*q);
		return (cv::ocl::Queue*)ret;
	}
	
	// create(const cv::ocl::Context &, const cv::ocl::Device &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:401
	Result<bool> cv_ocl_Queue_create_const_ContextR_const_DeviceR(cv::ocl::Queue* instance, const cv::ocl::Context* c, const cv::ocl::Device* d) {
		try {
			bool ret = instance->create(*c, *d);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// finish() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:402
	Result_void cv_ocl_Queue_finish(cv::ocl::Queue* instance) {
		try {
			instance->finish();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// ptr() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:403
	Result<void*> cv_ocl_Queue_ptr_const(const cv::ocl::Queue* instance) {
		try {
			void* ret = instance->ptr();
			return Ok<void*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// getDefault() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:404
	Result<cv::ocl::Queue*> cv_ocl_Queue_getDefault() {
		try {
			cv::ocl::Queue ret = cv::ocl::Queue::getDefault();
			return Ok(new cv::ocl::Queue(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Queue*>))
	}
	
	// getProfilingQueue() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:407
	Result<const cv::ocl::Queue*> cv_ocl_Queue_getProfilingQueue_const(const cv::ocl::Queue* instance) {
		try {
			const cv::ocl::Queue ret = instance->getProfilingQueue();
			return Ok(new const cv::ocl::Queue(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::ocl::Queue*>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:411
	Result<bool> cv_ocl_Queue_empty_const(const cv::ocl::Queue* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Timer_delete(cv::ocl::Timer* instance) {
		delete instance;
	}
	// Timer(const cv::ocl::Queue &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:776
	Result<cv::ocl::Timer*> cv_ocl_Timer_Timer_const_QueueR(const cv::ocl::Queue* q) {
		try {
			cv::ocl::Timer* ret = new cv::ocl::Timer(*q);
			return Ok<cv::ocl::Timer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ocl::Timer*>))
	}
	
	// start() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:778
	Result_void cv_ocl_Timer_start(cv::ocl::Timer* instance) {
		try {
			instance->start();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// stop() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:779
	Result_void cv_ocl_Timer_stop(cv::ocl::Timer* instance) {
		try {
			instance->stop();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// durationNS() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/ocl.hpp:781
	Result<uint64_t> cv_ocl_Timer_durationNS_const(const cv::ocl::Timer* instance) {
		try {
			uint64_t ret = instance->durationNS();
			return Ok<uint64_t>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<uint64_t>))
	}
	
	void cv_Arrays_delete(cv::ogl::Arrays* instance) {
		delete instance;
	}
	// Arrays() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:411
	Result<cv::ogl::Arrays*> cv_ogl_Arrays_Arrays() {
		try {
			cv::ogl::Arrays* ret = new cv::ogl::Arrays();
			return Ok<cv::ogl::Arrays*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Arrays*>))
	}
	
	// setVertexArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:416
	Result_void cv_ogl_Arrays_setVertexArray_const__InputArrayR(cv::ogl::Arrays* instance, const cv::_InputArray* vertex) {
		try {
			instance->setVertexArray(*vertex);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetVertexArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:420
	Result_void cv_ogl_Arrays_resetVertexArray(cv::ogl::Arrays* instance) {
		try {
			instance->resetVertexArray();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setColorArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:425
	Result_void cv_ogl_Arrays_setColorArray_const__InputArrayR(cv::ogl::Arrays* instance, const cv::_InputArray* color) {
		try {
			instance->setColorArray(*color);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetColorArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:429
	Result_void cv_ogl_Arrays_resetColorArray(cv::ogl::Arrays* instance) {
		try {
			instance->resetColorArray();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setNormalArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:434
	Result_void cv_ogl_Arrays_setNormalArray_const__InputArrayR(cv::ogl::Arrays* instance, const cv::_InputArray* normal) {
		try {
			instance->setNormalArray(*normal);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetNormalArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:438
	Result_void cv_ogl_Arrays_resetNormalArray(cv::ogl::Arrays* instance) {
		try {
			instance->resetNormalArray();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setTexCoordArray(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:443
	Result_void cv_ogl_Arrays_setTexCoordArray_const__InputArrayR(cv::ogl::Arrays* instance, const cv::_InputArray* texCoord) {
		try {
			instance->setTexCoordArray(*texCoord);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// resetTexCoordArray() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:447
	Result_void cv_ogl_Arrays_resetTexCoordArray(cv::ogl::Arrays* instance) {
		try {
			instance->resetTexCoordArray();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:451
	Result_void cv_ogl_Arrays_release(cv::ogl::Arrays* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setAutoRelease(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:456
	Result_void cv_ogl_Arrays_setAutoRelease_bool(cv::ogl::Arrays* instance, bool flag) {
		try {
			instance->setAutoRelease(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bind() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:460
	Result_void cv_ogl_Arrays_bind_const(const cv::ogl::Arrays* instance) {
		try {
			instance->bind();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:464
	Result<int> cv_ogl_Arrays_size_const(const cv::ogl::Arrays* instance) {
		try {
			int ret = instance->size();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:465
	Result<bool> cv_ogl_Arrays_empty_const(const cv::ogl::Arrays* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	void cv_Buffer_delete(cv::ogl::Buffer* instance) {
		delete instance;
	}
	// Buffer() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:104
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer() {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer();
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// Buffer(int, int, int, unsigned int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:113
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer_int_int_int_unsigned_int_bool(int arows, int acols, int atype, unsigned int abufId, bool autoRelease) {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer(arows, acols, atype, abufId, autoRelease);
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// Buffer(cv::Size, int, unsigned int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:121
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer_Size_int_unsigned_int_bool(cv::Size* asize, int atype, unsigned int abufId, bool autoRelease) {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer(*asize, atype, abufId, autoRelease);
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// Buffer(int, int, int, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:130
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer_int_int_int_Target_bool(int arows, int acols, int atype, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer(arows, acols, atype, target, autoRelease);
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// Buffer(cv::Size, int, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:138
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer_Size_int_Target_bool(cv::Size* asize, int atype, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer(*asize, atype, target, autoRelease);
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// Buffer(cv::InputArray, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:145
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_Buffer_const__InputArrayR_Target_bool(const cv::_InputArray* arr, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			cv::ogl::Buffer* ret = new cv::ogl::Buffer(*arr, target, autoRelease);
			return Ok<cv::ogl::Buffer*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// create(int, int, int, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:155
	Result_void cv_ogl_Buffer_create_int_int_int_Target_bool(cv::ogl::Buffer* instance, int arows, int acols, int atype, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			instance->create(arows, acols, atype, target, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, int, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:163
	Result_void cv_ogl_Buffer_create_Size_int_Target_bool(cv::ogl::Buffer* instance, cv::Size* asize, int atype, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			instance->create(*asize, atype, target, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:169
	Result_void cv_ogl_Buffer_release(cv::ogl::Buffer* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setAutoRelease(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:180
	Result_void cv_ogl_Buffer_setAutoRelease_bool(cv::ogl::Buffer* instance, bool flag) {
		try {
			instance->setAutoRelease(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyFrom(cv::InputArray, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:187
	Result_void cv_ogl_Buffer_copyFrom_const__InputArrayR_Target_bool(cv::ogl::Buffer* instance, const cv::_InputArray* arr, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			instance->copyFrom(*arr, target, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyFrom(cv::InputArray, cuda::Stream &, cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:190
	Result_void cv_ogl_Buffer_copyFrom_const__InputArrayR_StreamR_Target_bool(cv::ogl::Buffer* instance, const cv::_InputArray* arr, cv::cuda::Stream* stream, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			instance->copyFrom(*arr, *stream, target, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:197
	Result_void cv_ogl_Buffer_copyTo_const_const__OutputArrayR(const cv::ogl::Buffer* instance, const cv::_OutputArray* arr) {
		try {
			instance->copyTo(*arr);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:200
	Result_void cv_ogl_Buffer_copyTo_const_const__OutputArrayR_StreamR(const cv::ogl::Buffer* instance, const cv::_OutputArray* arr, cv::cuda::Stream* stream) {
		try {
			instance->copyTo(*arr, *stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clone(cv::ogl::Buffer::Target, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:207
	Result<cv::ogl::Buffer*> cv_ogl_Buffer_clone_const_Target_bool(const cv::ogl::Buffer* instance, cv::ogl::Buffer::Target target, bool autoRelease) {
		try {
			cv::ogl::Buffer ret = instance->clone(target, autoRelease);
			return Ok(new cv::ogl::Buffer(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Buffer*>))
	}
	
	// bind(cv::ogl::Buffer::Target) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:213
	Result_void cv_ogl_Buffer_bind_const_Target(const cv::ogl::Buffer* instance, cv::ogl::Buffer::Target target) {
		try {
			instance->bind(target);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// unbind(cv::ogl::Buffer::Target) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:219
	Result_void cv_ogl_Buffer_unbind_Target(cv::ogl::Buffer::Target target) {
		try {
			cv::ogl::Buffer::unbind(target);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapHost(cv::ogl::Buffer::Access) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:236
	Result<cv::Mat*> cv_ogl_Buffer_mapHost_Access(cv::ogl::Buffer* instance, cv::ogl::Buffer::Access access) {
		try {
			cv::Mat ret = instance->mapHost(access);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// unmapHost() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:240
	Result_void cv_ogl_Buffer_unmapHost(cv::ogl::Buffer* instance) {
		try {
			instance->unmapHost();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:243
	Result<cv::cuda::GpuMat*> cv_ogl_Buffer_mapDevice(cv::ogl::Buffer* instance) {
		try {
			cv::cuda::GpuMat ret = instance->mapDevice();
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// unmapDevice() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:244
	Result_void cv_ogl_Buffer_unmapDevice(cv::ogl::Buffer* instance) {
		try {
			instance->unmapDevice();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// mapDevice(cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:252
	Result<cv::cuda::GpuMat*> cv_ogl_Buffer_mapDevice_StreamR(cv::ogl::Buffer* instance, cv::cuda::Stream* stream) {
		try {
			cv::cuda::GpuMat ret = instance->mapDevice(*stream);
			return Ok(new cv::cuda::GpuMat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::cuda::GpuMat*>))
	}
	
	// unmapDevice(cuda::Stream &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:256
	Result_void cv_ogl_Buffer_unmapDevice_StreamR(cv::ogl::Buffer* instance, cv::cuda::Stream* stream) {
		try {
			instance->unmapDevice(*stream);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:258
	Result<int> cv_ogl_Buffer_rows_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->rows();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// cols() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:259
	Result<int> cv_ogl_Buffer_cols_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->cols();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:260
	Result<cv::Size> cv_ogl_Buffer_size_const(const cv::ogl::Buffer* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:261
	Result<bool> cv_ogl_Buffer_empty_const(const cv::ogl::Buffer* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// type() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:263
	Result<int> cv_ogl_Buffer_type_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->type();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// depth() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:264
	Result<int> cv_ogl_Buffer_depth_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->depth();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// channels() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:265
	Result<int> cv_ogl_Buffer_channels_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->channels();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// elemSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:266
	Result<int> cv_ogl_Buffer_elemSize_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->elemSize();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// elemSize1() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:267
	Result<int> cv_ogl_Buffer_elemSize1_const(const cv::ogl::Buffer* instance) {
		try {
			int ret = instance->elemSize1();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// bufId() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:270
	Result<unsigned int> cv_ogl_Buffer_bufId_const(const cv::ogl::Buffer* instance) {
		try {
			unsigned int ret = instance->bufId();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	void cv_Texture2D_delete(cv::ogl::Texture2D* instance) {
		delete instance;
	}
	// Texture2D() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:301
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D() {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D();
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// Texture2D(int, int, cv::ogl::Texture2D::Format, unsigned int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:304
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D_int_int_Format_unsigned_int_bool(int arows, int acols, cv::ogl::Texture2D::Format aformat, unsigned int atexId, bool autoRelease) {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D(arows, acols, aformat, atexId, autoRelease);
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// Texture2D(cv::Size, cv::ogl::Texture2D::Format, unsigned int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:307
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D_Size_Format_unsigned_int_bool(cv::Size* asize, cv::ogl::Texture2D::Format aformat, unsigned int atexId, bool autoRelease) {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D(*asize, aformat, atexId, autoRelease);
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// Texture2D(int, int, cv::ogl::Texture2D::Format, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:315
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D_int_int_Format_bool(int arows, int acols, cv::ogl::Texture2D::Format aformat, bool autoRelease) {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D(arows, acols, aformat, autoRelease);
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// Texture2D(cv::Size, cv::ogl::Texture2D::Format, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:322
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D_Size_Format_bool(cv::Size* asize, cv::ogl::Texture2D::Format aformat, bool autoRelease) {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D(*asize, aformat, autoRelease);
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// Texture2D(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:328
	Result<cv::ogl::Texture2D*> cv_ogl_Texture2D_Texture2D_const__InputArrayR_bool(const cv::_InputArray* arr, bool autoRelease) {
		try {
			cv::ogl::Texture2D* ret = new cv::ogl::Texture2D(*arr, autoRelease);
			return Ok<cv::ogl::Texture2D*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D*>))
	}
	
	// create(int, int, cv::ogl::Texture2D::Format, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:337
	Result_void cv_ogl_Texture2D_create_int_int_Format_bool(cv::ogl::Texture2D* instance, int arows, int acols, cv::ogl::Texture2D::Format aformat, bool autoRelease) {
		try {
			instance->create(arows, acols, aformat, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size, cv::ogl::Texture2D::Format, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:343
	Result_void cv_ogl_Texture2D_create_Size_Format_bool(cv::ogl::Texture2D* instance, cv::Size* asize, cv::ogl::Texture2D::Format aformat, bool autoRelease) {
		try {
			instance->create(*asize, aformat, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// release() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:349
	Result_void cv_ogl_Texture2D_release(cv::ogl::Texture2D* instance) {
		try {
			instance->release();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setAutoRelease(bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:361
	Result_void cv_ogl_Texture2D_setAutoRelease_bool(cv::ogl::Texture2D* instance, bool flag) {
		try {
			instance->setAutoRelease(flag);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyFrom(cv::InputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:368
	Result_void cv_ogl_Texture2D_copyFrom_const__InputArrayR_bool(cv::ogl::Texture2D* instance, const cv::_InputArray* arr, bool autoRelease) {
		try {
			instance->copyFrom(*arr, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// copyTo(cv::OutputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:377
	Result_void cv_ogl_Texture2D_copyTo_const_const__OutputArrayR_int_bool(const cv::ogl::Texture2D* instance, const cv::_OutputArray* arr, int ddepth, bool autoRelease) {
		try {
			instance->copyTo(*arr, ddepth, autoRelease);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// bind() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:381
	Result_void cv_ogl_Texture2D_bind_const(const cv::ogl::Texture2D* instance) {
		try {
			instance->bind();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// rows() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:383
	Result<int> cv_ogl_Texture2D_rows_const(const cv::ogl::Texture2D* instance) {
		try {
			int ret = instance->rows();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// cols() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:384
	Result<int> cv_ogl_Texture2D_cols_const(const cv::ogl::Texture2D* instance) {
		try {
			int ret = instance->cols();
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// size() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:385
	Result<cv::Size> cv_ogl_Texture2D_size_const(const cv::ogl::Texture2D* instance) {
		try {
			cv::Size ret = instance->size();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// empty() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:386
	Result<bool> cv_ogl_Texture2D_empty_const(const cv::ogl::Texture2D* instance) {
		try {
			bool ret = instance->empty();
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// format() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:388
	Result<cv::ogl::Texture2D::Format> cv_ogl_Texture2D_format_const(const cv::ogl::Texture2D* instance) {
		try {
			cv::ogl::Texture2D::Format ret = instance->format();
			return Ok<cv::ogl::Texture2D::Format>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::ogl::Texture2D::Format>))
	}
	
	// texId() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/opengl.hpp:391
	Result<unsigned int> cv_ogl_Texture2D_texId_const(const cv::ogl::Texture2D* instance) {
		try {
			unsigned int ret = instance->texId();
			return Ok<unsigned int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<unsigned int>))
	}
	
	// name /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logtag.hpp:17
	void* cv_utils_logging_LogTag_getPropName_const(const cv::utils::logging::LogTag* instance) {
		const char* ret = instance->name;
		return ocvrs_create_string(ret);
	}
	
	// level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logtag.hpp:18
	cv::utils::logging::LogLevel cv_utils_logging_LogTag_getPropLevel_const(const cv::utils::logging::LogTag* instance) {
		cv::utils::logging::LogLevel ret = instance->level;
		return (cv::utils::logging::LogLevel)ret;
	}
	
	// level /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logtag.hpp:18
	void cv_utils_logging_LogTag_setPropLevel_LogLevel(cv::utils::logging::LogTag* instance, cv::utils::logging::LogLevel val) {
		instance->level = val;
	}
	
	void cv_LogTag_delete(cv::utils::logging::LogTag* instance) {
		delete instance;
	}
	// LogTag(const char *, cv::utils::logging::LogLevel) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/core/utils/logtag.hpp:20
	Result<cv::utils::logging::LogTag*> cv_utils_logging_LogTag_LogTag_const_charX_LogLevel(const char* _name, cv::utils::logging::LogLevel _level) {
		try {
			cv::utils::logging::LogTag* ret = new cv::utils::logging::LogTag(_name, _level);
			return Ok<cv::utils::logging::LogTag*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::utils::logging::LogTag*>))
	}
	
}
