#include "bioinspired.hpp"
#include "bioinspired_types.hpp"

extern "C" {
	// getInputSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:215
	Result<cv::Size> cv_bioinspired_Retina_getInputSize(cv::bioinspired::Retina* instance) {
		try {
			cv::Size ret = instance->getInputSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getOutputSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:221
	Result<cv::Size> cv_bioinspired_Retina_getOutputSize(cv::bioinspired::Retina* instance) {
		try {
			cv::Size ret = instance->getOutputSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setup(cv::String, const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:233
	Result_void cv_bioinspired_Retina_setup_String_const_bool(cv::bioinspired::Retina* instance, char* retinaParameterFile, const bool applyDefaultSetupOnFailure) {
		try {
			instance->setup(std::string(retinaParameterFile), applyDefaultSetupOnFailure);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setup(cv::FileStorage &, const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:239
	Result_void cv_bioinspired_Retina_setup_FileStorageR_const_bool(cv::bioinspired::Retina* instance, cv::FileStorage* fs, const bool applyDefaultSetupOnFailure) {
		try {
			instance->setup(*fs, applyDefaultSetupOnFailure);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setup(cv::bioinspired::RetinaParameters) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:244
	Result_void cv_bioinspired_Retina_setup_RetinaParameters(cv::bioinspired::Retina* instance, cv::bioinspired::RetinaParameters* newParameters) {
		try {
			instance->setup(*newParameters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:249
	Result<cv::bioinspired::RetinaParameters*> cv_bioinspired_Retina_getParameters(cv::bioinspired::Retina* instance) {
		try {
			cv::bioinspired::RetinaParameters ret = instance->getParameters();
			return Ok(new cv::bioinspired::RetinaParameters(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::bioinspired::RetinaParameters*>))
	}
	
	// printSetup() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:254
	Result<void*> cv_bioinspired_Retina_printSetup(cv::bioinspired::Retina* instance) {
		try {
			const cv::String ret = instance->printSetup();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// write(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:260
	Result_void cv_bioinspired_Retina_write_const_String(const cv::bioinspired::Retina* instance, char* fs) {
		try {
			instance->write(std::string(fs));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:263
	Result_void cv_bioinspired_Retina_write_const_FileStorageR(const cv::bioinspired::Retina* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setupOPLandIPLParvoChannel(const bool, const bool, const float, const float, const float, const float, const float, const float, const float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:299
	Result_void cv_bioinspired_Retina_setupOPLandIPLParvoChannel_const_bool_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(cv::bioinspired::Retina* instance, const bool colorMode, const bool normaliseOutput, const float photoreceptorsLocalAdaptationSensitivity, const float photoreceptorsTemporalConstant, const float photoreceptorsSpatialConstant, const float horizontalCellsGain, const float HcellsTemporalConstant, const float HcellsSpatialConstant, const float ganglionCellsSensitivity) {
		try {
			instance->setupOPLandIPLParvoChannel(colorMode, normaliseOutput, photoreceptorsLocalAdaptationSensitivity, photoreceptorsTemporalConstant, photoreceptorsSpatialConstant, horizontalCellsGain, HcellsTemporalConstant, HcellsSpatialConstant, ganglionCellsSensitivity);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setupIPLMagnoChannel(const bool, const float, const float, const float, const float, const float, const float, const float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:326
	Result_void cv_bioinspired_Retina_setupIPLMagnoChannel_const_bool_const_float_const_float_const_float_const_float_const_float_const_float_const_float(cv::bioinspired::Retina* instance, const bool normaliseOutput, const float parasolCells_beta, const float parasolCells_tau, const float parasolCells_k, const float amacrinCellsTemporalCutFrequency, const float V0CompressionParameter, const float localAdaptintegration_tau, const float localAdaptintegration_k) {
		try {
			instance->setupIPLMagnoChannel(normaliseOutput, parasolCells_beta, parasolCells_tau, parasolCells_k, amacrinCellsTemporalCutFrequency, V0CompressionParameter, localAdaptintegration_tau, localAdaptintegration_k);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:335
	Result_void cv_bioinspired_Retina_run_const__InputArrayR(cv::bioinspired::Retina* instance, const cv::_InputArray* inputImage) {
		try {
			instance->run(*inputImage);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// applyFastToneMapping(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:353
	Result_void cv_bioinspired_Retina_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(cv::bioinspired::Retina* instance, const cv::_InputArray* inputImage, const cv::_OutputArray* outputToneMappedImage) {
		try {
			instance->applyFastToneMapping(*inputImage, *outputToneMappedImage);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getParvo(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:367
	Result_void cv_bioinspired_Retina_getParvo_const__OutputArrayR(cv::bioinspired::Retina* instance, const cv::_OutputArray* retinaOutput_parvo) {
		try {
			instance->getParvo(*retinaOutput_parvo);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getParvoRAW(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:372
	Result_void cv_bioinspired_Retina_getParvoRAW_const__OutputArrayR(cv::bioinspired::Retina* instance, const cv::_OutputArray* retinaOutput_parvo) {
		try {
			instance->getParvoRAW(*retinaOutput_parvo);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMagno(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:384
	Result_void cv_bioinspired_Retina_getMagno_const__OutputArrayR(cv::bioinspired::Retina* instance, const cv::_OutputArray* retinaOutput_magno) {
		try {
			instance->getMagno(*retinaOutput_magno);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMagnoRAW(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:389
	Result_void cv_bioinspired_Retina_getMagnoRAW_const__OutputArrayR(cv::bioinspired::Retina* instance, const cv::_OutputArray* retinaOutput_magno) {
		try {
			instance->getMagnoRAW(*retinaOutput_magno);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getMagnoRAW() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:392
	Result<const cv::Mat*> cv_bioinspired_Retina_getMagnoRAW_const(const cv::bioinspired::Retina* instance) {
		try {
			const cv::Mat ret = instance->getMagnoRAW();
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// getParvoRAW() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:394
	Result<const cv::Mat*> cv_bioinspired_Retina_getParvoRAW_const(const cv::bioinspired::Retina* instance) {
		try {
			const cv::Mat ret = instance->getParvoRAW();
			return Ok(new const cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<const cv::Mat*>))
	}
	
	// setColorSaturation(const bool, const float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:402
	Result_void cv_bioinspired_Retina_setColorSaturation_const_bool_const_float(cv::bioinspired::Retina* instance, const bool saturateColors, const float colorSaturationValue) {
		try {
			instance->setColorSaturation(saturateColors, colorSaturationValue);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearBuffers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:409
	Result_void cv_bioinspired_Retina_clearBuffers(cv::bioinspired::Retina* instance) {
		try {
			instance->clearBuffers();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// activateMovingContoursProcessing(const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:416
	Result_void cv_bioinspired_Retina_activateMovingContoursProcessing_const_bool(cv::bioinspired::Retina* instance, const bool activate) {
		try {
			instance->activateMovingContoursProcessing(activate);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// activateContoursProcessing(const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:424
	Result_void cv_bioinspired_Retina_activateContoursProcessing_const_bool(cv::bioinspired::Retina* instance, const bool activate) {
		try {
			instance->activateContoursProcessing(activate);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:427
	Result<cv::Ptr<cv::bioinspired::Retina>*> cv_bioinspired_Retina_create_Size(cv::Size* inputSize) {
		try {
			cv::Ptr<cv::bioinspired::Retina> ret = cv::bioinspired::Retina::create(*inputSize);
			return Ok(new cv::Ptr<cv::bioinspired::Retina>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::bioinspired::Retina>*>))
	}
	
	// create(cv::Size, const bool, int, const bool, const float, const float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:444
	Result<cv::Ptr<cv::bioinspired::Retina>*> cv_bioinspired_Retina_create_Size_const_bool_int_const_bool_const_float_const_float(cv::Size* inputSize, const bool colorMode, int colorSamplingMethod, const bool useRetinaLogSampling, const float reductionFactor, const float samplingStrength) {
		try {
			cv::Ptr<cv::bioinspired::Retina> ret = cv::bioinspired::Retina::create(*inputSize, colorMode, colorSamplingMethod, useRetinaLogSampling, reductionFactor, samplingStrength);
			return Ok(new cv::Ptr<cv::bioinspired::Retina>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::bioinspired::Retina>*>))
	}
	
	// applyFastToneMapping(cv::InputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retinafasttonemapping.hpp:119
	Result_void cv_bioinspired_RetinaFastToneMapping_applyFastToneMapping_const__InputArrayR_const__OutputArrayR(cv::bioinspired::RetinaFastToneMapping* instance, const cv::_InputArray* inputImage, const cv::_OutputArray* outputToneMappedImage) {
		try {
			instance->applyFastToneMapping(*inputImage, *outputToneMappedImage);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setup(const float, const float, const float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retinafasttonemapping.hpp:128
	Result_void cv_bioinspired_RetinaFastToneMapping_setup_const_float_const_float_const_float(cv::bioinspired::RetinaFastToneMapping* instance, const float photoreceptorsNeighborhoodRadius, const float ganglioncellsNeighborhoodRadius, const float meanLuminanceModulatorK) {
		try {
			instance->setup(photoreceptorsNeighborhoodRadius, ganglioncellsNeighborhoodRadius, meanLuminanceModulatorK);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retinafasttonemapping.hpp:130
	Result<cv::Ptr<cv::bioinspired::RetinaFastToneMapping>*> cv_bioinspired_RetinaFastToneMapping_create_Size(cv::Size* inputSize) {
		try {
			cv::Ptr<cv::bioinspired::RetinaFastToneMapping> ret = cv::bioinspired::RetinaFastToneMapping::create(*inputSize);
			return Ok(new cv::Ptr<cv::bioinspired::RetinaFastToneMapping>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::bioinspired::RetinaFastToneMapping>*>))
	}
	
	// OPLandIplParvo /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:178
	cv::bioinspired::RetinaParameters::OPLandIplParvoParameters cv_bioinspired_RetinaParameters_getPropOPLandIplParvo_const(const cv::bioinspired::RetinaParameters* instance) {
		cv::bioinspired::RetinaParameters::OPLandIplParvoParameters ret = instance->OPLandIplParvo;
		return (cv::bioinspired::RetinaParameters::OPLandIplParvoParameters)ret;
	}
	
	// OPLandIplParvo /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:178
	void cv_bioinspired_RetinaParameters_setPropOPLandIplParvo_OPLandIplParvoParameters(cv::bioinspired::RetinaParameters* instance, cv::bioinspired::RetinaParameters::OPLandIplParvoParameters* val) {
		instance->OPLandIplParvo = *val;
	}
	
	// IplMagno /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:179
	cv::bioinspired::RetinaParameters::IplMagnoParameters cv_bioinspired_RetinaParameters_getPropIplMagno_const(const cv::bioinspired::RetinaParameters* instance) {
		cv::bioinspired::RetinaParameters::IplMagnoParameters ret = instance->IplMagno;
		return (cv::bioinspired::RetinaParameters::IplMagnoParameters)ret;
	}
	
	// IplMagno /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:179
	void cv_bioinspired_RetinaParameters_setPropIplMagno_IplMagnoParameters(cv::bioinspired::RetinaParameters* instance, cv::bioinspired::RetinaParameters::IplMagnoParameters* val) {
		instance->IplMagno = *val;
	}
	
	void cv_RetinaParameters_delete(cv::bioinspired::RetinaParameters* instance) {
		delete instance;
	}
	// IplMagnoParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:166
	Result<cv::bioinspired::RetinaParameters::IplMagnoParameters> cv_bioinspired_RetinaParameters_IplMagnoParameters_IplMagnoParameters() {
		try {
			cv::bioinspired::RetinaParameters::IplMagnoParameters ret;
			return Ok<cv::bioinspired::RetinaParameters::IplMagnoParameters>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::bioinspired::RetinaParameters::IplMagnoParameters>))
	}
	
	// OPLandIplParvoParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/retina.hpp:152
	Result<cv::bioinspired::RetinaParameters::OPLandIplParvoParameters> cv_bioinspired_RetinaParameters_OPLandIplParvoParameters_OPLandIplParvoParameters() {
		try {
			cv::bioinspired::RetinaParameters::OPLandIplParvoParameters ret;
			return Ok<cv::bioinspired::RetinaParameters::OPLandIplParvoParameters>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::bioinspired::RetinaParameters::OPLandIplParvoParameters>))
	}
	
	// SegmentationParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:84
	Result<cv::bioinspired::SegmentationParameters> cv_bioinspired_SegmentationParameters_SegmentationParameters() {
		try {
			cv::bioinspired::SegmentationParameters ret;
			return Ok<cv::bioinspired::SegmentationParameters>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::bioinspired::SegmentationParameters>))
	}
	
	// getSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:129
	Result<cv::Size> cv_bioinspired_TransientAreasSegmentationModule_getSize(cv::bioinspired::TransientAreasSegmentationModule* instance) {
		try {
			cv::Size ret = instance->getSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// setup(cv::String, const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:138
	Result_void cv_bioinspired_TransientAreasSegmentationModule_setup_String_const_bool(cv::bioinspired::TransientAreasSegmentationModule* instance, char* segmentationParameterFile, const bool applyDefaultSetupOnFailure) {
		try {
			instance->setup(std::string(segmentationParameterFile), applyDefaultSetupOnFailure);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setup(cv::FileStorage &, const bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:147
	Result_void cv_bioinspired_TransientAreasSegmentationModule_setup_FileStorageR_const_bool(cv::bioinspired::TransientAreasSegmentationModule* instance, cv::FileStorage* fs, const bool applyDefaultSetupOnFailure) {
		try {
			instance->setup(*fs, applyDefaultSetupOnFailure);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// setup(cv::bioinspired::SegmentationParameters) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:155
	Result_void cv_bioinspired_TransientAreasSegmentationModule_setup_SegmentationParameters(cv::bioinspired::TransientAreasSegmentationModule* instance, cv::bioinspired::SegmentationParameters* newParameters) {
		try {
			instance->setup(*newParameters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:159
	Result<cv::bioinspired::SegmentationParameters> cv_bioinspired_TransientAreasSegmentationModule_getParameters(cv::bioinspired::TransientAreasSegmentationModule* instance) {
		try {
			cv::bioinspired::SegmentationParameters ret = instance->getParameters();
			return Ok<cv::bioinspired::SegmentationParameters>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::bioinspired::SegmentationParameters>))
	}
	
	// printSetup() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:164
	Result<void*> cv_bioinspired_TransientAreasSegmentationModule_printSetup(cv::bioinspired::TransientAreasSegmentationModule* instance) {
		try {
			const cv::String ret = instance->printSetup();
			return Ok(ocvrs_create_string(ret.c_str()));
		} OCVRS_CATCH(OCVRS_TYPE(Result<void*>))
	}
	
	// write(cv::String) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:169
	Result_void cv_bioinspired_TransientAreasSegmentationModule_write_const_String(const cv::bioinspired::TransientAreasSegmentationModule* instance, char* fs) {
		try {
			instance->write(std::string(fs));
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// write(cv::FileStorage &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:174
	Result_void cv_bioinspired_TransientAreasSegmentationModule_write_const_FileStorageR(const cv::bioinspired::TransientAreasSegmentationModule* instance, cv::FileStorage* fs) {
		try {
			instance->write(*fs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// run(cv::InputArray, const int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:180
	Result_void cv_bioinspired_TransientAreasSegmentationModule_run_const__InputArrayR_const_int(cv::bioinspired::TransientAreasSegmentationModule* instance, const cv::_InputArray* inputToSegment, const int channelIndex) {
		try {
			instance->run(*inputToSegment, channelIndex);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getSegmentationPicture(cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:185
	Result_void cv_bioinspired_TransientAreasSegmentationModule_getSegmentationPicture_const__OutputArrayR(cv::bioinspired::TransientAreasSegmentationModule* instance, const cv::_OutputArray* transientAreas) {
		try {
			instance->getSegmentationPicture(*transientAreas);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// clearAllBuffers() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:189
	Result_void cv_bioinspired_TransientAreasSegmentationModule_clearAllBuffers(cv::bioinspired::TransientAreasSegmentationModule* instance) {
		try {
			instance->clearAllBuffers();
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(cv::Size) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/bioinspired/transientareassegmentationmodule.hpp:194
	Result<cv::Ptr<cv::bioinspired::TransientAreasSegmentationModule>*> cv_bioinspired_TransientAreasSegmentationModule_create_Size(cv::Size* inputSize) {
		try {
			cv::Ptr<cv::bioinspired::TransientAreasSegmentationModule> ret = cv::bioinspired::TransientAreasSegmentationModule::create(*inputSize);
			return Ok(new cv::Ptr<cv::bioinspired::TransientAreasSegmentationModule>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::bioinspired::TransientAreasSegmentationModule>*>))
	}
	
}
