#include "aruco.hpp"
#include "aruco_types.hpp"

extern "C" {
	// calibrateCameraAruco(cv::InputArrayOfArrays, cv::InputArray, cv::InputArray, const Ptr<cv::aruco::Board> &, cv::Size, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArray, cv::OutputArray, cv::OutputArray, int, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:580
	Result<double> cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(const cv::_InputArray* corners, const cv::_InputArray* ids, const cv::_InputArray* counter, const cv::Ptr<cv::aruco::Board>* board, cv::Size* imageSize, const cv::_InputOutputArray* cameraMatrix, const cv::_InputOutputArray* distCoeffs, const cv::_OutputArray* rvecs, const cv::_OutputArray* tvecs, const cv::_OutputArray* stdDeviationsIntrinsics, const cv::_OutputArray* stdDeviationsExtrinsics, const cv::_OutputArray* perViewErrors, int flags, cv::TermCriteria* criteria) {
		try {
			double ret = cv::aruco::calibrateCameraAruco(*corners, *ids, *counter, *board, *imageSize, *cameraMatrix, *distCoeffs, *rvecs, *tvecs, *stdDeviationsIntrinsics, *stdDeviationsExtrinsics, *perViewErrors, flags, *criteria);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// calibrateCameraAruco(cv::InputArrayOfArrays, cv::InputArray, cv::InputArray, const Ptr<cv::aruco::Board> &, cv::Size, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, int, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:591
	Result<double> cv_aruco_calibrateCameraAruco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(const cv::_InputArray* corners, const cv::_InputArray* ids, const cv::_InputArray* counter, const cv::Ptr<cv::aruco::Board>* board, cv::Size* imageSize, const cv::_InputOutputArray* cameraMatrix, const cv::_InputOutputArray* distCoeffs, const cv::_OutputArray* rvecs, const cv::_OutputArray* tvecs, int flags, cv::TermCriteria* criteria) {
		try {
			double ret = cv::aruco::calibrateCameraAruco(*corners, *ids, *counter, *board, *imageSize, *cameraMatrix, *distCoeffs, *rvecs, *tvecs, flags, *criteria);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// calibrateCameraCharuco(cv::InputArrayOfArrays, cv::InputArrayOfArrays, const Ptr<cv::aruco::CharucoBoard> &, cv::Size, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, cv::OutputArray, cv::OutputArray, cv::OutputArray, int, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:244
	Result<double> cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(const cv::_InputArray* charucoCorners, const cv::_InputArray* charucoIds, const cv::Ptr<cv::aruco::CharucoBoard>* board, cv::Size* imageSize, const cv::_InputOutputArray* cameraMatrix, const cv::_InputOutputArray* distCoeffs, const cv::_OutputArray* rvecs, const cv::_OutputArray* tvecs, const cv::_OutputArray* stdDeviationsIntrinsics, const cv::_OutputArray* stdDeviationsExtrinsics, const cv::_OutputArray* perViewErrors, int flags, cv::TermCriteria* criteria) {
		try {
			double ret = cv::aruco::calibrateCameraCharuco(*charucoCorners, *charucoIds, *board, *imageSize, *cameraMatrix, *distCoeffs, *rvecs, *tvecs, *stdDeviationsIntrinsics, *stdDeviationsExtrinsics, *perViewErrors, flags, *criteria);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// calibrateCameraCharuco(cv::InputArrayOfArrays, cv::InputArrayOfArrays, const Ptr<cv::aruco::CharucoBoard> &, cv::Size, cv::InputOutputArray, cv::InputOutputArray, cv::OutputArrayOfArrays, cv::OutputArrayOfArrays, int, cv::TermCriteria) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:254
	Result<double> cv_aruco_calibrateCameraCharuco_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_Size_const__InputOutputArrayR_const__InputOutputArrayR_const__OutputArrayR_const__OutputArrayR_int_TermCriteria(const cv::_InputArray* charucoCorners, const cv::_InputArray* charucoIds, const cv::Ptr<cv::aruco::CharucoBoard>* board, cv::Size* imageSize, const cv::_InputOutputArray* cameraMatrix, const cv::_InputOutputArray* distCoeffs, const cv::_OutputArray* rvecs, const cv::_OutputArray* tvecs, int flags, cv::TermCriteria* criteria) {
		try {
			double ret = cv::aruco::calibrateCameraCharuco(*charucoCorners, *charucoIds, *board, *imageSize, *cameraMatrix, *distCoeffs, *rvecs, *tvecs, flags, *criteria);
			return Ok<double>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<double>))
	}
	
	// detectCharucoDiamond(cv::InputArray, cv::InputArrayOfArrays, cv::InputArray, float, cv::OutputArrayOfArrays, cv::OutputArray, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:284
	Result_void cv_aruco_detectCharucoDiamond_const__InputArrayR_const__InputArrayR_const__InputArrayR_float_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* image, const cv::_InputArray* markerCorners, const cv::_InputArray* markerIds, float squareMarkerLengthRate, const cv::_OutputArray* diamondCorners, const cv::_OutputArray* diamondIds, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs) {
		try {
			cv::aruco::detectCharucoDiamond(*image, *markerCorners, *markerIds, squareMarkerLengthRate, *diamondCorners, *diamondIds, *cameraMatrix, *distCoeffs);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// detectMarkers(cv::InputArray, const Ptr<cv::aruco::Dictionary> &, cv::OutputArrayOfArrays, cv::OutputArray, const Ptr<cv::aruco::DetectorParameters> &, cv::OutputArrayOfArrays, cv::InputArray, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:221
	Result_void cv_aruco_detectMarkers_const__InputArrayR_const_Ptr_Dictionary_R_const__OutputArrayR_const__OutputArrayR_const_Ptr_DetectorParameters_R_const__OutputArrayR_const__InputArrayR_const__InputArrayR(const cv::_InputArray* image, const cv::Ptr<cv::aruco::Dictionary>* dictionary, const cv::_OutputArray* corners, const cv::_OutputArray* ids, const cv::Ptr<cv::aruco::DetectorParameters>* parameters, const cv::_OutputArray* rejectedImgPoints, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeff) {
		try {
			cv::aruco::detectMarkers(*image, *dictionary, *corners, *ids, *parameters, *rejectedImgPoints, *cameraMatrix, *distCoeff);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawAxis(cv::InputOutputArray, cv::InputArray, cv::InputArray, cv::InputArray, cv::InputArray, float) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:494
	Result_void cv_aruco_drawAxis_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_const__InputArrayR_float(const cv::_InputOutputArray* image, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, const cv::_InputArray* rvec, const cv::_InputArray* tvec, float length) {
		try {
			cv::aruco::drawAxis(*image, *cameraMatrix, *distCoeffs, *rvec, *tvec, length);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawCharucoDiamond(const Ptr<cv::aruco::Dictionary> &, cv::Vec4i, int, int, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:331
	Result_void cv_aruco_drawCharucoDiamond_const_Ptr_Dictionary_R_Vec4i_int_int_const__OutputArrayR_int_int(const cv::Ptr<cv::aruco::Dictionary>* dictionary, cv::Vec4i* ids, int squareLength, int markerLength, const cv::_OutputArray* img, int marginSize, int borderBits) {
		try {
			cv::aruco::drawCharucoDiamond(*dictionary, *ids, squareLength, markerLength, *img, marginSize, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawDetectedCornersCharuco(cv::InputOutputArray, cv::InputArray, cv::InputArray, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:204
	Result_void cv_aruco_drawDetectedCornersCharuco_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(const cv::_InputOutputArray* image, const cv::_InputArray* charucoCorners, const cv::_InputArray* charucoIds, cv::Scalar* cornerColor) {
		try {
			cv::aruco::drawDetectedCornersCharuco(*image, *charucoCorners, *charucoIds, *cornerColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawDetectedDiamonds(cv::InputOutputArray, cv::InputArrayOfArrays, cv::InputArray, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:310
	Result_void cv_aruco_drawDetectedDiamonds_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(const cv::_InputOutputArray* image, const cv::_InputArray* diamondCorners, const cv::_InputArray* diamondIds, cv::Scalar* borderColor) {
		try {
			cv::aruco::drawDetectedDiamonds(*image, *diamondCorners, *diamondIds, *borderColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawDetectedMarkers(cv::InputOutputArray, cv::InputArrayOfArrays, cv::InputArray, cv::Scalar) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:470
	Result_void cv_aruco_drawDetectedMarkers_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_Scalar(const cv::_InputOutputArray* image, const cv::_InputArray* corners, const cv::_InputArray* ids, cv::Scalar* borderColor) {
		try {
			cv::aruco::drawDetectedMarkers(*image, *corners, *ids, *borderColor);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawMarker(const Ptr<cv::aruco::Dictionary> &, int, int, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:511
	Result_void cv_aruco_drawMarker_const_Ptr_Dictionary_R_int_int_const__OutputArrayR_int(const cv::Ptr<cv::aruco::Dictionary>* dictionary, int id, int sidePixels, const cv::_OutputArray* img, int borderBits) {
		try {
			cv::aruco::drawMarker(*dictionary, id, sidePixels, *img, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// drawPlanarBoard(const Ptr<cv::aruco::Board> &, cv::Size, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:531
	Result_void cv_aruco_drawPlanarBoard_const_Ptr_Board_R_Size_const__OutputArrayR_int_int(const cv::Ptr<cv::aruco::Board>* board, cv::Size* outSize, const cv::_OutputArray* img, int marginSize, int borderBits) {
		try {
			cv::aruco::drawPlanarBoard(*board, *outSize, *img, marginSize, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// estimatePoseBoard(cv::InputArrayOfArrays, cv::InputArray, const Ptr<cv::aruco::Board> &, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputOutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:406
	Result<int> cv_aruco_estimatePoseBoard_const__InputArrayR_const__InputArrayR_const_Ptr_Board_R_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(const cv::_InputArray* corners, const cv::_InputArray* ids, const cv::Ptr<cv::aruco::Board>* board, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, const cv::_InputOutputArray* rvec, const cv::_InputOutputArray* tvec, bool useExtrinsicGuess) {
		try {
			int ret = cv::aruco::estimatePoseBoard(*corners, *ids, *board, *cameraMatrix, *distCoeffs, *rvec, *tvec, useExtrinsicGuess);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// estimatePoseCharucoBoard(cv::InputArray, cv::InputArray, const Ptr<cv::aruco::CharucoBoard> &, cv::InputArray, cv::InputArray, cv::InputOutputArray, cv::InputOutputArray, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:185
	Result<bool> cv_aruco_estimatePoseCharucoBoard_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_const__InputArrayR_const__InputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_bool(const cv::_InputArray* charucoCorners, const cv::_InputArray* charucoIds, const cv::Ptr<cv::aruco::CharucoBoard>* board, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, const cv::_InputOutputArray* rvec, const cv::_InputOutputArray* tvec, bool useExtrinsicGuess) {
		try {
			bool ret = cv::aruco::estimatePoseCharucoBoard(*charucoCorners, *charucoIds, *board, *cameraMatrix, *distCoeffs, *rvec, *tvec, useExtrinsicGuess);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// estimatePoseSingleMarkers(cv::InputArrayOfArrays, float, cv::InputArray, cv::InputArray, cv::OutputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:256
	Result_void cv_aruco_estimatePoseSingleMarkers_const__InputArrayR_float_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::_InputArray* corners, float markerLength, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, const cv::_OutputArray* rvecs, const cv::_OutputArray* tvecs, const cv::_OutputArray* _objPoints) {
		try {
			cv::aruco::estimatePoseSingleMarkers(*corners, markerLength, *cameraMatrix, *distCoeffs, *rvecs, *tvecs, *_objPoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// generateCustomDictionary(int, int, const Ptr<cv::aruco::Dictionary> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:200
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_generateCustomDictionary_int_int_const_Ptr_Dictionary_R_int(int nMarkers, int markerSize, const cv::Ptr<cv::aruco::Dictionary>* baseDictionary, int randomSeed) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::generateCustomDictionary(nMarkers, markerSize, *baseDictionary, randomSeed);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// generateCustomDictionary(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:181
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_generateCustomDictionary_int_int_int(int nMarkers, int markerSize, int randomSeed) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::generateCustomDictionary(nMarkers, markerSize, randomSeed);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// getBoardObjectAndImagePoints(const Ptr<cv::aruco::Board> &, cv::InputArrayOfArrays, cv::InputArray, cv::OutputArray, cv::OutputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:608
	Result_void cv_aruco_getBoardObjectAndImagePoints_const_Ptr_Board_R_const__InputArrayR_const__InputArrayR_const__OutputArrayR_const__OutputArrayR(const cv::Ptr<cv::aruco::Board>* board, const cv::_InputArray* detectedCorners, const cv::_InputArray* detectedIds, const cv::_OutputArray* objPoints, const cv::_OutputArray* imgPoints) {
		try {
			cv::aruco::getBoardObjectAndImagePoints(*board, *detectedCorners, *detectedIds, *objPoints, *imgPoints);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getPredefinedDictionary(cv::aruco::PREDEFINED_DICTIONARY_NAME) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:169
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_getPredefinedDictionary_PREDEFINED_DICTIONARY_NAME(cv::aruco::PREDEFINED_DICTIONARY_NAME name) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::getPredefinedDictionary(name);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// getPredefinedDictionary(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:175
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_getPredefinedDictionary_int(int dict) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::getPredefinedDictionary(dict);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// interpolateCornersCharuco(cv::InputArrayOfArrays, cv::InputArray, cv::InputArray, const Ptr<cv::aruco::CharucoBoard> &, cv::OutputArray, cv::OutputArray, cv::InputArray, cv::InputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:158
	Result<int> cv_aruco_interpolateCornersCharuco_const__InputArrayR_const__InputArrayR_const__InputArrayR_const_Ptr_CharucoBoard_R_const__OutputArrayR_const__OutputArrayR_const__InputArrayR_const__InputArrayR_int(const cv::_InputArray* markerCorners, const cv::_InputArray* markerIds, const cv::_InputArray* image, const cv::Ptr<cv::aruco::CharucoBoard>* board, const cv::_OutputArray* charucoCorners, const cv::_OutputArray* charucoIds, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, int minMarkers) {
		try {
			int ret = cv::aruco::interpolateCornersCharuco(*markerCorners, *markerIds, *image, *board, *charucoCorners, *charucoIds, *cameraMatrix, *distCoeffs, minMarkers);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// refineDetectedMarkers(cv::InputArray, const Ptr<cv::aruco::Board> &, cv::InputOutputArrayOfArrays, cv::InputOutputArray, cv::InputOutputArrayOfArrays, cv::InputArray, cv::InputArray, float, float, bool, cv::OutputArray, const Ptr<cv::aruco::DetectorParameters> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:444
	Result_void cv_aruco_refineDetectedMarkers_const__InputArrayR_const_Ptr_Board_R_const__InputOutputArrayR_const__InputOutputArrayR_const__InputOutputArrayR_const__InputArrayR_const__InputArrayR_float_float_bool_const__OutputArrayR_const_Ptr_DetectorParameters_R(const cv::_InputArray* image, const cv::Ptr<cv::aruco::Board>* board, const cv::_InputOutputArray* detectedCorners, const cv::_InputOutputArray* detectedIds, const cv::_InputOutputArray* rejectedCorners, const cv::_InputArray* cameraMatrix, const cv::_InputArray* distCoeffs, float minRepDistance, float errorCorrectionRate, bool checkAllOrders, const cv::_OutputArray* recoveredIdxs, const cv::Ptr<cv::aruco::DetectorParameters>* parameters) {
		try {
			cv::aruco::refineDetectedMarkers(*image, *board, *detectedCorners, *detectedIds, *rejectedCorners, *cameraMatrix, *distCoeffs, minRepDistance, errorCorrectionRate, checkAllOrders, *recoveredIdxs, *parameters);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// testCharucoCornersCollinear(const Ptr<cv::aruco::CharucoBoard> &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:346
	Result<bool> cv_aruco_testCharucoCornersCollinear_const_Ptr_CharucoBoard_R_const__InputArrayR(const cv::Ptr<cv::aruco::CharucoBoard>* _board, const cv::_InputArray* _charucoIds) {
		try {
			bool ret = cv::aruco::testCharucoCornersCollinear(*_board, *_charucoIds);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// objPoints /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:298
	std::vector<std::vector<cv::Point3f>>* cv_aruco_Board_getPropObjPoints_const(const cv::aruco::Board* instance) {
		std::vector<std::vector<cv::Point3f>> ret = instance->objPoints;
		return new std::vector<std::vector<cv::Point3f>>(ret);
	}
	
	// objPoints /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:298
	void cv_aruco_Board_setPropObjPoints_vector_vector_Point3f__(cv::aruco::Board* instance, std::vector<std::vector<cv::Point3f>>* val) {
		instance->objPoints = *val;
	}
	
	// dictionary /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:301
	cv::Ptr<cv::aruco::Dictionary>* cv_aruco_Board_getPropDictionary(cv::aruco::Board* instance) {
		cv::Ptr<cv::aruco::Dictionary> ret = instance->dictionary;
		return new cv::Ptr<cv::aruco::Dictionary>(ret);
	}
	
	// dictionary /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:301
	void cv_aruco_Board_setPropDictionary_Ptr_Dictionary_(cv::aruco::Board* instance, cv::Ptr<cv::aruco::Dictionary>* val) {
		instance->dictionary = *val;
	}
	
	// ids /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:305
	std::vector<int>* cv_aruco_Board_getPropIds_const(const cv::aruco::Board* instance) {
		std::vector<int> ret = instance->ids;
		return new std::vector<int>(ret);
	}
	
	// ids /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:305
	void cv_aruco_Board_setPropIds_vector_int_(cv::aruco::Board* instance, std::vector<int>* val) {
		instance->ids = *val;
	}
	
	void cv_Board_delete(cv::aruco::Board* instance) {
		delete instance;
	}
	// create(cv::InputArrayOfArrays, const Ptr<cv::aruco::Dictionary> &, cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:283
	Result<cv::Ptr<cv::aruco::Board>*> cv_aruco_Board_create_const__InputArrayR_const_Ptr_Dictionary_R_const__InputArrayR(const cv::_InputArray* objPoints, const cv::Ptr<cv::aruco::Dictionary>* dictionary, const cv::_InputArray* ids) {
		try {
			cv::Ptr<cv::aruco::Board> ret = cv::aruco::Board::create(*objPoints, *dictionary, *ids);
			return Ok(new cv::Ptr<cv::aruco::Board>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Board>*>))
	}
	
	// setIds(cv::InputArray) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:294
	Result_void cv_aruco_Board_setIds_const__InputArrayR(cv::aruco::Board* instance, const cv::_InputArray* ids) {
		try {
			instance->setIds(*ids);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// chessboardCorners /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:66
	std::vector<cv::Point3f>* cv_aruco_CharucoBoard_getPropChessboardCorners_const(const cv::aruco::CharucoBoard* instance) {
		std::vector<cv::Point3f> ret = instance->chessboardCorners;
		return new std::vector<cv::Point3f>(ret);
	}
	
	// chessboardCorners /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:66
	void cv_aruco_CharucoBoard_setPropChessboardCorners_vector_Point3f_(cv::aruco::CharucoBoard* instance, std::vector<cv::Point3f>* val) {
		instance->chessboardCorners = *val;
	}
	
	// nearestMarkerIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:69
	std::vector<std::vector<int>>* cv_aruco_CharucoBoard_getPropNearestMarkerIdx_const(const cv::aruco::CharucoBoard* instance) {
		std::vector<std::vector<int>> ret = instance->nearestMarkerIdx;
		return new std::vector<std::vector<int>>(ret);
	}
	
	// nearestMarkerIdx /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:69
	void cv_aruco_CharucoBoard_setPropNearestMarkerIdx_vector_vector_int__(cv::aruco::CharucoBoard* instance, std::vector<std::vector<int>>* val) {
		instance->nearestMarkerIdx = *val;
	}
	
	// nearestMarkerCorners /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:70
	std::vector<std::vector<int>>* cv_aruco_CharucoBoard_getPropNearestMarkerCorners_const(const cv::aruco::CharucoBoard* instance) {
		std::vector<std::vector<int>> ret = instance->nearestMarkerCorners;
		return new std::vector<std::vector<int>>(ret);
	}
	
	// nearestMarkerCorners /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:70
	void cv_aruco_CharucoBoard_setPropNearestMarkerCorners_vector_vector_int__(cv::aruco::CharucoBoard* instance, std::vector<std::vector<int>>* val) {
		instance->nearestMarkerCorners = *val;
	}
	
	cv::aruco::Board* cv_CharucoBoard_to_Board(cv::aruco::CharucoBoard* instance) {
		return dynamic_cast<cv::aruco::Board*>(instance);
	}
	
	void cv_CharucoBoard_delete(cv::aruco::CharucoBoard* instance) {
		delete instance;
	}
	// draw(cv::Size, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:83
	Result_void cv_aruco_CharucoBoard_draw_Size_const__OutputArrayR_int_int(cv::aruco::CharucoBoard* instance, cv::Size* outSize, const cv::_OutputArray* img, int marginSize, int borderBits) {
		try {
			instance->draw(*outSize, *img, marginSize, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, int, float, float, const Ptr<cv::aruco::Dictionary> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:100
	Result<cv::Ptr<cv::aruco::CharucoBoard>*> cv_aruco_CharucoBoard_create_int_int_float_float_const_Ptr_Dictionary_R(int squaresX, int squaresY, float squareLength, float markerLength, const cv::Ptr<cv::aruco::Dictionary>* dictionary) {
		try {
			cv::Ptr<cv::aruco::CharucoBoard> ret = cv::aruco::CharucoBoard::create(squaresX, squaresY, squareLength, markerLength, *dictionary);
			return Ok(new cv::Ptr<cv::aruco::CharucoBoard>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::CharucoBoard>*>))
	}
	
	// getChessboardSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:106
	Result<cv::Size> cv_aruco_CharucoBoard_getChessboardSize_const(const cv::aruco::CharucoBoard* instance) {
		try {
			cv::Size ret = instance->getChessboardSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getSquareLength() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:111
	Result<float> cv_aruco_CharucoBoard_getSquareLength_const(const cv::aruco::CharucoBoard* instance) {
		try {
			float ret = instance->getSquareLength();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getMarkerLength() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/charuco.hpp:116
	Result<float> cv_aruco_CharucoBoard_getMarkerLength_const(const cv::aruco::CharucoBoard* instance) {
		try {
			float ret = instance->getMarkerLength();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// adaptiveThreshWinSizeMin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:156
	int cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeMin_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeMin;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeMin /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:156
	void cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeMin_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeMin = val;
	}
	
	// adaptiveThreshWinSizeMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:157
	int cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeMax_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeMax;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeMax /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:157
	void cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeMax_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeMax = val;
	}
	
	// adaptiveThreshWinSizeStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:158
	int cv_aruco_DetectorParameters_getPropAdaptiveThreshWinSizeStep_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->adaptiveThreshWinSizeStep;
		return (int)ret;
	}
	
	// adaptiveThreshWinSizeStep /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:158
	void cv_aruco_DetectorParameters_setPropAdaptiveThreshWinSizeStep_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->adaptiveThreshWinSizeStep = val;
	}
	
	// adaptiveThreshConstant /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:159
	double cv_aruco_DetectorParameters_getPropAdaptiveThreshConstant_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->adaptiveThreshConstant;
		return (double)ret;
	}
	
	// adaptiveThreshConstant /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:159
	void cv_aruco_DetectorParameters_setPropAdaptiveThreshConstant_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->adaptiveThreshConstant = val;
	}
	
	// minMarkerPerimeterRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:160
	double cv_aruco_DetectorParameters_getPropMinMarkerPerimeterRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->minMarkerPerimeterRate;
		return (double)ret;
	}
	
	// minMarkerPerimeterRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:160
	void cv_aruco_DetectorParameters_setPropMinMarkerPerimeterRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->minMarkerPerimeterRate = val;
	}
	
	// maxMarkerPerimeterRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:161
	double cv_aruco_DetectorParameters_getPropMaxMarkerPerimeterRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->maxMarkerPerimeterRate;
		return (double)ret;
	}
	
	// maxMarkerPerimeterRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:161
	void cv_aruco_DetectorParameters_setPropMaxMarkerPerimeterRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->maxMarkerPerimeterRate = val;
	}
	
	// polygonalApproxAccuracyRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:162
	double cv_aruco_DetectorParameters_getPropPolygonalApproxAccuracyRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->polygonalApproxAccuracyRate;
		return (double)ret;
	}
	
	// polygonalApproxAccuracyRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:162
	void cv_aruco_DetectorParameters_setPropPolygonalApproxAccuracyRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->polygonalApproxAccuracyRate = val;
	}
	
	// minCornerDistanceRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:163
	double cv_aruco_DetectorParameters_getPropMinCornerDistanceRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->minCornerDistanceRate;
		return (double)ret;
	}
	
	// minCornerDistanceRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:163
	void cv_aruco_DetectorParameters_setPropMinCornerDistanceRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->minCornerDistanceRate = val;
	}
	
	// minDistanceToBorder /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:164
	int cv_aruco_DetectorParameters_getPropMinDistanceToBorder_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->minDistanceToBorder;
		return (int)ret;
	}
	
	// minDistanceToBorder /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:164
	void cv_aruco_DetectorParameters_setPropMinDistanceToBorder_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->minDistanceToBorder = val;
	}
	
	// minMarkerDistanceRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:165
	double cv_aruco_DetectorParameters_getPropMinMarkerDistanceRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->minMarkerDistanceRate;
		return (double)ret;
	}
	
	// minMarkerDistanceRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:165
	void cv_aruco_DetectorParameters_setPropMinMarkerDistanceRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->minMarkerDistanceRate = val;
	}
	
	// cornerRefinementMethod /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:166
	int cv_aruco_DetectorParameters_getPropCornerRefinementMethod_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->cornerRefinementMethod;
		return (int)ret;
	}
	
	// cornerRefinementMethod /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:166
	void cv_aruco_DetectorParameters_setPropCornerRefinementMethod_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->cornerRefinementMethod = val;
	}
	
	// cornerRefinementWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:167
	int cv_aruco_DetectorParameters_getPropCornerRefinementWinSize_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->cornerRefinementWinSize;
		return (int)ret;
	}
	
	// cornerRefinementWinSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:167
	void cv_aruco_DetectorParameters_setPropCornerRefinementWinSize_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->cornerRefinementWinSize = val;
	}
	
	// cornerRefinementMaxIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:168
	int cv_aruco_DetectorParameters_getPropCornerRefinementMaxIterations_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->cornerRefinementMaxIterations;
		return (int)ret;
	}
	
	// cornerRefinementMaxIterations /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:168
	void cv_aruco_DetectorParameters_setPropCornerRefinementMaxIterations_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->cornerRefinementMaxIterations = val;
	}
	
	// cornerRefinementMinAccuracy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:169
	double cv_aruco_DetectorParameters_getPropCornerRefinementMinAccuracy_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->cornerRefinementMinAccuracy;
		return (double)ret;
	}
	
	// cornerRefinementMinAccuracy /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:169
	void cv_aruco_DetectorParameters_setPropCornerRefinementMinAccuracy_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->cornerRefinementMinAccuracy = val;
	}
	
	// markerBorderBits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:170
	int cv_aruco_DetectorParameters_getPropMarkerBorderBits_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->markerBorderBits;
		return (int)ret;
	}
	
	// markerBorderBits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:170
	void cv_aruco_DetectorParameters_setPropMarkerBorderBits_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->markerBorderBits = val;
	}
	
	// perspectiveRemovePixelPerCell /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:171
	int cv_aruco_DetectorParameters_getPropPerspectiveRemovePixelPerCell_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->perspectiveRemovePixelPerCell;
		return (int)ret;
	}
	
	// perspectiveRemovePixelPerCell /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:171
	void cv_aruco_DetectorParameters_setPropPerspectiveRemovePixelPerCell_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->perspectiveRemovePixelPerCell = val;
	}
	
	// perspectiveRemoveIgnoredMarginPerCell /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:172
	double cv_aruco_DetectorParameters_getPropPerspectiveRemoveIgnoredMarginPerCell_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->perspectiveRemoveIgnoredMarginPerCell;
		return (double)ret;
	}
	
	// perspectiveRemoveIgnoredMarginPerCell /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:172
	void cv_aruco_DetectorParameters_setPropPerspectiveRemoveIgnoredMarginPerCell_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->perspectiveRemoveIgnoredMarginPerCell = val;
	}
	
	// maxErroneousBitsInBorderRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:173
	double cv_aruco_DetectorParameters_getPropMaxErroneousBitsInBorderRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->maxErroneousBitsInBorderRate;
		return (double)ret;
	}
	
	// maxErroneousBitsInBorderRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:173
	void cv_aruco_DetectorParameters_setPropMaxErroneousBitsInBorderRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->maxErroneousBitsInBorderRate = val;
	}
	
	// minOtsuStdDev /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:174
	double cv_aruco_DetectorParameters_getPropMinOtsuStdDev_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->minOtsuStdDev;
		return (double)ret;
	}
	
	// minOtsuStdDev /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:174
	void cv_aruco_DetectorParameters_setPropMinOtsuStdDev_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->minOtsuStdDev = val;
	}
	
	// errorCorrectionRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:175
	double cv_aruco_DetectorParameters_getPropErrorCorrectionRate_const(const cv::aruco::DetectorParameters* instance) {
		double ret = instance->errorCorrectionRate;
		return (double)ret;
	}
	
	// errorCorrectionRate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:175
	void cv_aruco_DetectorParameters_setPropErrorCorrectionRate_double(cv::aruco::DetectorParameters* instance, double val) {
		instance->errorCorrectionRate = val;
	}
	
	// aprilTagQuadDecimate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:178
	float cv_aruco_DetectorParameters_getPropAprilTagQuadDecimate_const(const cv::aruco::DetectorParameters* instance) {
		float ret = instance->aprilTagQuadDecimate;
		return (float)ret;
	}
	
	// aprilTagQuadDecimate /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:178
	void cv_aruco_DetectorParameters_setPropAprilTagQuadDecimate_float(cv::aruco::DetectorParameters* instance, float val) {
		instance->aprilTagQuadDecimate = val;
	}
	
	// aprilTagQuadSigma /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:179
	float cv_aruco_DetectorParameters_getPropAprilTagQuadSigma_const(const cv::aruco::DetectorParameters* instance) {
		float ret = instance->aprilTagQuadSigma;
		return (float)ret;
	}
	
	// aprilTagQuadSigma /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:179
	void cv_aruco_DetectorParameters_setPropAprilTagQuadSigma_float(cv::aruco::DetectorParameters* instance, float val) {
		instance->aprilTagQuadSigma = val;
	}
	
	// aprilTagMinClusterPixels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:182
	int cv_aruco_DetectorParameters_getPropAprilTagMinClusterPixels_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->aprilTagMinClusterPixels;
		return (int)ret;
	}
	
	// aprilTagMinClusterPixels /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:182
	void cv_aruco_DetectorParameters_setPropAprilTagMinClusterPixels_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->aprilTagMinClusterPixels = val;
	}
	
	// aprilTagMaxNmaxima /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:183
	int cv_aruco_DetectorParameters_getPropAprilTagMaxNmaxima_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->aprilTagMaxNmaxima;
		return (int)ret;
	}
	
	// aprilTagMaxNmaxima /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:183
	void cv_aruco_DetectorParameters_setPropAprilTagMaxNmaxima_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->aprilTagMaxNmaxima = val;
	}
	
	// aprilTagCriticalRad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:184
	float cv_aruco_DetectorParameters_getPropAprilTagCriticalRad_const(const cv::aruco::DetectorParameters* instance) {
		float ret = instance->aprilTagCriticalRad;
		return (float)ret;
	}
	
	// aprilTagCriticalRad /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:184
	void cv_aruco_DetectorParameters_setPropAprilTagCriticalRad_float(cv::aruco::DetectorParameters* instance, float val) {
		instance->aprilTagCriticalRad = val;
	}
	
	// aprilTagMaxLineFitMse /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:185
	float cv_aruco_DetectorParameters_getPropAprilTagMaxLineFitMse_const(const cv::aruco::DetectorParameters* instance) {
		float ret = instance->aprilTagMaxLineFitMse;
		return (float)ret;
	}
	
	// aprilTagMaxLineFitMse /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:185
	void cv_aruco_DetectorParameters_setPropAprilTagMaxLineFitMse_float(cv::aruco::DetectorParameters* instance, float val) {
		instance->aprilTagMaxLineFitMse = val;
	}
	
	// aprilTagMinWhiteBlackDiff /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:186
	int cv_aruco_DetectorParameters_getPropAprilTagMinWhiteBlackDiff_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->aprilTagMinWhiteBlackDiff;
		return (int)ret;
	}
	
	// aprilTagMinWhiteBlackDiff /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:186
	void cv_aruco_DetectorParameters_setPropAprilTagMinWhiteBlackDiff_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->aprilTagMinWhiteBlackDiff = val;
	}
	
	// aprilTagDeglitch /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:187
	int cv_aruco_DetectorParameters_getPropAprilTagDeglitch_const(const cv::aruco::DetectorParameters* instance) {
		int ret = instance->aprilTagDeglitch;
		return (int)ret;
	}
	
	// aprilTagDeglitch /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:187
	void cv_aruco_DetectorParameters_setPropAprilTagDeglitch_int(cv::aruco::DetectorParameters* instance, int val) {
		instance->aprilTagDeglitch = val;
	}
	
	// detectInvertedMarker /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:190
	bool cv_aruco_DetectorParameters_getPropDetectInvertedMarker_const(const cv::aruco::DetectorParameters* instance) {
		bool ret = instance->detectInvertedMarker;
		return (bool)ret;
	}
	
	// detectInvertedMarker /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:190
	void cv_aruco_DetectorParameters_setPropDetectInvertedMarker_bool(cv::aruco::DetectorParameters* instance, bool val) {
		instance->detectInvertedMarker = val;
	}
	
	void cv_DetectorParameters_delete(cv::aruco::DetectorParameters* instance) {
		delete instance;
	}
	// DetectorParameters() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:152
	Result<cv::aruco::DetectorParameters*> cv_aruco_DetectorParameters_DetectorParameters() {
		try {
			cv::aruco::DetectorParameters* ret = new cv::aruco::DetectorParameters();
			return Ok<cv::aruco::DetectorParameters*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::aruco::DetectorParameters*>))
	}
	
	// create() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:154
	Result<cv::Ptr<cv::aruco::DetectorParameters>*> cv_aruco_DetectorParameters_create() {
		try {
			cv::Ptr<cv::aruco::DetectorParameters> ret = cv::aruco::DetectorParameters::create();
			return Ok(new cv::Ptr<cv::aruco::DetectorParameters>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::DetectorParameters>*>))
	}
	
	// bytesList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:64
	cv::Mat* cv_aruco_Dictionary_getPropBytesList_const(const cv::aruco::Dictionary* instance) {
		cv::Mat ret = instance->bytesList;
		return new cv::Mat(ret);
	}
	
	// bytesList /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:64
	void cv_aruco_Dictionary_setPropBytesList_Mat(cv::aruco::Dictionary* instance, cv::Mat* val) {
		instance->bytesList = *val;
	}
	
	// markerSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:65
	int cv_aruco_Dictionary_getPropMarkerSize_const(const cv::aruco::Dictionary* instance) {
		int ret = instance->markerSize;
		return (int)ret;
	}
	
	// markerSize /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:65
	void cv_aruco_Dictionary_setPropMarkerSize_int(cv::aruco::Dictionary* instance, int val) {
		instance->markerSize = val;
	}
	
	// maxCorrectionBits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:66
	int cv_aruco_Dictionary_getPropMaxCorrectionBits_const(const cv::aruco::Dictionary* instance) {
		int ret = instance->maxCorrectionBits;
		return (int)ret;
	}
	
	// maxCorrectionBits /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:66
	void cv_aruco_Dictionary_setPropMaxCorrectionBits_int(cv::aruco::Dictionary* instance, int val) {
		instance->maxCorrectionBits = val;
	}
	
	void cv_Dictionary_delete(cv::aruco::Dictionary* instance) {
		delete instance;
	}
	// Dictionary(const cv::Mat &, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:71
	Result<cv::aruco::Dictionary*> cv_aruco_Dictionary_Dictionary_const_MatR_int_int(const cv::Mat* _bytesList, int _markerSize, int _maxcorr) {
		try {
			cv::aruco::Dictionary* ret = new cv::aruco::Dictionary(*_bytesList, _markerSize, _maxcorr);
			return Ok<cv::aruco::Dictionary*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::aruco::Dictionary*>))
	}
	
	// Dictionary(const Ptr<cv::aruco::Dictionary> &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:81
	Result<cv::aruco::Dictionary*> cv_aruco_Dictionary_Dictionary_const_Ptr_Dictionary_R(const cv::Ptr<cv::aruco::Dictionary>* _dictionary) {
		try {
			cv::aruco::Dictionary* ret = new cv::aruco::Dictionary(*_dictionary);
			return Ok<cv::aruco::Dictionary*>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::aruco::Dictionary*>))
	}
	
	// create(int, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:87
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_Dictionary_create_int_int_int(int nMarkers, int markerSize, int randomSeed) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::Dictionary::create(nMarkers, markerSize, randomSeed);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// create(int, int, const Ptr<cv::aruco::Dictionary> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:93
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_Dictionary_create_int_int_const_Ptr_Dictionary_R_int(int nMarkers, int markerSize, const cv::Ptr<cv::aruco::Dictionary>* baseDictionary, int randomSeed) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::Dictionary::create(nMarkers, markerSize, *baseDictionary, randomSeed);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// get(int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:99
	Result<cv::Ptr<cv::aruco::Dictionary>*> cv_aruco_Dictionary_get_int(int dict) {
		try {
			cv::Ptr<cv::aruco::Dictionary> ret = cv::aruco::Dictionary::get(dict);
			return Ok(new cv::Ptr<cv::aruco::Dictionary>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::Dictionary>*>))
	}
	
	// identify(const cv::Mat &, int &, int &, double) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:105
	Result<bool> cv_aruco_Dictionary_identify_const_const_MatR_intR_intR_double(const cv::aruco::Dictionary* instance, const cv::Mat* onlyBits, int* idx, int* rotation, double maxCorrectionRate) {
		try {
			bool ret = instance->identify(*onlyBits, *idx, *rotation, maxCorrectionRate);
			return Ok<bool>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<bool>))
	}
	
	// getDistanceToId(cv::InputArray, int, bool) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:111
	Result<int> cv_aruco_Dictionary_getDistanceToId_const_const__InputArrayR_int_bool(const cv::aruco::Dictionary* instance, const cv::_InputArray* bits, int id, bool allRotations) {
		try {
			int ret = instance->getDistanceToId(*bits, id, allRotations);
			return Ok<int>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<int>))
	}
	
	// drawMarker(int, int, cv::OutputArray, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:117
	Result_void cv_aruco_Dictionary_drawMarker_const_int_int_const__OutputArrayR_int(const cv::aruco::Dictionary* instance, int id, int sidePixels, const cv::_OutputArray* _img, int borderBits) {
		try {
			instance->drawMarker(id, sidePixels, *_img, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// getByteListFromBits(const cv::Mat &) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:123
	Result<cv::Mat*> cv_aruco_Dictionary_getByteListFromBits_const_MatR(const cv::Mat* bits) {
		try {
			cv::Mat ret = cv::aruco::Dictionary::getByteListFromBits(*bits);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	// getBitsFromByteList(const cv::Mat &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco/dictionary.hpp:129
	Result<cv::Mat*> cv_aruco_Dictionary_getBitsFromByteList_const_MatR_int(const cv::Mat* byteList, int markerSize) {
		try {
			cv::Mat ret = cv::aruco::Dictionary::getBitsFromByteList(*byteList, markerSize);
			return Ok(new cv::Mat(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Mat*>))
	}
	
	cv::aruco::Board* cv_GridBoard_to_Board(cv::aruco::GridBoard* instance) {
		return dynamic_cast<cv::aruco::Board*>(instance);
	}
	
	void cv_GridBoard_delete(cv::aruco::GridBoard* instance) {
		delete instance;
	}
	// draw(cv::Size, cv::OutputArray, int, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:329
	Result_void cv_aruco_GridBoard_draw_Size_const__OutputArrayR_int_int(cv::aruco::GridBoard* instance, cv::Size* outSize, const cv::_OutputArray* img, int marginSize, int borderBits) {
		try {
			instance->draw(*outSize, *img, marginSize, borderBits);
			return Ok();
		} OCVRS_CATCH(OCVRS_TYPE(Result_void))
	}
	
	// create(int, int, float, float, const Ptr<cv::aruco::Dictionary> &, int) /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:346
	Result<cv::Ptr<cv::aruco::GridBoard>*> cv_aruco_GridBoard_create_int_int_float_float_const_Ptr_Dictionary_R_int(int markersX, int markersY, float markerLength, float markerSeparation, const cv::Ptr<cv::aruco::Dictionary>* dictionary, int firstMarker) {
		try {
			cv::Ptr<cv::aruco::GridBoard> ret = cv::aruco::GridBoard::create(markersX, markersY, markerLength, markerSeparation, *dictionary, firstMarker);
			return Ok(new cv::Ptr<cv::aruco::GridBoard>(ret));
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Ptr<cv::aruco::GridBoard>*>))
	}
	
	// getGridSize() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:352
	Result<cv::Size> cv_aruco_GridBoard_getGridSize_const(const cv::aruco::GridBoard* instance) {
		try {
			cv::Size ret = instance->getGridSize();
			return Ok<cv::Size>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<cv::Size>))
	}
	
	// getMarkerLength() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:357
	Result<float> cv_aruco_GridBoard_getMarkerLength_const(const cv::aruco::GridBoard* instance) {
		try {
			float ret = instance->getMarkerLength();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
	// getMarkerSeparation() /home/pro/projects/opencv-lib/opencv-4.5/install/include/opencv4/opencv2/aruco.hpp:362
	Result<float> cv_aruco_GridBoard_getMarkerSeparation_const(const cv::aruco::GridBoard* instance) {
		try {
			float ret = instance->getMarkerSeparation();
			return Ok<float>(ret);
		} OCVRS_CATCH(OCVRS_TYPE(Result<float>))
	}
	
}
