use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Description of either Positions or Scalings.
/// All attributes are mandatory.
/// For positions, 1.0 means 1.0 m.
pub struct Vector3 {
    pub x: f64,
    pub y: f64,
    pub z: f64,
}
