use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::ImageFormat;

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Top-view representation of a Product.
/// Implemented by an image that is put into a rectangular region.
/// The origin of the region is aligned with the origin of the Product
/// but may be moved by an offset.

pub struct TopView {
    /// Width, in m, of the rectangular region.
    pub width: f64,

    /// Depth, in m, of the rectangular region.
    pub depth: f64,

    /// Optional X offset, in m, of the rectangular region.
    pub x: Option<f64>,

    /// Optional Z offset, in m, of the rectangular region.
    pub z: Option<f64>,

    /// The mandatory format of the image.
    pub image_format: ImageFormat,

    /// The manadatory image reference.
    pub image: String,
}
