use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Information of a client-side JavaScript script (ECMA 5.1).
/// All attributes, except Path, are mandatory.
pub struct Script {
    /// The name of the script, should correspond to it's scope, two or
    /// three levels.
    pub name: String,

    /// The mode of the script.
    pub mode: ScriptMode,

    /// The version of the script: <Major/>.<Minor/>.<Build/>.<Release/>
    ///
    /// <Major/> starts at 1 and will be incremented on major changes.
    ///
    /// <Minor/> starts at 0 and will be incremented on minor changes.
    ///
    /// <Build/> starts at 0 and will be incremented on small changes.
    ///
    /// <Release/> starts at 1 for non-final release and 100 for final ones.
    ///
    /// Release numbers bigger than 100 mark bug fixes/patches.
    pub version: String,

    /// The operation mode. For client-side scripts it must be true.
    pub run_time: bool,

    /// Optional path to the JavaScript file, fallback: Name + ".js"
    pub path: Option<String>,
}

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
pub enum ScriptMode {
    Interactor,
}
