use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::Vector3;

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Description of a three-dimensional rotation.
/// All attributes are mandatory.
pub struct Quaternion {
    #[serde(flatten)]
    pub vector: Vector3,

    pub w: f64,
}
