use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::ImageFormat;

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Product preview image, preferably a perspective image with 1k size.
pub struct Preview {
    /// The mandatory format of the image.
    pub image_format: ImageFormat,

    /// The manadatory image reference.
    pub image: String,
}
