use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

/// Basic master data, used OC master-data scenarios.
#[derive(Serialize, Deserialize, Debug, JsonSchema)]
pub struct MasterData {
    /// The commercial product Id.
    /// ASCII. 45 chars max.
    pub product_id: Option<String>,

    /// The instance id of an associated master product, e.g. a set.
    pub native_id: Option<String>,

    /// Informal description.
    /// UTF-8. 100 chars max.
    pub description: Option<String>,
}
