use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]

/// A Transformation of the UV Set of a Geometry  
/// Ordering S///T///R///V
/// This order minimizes shearing and improves
/// the posibility to fix tiling.
///
/// Combination with a MaterialMapping looks like this:
/// GS///GT///GR///MR///MS///MT///V
///
/// GS .. Matrix of GeometryMapping.Scale///
/// GT .. Matrix of GeometryMapping.Translation///
/// GR .. Matrix of GeometryMapping.Rotation
///
/// MR .. Matrix of TextureMapping.Rotation
/// MS .. Matrix of TextureMapping.Scale///
/// MT .. Matrix of TextureMapping.Translation///
///
/// V .. (UV)-Vector to be transformed
///
/// Rotation is clockwise in degrees
pub struct GeometryMapping {
    pub translation_s: f64,

    pub translation_t: f64,

    pub rotation: f64,

    #[serde(default = "default_scale")]
    ///////
    /// default value = 1
    ////
    pub scale_s: f64,

    #[serde(default = "default_scale")]
    ///////
    /// default value = 1
    ////
    pub scale_t: f64,
}

fn default_scale() -> f64 {
    1.0
}
