use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::Vector3;

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// A simple camera definition.
/// Up vector is per default in positive y direction.
/// FOV / Dollying depends on viewer.
pub struct Camera {
    /// The position of the target point, a.k.a. look-at point.
    pub look_at: Vector3,

    /// The position of the camera, a.k.a. eye point.
    pub look_from: Vector3,
}
