use schemars::{
    gen::{SchemaGenerator, SchemaSettings},
    schema::RootSchema,
    JsonSchema,
};

fn main() {
    std::fs::create_dir_all("../schema").unwrap();

    std::fs::write(
        "../schema/scene.json",
        &serde_json::to_vec_pretty(&generate_schema::<openconfiguration::Scene>()).unwrap(),
    )
    .unwrap();
}

fn generate_schema<T: ?Sized + JsonSchema>() -> RootSchema {
    let mut settings = SchemaSettings::default();
    settings.option_add_null_type = true;

    let mut generator = SchemaGenerator::from(settings);

    generator.root_schema_for::<T>()
}
