// Copyright (c) 2022 Via Technology Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//! FFI bindings for [cl_platform.h](https://github.com/KhronosGroup/OpenCL-Headers/blob/main/CL/cl_platform.h)

#![allow(non_camel_case_types)]

pub type cl_char = i8;
pub type cl_uchar = u8;
pub type cl_short = i16;
pub type cl_ushort = u16;
pub type cl_int = i32;
pub type cl_uint = u32;
pub type cl_long = i64;
pub type cl_ulong = u64;

pub type cl_half = u16;
pub type cl_float = f32;
pub type cl_double = f64;

pub type cl_GLuint = u32;
pub type cl_GLint = i32;
pub type cl_GLenum = u32;
pub type DXGI_FORMAT = u32;
