# OpenBabel bindings for Rust

This repository is composed of two packages:
- openbabel-sys: FFI to OpenBabel C++ codes.
- openbabel: Rust wrappers for easy usage.

Refer to test cases for how to use.

## Binding Progress
:white_check_mark: OBConversion
:white_check_mark: OBMol 
:white_check_mark: OBFingerprint 
:white_check_mark: OBSmartsPatten 


## References
- Code structure: [libcurl bindings for Rust](https://github.com/alexcrichton/curl-rust)

### OpenBabel 
- Openbabel [documentation](http://openbabel.org/wiki/Main_Page)
- [Substructure Searching](http://openbabel.org/dev-api/group__substructure.shtml)
- [OBSmartsPattern Class Reference](http://openbabel.org/dev-api/classOpenBabel_1_1OBSmartsPattern.shtml)
- [Multilevel Neighborhoods of Atoms (MNA) descriptors](http://openbabel.org/docs/dev/FileFormats/Multilevel_Neighborhoods_of_Atoms_(MNA).html#multilevel-neighborhoods-of-atoms-mna)
