#[test]
fn it_correctly_deserializes_json() {
    let base = include_str!("../fixtures/01-oc-1.3pre-sansibar.json");

    let result = serde_json::from_str::<open_configuration::Scene>(base).unwrap();

    insta::with_settings!(
        {sort_maps => true},
        {
            insta::assert_json_snapshot!(result);
        }
    );
}

#[test]
fn it_correctly_deserializes_json_with_multiple_products() {
    let base = include_str!("../fixtures/02-oc-1.3pre-provita.json");

    let result = serde_json::from_str::<open_configuration::Scene>(base).unwrap();

    insta::with_settings!(
        {sort_maps => true},
        {
            insta::assert_json_snapshot!(result);
        }
    );
}

#[test]
fn it_correctly_deserializes_oc_1_0_json() {
    let base = include_str!("../fixtures/03-oc-1.0.json");

    let result = serde_json::from_str::<open_configuration::Scene>(base).unwrap();

    insta::with_settings!(
        {sort_maps => true},
        {
            insta::assert_json_snapshot!(result);
        }
    );
}

#[test]
fn it_correctly_deserializes_icom_1_3_json() {
    let base = include_str!("../fixtures/04-oc-1.3pre-icom.json");

    let result = serde_json::from_str::<open_configuration::Scene>(base).unwrap();

    insta::with_settings!(
        {sort_maps => true},
        {
            insta::assert_json_snapshot!(result);
        }
    );
}
