use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::{Quaternion, Vector3};

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/// Spatial transformation of an object, relative to it's parent object.
/// All attributes are optional. But, if an attribute exists, all it's
/// attributes must exist, too.
/// The application ordering follows industry standard (X3D, ThreeJS) so first scales then rotates and then positions.
/// This basically allows to scale and rotate an object undisturbed and then move it to its position.
/// Think of a cube.
/// Ordering as Matrices is therefore T///R///S///V
pub struct Transform {
    /// The position of the object, relative to it's parent.
    pub position: Option<Vector3>,

    /// The rotation of the object, relative to it's parent.
    pub rotation: Option<Quaternion>,

    /// The scaling of the object's geometries.
    pub scale: Option<Vector3>,
}
