use std::collections::HashMap;

use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::material::Material;

#[derive(Serialize, Deserialize, Debug, JsonSchema)]
#[serde(rename_all = "camelCase")]
/**
 * An external Material index.
 */
pub struct MaterialIndex {
    /**
     * The optional attribute provides a partial URI to be added to all
     * relative asset uris. A valid base path should normally start with
     * https:// or file://, and end with either a slash or the path sepa-
     * rator character of the operating system.
     */
    pub base_path: Option<String>,

    /**
     * The mandatory attribute provides unique content hashes for assets
     * that are directly referenced in the OC data set. The specific hash
     * algorithm is unspecified. It may be an MD5 hash of the binary
     * content for instance. But low-res assets may use the same hash as
     * the originals, they are derived from. So, the only operation that is
     * legal for hash, is to compare them with an optionally existing one.
     */
    pub hashes: HashMap<String, String>,

    /**
     * The mandatory attribute provides an embedded Material index.
     */
    pub materials: HashMap<String, Material>,
}
