// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock

// This file was autogenerated from Opc.Ua.StatusCodes.csv by tools/schema/gen_status_codes.js
// DO NOT EDIT THIS FILE
#![allow(non_upper_case_globals)]
#![allow(unused_attributes)]

use std::str::FromStr;

// This file contains the machine-generated values of StatusCode. Refer to status_code.rs for the hand implemented
// components.

bitflags! {
    pub struct StatusCode: u32 {
        // The UPPERCASE values are bitflags. The PascalCase values are OPC UA Status codes.

        // Mask for the status code section
        const STATUS_MASK = 0xffff_0000;
        // Mask for the bits section
        const BIT_MASK = 0x0000_ffff;

        // Flag for an error / uncertain code
        const IS_ERROR                = 0x8000_0000;
        const IS_UNCERTAIN            = 0x4000_0000;

        // Historian bits 0:4
        const HISTORICAL_RAW          = 0x0000_0000;
        const HISTORICAL_CALCULATED   = 0x0000_0001;
        const HISTORICAL_INTERPOLATED = 0x0000_0002;
        const HISTORICAL_RESERVED     = 0x0000_0003;
        const HISTORICAL_PARTIAL      = 0x0000_0004;
        const HISTORICAL_EXTRA_DATA   = 0x0000_0008;
        const HISTORICAL_MULTI_VALUE  = 0x0000_0010;
        // Overflow bit 7
        const OVERFLOW                = 0x0000_0080;
        // Limit bits 8:9
        const LIMIT_LOW               = 0x0000_0100;
        const LIMIT_HIGH              = 0x0000_0200;
        const LIMIT_CONSTANT          = 0x0000_0300;
        // Info type bits 10:11
        const LIMIT_DATA_VALUE        = 0x0000_2000;
        // Semantics changed bit 14
        const SEMANTICS_CHANGED       = 0x0000_4000;
        // Semantics changed bit 15
        const STRUCTURE_CHANGED       = 0x0000_8000;

        // Actual status codes follow here
        const Good = 0;
        const GoodSubscriptionTransferred = 0x002D_0000;
        const GoodCompletesAsynchronously = 0x002E_0000;
        const GoodOverload = 0x002F_0000;
        const GoodClamped = 0x0030_0000;
        const GoodLocalOverride = 0x0096_0000;
        const GoodEntryInserted = 0x00A2_0000;
        const GoodEntryReplaced = 0x00A3_0000;
        const GoodNoData = 0x00A5_0000;
        const GoodMoreData = 0x00A6_0000;
        const GoodCommunicationEvent = 0x00A7_0000;
        const GoodShutdownEvent = 0x00A8_0000;
        const GoodCallAgain = 0x00A9_0000;
        const GoodNonCriticalTimeout = 0x00AA_0000;
        const GoodResultsMayBeIncomplete = 0x00BA_0000;
        const GoodDataIgnored = 0x00D9_0000;
        const GoodEdited = 0x00DC_0000;
        const GoodPostActionFailed = 0x00DD_0000;
        const GoodDependentValueChanged = 0x00E0_0000;
        const GoodEdited_DependentValueChanged = 0x0116_0000;
        const GoodEdited_DominantValueChanged = 0x0117_0000;
        const GoodEdited_DominantValueChanged_DependentValueChanged = 0x0118_0000;
        const UncertainReferenceOutOfServer = 0x406C_0000;
        const UncertainNoCommunicationLastUsableValue = 0x408F_0000;
        const UncertainLastUsableValue = 0x4090_0000;
        const UncertainSubstituteValue = 0x4091_0000;
        const UncertainInitialValue = 0x4092_0000;
        const UncertainSensorNotAccurate = 0x4093_0000;
        const UncertainEngineeringUnitsExceeded = 0x4094_0000;
        const UncertainSubNormal = 0x4095_0000;
        const UncertainDataSubNormal = 0x40A4_0000;
        const UncertainReferenceNotDeleted = 0x40BC_0000;
        const UncertainNotAllNodesAvailable = 0x40C0_0000;
        const UncertainDominantValueChanged = 0x40DE_0000;
        const UncertainDependentValueChanged = 0x40E2_0000;
        const BadUnexpectedError = 0x8001_0000;
        const BadInternalError = 0x8002_0000;
        const BadOutOfMemory = 0x8003_0000;
        const BadResourceUnavailable = 0x8004_0000;
        const BadCommunicationError = 0x8005_0000;
        const BadEncodingError = 0x8006_0000;
        const BadDecodingError = 0x8007_0000;
        const BadEncodingLimitsExceeded = 0x8008_0000;
        const BadUnknownResponse = 0x8009_0000;
        const BadTimeout = 0x800A_0000;
        const BadServiceUnsupported = 0x800B_0000;
        const BadShutdown = 0x800C_0000;
        const BadServerNotConnected = 0x800D_0000;
        const BadServerHalted = 0x800E_0000;
        const BadNothingToDo = 0x800F_0000;
        const BadTooManyOperations = 0x8010_0000;
        const BadDataTypeIdUnknown = 0x8011_0000;
        const BadCertificateInvalid = 0x8012_0000;
        const BadSecurityChecksFailed = 0x8013_0000;
        const BadCertificateTimeInvalid = 0x8014_0000;
        const BadCertificateIssuerTimeInvalid = 0x8015_0000;
        const BadCertificateHostNameInvalid = 0x8016_0000;
        const BadCertificateUriInvalid = 0x8017_0000;
        const BadCertificateUseNotAllowed = 0x8018_0000;
        const BadCertificateIssuerUseNotAllowed = 0x8019_0000;
        const BadCertificateUntrusted = 0x801A_0000;
        const BadCertificateRevocationUnknown = 0x801B_0000;
        const BadCertificateIssuerRevocationUnknown = 0x801C_0000;
        const BadCertificateRevoked = 0x801D_0000;
        const BadCertificateIssuerRevoked = 0x801E_0000;
        const BadUserAccessDenied = 0x801F_0000;
        const BadIdentityTokenInvalid = 0x8020_0000;
        const BadIdentityTokenRejected = 0x8021_0000;
        const BadSecureChannelIdInvalid = 0x8022_0000;
        const BadInvalidTimestamp = 0x8023_0000;
        const BadNonceInvalid = 0x8024_0000;
        const BadSessionIdInvalid = 0x8025_0000;
        const BadSessionClosed = 0x8026_0000;
        const BadSessionNotActivated = 0x8027_0000;
        const BadSubscriptionIdInvalid = 0x8028_0000;
        const BadRequestHeaderInvalid = 0x802A_0000;
        const BadTimestampsToReturnInvalid = 0x802B_0000;
        const BadRequestCancelledByClient = 0x802C_0000;
        const BadNoCommunication = 0x8031_0000;
        const BadWaitingForInitialData = 0x8032_0000;
        const BadNodeIdInvalid = 0x8033_0000;
        const BadNodeIdUnknown = 0x8034_0000;
        const BadAttributeIdInvalid = 0x8035_0000;
        const BadIndexRangeInvalid = 0x8036_0000;
        const BadIndexRangeNoData = 0x8037_0000;
        const BadDataEncodingInvalid = 0x8038_0000;
        const BadDataEncodingUnsupported = 0x8039_0000;
        const BadNotReadable = 0x803A_0000;
        const BadNotWritable = 0x803B_0000;
        const BadOutOfRange = 0x803C_0000;
        const BadNotSupported = 0x803D_0000;
        const BadNotFound = 0x803E_0000;
        const BadObjectDeleted = 0x803F_0000;
        const BadNotImplemented = 0x8040_0000;
        const BadMonitoringModeInvalid = 0x8041_0000;
        const BadMonitoredItemIdInvalid = 0x8042_0000;
        const BadMonitoredItemFilterInvalid = 0x8043_0000;
        const BadMonitoredItemFilterUnsupported = 0x8044_0000;
        const BadFilterNotAllowed = 0x8045_0000;
        const BadStructureMissing = 0x8046_0000;
        const BadEventFilterInvalid = 0x8047_0000;
        const BadContentFilterInvalid = 0x8048_0000;
        const BadFilterOperandInvalid = 0x8049_0000;
        const BadContinuationPointInvalid = 0x804A_0000;
        const BadNoContinuationPoints = 0x804B_0000;
        const BadReferenceTypeIdInvalid = 0x804C_0000;
        const BadBrowseDirectionInvalid = 0x804D_0000;
        const BadNodeNotInView = 0x804E_0000;
        const BadServerUriInvalid = 0x804F_0000;
        const BadServerNameMissing = 0x8050_0000;
        const BadDiscoveryUrlMissing = 0x8051_0000;
        const BadSempahoreFileMissing = 0x8052_0000;
        const BadRequestTypeInvalid = 0x8053_0000;
        const BadSecurityModeRejected = 0x8054_0000;
        const BadSecurityPolicyRejected = 0x8055_0000;
        const BadTooManySessions = 0x8056_0000;
        const BadUserSignatureInvalid = 0x8057_0000;
        const BadApplicationSignatureInvalid = 0x8058_0000;
        const BadNoValidCertificates = 0x8059_0000;
        const BadRequestCancelledByRequest = 0x805A_0000;
        const BadParentNodeIdInvalid = 0x805B_0000;
        const BadReferenceNotAllowed = 0x805C_0000;
        const BadNodeIdRejected = 0x805D_0000;
        const BadNodeIdExists = 0x805E_0000;
        const BadNodeClassInvalid = 0x805F_0000;
        const BadBrowseNameInvalid = 0x8060_0000;
        const BadBrowseNameDuplicated = 0x8061_0000;
        const BadNodeAttributesInvalid = 0x8062_0000;
        const BadTypeDefinitionInvalid = 0x8063_0000;
        const BadSourceNodeIdInvalid = 0x8064_0000;
        const BadTargetNodeIdInvalid = 0x8065_0000;
        const BadDuplicateReferenceNotAllowed = 0x8066_0000;
        const BadInvalidSelfReference = 0x8067_0000;
        const BadReferenceLocalOnly = 0x8068_0000;
        const BadNoDeleteRights = 0x8069_0000;
        const BadServerIndexInvalid = 0x806A_0000;
        const BadViewIdUnknown = 0x806B_0000;
        const BadTooManyMatches = 0x806D_0000;
        const BadQueryTooComplex = 0x806E_0000;
        const BadNoMatch = 0x806F_0000;
        const BadMaxAgeInvalid = 0x8070_0000;
        const BadHistoryOperationInvalid = 0x8071_0000;
        const BadHistoryOperationUnsupported = 0x8072_0000;
        const BadWriteNotSupported = 0x8073_0000;
        const BadTypeMismatch = 0x8074_0000;
        const BadMethodInvalid = 0x8075_0000;
        const BadArgumentsMissing = 0x8076_0000;
        const BadTooManySubscriptions = 0x8077_0000;
        const BadTooManyPublishRequests = 0x8078_0000;
        const BadNoSubscription = 0x8079_0000;
        const BadSequenceNumberUnknown = 0x807A_0000;
        const BadMessageNotAvailable = 0x807B_0000;
        const BadInsufficientClientProfile = 0x807C_0000;
        const BadTcpServerTooBusy = 0x807D_0000;
        const BadTcpMessageTypeInvalid = 0x807E_0000;
        const BadTcpSecureChannelUnknown = 0x807F_0000;
        const BadTcpMessageTooLarge = 0x8080_0000;
        const BadTcpNotEnoughResources = 0x8081_0000;
        const BadTcpInternalError = 0x8082_0000;
        const BadTcpEndpointUrlInvalid = 0x8083_0000;
        const BadRequestInterrupted = 0x8084_0000;
        const BadRequestTimeout = 0x8085_0000;
        const BadSecureChannelClosed = 0x8086_0000;
        const BadSecureChannelTokenUnknown = 0x8087_0000;
        const BadSequenceNumberInvalid = 0x8088_0000;
        const BadConfigurationError = 0x8089_0000;
        const BadNotConnected = 0x808A_0000;
        const BadDeviceFailure = 0x808B_0000;
        const BadSensorFailure = 0x808C_0000;
        const BadOutOfService = 0x808D_0000;
        const BadDeadbandFilterInvalid = 0x808E_0000;
        const BadRefreshInProgress = 0x8097_0000;
        const BadConditionAlreadyDisabled = 0x8098_0000;
        const BadConditionDisabled = 0x8099_0000;
        const BadEventIdUnknown = 0x809A_0000;
        const BadNoData = 0x809B_0000;
        const BadDataLost = 0x809D_0000;
        const BadDataUnavailable = 0x809E_0000;
        const BadEntryExists = 0x809F_0000;
        const BadNoEntryExists = 0x80A0_0000;
        const BadTimestampNotSupported = 0x80A1_0000;
        const BadInvalidArgument = 0x80AB_0000;
        const BadConnectionRejected = 0x80AC_0000;
        const BadDisconnect = 0x80AD_0000;
        const BadConnectionClosed = 0x80AE_0000;
        const BadInvalidState = 0x80AF_0000;
        const BadEndOfStream = 0x80B0_0000;
        const BadNoDataAvailable = 0x80B1_0000;
        const BadWaitingForResponse = 0x80B2_0000;
        const BadOperationAbandoned = 0x80B3_0000;
        const BadExpectedStreamToBlock = 0x80B4_0000;
        const BadWouldBlock = 0x80B5_0000;
        const BadSyntaxError = 0x80B6_0000;
        const BadMaxConnectionsReached = 0x80B7_0000;
        const BadRequestTooLarge = 0x80B8_0000;
        const BadResponseTooLarge = 0x80B9_0000;
        const BadEventNotAcknowledgeable = 0x80BB_0000;
        const BadInvalidTimestampArgument = 0x80BD_0000;
        const BadProtocolVersionUnsupported = 0x80BE_0000;
        const BadStateNotActive = 0x80BF_0000;
        const BadFilterOperatorInvalid = 0x80C1_0000;
        const BadFilterOperatorUnsupported = 0x80C2_0000;
        const BadFilterOperandCountMismatch = 0x80C3_0000;
        const BadFilterElementInvalid = 0x80C4_0000;
        const BadFilterLiteralInvalid = 0x80C5_0000;
        const BadIdentityChangeNotSupported = 0x80C6_0000;
        const BadNotTypeDefinition = 0x80C8_0000;
        const BadViewTimestampInvalid = 0x80C9_0000;
        const BadViewParameterMismatch = 0x80CA_0000;
        const BadViewVersionInvalid = 0x80CB_0000;
        const BadConditionAlreadyEnabled = 0x80CC_0000;
        const BadDialogNotActive = 0x80CD_0000;
        const BadDialogResponseInvalid = 0x80CE_0000;
        const BadConditionBranchAlreadyAcked = 0x80CF_0000;
        const BadConditionBranchAlreadyConfirmed = 0x80D0_0000;
        const BadConditionAlreadyShelved = 0x80D1_0000;
        const BadConditionNotShelved = 0x80D2_0000;
        const BadShelvingTimeOutOfRange = 0x80D3_0000;
        const BadAggregateListMismatch = 0x80D4_0000;
        const BadAggregateNotSupported = 0x80D5_0000;
        const BadAggregateInvalidInputs = 0x80D6_0000;
        const BadBoundNotFound = 0x80D7_0000;
        const BadBoundNotSupported = 0x80D8_0000;
        const BadAggregateConfigurationRejected = 0x80DA_0000;
        const BadTooManyMonitoredItems = 0x80DB_0000;
        const BadDominantValueChanged = 0x80E1_0000;
        const BadDependentValueChanged = 0x80E3_0000;
        const BadRequestNotAllowed = 0x80E4_0000;
        const BadTooManyArguments = 0x80E5_0000;
        const BadSecurityModeInsufficient = 0x80E6_0000;
        const BadCertificateChainIncomplete = 0x810D_0000;
        const BadLicenseExpired = 0x810E_0000;
        const BadLicenseLimitsExceeded = 0x810F_0000;
        const BadLicenseNotAvailable = 0x8110_0000;
        const BadNotExecutable = 0x8111_0000;
        const BadNumericOverflow = 0x8112_0000;
        const BadRequestNotComplete = 0x8113_0000;
        const BadCertificatePolicyCheckFailed = 0x8114_0000;
        const BadAlreadyExists = 0x8115_0000;
        const BadEdited_OutOfRange = 0x8119_0000;
        const BadInitialValue_OutOfRange = 0x811A_0000;
        const BadOutOfRange_DominantValueChanged = 0x811B_0000;
        const BadEdited_OutOfRange_DominantValueChanged = 0x811C_0000;
        const BadOutOfRange_DominantValueChanged_DependentValueChanged = 0x811D_0000;
        const BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged = 0x811E_0000;
    }
}

impl StatusCode {
    /// Returns the descriptive name for the status code, e.g. to put a meaningful code in a log file
    pub fn name(self) -> &'static str {
        match self.status() {
            StatusCode::Good => "Good",
            StatusCode::GoodSubscriptionTransferred => "GoodSubscriptionTransferred",
            StatusCode::GoodCompletesAsynchronously => "GoodCompletesAsynchronously",
            StatusCode::GoodOverload => "GoodOverload",
            StatusCode::GoodClamped => "GoodClamped",
            StatusCode::GoodLocalOverride => "GoodLocalOverride",
            StatusCode::GoodEntryInserted => "GoodEntryInserted",
            StatusCode::GoodEntryReplaced => "GoodEntryReplaced",
            StatusCode::GoodNoData => "GoodNoData",
            StatusCode::GoodMoreData => "GoodMoreData",
            StatusCode::GoodCommunicationEvent => "GoodCommunicationEvent",
            StatusCode::GoodShutdownEvent => "GoodShutdownEvent",
            StatusCode::GoodCallAgain => "GoodCallAgain",
            StatusCode::GoodNonCriticalTimeout => "GoodNonCriticalTimeout",
            StatusCode::GoodResultsMayBeIncomplete => "GoodResultsMayBeIncomplete",
            StatusCode::GoodDataIgnored => "GoodDataIgnored",
            StatusCode::GoodEdited => "GoodEdited",
            StatusCode::GoodPostActionFailed => "GoodPostActionFailed",
            StatusCode::GoodDependentValueChanged => "GoodDependentValueChanged",
            StatusCode::GoodEdited_DependentValueChanged => "GoodEdited_DependentValueChanged",
            StatusCode::GoodEdited_DominantValueChanged => "GoodEdited_DominantValueChanged",
            StatusCode::GoodEdited_DominantValueChanged_DependentValueChanged => {
                "GoodEdited_DominantValueChanged_DependentValueChanged"
            }
            StatusCode::UncertainReferenceOutOfServer => "UncertainReferenceOutOfServer",
            StatusCode::UncertainNoCommunicationLastUsableValue => {
                "UncertainNoCommunicationLastUsableValue"
            }
            StatusCode::UncertainLastUsableValue => "UncertainLastUsableValue",
            StatusCode::UncertainSubstituteValue => "UncertainSubstituteValue",
            StatusCode::UncertainInitialValue => "UncertainInitialValue",
            StatusCode::UncertainSensorNotAccurate => "UncertainSensorNotAccurate",
            StatusCode::UncertainEngineeringUnitsExceeded => "UncertainEngineeringUnitsExceeded",
            StatusCode::UncertainSubNormal => "UncertainSubNormal",
            StatusCode::UncertainDataSubNormal => "UncertainDataSubNormal",
            StatusCode::UncertainReferenceNotDeleted => "UncertainReferenceNotDeleted",
            StatusCode::UncertainNotAllNodesAvailable => "UncertainNotAllNodesAvailable",
            StatusCode::UncertainDominantValueChanged => "UncertainDominantValueChanged",
            StatusCode::UncertainDependentValueChanged => "UncertainDependentValueChanged",
            StatusCode::BadUnexpectedError => "BadUnexpectedError",
            StatusCode::BadInternalError => "BadInternalError",
            StatusCode::BadOutOfMemory => "BadOutOfMemory",
            StatusCode::BadResourceUnavailable => "BadResourceUnavailable",
            StatusCode::BadCommunicationError => "BadCommunicationError",
            StatusCode::BadEncodingError => "BadEncodingError",
            StatusCode::BadDecodingError => "BadDecodingError",
            StatusCode::BadEncodingLimitsExceeded => "BadEncodingLimitsExceeded",
            StatusCode::BadUnknownResponse => "BadUnknownResponse",
            StatusCode::BadTimeout => "BadTimeout",
            StatusCode::BadServiceUnsupported => "BadServiceUnsupported",
            StatusCode::BadShutdown => "BadShutdown",
            StatusCode::BadServerNotConnected => "BadServerNotConnected",
            StatusCode::BadServerHalted => "BadServerHalted",
            StatusCode::BadNothingToDo => "BadNothingToDo",
            StatusCode::BadTooManyOperations => "BadTooManyOperations",
            StatusCode::BadDataTypeIdUnknown => "BadDataTypeIdUnknown",
            StatusCode::BadCertificateInvalid => "BadCertificateInvalid",
            StatusCode::BadSecurityChecksFailed => "BadSecurityChecksFailed",
            StatusCode::BadCertificateTimeInvalid => "BadCertificateTimeInvalid",
            StatusCode::BadCertificateIssuerTimeInvalid => "BadCertificateIssuerTimeInvalid",
            StatusCode::BadCertificateHostNameInvalid => "BadCertificateHostNameInvalid",
            StatusCode::BadCertificateUriInvalid => "BadCertificateUriInvalid",
            StatusCode::BadCertificateUseNotAllowed => "BadCertificateUseNotAllowed",
            StatusCode::BadCertificateIssuerUseNotAllowed => "BadCertificateIssuerUseNotAllowed",
            StatusCode::BadCertificateUntrusted => "BadCertificateUntrusted",
            StatusCode::BadCertificateRevocationUnknown => "BadCertificateRevocationUnknown",
            StatusCode::BadCertificateIssuerRevocationUnknown => {
                "BadCertificateIssuerRevocationUnknown"
            }
            StatusCode::BadCertificateRevoked => "BadCertificateRevoked",
            StatusCode::BadCertificateIssuerRevoked => "BadCertificateIssuerRevoked",
            StatusCode::BadUserAccessDenied => "BadUserAccessDenied",
            StatusCode::BadIdentityTokenInvalid => "BadIdentityTokenInvalid",
            StatusCode::BadIdentityTokenRejected => "BadIdentityTokenRejected",
            StatusCode::BadSecureChannelIdInvalid => "BadSecureChannelIdInvalid",
            StatusCode::BadInvalidTimestamp => "BadInvalidTimestamp",
            StatusCode::BadNonceInvalid => "BadNonceInvalid",
            StatusCode::BadSessionIdInvalid => "BadSessionIdInvalid",
            StatusCode::BadSessionClosed => "BadSessionClosed",
            StatusCode::BadSessionNotActivated => "BadSessionNotActivated",
            StatusCode::BadSubscriptionIdInvalid => "BadSubscriptionIdInvalid",
            StatusCode::BadRequestHeaderInvalid => "BadRequestHeaderInvalid",
            StatusCode::BadTimestampsToReturnInvalid => "BadTimestampsToReturnInvalid",
            StatusCode::BadRequestCancelledByClient => "BadRequestCancelledByClient",
            StatusCode::BadNoCommunication => "BadNoCommunication",
            StatusCode::BadWaitingForInitialData => "BadWaitingForInitialData",
            StatusCode::BadNodeIdInvalid => "BadNodeIdInvalid",
            StatusCode::BadNodeIdUnknown => "BadNodeIdUnknown",
            StatusCode::BadAttributeIdInvalid => "BadAttributeIdInvalid",
            StatusCode::BadIndexRangeInvalid => "BadIndexRangeInvalid",
            StatusCode::BadIndexRangeNoData => "BadIndexRangeNoData",
            StatusCode::BadDataEncodingInvalid => "BadDataEncodingInvalid",
            StatusCode::BadDataEncodingUnsupported => "BadDataEncodingUnsupported",
            StatusCode::BadNotReadable => "BadNotReadable",
            StatusCode::BadNotWritable => "BadNotWritable",
            StatusCode::BadOutOfRange => "BadOutOfRange",
            StatusCode::BadNotSupported => "BadNotSupported",
            StatusCode::BadNotFound => "BadNotFound",
            StatusCode::BadObjectDeleted => "BadObjectDeleted",
            StatusCode::BadNotImplemented => "BadNotImplemented",
            StatusCode::BadMonitoringModeInvalid => "BadMonitoringModeInvalid",
            StatusCode::BadMonitoredItemIdInvalid => "BadMonitoredItemIdInvalid",
            StatusCode::BadMonitoredItemFilterInvalid => "BadMonitoredItemFilterInvalid",
            StatusCode::BadMonitoredItemFilterUnsupported => "BadMonitoredItemFilterUnsupported",
            StatusCode::BadFilterNotAllowed => "BadFilterNotAllowed",
            StatusCode::BadStructureMissing => "BadStructureMissing",
            StatusCode::BadEventFilterInvalid => "BadEventFilterInvalid",
            StatusCode::BadContentFilterInvalid => "BadContentFilterInvalid",
            StatusCode::BadFilterOperandInvalid => "BadFilterOperandInvalid",
            StatusCode::BadContinuationPointInvalid => "BadContinuationPointInvalid",
            StatusCode::BadNoContinuationPoints => "BadNoContinuationPoints",
            StatusCode::BadReferenceTypeIdInvalid => "BadReferenceTypeIdInvalid",
            StatusCode::BadBrowseDirectionInvalid => "BadBrowseDirectionInvalid",
            StatusCode::BadNodeNotInView => "BadNodeNotInView",
            StatusCode::BadServerUriInvalid => "BadServerUriInvalid",
            StatusCode::BadServerNameMissing => "BadServerNameMissing",
            StatusCode::BadDiscoveryUrlMissing => "BadDiscoveryUrlMissing",
            StatusCode::BadSempahoreFileMissing => "BadSempahoreFileMissing",
            StatusCode::BadRequestTypeInvalid => "BadRequestTypeInvalid",
            StatusCode::BadSecurityModeRejected => "BadSecurityModeRejected",
            StatusCode::BadSecurityPolicyRejected => "BadSecurityPolicyRejected",
            StatusCode::BadTooManySessions => "BadTooManySessions",
            StatusCode::BadUserSignatureInvalid => "BadUserSignatureInvalid",
            StatusCode::BadApplicationSignatureInvalid => "BadApplicationSignatureInvalid",
            StatusCode::BadNoValidCertificates => "BadNoValidCertificates",
            StatusCode::BadRequestCancelledByRequest => "BadRequestCancelledByRequest",
            StatusCode::BadParentNodeIdInvalid => "BadParentNodeIdInvalid",
            StatusCode::BadReferenceNotAllowed => "BadReferenceNotAllowed",
            StatusCode::BadNodeIdRejected => "BadNodeIdRejected",
            StatusCode::BadNodeIdExists => "BadNodeIdExists",
            StatusCode::BadNodeClassInvalid => "BadNodeClassInvalid",
            StatusCode::BadBrowseNameInvalid => "BadBrowseNameInvalid",
            StatusCode::BadBrowseNameDuplicated => "BadBrowseNameDuplicated",
            StatusCode::BadNodeAttributesInvalid => "BadNodeAttributesInvalid",
            StatusCode::BadTypeDefinitionInvalid => "BadTypeDefinitionInvalid",
            StatusCode::BadSourceNodeIdInvalid => "BadSourceNodeIdInvalid",
            StatusCode::BadTargetNodeIdInvalid => "BadTargetNodeIdInvalid",
            StatusCode::BadDuplicateReferenceNotAllowed => "BadDuplicateReferenceNotAllowed",
            StatusCode::BadInvalidSelfReference => "BadInvalidSelfReference",
            StatusCode::BadReferenceLocalOnly => "BadReferenceLocalOnly",
            StatusCode::BadNoDeleteRights => "BadNoDeleteRights",
            StatusCode::BadServerIndexInvalid => "BadServerIndexInvalid",
            StatusCode::BadViewIdUnknown => "BadViewIdUnknown",
            StatusCode::BadTooManyMatches => "BadTooManyMatches",
            StatusCode::BadQueryTooComplex => "BadQueryTooComplex",
            StatusCode::BadNoMatch => "BadNoMatch",
            StatusCode::BadMaxAgeInvalid => "BadMaxAgeInvalid",
            StatusCode::BadHistoryOperationInvalid => "BadHistoryOperationInvalid",
            StatusCode::BadHistoryOperationUnsupported => "BadHistoryOperationUnsupported",
            StatusCode::BadWriteNotSupported => "BadWriteNotSupported",
            StatusCode::BadTypeMismatch => "BadTypeMismatch",
            StatusCode::BadMethodInvalid => "BadMethodInvalid",
            StatusCode::BadArgumentsMissing => "BadArgumentsMissing",
            StatusCode::BadTooManySubscriptions => "BadTooManySubscriptions",
            StatusCode::BadTooManyPublishRequests => "BadTooManyPublishRequests",
            StatusCode::BadNoSubscription => "BadNoSubscription",
            StatusCode::BadSequenceNumberUnknown => "BadSequenceNumberUnknown",
            StatusCode::BadMessageNotAvailable => "BadMessageNotAvailable",
            StatusCode::BadInsufficientClientProfile => "BadInsufficientClientProfile",
            StatusCode::BadTcpServerTooBusy => "BadTcpServerTooBusy",
            StatusCode::BadTcpMessageTypeInvalid => "BadTcpMessageTypeInvalid",
            StatusCode::BadTcpSecureChannelUnknown => "BadTcpSecureChannelUnknown",
            StatusCode::BadTcpMessageTooLarge => "BadTcpMessageTooLarge",
            StatusCode::BadTcpNotEnoughResources => "BadTcpNotEnoughResources",
            StatusCode::BadTcpInternalError => "BadTcpInternalError",
            StatusCode::BadTcpEndpointUrlInvalid => "BadTcpEndpointUrlInvalid",
            StatusCode::BadRequestInterrupted => "BadRequestInterrupted",
            StatusCode::BadRequestTimeout => "BadRequestTimeout",
            StatusCode::BadSecureChannelClosed => "BadSecureChannelClosed",
            StatusCode::BadSecureChannelTokenUnknown => "BadSecureChannelTokenUnknown",
            StatusCode::BadSequenceNumberInvalid => "BadSequenceNumberInvalid",
            StatusCode::BadConfigurationError => "BadConfigurationError",
            StatusCode::BadNotConnected => "BadNotConnected",
            StatusCode::BadDeviceFailure => "BadDeviceFailure",
            StatusCode::BadSensorFailure => "BadSensorFailure",
            StatusCode::BadOutOfService => "BadOutOfService",
            StatusCode::BadDeadbandFilterInvalid => "BadDeadbandFilterInvalid",
            StatusCode::BadRefreshInProgress => "BadRefreshInProgress",
            StatusCode::BadConditionAlreadyDisabled => "BadConditionAlreadyDisabled",
            StatusCode::BadConditionDisabled => "BadConditionDisabled",
            StatusCode::BadEventIdUnknown => "BadEventIdUnknown",
            StatusCode::BadNoData => "BadNoData",
            StatusCode::BadDataLost => "BadDataLost",
            StatusCode::BadDataUnavailable => "BadDataUnavailable",
            StatusCode::BadEntryExists => "BadEntryExists",
            StatusCode::BadNoEntryExists => "BadNoEntryExists",
            StatusCode::BadTimestampNotSupported => "BadTimestampNotSupported",
            StatusCode::BadInvalidArgument => "BadInvalidArgument",
            StatusCode::BadConnectionRejected => "BadConnectionRejected",
            StatusCode::BadDisconnect => "BadDisconnect",
            StatusCode::BadConnectionClosed => "BadConnectionClosed",
            StatusCode::BadInvalidState => "BadInvalidState",
            StatusCode::BadEndOfStream => "BadEndOfStream",
            StatusCode::BadNoDataAvailable => "BadNoDataAvailable",
            StatusCode::BadWaitingForResponse => "BadWaitingForResponse",
            StatusCode::BadOperationAbandoned => "BadOperationAbandoned",
            StatusCode::BadExpectedStreamToBlock => "BadExpectedStreamToBlock",
            StatusCode::BadWouldBlock => "BadWouldBlock",
            StatusCode::BadSyntaxError => "BadSyntaxError",
            StatusCode::BadMaxConnectionsReached => "BadMaxConnectionsReached",
            StatusCode::BadRequestTooLarge => "BadRequestTooLarge",
            StatusCode::BadResponseTooLarge => "BadResponseTooLarge",
            StatusCode::BadEventNotAcknowledgeable => "BadEventNotAcknowledgeable",
            StatusCode::BadInvalidTimestampArgument => "BadInvalidTimestampArgument",
            StatusCode::BadProtocolVersionUnsupported => "BadProtocolVersionUnsupported",
            StatusCode::BadStateNotActive => "BadStateNotActive",
            StatusCode::BadFilterOperatorInvalid => "BadFilterOperatorInvalid",
            StatusCode::BadFilterOperatorUnsupported => "BadFilterOperatorUnsupported",
            StatusCode::BadFilterOperandCountMismatch => "BadFilterOperandCountMismatch",
            StatusCode::BadFilterElementInvalid => "BadFilterElementInvalid",
            StatusCode::BadFilterLiteralInvalid => "BadFilterLiteralInvalid",
            StatusCode::BadIdentityChangeNotSupported => "BadIdentityChangeNotSupported",
            StatusCode::BadNotTypeDefinition => "BadNotTypeDefinition",
            StatusCode::BadViewTimestampInvalid => "BadViewTimestampInvalid",
            StatusCode::BadViewParameterMismatch => "BadViewParameterMismatch",
            StatusCode::BadViewVersionInvalid => "BadViewVersionInvalid",
            StatusCode::BadConditionAlreadyEnabled => "BadConditionAlreadyEnabled",
            StatusCode::BadDialogNotActive => "BadDialogNotActive",
            StatusCode::BadDialogResponseInvalid => "BadDialogResponseInvalid",
            StatusCode::BadConditionBranchAlreadyAcked => "BadConditionBranchAlreadyAcked",
            StatusCode::BadConditionBranchAlreadyConfirmed => "BadConditionBranchAlreadyConfirmed",
            StatusCode::BadConditionAlreadyShelved => "BadConditionAlreadyShelved",
            StatusCode::BadConditionNotShelved => "BadConditionNotShelved",
            StatusCode::BadShelvingTimeOutOfRange => "BadShelvingTimeOutOfRange",
            StatusCode::BadAggregateListMismatch => "BadAggregateListMismatch",
            StatusCode::BadAggregateNotSupported => "BadAggregateNotSupported",
            StatusCode::BadAggregateInvalidInputs => "BadAggregateInvalidInputs",
            StatusCode::BadBoundNotFound => "BadBoundNotFound",
            StatusCode::BadBoundNotSupported => "BadBoundNotSupported",
            StatusCode::BadAggregateConfigurationRejected => "BadAggregateConfigurationRejected",
            StatusCode::BadTooManyMonitoredItems => "BadTooManyMonitoredItems",
            StatusCode::BadDominantValueChanged => "BadDominantValueChanged",
            StatusCode::BadDependentValueChanged => "BadDependentValueChanged",
            StatusCode::BadRequestNotAllowed => "BadRequestNotAllowed",
            StatusCode::BadTooManyArguments => "BadTooManyArguments",
            StatusCode::BadSecurityModeInsufficient => "BadSecurityModeInsufficient",
            StatusCode::BadCertificateChainIncomplete => "BadCertificateChainIncomplete",
            StatusCode::BadLicenseExpired => "BadLicenseExpired",
            StatusCode::BadLicenseLimitsExceeded => "BadLicenseLimitsExceeded",
            StatusCode::BadLicenseNotAvailable => "BadLicenseNotAvailable",
            StatusCode::BadNotExecutable => "BadNotExecutable",
            StatusCode::BadNumericOverflow => "BadNumericOverflow",
            StatusCode::BadRequestNotComplete => "BadRequestNotComplete",
            StatusCode::BadCertificatePolicyCheckFailed => "BadCertificatePolicyCheckFailed",
            StatusCode::BadAlreadyExists => "BadAlreadyExists",
            StatusCode::BadEdited_OutOfRange => "BadEdited_OutOfRange",
            StatusCode::BadInitialValue_OutOfRange => "BadInitialValue_OutOfRange",
            StatusCode::BadOutOfRange_DominantValueChanged => "BadOutOfRange_DominantValueChanged",
            StatusCode::BadEdited_OutOfRange_DominantValueChanged => {
                "BadEdited_OutOfRange_DominantValueChanged"
            }
            StatusCode::BadOutOfRange_DominantValueChanged_DependentValueChanged => {
                "BadOutOfRange_DominantValueChanged_DependentValueChanged"
            }
            StatusCode::BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged => {
                "BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged"
            }
            _ => "Unrecognized status code",
        }
    }

    /// Returns the descriptive text for the status code
    pub fn description(self) -> &'static str {
        match self.status() {
            StatusCode::Good => "Good",
            StatusCode::GoodSubscriptionTransferred => "The subscription was transferred to another session.",
            StatusCode::GoodCompletesAsynchronously => "The processing will complete asynchronously.",
            StatusCode::GoodOverload => "Sampling has slowed down due to resource limitations.",
            StatusCode::GoodClamped => "The value written was accepted but was clamped.",
            StatusCode::GoodLocalOverride => "The value has been overridden.",
            StatusCode::GoodEntryInserted => "The data or event was successfully inserted into the historical database.",
            StatusCode::GoodEntryReplaced => "The data or event field was successfully replaced in the historical database.",
            StatusCode::GoodNoData => "No data exists for the requested time range or event filter.",
            StatusCode::GoodMoreData => "The data or event field was successfully replaced in the historical database.",
            StatusCode::GoodCommunicationEvent => "The communication layer has raised an event.",
            StatusCode::GoodShutdownEvent => "The system is shutting down.",
            StatusCode::GoodCallAgain => "The operation is not finished and needs to be called again.",
            StatusCode::GoodNonCriticalTimeout => "A non-critical timeout occurred.",
            StatusCode::GoodResultsMayBeIncomplete => "The server should have followed a reference to a node in a remote server but did not. The result set may be incomplete.",
            StatusCode::GoodDataIgnored => "The request specifies fields which are not valid for the EventType or cannot be saved by the historian.",
            StatusCode::GoodEdited => "The value does not come from the real source and has been edited by the server.",
            StatusCode::GoodPostActionFailed => "There was an error in execution of these post-actions.",
            StatusCode::GoodDependentValueChanged => "A dependent value has been changed but the change has not been applied to the device.",
            StatusCode::GoodEdited_DependentValueChanged => "It is delivered with a dominant Variable value when a dependent Variable has changed but the change has not been applied.",
            StatusCode::GoodEdited_DominantValueChanged => "It is delivered with a dependent Variable value when a dominant Variable has changed but the change has not been applied.",
            StatusCode::GoodEdited_DominantValueChanged_DependentValueChanged => "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed but change has not been applied.",
            StatusCode::UncertainReferenceOutOfServer => "One of the references to follow in the relative path references to a node in the address space in another server.",
            StatusCode::UncertainNoCommunicationLastUsableValue => "Communication to the data source has failed. The variable value is the last value that had a good quality.",
            StatusCode::UncertainLastUsableValue => "Whatever was updating this value has stopped doing so.",
            StatusCode::UncertainSubstituteValue => "The value is an operational value that was manually overwritten.",
            StatusCode::UncertainInitialValue => "The value is an initial value for a variable that normally receives its value from another variable.",
            StatusCode::UncertainSensorNotAccurate => "The value is at one of the sensor limits.",
            StatusCode::UncertainEngineeringUnitsExceeded => "The value is outside of the range of values defined for this parameter.",
            StatusCode::UncertainSubNormal => "The value is derived from multiple sources and has less than the required number of Good sources.",
            StatusCode::UncertainDataSubNormal => "The value is derived from multiple values and has less than the required number of Good values.",
            StatusCode::UncertainReferenceNotDeleted => "The server was not able to delete all target references.",
            StatusCode::UncertainNotAllNodesAvailable => "The list of references may not be complete because the underlying system is not available.",
            StatusCode::UncertainDominantValueChanged => "The related EngineeringUnit has been changed but the Variable Value is still provided based on the previous unit.",
            StatusCode::UncertainDependentValueChanged => "A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is uncertain.",
            StatusCode::BadUnexpectedError => "An unexpected error occurred.",
            StatusCode::BadInternalError => "An internal error occurred as a result of a programming or configuration error.",
            StatusCode::BadOutOfMemory => "Not enough memory to complete the operation.",
            StatusCode::BadResourceUnavailable => "An operating system resource is not available.",
            StatusCode::BadCommunicationError => "A low level communication error occurred.",
            StatusCode::BadEncodingError => "Encoding halted because of invalid data in the objects being serialized.",
            StatusCode::BadDecodingError => "Decoding halted because of invalid data in the stream.",
            StatusCode::BadEncodingLimitsExceeded => "The message encoding/decoding limits imposed by the stack have been exceeded.",
            StatusCode::BadUnknownResponse => "An unrecognized response was received from the server.",
            StatusCode::BadTimeout => "The operation timed out.",
            StatusCode::BadServiceUnsupported => "The server does not support the requested service.",
            StatusCode::BadShutdown => "The operation was cancelled because the application is shutting down.",
            StatusCode::BadServerNotConnected => "The operation could not complete because the client is not connected to the server.",
            StatusCode::BadServerHalted => "The server has stopped and cannot process any requests.",
            StatusCode::BadNothingToDo => "There was nothing to do because the client passed a list of operations with no elements.",
            StatusCode::BadTooManyOperations => "The request could not be processed because it specified too many operations.",
            StatusCode::BadDataTypeIdUnknown => "The extension object cannot be (de)serialized because the data type id is not recognized.",
            StatusCode::BadCertificateInvalid => "The certificate provided as a parameter is not valid.",
            StatusCode::BadSecurityChecksFailed => "An error occurred verifying security.",
            StatusCode::BadCertificateTimeInvalid => "The certificate has expired or is not yet valid.",
            StatusCode::BadCertificateIssuerTimeInvalid => "An issuer certificate has expired or is not yet valid.",
            StatusCode::BadCertificateHostNameInvalid => "The HostName used to connect to a server does not match a HostName in the certificate.",
            StatusCode::BadCertificateUriInvalid => "The URI specified in the ApplicationDescription does not match the URI in the certificate.",
            StatusCode::BadCertificateUseNotAllowed => "The certificate may not be used for the requested operation.",
            StatusCode::BadCertificateIssuerUseNotAllowed => "The issuer certificate may not be used for the requested operation.",
            StatusCode::BadCertificateUntrusted => "The certificate is not trusted.",
            StatusCode::BadCertificateRevocationUnknown => "It was not possible to determine if the certificate has been revoked.",
            StatusCode::BadCertificateIssuerRevocationUnknown => "It was not possible to determine if the issuer certificate has been revoked.",
            StatusCode::BadCertificateRevoked => "The certificate has been revoked.",
            StatusCode::BadCertificateIssuerRevoked => "The issuer certificate has been revoked.",
            StatusCode::BadUserAccessDenied => "User does not have permission to perform the requested operation.",
            StatusCode::BadIdentityTokenInvalid => "The user identity token is not valid.",
            StatusCode::BadIdentityTokenRejected => "The user identity token is valid but the server has rejected it.",
            StatusCode::BadSecureChannelIdInvalid => "The specified secure channel is no longer valid.",
            StatusCode::BadInvalidTimestamp => "The timestamp is outside the range allowed by the server.",
            StatusCode::BadNonceInvalid => "The nonce does appear to be not a random value or it is not the correct length.",
            StatusCode::BadSessionIdInvalid => "The session id is not valid.",
            StatusCode::BadSessionClosed => "The session was closed by the client.",
            StatusCode::BadSessionNotActivated => "The session cannot be used because ActivateSession has not been called.",
            StatusCode::BadSubscriptionIdInvalid => "The subscription id is not valid.",
            StatusCode::BadRequestHeaderInvalid => "The header for the request is missing or invalid.",
            StatusCode::BadTimestampsToReturnInvalid => "The timestamps to return parameter is invalid.",
            StatusCode::BadRequestCancelledByClient => "The request was cancelled by the client.",
            StatusCode::BadNoCommunication => "Communication with the data source is defined, but not established, and there is no last known value available.",
            StatusCode::BadWaitingForInitialData => "Waiting for the server to obtain values from the underlying data source.",
            StatusCode::BadNodeIdInvalid => "The syntax of the node id is not valid.",
            StatusCode::BadNodeIdUnknown => "The node id refers to a node that does not exist in the server address space.",
            StatusCode::BadAttributeIdInvalid => "The attribute is not supported for the specified Node.",
            StatusCode::BadIndexRangeInvalid => "The syntax of the index range parameter is invalid.",
            StatusCode::BadIndexRangeNoData => "No data exists within the range of indexes specified.",
            StatusCode::BadDataEncodingInvalid => "The data encoding is invalid.",
            StatusCode::BadDataEncodingUnsupported => "The server does not support the requested data encoding for the node.",
            StatusCode::BadNotReadable => "The access level does not allow reading or subscribing to the Node.",
            StatusCode::BadNotWritable => "The access level does not allow writing to the Node.",
            StatusCode::BadOutOfRange => "The value was out of range.",
            StatusCode::BadNotSupported => "The requested operation is not supported.",
            StatusCode::BadNotFound => "A requested item was not found or a search operation ended without success.",
            StatusCode::BadObjectDeleted => "The object cannot be used because it has been deleted.",
            StatusCode::BadNotImplemented => "Requested operation is not implemented.",
            StatusCode::BadMonitoringModeInvalid => "The monitoring mode is invalid.",
            StatusCode::BadMonitoredItemIdInvalid => "The monitoring item id does not refer to a valid monitored item.",
            StatusCode::BadMonitoredItemFilterInvalid => "The monitored item filter parameter is not valid.",
            StatusCode::BadMonitoredItemFilterUnsupported => "The server does not support the requested monitored item filter.",
            StatusCode::BadFilterNotAllowed => "A monitoring filter cannot be used in combination with the attribute specified.",
            StatusCode::BadStructureMissing => "A mandatory structured parameter was missing or null.",
            StatusCode::BadEventFilterInvalid => "The event filter is not valid.",
            StatusCode::BadContentFilterInvalid => "The content filter is not valid.",
            StatusCode::BadFilterOperandInvalid => "The operand used in a content filter is not valid.",
            StatusCode::BadContinuationPointInvalid => "The continuation point provide is longer valid.",
            StatusCode::BadNoContinuationPoints => "The operation could not be processed because all continuation points have been allocated.",
            StatusCode::BadReferenceTypeIdInvalid => "The reference type id does not refer to a valid reference type node.",
            StatusCode::BadBrowseDirectionInvalid => "The browse direction is not valid.",
            StatusCode::BadNodeNotInView => "The node is not part of the view.",
            StatusCode::BadServerUriInvalid => "The ServerUri is not a valid URI.",
            StatusCode::BadServerNameMissing => "No ServerName was specified.",
            StatusCode::BadDiscoveryUrlMissing => "No DiscoveryUrl was specified.",
            StatusCode::BadSempahoreFileMissing => "The semaphore file specified by the client is not valid.",
            StatusCode::BadRequestTypeInvalid => "The security token request type is not valid.",
            StatusCode::BadSecurityModeRejected => "The security mode does not meet the requirements set by the server.",
            StatusCode::BadSecurityPolicyRejected => "The security policy does not meet the requirements set by the server.",
            StatusCode::BadTooManySessions => "The server has reached its maximum number of sessions.",
            StatusCode::BadUserSignatureInvalid => "The user token signature is missing or invalid.",
            StatusCode::BadApplicationSignatureInvalid => "The signature generated with the client certificate is missing or invalid.",
            StatusCode::BadNoValidCertificates => "The client did not provide at least one software certificate that is valid and meets the profile requirements for the server.",
            StatusCode::BadRequestCancelledByRequest => "The request was cancelled by the client with the Cancel service.",
            StatusCode::BadParentNodeIdInvalid => "The parent node id does not to refer to a valid node.",
            StatusCode::BadReferenceNotAllowed => "The reference could not be created because it violates constraints imposed by the data model.",
            StatusCode::BadNodeIdRejected => "The requested node id was reject because it was either invalid or server does not allow node ids to be specified by the client.",
            StatusCode::BadNodeIdExists => "The requested node id is already used by another node.",
            StatusCode::BadNodeClassInvalid => "The node class is not valid.",
            StatusCode::BadBrowseNameInvalid => "The browse name is invalid.",
            StatusCode::BadBrowseNameDuplicated => "The browse name is not unique among nodes that share the same relationship with the parent.",
            StatusCode::BadNodeAttributesInvalid => "The node attributes are not valid for the node class.",
            StatusCode::BadTypeDefinitionInvalid => "The type definition node id does not reference an appropriate type node.",
            StatusCode::BadSourceNodeIdInvalid => "The source node id does not reference a valid node.",
            StatusCode::BadTargetNodeIdInvalid => "The target node id does not reference a valid node.",
            StatusCode::BadDuplicateReferenceNotAllowed => "The reference type between the nodes is already defined.",
            StatusCode::BadInvalidSelfReference => "The server does not allow this type of self reference on this node.",
            StatusCode::BadReferenceLocalOnly => "The reference type is not valid for a reference to a remote server.",
            StatusCode::BadNoDeleteRights => "The server will not allow the node to be deleted.",
            StatusCode::BadServerIndexInvalid => "The server index is not valid.",
            StatusCode::BadViewIdUnknown => "The view id does not refer to a valid view node.",
            StatusCode::BadTooManyMatches => "The requested operation has too many matches to return.",
            StatusCode::BadQueryTooComplex => "The requested operation requires too many resources in the server.",
            StatusCode::BadNoMatch => "The requested operation has no match to return.",
            StatusCode::BadMaxAgeInvalid => "The max age parameter is invalid.",
            StatusCode::BadHistoryOperationInvalid => "The history details parameter is not valid.",
            StatusCode::BadHistoryOperationUnsupported => "The server does not support the requested operation.",
            StatusCode::BadWriteNotSupported => "The server does not support writing the combination of value, status and timestamps provided.",
            StatusCode::BadTypeMismatch => "The value supplied for the attribute is not of the same type as the attribute's value.",
            StatusCode::BadMethodInvalid => "The method id does not refer to a method for the specified object.",
            StatusCode::BadArgumentsMissing => "The client did not specify all of the input arguments for the method.",
            StatusCode::BadTooManySubscriptions => "The server has reached its maximum number of subscriptions.",
            StatusCode::BadTooManyPublishRequests => "The server has reached the maximum number of queued publish requests.",
            StatusCode::BadNoSubscription => "There is no subscription available for this session.",
            StatusCode::BadSequenceNumberUnknown => "The sequence number is unknown to the server.",
            StatusCode::BadMessageNotAvailable => "The requested notification message is no longer available.",
            StatusCode::BadInsufficientClientProfile => "The client of the current session does not support one or more Profiles that are necessary for the subscription.",
            StatusCode::BadTcpServerTooBusy => "The server cannot process the request because it is too busy.",
            StatusCode::BadTcpMessageTypeInvalid => "The type of the message specified in the header invalid.",
            StatusCode::BadTcpSecureChannelUnknown => "The SecureChannelId and/or TokenId are not currently in use.",
            StatusCode::BadTcpMessageTooLarge => "The size of the message specified in the header is too large.",
            StatusCode::BadTcpNotEnoughResources => "There are not enough resources to process the request.",
            StatusCode::BadTcpInternalError => "An internal error occurred.",
            StatusCode::BadTcpEndpointUrlInvalid => "The server does not recognize the QueryString specified.",
            StatusCode::BadRequestInterrupted => "The request could not be sent because of a network interruption.",
            StatusCode::BadRequestTimeout => "Timeout occurred while processing the request.",
            StatusCode::BadSecureChannelClosed => "The secure channel has been closed.",
            StatusCode::BadSecureChannelTokenUnknown => "The token has expired or is not recognized.",
            StatusCode::BadSequenceNumberInvalid => "The sequence number is not valid.",
            StatusCode::BadConfigurationError => "There is a problem with the configuration that affects the usefulness of the value.",
            StatusCode::BadNotConnected => "The variable should receive its value from another variable, but has never been configured to do so.",
            StatusCode::BadDeviceFailure => "There has been a failure in the device/data source that generates the value that has affected the value.",
            StatusCode::BadSensorFailure => "There has been a failure in the sensor from which the value is derived by the device/data source.",
            StatusCode::BadOutOfService => "The source of the data is not operational.",
            StatusCode::BadDeadbandFilterInvalid => "The deadband filter is not valid.",
            StatusCode::BadRefreshInProgress => "This Condition refresh failed, a Condition refresh operation is already in progress.",
            StatusCode::BadConditionAlreadyDisabled => "This condition has already been disabled.",
            StatusCode::BadConditionDisabled => "Property not available, this condition is disabled.",
            StatusCode::BadEventIdUnknown => "The specified event id is not recognized.",
            StatusCode::BadNoData => "No data exists for the requested time range or event filter.",
            StatusCode::BadDataLost => "Data is missing due to collection started/stopped/lost.",
            StatusCode::BadDataUnavailable => "Expected data is unavailable for the requested time range due to an un-mounted volume, an off-line archive or tape, or similar reason for temporary unavailability.",
            StatusCode::BadEntryExists => "The data or event was not successfully inserted because a matching entry exists.",
            StatusCode::BadNoEntryExists => "The data or event was not successfully updated because no matching entry exists.",
            StatusCode::BadTimestampNotSupported => "The client requested history using a timestamp format the server does not support (i.e requested ServerTimestamp when server only supports SourceTimestamp).",
            StatusCode::BadInvalidArgument => "One or more arguments are invalid.",
            StatusCode::BadConnectionRejected => "Could not establish a network connection to remote server.",
            StatusCode::BadDisconnect => "The server has disconnected from the client.",
            StatusCode::BadConnectionClosed => "The network connection has been closed.",
            StatusCode::BadInvalidState => "The operation cannot be completed because the object is closed, uninitialized or in some other invalid state.",
            StatusCode::BadEndOfStream => "Cannot move beyond end of the stream.",
            StatusCode::BadNoDataAvailable => "No data is currently available for reading from a non-blocking stream.",
            StatusCode::BadWaitingForResponse => "The asynchronous operation is waiting for a response.",
            StatusCode::BadOperationAbandoned => "The asynchronous operation was abandoned by the caller.",
            StatusCode::BadExpectedStreamToBlock => "The stream did not return all data requested (possibly because it is a non-blocking stream).",
            StatusCode::BadWouldBlock => "Non blocking behaviour is required and the operation would block.",
            StatusCode::BadSyntaxError => "A value had an invalid syntax.",
            StatusCode::BadMaxConnectionsReached => "The operation could not be finished because all available connections are in use.",
            StatusCode::BadRequestTooLarge => "The request message size exceeds limits set by the server.",
            StatusCode::BadResponseTooLarge => "The response message size exceeds limits set by the client.",
            StatusCode::BadEventNotAcknowledgeable => "The event cannot be acknowledged.",
            StatusCode::BadInvalidTimestampArgument => "The defined timestamp to return was invalid.",
            StatusCode::BadProtocolVersionUnsupported => "The applications do not have compatible protocol versions.",
            StatusCode::BadStateNotActive => "The sub-state machine is not currently active.",
            StatusCode::BadFilterOperatorInvalid => "An unrecognized operator was provided in a filter.",
            StatusCode::BadFilterOperatorUnsupported => "A valid operator was provided, but the server does not provide support for this filter operator.",
            StatusCode::BadFilterOperandCountMismatch => "The number of operands provided for the filter operator was less then expected for the operand provided.",
            StatusCode::BadFilterElementInvalid => "The referenced element is not a valid element in the content filter.",
            StatusCode::BadFilterLiteralInvalid => "The referenced literal is not a valid value.",
            StatusCode::BadIdentityChangeNotSupported => "The server does not support changing the user identity assigned to the session.",
            StatusCode::BadNotTypeDefinition => "The provided Nodeid was not a type definition nodeid.",
            StatusCode::BadViewTimestampInvalid => "The view timestamp is not available or not supported.",
            StatusCode::BadViewParameterMismatch => "The view parameters are not consistent with each other.",
            StatusCode::BadViewVersionInvalid => "The view version is not available or not supported.",
            StatusCode::BadConditionAlreadyEnabled => "This condition has already been enabled.",
            StatusCode::BadDialogNotActive => "The dialog condition is not active.",
            StatusCode::BadDialogResponseInvalid => "The response is not valid for the dialog.",
            StatusCode::BadConditionBranchAlreadyAcked => "The condition branch has already been acknowledged.",
            StatusCode::BadConditionBranchAlreadyConfirmed => "The condition branch has already been confirmed.",
            StatusCode::BadConditionAlreadyShelved => "The condition has already been shelved.",
            StatusCode::BadConditionNotShelved => "The condition is not currently shelved.",
            StatusCode::BadShelvingTimeOutOfRange => "The shelving time not within an acceptable range.",
            StatusCode::BadAggregateListMismatch => "The requested number of Aggregates does not match the requested number of NodeIds.",
            StatusCode::BadAggregateNotSupported => "The requested Aggregate is not support by the server.",
            StatusCode::BadAggregateInvalidInputs => "The aggregate value could not be derived due to invalid data inputs.",
            StatusCode::BadBoundNotFound => "No data found to provide upper or lower bound value.",
            StatusCode::BadBoundNotSupported => "The server cannot retrieve a bound for the variable.",
            StatusCode::BadAggregateConfigurationRejected => "The aggregate configuration is not valid for specified node.",
            StatusCode::BadTooManyMonitoredItems => "The request could not be processed because there are too many monitored items in the subscription.",
            StatusCode::BadDominantValueChanged => "The related EngineeringUnit has been changed but this change has not been applied to the device. The Variable Value is still dependent on the previous unit but its status is currently Bad.",
            StatusCode::BadDependentValueChanged => "A dependent value has been changed but the change has not been applied to the device. The quality of the dominant variable is Bad.",
            StatusCode::BadRequestNotAllowed => "The request was rejected by the server because it did not meet the criteria set by the server.",
            StatusCode::BadTooManyArguments => "Too many arguments were provided.",
            StatusCode::BadSecurityModeInsufficient => "The operation is not permitted over the current secure channel.",
            StatusCode::BadCertificateChainIncomplete => "The certificate chain is incomplete.",
            StatusCode::BadLicenseExpired => "The server requires a license to operate in general or to perform a service or operation, but existing license is expired.",
            StatusCode::BadLicenseLimitsExceeded => "The server has limits on number of allowed operations / objects, based on installed licenses, and these limits where exceeded.",
            StatusCode::BadLicenseNotAvailable => "The server does not have a license which is required to operate in general or to perform a service or operation.",
            StatusCode::BadNotExecutable => "The executable attribute does not allow the execution of the method.",
            StatusCode::BadNumericOverflow => "The number was not accepted because of a numeric overflow.",
            StatusCode::BadRequestNotComplete => "The request has not been processed by the server yet.",
            StatusCode::BadCertificatePolicyCheckFailed => "The certificate does not meet the requirements of the security policy.",
            StatusCode::BadAlreadyExists => "An equivalent rule already exists.",
            StatusCode::BadEdited_OutOfRange => "It is delivered with a Variable value when Variable has changed but the value is not legal.",
            StatusCode::BadInitialValue_OutOfRange => "It is delivered with a Variable value when a source Variable has changed but the value is not legal.",
            StatusCode::BadOutOfRange_DominantValueChanged => "It is delivered with a dependent Variable value when a dominant Variable has changed and the value is not legal.",
            StatusCode::BadEdited_OutOfRange_DominantValueChanged => "It is delivered with a dependent Variable value when a dominant Variable has changed, the value is not legal and the change has not been applied.",
            StatusCode::BadOutOfRange_DominantValueChanged_DependentValueChanged => "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed and the value is not legal.",
            StatusCode::BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged => "It is delivered with a dependent Variable value when a dominant or dependent Variable has changed, the value is not legal and the change has not been applied.",
            _ => "Unrecognized status code",
        }
    }

    /// Takes an OPC UA status code as a UInt32 and returns the matching StatusCode, assuming there is one
    /// Note that this is lossy since any bits associated with the status code will be ignored.
    pub fn from_u32(code: u32) -> Option<StatusCode> {
        StatusCode::from_bits(code)
    }
}

impl FromStr for StatusCode {
    type Err = ();

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s {
            "Good" => Ok(StatusCode::Good),
            "GoodSubscriptionTransferred" => Ok(StatusCode::GoodSubscriptionTransferred),
            "GoodCompletesAsynchronously" => Ok(StatusCode::GoodCompletesAsynchronously),
            "GoodOverload" => Ok(StatusCode::GoodOverload),
            "GoodClamped" => Ok(StatusCode::GoodClamped),
            "GoodLocalOverride" => Ok(StatusCode::GoodLocalOverride),
            "GoodEntryInserted" => Ok(StatusCode::GoodEntryInserted),
            "GoodEntryReplaced" => Ok(StatusCode::GoodEntryReplaced),
            "GoodNoData" => Ok(StatusCode::GoodNoData),
            "GoodMoreData" => Ok(StatusCode::GoodMoreData),
            "GoodCommunicationEvent" => Ok(StatusCode::GoodCommunicationEvent),
            "GoodShutdownEvent" => Ok(StatusCode::GoodShutdownEvent),
            "GoodCallAgain" => Ok(StatusCode::GoodCallAgain),
            "GoodNonCriticalTimeout" => Ok(StatusCode::GoodNonCriticalTimeout),
            "GoodResultsMayBeIncomplete" => Ok(StatusCode::GoodResultsMayBeIncomplete),
            "GoodDataIgnored" => Ok(StatusCode::GoodDataIgnored),
            "GoodEdited" => Ok(StatusCode::GoodEdited),
            "GoodPostActionFailed" => Ok(StatusCode::GoodPostActionFailed),
            "GoodDependentValueChanged" => Ok(StatusCode::GoodDependentValueChanged),
            "GoodEdited_DependentValueChanged" => Ok(StatusCode::GoodEdited_DependentValueChanged),
            "GoodEdited_DominantValueChanged" => Ok(StatusCode::GoodEdited_DominantValueChanged),
            "GoodEdited_DominantValueChanged_DependentValueChanged" => {
                Ok(StatusCode::GoodEdited_DominantValueChanged_DependentValueChanged)
            }
            "UncertainReferenceOutOfServer" => Ok(StatusCode::UncertainReferenceOutOfServer),
            "UncertainNoCommunicationLastUsableValue" => {
                Ok(StatusCode::UncertainNoCommunicationLastUsableValue)
            }
            "UncertainLastUsableValue" => Ok(StatusCode::UncertainLastUsableValue),
            "UncertainSubstituteValue" => Ok(StatusCode::UncertainSubstituteValue),
            "UncertainInitialValue" => Ok(StatusCode::UncertainInitialValue),
            "UncertainSensorNotAccurate" => Ok(StatusCode::UncertainSensorNotAccurate),
            "UncertainEngineeringUnitsExceeded" => {
                Ok(StatusCode::UncertainEngineeringUnitsExceeded)
            }
            "UncertainSubNormal" => Ok(StatusCode::UncertainSubNormal),
            "UncertainDataSubNormal" => Ok(StatusCode::UncertainDataSubNormal),
            "UncertainReferenceNotDeleted" => Ok(StatusCode::UncertainReferenceNotDeleted),
            "UncertainNotAllNodesAvailable" => Ok(StatusCode::UncertainNotAllNodesAvailable),
            "UncertainDominantValueChanged" => Ok(StatusCode::UncertainDominantValueChanged),
            "UncertainDependentValueChanged" => Ok(StatusCode::UncertainDependentValueChanged),
            "BadUnexpectedError" => Ok(StatusCode::BadUnexpectedError),
            "BadInternalError" => Ok(StatusCode::BadInternalError),
            "BadOutOfMemory" => Ok(StatusCode::BadOutOfMemory),
            "BadResourceUnavailable" => Ok(StatusCode::BadResourceUnavailable),
            "BadCommunicationError" => Ok(StatusCode::BadCommunicationError),
            "BadEncodingError" => Ok(StatusCode::BadEncodingError),
            "BadDecodingError" => Ok(StatusCode::BadDecodingError),
            "BadEncodingLimitsExceeded" => Ok(StatusCode::BadEncodingLimitsExceeded),
            "BadUnknownResponse" => Ok(StatusCode::BadUnknownResponse),
            "BadTimeout" => Ok(StatusCode::BadTimeout),
            "BadServiceUnsupported" => Ok(StatusCode::BadServiceUnsupported),
            "BadShutdown" => Ok(StatusCode::BadShutdown),
            "BadServerNotConnected" => Ok(StatusCode::BadServerNotConnected),
            "BadServerHalted" => Ok(StatusCode::BadServerHalted),
            "BadNothingToDo" => Ok(StatusCode::BadNothingToDo),
            "BadTooManyOperations" => Ok(StatusCode::BadTooManyOperations),
            "BadDataTypeIdUnknown" => Ok(StatusCode::BadDataTypeIdUnknown),
            "BadCertificateInvalid" => Ok(StatusCode::BadCertificateInvalid),
            "BadSecurityChecksFailed" => Ok(StatusCode::BadSecurityChecksFailed),
            "BadCertificateTimeInvalid" => Ok(StatusCode::BadCertificateTimeInvalid),
            "BadCertificateIssuerTimeInvalid" => Ok(StatusCode::BadCertificateIssuerTimeInvalid),
            "BadCertificateHostNameInvalid" => Ok(StatusCode::BadCertificateHostNameInvalid),
            "BadCertificateUriInvalid" => Ok(StatusCode::BadCertificateUriInvalid),
            "BadCertificateUseNotAllowed" => Ok(StatusCode::BadCertificateUseNotAllowed),
            "BadCertificateIssuerUseNotAllowed" => {
                Ok(StatusCode::BadCertificateIssuerUseNotAllowed)
            }
            "BadCertificateUntrusted" => Ok(StatusCode::BadCertificateUntrusted),
            "BadCertificateRevocationUnknown" => Ok(StatusCode::BadCertificateRevocationUnknown),
            "BadCertificateIssuerRevocationUnknown" => {
                Ok(StatusCode::BadCertificateIssuerRevocationUnknown)
            }
            "BadCertificateRevoked" => Ok(StatusCode::BadCertificateRevoked),
            "BadCertificateIssuerRevoked" => Ok(StatusCode::BadCertificateIssuerRevoked),
            "BadUserAccessDenied" => Ok(StatusCode::BadUserAccessDenied),
            "BadIdentityTokenInvalid" => Ok(StatusCode::BadIdentityTokenInvalid),
            "BadIdentityTokenRejected" => Ok(StatusCode::BadIdentityTokenRejected),
            "BadSecureChannelIdInvalid" => Ok(StatusCode::BadSecureChannelIdInvalid),
            "BadInvalidTimestamp" => Ok(StatusCode::BadInvalidTimestamp),
            "BadNonceInvalid" => Ok(StatusCode::BadNonceInvalid),
            "BadSessionIdInvalid" => Ok(StatusCode::BadSessionIdInvalid),
            "BadSessionClosed" => Ok(StatusCode::BadSessionClosed),
            "BadSessionNotActivated" => Ok(StatusCode::BadSessionNotActivated),
            "BadSubscriptionIdInvalid" => Ok(StatusCode::BadSubscriptionIdInvalid),
            "BadRequestHeaderInvalid" => Ok(StatusCode::BadRequestHeaderInvalid),
            "BadTimestampsToReturnInvalid" => Ok(StatusCode::BadTimestampsToReturnInvalid),
            "BadRequestCancelledByClient" => Ok(StatusCode::BadRequestCancelledByClient),
            "BadNoCommunication" => Ok(StatusCode::BadNoCommunication),
            "BadWaitingForInitialData" => Ok(StatusCode::BadWaitingForInitialData),
            "BadNodeIdInvalid" => Ok(StatusCode::BadNodeIdInvalid),
            "BadNodeIdUnknown" => Ok(StatusCode::BadNodeIdUnknown),
            "BadAttributeIdInvalid" => Ok(StatusCode::BadAttributeIdInvalid),
            "BadIndexRangeInvalid" => Ok(StatusCode::BadIndexRangeInvalid),
            "BadIndexRangeNoData" => Ok(StatusCode::BadIndexRangeNoData),
            "BadDataEncodingInvalid" => Ok(StatusCode::BadDataEncodingInvalid),
            "BadDataEncodingUnsupported" => Ok(StatusCode::BadDataEncodingUnsupported),
            "BadNotReadable" => Ok(StatusCode::BadNotReadable),
            "BadNotWritable" => Ok(StatusCode::BadNotWritable),
            "BadOutOfRange" => Ok(StatusCode::BadOutOfRange),
            "BadNotSupported" => Ok(StatusCode::BadNotSupported),
            "BadNotFound" => Ok(StatusCode::BadNotFound),
            "BadObjectDeleted" => Ok(StatusCode::BadObjectDeleted),
            "BadNotImplemented" => Ok(StatusCode::BadNotImplemented),
            "BadMonitoringModeInvalid" => Ok(StatusCode::BadMonitoringModeInvalid),
            "BadMonitoredItemIdInvalid" => Ok(StatusCode::BadMonitoredItemIdInvalid),
            "BadMonitoredItemFilterInvalid" => Ok(StatusCode::BadMonitoredItemFilterInvalid),
            "BadMonitoredItemFilterUnsupported" => {
                Ok(StatusCode::BadMonitoredItemFilterUnsupported)
            }
            "BadFilterNotAllowed" => Ok(StatusCode::BadFilterNotAllowed),
            "BadStructureMissing" => Ok(StatusCode::BadStructureMissing),
            "BadEventFilterInvalid" => Ok(StatusCode::BadEventFilterInvalid),
            "BadContentFilterInvalid" => Ok(StatusCode::BadContentFilterInvalid),
            "BadFilterOperandInvalid" => Ok(StatusCode::BadFilterOperandInvalid),
            "BadContinuationPointInvalid" => Ok(StatusCode::BadContinuationPointInvalid),
            "BadNoContinuationPoints" => Ok(StatusCode::BadNoContinuationPoints),
            "BadReferenceTypeIdInvalid" => Ok(StatusCode::BadReferenceTypeIdInvalid),
            "BadBrowseDirectionInvalid" => Ok(StatusCode::BadBrowseDirectionInvalid),
            "BadNodeNotInView" => Ok(StatusCode::BadNodeNotInView),
            "BadServerUriInvalid" => Ok(StatusCode::BadServerUriInvalid),
            "BadServerNameMissing" => Ok(StatusCode::BadServerNameMissing),
            "BadDiscoveryUrlMissing" => Ok(StatusCode::BadDiscoveryUrlMissing),
            "BadSempahoreFileMissing" => Ok(StatusCode::BadSempahoreFileMissing),
            "BadRequestTypeInvalid" => Ok(StatusCode::BadRequestTypeInvalid),
            "BadSecurityModeRejected" => Ok(StatusCode::BadSecurityModeRejected),
            "BadSecurityPolicyRejected" => Ok(StatusCode::BadSecurityPolicyRejected),
            "BadTooManySessions" => Ok(StatusCode::BadTooManySessions),
            "BadUserSignatureInvalid" => Ok(StatusCode::BadUserSignatureInvalid),
            "BadApplicationSignatureInvalid" => Ok(StatusCode::BadApplicationSignatureInvalid),
            "BadNoValidCertificates" => Ok(StatusCode::BadNoValidCertificates),
            "BadRequestCancelledByRequest" => Ok(StatusCode::BadRequestCancelledByRequest),
            "BadParentNodeIdInvalid" => Ok(StatusCode::BadParentNodeIdInvalid),
            "BadReferenceNotAllowed" => Ok(StatusCode::BadReferenceNotAllowed),
            "BadNodeIdRejected" => Ok(StatusCode::BadNodeIdRejected),
            "BadNodeIdExists" => Ok(StatusCode::BadNodeIdExists),
            "BadNodeClassInvalid" => Ok(StatusCode::BadNodeClassInvalid),
            "BadBrowseNameInvalid" => Ok(StatusCode::BadBrowseNameInvalid),
            "BadBrowseNameDuplicated" => Ok(StatusCode::BadBrowseNameDuplicated),
            "BadNodeAttributesInvalid" => Ok(StatusCode::BadNodeAttributesInvalid),
            "BadTypeDefinitionInvalid" => Ok(StatusCode::BadTypeDefinitionInvalid),
            "BadSourceNodeIdInvalid" => Ok(StatusCode::BadSourceNodeIdInvalid),
            "BadTargetNodeIdInvalid" => Ok(StatusCode::BadTargetNodeIdInvalid),
            "BadDuplicateReferenceNotAllowed" => Ok(StatusCode::BadDuplicateReferenceNotAllowed),
            "BadInvalidSelfReference" => Ok(StatusCode::BadInvalidSelfReference),
            "BadReferenceLocalOnly" => Ok(StatusCode::BadReferenceLocalOnly),
            "BadNoDeleteRights" => Ok(StatusCode::BadNoDeleteRights),
            "BadServerIndexInvalid" => Ok(StatusCode::BadServerIndexInvalid),
            "BadViewIdUnknown" => Ok(StatusCode::BadViewIdUnknown),
            "BadTooManyMatches" => Ok(StatusCode::BadTooManyMatches),
            "BadQueryTooComplex" => Ok(StatusCode::BadQueryTooComplex),
            "BadNoMatch" => Ok(StatusCode::BadNoMatch),
            "BadMaxAgeInvalid" => Ok(StatusCode::BadMaxAgeInvalid),
            "BadHistoryOperationInvalid" => Ok(StatusCode::BadHistoryOperationInvalid),
            "BadHistoryOperationUnsupported" => Ok(StatusCode::BadHistoryOperationUnsupported),
            "BadWriteNotSupported" => Ok(StatusCode::BadWriteNotSupported),
            "BadTypeMismatch" => Ok(StatusCode::BadTypeMismatch),
            "BadMethodInvalid" => Ok(StatusCode::BadMethodInvalid),
            "BadArgumentsMissing" => Ok(StatusCode::BadArgumentsMissing),
            "BadTooManySubscriptions" => Ok(StatusCode::BadTooManySubscriptions),
            "BadTooManyPublishRequests" => Ok(StatusCode::BadTooManyPublishRequests),
            "BadNoSubscription" => Ok(StatusCode::BadNoSubscription),
            "BadSequenceNumberUnknown" => Ok(StatusCode::BadSequenceNumberUnknown),
            "BadMessageNotAvailable" => Ok(StatusCode::BadMessageNotAvailable),
            "BadInsufficientClientProfile" => Ok(StatusCode::BadInsufficientClientProfile),
            "BadTcpServerTooBusy" => Ok(StatusCode::BadTcpServerTooBusy),
            "BadTcpMessageTypeInvalid" => Ok(StatusCode::BadTcpMessageTypeInvalid),
            "BadTcpSecureChannelUnknown" => Ok(StatusCode::BadTcpSecureChannelUnknown),
            "BadTcpMessageTooLarge" => Ok(StatusCode::BadTcpMessageTooLarge),
            "BadTcpNotEnoughResources" => Ok(StatusCode::BadTcpNotEnoughResources),
            "BadTcpInternalError" => Ok(StatusCode::BadTcpInternalError),
            "BadTcpEndpointUrlInvalid" => Ok(StatusCode::BadTcpEndpointUrlInvalid),
            "BadRequestInterrupted" => Ok(StatusCode::BadRequestInterrupted),
            "BadRequestTimeout" => Ok(StatusCode::BadRequestTimeout),
            "BadSecureChannelClosed" => Ok(StatusCode::BadSecureChannelClosed),
            "BadSecureChannelTokenUnknown" => Ok(StatusCode::BadSecureChannelTokenUnknown),
            "BadSequenceNumberInvalid" => Ok(StatusCode::BadSequenceNumberInvalid),
            "BadConfigurationError" => Ok(StatusCode::BadConfigurationError),
            "BadNotConnected" => Ok(StatusCode::BadNotConnected),
            "BadDeviceFailure" => Ok(StatusCode::BadDeviceFailure),
            "BadSensorFailure" => Ok(StatusCode::BadSensorFailure),
            "BadOutOfService" => Ok(StatusCode::BadOutOfService),
            "BadDeadbandFilterInvalid" => Ok(StatusCode::BadDeadbandFilterInvalid),
            "BadRefreshInProgress" => Ok(StatusCode::BadRefreshInProgress),
            "BadConditionAlreadyDisabled" => Ok(StatusCode::BadConditionAlreadyDisabled),
            "BadConditionDisabled" => Ok(StatusCode::BadConditionDisabled),
            "BadEventIdUnknown" => Ok(StatusCode::BadEventIdUnknown),
            "BadNoData" => Ok(StatusCode::BadNoData),
            "BadDataLost" => Ok(StatusCode::BadDataLost),
            "BadDataUnavailable" => Ok(StatusCode::BadDataUnavailable),
            "BadEntryExists" => Ok(StatusCode::BadEntryExists),
            "BadNoEntryExists" => Ok(StatusCode::BadNoEntryExists),
            "BadTimestampNotSupported" => Ok(StatusCode::BadTimestampNotSupported),
            "BadInvalidArgument" => Ok(StatusCode::BadInvalidArgument),
            "BadConnectionRejected" => Ok(StatusCode::BadConnectionRejected),
            "BadDisconnect" => Ok(StatusCode::BadDisconnect),
            "BadConnectionClosed" => Ok(StatusCode::BadConnectionClosed),
            "BadInvalidState" => Ok(StatusCode::BadInvalidState),
            "BadEndOfStream" => Ok(StatusCode::BadEndOfStream),
            "BadNoDataAvailable" => Ok(StatusCode::BadNoDataAvailable),
            "BadWaitingForResponse" => Ok(StatusCode::BadWaitingForResponse),
            "BadOperationAbandoned" => Ok(StatusCode::BadOperationAbandoned),
            "BadExpectedStreamToBlock" => Ok(StatusCode::BadExpectedStreamToBlock),
            "BadWouldBlock" => Ok(StatusCode::BadWouldBlock),
            "BadSyntaxError" => Ok(StatusCode::BadSyntaxError),
            "BadMaxConnectionsReached" => Ok(StatusCode::BadMaxConnectionsReached),
            "BadRequestTooLarge" => Ok(StatusCode::BadRequestTooLarge),
            "BadResponseTooLarge" => Ok(StatusCode::BadResponseTooLarge),
            "BadEventNotAcknowledgeable" => Ok(StatusCode::BadEventNotAcknowledgeable),
            "BadInvalidTimestampArgument" => Ok(StatusCode::BadInvalidTimestampArgument),
            "BadProtocolVersionUnsupported" => Ok(StatusCode::BadProtocolVersionUnsupported),
            "BadStateNotActive" => Ok(StatusCode::BadStateNotActive),
            "BadFilterOperatorInvalid" => Ok(StatusCode::BadFilterOperatorInvalid),
            "BadFilterOperatorUnsupported" => Ok(StatusCode::BadFilterOperatorUnsupported),
            "BadFilterOperandCountMismatch" => Ok(StatusCode::BadFilterOperandCountMismatch),
            "BadFilterElementInvalid" => Ok(StatusCode::BadFilterElementInvalid),
            "BadFilterLiteralInvalid" => Ok(StatusCode::BadFilterLiteralInvalid),
            "BadIdentityChangeNotSupported" => Ok(StatusCode::BadIdentityChangeNotSupported),
            "BadNotTypeDefinition" => Ok(StatusCode::BadNotTypeDefinition),
            "BadViewTimestampInvalid" => Ok(StatusCode::BadViewTimestampInvalid),
            "BadViewParameterMismatch" => Ok(StatusCode::BadViewParameterMismatch),
            "BadViewVersionInvalid" => Ok(StatusCode::BadViewVersionInvalid),
            "BadConditionAlreadyEnabled" => Ok(StatusCode::BadConditionAlreadyEnabled),
            "BadDialogNotActive" => Ok(StatusCode::BadDialogNotActive),
            "BadDialogResponseInvalid" => Ok(StatusCode::BadDialogResponseInvalid),
            "BadConditionBranchAlreadyAcked" => Ok(StatusCode::BadConditionBranchAlreadyAcked),
            "BadConditionBranchAlreadyConfirmed" => {
                Ok(StatusCode::BadConditionBranchAlreadyConfirmed)
            }
            "BadConditionAlreadyShelved" => Ok(StatusCode::BadConditionAlreadyShelved),
            "BadConditionNotShelved" => Ok(StatusCode::BadConditionNotShelved),
            "BadShelvingTimeOutOfRange" => Ok(StatusCode::BadShelvingTimeOutOfRange),
            "BadAggregateListMismatch" => Ok(StatusCode::BadAggregateListMismatch),
            "BadAggregateNotSupported" => Ok(StatusCode::BadAggregateNotSupported),
            "BadAggregateInvalidInputs" => Ok(StatusCode::BadAggregateInvalidInputs),
            "BadBoundNotFound" => Ok(StatusCode::BadBoundNotFound),
            "BadBoundNotSupported" => Ok(StatusCode::BadBoundNotSupported),
            "BadAggregateConfigurationRejected" => {
                Ok(StatusCode::BadAggregateConfigurationRejected)
            }
            "BadTooManyMonitoredItems" => Ok(StatusCode::BadTooManyMonitoredItems),
            "BadDominantValueChanged" => Ok(StatusCode::BadDominantValueChanged),
            "BadDependentValueChanged" => Ok(StatusCode::BadDependentValueChanged),
            "BadRequestNotAllowed" => Ok(StatusCode::BadRequestNotAllowed),
            "BadTooManyArguments" => Ok(StatusCode::BadTooManyArguments),
            "BadSecurityModeInsufficient" => Ok(StatusCode::BadSecurityModeInsufficient),
            "BadCertificateChainIncomplete" => Ok(StatusCode::BadCertificateChainIncomplete),
            "BadLicenseExpired" => Ok(StatusCode::BadLicenseExpired),
            "BadLicenseLimitsExceeded" => Ok(StatusCode::BadLicenseLimitsExceeded),
            "BadLicenseNotAvailable" => Ok(StatusCode::BadLicenseNotAvailable),
            "BadNotExecutable" => Ok(StatusCode::BadNotExecutable),
            "BadNumericOverflow" => Ok(StatusCode::BadNumericOverflow),
            "BadRequestNotComplete" => Ok(StatusCode::BadRequestNotComplete),
            "BadCertificatePolicyCheckFailed" => Ok(StatusCode::BadCertificatePolicyCheckFailed),
            "BadAlreadyExists" => Ok(StatusCode::BadAlreadyExists),
            "BadEdited_OutOfRange" => Ok(StatusCode::BadEdited_OutOfRange),
            "BadInitialValue_OutOfRange" => Ok(StatusCode::BadInitialValue_OutOfRange),
            "BadOutOfRange_DominantValueChanged" => {
                Ok(StatusCode::BadOutOfRange_DominantValueChanged)
            }
            "BadEdited_OutOfRange_DominantValueChanged" => {
                Ok(StatusCode::BadEdited_OutOfRange_DominantValueChanged)
            }
            "BadOutOfRange_DominantValueChanged_DependentValueChanged" => {
                Ok(StatusCode::BadOutOfRange_DominantValueChanged_DependentValueChanged)
            }
            "BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged" => {
                Ok(StatusCode::BadEdited_OutOfRange_DominantValueChanged_DependentValueChanged)
            }
            _ => Err(()),
        }
    }
}
