// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct XVType {
    pub x: f64,
    pub value: f32,
}

impl MessageInfo for XVType {
    fn object_id(&self) -> ObjectId {
        ObjectId::XVType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<XVType> for XVType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.x.byte_len();
        size += self.value.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.x.encode(stream)?;
        size += self.value.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let x = f64::decode(stream, decoding_options)?;
        let value = f32::decode(stream, decoding_options)?;
        Ok(XVType {
            x,
            value,
        })
    }
}
