// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    string::UAString,
    service_types::enums::UserTokenType,
};

#[derive(Debug, Clone, PartialEq)]
pub struct UserTokenPolicy {
    pub policy_id: UAString,
    pub token_type: UserTokenType,
    pub issued_token_type: UAString,
    pub issuer_endpoint_url: UAString,
    pub security_policy_uri: UAString,
}

impl MessageInfo for UserTokenPolicy {
    fn object_id(&self) -> ObjectId {
        ObjectId::UserTokenPolicy_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<UserTokenPolicy> for UserTokenPolicy {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.policy_id.byte_len();
        size += self.token_type.byte_len();
        size += self.issued_token_type.byte_len();
        size += self.issuer_endpoint_url.byte_len();
        size += self.security_policy_uri.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.policy_id.encode(stream)?;
        size += self.token_type.encode(stream)?;
        size += self.issued_token_type.encode(stream)?;
        size += self.issuer_endpoint_url.encode(stream)?;
        size += self.security_policy_uri.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let policy_id = UAString::decode(stream, decoding_options)?;
        let token_type = UserTokenType::decode(stream, decoding_options)?;
        let issued_token_type = UAString::decode(stream, decoding_options)?;
        let issuer_endpoint_url = UAString::decode(stream, decoding_options)?;
        let security_policy_uri = UAString::decode(stream, decoding_options)?;
        Ok(UserTokenPolicy {
            policy_id,
            token_type,
            issued_token_type,
            issuer_endpoint_url,
            security_policy_uri,
        })
    }
}
