// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::enums::DataSetOrderingType,
    service_types::enums::UadpNetworkMessageContentMask,
};

#[derive(Debug, Clone, PartialEq)]
pub struct UadpWriterGroupMessageDataType {
    pub group_version: u32,
    pub data_set_ordering: DataSetOrderingType,
    pub network_message_content_mask: UadpNetworkMessageContentMask,
    pub sampling_offset: f64,
    pub publishing_offset: Option<Vec<f64>>,
}

impl BinaryEncoder<UadpWriterGroupMessageDataType> for UadpWriterGroupMessageDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.group_version.byte_len();
        size += self.data_set_ordering.byte_len();
        size += self.network_message_content_mask.byte_len();
        size += self.sampling_offset.byte_len();
        size += byte_len_array(&self.publishing_offset);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.group_version.encode(stream)?;
        size += self.data_set_ordering.encode(stream)?;
        size += self.network_message_content_mask.encode(stream)?;
        size += self.sampling_offset.encode(stream)?;
        size += write_array(stream, &self.publishing_offset)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let group_version = u32::decode(stream, decoding_options)?;
        let data_set_ordering = DataSetOrderingType::decode(stream, decoding_options)?;
        let network_message_content_mask = UadpNetworkMessageContentMask::decode(stream, decoding_options)?;
        let sampling_offset = f64::decode(stream, decoding_options)?;
        let publishing_offset: Option<Vec<f64>> = read_array(stream, decoding_options)?;
        Ok(UadpWriterGroupMessageDataType {
            group_version,
            data_set_ordering,
            network_message_content_mask,
            sampling_offset,
            publishing_offset,
        })
    }
}
