// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    node_id::NodeId,
    qualified_name::QualifiedName,
    service_types::StructureDefinition,
};

#[derive(Debug, Clone, PartialEq)]
pub struct StructureDescription {
    pub data_type_id: NodeId,
    pub name: QualifiedName,
    pub structure_definition: StructureDefinition,
}

impl BinaryEncoder<StructureDescription> for StructureDescription {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.data_type_id.byte_len();
        size += self.name.byte_len();
        size += self.structure_definition.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.data_type_id.encode(stream)?;
        size += self.name.encode(stream)?;
        size += self.structure_definition.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let data_type_id = NodeId::decode(stream, decoding_options)?;
        let name = QualifiedName::decode(stream, decoding_options)?;
        let structure_definition = StructureDefinition::decode(stream, decoding_options)?;
        Ok(StructureDescription {
            data_type_id,
            name,
            structure_definition,
        })
    }
}
