// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    date_time::DateTime,
    service_types::enums::ServerState,
    localized_text::LocalizedText,
    service_types::BuildInfo,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ServerStatusDataType {
    pub start_time: DateTime,
    pub current_time: DateTime,
    pub state: ServerState,
    pub build_info: BuildInfo,
    pub seconds_till_shutdown: u32,
    pub shutdown_reason: LocalizedText,
}

impl MessageInfo for ServerStatusDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::ServerStatusDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ServerStatusDataType> for ServerStatusDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.start_time.byte_len();
        size += self.current_time.byte_len();
        size += self.state.byte_len();
        size += self.build_info.byte_len();
        size += self.seconds_till_shutdown.byte_len();
        size += self.shutdown_reason.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.start_time.encode(stream)?;
        size += self.current_time.encode(stream)?;
        size += self.state.encode(stream)?;
        size += self.build_info.encode(stream)?;
        size += self.seconds_till_shutdown.encode(stream)?;
        size += self.shutdown_reason.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let start_time = DateTime::decode(stream, decoding_options)?;
        let current_time = DateTime::decode(stream, decoding_options)?;
        let state = ServerState::decode(stream, decoding_options)?;
        let build_info = BuildInfo::decode(stream, decoding_options)?;
        let seconds_till_shutdown = u32::decode(stream, decoding_options)?;
        let shutdown_reason = LocalizedText::decode(stream, decoding_options)?;
        Ok(ServerStatusDataType {
            start_time,
            current_time,
            state,
            build_info,
            seconds_till_shutdown,
            shutdown_reason,
        })
    }
}
