// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    string::UAString,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ServerOnNetwork {
    pub record_id: u32,
    pub server_name: UAString,
    pub discovery_url: UAString,
    pub server_capabilities: Option<Vec<UAString>>,
}

impl MessageInfo for ServerOnNetwork {
    fn object_id(&self) -> ObjectId {
        ObjectId::ServerOnNetwork_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ServerOnNetwork> for ServerOnNetwork {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.record_id.byte_len();
        size += self.server_name.byte_len();
        size += self.discovery_url.byte_len();
        size += byte_len_array(&self.server_capabilities);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.record_id.encode(stream)?;
        size += self.server_name.encode(stream)?;
        size += self.discovery_url.encode(stream)?;
        size += write_array(stream, &self.server_capabilities)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let record_id = u32::decode(stream, decoding_options)?;
        let server_name = UAString::decode(stream, decoding_options)?;
        let discovery_url = UAString::decode(stream, decoding_options)?;
        let server_capabilities: Option<Vec<UAString>> = read_array(stream, decoding_options)?;
        Ok(ServerOnNetwork {
            record_id,
            server_name,
            discovery_url,
            server_capabilities,
        })
    }
}
