// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct SamplingIntervalDiagnosticsDataType {
    pub sampling_interval: f64,
    pub monitored_item_count: u32,
    pub max_monitored_item_count: u32,
    pub disabled_monitored_item_count: u32,
}

impl MessageInfo for SamplingIntervalDiagnosticsDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::SamplingIntervalDiagnosticsDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<SamplingIntervalDiagnosticsDataType> for SamplingIntervalDiagnosticsDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.sampling_interval.byte_len();
        size += self.monitored_item_count.byte_len();
        size += self.max_monitored_item_count.byte_len();
        size += self.disabled_monitored_item_count.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.sampling_interval.encode(stream)?;
        size += self.monitored_item_count.encode(stream)?;
        size += self.max_monitored_item_count.encode(stream)?;
        size += self.disabled_monitored_item_count.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let sampling_interval = f64::decode(stream, decoding_options)?;
        let monitored_item_count = u32::decode(stream, decoding_options)?;
        let max_monitored_item_count = u32::decode(stream, decoding_options)?;
        let disabled_monitored_item_count = u32::decode(stream, decoding_options)?;
        Ok(SamplingIntervalDiagnosticsDataType {
            sampling_interval,
            monitored_item_count,
            max_monitored_item_count,
            disabled_monitored_item_count,
        })
    }
}
