// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    response_header::ResponseHeader,
    node_id::NodeId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct RegisterNodesResponse {
    pub response_header: ResponseHeader,
    pub registered_node_ids: Option<Vec<NodeId>>,
}

impl MessageInfo for RegisterNodesResponse {
    fn object_id(&self) -> ObjectId {
        ObjectId::RegisterNodesResponse_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<RegisterNodesResponse> for RegisterNodesResponse {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.response_header.byte_len();
        size += byte_len_array(&self.registered_node_ids);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.response_header.encode(stream)?;
        size += write_array(stream, &self.registered_node_ids)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let response_header = ResponseHeader::decode(stream, decoding_options)?;
        let registered_node_ids: Option<Vec<NodeId>> = read_array(stream, decoding_options)?;
        Ok(RegisterNodesResponse {
            response_header,
            registered_node_ids,
        })
    }
}
