// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    node_id::NodeId,
    node_id::ExpandedNodeId,
    qualified_name::QualifiedName,
    localized_text::LocalizedText,
    service_types::enums::NodeClass,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ReferenceDescription {
    pub reference_type_id: NodeId,
    pub is_forward: bool,
    pub node_id: ExpandedNodeId,
    pub browse_name: QualifiedName,
    pub display_name: LocalizedText,
    pub node_class: NodeClass,
    pub type_definition: ExpandedNodeId,
}

impl MessageInfo for ReferenceDescription {
    fn object_id(&self) -> ObjectId {
        ObjectId::ReferenceDescription_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ReferenceDescription> for ReferenceDescription {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.reference_type_id.byte_len();
        size += self.is_forward.byte_len();
        size += self.node_id.byte_len();
        size += self.browse_name.byte_len();
        size += self.display_name.byte_len();
        size += self.node_class.byte_len();
        size += self.type_definition.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.reference_type_id.encode(stream)?;
        size += self.is_forward.encode(stream)?;
        size += self.node_id.encode(stream)?;
        size += self.browse_name.encode(stream)?;
        size += self.display_name.encode(stream)?;
        size += self.node_class.encode(stream)?;
        size += self.type_definition.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let reference_type_id = NodeId::decode(stream, decoding_options)?;
        let is_forward = bool::decode(stream, decoding_options)?;
        let node_id = ExpandedNodeId::decode(stream, decoding_options)?;
        let browse_name = QualifiedName::decode(stream, decoding_options)?;
        let display_name = LocalizedText::decode(stream, decoding_options)?;
        let node_class = NodeClass::decode(stream, decoding_options)?;
        let type_definition = ExpandedNodeId::decode(stream, decoding_options)?;
        Ok(ReferenceDescription {
            reference_type_id,
            is_forward,
            node_id,
            browse_name,
            display_name,
            node_class,
            type_definition,
        })
    }
}
