// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    request_header::RequestHeader,
    service_types::enums::TimestampsToReturn,
    service_types::ReadValueId,
};

#[derive(Debug, Clone, PartialEq)]
pub struct ReadRequest {
    pub request_header: RequestHeader,
    pub max_age: f64,
    pub timestamps_to_return: TimestampsToReturn,
    pub nodes_to_read: Option<Vec<ReadValueId>>,
}

impl MessageInfo for ReadRequest {
    fn object_id(&self) -> ObjectId {
        ObjectId::ReadRequest_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<ReadRequest> for ReadRequest {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.request_header.byte_len();
        size += self.max_age.byte_len();
        size += self.timestamps_to_return.byte_len();
        size += byte_len_array(&self.nodes_to_read);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.request_header.encode(stream)?;
        size += self.max_age.encode(stream)?;
        size += self.timestamps_to_return.encode(stream)?;
        size += write_array(stream, &self.nodes_to_read)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let request_header = RequestHeader::decode(stream, decoding_options)?;
        let max_age = f64::decode(stream, decoding_options)?;
        let timestamps_to_return = TimestampsToReturn::decode(stream, decoding_options)?;
        let nodes_to_read: Option<Vec<ReadValueId>> = read_array(stream, decoding_options)?;
        Ok(ReadRequest {
            request_header,
            max_age,
            timestamps_to_return,
            nodes_to_read,
        })
    }
}
