// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    response_header::ResponseHeader,
    byte_string::ByteString,
    service_types::QueryDataSet,
};

#[derive(Debug, Clone, PartialEq)]
pub struct QueryNextResponse {
    pub response_header: ResponseHeader,
    pub query_data_sets: Option<Vec<QueryDataSet>>,
    pub revised_continuation_point: ByteString,
}

impl MessageInfo for QueryNextResponse {
    fn object_id(&self) -> ObjectId {
        ObjectId::QueryNextResponse_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<QueryNextResponse> for QueryNextResponse {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.response_header.byte_len();
        size += byte_len_array(&self.query_data_sets);
        size += self.revised_continuation_point.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.response_header.encode(stream)?;
        size += write_array(stream, &self.query_data_sets)?;
        size += self.revised_continuation_point.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let response_header = ResponseHeader::decode(stream, decoding_options)?;
        let query_data_sets: Option<Vec<QueryDataSet>> = read_array(stream, decoding_options)?;
        let revised_continuation_point = ByteString::decode(stream, decoding_options)?;
        Ok(QueryNextResponse {
            response_header,
            query_data_sets,
            revised_continuation_point,
        })
    }
}
