// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    string::UAString,
    service_types::RelativePath,
};

#[derive(Debug, Clone, PartialEq)]
pub struct QueryDataDescription {
    pub relative_path: RelativePath,
    pub attribute_id: u32,
    pub index_range: UAString,
}

impl MessageInfo for QueryDataDescription {
    fn object_id(&self) -> ObjectId {
        ObjectId::QueryDataDescription_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<QueryDataDescription> for QueryDataDescription {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.relative_path.byte_len();
        size += self.attribute_id.byte_len();
        size += self.index_range.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.relative_path.encode(stream)?;
        size += self.attribute_id.encode(stream)?;
        size += self.index_range.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let relative_path = RelativePath::decode(stream, decoding_options)?;
        let attribute_id = u32::decode(stream, decoding_options)?;
        let index_range = UAString::decode(stream, decoding_options)?;
        Ok(QueryDataDescription {
            relative_path,
            attribute_id,
            index_range,
        })
    }
}
