// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    response_header::ResponseHeader,
    status_codes::StatusCode,
    diagnostic_info::DiagnosticInfo,
    service_types::NotificationMessage,
};

#[derive(Debug, Clone, PartialEq)]
pub struct PublishResponse {
    pub response_header: ResponseHeader,
    pub subscription_id: u32,
    pub available_sequence_numbers: Option<Vec<u32>>,
    pub more_notifications: bool,
    pub notification_message: NotificationMessage,
    pub results: Option<Vec<StatusCode>>,
    pub diagnostic_infos: Option<Vec<DiagnosticInfo>>,
}

impl MessageInfo for PublishResponse {
    fn object_id(&self) -> ObjectId {
        ObjectId::PublishResponse_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<PublishResponse> for PublishResponse {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += self.response_header.byte_len();
        size += self.subscription_id.byte_len();
        size += byte_len_array(&self.available_sequence_numbers);
        size += self.more_notifications.byte_len();
        size += self.notification_message.byte_len();
        size += byte_len_array(&self.results);
        size += byte_len_array(&self.diagnostic_infos);
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += self.response_header.encode(stream)?;
        size += self.subscription_id.encode(stream)?;
        size += write_array(stream, &self.available_sequence_numbers)?;
        size += self.more_notifications.encode(stream)?;
        size += self.notification_message.encode(stream)?;
        size += write_array(stream, &self.results)?;
        size += write_array(stream, &self.diagnostic_infos)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let response_header = ResponseHeader::decode(stream, decoding_options)?;
        let subscription_id = u32::decode(stream, decoding_options)?;
        let available_sequence_numbers: Option<Vec<u32>> = read_array(stream, decoding_options)?;
        let more_notifications = bool::decode(stream, decoding_options)?;
        let notification_message = NotificationMessage::decode(stream, decoding_options)?;
        let results: Option<Vec<StatusCode>> = read_array(stream, decoding_options)?;
        let diagnostic_infos: Option<Vec<DiagnosticInfo>> = read_array(stream, decoding_options)?;
        Ok(PublishResponse {
            response_header,
            subscription_id,
            available_sequence_numbers,
            more_notifications,
            notification_message,
            results,
            diagnostic_infos,
        })
    }
}
