// OPCUA for Rust
// SPDX-License-Identifier: MPL-2.0
// Copyright (C) 2017-2022 Adam Lock
//
// This file was autogenerated from Opc.Ua.Types.bsd by tools/schema/gen_types.js
//
// DO NOT EDIT THIS FILE
#![allow(unused_attributes)]
use std::io::{Read, Write};
#[allow(unused_imports)]
use crate::types::{
    encoding::*,
    basic_types::*,
    service_types::impls::MessageInfo,
    node_ids::ObjectId,
    service_types::PublishedDataSetDataType,
    service_types::PubSubConnectionDataType,
};

#[derive(Debug, Clone, PartialEq)]
pub struct PubSubConfigurationDataType {
    pub published_data_sets: Option<Vec<PublishedDataSetDataType>>,
    pub connections: Option<Vec<PubSubConnectionDataType>>,
    pub enabled: bool,
}

impl MessageInfo for PubSubConfigurationDataType {
    fn object_id(&self) -> ObjectId {
        ObjectId::PubSubConfigurationDataType_Encoding_DefaultBinary
    }
}

impl BinaryEncoder<PubSubConfigurationDataType> for PubSubConfigurationDataType {
    fn byte_len(&self) -> usize {
        let mut size = 0;
        size += byte_len_array(&self.published_data_sets);
        size += byte_len_array(&self.connections);
        size += self.enabled.byte_len();
        size
    }

    #[allow(unused_variables)]
    fn encode<S: Write>(&self, stream: &mut S) -> EncodingResult<usize> {
        let mut size = 0;
        size += write_array(stream, &self.published_data_sets)?;
        size += write_array(stream, &self.connections)?;
        size += self.enabled.encode(stream)?;
        Ok(size)
    }

    #[allow(unused_variables)]
    fn decode<S: Read>(stream: &mut S, decoding_options: &DecodingOptions) -> EncodingResult<Self> {
        let published_data_sets: Option<Vec<PublishedDataSetDataType>> = read_array(stream, decoding_options)?;
        let connections: Option<Vec<PubSubConnectionDataType>> = read_array(stream, decoding_options)?;
        let enabled = bool::decode(stream, decoding_options)?;
        Ok(PubSubConfigurationDataType {
            published_data_sets,
            connections,
            enabled,
        })
    }
}
